------------------------------------------------------------------------------------------
-- Threat Frame---------------------------------------------------------------------------
------------------------------------------------------------------------------------------
local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")
local MODNAME = "threat"
local THREAT = SN:NewModule(MODNAME, "AceEvent-3.0")

local unpack = unpack
local wipe = wipe
local select = select
local SPELL_FAILED_NOT_ON_MOUNTED = SPELL_FAILED_NOT_ON_MOUNTED
local SPELL_FAILED_NOT_ON_SHAPESHIFT = SPELL_FAILED_NOT_ON_SHAPESHIFT
local NORMAL_FONT_COLOR = NORMAL_FONT_COLOR
local UnitDetailedThreatSituation = UnitDetailedThreatSituation
local GetSpecializationInfo = GetSpecializationInfo
local GetSpecialization = GetSpecialization
local GetSpellCooldown = GetSpellCooldown
local GetSpellInfo = GetSpellInfo
local SendChatMessage = SendChatMessage

local threatSpells = {
	["ROGUE"] = { 57934, true }, --Tricks
	["HUNTER"] = { 34477, true }, --Misdirection
	["MAGE"] = { 45438, false }, --Ice Block
	["PALADIN"] = { 642, false }, --Divine Shield
	["PRIEST"] = { 586, false }, --Fade
	["SHAMAN"] = { 57994, false }, --Wind Shear
}

local threat

local function getOptions()
	threat = {
		type = "group",
		name = L["Threat"],
		args = {
			enable = {
				type = "toggle",
				name = L["Enable Threat System"],
				order = 0,
				get = function(info)
					return SN.data.profile.threat[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.threat[info[#info]] = value
					if value then
						SN:EnableModule(MODNAME)
					else
						SN:DisableModule(MODNAME)
					end
				end,
			},
			h8 = {
				order = 3,
				type = "header",
				name = "Size",
				hidden = function() return not SN.data.profile.threat.enable end,
			},
			size = {
				type = "range",
				name = L["Size of Threat Icon"],
				hidden = function() return not SN.data.profile.threat.enable end,
				order = 4,
				min = 16, max = 128, step = 4,
				get = function(info)
					return SN.data.profile.threat[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.threat[info[#info]] = value
					F.threat:SetSize(value, value)
				end,
			},
		},
	}
	return threat
end

function THREAT:OnInitialize()
	SN:RegisterModuleOptions(MODNAME, getOptions, L["Threat"])

	F.threat = CreateFrame("Frame", nil, UIParent)
	F.threat:SetPoint(unpack(SN.data.profile.frames.threat))
	F.threat:SetSize(SN.data.profile.threat.width, SN.data.profile.threat.height)
	F.threat:SetClampedToScreen(true)

	F.threat:SetScript("OnEvent", function(self, event, ...)
		THREAT:ThreatEvents(self, event, ...)
	end)
	
	F.threat.icon = F.threat:CreateTexture("$parentIcon", "ARTWORK")
	F.threat.icon:SetPoint("TOPLEFT", 2, -2)
	F.threat.icon:SetPoint("BOTTOMRIGHT", -2, 2)
	F.threat.icon:SetTexCoord(0.1, 0.9, 0.1, 0.9)
	
	local color = NORMAL_FONT_COLOR
	F.threat.value = F.threat:CreateFontString(nil, "ARTWORK")
	F.threat.value:SetFont(LSM:Fetch("font", SN.data.profile.threat.font), SN.data.profile.threat.fontsize, "OUTLINE")
	F.threat.value:SetTextColor(color.r, color.g, color.b)
	F.threat.value:SetText("")
	F.threat.value:SetAllPoints(F.threat)
	F.threat.value:SetJustifyH("CENTER")
	F.threat.value:SetJustifyV("MIDDLE")
	F.threat.name = "Threat Frame"
	F.threat.db = MODNAME
	F.threat.storeMDtar = ""
	
end

function THREAT:OnEnable()
	F.threat:Show()
	F.threat:RegisterEvent("UNIT_THREAT_LIST_UPDATE")
	F.threat:RegisterEvent("PLAYER_REGEN_ENABLED")
	F.threat:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	--F.threat:RegisterEvent("UNIT_THREAT_SITUATION_UPDATE")
	F.threat:RegisterEvent("UNIT_SPELLCAST_SENT")
end

function THREAT:OnDisable()
	F.threat:UnregisterAllEvents()
	F.threat:Hide()
end

function THREAT:Lock()
	if SN.data.profile.threat.enable then
		SN:LockFrame(F.threat)
		F.threat:Show()
	end
end

function THREAT:Unlock()
	if SN.data.profile.threat.enable then
		SN:UnlockFrame(F.threat)
	end
end

function THREAT:Reset()
	local static = SN.DB.profile.frames
	local temp = SN.data.profile.frames
	F.threat:ClearAllPoints()

	F.threat:SetPoint(unpack(static.threat))
	wipe(temp.threat)
end

function THREAT:ApplySettings()
	F.threat:ClearAllPoints()
	F.threat:SetPoint(unpack(SN.data.profile.frames.threat))
	F.threat:SetSize(SN.data.profile.threat.width, SN.data.profile.threat.height)
	F.threat.value:SetFont(LSM:Fetch("font", SN.data.profile.threat.font), SN.data.profile.threat.fontsize, "OUTLINE")
end

function THREAT:ThreatEvents(self, event, ...)
	local threat = threatSpells[SN.playerClass]

	if event == "COMBAT_LOG_EVENT_UNFILTERED" then
		local _, type, _, sourceGUID, sourceName, _, _, destGUID, destName = ...
		local spellId, spellName, _, extraFlag1 = select(12, ...)

		if type == "SPELL_CAST_SUCCESS" then
			if sourceName == SN.playerName then
				--Checking to see if this success was a threat spell
				if threat then
					if spellId == threat[1] then
						if threat[2] == true then								
							SN:Announcer(self, nil, spellId, sourceName, destName, true)
						end
						self.icon:SetTexture("")
						self.icon.display = false
						self.startYell = false
						self.aggro = false
					end
				end
			end
		elseif type == "SPELL_CAST_FAILED" then
			--Checking to see if this success was a threat spell
			if (extraFlag1 == SPELL_FAILED_NOT_ON_MOUNTED) or (extraFlag1 == SPELL_FAILED_NOT_ON_SHAPESHIFT) then
				if threat then
					if spellId == threat[1] then
						if threat[2] == true then
							SN:Announcer(self, nil, spellId, sourceName, self.storeMDtar, false)
						end
					end
				end
			end
		end
	end

	if event == "UNIT_SPELLCAST_SENT" then
	--Store the target name for the misdirect/tricks of the trade since the failed event doesn't have a target arg
		local sourceName, spellId, _, destName = ...
		if sourceName == SN.playerName then
			if threat then
				if spellId == threat[1] then
					if threat[2] == true then
						self.storeMDtar = destName
					end
				end
			end
		end
	end
	if event == "UNIT_THREAT_SITUATION_UPDATE" then
		--SN:Debug(...)
	end
	if event == "UNIT_THREAT_LIST_UPDATE" then
		local enemy = ...
		
		if enemy then
			local groupType = SN:GroupType()
			if groupType > 0 then
				local isTanking, status, scaledPercent, rawPercent = UnitDetailedThreatSituation("player", enemy)
			
				local _, _, _, _, _, role = GetSpecializationInfo(GetSpecialization())

				if role == "TANK" then return end
		
				if rawPercent and rawPercent > 60 then
					self.aggro = true
					if threat and not self.icon.display then
						local start, duration, enabled = GetSpellCooldown(threat[1])
						local name, _, icon = GetSpellInfo(threat[1])
						if start == 0 and enabled == 1 then
							self.icon:SetTexture(icon)
							self.icon.display = true
						elseif not self.startYell then
							local args = { self, enemy }
							SendChatMessage(SN.playerName..L[" pulled aggro on "]..enemy..L[" help me!"], "SAY")
							self.startYell = true
							self.timer = SN:ScheduleRepeatingTimer("WarnSay", 8, args)
						end
					end
				else
					self.icon:SetTexture("")
					self.aggro = false
					self.startYell = false
					self.icon.display = false
				end
			end
		end
	end
	if event == "PLAYER_REGEN_ENABLED" then
		self.icon:SetTexture("")
		self.aggro = false
		self.startYell = false
		self.icon.display = false
	end
end