local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")
local MODNAME = "readycheck"
local RC = SN:NewModule(MODNAME, "AceEvent-3.0", "AceConsole-3.0", "AceTimer-3.0")

local unpack = unpack
local wipe = wipe
local pairs = pairs
local strjoin = strjoin
local tonumber = tonumber
local NORMAL_FONT_COLOR = NORMAL_FONT_COLOR
local SendChatMessage = SendChatMessage
local READY_CHECK_READY_TEXTURE = READY_CHECK_READY_TEXTURE
local READY_CHECK_NOT_READY_TEXTURE = READY_CHECK_NOT_READY_TEXTURE
local READY_CHECK_WAITING_TEXTURE = READY_CHECK_WAITING_TEXTURE
local IsInRaid = IsInRaid
local GetNumGroupMembers = GetNumGroupMembers
local GetRaidRosterInfo = GetRaidRosterInfo
local UnitIsGroupLeader = UnitIsGroupLeader
local UnitIsGroupAssistant = UnitIsGroupAssistant
local UnitName = UnitName


local newRows = { 
	[6] = 6, 
	[11] = 11, 
	[16] = 16, 
	[21] = 21, 
	[26] = 26, 
	[31] = 31, 
	[36] = 36
}

local not_ready = {}

local readycheck

local isReadyCheck

local function getOptions()
	readycheck = {
		type = "group",
		name = L["Ready Check"],
		args = {
			enable = {
				type = "toggle",
				name = L["Enable Ready Check System"],
				order = 0,
				get = function(info)
					return SN.data.profile.readycheck[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.readycheck[info[#info]] = value
					if value then
						SN:EnableModule(MODNAME)
					else
						SN:DisableModule(MODNAME)
					end
				end,
			},
			announce = {
				type = "select",
				name = L["Announce Results to Where?"],
				values = {
					["NONE"] = "None",
					["SELF"] = "Self",
					["RAID"] = "Raid",
					["RAID_WARNING"] = "Raid Warning",
				},
				hidden = function() return not SN.data.profile.readycheck.enable end,
				get = function(info)
					return SN.data.profile.readycheck[info[#info]]
				end,
				set = function(info, value)
					SN:Debug(value)
					SN.data.profile.readycheck[info[#info]] = value
				end,
			},
		},
	}
	return readycheck
end

function RC:OnInitialize()
	SN:RegisterModuleOptions(MODNAME, getOptions, L["Ready Check"])	
	RC:RegisterChatCommand("debug", "Debug")

	--Ready Check Frame
	RC.ReadyCheck = SN:CreateFrame("Ready Check Frame", MODNAME, UIParent)

	SN:CreateBackDrop(RC.ReadyCheck)

	RC.ReadyCheck.text = RC.ReadyCheck:CreateFontString(nil, "ARTWORK")
	RC.ReadyCheck.text:SetFont(M.media.font, 14, "OUTLINE")
	RC.ReadyCheck.text:SetJustifyH("CENTER")
	RC.ReadyCheck.text:SetPoint("TOP", RC.ReadyCheck, "TOP", 0, -5)

	RC.ReadyCheck:Hide()
end

function RC:OnEnable()
	RC:RegisterEvent("READY_CHECK")
	RC:RegisterEvent("READY_CHECK_CONFIRM")
	RC:RegisterEvent("READY_CHECK_FINISHED")
	RC:RegisterEvent("PLAYER_REGEN_DISABLED")

	RC:RegisterChatCommand("rcdebug", "Cmds")
end

function RC:OnDisable()
	RC.ReadyCheck:UnregisterAllEvents()
end

function RC:Lock()
	SN:LockFrame(RC.ReadyCheck)
	SN:CreateBackDrop(RC.ReadyCheck)
	RC.ReadyCheck:Hide()
end

function RC:Unlock()
	SN:UnlockFrame(RC.ReadyCheck)
end

function RC:Reset()
	local static = SN.DB.profile.frames
	local temp = SN.data.profile.frames
	RC.ReadyCheck:ClearAllPoints()

	RC.ReadyCheck:SetPoint(unpack(static.readycheck))
	wipe(temp.readycheck)
end

function RC:ApplySettings()
	RC.ReadyCheck:ClearAllPoints()
	RC.ReadyCheck:SetPoint(unpack(SN.data.profile.frames.readycheck))
end

local readycheck = {}

function RC:READY_CHECK(event, name, dur)
	if IsInRaid() then
		RC:CancelTimer(isReadyCheck)
		isReadyCheck = RC:ScheduleTimer("READY_CHECK_FINISHED", dur + 1)

		for i = 1, GetNumGroupMembers() do
			local rname = GetRaidRosterInfo(i)
			if rname then
				local cachename = rname:gsub("^(.*)%-.*$", "%1")
				readycheck[cachename] = { status = 2, }
			end
		end
		local cachename = name:gsub("^(.*)%-.*$", "%1")
		readycheck[cachename].status = 1
		
		RC:CreateRaidMemberNames(readycheck, RC.ReadyCheck.name)
	end
end

function RC:READY_CHECK_CONFIRM(event, unitID, status)
	
	if not isReadyCheck then return end
	
	if not readycheck[UnitName(unitID)] then
		readycheck[UnitName(unitID)] = { status = 0 }
	end

	if status then
		readycheck[UnitName(unitID)].status = 1
	else
		readycheck[UnitName(unitID)].status = 0
	end
	RC:CreateRaidMemberNames(readycheck, RC.ReadyCheck.name)
end

function RC:READY_CHECK_FINISHED(event, preempted)
	if not isReadyCheck or preempted then return end -- is a dungeon group ready check

	RC:CancelTimer(isReadyCheck)
	isReadyCheck = nil

	local not_ready
	local numNames = 0

	for k, v in pairs(readycheck) do
		if v.status == 0 or v.status == 2 then
			if not not_ready then
				not_ready = k
				numNames = 1
			else
				numNames = numNames + 1
				not_ready = strjoin(", ", not_ready, k)
			end
		end
	end
	local canSpeak = UnitIsGroupLeader("player") or UnitIsGroupAssistant("player")
	if not_ready then
		local message
		if numNames > 1 then
			message = " are not ready"
		else
			message = " is not ready"
		end
		if SN.data.profile.readycheck.announce ~= "NONE" then
			if SN.data.profile.readycheck.announce == "SELF" then				
				SN:Print(not_ready..message)
			elseif SN.data.profile.readycheck.announce == "RAID_WARNING" and not canSpeak then
				SendChatMessage("{star}Serenity Now{star} "..not_ready..message, "RAID")
			else
				SendChatMessage("{star}Serenity Now{star} "..not_ready..message, SN.data.profile.readycheck.announce)
			end
		end
	else
		if SN.data.profile.readycheck.announce ~= "NONE" then
			if SN.data.profile.readycheck.announce == "SELF" then
				SN:Print("Everyone is Ready.")
			elseif SN.data.profile.readycheck.announce == "RAID_WARNING" and not canSpeak then
				SendChatMessage("{star}Serenity Now{star} Everyone is Ready.", "RAID")
			else
				SendChatMessage("{star}Serenity Now{star} Everyone is Ready.", SN.data.profile.readycheck.announce)
			end
		end
	end
	wipe(readycheck)
	RC:PurgeWindow(RC.ReadyCheck)
	RC.ReadyCheck:Hide()
end

function RC:PLAYER_REGEN_DISABLED()
	wipe(readycheck)
	RC:PurgeWindow(RC.ReadyCheck)
	RC.ReadyCheck:Hide()
end

function RC:PurgeWindow(frame)
	frame.text:SetText("")
	for i = 1, #frame do
		frame[i]:Hide()
		frame[i].icon:SetTexture("")
		frame[i].text:SetText("")
	end
end

function RC:CreateRaidMemberNames(table, title)
	local frame = RC.ReadyCheck
	local column = 1
	
	RC:PurgeWindow(frame)

	--That's just too big
	--if SN:tcount(table) > 25 then return end
	local i = 1
	frame.text:SetText(title)
	for k, v in pairs(table) do
		local color = NORMAL_FONT_COLOR
		if not frame[i] then
			frame[i] = CreateFrame("Frame", nil, frame)
		end
		frame[i]:SetSize(100, 14)
		frame[i]:SetParent(frame)
		
		if i == 1 then
			frame[i]:SetPoint("TOPLEFT", frame, "TOPLEFT", 14, -28)
		elseif newRows[i] then
			column = column + 1
			frame[i]:SetPoint("TOPLEFT", frame[i - 5], "TOPRIGHT", 4, 0)
		else
			frame[i]:SetPoint("TOPLEFT", (frame[i - 1]), "TOPLEFT", 0, -14)
		end

		if not frame[i].icon then
			frame[i].icon = frame[i]:CreateTexture(nil, "OVERLAY")
		end
		frame[i].icon:SetSize(14, 14)
		frame[i].icon:SetPoint("TOPLEFT", frame[i], "TOPLEFT")
		if not frame[i].text then
			frame[i].text = frame[i]:CreateFontString(nil, "ARTWORK")
		end
		frame[i].text:SetFont(M.media.font, 14, "OUTLINE")
		frame[i].text:SetAllPoints(frame[i])
		frame[i].text:SetJustifyH("LEFT")
		frame[i].text:SetPoint("TOPLEFT", frame[i], "TOPLEFT", 16, 0)

		frame[i].text:SetTextColor(color.r, color.g, color.b)
		frame[i].text:SetText(k)
		if v.status == 1 then
			frame[i].icon:SetTexture(READY_CHECK_READY_TEXTURE)
		elseif v.status == 0 then
			frame[i].icon:SetTexture(READY_CHECK_NOT_READY_TEXTURE)
		else
			frame[i].icon:SetTexture(READY_CHECK_WAITING_TEXTURE)
		end
		frame[i]:Show()
		i = i + 1		
	end
	local width = (100 * column) + 28
	local relf, parent, relp, x, y = unpack(SN.data.profile.frames[frame.db])
	if column > 2 then
		local x = x + (width / 2)
	end

	frame:SetWidth(width)
	frame:SetHeight((14 * 5) + 42)
	frame:ClearAllPoints()
	--frame:SetPoint("CENTER", UIParent, "CENTER", 0, 150)
	frame:SetPoint(relf, parent, relp, x, y)
	frame:Show()
end

function RC:Cmds(input)
	local v1, v2 = input:match("^(%S*)%s*(.-)$")
	v1 = v1:lower()
	
	if tonumber(v1) then
		v1 = tonumber(v1)
		--SN:Debug(v1)
		for i = 1, v1 do
			local name, _, rankIndex, unitLevel, _, unitZone, _, _, online = GetGuildRosterInfo(i)
			--if unitLevel == 90 then --and online and name ~= SN.playerName then
				readycheck[name] = { status = 2, }
			--end
		end
		RC:CreateRaidMemberNames(readycheck, RC.ReadyCheck.name)
	elseif v1 == "off" then
		RC.ReadyCheck:Hide()
		wipe(readycheck)
	end
end