------------------------------------------------------------------------------------------
--Power Bar Setup-------------------------------------------------------------------------
------------------------------------------------------------------------------------------
local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")
local MODNAME = "powerbar"
local PB = SN:NewModule(MODNAME, "AceEvent-3.0")

local IsAddOnLoaded = IsAddOnLoaded
local UnitPowerType = UnitPowerType
local UnitPower = UnitPower
local UnitPowerMax = UnitPowerMax
local UnitAlternatePowerInfo = UnitAlternatePowerInfo
local HasVehicleActionBar = HasVehicleActionBar
local BEAR_FORM = BEAR_FORM
local CAT_FORM = CAT_FORM
local SPELL_POWER_MANA = SPELL_POWER_MANA
local SPELL_POWER_RAGE = SPELL_POWER_RAGE
local SPELL_POWER_FOCUS = SPELL_POWER_FOCUS
local SPELL_POWER_ENERGY = SPELL_POWER_ENERGY
local SPELL_POWER_RUNIC_POWER = SPELL_POWER_RUNIC_POWER
local SPELL_POWER_ALTERNATE_POWER = SPELL_POWER_ALTERNATE_POWER
local ALTERNATE_POWER_INDEX = ALTERNATE_POWER_INDEX
local GetSpecialization = GetSpecialization
local GetShapeshiftFormID = GetShapeshiftFormID
local UnitHasVehicleUI = UnitHasVehicleUI
local RAID_CLASS_COLORS = RAID_CLASS_COLORS
local GetSpellInfo = GetSpellInfo
local UnitClass = UnitClass
local UnitAura = UnitAura
local unpack = unpack
local select = select
local string = string
local wipe = wipe

local powerbar

local function getOptions()
	powerbar = {
		type = "group",
		name = L["Powerbar"],
		args = {
			enable = {
				order = 0,
				type = "toggle",
				name = L["Enable Powerbar"],
				get = function(info)
					return SN.data.profile.powerbar[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.powerbar[info[#info]] = value
					if value then
						SN:EnableModule(MODNAME)
					else
						SN:DisableModule(MODNAME)
					end
					if (IsAddOnLoaded("ElvUI")) then
						SN:ElvOverride()
					end
				end,
			},
			tickenable = {
				order = 1,
				name = L["Powerbar Ticks Marks"],
				desc = L["Tick marks on the powerbar to represent how much power you need to cast your main spell."],
				hidden = function() return not SN.data.profile.powerbar.enable end,
				type = "toggle",
				get = function()
					return SN.data.profile.powerbar.tickenable
				end,
				set = function(key, value)
					SN.data.profile.powerbar.tickenable = value
					if value then
						F.power.tick:Show()
					else
						F.power.tick:Hide()
					end
				end,
			},
			h10 = {
				order = 2,
				type = "header",
				name = "Dimensions",
				hidden = function() return not SN.data.profile.powerbar.enable end,
			},
			width = {
				type = "range",
				name = L["Width of Powerbar"],
				hidden = function() return not SN.data.profile.powerbar.enable end,
				order = 4,
				min = 50, max = 500, step = 1,
				get = function(info)
					return SN.data.profile.powerbar[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.powerbar[info[#info]] = value
					PB:ApplySettings()
				end,
			},
			height = {
				type = "range",
				name = L["Height of Powerbar"],
				hidden = function() return not SN.data.profile.powerbar.enable end,
				order = 5,
				min = 12, max = 30, step = 1,
				get = function(info)
					return SN.data.profile.powerbar[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.powerbar[info[#info]] = value
					PB:ApplySettings()
				end,
			},
			h11 = {
				order = 6,
				type = "header",
				name = "Font",
				hidden = function() return not SN.data.profile.powerbar.enable end,
			},
			font = {
				type = "select",
				dialogControl = 'LSM30_Font',
				name = L["Font"],
				hidden = function() return not SN.data.profile.powerbar.enable end,
				order = 8,
				values = AceGUIWidgetLSMlists.font,
				get = function(info) return SN.data.profile.powerbar[info[#info]] end,--selectedClass end,
				set = function(info, value)
					SN.data.profile.powerbar[info[#info]] = value
					PB:ApplySettings()
				end,
			},
			fontsize = {
				type = "range",
				name = L["Font Size of Powerbar"],
				hidden = function() return not SN.data.profile.powerbar.enable end,
				order = 9,
				min = 10, max = 24, step = 1,
				get = function(info)
					return SN.data.profile.powerbar[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.powerbar[info[#info]] = value
					PB:ApplySettings()
				end,
			},
			h12 = {
				order = 10,
				type = "header",
				name = "Texture",
				hidden = function() return not SN.data.profile.powerbar.enable end,
			},
			texture = {
				type = "select",
				dialogControl = 'LSM30_Statusbar',
				name = L["Texture"],
				hidden = function() return not SN.data.profile.powerbar.enable end,
				order = 12,
				values = AceGUIWidgetLSMlists.statusbar,
				get = function(info) return SN.data.profile.powerbar[info[#info]] end,
				set = function(info, value)
					SN.data.profile.powerbar[info[#info]] = value
					PB:ApplySettings()
				end,
			},
		},
	}
	return powerbar
end

function PB:OnInitialize()
	SN:RegisterModuleOptions(MODNAME, getOptions, L["Power Bar"])

	--The powerbar mover frame
	F.powermover = SN:CreateFrame("Power Bar", MODNAME, UIParent)

	--The powerbar statusbar holder
	F.container = CreateFrame("Frame", nil, F.powermover)
	F.container:SetPoint("CENTER", F.powermover)
	F.container:SetSize(SN.data.profile.powerbar.width, SN.data.profile.powerbar.height)

	SN:CreateBackDrop(F.container)

	--The powerbar statusbar
	F.power = CreateFrame("StatusBar", nil, F.container)
	F.power:SetPoint("LEFT", F.container, 1, 0)

	local powerType = UnitPowerType("player")

	if powerType > 5 then
		powerType = 5
	else
		powerType = powerType + 1
	end
	
	F.power:SetSize(SN.data.profile.powerbar.width - 2, SN.data.profile.powerbar.height - 2)
	
	F.power:SetStatusBarTexture(LSM:Fetch("statusbar", SN.data.profile.powerbar.texture))
	F.power:SetStatusBarColor(unpack(M.power[powerType]))
	local min = UnitPower("player")
	local max = UnitPowerMax("player")
	F.power:SetMinMaxValues(0, max)	
	F.power:SetValue(min)

	F.power:SetScript("OnEvent", function(self, event, ...)
		PB:PowerbarEvents(self, event, ...)
	end)
	
	local class, classFileName, classID = UnitClass("player")
	local colortmp = RAID_CLASS_COLORS[classFileName]
	local color = { colortmp.r, colortmp.g, colortmp.b }
	
	--The powerbar statusbar text
	F.power.value = F.power:CreateFontString(nil, "OVERLAY")
	F.power.value:SetPoint("CENTER", F.power)
	F.power.value:SetFont(LSM:Fetch("font", SN.data.profile.powerbar.font), SN.data.profile.powerbar.fontsize, "OUTLINE")
	F.power.value:SetJustifyH("CENTER")
	F.power.value:SetShadowOffset(1, -1)
	F.power.value:SetTextColor(unpack(color))
	if max > 150 then
		F.power.value:SetText(string.format("%s / %s",  PB:ShortValue(min), PB:ShortValue(max)))
	else
		F.power.value:SetText(min)
	end

	F.power.tick = CreateFrame("Frame", nil, F.power)
	F.power.tick:SetSize(10, F.power:GetHeight() * 1.6)
	F.power.tick.tex = F.power.tick:CreateTexture(nil, "OVERLAY")
	F.power.tick.tex:SetAllPoints(F.power.tick)
	F.power.tick.tex:SetTexture("Interface\\CastingBar\\UI-CastingBar-Spark")	
	F.power.tick.tex:SetBlendMode("ADD")
	F.power.tick:SetAlpha(1)
	F.power.tick:Hide()

	F.container:Hide()
end

function PB:OnEnable()
	F.container:Show()
	F.power:RegisterEvent("PLAYER_ENTERING_WORLD")
	F.power:RegisterEvent("UNIT_POWER_FREQUENT")
	F.power:RegisterEvent("UNIT_POWER")
	F.power:RegisterEvent("UNIT_MAXPOWER")
	F.power:RegisterEvent("UNIT_DISPLAYPOWER")
	F.power:RegisterEvent("UNIT_POWER_BAR_HIDE")
	F.power:RegisterEvent("UNIT_POWER_BAR_SHOW")
	F.power:RegisterEvent("PLAYER_LEVEL_UP")
	F.power:RegisterUnitEvent("UNIT_ENTERED_VEHICLE", "player")
	F.power:RegisterUnitEvent("UNIT_EXITED_VEHICLE", "player")
	F.power:RegisterEvent("PET_BATTLE_OPENING_START")
	F.power:RegisterEvent("PET_BATTLE_CLOSE")
end	

function PB:OnDisable()
	F.power:UnregisterAllEvents()
	F.container:Hide()
end

function PB:Lock()
	if SN.data.profile.powerbar.enable then
		SN:LockFrame(F.powermover)
		F.container:Show()
	end
end

function PB:Unlock()
	if SN.data.profile.powerbar.enable then
		F.container:Hide()
		SN:UnlockFrame(F.powermover)
	end
end

function PB:Reset()
	local static = SN.DB.profile.frames
	local temp = SN.data.profile.frames
	F.powermover:ClearAllPoints()

	F.powermover:SetPoint(unpack(static.powerbar))
	
	wipe(temp.powerbar)
end

function PB:ApplySettings()
	F.powermover:ClearAllPoints()
	F.powermover:SetPoint(unpack(SN.data.profile.frames.powerbar))
	F.powermover:SetSize(SN.data.profile.powerbar.width, SN.data.profile.powerbar.height)
	F.container:SetSize(SN.data.profile.powerbar.width, SN.data.profile.powerbar.height)
	F.power:SetSize(SN.data.profile.powerbar.width - 2, SN.data.profile.powerbar.height - 2)
	F.power:SetStatusBarTexture(LSM:Fetch("statusbar", SN.data.profile.powerbar.texture))
	F.power.value:SetFont(LSM:Fetch("font", SN.data.profile.powerbar.font), SN.data.profile.powerbar.fontsize, "OUTLINE")
	if SN.data.profile.powerbar.tickenable and F.power.tick ~= nil then
		local name, _, _, cost = GetSpellInfo(SN.spells[SN.playerClass][GetSpecialization()])
		F.power.tick.name = name
		F.power.tick.cost = cost
		if not F.power.tick:IsShown() then
			F.power.tick:Show()
		end
	elseif not SN.data.profile.powerbar.tickenable and F.power.tick ~= nil then
		F.power.tick:Hide()
	end
	if IsAddOnLoaded("ElvUI") then
		SN:ScheduleTimer("ElvOverride", 5)
	end
end

function PB:ShortValue(value)
	if value >= 1e6 then
		return ("%.1fm"):format(value / 1e6):gsub("%.?0+([km])$", "%1")
	elseif value >= 1e3 or value <= -1e3 then
		return ("%.1fk"):format(value / 1e3):gsub("%.?0+([km])$", "%1")
	else
		return value
	end
end

function PB:PowerbarEvents(self, event, ...)

	if event == "PLAYER_ENTERING_WORLD" then
		local name, _, _, cost = GetSpellInfo(SN.spells[SN.playerClass][GetSpecialization()])
		if name and cost and (cost > 0) then
			self.tick.name = name
			self.tick.cost = cost
		
			local powerType = UnitPowerType("player")
			
			if powerType == 0 then
				self.tick:ClearAllPoints()
				local xoffset = (self:GetValue() - self.tick.cost) * (self:GetWidth() / select(2, self:GetMinMaxValues()) - 5)
				self.tick:SetPoint("LEFT", self, "LEFT", xoffset, 0)
			else
				self.tick:ClearAllPoints()
				local xoffset = (self.tick.cost) * (self:GetWidth() / select(2, self:GetMinMaxValues())) - 5
				self.tick:SetPoint("LEFT", self, "LEFT", xoffset, 0)
			end

			if SN.data.profile.powerbar.tickenable then
				self.tick:Show()
			else
				self.tick:Hide()
			end
		else
			self.tick:Hide()
		end
	end
	local max
	local min
	local powerType
	local powerTypeIndex

	local barType, minPower, _, _, _, hideFromOthers = UnitAlternatePowerInfo("player")

	if barType and not hideFromOthers and UnitHasVehicleUI("player") then
		powerType = ALTERNATE_POWER_INDEX
		powerTypeIndex = 3
	else
		powerType = UnitPowerType("player")

		if powerType == 6 then
			powerTypeIndex = 5
		else
			powerTypeIndex = powerType + 1
		end
	end

	min = UnitPower("player", powerType)
	max = UnitPowerMax("player", powerType)

	self:SetStatusBarColor(unpack(M.power[powerTypeIndex]))
	self:SetMinMaxValues(0, max)
	self:SetValue(min)
	if max > 150 then
		self.value:SetText(string.format("%s / %s",  PB:ShortValue(min), PB:ShortValue(max)))
	else
		self.value:SetText(min)
	end

	if SN.data.profile.powerbar.tickenable and not HasVehicleActionBar() then
		if self.tick == nil then
			self.tick = CreateFrame("Frame", nil, self)
			self.tick:SetSize(10, self:GetHeight() * 1.6)
			self.tick.tex = self.tick:CreateTexture(nil, "OVERLAY")
			self.tick.tex:SetAllPoints(self.tick)
			self.tick.tex:SetTexture("Interface\\CastingBar\\UI-CastingBar-Spark")	
			self.tick.tex:SetBlendMode("ADD")
			self.tick:SetAlpha(1)
		end
		local name, _, _, cost = GetSpellInfo(SN.spells[SN.playerClass][GetSpecialization()])
		if name and cost and (cost > 0) then
			self.tick.name = name
			self.tick.cost = cost
		
			local powerType = UnitPowerType("player")
			
			if powerType == 0 then
				self.tick:ClearAllPoints()
				local xoffset = (self:GetValue() - self.tick.cost) * (self:GetWidth() / select(2, self:GetMinMaxValues()) - 5)
				self.tick:SetPoint("LEFT", self, "LEFT", xoffset, 0)
			else
				self.tick:ClearAllPoints()
				local xoffset = (self.tick.cost) * (self:GetWidth() / select(2, self:GetMinMaxValues())) - 5
				self.tick:SetPoint("LEFT", self, "LEFT", xoffset, 0)
			end
		end
		if self.tick:IsShown() == false then 
			self.tick:Show() 
		end
	else
		self.tick:Hide()
	end
	if event == "PET_BATTLE_OPENING_START" then
		F.container:Hide()
	elseif event == "PET_BATTLE_CLOSE" then
		F.container:Show()
	end
	
end