------------------------------------------------------------------------------------------
-- Minimap Functions----------------------------------------------------------------------
------------------------------------------------------------------------------------------
local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")
local MODNAME = "minimap"
local MINIMAP = SN:NewModule(MODNAME, "AceEvent-3.0", "AceConsole-3.0")

local AceConfigDialog = LibStub("AceConfigDialog-3.0")

function MINIMAP:OnInitialize()
	
	MINIMAP.icon = LibStub("LibDBIcon-1.0")
	MINIMAP.ldb = LibStub("LibDataBroker-1.1"):NewDataObject("SerenityNow", {
  		type = "launcher",
		text = "Serenity Now",
		icon = "Interface\\Icons\\Spell_Holy_Serendipity",
		OnClick = function(self, button)
			if button == "LeftButton" then
				local mode = "Close"
				if not AceConfigDialog.OpenFrames["SN"] then
					mode = "Open"
				end
				AceConfigDialog[mode](AceConfigDialog, "SN")
			elseif button == "RightButton" and SN.data.profile.raidinvite.enable then
				local mode = "Close"
				if not AceConfigDialog.OpenFrames["Inviter"] then
					mode = "Open"
				end
				AceConfigDialog[mode](AceConfigDialog, "Inviter")
			end
		end,
		OnTooltipShow = function(tt)
			tt:AddLine(L["|cff0070deSerenity Now|r "]..SN.ver)
			tt:AddLine("\n")
			tt:AddLine(L["Left click to open config"])
			if SN.data.profile.raidinvite.enable then
				tt:AddLine(L["Right click to open the Raid Inviter"])
			end
		end		
	}) 

	MINIMAP.icon:Register("SerenityNow", MINIMAP.ldb, SN.data.profile.minimap)
	SN.minimap = MINIMAP.icon
	--if not SN.data.profile.minimap.hide then
	--	MINIMAP.icon:Show("SerenityNow")
	--else
	--	MINIMAP.icon:Hide("SerenityNow")
	--end
end

function MINIMAP:OnEnable()
	
end

function MINIMAP:OnDisable()
	
end

function MINIMAP:Lock()

end

function MINIMAP:Unlock()
	
end

function MINIMAP:Reset()

end

function MINIMAP:ApplySettings()

end