local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")
local MODNAME = "raidinvite"
local RI = SN:NewModule(MODNAME, "AceEvent-3.0", "AceConsole-3.0", "AceTimer-3.0")

local guildMembers = {}
local InviteQueue = {}
local Invites = {}
local masterLooter = ""
local maintank = ""
local inviteStart = false
local lootthresh

local GetNumGroupMembers = GetNumGroupMembers
local IsInRaid = IsInRaid
local ConvertToRaid = ConvertToRaid
local InviteUnit = InviteUnit
local GetLootMethod = GetLootMethod
local strlen = strlen
local UnitInRaid = UnitInRaid
local SetLootMethod = SetLootMethod
local PromoteToAssistant = PromoteToAssistant
local SetLootThreshold = SetLootThreshold
local SetEveryoneIsAssistant = SetEveryoneIsAssistant
local wipe = wipe

local Threshold = {
    ["Poor"]		= 0,
    ["Common"]		= 1,
    ["Uncommon"]	= 2,
    ["Rare"]		= 3,
    ["Epic"]		= 4,
    ["Legendary"]	= 5,
    ["Artifact"]	= 6,

}

function RI:BuildFilterTable()

    RI.filterTable = {
		JOINED_PARTY,
		ERR_DUNGEON_DIFFICULTY_CHANGED_S,
		ERR_RAID_DIFFICULTY_CHANGED_S,
		ERR_ALREADY_IN_GROUP_S,
		ERR_DECLINE_GROUP_S,
		ERR_INVITE_IN_COMBAT,
		ERR_INVITE_PLAYER_S,
		ERR_JOINED_GROUP_S,
		ERR_RAID_MEMBER_ADDED_S,
		ERR_NEW_LOOT_MASTER_S,
		ERR_SET_LOOT_MASTER,
		ERR_SET_LOOT_GROUP,
		ERR_SET_LOOT_THRESHOLD_S,
    }
end

function RI:ChatFilter(self, event, msg, ...)
    if not RI.filterTable then 
		RI:BuildFilterTable() 
	end

    for i = 1, #RI.filterTable do
        if string.find(msg, RI.filterTable[i]) then 
			return true 
		end
    end

    return false
end

function RI:OnInitialize()
	--Inviter frame to allow OnUpdate
	RI.Inviter = CreateFrame("Frame")
	--Raid Inviter option table for AceConfigDialog
	RI.options = {
		type = "group",
		name = "Guild Raid Inviter",
		childGroups = "tree",
		args = {
			memberSelect = {
				type = "group",
				name = "Guild Member List",
				guiInline = true,
				args = {
					invite = {
						order = 0,
						type = "execute",
						name = "Invite",
						func = function()
							if inviteStart then
								RI:Print("The Inviter has already started")
							else
								inviteStart = true
								local i = 1
								for k, v in pairs(guildMembers) do
									if guildMembers[k]["Invite"] then
										Invites[i] = k
										i = i + 1
									end
								end
								RI:Invite()
							end
						end,
					},
					refresh = {
						order = 1,
						type = "execute",
						name = "Refresh",
						func = function()
							RI:RefreshInviteData()
						end,
					},
					masterlootOn = {
						order = 2,
						type = "toggle",
						name = "Master Loot On",
						desc = "Check if you wish to use Master Looter",
						order = 5,
						get = function(info)
							return SN.data.profile.raidinvite[info[#info]]
						end,
						set = function(info, value)
							SN.data.profile.raidinvite[info[#info]] = value
						end,
					},
					masterloot = {
						order = 3,
						name = "Master Looter",
						hidden = function() return SN.data.profile.raidinvite.masterlootOn end,
						type = "select",
						values = function()
							local values = {}
							for k, v in pairs(guildMembers) do
								values[k] = k
							end
							return values
						end,
						get = function(info)
							return masterLooter
						end,
						set = function(info, value)
							masterLooter = value
						end,		
					},
					assistAll = {
						order = 2,
						type = "toggle",
						name = "Everyone Assist",
						desc = "Allow Everyone to Have Assist",
						order = 5,
						get = function(info)
							return SN.data.profile.raidinvite[info[#info]]
						end,
						set = function(info, value)
							SN.data.profile.raidinvite[info[#info]] = value
						end,
					},
					tank = {
						order = 4,
						name = "Main Tank",
						type = "select",
						hidden = function() return SN.data.profile.raidinvite.assistAll end,
						values = function()
							local values = {}
							for k, v in pairs(guildMembers) do
								values[k] = k
							end
							return values
						end,
						get = function(info)
							return maintank
						end,
						set = function(info, value)
							maintank = value
						end,
					},
					lootquality = {
						order = 5,
						hidden = function() return not SN.data.profile.raidinvite.masterlootOn end,
						name = "Loot Threshold",
						type = "select",
						values = {
							["Uncommon"] = "|cff1eff00Uncommon|r",
							["Rare"] = "|cff0070ddRare|r",
							["Epic"] = "|cffa335eeEpic|r",
						},
						get = function(info)
							return lootthresh
						end,
						set = function(info, value)
							lootthresh = value
						end,
					},
					members = {
						order = 6,
						type = "multiselect",
						name = "",
						values = function()
							local values = {}
							for k, v in pairs(guildMembers) do
								values[k] = k
							end
							return values
						end,
						get = function(info, value)
							return guildMembers[value]["Invite"]
						end,
						set = function(info, value, bool)
							guildMembers[value]["Invite"] = bool
						end,
					},
				},
			},
		},
	}

	--Raid Invite Tool
	LibStub("AceConfig-3.0"):RegisterOptionsTable("Inviter", RI.options)
	LibStub("AceConfigDialog-3.0"):SetDefaultSize("Inviter", 450, 500)
	--Raid Function command line tools
	RI:RegisterChatCommand("raidinviter", "Cmds")
end

function RI:RefreshInviteData()
	--wipe(guildMembers)

	--local numberOfFriends, onlineFriends = GetNumFriends()
	--local totalBNet, numBNetOnline = BNGetNumFriends()

	for i = 1, GetNumGuildMembers() do
		local name, _, rankIndex, unitLevel, _, unitZone, _, _, online = GetGuildRosterInfo(i)
		if unitLevel == 90 and online then
			if not guildMembers[name] then
				guildMembers[name] = { ["Invite"] = false }
			end
		end
	end
end

function RI:Cmds(input)
	local v1, v2 = input:match("^(%S*)%s*(.-)$")
	v1 = v1:lower()

	if (v1 == "") then	
		LibStub("AceConfigDialog-3.0"):Open("Inviter")
	end
end

local delay = 0
local inviteProgress = 1
local MLset = false
local MTset = false
local ASSTset = false
local filtered = false

local function inviteUpdate(self, elapsed)
	if not filtered then
		ChatFrame_AddMessageEventFilter("CHAT_MSG_SYSTEM", RI.ChatFilter)
		filtered = true
	end
	delay = delay + elapsed
	if delay > 5 then		
		if Invites[inviteProgress] then
			if GetNumGroupMembers() >= 4 and not IsInRaid() then
				RI:Print("Setting group to Raid")
				ConvertToRaid()
			end
			--RI:Print("Inviting..."..Invites[inviteProgress])
			InviteUnit(Invites[inviteProgress])
			inviteProgress = inviteProgress + 1
			delay = 0
		else
			if SN.data.profile.raidinvite.masterlootOn then
				local lootmethod = GetLootMethod()
				if lootmethod ~= "master" and strlen(masterLooter) ~= 0 and IsInRaid() and not MLset then
					if UnitInRaid(masterLooter) then
						SetLootMethod("master", masterLooter)
						RI:Print("Setting "..masterLooter.." to Master Looter")
						PromoteToAssistant(masterLooter)
						RI:Print("Setting "..masterLooter.." to Assistant")
						masterLooter = ""
						MLset = true
					end
					delay = 0
				elseif SN.data.profile.raidinvite.masterlootOn and MLset and IsInRaid() and masterLooter == "" then
					SetLootThreshold(Threshold[lootthresh])
					RI:Print("Setting Loot Threshold to Epic")
					if strlen(maintank) ~= 0 and UnitInRaid(maintank) and not MTset then
						PromoteToAssistant(maintank)
						RI:Print("Setting "..maintank.." to Assistant")
						maintank = ""
						MTset = true
					end
				end
			elseif SN.data.profile.raidinvite.assistAll and not ASSTset then
				SetEveryoneIsAssistant()
				ASSTset = true
			else
				self:SetScript("OnUpdate", nil)
				RI:Print("Invites Done")
				wipe(Invites)
				inviteStart = false
				inviteProgress = 1
				delay = 0
				MLset = false
				ChatFrame_RemoveMessageEventFilter("CHAT_MSG_SYSTEM", RI.ChatFilter)
				filtered = false
			end
		end
	end
	
end

local function chatMsg(self, event, msg)
	if string.find(msg, ERR_ALREADY_IN_GROUP_S) then
		local name = strsplit(" ", ERR_ALREADY_IN_GROUP_S, 1)
	elseif string.find(msg, ERR_DECLINE_GROUP_S) then
		local name = strsplit(" ", ERR_DECLINE_GROUP_S, 1)
	end
end

function RI:Invite()
	RI:Print("Starting invites...")
	--RI.Inviter:RegisterEvent("CHAT_MSG_SYSTEM", chatMsg)
	RI.Inviter:SetScript("OnUpdate", inviteUpdate)
end

function RI:OnEnable()
	
end

function RI:OnDisable()

end

function RI:Lock()

end

function RI:Unlock()
	
end

function RI:Reset()

end

function RI:ApplySettings()

end

