-----------------------------------------------------------------------------------------
--Interrupt Frame------------------------------------------------------------------------
-----------------------------------------------------------------------------------------
local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")
local MODNAME = "interrupt"
local INT = SN:NewModule(MODNAME, "AceEvent-3.0")

local unpack = unpack
local wipe = wipe
local tostring = tostring
local IsAddOnLoaded = IsAddOnLoaded
local IsInInstance = IsInInstance
local UnitCastingInfo = UnitCastingInfo
local UnitChannelInfo = UnitChannelInfo
local IsUsableSpell = IsUsableSpell
local GetSpellCooldown = GetSpellCooldown
local GetSpellInfo = GetSpellInfo

SN.interrupts = {
	["DRUID"] = 106839,
	["DEATHKNIGHT"] = 47528,
	["HUNTER"] = 34490,
	["MAGE"] = 2139,
	["PALADIN"] = 96231,
	["PRIEST"] = 15487,
	["ROGUE"] = 1766,
	["SHAMAN"] = 57994,
	["WARRIOR"] = 6552,
}

local interrupt

local function getOptions()
	interrupt = {
		type = "group",
		name = L["Interrupt"],
		args = {
			enable = {
				type = "toggle",
				name = L["Enable Interrupt System"],
				order = 0,
				get = function(info)
					return SN.data.profile.interrupt[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.interrupt[info[#info]] = value
					if value then
						SN:EnableModule(MODNAME)
					else
						SN:DisableModule(MODNAME)
					end
				end,
			},
			h8 = {
				order = 3,
				type = "header",
				name = "Font",
				hidden = function() return not SN.data.profile.interrupt.enable end,
			},
			font = {
				type = "select",
				dialogControl = 'LSM30_Font',
				name = L["Font"],
				hidden = function() return not SN.data.profile.interrupt.enable end,
				order = 5,
				values = AceGUIWidgetLSMlists.font,
				get = function(info) return SN.data.profile.interrupt[info[#info]] end,--selectedClass end,
				set = function(info, value)
					SN.data.profile.interrupt[info[#info]] = value
					INT.interrupt.value:SetFont(LSM:Fetch("font", value), SN.data.profile.interrupt.fontsize)
				end,
			},
			fontsize = {
				type = "range",
				name = L["Font Size of Interrupt Frame"],
				hidden = function() return not SN.data.profile.interrupt.enable end,
				order = 6,
				min = 10, max = 24, step = 1,
				get = function(info)
					return SN.data.profile.interrupt[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.interrupt[info[#info]] = value
					INT.interrupt.value:SetFont(LSM:Fetch("font", SN.data.profile.interrupt.font), value)
				end,
			},
		},
	}
	return interrupt
end

function INT:OnInitialize()
	SN:RegisterModuleOptions(MODNAME, getOptions, L["Interrupt"])

	INT.interrupt = SN:CreateFrame("Interrupt Bar", MODNAME, UIParent)
end

function INT:OnEnable()
	INT.interrupt:Show()
	INT:RegisterEvent("UNIT_SPELLCAST_START")
	INT:RegisterEvent("UNIT_SPELLCAST_CHANNEL_START")
	INT:RegisterEvent("UNIT_SPELLCAST_CHANNEL_STOP")
	INT:RegisterEvent("UNIT_SPELLCAST_FAILED")
	INT:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED")
	INT:RegisterEvent("UNIT_SPELLCAST_STOP")
	INT:RegisterEvent("PLAYER_REGEN_ENABLED")
	INT:RegisterEvent("PLAYER_TARGET_CHANGED")
	
end

function INT:OnDisable()
	INT:UnregisterAllEvents()
	INT.interrupt:Hide()
end

function INT:Lock()
	SN:LockFrame(INT.interrupt)
	if SN.data.profile.interrupt.enable then
		INT.interrupt:Show()
	end
end

function INT:Unlock()
	SN:UnlockFrame(INT.interrupt)
end

function INT:Reset()
	local static = SN.DB.profile.frames
	local temp = SN.data.profile.frames
	INT.interrupt:ClearAllPoints()

	INT.interrupt:SetPoint(unpack(static.interrupt))
	wipe(temp.interrupt)
end

function INT:ApplySettings()
	INT.interrupt:ClearAllPoints()
	INT.interrupt:SetPoint(unpack(SN.data.profile.frames.interrupt))
	INT.interrupt.value:SetFont(LSM:Fetch("font", SN.data.profile.interrupt.font), SN.data.profile.interrupt.fontsize, "OUTLINE")
end
--hmm still not sure I like doing event handlers this way...it seems orderly
function INT:UNIT_SPELLCAST_START(event, unit)
	local inInstance, instanceType = IsInInstance()
	if IsAddOnLoaded("DBM-Core") and inInstance and instanceType == "raid" then return end
	if unit ~= "target" then return end

	if event == "UNIT_SPELLCAST_START" then
		self.interrupt.casting, self.interrupt.channeling = true, nil
	else
		self.interrupt.casting, self.interrupt.channeling = nil, true
	end

	if SN.interrupts[SN.playerClass] then
		local spell, displayName, notInterruptible
		if self.interrupt.casting then
			spell, _, displayName, _, _, _, _, notInterruptible = UnitCastingInfo(unit)
		else
			spell, _, displayName, _, _, _, _, notInterruptible = UnitChannelInfo(unit)
			displayName = spell
		end
		if not notInterruptible then
			local interruptSpell = GetSpellInfo(SN.interrupts[SN.playerClass])
			local isUsable, notEnoughMana = IsUsableSpell(interruptSpell)
			local _, dur = GetSpellCooldown(SN.interrupts[SN.playerClass])
			if isUsable and not notEnoughMana and dur == 0 then
				self.interrupt.value:SetText("Interrupt "..tostring(displayName))
			else
				self.interrupt.value:SetText("")
			end
		end
	end
end
INT.UNIT_SPELLCAST_CHANNEL_START = INT.UNIT_SPELLCAST_START

function INT:PLAYER_REGEN_ENABLED()
	self.interrupt.value:SetText("")
end

function INT:UNIT_SPELLCAST_INTERRUPTED(event, unit)
	if unit ~= "target" then return end
	self.interrupt.value:SetText("")
end
INT.PLAYER_TARGET_CHANGED = INT.PLAYER_REGEN_ENABLED
INT.UNIT_SPELLCAST_FAILED = INT.UNIT_SPELLCAST_INTERRUPTED
INT.UNIT_SPELLCAST_CHANNEL_STOP = INT.UNIT_SPELLCAST_INTERRUPTED
INT.UNIT_SPELLCAST_STOP = INT.UNIT_SPELLCAST_INTERRUPTED
