-----------------------------------------------------------------------------------------
--Dispel Frame---------------------------------------------------------------------------
-----------------------------------------------------------------------------------------
local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")
local MODNAME = "dispel"
local DISPEL = SN:NewModule(MODNAME, "AceEvent-3.0")

local UnitAura = UnitAura
local GetSpellLink = GetSpellLink
local UnitGUID = UnitGUID
local UnitName = UnitName
local UnitIsEnemy = UnitIsEnemy
local unpack = unpack
local select = select
local wipe = wipe
local NORMAL_FONT_COLOR = NORMAL_FONT_COLOR
local GetSpellTexture = GetSpellTexture

local dispelSpell

local dispel

local function getOptions()
	dispel = {
		type = "group",
		name = L["Dispel"],
		args = {
			enable = {
				type = "toggle",
				name = L["Enable Dispel System"],
				order = 0,
				get = function(info)
					return SN.data.profile.dispel[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.dispel[info[#info]] = value
					if value then
						SN:EnableModule(MODNAME)
					else
						SN:DisableModule(MODNAME)
					end
				end,
			},
			h8 = {
				order = 3,
				type = "header",
				name = "Size",
				hidden = function() return not SN.data.profile.dispel.enable end,
			},
			size = {
				type = "range",
				name = L["Size of Dispel Icon"],
				hidden = function() return not SN.data.profile.dispel.enable end,
				order = 4,
				min = 16, max = 128, step = 4,
				get = function(info)
					return SN.data.profile.dispel[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.dispel[info[#info]] = value
					F.dispel:SetSize(value, value)
				end,
			},
		},
	}
	return dispel
end

function DISPEL:OnInitialize()
	SN:RegisterModuleOptions(MODNAME, getOptions, L["Dispel"])

	F.dispel = SN:CreateFrame("Dispel Frame", MODNAME, UIParent)
	
	F.dispel.TimeSinceLastUpdate = 0
	F.dispel.dispelSpell = nil
	F.dispel.spell = nil

	F.dispel:SetScript("OnEvent", function(self, event, ...)
		DISPEL:DispelEvents(self, event, ...)
	end)
	local color = NORMAL_FONT_COLOR

	F.dispel.icon = F.dispel:CreateTexture("$parentIcon", "ARTWORK")
	F.dispel.icon:SetPoint("TOPLEFT", 2, -2)
	F.dispel.icon:SetPoint("BOTTOMRIGHT", -2, 2)
	F.dispel.icon:SetTexCoord(0.1, 0.9, 0.1, 0.9)
	
end

function DISPEL:OnEnable()
	F.dispel:Show()
	F.dispel:RegisterEvent("PLAYER_REGEN_ENABLED")
	F.dispel:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	F.dispel:RegisterEvent("PLAYER_TARGET_CHANGED")

	F.dispel:SetScript("OnUpdate", function(self, elapsed)
		if UnitIsEnemy("player", "target") == 1 then
			DISPEL:SearchBuffs(self, elapsed)
		end
	end)
end

function DISPEL:OnDisable()
	F.dispel:UnregisterAllEvents()
	F.dispel:SetScript("OnUpdate", nil)
	F.dispel:Hide()
end

function DISPEL:Lock()
	SN:LockFrame(F.dispel)
	if SN.data.profile.dispel.enable then
		F.dispel:Show()
	end
end

function DISPEL:Unlock()
	SN:UnlockFrame(F.dispel)
end

function DISPEL:Reset()
	local static = SN.DB.profile.frames
	local temp = SN.data.profile.frames
	F.dispel:ClearAllPoints()

	F.dispel:SetPoint(unpack(static.dispel))
	wipe(temp.dispel)
end

function DISPEL:ApplySettings()
	F.dispel:ClearAllPoints()
	F.dispel:SetPoint(unpack(SN.data.profile.frames.dispel))
	F.dispel.value:SetFont(LSM:Fetch("font", SN.data.profile.dispel.font), SN.data.profile.dispel.fontsize, "OUTLINE")
end

function DISPEL:SearchBuffs(self, elapsed)
	--Make sure we don't hog cpu cycles checking it every millisecond
	self.TimeSinceLastUpdate = self.TimeSinceLastUpdate + elapsed
	if self.TimeSinceLastUpdate > SN.UpdateIntervalDispel then

		self.TimeSinceLastUpdate = 0
		for i = 1, 40 do

			local stealableBuffs
			local name, _, icon, _, debuffType, _, _, _, _, _, spellId, _, _ = UnitAura("target", i, "HELPFUL")
				
			if name then
				local canDispel, dispelSpell = SN.dispel:CanDispel("target", true, debuffType, spellId)
				if canDispel then
					self.icon:SetTexture(GetSpellTexture(dispelSpell))
					self.dispelSpell = dispelSpell
					self.spell = spellId
				end
			end
		end
	end
end

function DISPEL:DispelEvents(self, event, ...)

	if event == "COMBAT_LOG_EVENT_UNFILTERED" then
		local _, type, _, sourceGUID, sourceName, _, _, destGUID, destName = ...
		local spellId, spellName = select(12, ...)
		--Reset text after the Buff has been dispeled
		if type == "SPELL_AURA_REMOVED" or "SPELL_DISPEL" or "SPELL_AURA_STOLEN" then
			if destGUID == UnitGUID("target") and spellId == self.spell then
				self.icon:SetTexture("")
				self.dispelSpell = nil
			end
		end
	end

	if event == "PLAYER_REGEN_ENABLED" then
		self.icon:SetTexture("")
		self.dispelSpell = nil
	end
	
	if event == "PLAYER_TARGET_CHANGED" then
		self.icon:SetTexture("")
		self.dispelSpell = nil
	end
end