-----------------------------------------------------------------------------------------
--Debuffs Group Frame--------------------------------------------------------------------
-----------------------------------------------------------------------------------------
local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")
local MODNAME = "debuffs"
local DB = SN:NewModule(MODNAME, "AceEvent-3.0")

local UnitDebuff = UnitDebuff
local UnitGUID = UnitGUID
local UnitName = UnitName
local UnitIsEnemy = UnitIsEnemy
local UnitExists = UnitExists
local GetTime = GetTime
local IsAddOnLoaded = IsAddOnLoaded
local pairs = pairs
local unpack = unpack
local wipe = wipe
local tContains = tContains
local bit_band = bit.band
local GameFontNormal = GameFontNormal
local NORMAL_FONT_COLOR = NORMAL_FONT_COLOR
local COMBATLOG_OBJECT_REACTION_FRIENDLY = COMBATLOG_OBJECT_REACTION_FRIENDLY
local COMBATLOG_OBJECT_REACTION_NEUTRAL = COMBATLOG_OBJECT_REACTION_NEUTRAL

local debuffs

local function getOptions()
	debuffs = {
		type = "group",
		name = L["Debuffs"],
		args = {
			enable = {
				order = 0,
				type = "toggle",
				name = L["Enable Debuff Bars"],
				get = function(info)
					return SN.data.profile.debuffs[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.debuffs[info[#info]] = value

					if value then
						SN:EnableModule(MODNAME)
					else
						SN:DisableModule(MODNAME)
					end
				end,
			},
			visible = {
				order = 1,
				type = "range",
				name = L["Number of Debuff Bars Visible"],
				hidden = function() return not SN.data.profile.debuffs.enable end,
				min = 1, max = 8, step = 1,
				get = function(info)
					return SN.data.profile.debuffs[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.debuffs[info[#info]] = value
					F.debuffs:SetVisibleBars(value)
				end,
			},
			h7 = {
				order = 2,
				type = "header",
				name = "Dimensions",
				hidden = function() return not SN.data.profile.debuffs.enable end,
			},
			width = {
				order = 4,
				type = "range",
				name = L["Width of Debuff Bars"],
				hidden = function() return not SN.data.profile.debuffs.enable end,
				min = 50, max = 500, step = 1,
				get = function(info)
					return SN.data.profile.debuffs[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.debuffs[info[#info]] = value
					F.debuffs:SetWidth(value)
				end,
			},
			height = {
				order = 5,
				type = "range",
				name = L["Height of Debuff Bars"],
				hidden = function() return not SN.data.profile.debuffs.enable end,
				min = 12, max = 40, step = 1,
				get = function(info)
					return SN.data.profile.debuffs[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.debuffs[info[#info]] = value
					if F.debuffs.bars ~= nil then
						local bars = F.debuffs.bars
						for i in pairs(bars) do
							i:SetHeight(value)
						end
					end
				end,
			},
			yoffset = {
				order = 6,
				type = "range",
				name = L["Y Offset of Debuff Bars"],
				hidden = function() return not SN.data.profile.debuffs.enable end,
				order = 7,
				min = 0, max = 6, step = 1,
				get = function(info)
					return SN.data.profile.debuffs[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.debuffs[info[#info]] = value
					F.debuffs:SetSpacing(SN.data.profile.debuffs.yoffset, value)
				end,
			},
			h8 = {
				order = 8,
				type = "header",
				name = "Font",
				hidden = function() return not SN.data.profile.debuffs.enable end,
			},
			font = {
				order = 9,
				type = "select",
				dialogControl = 'LSM30_Font',
				name = L["Font"],
				hidden = function() return not SN.data.profile.debuffs.enable end,
				values = AceGUIWidgetLSMlists.font,
				get = function(info) return SN.data.profile.debuffs[info[#info]] end,--selectedClass end,
				set = function(info, value)
					SN.data.profile.debuffs[info[#info]] = value
					if F.debuffs.bars ~= nil then
						local bars = F.debuffs.bars
						for i in pairs(bars) do
							i:SetLabelFont(LSM:Fetch("font", value), SN.data.profile.debuffs.fontsize)
							i:SetDurationFont(LSM:Fetch("font", value), SN.data.profile.debuffs.fontsize)
						end
					end
				end,
			},
			fontsize = {
				order = 10,
				type = "range",
				name = L["Font Size of Debuff Bars"],
				hidden = function() return not SN.data.profile.debuffs.enable end,
				min = 10, max = 24, step = 1,
				get = function(info)
					return SN.data.profile.debuffs[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.debuffs[info[#info]] = value
					if F.debuffs.bars ~= nil then
						local bars = F.debuffs.bars
						for i in pairs(bars) do
							i:SetLabelFont(LSM:Fetch("font", SN.data.profile.debuffs.font), value)
							i:SetDurationFont(LSM:Fetch("font", SN.data.profile.debuffs.font), value)
						end
					end
				end,
			},
			h9 = {
				order = 11,
				type = "header",
				name = L["Texture/Misc"],
				hidden = function() return not SN.data.profile.debuffs.enable end,
			},
			texture = {
				order = 12,
				type = "select",
				dialogControl = 'LSM30_Statusbar',
				name = L["Texture"],
				hidden = function() return not SN.data.profile.debuffs.enable end,
				values = AceGUIWidgetLSMlists.statusbar,
				get = function(info) return SN.data.profile.debuffs[info[#info]] end,
				set = function(info, value)
					SN.data.profile.debuffs[info[#info]] = value
					if F.debuffs.bars ~= nil then
						local bars = F.debuffs.bars
						for i in pairs(bars) do
							i:SetTexture(LSM:Fetch("statusbar", value))
						end
					end
				end,
			},
			grow = {
				order = 13,
				type = "select",
				name = L["Grow Direction"],
				hidden = function() return not SN.data.profile.debuffs.enable end,
				values = {
					["topleft"] = "Up",
					["bottomleft"] = "Down",
				},
				get = function(info)
					return SN.data.profile.debuffs[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.debuffs[info[#info]] = value
					F.debuffs:SetStartPoint(value)
				end,
			},
			iconmode = {
				order = 14,
				type = "toggle",
				name = L["Turn on Icon Mode"],
				hidden = function() return not SN.data.profile.debuffs.enable end,
				get = function(info)
					return SN.data.profile.debuffs[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.debuffs[info[#info]] = value
					if value then
						F.debuffs:SetIconMode(32 * SN.data.profile.debuffs.iconscale, "BOTTOM", 0, 0)
						F.debuffs:SetSpacing(SN.data.profile.debuffs.fontsize / 2, SN.data.profile.debuffs.fontsize + 3)
					else
						F.debuffs:SetIconMode(false)
						F.debuffs:SetSpacing(0, 3)
						F.debuffs:SetWidth(SN.data.profile.debuffs.width)
						if F.debuffs.bars ~= nil then
							local bars = F.debuffs.bars
							for i in pairs(bars) do
								i:SetHeight(SN.data.profile.debuffs.height)
							end
						end
					end
				end,
			},
			iconscale = {
				order = 15,
				type = "range",
				name = L["Icon Scale"],
				min = 0.1, max = 2.0, step = 0.1,
				hidden = function() return not SN.data.profile.debuffs.iconmode or not SN.data.profile.debuffs.enable end,
				get = function(info)
					return SN.data.profile.debuffs[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.debuffs[info[#info]] = value
					if SN.data.profile.debuffs.iconmode then
						F.debuffs:SetIconMode(32 * SN.data.profile.debuffs.iconscale, "BOTTOM", 0, 0)
						F.debuffs:SetSpacing(SN.data.profile.debuffs.fontsize / 3, SN.data.profile.debuffs.fontsize + 3)
					end
				end,
			},
		},
	}
	return debuffs
end

function DB:OnInitialize()
	SN:RegisterModuleOptions(MODNAME, getOptions, L["Debuffs"])
	
	F.debuffs = T:NewGroup(SN.data.profile.debuffs.width, "Debuff Frame", "debuffs", M.media.draghandle)
	F.debuffs:SetSorting("time", true)
	F.debuffs:SetSpacing(0, SN.data.profile.debuffs.yoffset)
	F.debuffs:SetStartPoint(SN.data.profile.debuffs.grow)
	F.debuffs:SetPoint(unpack(SN.data.profile.frames.debuffs))
	F.debuffs:SetVisibleBars(SN.data.profile.debuffs.visible)
	
	local color = NORMAL_FONT_COLOR

	--The mover frame text
	F.debuffs.value = F.debuffs:CreateFontString(nil, "OVERLAY")
	F.debuffs.value:SetPoint("CENTER", F.debuffs)
	F.debuffs.value:SetFontObject(GameFontNormal)
	F.debuffs.value:SetJustifyH("CENTER")
	F.debuffs.value:SetTextColor(color.r, color.g, color.b)

	F.debuffs.name = "Debuffs"
	F.debuffs.db = MODNAME

	if SN.data.profile.debuffs.iconmode then
		F.debuffs:SetIconMode(32 * SN.data.profile.debuffs.iconscale, "BOTTOM", 0, 0)
		F.debuffs:SetSpacing(SN.data.profile.debuffs.fontsize / 2, SN.data.profile.debuffs.fontsize + 3)
	end
	F.debuffs:SetScript("OnEvent", function(self, event, ...)
		DB:DebuffEvents(self, event, ...)
	end)
end

function DB:OnEnable()
	F.debuffs:Show()		
	--Register our events for the frame
	--F.debuffs:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	F.debuffs:RegisterEvent("PLAYER_TARGET_CHANGED")
	F.debuffs:RegisterEvent("PLAYER_REGEN_ENABLED")
	F.debuffs:RegisterUnitEvent("UNIT_AURA", "target")
end

function DB:OnDisable()
	F.debuffs:UnregisterAllEvents()
	F.debuffs:Clear()
	F.debuffs:Hide()
end

function DB:Lock()
	SN:LockFrame(F.debuffs)
end

function DB:Unlock()
	SN:UnlockFrame(F.debuffs)
end

function DB:Reset()
	local static = SN.DB.profile.frames
	local temp = SN.data.profile.frames
	F.debuffs:ClearAllPoints()

	F.debuffs:SetPoint(unpack(static.debuffs))
	wipe(temp.debuffs)
end

function DB:ApplySettings()
	F.debuffs:ClearAllPoints()
	SN:EditBars(F.debuffs.db)
end

local function purgeExpiredDebuffs(group)
	if group then
		for k in pairs(group) do
			local name = k:GetData("SN:arg5")
			if name then
				local buff = UnitDebuff("target", name)

				if not buff then
					k:Stop()
				end
			end
		end
	end
end

function DB:DebuffEvents(self, event, ...)
	if event == "PLAYER_REGEN_ENABLED" then
		self:Clear()
	end

	if event == "PLAYER_TARGET_CHANGED" then
		self:Clear()
		if not UnitExists("target") then return end
		
		local debuff
		local i = 1
		while true do
			local name, rank, icon, count, debuffType, duration, expiration, caster, canStealOrPurge, shouldConsolidate, spellId = UnitDebuff("target", i)
		
			if not name then break end

			if caster == "player" then
				if not tContains(SN.crowdcontrol, spellId) then
					if duration ~= 0 and expiration ~= 0 then
						debuff = SN:CreateBar(self, spellId, (expiration - GetTime()), caster, UnitGUID("target"), name)
						debuff:SetDuration((expiration - GetTime()), duration)
						debuff:Start()
					end				
				end
			end
			i = i + 1
		end
	end

	if event == "UNIT_AURA" then
		local debuff
		local name, rank, icon, count, debuffType, duration, expiration, caster, canStealOrPurge, shouldConsolidate, spellId, _
	
		local i = 1
		purgeExpiredDebuffs(self.bars)
		while true do
			name, rank, icon, count, debuffType, duration, expiration, caster, canStealOrPurge, shouldConsolidate, spellId = UnitDebuff("target", i)
		
			if not name then break end

			if caster == "player" then
				debuff = self:Find("SN:arg5", name)

				if not debuff then
					if duration ~= 0 and expiration ~= 0 then
						debuff = SN:CreateBar(self, spellId, (expiration - GetTime()), SN.playerName, UnitGUID("target"), name)
					else
						return
					end
				end

				debuff:SetDuration((expiration - GetTime()), duration)
				debuff:Start()
			end
			i = i + 1
		end
	end

--	if event == "COMBAT_LOG_EVENT_UNFILTERED" then
--		local debuff
--		local timestamp, type, hideCaster, sourceGUID, sourceName, sourceFlags, sourceRaidFlags, destGUID, destName = ...
		
--		if (type == "SPELL_AURA_REFRESH" or type == "SPELL_AURA_APPLIED" or type == "SPELL_AURA_REMOVED" or type == "SPELL_AURA_APPLIED_DOSE" or type == "SPELL_PERIODIC_AURA_REMOVED" or type == "SPELL_PERIODIC_AURA_APPLIED" or type == "SPELL_PERIODIC_AURA_APPLIED_DOSE" or type == "SPELL_PERIODIC_AURA_REFRESH") then
--			local spellId, spellName, spellSchool = select(12, ...)

--			local isMySpell
--			isMySpell = (sourceName == UnitName("player"))
			
--			purgeExpiredDebuffs(self.bars)

--			if destName == GetUnitName("target", true) then
--				if isMySpell then
--					if not tContains(SN.crowdcontrol, spellId) then
--						local debuff = self:Find("SN:arg5", spellName)
--						local name, rank, icon, count, debuffType, duration, expirationTime = UnitDebuff("target", spellName, nil, "PLAYER")
						
--						if not name then return end

--						if not debuff then
--							if duration ~= 0 and expirationTime ~= 0 then
--								debuff = SN:CreateBar(self, spellId, (expirationTime - GetTime()), sourceName, UnitGUID("target"), name)
							
--								debuff:SetDuration((expirationTime - GetTime()), duration)
--								debuff:Start()
--							end
--						else
--							local name, rank, icon, count, debuffType, duration, expirationTime = UnitDebuff("target", debuff:GetData("SN:arg5"), nil, "PLAYER")

--							if not name then debuff:Stop() return end

--							local timeLeft, _ = debuff:GetDuration()

--							if timeLeft ~= expirationTime - GetTime() then
--								debuff:SetDuration((expirationTime - GetTime()), duration)
--								debuff:Start()
--							end
--						end
--					end
--				end
--			end		
--		end
end