------------------------------------------------------------------------------------------
--Crowd Control module--------------------------------------------------------------------
------------------------------------------------------------------------------------------
local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")
local MODNAME = "cc"
local CC = SN:NewModule(MODNAME, "AceEvent-3.0")

local pairs = pairs
local bit = bit
local unpack = unpack
local select = select
local wipe = wipe
local COMBATLOG_OBJECT_REACTION_FRIENDLY = COMBATLOG_OBJECT_REACTION_FRIENDLY
local NORMAL_FONT_COLOR = NORMAL_FONT_COLOR
local GameFontNormal = GameFontNormal
local GetTime = GetTime
local UnitDebuff = UnitDebuff
local UnitIsEnemy = UnitIsEnemy
local UnitGUID = UnitGUID

local RaidMarks = {
	["Mage"] =		{ ["Mark"] = 5, ["Used"] = false },
	["Shaman"] =	{ ["Mark"] = 4, ["Used"] = false },
	["Hunter"] =	{ ["Mark"] = 6, ["Used"] = false },
	["Warlock"] =	{ ["Mark"] = 3, ["Used"] = false },
	["Rogue"] =		{ ["Mark"] = 1, ["Used"] = false },
	["Paladin"] =	{ ["Mark"] = 2, ["Used"] = false },
}

local cc

local function getOptions()
	cc = {
		type = "group",
		name = L["Crowd Control"],
		args = {
			enable = {
				type = "toggle",
				name = L["Enable CC Bars"],
				order = 0,
				get = function(info)
					return SN.data.profile.cc[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.cc[info[#info]] = value

					if value then
						SN:EnableModule(MODNAME)
					else
						SN:DisableModule(MODNAME)
					end
				end,
			},
			announce = {
				type = "toggle",
				name = L["Enable CC Break Announce"],
				order = 0,
				get = function(info)
					return SN.data.profile.cc[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.cc[info[#info]] = value
				end,
			},
			h7 = {
				order = 2,
				type = "header",
				name = "Dimensions",
				hidden = function() return not SN.data.profile.cc.enable end,
			},
			width = {
				type = "range",
				name = L["Width of CC Bars"],
				hidden = function() return not SN.data.profile.cc.enable end,
				order = 4,
				min = 50, max = 500, step = 1,
				get = function(info)
					return SN.data.profile.cc[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.cc[info[#info]] = value
					F.cc:SetWidth(value)
				end,
			},
			height = {
				type = "range",
				name = L["Height of CC Bars"],
				hidden = function() return not SN.data.profile.cc.enable end,
				order = 5,
				min = 12, max = 40, step = 1,
				get = function(info)
					return SN.data.profile.cc[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.cc[info[#info]] = value
					if F.cc.bars ~= nil then
						local bars = F.cc.bars
						for i in pairs(bars) do
							i:SetHeight(value)
						end
					end
				end,
			},
			h8 = {
				order = 6,
				type = "header",
				name = "Font",
				hidden = function() return not SN.data.profile.cc.enable end,
			},
			font = {
				type = "select",
				dialogControl = 'LSM30_Font',
				name = L["Font"],
				hidden = function() return not SN.data.profile.cc.enable end,
				order = 8,
				values = AceGUIWidgetLSMlists.font,
				get = function(info) return SN.data.profile.cc[info[#info]] end,--selectedClass end,
				set = function(info, value)
					SN.data.profile.cc[info[#info]] = value
					if F.cc.bars ~= nil then
						local bars = F.cc.bars
						for i in pairs(bars) do
							i:SetLabelFont(LSM:Fetch("font", value), SN.data.profile.cc.fontsize)
							i:SetDurationFont(LSM:Fetch("font", value), SN.data.profile.cc.fontsize)
						end
					end
				end,
			},
			fontsize = {
				type = "range",
				name = L["Font Size of CC Bars"],
				hidden = function() return not SN.data.profile.cc.enable end,
				order = 9,
				min = 10, max = 24, step = 1,
				get = function(info)
					return SN.data.profile.cc[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.cc[info[#info]] = value
					if F.cc.bars ~= nil then
						local bars = F.cc.bars
						for i in pairs(bars) do
							i:SetLabelFont(LSM:Fetch("font", SN.data.profile.cc.font), value)
							i:SetDurationFont(LSM:Fetch("font", SN.data.profile.cc.font), value)
						end
					end
				end,
			},
			h9 = {
				order = 12,
				type = "header",
				name = "Texture",
				hidden = function() return not SN.data.profile.cc.enable end,
			},
			texture = {
				type = "select",
				dialogControl = 'LSM30_Statusbar',
				name = L["Texture"],
				hidden = function() return not SN.data.profile.cc.enable end,
				order = 14,
				values = AceGUIWidgetLSMlists.statusbar,
				get = function(info) return SN.data.profile.cc[info[#info]] end,
				set = function(info, value)
					SN.data.profile.cc[info[#info]] = value
					if F.cc.bars ~= nil then
						local bars = F.cc.bars
						for i in pairs(bars) do
							i:SetTexture(LSM:Fetch("statusbar", value))
						end
					end
				end,
			},
			h55 = {
				order = 16,
				type = "header",
				name = "",
				hidden = function() return not SN.data.profile.cc.enable end,
			},
			grow = {
				type = "select",
				name = L["Grow Direction"],
				hidden = function() return not SN.data.profile.cc.enable end,
				order = 18,
				values = {
					["topleft"] = "Up",
					["bottomleft"] = "Down",
				},
				get = function(info)
					return SN.data.profile.cc[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.cc[info[#info]] = value
					F.cc:SetStartPoint(value)
				end,
			},
			iconmode = {
				type = "toggle",
				name = L["Turn on Icon Mode"],
				hidden = function() return not SN.data.profile.cc.enable end,
				order = 20,
				get = function(info)
					return SN.data.profile.cc[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.cc[info[#info]] = value
					if value then
						F.cc:SetIconMode(32 * SN.data.profile.cc.iconscale, "BOTTOM", 0, 0)
						F.cc:SetSpacing(SN.data.profile.cc.fontsize / 2, SN.data.profile.cc.fontsize + 3)
					else
						F.cc:SetIconMode(false)
						F.cc:SetSpacing(0, 3)
						F.cc:SetWidth(SN.data.profile.cc.width)
						if F.cc.bars ~= nil then
							local bars = F.cc.bars
							for i in pairs(bars) do
								i:SetHeight(SN.data.profile.cc.height)
							end
						end
					end
				end,
			},
			iconscale = {
				type = "range",
				name = L["Icon Scale"],
				order = 21,
				min = 0.1, max = 2.0, step = 0.1,
				hidden = function() return not SN.data.profile.cc.iconmode or not SN.data.profile.cc.enable end,
				get = function(info)
					return SN.data.profile.cc[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.cc[info[#info]] = value
					if SN.data.prdoile.cc.iconmode then
						F.cc:SetIconMode(32 * SN.data.profile.cc.iconscale, "BOTTOM", 0, 0)
						F.cc:SetSpacing(SN.data.profile.cc.fontsize / 3, SN.data.profile.cc.fontsize + 3)
					end
				end,
			},
		},
	}
	return cc
end

function CC:OnInitialize()
	SN:RegisterModuleOptions(MODNAME, getOptions, L["Crowd Control"])
	
	F.cc = T:NewGroup(SN.data.profile.cc.width, "CC Frame", "crowdcontrol", M.media.draghandle)
	F.cc:SetSorting("label")
	F.cc:SetSpacing(0, 3)
	F.cc:SetStartPoint(SN.data.profile.cc.grow)
	F.cc:SetPoint(unpack(SN.data.profile.frames.cc))
	
	local color = NORMAL_FONT_COLOR

	--The mover frame text
	F.cc.value = F.cc:CreateFontString(nil, "OVERLAY")
	F.cc.value:SetPoint("CENTER", F.cc)
	F.cc.value:SetFontObject(GameFontNormal)
	F.cc.value:SetJustifyH("CENTER")
	F.cc.value:SetTextColor(color.r, color.g, color.b)

	F.cc.name = "Crowd Control"
	F.cc.db = MODNAME
	
	if SN.data.profile.cc.iconmode then
		F.cc:SetIconMode(32 * SN.data.profile.cc.iconscale, "BOTTOM", 0, 0)
		F.cc:SetSpacing(SN.data.profile.cc.fontsize / 2, SN.data.profile.cc.fontsize + 3)
	end
	F.cc:SetScript("OnEvent", function(self, event, ...)
		CC:UpdateCC(self, event, ...)
	end)
end

function CC:OnEnable()
	F.cc:Show()
	F.cc:RegisterEvent("UNIT_AURA")
	F.cc:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
end

function CC:OnDisable()
	F.cc:UnregisterAllEvents()
	F.cc:Clear()
	F.cc:Hide()
end

function CC:Lock()
	SN:LockFrame(F.cc)
	--F.cc:Lock(true)
	--SN.data.profile.frames.cc = { SN:GetPoint(F.cc) }
end

function CC:Unlock()
	SN:UnlockFrame(F.cc)
	--F.cc:Lock(false)
end

function CC:Reset()
	local static = SN.DB.profile.frames
	local temp = SN.data.profile.frames
	F.cc:ClearAllPoints()

	F.cc:SetPoint(unpack(static.cc))
	wipe(temp.cc)
end

function CC:ApplySettings()
	F.cc:ClearAllPoints()
	SN:EditBars(F.cc.db)
end

function CC:UpdateCC(self, event, ...)
	if event == "UNIT_AURA" then
		local UnitID = ...
		if UnitIsEnemy(UnitID, "player") then
			local count = 1
			while true do
				local name, _, _, _, _, dur, expirationTime, sourceName, _, _, spellId, canApplyAura = UnitDebuff(UnitID, count)
				--Is there a bar for this debuff already?
				if not name then break end
				local cc = self:Find("SN:arg5", name)
				if cc == nil and expirationTime ~= nil then
					for _, ccontrol in pairs(SN.crowdcontrol) do
						if ccontrol == spellId then
							SN:CreateBar(self, spellId, (expirationTime - GetTime()), sourceName, UnitGUID(UnitID), name)
							for i in pairs(self.bars) do
								if i:GetData("SN:arg2") == spellId then
									i:SetDuration((expirationTime - GetTime()), dur)
									i:Start()
								end
							end
							--if RaidMarks[UnitClass(sourceName)] and not RaidMarks[UnitClass(sourceName)]["Used"] and UnitIsGroupLeader("player") then
							--	SetRaidTarget(UnitID, RaidMarks[UnitClass(sourceName)])
							--	RaidMarks[UnitClass(sourceName)]["Used"] = true
							--end
						end
					end
				end
				count = count + 1
			end
		end
	end
	if event == "COMBAT_LOG_EVENT_UNFILTERED" then
		local _, type, _, sourceGUID, sourceName, _, _, destGUID, destName, destFlags = ...
		local spellId, spellName = select(12, ...)
		
		if type == "SPELL_AURA_REMOVED" then
			for _, ccontrol in pairs(SN.crowdcontrol) do
				if ccontrol == spellId then
					local cc = self:Find("SN:arg2", spellId)
					if cc ~= nil then
						cc:Stop()
					end
				end
			end
		end
		if type == "SPELL_AURA_BROKEN_SPELL" or type == "SPELL_AURA_BROKEN" then
			if SN:GroupType() > 0 and SN.RaidMemberData ~= nil then	
				if destGUID and bit.band(destFlags, COMBATLOG_OBJECT_REACTION_FRIENDLY) == 0 then
					local cc = self:Find("SN:arg2", spellId)
					if cc then
						--if SN.data.profile.cc.announce then
						--	if SN.RaidMemberData[sourceGUID]["spec_role"] ~= "TANK" then
						--		local bit = false
						--		if SN:GroupType() == 2 then
						--			bit = true
						--		elseif SN:GroupType() == 1 then
						--			bit = false
						--		end
						--		SN:Announcer(self, nil, spellId, sourceName, destName, bit)
						--	end
						--end
						cc:Stop()
					end
				end
			end
		end
	end
end