------------------------------------------------------------------------------------------
--Cooldown Group Frame--------------------------------------------------------------------
------------------------------------------------------------------------------------------
local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")
local MODNAME = "cooldown"
local CD = SN:NewModule(MODNAME, "AceEvent-3.0", "AceTimer-3.0", "AceComm-3.0", "AceSerializer-3.0")

local IsAddOnLoaded = IsAddOnLoaded
local IsInRaid = IsInRaid
local CLASS_SORT_ORDER = CLASS_SORT_ORDER
local NORMAL_FONT_COLOR = NORMAL_FONT_COLOR
local GameFontNormal = GameFontNormal
local UnitInParty = UnitInParty
local UnitInRaid = UnitInRaid
local UnitGUID = UnitGUID
local IsInGroup = IsInGroup
local LE_PARTY_CATEGORY_INSTANCE = LE_PARTY_CATEGORY_INSTANCE
local GetSpecialization = GetSpecialization
local GetInspectSpecialization = GetInspectSpecialization
local GetNumGroupMembers = GetNumGroupMembers
local GetSpellCooldown = GetSpellCooldown
local GetSpellInfo = GetSpellInfo
local IsInInstance = IsInInstance
local pairs = pairs
local unpack = unpack
local select = select
local strsub = strsub
local strconcat = strconcat
local strlower = strlower
local wipe = wipe

local wiper = false

local cooldown
local cooldowns

local function getOptions()
	cooldown = {
		type = "group",
		name = L["Cooldowns"],
		args = {
			enable = {
				order = 0,
				type = "toggle",
				name = L["Enable Cooldowns"],
				get = function(info)
					return SN.data.profile.cooldown[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.cooldown[info[#info]] = value
					if value then
						SN:EnableModule(MODNAME)
					else
						SN:DisableModule(MODNAME)
					end
				end,
			},
			castannounce = {
				type = "toggle",
				name = L["Announce Casts"],
				desc = L["You will only announce if you are the Raid Leader or Raid Assistant"],
				hidden = function() return not SN.data.profile.cooldown.enable end,
				order = 1,
				get = function(info)
					return SN.data.profile.cooldown[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.cooldown[info[#info]] = value
				end,
			},
			raid = {
				order = 2,
				name = L["Raid Cooldowns"],
				desc = L["Uncheck to show only your personal CD's"],
				hidden = function() return not SN.data.profile.cooldown.enable end,
				type = "toggle",
				get = function(info)
					return SN.data.profile.cooldown[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.cooldown[info[#info]] = value
				end,
			},
			visible = {
				type = "range",
				name = L["Number of CD Bars Visible"],
				hidden = function() return not SN.data.profile.cooldown.enable end,
				order = 3,
				min = 1, max = 25, step = 1,
				get = function(info)
					return SN.data.profile.cooldown[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.cooldown[info[#info]] = value
					F.cooldowns:SetVisibleBars(value)
				end,
			},
			h3 = {
				order = 4,
				type = "header",
				name = "Dimensions",
				hidden = function() return not SN.data.profile.cooldown.enable end,
			},
			width = {
				type = "range",
				name = L["Width of CD Bars"],
				hidden = function() return not SN.data.profile.cooldown.enable end,
				order = 6,
				min = 12, max = 500, step = 1,
				get = function(info)
					return SN.data.profile.cooldown[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.cooldown[info[#info]] = value
					F.cooldowns:SetWidth(value)
				end,
			},
			height = {
				type = "range",
				name = L["Height of CD Bars"],
				hidden = function() return not SN.data.profile.cooldown.enable end,
				order = 7,
				min = 12, max = 40, step = 1,
				get = function(info)
					return SN.data.profile.cooldown[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.cooldown[info[#info]] = value
					if F.cooldowns.bars ~= nil then
						local bars = F.cooldowns.bars
						for i in pairs(bars) do
							i:SetHeight(value)
						end
					end
				end,
			},
			yoffset = {
				type = "range",
				name = L["Y Offset of CD Bars"],
				hidden = function() return not SN.data.profile.cooldown.enable end,
				order = 7,
				min = 0, max = 6, step = 1,
				get = function(info)
					return SN.data.profile.cooldown[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.cooldown[info[#info]] = value
					F.cooldowns:SetSpacing(SN.data.profile.cooldown.xoffset, value)
				end,
			},
			h4 = {
				order = 9,
				type = "header",
				name = "Font",
				hidden = function() return not SN.data.profile.cooldown.enable end,
			},
			font = {
				type = "select",
				dialogControl = 'LSM30_Font',
				name = L["Font"],
				hidden = function() return not SN.data.profile.cooldown.enable end,
				order = 12,
				values = AceGUIWidgetLSMlists.font,
				get = function(info) return SN.data.profile.cooldown[info[#info]] end,--selectedClass end,
				set = function(info, value)
					SN.data.profile.cooldown[info[#info]] = value
					if F.cooldowns.bars ~= nil then
						local bars = F.cooldowns.bars
						for i in pairs(bars) do
							i:SetLabelFont(LSM:Fetch("font", value), SN.data.profile.cooldown.fontsize)
							i:SetDurationFont(LSM:Fetch("font", value), SN.data.profile.cooldown.fontsize)
						end
					end
				end,
			},
			fontsize = {
				type = "range",
				name = L["Font Size of CD Bars"],
				hidden = function() return not SN.data.profile.cooldown.enable end,
				order = 13,
				min = 10, max = 24, step = 1,
				get = function(info)
					return SN.data.profile.cooldown[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.cooldown[info[#info]] = value
					if SN.data.profile.cooldown.iconmode then
						F.cooldowns:SetSpacing(SN.data.profile.cooldown.fontsize / 2, SN.data.profile.cooldown.fontsize + 3)
					end
					if F.cooldowns.bars ~= nil then
						local bars = F.cooldowns.bars
						for i in pairs(bars) do
							i:SetLabelFont(LSM:Fetch("font", SN.data.profile.cooldown.font), value)
							i:SetDurationFont(LSM:Fetch("font", SN.data.profile.cooldown.font), value)
						end
					end
				end,
			},
			h5 = {
				order = 15,
				type = "header",
				name = L["Texture/Misc"],
				hidden = function() return not SN.data.profile.cooldown.enable end,
			},
			texture = {
				type = "select",
				dialogControl = 'LSM30_Statusbar',
				hidden = function() return not SN.data.profile.cooldown.enable end,
				name = L["Texture"],
				order = 18,
				values = AceGUIWidgetLSMlists.statusbar,
				get = function(info) return SN.data.profile.cooldown[info[#info]] end,
				set = function(info, value)
					SN.data.profile.cooldown[info[#info]] = value
					if F.cooldowns.bars ~= nil then
						local bars = F.cooldowns.bars
						for i in pairs(bars) do
							i:SetTexture(LSM:Fetch("statusbar", value))
						end
					end
				end,
			},
			grow = {
				type = "select",
				name = L["Grow Direction"],
				hidden = function() return not SN.data.profile.cooldown.enable end,
				order = 19,
				values = {
					["topleft"] = "Up",
					["bottomleft"] = "Down",
				},
				get = function(info)
					return SN.data.profile.cooldown[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.cooldown[info[#info]] = value
					F.cooldowns:SetStartPoint(value)
				end,
			},
			iconmode = {
				type = "toggle",
				name = L["Turn on Icon Mode"],
				hidden = function() return not SN.data.profile.cooldown.enable end,
				order = 21,
				get = function(info)
					return SN.data.profile.cooldown[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.cooldown[info[#info]] = value
					if value then
						F.cooldowns:SetIconMode(32 * SN.data.profile.cooldown.iconscale, "BOTTOM", 0, 0)
						F.cooldowns:SetSpacing(SN.data.profile.cooldown.fontsize / 2, SN.data.profile.cooldown.fontsize + 3)
					else
						F.cooldowns:SetIconMode(false)
						F.cooldowns:SetSpacing(0, 3)
						F.cooldowns:SetWidth(SN.data.profile.cooldown.width)
						if F.cooldowns.bars ~= nil then
							local bars = F.cooldowns.bars
							for i in pairs(bars) do
								i:SetHeight(SN.data.profile.cooldown.height)
							end
						end
					end
				end,
			},
			iconscale = {
				type = "range",
				name = L["Icon Scale"],
				order = 22,
				min = 0.1, max = 2.0, step = 0.1,
				hidden = function() return not SN.data.profile.cooldown.iconmode or not SN.data.profile.cooldown.enable end,
				get = function(info)
					return SN.data.profile.cooldown[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.cooldown[info[#info]] = value
					if SN.data.profile.cooldown.iconmode then
						F.cooldowns:SetIconMode(32 * SN.data.profile.cooldown.iconscale, "BOTTOM", 0, 0)
						F.cooldowns:SetSpacing(SN.data.profile.cooldown.fontsize / 3, SN.data.profile.cooldown.fontsize + 3)
					end
				end,
			},
		},
	}
	return cooldown
end

local function getOptions2()
	cooldowns = {
		type = "group",
		name = L["CD List"],
		args = {
			enableall = {
				name = L["Enable All CD's"],
				type = "execute",
				order = 0,
				func = function()
					for i, cd in pairs(SN.char.profile.cooldowns) do
						cd.enable = true
					end
				end,
				width = "normal",
			},
			disableall = {
				name = L["Disable All CD's"],
				type = "execute",
				order = 1,
				func = function()
					for i, cd in pairs(SN.char.profile.cooldowns) do
						cd.enable = false
					end
				end,
				width = "normal",
			},
			selectClass = {
				name = L["Select Class"],
				type = "select",
				order = 4,
				values = function()
					local values = { } 
					for _, class in pairs(CLASS_SORT_ORDER) do
						local class1 = strsub(class, 1, 1)
						class1 = strconcat(class1, strlower(strsub(class, 2)))
						values[class] = class1
					end
					return values
				end,
				get = function(info) return SN.data.profile.classSelect.default end,--selectedClass end,
				set = function(info, value)
					--selectedClass = value
					SN.data.profile.classSelect.default = value
				end,
			},
			h6 = {
				order = 7,
				type = "header",
				name = "",
			},
			selectSpell = {
				name = L["Select Spell"],
				type = "multiselect",
				order = 10,						
				values = function()
					local values = {}
					for _, spell in pairs(SN.char.profile.cooldowns) do
						if SN.data.profile.classSelect.default == spell.class then--selectedClass == spell.class then
							local name, _, icon = GetSpellInfo(spell.id)
							if spell.id == 86698 then
								name = name.."(Ret)"
							elseif spell.id == 86669 then
								name = name.."(Holy)"
							elseif spell.id == 86659 then
								name = name.."(Prot)"
							end
							values[spell.id] = name
						end
					end
					return values
				end,
				get = function(info, spid) 
					for _, spell in pairs(SN.char.profile.cooldowns) do
						if spid == spell.id then
							return spell.enable
						end
					end
				end,
				set = function(info, spid, value)
					for _, spell in pairs(SN.char.profile.cooldowns) do
						if spid == spell.id then
							spell.enable = value
						end
					end
				end,
			},
		},
	}
	return cooldowns
end

function CD:OnInitialize()
	SN:RegisterModuleOptions(MODNAME..1, getOptions, L["Cooldowns"])
	SN:RegisterModuleOptions(MODNAME..2, getOptions2, L["CD List"])

	if not SN.data.profile.installed then
		for _, spell in pairs(SN.char.profile.cooldowns) do
			if SN.playerClass == spell.class then
				spell.enable = true
			end
		end
		SN.data.profile.installed = true
	end

	F.cooldowns = T:NewGroup(SN.data.profile.cooldown.width, "CD Frame", "cooldowns", M.media.draghandle)
	F.cooldowns:SetSorting("SN:arg4", false)
	F.cooldowns:SetSpacing(0, SN.data.profile.cooldown.yoffset)
	F.cooldowns:SetStartPoint(SN.data.profile.cooldown.grow)
	F.cooldowns:SetPoint(unpack(SN.data.profile.frames.cooldown))
	F.cooldowns:SetVisibleBars(SN.data.profile.cooldown.visible)
	
	local color = NORMAL_FONT_COLOR

	--The mover frame text
	F.cooldowns.value = F.cooldowns:CreateFontString(nil, "OVERLAY")
	F.cooldowns.value:SetPoint("CENTER", F.cooldowns)
	F.cooldowns.value:SetFontObject(GameFontNormal)
	F.cooldowns.value:SetJustifyH("CENTER")
	F.cooldowns.value:SetTextColor(color.r, color.g, color.b)

	F.cooldowns.name = "Cooldowns"
	F.cooldowns.db = MODNAME

	if SN.data.profile.cooldown.iconmode then
		F.cooldowns:SetIconMode(32 * SN.data.profile.cooldown.iconscale, "BOTTOM", 0, 0)
		F.cooldowns:SetSpacing(SN.data.profile.cooldown.fontsize / 2, SN.data.profile.cooldown.fontsize + 3)
	end
	F.cooldowns:SetScript("OnEvent", function(self, event, ...)
		CD:CooldownEvents(self, event, ...)
	end)
	
end

function CD:OnEnable()
	F.cooldowns:Show()
	--Register our events for the frame
	F.cooldowns:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	F.cooldowns:RegisterEvent("SPELL_UPDATE_USABLE")
	F.cooldowns:RegisterEvent("GROUP_ROSTER_UPDATE")
	F.cooldowns:RegisterEvent("ENCOUNTER_END")
	CD:RegisterComm("SNCooldown", "OnCommCooldown")
end

function CD:OnDisable()
	
	F.cooldowns:UnregisterAllEvents()
	F.cooldowns:Clear()
	F.cooldowns:Hide()
end

function CD:Lock()
	SN:LockFrame(F.cooldowns)
	--F.cooldowns:Lock(true)
	--SN.data.profile.frames.cooldown = { SN:GetPoint(F.cooldowns) }
end

function CD:Unlock()
	SN:UnlockFrame(F.cooldowns)
	--F.cooldowns:Lock(false)
end

function CD:Reset()
	local static = SN.DB.profile.frames
	local temp = SN.data.profile.frames
	F.cooldowns:ClearAllPoints()

	F.cooldowns:SetPoint(unpack(static.cooldown))
	wipe(temp.cooldown)
end

function CD:ApplySettings()
	F.cooldowns:ClearAllPoints()
	SN:EditBars(F.cooldowns.db)
end

function CD:Cooldown(spellId, sourceGUID)
	local cd = SN.char.profile.cooldowns[spellId].CD
	if SN.RaidMemberData ~= nil and SN:GroupType() > 0 then
		if spellId == 740 and SN.RaidMemberData[sourceGUID] then
			if SN.RaidMemberData[sourceGUID].spec_index == 4 then
				cd = 180
			end
		end
	elseif SN.playerClass == "DRUID" and GetSpecialization() == 4 then
		cd = 180
	--elseif sourceGUID == SN.playerGUID then
	--	cd = select(2, GetSpellCooldown(spellId))
	--	if cd == nil then
	--		cd = SN.data.profile.cooldowns[spellId].CD
	--	end
	end
	return cd
end

function CD:CooldownEvents(self, event, ...)
	if event == "COMBAT_LOG_EVENT_UNFILTERED" then
		local _, type, _, sourceGUID, sourceName, _, _, destGUID, destName = ...
		local spellId, spellName = select(12, ...)

		if type == "SPELL_CAST_SUCCESS" then
			--Check to see if the cd is in our DB and also if it is enabled
			if SN.char.profile.cooldowns[spellId] then

				local srcName = sourceName:gsub("^(.*)%-.*$", "%1")
				local cd = CD:Cooldown(spellId, sourceGUID)
				local distro
				local groupType = SN:GroupType()
				if groupType > 0 then
					if IsInGroup(LE_PARTY_CATEGORY_INSTANCE) then
						distro = "INSTANCE_CHAT"
					else
						distro = "RAID"
					end
				else
					distro = "WHISPER"
				end
				 
				if srcName == SN.playerName then
					if distro == "WHISPER" then
						CD:SendCommMessage("SNCooldown", CD:Serialize(srcName, sourceGUID, spellId, cd), distro, SN.playerName)
					else
						CD:SendCommMessage("SNCooldown", CD:Serialize(srcName, sourceGUID, spellId, cd), distro)
					end
				elseif groupType > 0 and SN.data.profile.cooldown.raid and (UnitInParty(srcName) or UnitInRaid(srcName)) then
					CD:OnCommCooldown("SNCooldown", CD:Serialize(srcName, sourceGUID, spellId, cd), distro)
				end
			end
		end
		--if type == "UNIT_DIED" or type == "UNIT_DESTROYED" then
		--	--Check for a wipe so we can kill the cooldown bars
		--	local zoneType = select(2, IsInInstance())	
		--	if SN:GroupType() == 2 and zoneType == "raid" and not wiper then
		--		wiper = true
		--		self.WipeCheck = CD:ScheduleRepeatingTimer("CheckForWipe", 10, self)
		--	end
		--end
	end
	if event == "SPELL_UPDATE_USABLE" then
		--Remove CD bars if the spell becomes usable sooner because of some event.
		for i, bars in pairs(self.bars) do
			if i:GetData("SN:arg4") == SN.playerName then
				local startTime, duration, enable = GetSpellCooldown(i:GetData("SN:arg2"))
				if not duration then
					i:Stop()
				end
			end
		end
	end
	if event == "ENCOUNTER_END" then
		for i, bar in pairs(self.bars) do
			if i:GetData("SN:arg7") > 299 then
				i:Stop()
			end
		end
	end
	if event == "GROUP_ROSTER_UPDATE" then
		for i, bar in pairs(self.bars) do
			if not SN.RaidMemberData[i:GetData("SN:arg3")] then
				i:Stop()
			end
		end
	end
end
--Let's see if it's a wipe
--function CD:CheckForWipe(self)
--	local wipe = true

--	if IsEncounterInProgress() then
--		wipe = false
--	else
--		for i = 1, #SN.RaidMemberData do
--			if UnitAffectingCombat("raid"..i) == 1 and UnitIsDeadOrGhost("raid"..i) ~= 1 then
--				wipe = false
--				break
--			end
--		end
--	end
--	if wipe then
--		for i, bar in pairs(self.bars) do
--			if i:GetData("SN:arg7") > 299 then
--				i:Stop()
--			end
--		end
--	end
--	wiper = false
--	CD:CancelTimer(self.WipeCheck)
--end

function CD:DelayCD(args)
	SN:CreateBar(unpack(args))
end

function CD:OnCommCooldown(prefix, message, distribution, sender)
	if prefix ~= "SNCooldown" then return end
	local success, sourceName, sourceGUID, spellId, cd = CD:Deserialize(message)
	local group = F.cooldowns
	--Work around to stop the auto killing of CD bars for spells that don't go on CD until the effect wears off
	if SN.char.profile.cooldowns[spellId].enable then
		if SN.char.profile.cooldowns[spellId].delay ~= nil and sender == SN.playerName then
			local cd = cd - SN.char.profile.cooldowns[spellId].delay
			local args = { group, spellId, cd, sourceName, sourceGUID, GetSpellInfo(spellId) }
			CD:ScheduleTimer("DelayCD", SN.char.profile.cooldowns[spellId].delay, args)
		elseif SN.char.profile.cooldowns[spellId].delay ~= nil and sender ~= SN.playerName and SN:GroupType() > 0 then
			local cd = cd - SN.char.profile.cooldowns[spellId].delay
			local args = { group, spellId, cd, sourceName, sourceGUID, GetSpellInfo(spellId) }
			CD:ScheduleTimer("DelayCD", SN.char.profile.cooldowns[spellId].delay, args)
		else
			SN:CreateBar(group, spellId, cd, sourceName, sourceGUID, GetSpellInfo(spellId))
		end
		if SN.data.profile.cooldown.castannounce then
			local bit
			if SN:GroupType() >= 2 then
				bit = true
			else
				bit = false
			end
			SN:Announcer(group, cd, spellId, sourceName, nil, bit)
		end
	end
end