------------------------------------------------------------------------------------------
--Setup the Class Power-------------------------------------------------------------------
------------------------------------------------------------------------------------------
local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")
local MODNAME = "classResources"
local CP = SN:NewModule(MODNAME, "AceEvent-3.0")

local UnitHasVehicleUI = UnitHasVehicleUI
local IsAddOnLoaded = IsAddOnLoaded
local unpack = unpack
local wipe = wipe

local classResources

local function getOptions()
	classResources = {
		type = "group",
		name = L["Class Power"],
		args = {
			enable = {
				order = 0,
				type = "toggle",
				name = L["Enable Class Power"],
				get = function(info)
					return SN.data.profile.classResources[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.classResources[info[#info]] = value
					if value then
						SN:EnableModule(MODNAME)
					else
						SN:DisableModule(MODNAME)
					end
					if (IsAddOnLoaded("ElvUI")) then
						SN:ElvOverride()
					end
				end,
						
			},
			orientation = {
				order = 1,
				type = "select",
				name = L["Rune Fill Direction"],
				values = {
					["HORIZONTAL"] = "HORIZONTAL",
					["VERTICAL"] = "VERTICAL",
				},
				hidden = function() return SN.playerClass ~= "DEATHKNIGHT" or
						not SN.data.profile.classResources.enable end,
				get = function(info)
					return SN.data.profile.classResources[info[#info]]
				end,
				set = function(info, value)
					for i = 1, 6 do
						F.classpower.runes[i]:SetOrientation(value)
					end
					SN.data.profile.classResources[info[#info]] = value							
				end,
			},
			h = {
				order = 2,
				type = "header",
				name = "Dimensions",
				hidden = function() return not SN.data.profile.classResources.enable end,
			},
			width = {
				type = "range",
				name = L["Width of Class Power"],
				hidden = function() return not SN.data.profile.classResources.enable end,
				order = 4,
				min = 10, max = 500, step = 1,
				get = function(info)
					return SN.data.profile.classResources[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.classResources[info[#info]] = value
					CP:ApplySettings()
				end,
			},
			height = {
				type = "range",
				name = L["Height of Class Power"],
				hidden = function() return not SN.data.profile.classResources.enable end,
				order = 5,
				min = 10, max = 100, step = 1,
				get = function(info)
					return SN.data.profile.classResources[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.classResources[info[#info]] = value
					CP:ApplySettings()
				end,
			},
			texture = {
				type = "select",
				dialogControl = 'LSM30_Statusbar',
				name = L["Texture"],
				hidden = function() return not SN.data.profile.classResources.enable end,
				order = 14,
				values = AceGUIWidgetLSMlists.statusbar,
				get = function(info) return SN.data.profile.classResources[info[#info]] end,
				set = function(info, value)
					SN.data.profile.classResources[info[#info]] = value
					CP:ApplySettings()
				end,
			},
		},
	}
	return classResources
end

function CP:OnInitialize()
	if SN.playerClass == "HUNTER" or SN.playerClass == "SHAMAN" or SN.playerClass == "WARRIOR" or SN.playerClass == "MAGE" then
		CP:SetEnabledState(false)
		SN.data.profile.classResources.enable = false
		SN.data.profile.classResources.classpowerclass = false
	else
		SN:RegisterModuleOptions(MODNAME, getOptions, L["Class Power"])
		
		SN.data.profile.classResources.classpowerclass = true

		F.classpower = SN:CreateFrame("Class Power", MODNAME, UIParent)

		F.classpower:SetScript("OnEvent", function(self, event, ...)
			if event == "PLAYER_ENTERING_WORLD" then
				if SN.data.profile.classResources.enable then
					for name, module in CP:IterateModules() do
						CP:EnableModule(name)
					end
				else
					for name, module in CP:IterateModules() do
						CP:DisableModule(name)
					end
					F.classpower:Hide()
					F.classpower:UnregisterAllEvents()
				end
				
				self:UnregisterEvent("PLAYER_ENTERING_WORLD")
			end
			if UnitHasVehicleUI("player") and SN.data.profile.classResources.enable then
				self:Hide()
			else
				self:Show()
			end
		end)
		F.classpower:RegisterEvent("PLAYER_ENTERING_WORLD")
		F.classpower:Hide()
	end
	
end

function CP:OnEnable()
	if SN.data.profile.classResources.classpowerclass then
		F.classpower:Show()
		F.classpower:RegisterEvent("UNIT_DISPLAYPOWER")
		F.classpower:RegisterUnitEvent("UNIT_ENTERED_VEHICLE", "player")
		F.classpower:RegisterUnitEvent("UNIT_EXITED_VEHICLE", "player")
		
		for name, module in CP:IterateModules() do
			CP:EnableModule(name)
		end
	end
end

function CP:OnDisable()
	if SN.data.profile.classResources.classpowerclass then
		F.classpower:UnregisterAllEvents()
		for name, module in CP:IterateModules() do
			CP:DisableModule(name)
		end
		F.classpower:Hide()
	end
end

function CP:Lock()
	if SN.data.profile.classResources.enable and SN.data.profile.classResources.classpowerclass then
		SN:LockFrame(F.classpower)
		for name, module in CP:IterateModules() do
			module:Lock()
		end
	end
end

function CP:Unlock()
	if SN.data.profile.classResources.enable and SN.data.profile.classResources.classpowerclass then
		SN:UnlockFrame(F.classpower)
		for name, module in CP:IterateModules() do
			module:Unlock()
		end
	end
end

function CP:Reset()
	if SN.data.profile.classResources.enable and SN.data.profile.classResources.classpowerclass then
		local static = SN.DB.profile.frames
		local temp = SN.data.profile.frames
		F.classpower:ClearAllPoints()

		F.classpower:SetPoint(unpack(static.classResources))
		wipe(temp.classResources)
		
	end
end

function CP:ApplySettings()
	if SN.data.profile.classResources.enable and SN.data.profile.classResources.classpowerclass then
		F.classpower:SetPoint(unpack(SN.data.profile.frames.classResources))
		F.classpower:SetSize(SN.data.profile.classResources.width, SN.data.profile.classResources.height)
		for name, module in CP:IterateModules() do
			module:ApplySettings()
		end
		if IsAddOnLoaded("ElvUI") then
			SN:ScheduleTimer("ElvOverride", 5)
		end
	end
end

function CP:PowerBubbles(maxbub)
	local frame = CreateFrame("Frame", nil, F.classpower)
	frame:SetSize(SN.data.profile.classResources.width, SN.data.profile.classResources.height)
	frame:SetPoint("CENTER", F.classpower, "CENTER", 0, 0)
	frame.maxbub = maxbub

	SN:CreateBackDrop(frame)

	for i = 1, maxbub do
		frame[i] = CreateFrame("StatusBar", nil, frame)
		frame[i]:SetSize(CP:ReturnBubSize(frame))
		if i == 1 then
			frame[i]:SetPoint("LEFT", frame, 1, 0)
		else
			frame[i]:SetPoint("LEFT", frame[(i - 1)], "RIGHT", 1, 0)
		end
		
		frame[i]:SetStatusBarTexture(LSM:Fetch("statusbar", SN.data.profile.classResources.texture))
		frame[i]:GetStatusBarTexture():SetHorizTile(false)
		frame[i]:SetMinMaxValues(0, 1)
		frame[i]:SetValue(1)
	end
	return frame
end

function CP:ReturnBubSize(self)
	local width = (SN.data.profile.classResources.width - (self.maxbub + 1)) / self.maxbub
	local height = SN.data.profile.classResources.height - 2

	return width, height
end