------------------------------------------------------------------------------------------
--Buff Frame Setup-------------------------------------------------------------
------------------------------------------------------------------------------------------
local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")
local MODNAME = "buffs"
local BUFF = SN:NewModule(MODNAME, "AceEvent-3.0")

local timers = LibStub("LibFancyBar-1.0")

local UnitBuff = UnitBuff
local SHOW_CASTABLE_BUFFS = SHOW_CASTABLE_BUFFS
local GetTime = GetTime
local UnitGUID = UnitGUID
local NORMAL_FONT_COLORS = NORMAL_FONT_COLORS
local GameFontNormal = GameFontNormal
local pairs = pairs
local wipe = wipe
local unpack = unpack

local buffs

local function getOptions()
	buffs = {
		type = "group",
		name = L["Buffs"],
		args = {
			enable = {
				order = 0,
				type = "toggle",
				name = L["Enable Buff Bars"],
				get = function(info)
					return SN.data.profile.buffs[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.buffs[info[#info]] = value

					if value then
						SN:EnableModule(MODNAME)
					else
						SN:DisableModule(MODNAME)
					end
				end,
			},
			visible = {
				order = 1,
				type = "range",
				name = L["Number of Buff Bars Visible"],
				hidden = function() return not SN.data.profile.buffs.enable end,
				min = 1, max = 8, step = 1,
				get = function(info)
					return SN.data.profile.buffs[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.buffs[info[#info]] = value
					F.buffs:SetVisibleBars(value)
				end,
			},
			h7 = {
				order = 2,
				type = "header",
				name = "Dimensions",
				hidden = function() return not SN.data.profile.buffs.enable end,
			},
			width = {
				order = 4,
				type = "range",
				name = L["Width of Buff Bars"],
				hidden = function() return not SN.data.profile.buffs.enable end,
				min = 50, max = 500, step = 1,
				get = function(info)
					return SN.data.profile.buffs[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.buffs[info[#info]] = value
					F.buffs:SetWidth(value)
				end,
			},
			height = {
				order = 5,
				type = "range",
				name = L["Height of Buff Bars"],
				hidden = function() return not SN.data.profile.buffs.enable end,
				min = 12, max = 40, step = 1,
				get = function(info)
					return SN.data.profile.buffs[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.buffs[info[#info]] = value
					if F.buffs.bars ~= nil then
						local bars = F.buffs.bars
						for i in pairs(bars) do
							i:SetHeight(value)
						end
					end
				end,
			},
			yoffset = {
				order = 6,
				type = "range",
				name = L["Y Offset of Buff Bars"],
				hidden = function() return not SN.data.profile.buffs.enable end,
				order = 7,
				min = 0, max = 6, step = 1,
				get = function(info)
					return SN.data.profile.buffs[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.buffs[info[#info]] = value
					F.buffs:SetSpacing(SN.data.profile.buffs.yoffset, value)
				end,
			},
			h8 = {
				order = 8,
				type = "header",
				name = "Font",
				hidden = function() return not SN.data.profile.buffs.enable end,
			},
			font = {
				order = 9,
				type = "select",
				dialogControl = 'LSM30_Font',
				name = L["Font"],
				hidden = function() return not SN.data.profile.buffs.enable end,
				values = AceGUIWidgetLSMlists.font,
				get = function(info) return SN.data.profile.buffs[info[#info]] end,--selectedClass end,
				set = function(info, value)
					SN.data.profile.buffs[info[#info]] = value
					if F.buffs.bars ~= nil then
						local bars = F.buffs.bars
						for i in pairs(bars) do
							i:SetLabelFont(LSM:Fetch("font", value), SN.data.profile.buffs.fontsize)
							i:SetDurationFont(LSM:Fetch("font", value), SN.data.profile.buffs.fontsize)
						end
					end
				end,
			},
			fontsize = {
				order = 10,
				type = "range",
				name = L["Font Size of Buff Bars"],
				hidden = function() return not SN.data.profile.buffs.enable end,
				min = 10, max = 24, step = 1,
				get = function(info)
					return SN.data.profile.buffs[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.buffs[info[#info]] = value
					if F.buffs.bars ~= nil then
						local bars = F.buffs.bars
						for i in pairs(bars) do
							i:SetLabelFont(LSM:Fetch("font", SN.data.profile.buffs.font), value)
							i:SetDurationFont(LSM:Fetch("font", SN.data.profile.buffs.font), value)
						end
					end
				end,
			},
			h9 = {
				order = 11,
				type = "header",
				name = L["Texture/Misc"],
				hidden = function() return not SN.data.profile.buffs.enable end,
			},
			texture = {
				order = 12,
				type = "select",
				dialogControl = 'LSM30_Statusbar',
				name = L["Texture"],
				hidden = function() return not SN.data.profile.buffs.enable end,
				values = AceGUIWidgetLSMlists.statusbar,
				get = function(info) return SN.data.profile.buffs[info[#info]] end,
				set = function(info, value)
					SN.data.profile.buffs[info[#info]] = value
					if F.buffs.bars ~= nil then
						local bars = F.buffs.bars
						for i in pairs(bars) do
							i:SetTexture(LSM:Fetch("statusbar", value))
						end
					end
				end,
			},
			grow = {
				order = 13,
				type = "select",
				name = L["Grow Direction"],
				hidden = function() return not SN.data.profile.buffs.enable end,
				values = {
					["topleft"] = "Up",
					["bottomleft"] = "Down",
				},
				get = function(info)
					return SN.data.profile.buffs[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.buffs[info[#info]] = value
					F.buffs:SetStartPoint(value)
				end,
			},
			iconmode = {
				order = 14,
				type = "toggle",
				name = L["Turn on Icon Mode"],
				hidden = function() return not SN.data.profile.buffs.enable end,
				get = function(info)
					return SN.data.profile.buffs[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.buffs[info[#info]] = value
					if value then
						F.buffs:SetIconMode(32 * SN.data.profile.buffs.iconscale, "BOTTOM", 0, 0)
						F.buffs:SetSpacing(SN.data.profile.buffs.fontsize / 2, SN.data.profile.buffs.fontsize + 3)
					else
						F.buffs:SetIconMode(false)
						F.buffs:SetSpacing(0, 3)
						F.buffs:SetWidth(SN.data.profile.buffs.width)
						if F.buffs.bars ~= nil then
							local bars = F.buffs.bars
							for i in pairs(bars) do
								i:SetHeight(SN.data.profile.buffs.height)
							end
						end
					end
				end,
			},
			iconscale = {
				order = 15,
				type = "range",
				name = L["Icon Scale"],
				min = 0.1, max = 2.0, step = 0.1,
				hidden = function() return not SN.data.profile.buffs.iconmode or not SN.data.profile.buffs.enable end,
				get = function(info)
					return SN.data.profile.buffs[info[#info]] 
				end,
				set = function(info, value)
					SN.data.profile.buffs[info[#info]] = value
					if SN.data.profile.buffs.iconmode then
						F.buffs:SetIconMode(32 * SN.data.profile.buffs.iconscale, "BOTTOM", 0, 0)
						F.buffs:SetSpacing(SN.data.profile.buffs.fontsize / 3, SN.data.profile.buffs.fontsize + 3)
					end
				end,
			},
		},
	}
	return buffs
end

local function KillBar(self, event, ...)
	local spellName

	spellName = self:GetData("SN:arg5")

	if not spellName then return end

	local name = UnitBuff("player", self:GetData("SN:arg5"))

	if not name then self:Stop() return end
end

local function buffUpdate(self, event, ...)
	if event == "PLAYER_ENTERING_WORLD" then
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
	end

	--Update Buffs
	local buff
	local name, rank, icon, count, debuffType, duration, expiration, caster, canStealOrPurge, spellId, _

	local filter
	if SHOW_CASTABLE_BUFFS == "1" then
		filter = "RAID"
	end
	
	if self.bars then
		for k, v in pairs(self.bars) do
			local buff = UnitBuff("player", k:GetData("SN:arg5"))

			if not buff then
				k:Stop()
			end
		end
	end

	local i = 1
	while true do
		name, rank, icon, count, debuffType, duration, expiration, caster, canStealOrPurge, _ , spellId = UnitBuff("player", i, filter)
		
		if not name then break end
		
		buff = self:Find("SN:arg5", name)
		
		if not buff then
			if duration ~= 0 and expiration ~= 0 then
				if duration <= 300 then
					buff = SN:CreateBar(self, spellId, (expiration - GetTime()), caster, UnitGUID("target"), name)
				end
			end
		end
		if buff then
			buff:SetDuration((expiration - GetTime()), duration)
			buff:Start()
			
			buff:RegisterEvent("UNIT_AURA", KillBar)
		end
		i = i + 1
	end
end

function BUFF:OnInitialize()

	SN:RegisterModuleOptions(MODNAME, getOptions, L["Buffs"])
	
	F.buffs = T:NewGroup(SN.data.profile.buffs.width, "Buff Frame", "buffs", M.media.draghandle)
	F.buffs:SetSorting("time", true)
	F.buffs:SetSpacing(0, SN.data.profile.buffs.yoffset)
	F.buffs:SetStartPoint(SN.data.profile.buffs.grow)
	F.buffs:SetPoint(unpack(SN.data.profile.frames.buffs))
	F.buffs:SetVisibleBars(SN.data.profile.buffs.visible)
	
	local color = NORMAL_FONT_COLOR

	--The mover frame text
	F.buffs.value = F.buffs:CreateFontString(nil, "OVERLAY")
	F.buffs.value:SetPoint("CENTER", F.buffs)
	F.buffs.value:SetFontObject(GameFontNormal)
	F.buffs.value:SetJustifyH("CENTER")
	F.buffs.value:SetTextColor(color.r, color.g, color.b)

	F.buffs.name = "Buffs"
	F.buffs.db = MODNAME

	if SN.data.profile.buffs.iconmode then
		F.buffs:SetIconMode(32 * SN.data.profile.buffs.iconscale, "BOTTOM", 0, 0)
		F.buffs:SetSpacing(SN.data.profile.buffs.fontsize / 2, SN.data.profile.buffs.fontsize + 3)
	end
	
	F.buffs:SetScript("OnEvent", function(self, event, ...)
		buffUpdate(self, event, ...)
	end)
end

function BUFF:OnEnable()
	F.buffs:Show()		
	--Register our events for the frame
	F.buffs:RegisterUnitEvent("UNIT_AURA", "player")
	F.buffs:RegisterEvent("PLAYER_ENTERING_WORLD")
	F.buffs:RegisterEvent("UPDATE_SHAPESHIFT_FORMS")
	F.buffs:RegisterEvent("PLAYER_LEVEL_UP")
	F.buffs:RegisterEvent("PLAYER_TALENT_UPDATE")
	buffUpdate(F.buffs, nil, nil)
end

function BUFF:OnDisable()
	F.buffs:UnregisterAllEvents()
	F.buffs:Clear()
	F.buffs:Hide()
end

function BUFF:Lock()
	SN:LockFrame(F.buffs)
end

function BUFF:Unlock()
	SN:UnlockFrame(F.buffs)
end

function BUFF:Reset()
	local static = SN.DB.profile.frames
	local temp = SN.data.profile.frames
	F.buffs:ClearAllPoints()

	F.buffs:SetPoint(unpack(static.buffs))
	wipe(temp.buffs)
end

function BUFF:ApplySettings()
	F.buffs:ClearAllPoints()
	SN:EditBars(F.buffs.db)
end