------------------------------------------------------------------------------------------
-- Lust Say-------------------------------------------------------------------------------
------------------------------------------------------------------------------------------
local SN, L, F, T, M, _ = unpack(select(2,...))

local LSM = LibStub("LibSharedMedia-3.0")
local MODNAME = "bloodlust"
local LUST = SN:NewModule(MODNAME, "AceEvent-3.0")

local table = table
local select = select
local random = random

local UnitInParty = UnitInParty
local UnitInRaid = UnitInRaid
local SendChatMessage = SendChatMessage

local LustIDS = { 80353, 2825, 32182, 90355 }

local bloodlust
local selectedSaying
local alreadyYelled = false

local sayings = {
	"YOLO, so might as well bust out this swagtastic lust!",
	"Prepare to rustle some jimmies",
	"WHARRGARBL",
	"It's a tarp!",
	"Kill it with FiRE!",
	"Here's your Lusticles",
	"DPS harder than Katrina",
	"Let's play some Pony Adventure Quest",
	"It's ok, I'm a melee",
	"I don't have time for this, I work 400 hours a week",
	"Is that a lust in your pants or are you happy to see us",
}

local function getOptions()
	bloodlust = {
		type = "group",
		name = L["Bloodlust Yeller"],
		args = {
			enable = {
				type = "toggle",
				name = L["Enable Silly Bloodlust Yeller"],
				order = 0,
				get = function(info)
					return SN.data.profile.bloodlust[info[#info]]
				end,
				set = function(info, value)
					SN.data.profile.bloodlust[info[#info]] = value
					if value then
						SN:EnableModule(MODNAME)
					else
						SN:DisableModule(MODNAME)
					end
				end,
			},
			sayings = {
				type = "select",
				name = L["Select Saying"],
				order = 1,
				hidden = function() return not SN.data.profile.bloodlust.enable end,
				values = function()
					local values = { }
					for i = 1, #SN.data.profile.yelldb do
						values[i] = i
					end
					return values
				end,
				get = function(info) return selectedSaying end,
				set = function(info, value)
					selectedSaying = value
				end,
			},
			add = {
				name = L["Add Saying"],
				type = "execute",
				order = 2,
				hidden = function() return not SN.data.profile.bloodlust.enable end,
				func = function()
					table.insert(SN.data.profile.yelldb, "")
					selectedSaying = #SN.data.profile.yelldb
				end,
			},
			remove = {
				name = L["Remove Saying"],
				type = "execute",
				order = 3,
				hidden = function() return not SN.data.profile.bloodlust.enable end,
				func = function()
					table.remove(SN.data.profile.yelldb, selectedSaying)
				end,
			},
			editor = {
				type = "input",
				order = 4,
				name = L["Saying"],
				width = "full",
				hidden = function() return not SN.data.profile.bloodlust.enable end,
				get = function(info)
					return SN.data.profile.yelldb[selectedSaying]
				end,
				set = function(info, value)
					SN.data.profile.yelldb[selectedSaying] = value
				end,
			},
		},
	}
	return bloodlust
end

function LUST:OnInitialize()
	SN:RegisterModuleOptions(MODNAME, getOptions, L["Bloodlust Yeller"])	

	F.lust = CreateFrame("Frame")
	F.lust:SetScript("OnEvent", function(self, event, ...)
		LUST:EventHandler(self, event, ...)
	end)
end

function LUST:OnEnable()
	if not SN.data.profile.yelldb then
		SN.data.profile.yelldb = {}
		for i = 1, #sayings do
			SN.data.profile.yelldb[i] = sayings[i]
		end
	end
	F.lust:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	F.lust:RegisterEvent("ENCOUNTER_END")
end

function LUST:OnDisable()
	F.lust:UnregisterAllEvents()
end

function LUST:Lock()
end

function LUST:Unlock()
end

function LUST:Reset()
end

function LUST:ApplySettings()
end

function LUST:EventHandler(self, event, ...)
	if event == "COMBAT_LOG_EVENT_UNFILTERED" then
		local _, type, _, sourceGUID, sourceName, _, _, destGUID, destName = ...
		local spellId, spellName = select(12, ...)
		if type == "SPELL_CAST_SUCCESS" then
			if not alreadyYelled then
				for i = 1, #LustIDS do
					if LustIDS[i] == spellId and (UnitInParty(sourceName) or UnitInRaid(sourceName)) then
						local saying = SN.data.profile.yelldb[random(1, #SN.data.profile.yelldb)]
						SendChatMessage(saying, "YELL")
						alreadyYelled = true
					end
				end
			end
		end
	end
	if event == "ENCOUNTER_END" then
		alreadyYelled = false
	end
end