------------------------------------------------------------------------------------------
--Engine Variables------------------------------------------------------------------------
------------------------------------------------------------------------------------------
local SN, L, F, T, M, _ = unpack(select(2,...))

SN.DB = {
	profile = {
		["installed"] = false,
		["bloodlust"] = {
			["enable"] = false,
		},
		["cooldown"] = {
			["enable"] = true,
			["castannounce"] = false,
			["iconmode"] = false,
			["iconscale"] = 1.0,
			["grow"] = "topleft",
			["columns"] = 1,
			["raid"] = false,
			["width"] = 250,
			["height"] = 18,
			["yoffset"] = 1,
			["fontsize"] = 12,
			["font"] = "SNFont",
			["texture"] = "SNMin",
			["visible"] = 15,
		},
		["debuffs"] = {
			["enable"] = true,
			["iconmode"] = false,
			["iconscale"] = 1.0,
			["grow"] = "topleft",
			["columns"] = 1,
			["width"] = 200,
			["height"] = 18,
			["yoffset"] = 1,
			["fontsize"] = 12,
			["font"] = "SNFont",
			["texture"] = "SNMin",
			["visible"] = 8,
		},
		["buffs"] = {
			["enable"] = true,
			["iconmode"] = false,
			["iconscale"] = 1.0,
			["grow"] = "topleft",
			["columns"] = 1,
			["width"] = 200,
			["height"] = 18,
			["yoffset"] = 1,
			["fontsize"] = 12,
			["font"] = "SNFont",
			["texture"] = "SNMin",
			["visible"] = 8,
		},
		["debug"] = {
			["enable"] = false,
		},
		["dispel"] = {
			["enable"] = false,
			["font"] = "SNFont",
			["fontsize"] = 12,
			["size"] = 48,
			["height"] = 48,
			["width"] = 48,
		},
		["interrupt"] = {
			["enable"] = false,
			["font"] = "SNFont",
			["fontsize"] = 16,
			["width"] = 250,
			["height"] = 75,
		},
		["cc"] = { 
			["enable"] = true,
			["announce"] = false,
			["iconmode"] = false,
			["iconscale"] = 1.0,
			["grow"] = "topleft",
			["columns"] = 1,
			["width"] = 200,
			["height"] = 18,
			["fontsize"] = 12,
			["font"] = "SNFont",
			["texture"] = "SNMin",
		},
		["classResources"] = {
			["enable"] = true,
			["classpowerclass"] = false,
			["width"] = 250,
			["height"] = 16,
			["orientation"] = "HORIZONTAL",
			["texture"] = "SNMin",
		},
		["classSelect"] = {
			["default"] = "DEATHKNIGHT",
		},
		["frames"] = {
			["lock"] = true,
			["threat"] = { "CENTER", UIParent, "CENTER", 0, 0 },
			["readycheck"] = { "CENTER", UIParent, "CENTER", 0, 100 },
			["debuffs"] = { "CENTER", UIParent, "CENTER", 215, -75 },
			["buffs"] = { "CENTER", UIParent, "CENTER", 215, 0 },
			["cooldown"] = { "CENTER", UIParent, "CENTER", -215, -75 },
			["cc"] = { "CENTER", UIParent, "CENTER", -250, 115 },
			["dispel"] = { "CENTER", UIParent, "CENTER", 0, 66 },
			["interrupt"] = { "CENTER", UIParent, "CENTER", 0, 80 },
			["powerbar"] = { "CENTER", UIParent, "CENTER", 0, -185 },
			["classResources"] = { "CENTER", UIParent, "CENTER", 0, -167 },
			["castbar"] = { "CENTER", UIParent, "CENTER", 0, -149 },
			["raidbuffs"] = { "TOP", UIParent, "TOP", 0, 0 },
		},
		["powerbar"] = {
			["tickenable"] = false,
			["enable"] = true,
			["width"] = 225,
			["height"] = 18,
			["fontsize"] = 12,
			["font"] = "SNFont",
			["texture"] = "SNMin",
		},
		["castbar"] = { 
			["enable"] = true,
			["lag"] = true,
			["width"] = 225,
			["height"] = 18,
			["fontsize"] = 12,
			["font"] = "SNFont",
			["texture"] = "SNMin",
		},
		["threat"] = {
			["enable"] = false,
			["font"] = "SNFont",
			["fontsize"] = 12,
			["width"] = 48,
			["height"] = 48,
		},
		["readycheck"] = {
			["enable"] = true,
			["height"] = 20,
			["width"] = 200,
			["announce"] = "SELF",
		},
		["raidbuffs"] = {
			["enable"] = true,
			["height"] = 46,
			["width"] = 280,
			["scale"] = 1.0,
			["orientation"] = "HORIZONTAL",
			["instance"] = true,
			["whisper"] = false,
			["readycheck"] = false,
		},
		["raidinvite"] = {
			["enable"] = true,
			["masterlootOn"] = false,
			["assistAll"] = false,
		},
		["minimap"] = {
			["enable"] = true,
			["hide"] = false,
		},
	},
}

SN.CHAR = {
	["profile"] = {
		["cooldowns"] = {
			[20484] = { -- Rebirth
				id = 20484,
				CD = 600,
				class = "DRUID",
				enable = false,
			},
			[29166] = { -- Innervate
				id = 29166,
				CD = 180,
				class = "DRUID",
				enable = false,
			},
			[132158] = { -- Nature's Swiftness
				id = 132158,
				CD = 60,
				class = "DRUID",
				enable = false,
			},
			[61336] = { -- Survival Instincts
				id = 61336,
				CD = 180,
				class = "DRUID",
				enable = false,
			},
			[22812] = { -- Barkskin
				id = 22812,
				CD = 60,
				class = "DRUID",
				enable = false,
			},
			[33831] = { -- Force of Nature
				id = 33831,
				CD = 60,
				class = "DRUID",
				enable = false,
			},
			[50334] = { -- Beserk
				id = 50334,
				CD = 180,
				class = "DRUID",
				enable = false,
			},
			[33891] = { -- Tree of Life
				id = 33891,
				CD = 180,
				class = "DRUID",
				enable = false,
			},
			[740] = { -- Tranquility
				id = 740,
				CD = 480,
				class = "DRUID",
				enable = false,
			},
			[77761] = { -- Stampeding Roar
				id = 77761,
				CD = 120,
				class = "DRUID",
				enable = false,
			},
			[102342] = { -- Ironbark
				id = 102342,
				CD = 120,
				class = "DRUID",
				enable = false,
			},
			[19263] = { -- Deterrence
				id = 19263,
				CD = 120,
				class = "HUNTER",
				enable = false,
			},
			[23989] = { -- Readiness
				id = 23989,
				CD = 300,
				class = "HUNTER",
				enable = false,
			},
			[19574] = { -- Bestial Wrath
				id = 19574,
				CD = 60,
				class = "HUNTER",
				enable = false,
			},
			[3045]  = { -- Rapid Fire
				id = 3045,
				CD = 180,
				class = "HUNTER",
				enable = false,
			},
			[126393] = { -- Eternal Guardian
				id = 126393,
				CD = 600,
				class = "HUNTER",
				enable = false,
			},
			[90355] = { -- Ancient Hysteria
				id = 90355,
				CD = 360,
				class = "HUNTER",
				enable = false,
			},
			[45438] = { -- Ice Block
				id = 45438,
				CD = 300,
				class = "MAGE",
				enable = false,
			},
			[66] = { -- Invisibility
				id = 66,
				CD = 300,
				class = "MAGE",
				enable = false,
			},
			[12472] = { -- Icy Veins
				id = 12472,
				CD = 180,
				class = "MAGE",
				enable = false,
			},
			[11958] = { -- Cold Snap
				id = 11958,
				CD = 180,
				class = "MAGE",
				enable = false,
			},
			[12043] = { -- Presence of Mind
				id = 12043,
				CD = 90,
				class = "MAGE",
				enable = false,
			},
			[12042] = { -- Arcane Power
				id = 12042,
				CD = 90,
				class = "MAGE",
				enable = false,
			},
			[80353] = { -- Time Warp
				id = 80353,
				CD = 300,
				class = "MAGE",
				enable = false,
			},
			[633] = { -- Lay on Hands
				id = 633,
				CD = 600,
				class = "PALADIN",
				enable = false,
			},
			[1022] = { -- Hand of Protection
				id = 1022,
				CD = 300,
				class = "PALADIN",
				enable = false,
			},
			[498] = { -- Divine Protection
				id = 498,
				CD = 60,
				class = "PALADIN",
				enable = false,
			},
			[642] = { -- Divine Shield
				id = 642,
				CD = 300,
				class = "PALADIN",
				enable = false,
			},
			[1038] = { -- Hand of Salvation
				id = 1038,
				CD = 120,
				class = "PALADIN",
				enable = false,
			},
			[6940] = { -- Hand of Sacrifice
				id = 6940,
				CD = 120,
				class = "PALADIN",
				enable = false,
			},
			[31821] = { -- Devotion Aura
				id = 31821,
				CD = 180,
				class = "PALADIN",
				enable = false,
			},
			[31850] = { -- Ardent Defender
				id = 31850,
				CD = 180,
				class = "PALADIN",
				enable = false,
			},
			[31884] = { -- Avenging Wrath
				id = 31884,
				CD = 180,
				class = "PALADIN",
				enable = false,
			},
			[853] = { -- Hammer of Justice
				id = 853,
				CD = 60,
				class = "PALADIN",
				enable = false,
			},
			[86698] = { -- Guardian of Ancient Kings (Ret)
				id = 86698,
				CD = 300,
				class = "PALADIN",
				enable = false,
			}, 
			[86669] = {  -- Guardian of Ancient Kings (Holy)
				id = 86669,
				CD = 300,
				class = "PALADIN",
				enable = false,
			},
			[86659] = { -- Guardian of Ancient Kings (Prot)
				id = 86659,
				CD = 180,
				class = "PALADIN",
				enable = false,
			},
			[105809] = { -- Holy Avenger
				id = 105809,
				CD = 120,
				class = "PALADIN",
				enable = false,
			},
			[6346]  = { -- Fear Ward
				id = 6346,
				CD = 180,
				class = "PRIEST",
				enable = false,
			},
			[64901] = { -- Hymn of Hope
				id = 64901,
				CD = 360,
				class = "PRIEST",
				enable = false,
			},
			[34433] = { -- Shadowfiend
				id = 34433,
				CD = 180,
				class = "PRIEST",
				enable = false,
			},
			[64843] = { -- Divine Hymn
				id = 64843,
				CD = 180,
				class = "PRIEST",
				enable = false,
			},
			[10060] = { -- Power Infusion
				id = 10060,
				CD = 120,
				class = "PRIEST",
				enable = false,
			},
			[33206] = { -- Pain Suppression
				id = 33206,
				CD = 180,
				class = "PRIEST",
				enable = false,
			},
			[62618] = { -- Power Word: Barrier
				id = 62618,
				CD = 180,
				class = "PRIEST",
				enable = false,
			},
			[724] = { -- Lightwell
				id = 724,
				CD = 180,
				class = "PRIEST",
				enable = false,
			},
			[47788] = { -- Guardian Spirit
				id = 47788,
				CD = 180,
				class = "PRIEST",
				enable = false,
			},
			[47585] = { -- Dispersion
				id = 47585,
				CD = 120,
				class = "PRIEST",
				enable = false,
			},
			[19236] = { -- Desperate Prayer
				id = 19236,
				CD = 120,
				class = "PRIEST",
				enable = false,
			},
			[64044] = { -- Psychic Horror
				id = 64044,
				CD = 120,
				class = "PRIEST",
				enable = false,
			},
			[73325] = { -- Leap of Faith
				id = 73325,
				CD = 90,
				class = "PRIEST",
				enable = false,
			},
			[15286] = { -- Vampiric Embrace
				id = 15286,
				CD = 180,
				class = "PRIEST",
				enable = false,
			},
			[109964] = { -- Spirit Shell
				id = 109964,
				CD = 60,
				class = "PRIEST",
				enable = false,
			},
			[5277] = { -- Evasion
				id = 5277,
				CD = 180,
				class = "ROGUE",
				enable = false,
			}, 
			[1856] = { -- Vanish
				id = 1856,
				CD = 180,
				class = "ROGUE",
				enable = false,
			},
			[2094] = { -- Blind
				id = 2094,
				CD = 180,
				class = "ROGUE",
				enable = false,
			},
			[31224] = { -- Cloak of Shadows
				id = 31224,
				CD = 120,
				class = "ROGUE",
				enable = false,
			},
			[14185] = { -- Preparation
				id = 14185,
				CD = 300,
				class = "ROGUE",
				enable = false,
			},
			[79140] = { -- Vendetta
				id = 79140,
				CD = 120,
				class = "ROGUE",
				enable = false,
			},
			[13750] = { -- Adrenaline Rush
				id = 13750,
				CD = 180,
				class = "ROGUE",
				enable = false,
			},
			[51690] = { -- Killing Spree
				id = 51690,
				CD = 120,
				class = "ROGUE",
				enable = false,
			},
			[51713] = { -- Shadow Dance
				id = 51713,
				CD = 60,
				class = "ROGUE",
				enable = false,
			},
			[76577] = { -- Smoke Bomb
				id = 76577,
				CD = 180,
				class = "ROGUE",
				enable = false,
			},
			[20608] = { -- Reincarnation
				id = 20608,
				CD = 1800,
				class = "SHAMAN",
				enable = false,
			},
			[2062] = { -- Earth Elemental Totem
				id = 2062,
				CD = 300,
				class = "SHAMAN",
				enable = false,
			},
			[2894] = { -- Fire Elemental Totem
				id = 2894,
				CD = 300,
				class = "SHAMAN",
				enable = false,
			},
			[2825] = { -- Bloodlust
				id = 2825,
				CD = 300,
				class = "SHAMAN",
				enable = false,
			},
			[32182] = { --Heroism
				id = 32182,
				CD = 300,
				class = "SHAMAN",
				enable = false,
			},
			--[16188] = { -- Ancestral Swiftness
			--	id = 16188,
			--	CD = 90,
			--	class = "SHAMAN",
			--	enable = false,
			--},
			[16190] = { -- Mana Tide Totem
				id = 16190,
				CD = 180,
				class = "SHAMAN",
				enable = false,
			},
			[556] = { -- Astral Recall
				id = 556,
				CD = 900,
				class = "SHAMAN",
				enable = false,
			},
			[16166] = { -- Elemental Mastery
				id = 16166,
				CD = 90,
				class = "SHAMAN",
				enable = false,
			},
			[79206] = { -- Spiritwalker's Grace
				id = 79206,
				CD = 120,
				class = "SHAMAN",
				enable = false,
			},
			[51533] = { -- Feral Spirit
				id = 51533,
				CD = 120,
				class = "SHAMAN",
				enable = false,
			},
			[98008] = { -- Spirit Link Totem
				id = 98008,
				CD = 180,
				class = "SHAMAN",
				enable = false,
			},
			[120668] = { -- Stormlash Totem
				id = 120668,
				CD = 300,
				class = "SHAMAN",
				enable = false,
			},
			[108280] = { -- Healing Tide Totem
				id = 108280,
				CD = 180,
				class = "SHAMAN",
				enable = false,
			},
			[108281] = { -- Ancestral Guidance
				id = 108281,
				CD = 120,
				class = "SHAMAN",
				enable = false,
			},
			[108271] = { -- Astral Shift
				id = 108271,
				CD = 120,
				class = "SHAMAN",
				enable = false,
			},
			[114049] = { -- Ancendance
				id = 114049,
				CD = 180,
				class = "SHAMAN",
				enable = false,
				delay = 15,
			},
			[20707] = { -- Soulstone Ressurrection
				id = 20707,
				CD = 600,
				class = "WARLOCK",
				enable = false,
			},
			[698] = { -- Ritual of Summoning
				id = 698,
				CD = 120,
				class = "WARLOCK",
				enable = false,
			},
			[1122] = { -- Summon Infernal
				id = 1122,
				CD = 600,
				class = "WARLOCK",
				enable = false,
			},
			[18540] = { -- Summon Doomguard
				id = 18540,
				CD = 600,
				class = "WARLOCK",
				enable = false,
			},
			[29858] = { -- Soulshatter
				id = 29858,
				CD = 120,
				class = "WARLOCK",
				enable = false,
			},
			[29893] = { -- Create Soulwell
				id = 29893,
				CD = 120,
				class = "WARLOCK",
				enable = false,
			},
			[1719] = { -- Recklessness
				id = 1719,
				CD = 300,
				class = "WARRIOR",
				enable = false,
			},
			[871] = { -- Shield Wall
				id = 871,
				CD = 300,
				class = "WARRIOR",
				enable = false,
			},
			[64382] = { -- Shattering Throw
				id = 64382,
				CD = 300,
				class = "WARRIOR",
				enable = false,
			},
			[55694] = { -- Enraged Regeneration
				id = 55694,
				CD = 60,
				class = "WARRIOR",
				enable = false,
			},
			[12975] = { -- Last Stand
				id = 12975,
				CD = 180,
				class = "WARRIOR",
				enable = false,
			},
			[46924] = { -- Bladestorm
				id = 46924,
				CD = 90,
				class = "WARRIOR",
				enable = false,
			},
			[97462] = { -- Rallying Cry
				id = 97462,
				CD = 180,
				class = "WARRIOR",
				enable = false,
			},
			[114030] = { -- Vigilance
				id = 114030,
				CD = 120,
				class = "WARRIOR",
				enable = false,
			},
			[114203] = { -- Demoralizing Banner
				id = 114203,
				CD = 180,
				class = "WARRIOR",
				enable = false,
			},
			[114207] = { -- Skull Banner
				id = 114207,
				CD = 180,
				class = "WARRIOR",
				enable = false,
			},
			[114192] = { -- Mocking Banner
				id = 114192,
				CD = 180,
				class = "WARRIOR",
				enable = false,
			},
			[47476] = { -- Strangulate
				id = 47476,
				CD = 120,
				class = "DEATHKNIGHT",
				enable = false,
			},
			[48792] = { -- Icebound Fortitude
				id = 48792,
				CD = 180,
				class = "DEATHKNIGHT",
				enable = false,
			},
			[61999] = { -- Raide Ally
				id = 61999,
				CD = 600,
				class = "DEATHKNIGHT",
				enable = false,
			},
			[42650] = { -- Army of the Dead
				id = 42650,
				CD = 600,
				class = "DEATHKNIGHT",
				enable = false,
				delay = 4,
			},
			[55233] = { -- Vampiric Blood
				id = 55233,
				CD = 60,
				class = "DEATHKNIGHT",
				enable = false,
			},
			[49028] = { -- Dancing Rune Weapon
				id = 49028,
				CD = 90,
				class = "DEATHKNIGHT",
				enable = false,
			},
			[49039] = { -- Lichborne
				id = 49039,
				CD = 120,
				class = "DEATHKNIGHT",
				enable = false,
			},
			[49016] = { -- Unholy Frenzy
				id = 49016,
				CD = 180,
				class = "DEATHKNIGHT",
				enable = false,
			},
			[49206] = { -- Summon Gargoyle
				id = 49206,
				CD = 180,
				class = "DEATHKNIGHT",
				enable = false,
			},
			[46584] = { -- Raise Dead
				id = 46584,
				CD = 120,
				class = "DEATHKNIGHT",
				enable = false,
			},
			[51052] = { -- Anti-Magic Zone
				id = 51052,
				CD = 120,
				class = "DEATHKNIGHT",
				enable = false,
			},
			[47568] = { -- Empower Rune Weapon
				id = 47568,
				CD = 300,
				class = "DEATHKNIGHT",
				enable = false,
			},
			[48743] = { -- Death Pact
				id = 48743,
				CD = 120,
				class = "DEATHKNIGHT",
				enable = false,
			},
			[115213] = { -- Avert Harm
				id = 115213,
				CD = 180,
				class = "MONK",
				enable = false,
			},
			[115176] = { -- Zen Meditation
				id = 115176,
				CD = 180,
				class = "MONK",
				enable = false,
			},
			[122278] = { -- Dampen Harm
				id = 122278,
				CD = 90,
				class = "MONK",
				enable = false,
			},
			[115310] = { -- Revival
				id = 115310,
				CD = 180,
				class = "MONK",
				enable = false,
			},
			[116849] = { -- Life Cocoon
				id = 116849,
				CD = 120,
				class = "MONK",
				enable = false,
			},
			[115203] = { -- Fortifying Brew
				id = 115203,
				CD = 180,
				class = "MONK",
				enable = false,
			},
			[122470] = { -- Touch of Karma
				id = 122470,
				CD = 90,
				class = "MONK",
				enable = false,
			},
			[123904] = { -- Xuen
				id = 123904,
				CD = 180,
				class = "MONK",
				enable = false,
			},
		},
	},
}

--SN.devUsers = {
--	["profile"] = {
--		["devUsers"] = {
--		},
--	}
--}