----------------------------------------------
--		Serenity Now						--
--	By Shampw(Calahil) on Zul'jin-US	--
----------------------------------------------

local addonName, SNEngine = ...
local SN = LibStub("AceAddon-3.0"):NewAddon(addonName, "AceEvent-3.0", "AceTimer-3.0",  "AceConsole-3.0", "AceComm-3.0", "AceSerializer-3.0", "AceHook-3.0")

local AceConfigDialog = LibStub("AceConfigDialog-3.0")

local L = LibStub("AceLocale-3.0"):GetLocale("SerenityNow")

local timers = LibStub("LibFancyBar-1.0")
local SNFrames = {}
local LSM = LibStub("LibSharedMedia-3.0")
local ISPCT = LibStub("LibGroupInSpecT-1.0")

local collectgarbage = collectgarbage
local print = print
local format = format
local IsAddOnLoaded = IsAddOnLoaded
local InCombatLockdown = InCombatLockdown

local IsInRaid = IsInRaid
local IsInGroup = IsInGroup
local LE_PARTY_CATEGORY_INSTANCE = LE_PARTY_CATEGORY_INSTANCE
local LE_PARTY_CATEGORY_HOME = LE_PARTY_CATEGORY_HOME

SN.dispel = LibStub("LibDispellable-1.0")
SN.ver = GetAddOnMetadata("SerenityNow", "Version")
SN.addonName = addonName

SN.playerClass = select(2, UnitClass("player"))
SN.playerName = UnitName("player")
SN.playerRealm = GetRealmName()
SN.playerGUID = UnitGUID("player")

SN.RaidMemberData = {}
-- How often the OnUpdate code will run (in seconds)
SN.UpdateIntervalDispel = 1.0

SN.me = true

SN.verWarn = false

SN.options = {
	type = "group",
	name = SN.addonName.." "..SN.ver,
	args = {},
}

local SNmedia = {
	["media"] = {
		["normTex"] = LSM:Fetch("statusbar","SNNorm"),
		["minTex"] = LSM:Fetch("statusbar", "SNMin"),
		["glossTex"] = LSM:Fetch("statusbar", "SNGloss"),
		["blankTex"] = LSM:Fetch("background","SNBlank"),
		["draghandle"] = LSM:Fetch("border", "SNDrag"),
		["borderTex"] = LSM:Fetch("border", "SNBorder"),
		["font"] = LSM:Fetch("font","SNFont")
	},
	["power"] = {
		{ 0.31, 0.45, 0.63 }, --Mana
		{ 0.78, 0.25, 0.25 }, --Rage
		{ 0.71, 0.43, 0.27 }, --Focus
		{ 0.65, 0.63, 0.35 }, --Energy
		{ 0, 0.82, 1 }, --Runic Power
	},
	["classResources"] = {
		["DEATHKNIGHT"] = {
			{ 1, 0, 0 },
			{ 0, .5, 0 },
			{ 0, 1, 1 },
			{ .9, 1, 1 },				
		},
		["DRUID"] = {
			{ .30, .52, .90 },
			{ .80, .82, .60 },
		},
		["MAGE"] = { 0, .61, 1 },
		["MONK"] = {
			{ .57, .63, .35 },
			{ .47, .63, .35 },
			{ .37, .63, .35 },
			{ .27, .63, .33 },
			{ .17, .63, .33 },			
		},
		["PALADIN"] = { 1, 1, 0 },
		["PRIEST"] = { 1, 1, 1 },
		["ROGUE"] = {
			{ .69, .31, .31 },
			{ .69, .31, .31 },
			{ .65, .63, .35 },
			{ .65, .63, .35 },
			{ .33, .59, .33 },
		},
		["WARLOCK"] = {
			{ .58, .50, .78 },
			{ .58, .50, .78 },
			{ .90, .37, .37 },			
		},
	},
}

SN["classMaxResourceBar"] = {
	["DEATHKNIGHT"] = 6,
	["PALADIN"] = 5,
	["WARLOCK"] = 4,
	["PRIEST"] = 3,
	["MONK"] = 5,
	["MAGE"] = 6,
}

--Serenity Now's Engine Variables
SNEngine[1] = SN			--Addon
SNEngine[2] = L				--Locale
SNEngine[3] = SNFrames		--Frame Table
SNEngine[4] = timers		--LibFancyBars
SNEngine[5] = SNmedia		--Shared Media

_G[addonName] = SNEngine


function SN:OnInitialize()
	--Setup the clc 
	SN:RegisterChatCommand("sn", "Cmds")
	--Lets make the welcome message more visible
	SN:ScheduleTimer("Ver", 10)
	SN:Initialize()
	
	SN.data.profile.frames.lock = true
	
	--collect garbage from startup
	collectgarbage("collect")

	ISPCT.RegisterCallback(SN, "GroupInSpecT_Update", "RosterUpdate")
	ISPCT.RegisterCallback(SN, "GroupInSpecT_Remove", "RosterRemove")
	SN:RegisterComm("SNow", "OnCommSNow")

	SN:RegisterEvent("GROUP_ROSTER_UPDATE", "SendCommSNow")
end

function SN:OnEnable()
	for name, module in SN:IterateModules() do
		if SN.data.profile[name].enable then
			SN:EnableModule(name)
		else
			SN:DisableModule(name)
		end
	end
	if (IsAddOnLoaded("ElvUI")) then
		SN:ElvOverride()
	end
end

function SN:Ver()
	print(format(L["Welcome to |cff0070deSerenity Now|r "]..SN.ver))
end

function SN:Cmds(input)
	local v1, v2 = input:match("^(%S*)%s*(.-)$")
	v1 = v1:lower()

	if (v1 == "") then	
		print(L["|cff0070deSerenity Now|r "]..SN.ver)
		SN:Print(L["/sn |cff0070deconfig|r - open the config frame."])
		SN:Print(L["/sn |cff0070delock|r - unlock/lock the frames."])
		SN:Print(L["/sn |cff0070dereset|r - reset the frames."])

	elseif (v1 == L["options"]) or (v1 == L["config"]) then
		
		if InCombatLockdown() then 
			SN:Print(L["Can not do that while in combat"])
		else
			AceConfigDialog:Open("SN")
		end
	elseif (v1 == L["lock"]) or (v1 == L["unlock"]) then
		if SN.data.profile.frames.lock then
			if InCombatLockdown() then 
				SN:Print(L["Can not do that while in combat"])
			else
				SN:MoveFrames(false)
				SN.data.profile.frames.lock = false
				SN:Print(L["Frames Unlocked"])
			end
		elseif not SN.data.profile.frames.lock then
			if InCombatLockdown() then 
				SN:Print(L["Can not do that while in combat"])
			else
				SN:MoveFrames(true)
				SN.data.profile.frames.lock = true
				SN:Print(L["Frames Locked"])
			end
		end
	elseif (v1 == L["reset"]) or (v1 == L["defaults"]) then
		if InCombatLockdown() then 
			SN:Print(L["Can not do that while in combat"])
		else
			SN:ResetAnchors()
		end
	else
		SN:Print(L["Command Unknown."])
	end
end

local isBroadCasting = nil

function SN:SendCommSNow()
	if isBroadCasting then return end
	
	SN:CommTimer()
	isBroadCasting = SN:ScheduleTimer("CommTimer", 12)
end

function SN:CommTimer()
	if IsInRaid() then
		SN:SendCommMessage("SNow", SN:Serialize(SN.playerName, SN.ver, SN.playerRealm), (not IsInRaid(LE_PARTY_CATEGORY_HOME) and IsInRaid(LE_PARTY_CATEGORY_INSTANCE)) and "INSTANCE_CHAT" or "RAID")
	elseif IsInGroup() then
		SN:SendCommMessage("SNow", SN:Serialize(SN.playerName, SN.ver, SN.playerRealm), (not IsInGroup(LE_PARTY_CATEGORY_HOME) and IsInGroup(LE_PARTY_CATEGORY_INSTANCE)) and "INSTANCE_CHAT" or "PARTY")
	end

	if isBroadCasting then
		SN:CancelTimer(isBroadcasting)
		isBroadCasting = nil
	end
end

function SN:OnCommSNow(prefix, message, distribution, sender)
	if prefix ~= "SNow" then return end
	local _, playerNameRemote, verRemote, realmNameRemote = SN:Deserialize(message)
	
	if verRemote == "1.9" then return end

	--SN:Debug("Received Comm Data")
	if (verRemote > SN.ver) and not SN.verWarn then
		SN:Print("Your version of Serenity Now is out of date.")
		SN.verWarn = true
	end
	--SN:Debug(playerNameRemote)
	--SN:Debug(SN.playerName)
	--if playerNameRemote == "Shampw" or playerNameRemote == "Brewmoo" then
		--SN:Debug("I am me")
--		if not SN.data.profile.devUsers then
--			SN.data.profile.devUsers = {}
--		end
		
		--if playerNameRemote == SN.playerName then return end
		--if SN.me then
		--	if not SN.dev.profile.devUsers[realmNameRemote] then
		--		SN.dev.profile.devUsers[realmNameRemote] = { [playerNameRemote] = { ["version"] = verRemote, ["realm"] = realmNameRemote } }
		--	else
		--		SN.dev.profile.devUsers[realmNameRemote][playerNameRemote] = { ["version"] = verRemote, ["realm"] = realmNameRemote }
		--	end
		--end
	--end
end

function SN:Debug(...)
	if SN.data.profile.debug.enable then
		SN:Print(...)
	end
end