------------------------------------------------------------------------------------------
--Engine Functions------------------------------------------------------------------------
------------------------------------------------------------------------------------------
local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")

local GetNumGroupMembers = GetNumGroupMembers
local IsInInstance = IsInInstance
local UnitAffectingCombat = UnitAffectingCombat
local UnitIsDeadOrGhost = UnitIsDeadOrGhost
local UnitIsDead = UnitIsDead
local SendChatMessage = SendChatMessage
local UnitIsGroupLeader = UnitIsGroupLeader
local IsInRaid = IsInRaid
local IsInGroup = IsInGroup
local LE_PARTY_CATEGORY_INSTANCE = LE_PARTY_CATEGORY_INSTANCE
local UnitName = UnitName
local GetSpellLink = GetSpellLink
local GetSpellInfo = GetSpellInfo
local GetSpellCooldown = GetSpellCooldown
local GetComboPoints = GetComboPoints
local UnitClass = UnitClass
local UnitGUID = UnitGUID
local IsAddOnLoaded = IsAddOnLoaded

local RAID_CLASS_COLORS = RAID_CLASS_COLORS

local collectgarbage = collectgarbage
local pairs = pairs
local ReloadUI = ReloadUI
local unpack = unpack
local wipe = wipe
local type = type
local tostring = tostring
local string = string

local NORMAL_FONT_COLOR = NORMAL_FONT_COLOR
local GameFontNormal = GameFontNormal
local GetScreenWidth = GetScreenWidth
local GetScreenHeight = GetScreenHeight
local GetTime = GetTime
------------------------------------------------------------------------------------------
--Override ElvUI Element Function---------------------------------------------------------
------------------------------------------------------------------------------------------

function SN:ElvOverride()
	local E, L, V, P, G, _ = unpack(ElvUI)
	local UF = E:GetModule("UnitFrames")

	if SN.data.profile.powerbar.enable then
		E.db.unitframe.units.player.power.enable = false
	else
		E.db.unitframe.units.player.power.enable = true
	end
	if SN.data.profile.castbar.enable then
		E.db.unitframe.units.player.castbar.enable = false
	else
		E.db.unitframe.units.player.castbar.enable = true
	end
	if SN.data.profile.classResources.enable then
		E.db.unitframe.units.player.classbar.enable = false
		if SN.playerClass == "DRUID" or "ROGUE" then
			E.db.unitframe.units.target.combobar.enable = false
		end
	else
		E.db.unitframe.units.player.classbar.enable = true
		if SN.playerClass == "DRUID" or "ROGUE" then
			E.db.unitframe.units.target.combobar.enable = true
		end
	end
	UF:CreateAndUpdateUF("player")
	UF:CreateAndUpdateUF("target")
	collectgarbage("collect")
end

------------------------------------------------------------------------------------------
--Misc Functions--------------------------------------------------------------------------
------------------------------------------------------------------------------------------

function SN:GetPoint(frame)
	local point, anchor, secondaryPoint, x, y = frame:GetPoint()
	if not anchor then anchor = UIParent end

	return point, anchor:GetName(), secondaryPoint, SN:Round(x), SN:Round(y)
end

function SN:Round(v, decimals)
	if not decimals then decimals = 0 end
    return (("%%.%df"):format(decimals)):format(v)
end

function SN:copyTable(new, old)
	if type(new) ~= "table" then new = {} end
	
	if type(old) == 'table' then
		for option, value in pairs(old) do
			if type(value) == "table" then
				value = self:copyTable(new[option], value)
			end
			
			new[option] = value			
		end
	end
	
	return new
end

function SN:tcount(table)
   local n = 0
   for _ in pairs(table) do
     n = n + 1
   end
   return n
end

-- tremovebyval: remove a table row given its value
function SN:tremovebyval(tab, val)
	local counter = 1
	for k,v in pairs(tab) do
		if k == val then
			table.remove(tab, counter)
			return true
		end
		counter = counter +  1
	end
	return false
end
 
function SN:CheckTable(t, val)
	for i, v in ipairs(t) do
		if v == val then
			return true
		end
	end
	return false
end
------------------------------------------------------------------------------------------
--Raid Functions--------------------------------------------------------------------------
------------------------------------------------------------------------------------------

function SN:RosterUpdate(event, guid, unit, info)
	SN.RaidMemberData[guid] = info
end

function SN:RosterRemove(event, guid)
	SN.RaidMemberData[guid] = nil
end

-- Get Group Type = 0|None, 1|Party, 2|Raid, 3|Instance
function SN:GroupType()
	if(GetNumGroupMembers() > 0) then
		if(IsInRaid()) then
			if IsInGroup(LE_PARTY_CATEGORY_INSTANCE) then
				return 3
			else
				return 2
			end
		elseif(IsInGroup()) then
			return 1
		end
	else
		return 0
	end
end

function SN:GUIDToUnitID(guid)
	local prefix, min, max = "raid", 1, GetNumGroupMembers()
	-- Prioritise getting direct units first because other players targets
	-- can change between notify and event which can bugger things up
	for i = min, max do
		local unit = i == 0 and "player" or prefix .. i
		if (UnitGUID(unit) == guid) then
			return unit
		end
	end
	
	if(guid == UnitGUID("player")) then
		return "player"	
	end

	-- This properly detects target units
	if (UnitGUID("target") == guid) then
        return "target"
	elseif (UnitGUID("focus") == guid) then
		return "focus"
	elseif (UnitGUID("mouseover") == guid) then
		return "mouseover"
    end

	for i = min, max + 3 do
		local unit
		if i == 0 then
			unit = "player"
		elseif i == max + 1 then
			unit = "target"
		elseif i == max + 2 then
			unit = "focus"
		elseif i == max + 3 then
			unit = "mouseover"
		else
			unit = prefix .. i
		end
		if (UnitGUID(unit .. "target") == guid) then
			return unit .. "target"
		elseif (i <= max and UnitGUID(unit.."pettarget") == guid) then
			return unit .. "pettarget"
		end
	end
	return nil
end

------------------------------------------------------------------------------------------
--Announcer Function----------------------------------------------------------------------
------------------------------------------------------------------------------------------

function SN:Announcer(frame, timer, spellId, caster, destName, token)

	--Is the announce setting and in a raid and are you the leader...otherwise no spam for you
	if (SN.data.profile.cooldown.castannounce) and (UnitIsGroupLeader("player") or UnitIsGroupAssistant("player")) and frame ==  F.cooldowns then
		if type(timer) ~= "number" then return end
		local dur = timer / 60

		if token then
			if IsInGroup(LE_PARTY_CATEGORY_INSTANCE) then
				SendChatMessage(caster..L[" casts "]..GetSpellLink(spellId).." "..dur.." min".." CD", "INSTANCE_CHAT")
			else
				SendChatMessage(caster..L[" casts "]..GetSpellLink(spellId).." "..dur.." min".." CD", "RAID")
			end
		elseif not token then
			SendChatMessage(caster..L[" casts "]..GetSpellLink(spellId).." "..dur.." min".." CD", "PARTY")
		end
	end
	
	if (SN.data.profile.threat.enable) and frame == F.threat then
		if token then
			SendChatMessage(SN.playerName..L[" casts {star} "]..GetSpellLink(spellId)..L[" {star} on you!"], "WHISPER", nil, destName)
		elseif not token then
			SendChatMessage(SN.playerName..L[" tried to cast {star} "]..GetSpellLink(spellId)..
									L[" {star} on you, but you're on your stupid mount."], "WHISPER", nil, destName)
		end
	end
		
	if (SN.data.profile.cc.enable) and frame == F.cc and token then
		if IsInGroup(LE_PARTY_CATEGORY_INSTANCE) then
			SendChatMessage(caster.." broke "..GetSpellLink(spellId).." on "..destName, "INSTANCE_CHAT")
		else
			SendChatMessage(caster.." broke "..GetSpellLink(spellId).." on "..destName, "RAID")
		end
	elseif (SN.data.profile.cc.enable) and frame == F.cc and not token then
		SendChatMessage(caster.." broke "..GetSpellLink(spellId).." on "..destName, "PARTY")
	end	
end

function SN:WarnSay(args)
	local self, enemy = args
	if self.aggro then
		SendChatMessage(SN.playerName..L[" pulled aggro on "]..enemy..L[" help me!"], "SAY")
	else
		SN:CancelTimer(self.timer)
		self.startYell = false
	end
end
------------------------------------------------------------------------------------------
--Frame Functions-------------------------------------------------------------------------
------------------------------------------------------------------------------------------

function SN:CreateFrame(name, dbname, parent)
	local db = SN.data.profile
	local color = NORMAL_FONT_COLOR

	local f = CreateFrame("Frame", nil, parent)
	f:SetPoint(unpack(db.frames[dbname]))
	f:SetSize(db[dbname].width, db[dbname].height)

	--The mover frame text
	f.value = f:CreateFontString(nil, "OVERLAY")
	f.value:SetPoint("CENTER", f)
	f.value:SetFontObject(GameFontNormal)
	f.value:SetJustifyH("CENTER")
	f.value:SetTextColor(color.r, color.g, color.b)
	--The name to display when the frame is being moved
	f.name = name
	f.db = dbname

	return f
end

function SN:CreateBackDrop(self)
	if (IsAddOnLoaded("ElvUI")) then
		SN:SNCreateBG(self, "Frame")
	else
		self:SetBackdrop({
			bgFile = M.media.blankTex, 
			edgeFile = M.media.blankTex, 
			tile = false, tileSize = 0, edgeSize = 2, 
			insets = { left = -1, right = -1, top = -1, bottom = -1 }
		})
		self:SetBackdropColor(0, 0, 0, 0.7)
		self:SetBackdropBorderColor(0.1, 0.1, 0.1, 1)
	end
end

function SN:SNCreateBG(frame, type)
	
	--Make the frames look like ElvUI
	local E, L, V, P, G,_ = unpack(ElvUI)
	local S = E:GetModule("Skins")
		
	if type == "Frame" then
		frame:StripTextures(true)
		frame:SetTemplate("Transparent")
		frame.skinned = true
	elseif type == "Button" then
		S:HandleButton(frame, true)
		frame.skinned = true
	elseif type == "EditBox" then
		S:HandleEditBox(frame)
		frame.skinned = true
	elseif type == "ScrollBar" then
		S:HandleScrollBar(frame)
		frame.skinned = true
	elseif type == "CheckBox" then
		S:HandleCheckBox(frame)
		frame.skinned = true
	elseif type == "StatusBar" then
		local bg = CreateFrame("Frame")
		bg:SetTemplate("Transparent")
		bg:SetParent(frame)
		bg:ClearAllPoints()
		bg:Point("TOPLEFT", frame, "TOPLEFT", -1, 1)
		bg:Point("BOTTOMRIGHT", frame, "BOTTOMRIGHT", 1, -1)
		bg:SetFrameStrata("BACKGROUND")
		bg:Show()
		bg:SetAlpha(.7)
		frame.skinned = true
	end
end

function SN:UnlockFrame(frame)
	frame:SetSize(SN.data.profile[frame.db].width, SN.data.profile[frame.db].height)
	frame:SetBackdrop( { bgFile   = "Interface/Tooltips/UI-Tooltip-Background",
						edgeFile = LSM:Fetch("border", "SNBorder"),
						tile     = false,
						tileSize = 0,
						edgeSize = 2,
						insets = { left = 0, right = 0, top = 0, bottom = 0 }
					} )
	frame:SetBackdropColor(.1, .1, .1, .8)
	frame:SetBackdropBorderColor(1.0, 0.1, 0.1, 1)
			
	frame.value:SetText(frame.name)

	frame:EnableMouse(true)
	frame:SetMovable(true)
	frame:RegisterForDrag("LeftButton")

	frame:SetScript("OnDragStart", function(self)
		self:StartMoving()
	end)
	frame:SetScript("OnDragStop", function(self)
		SN.data.profile.frames[self.db] = { SN:GetPoint(self) }
		self:StopMovingOrSizing()
	end)
end

function SN:LockFrame(frame)
	frame:SetBackdrop(nil)
	frame.value:SetText("")
	frame:EnableMouse(false)
	frame:SetMovable(false)
	frame:SetScript("OnDragStart", nil)
	frame:SetScript("OnDragStop", nil)
end

function SN:MoveFrames(settings)
	local AceConfig = LibStub("AceConfig-3.0")
	local AceConfigDialog = LibStub("AceConfigDialog-3.0")
	local AceDB = LibStub("AceDB-3.0")
	local AceDBOptions = LibStub("AceDBOptions-3.0")

	if settings then
		for name, module in SN:IterateModules() do
			if module:IsEnabled() then
				module:Lock()
			end
		end
		SN:Grid_Hide()
		SN.data.profile.frames.lock = true
		AceConfigDialog:Open("SN")
	else
		AceConfigDialog:Close("SN")
		InterfaceOptionsFrame:Hide()
		for name, module in SN:IterateModules() do
			if module:IsEnabled() then
				module:Unlock()
			end
		end
		SN:Grid_Show()
		SN.data.profile.frames.lock = false
	end
	collectgarbage("collect")
end

function SN:Grid_Show()
	if not SNgrid then
        SN:Grid()
    else
		SNgrid:Show()
	end
end

function SN:Grid_Hide()
	if SNgrid then
		SNgrid:Hide()
		SNgrid = nil
	end
end

function SN:Grid()
	SNgrid = CreateFrame("Frame", "Grid", UIParent) 
	SNgrid.boxSize = 96
	SNgrid:SetAllPoints(UIParent) 
	SNgrid:Show()

	local size = 1 
	local width = GetScreenWidth()
	local ratio = width / GetScreenHeight()
	local height = GetScreenHeight() * ratio

	local wStep = width / SNgrid.boxSize
	local hStep = height / SNgrid.boxSize

	for i = 0, SNgrid.boxSize do 
		local tx = SNgrid:CreateTexture(nil, "BACKGROUND") 
		if i == SNgrid.boxSize / 2 then 
			tx:SetTexture(1, 0, 0) 
		else 
			tx:SetTexture(0, 0, 0) 
		end 
		tx:SetPoint("TOPLEFT", SNgrid, "TOPLEFT", i*wStep - (size/2), 0) 
		tx:SetPoint("BOTTOMRIGHT", SNgrid, "BOTTOMLEFT", i*wStep + (size/2), 0) 
	end 
	height = GetScreenHeight()
	
	do
		local tx = SNgrid:CreateTexture(nil, "BACKGROUND") 
		tx:SetTexture(1, 0, 0)
		tx:SetPoint("TOPLEFT", SNgrid, "TOPLEFT", 0, -(height/2) + (size/2))
		tx:SetPoint("BOTTOMRIGHT", SNgrid, "TOPRIGHT", 0, -(height/2 + size/2))
	end
	
	for i = 1, floor((height/2)/hStep) do
		local tx = SNgrid:CreateTexture(nil, "BACKGROUND") 
		tx:SetTexture(0, 0, 0)
		
		tx:SetPoint("TOPLEFT", SNgrid, "TOPLEFT", 0, -(height/2+i*hStep) + (size/2))
		tx:SetPoint("BOTTOMRIGHT", SNgrid, "TOPRIGHT", 0, -(height/2+i*hStep + size/2))
		
		tx = SNgrid:CreateTexture(nil, "BACKGROUND") 
		tx:SetTexture(0, 0, 0)
		
		tx:SetPoint("TOPLEFT", SNgrid, "TOPLEFT", 0, -(height/2-i*hStep) + (size/2))
		tx:SetPoint("BOTTOMRIGHT", SNgrid, "TOPRIGHT", 0, -(height/2-i*hStep + size/2))
	end
end

function SN:ResetAnchors()
	for name, module in SN:IterateModules() do
	   module:Reset()
	end
	SN.data.profile.frames = SN.DB.profile.frames
end

------------------------------------------------------------------------------------------
--Bar Creation Functions------------------------------------------------------------------
------------------------------------------------------------------------------------------
local function updateCooldown(self)
	local spell = self:GetData("SN:arg2")
		
	if not spell then return end

	local startTime, duration, enable = GetSpellCooldown(spell)
	local dur, max = self:GetDuration()
	if dur >= startTime + duration - GetTime() then
		self:SetDuration(startTime + duration - GetTime(), duration)
		self:Start()
	elseif not duration then
		self:Stop()
	end
end

--local function barStop(event, bar, ...)
--	if SN:IsHooked(bar, "OnUpdate") then
--		SN:Unhook(bar, "OnUpdate")
--	end
--end

local function purgeExpiredBars(group)
	if group then
		for k in pairs(group) do
			local dur, max = k:GetDuration()
			if not dur then
				k:Stop()
			end
		end
	end
end

function SN:CreateBar(group, cooldown, duration, caster, guid, spell)
	
	--purgeExpiredBars(group.bars)

	--Make our lives easier with some variables
	local class, classFileName, classID
	if caster then
		class, classFileName, classID = UnitClass(caster)
	else
		class, classFileName, classID = UnitClass(SN.playerName)
	end

	local bar
	for b, v in pairs(group.bars) do
		if b:GetData("SN:arg4") == caster and b:GetData("SN:arg5") == spell then
			bar = b
			break
		end
	end
	if not bar then
		bar = T:NewBar(nil, SN.data.profile[group.db].width, SN.data.profile[group.db].height, LSM:Fetch("statusbar", SN.data.profile[group.db].texture))
	end
	
	if not bar.skinned then
		if (IsAddOnLoaded("ElvUI")) then
			SN:SNCreateBG(bar, "StatusBar")
		else
			bar.FB_Background:SetTexture(M.media.blankTex)
			bar.FB_Background:SetTexture(0, 0, 0, 0)
			bar.FB_Bar:SetAlpha(1)
			bar:SetBackdrop({
				bgFile = M.media.blankTex, 
				edgeFile = M.media.blankTex, 
				tile = false, tileSize = 0, edgeSize = 1, 
				insets = { left = -1, right = -1, top = -1, bottom = -1 }
			})
			bar:SetBackdropColor(0, 0, 0, 0.6)
			bar:SetBackdropBorderColor(0.1, 0.1, 0.1, 1)
			bar.skinned = true
		end
	end
	
	--Grab the player's class color and the icon of the spell
	local colortmp = RAID_CLASS_COLORS[classFileName]
	local color = { colortmp.r, colortmp.g, colortmp.b }
	
	SN:Debug(tostring(cooldown))

	local _, _, icon = GetSpellInfo(cooldown)
	
	SN:Debug(tostring(icon))
	--if not icon then
	--	icon = "Interface\\Icons\\Spell_Holy_Serendipity"
	--end

	bar:SetIcon(icon)
	bar:SetColor(color)
	bar:SetDuration(duration)
	
	--Setup the data keys that the bar will hold
	bar:SetData("SN:arg1", group)
	bar:SetData("SN:arg2", cooldown)
	bar:SetData("SN:arg3", guid)
	bar:SetData("SN:arg4", caster)
	bar:SetData("SN:arg5", spell)
	bar:SetData("SN:arg6", classID)
	bar:SetData("SN:arg7", duration)
	bar:SetData("SN:arg8", icon)

	bar.TimeSinceLastUpdate = 0
	
	--Make sure only the CD monitor gets the caster and spell names
	if group == F.debuffs or group == F.buffs then
		bar:SetLabel(spell)
	elseif group == F.cooldowns then
		bar:SetLabel(string.format("%-25s", caster)..string.format("%5s",spell))
	elseif group == F.cc then
		bar:SetLabel(string.format("%-25s", spell)..UnitName(SN:GUIDToUnitID(guid)))
	end
	
	bar:SetDurationFont(LSM:Fetch("font", SN.data.profile[group.db].font), SN.data.profile[group.db].fontsize)
	bar:SetLabelFont(LSM:Fetch("font", SN.data.profile[group.db].font), SN.data.profile[group.db].fontsize)

	if SN.playerClass == "ROGUE" then
		bar:RegisterEvent("UNIT_COMBO_POINTS")
		bar:SetScript("OnEvent", function(self, event, ...)
			if GetComboPoints("player", "target") == 0 then
				updateCooldown(self)
			end
		end)
	elseif SN.playerClass == "SHAMAN" then
		if cooldown == 114049 then
			bar:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
			bar:SetScript("OnEvent", function(self, event, ...)
				local _, type, _, sourceGUID, sourceName, _, _, destGUID, destName = ...
				local spellId, spellName = select(12, ...)

				if sourceName ~= SN.playerName then return end
				if type == "SPELL_CAST_SUCCESS" then
					if SN.modAscendence[spellId] then 
						updateCooldown(self)
					end
				end
			end)
		end
	end
	
	--bar.HookUpdate = 0
	
	--SN:HookScript(bar, "OnUpdate", function(self, elapsed) 
	--	self.HookUpdate = self.HookUpdate + elapsed
	--	if self.HookUpdate < 5 then return end
	--	if not self:GetData("SN:arg4") == SN.playerName then return end
	--	updateCooldown(self)
	--	self.HookUpdate = 0
	--end)
	
	group:Add(bar)
	bar:Start()
	--bar:RegisterCallback("FancyBar_BarStop", barStop)

	return bar
end

function SN:EditBars(group)
	local frame

	if group == "cc" then
		frame = F.cc
	elseif group == "cooldown" then
		frame = F.cooldowns
	else
		frame = F.debuffs
	end
	frame:SetPoint(unpack(SN.data.profile.frames[group]))
	frame:SetStartPoint(SN.data.profile[group].grow)
	frame:SetWidth(SN.data.profile[group].width)
	frame:SetVisibleBars(SN.data.profile[group].visible)

	if frame.bars ~= nil then
		for i in pairs(frame.bars) do
			i:SetHeight(SN.data.profile[group].height)
			i:SetLabelFont(LSM:Fetch("font", SN.data.profile[group].font), SN.data.profile[group].fontsize)
			i:SetDurationFont(LSM:Fetch("font", SN.data.profile[group].font), SN.data.profile[group].fontsize)
			i:SetTexture(LSM:Fetch("statusbar", SN.data.profile[group].texture))
		end
	end
	if SN.data.profile[group].iconmode then
		frame:SetIconMode(32 * SN.data.profile[group].iconscale, "BOTTOM", 0, 0)
		frame:SetSpacing(SN.data.profile[group].fontsize / 2, SN.data.profile[group].fontsize + 3)
	else
		frame:SetIconMode(false)
		frame:SetSpacing(0, SN.data.profile[group].yoffset)
	end
end