------------------------------------------------------------------------------------------
--Config UI-------------------------------------------------------------------------------
------------------------------------------------------------------------------------------
local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")

local AceConfig = LibStub("AceConfig-3.0")
local AceConfigDialog = LibStub("AceConfigDialog-3.0")
local AceDB = LibStub("AceDB-3.0")
local AceDBOptions = LibStub("AceDBOptions-3.0")
local AceConfigRegistry = LibStub("AceConfigRegistry-3.0")
local LibDualSpec = LibStub('LibDualSpec-1.0')

local CLASS_SORT_ORDER = CLASS_SORT_ORDER
local AceGUIWidgetLSMlists = AceGUIWidgetLSMlists
local GetSpellInfo = GetSpellInfo
local IsAddOnLoaded = IsAddOnLoaded
local InCombatLockdown = InCombatLockdown
local pairs = pairs
local ReloadUI = ReloadUI
local strconcat = strconcat
local strlower = strlower
local strsub = strsub
local unpack = unpack
local collectgarbage = collectgarbage
local selectedSpell

local moduleOptions = {}

local function profileUpdate()
	SN:ChangeDB()

	if SN.playerClass == "HUNTER" or SN.playerClass == "SHAMAN" or SN.playerClass == "WARRIOR" or SN.playerClass == "MAGE" then
		SN.data.profile.classResources.classpowerclass = false
	else		
		SN.data.profile.classResources.classpowerclass = true
	end

	for name, module in SN:IterateModules() do
		if SN.data.profile[name].enable then
			SN:EnableModule(name)
			module:ApplySettings()
		else
			SN:DisableModule(name)
		end
	end
	collectgarbage("collect")
end

function SN:ChangeDB()
	if SN.data.profile.cooldowns then
		SN.char.profile.cooldowns = SN.data.profile.cooldowns
		SN.data.profile.cooldowns = nil
	end
end

function SN:Initialize()
	local db = LibStub("AceDB-3.0"):New("SNDB", SN.DB)
	local chardb = db:RegisterNamespace("SNCharDB", SN.CHAR)
	--local devdb = db:RegisterNamespace("SNdevDB", SN.devUsers)
	SN.char = chardb
	SN.data = db
	--SN.dev = devdb
	LibStub("LibDualSpec-1.0"):EnhanceDatabase(SN.data, "SN")
	SN.data.profile.classSelect.default = SN.playerClass

	db.RegisterCallback(self, "OnProfileChanged", profileUpdate)
	db.RegisterCallback(self, "OnProfileCopied", profileUpdate)
	db.RegisterCallback(self, "OnProfileReset", profileUpdate)
	SN:ChangeDB()
	SN:LoadConfig()
end

SN.TexCoords = {.08, .92, .08, .92}

local function getOptions()
	SN.options.args = {
		descrip = {
			order = 0,
			type = "description",
			name = L["A tool to have as much of the needed information from each class\nwithin eye sight so that you can say Serenity Now!"],
		},
		h1 = {
			order = 4,
			type = "header",
			name = "",
		},
				
		lock = {
			order = 7,
			name = L["Lock Frames"],
			type = 'toggle',
			get = function(info)
				return SN.data.profile.frames[info[#info]] 
			end,
			set = function(info, value)
				SN:FrameMoverPopUp(value)
			end,
		},
		reset = {
			type = "execute",
			name = L["Reset Frames"],
			func = function()
				if InCombatLockdown() then 
					SN:Print(L["Can not do that while in combat"])
				else
					SN:ResetAnchors()
				end
			end,
		},
		debug = {
			order = 8,
			name = L["Debug Mode"],
			type = "toggle",
			get = function()
				return SN.data.profile.debug.enable 
			end,
			set = function(info, value)
				SN.data.profile.debug.enable = value
			end,
		},
		minimap = {
			order = 9,
			name = L["Minimap"],
			type = "toggle",
			get = function()
				return not SN.data.profile.minimap.hide
			end,
			set = function(info, value)
				SN.data.profile.minimap.hide = not value
				if value then 
					SN.minimap:Show("SerenityNow") 
				else 
					SN.minimap:Hide("SerenityNow") 
				end
			end,
		},
	}
	for k, v in pairs(moduleOptions) do
		SN.options.args[k] = (type(v) == "function") and v() or v
	end
	return SN.options
end

function SN:LoadConfig()
	SN.options.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(SN.data)
	LibStub("LibDualSpec-1.0"):EnhanceOptions(SN.options.args.profile, SN.data)

	LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("SN", getOptions)
	LibStub("AceConfigDialog-3.0"):AddToBlizOptions("SN", "Serenity Now")
	SN:RegisterModuleOptions("Profile", LibStub("AceDBOptions-3.0"):GetOptionsTable(SN.data), "Profile")
end

function SN:FrameMoverPopUp(value)
	SN:MoveFrames(value)
	F.FrameMoverPopUp = CreateFrame("Frame", "FrameMoverPopUp", UIParent)
	F.FrameMoverPopUp:SetSize(250, 50)
	F.FrameMoverPopUp:SetPoint("CENTER", nil, "CENTER", 0, 300)
	F.FrameMoverPopUp:SetFrameStrata("DIALOG")
	F.FrameMoverPopUp:SetToplevel(true)
	F.FrameMoverPopUp:EnableMouse(true)
	F.FrameMoverPopUp:SetMovable(true)
	F.FrameMoverPopUp:SetFrameLevel(99)
	F.FrameMoverPopUp:SetClampedToScreen(true)

	if (IsAddOnLoaded("ElvUI")) then
		SN:SNCreateBG(F.FrameMoverPopUp, "Frame")
	else
		F.FrameMoverPopUp:SetBackdrop({
			bgFile = M.media.blankTex, 
			edgeFile = M.media.blankTex, 
			tile = false, tileSize = 0, edgeSize = 2, 
			insets = { left = 2, right = 2, top = 2, bottom = 2 }
			})
		F.FrameMoverPopUp:SetBackdropColor(0.1, 0.1, 0.1, 0.8)
		F.FrameMoverPopUp:SetBackdropBorderColor(0.1, 0.1, 0.1, 1)
	end

	F.FrameMoverPopUp.text = F.FrameMoverPopUp:CreateFontString(nil, "ARTWORK")
	F.FrameMoverPopUp.text:SetFont(M.media.font, 12, "OUTLINE")
	F.FrameMoverPopUp.text:SetText(L["Frame Mover"])
	F.FrameMoverPopUp.text:SetAllPoints(F.FrameMoverPopUp)
	F.FrameMoverPopUp.text:SetJustifyH("CENTER")
	F.FrameMoverPopUp.text:SetJustifyV("TOP")

	F.FrameMoverPopUp.lock = CreateFrame("Button", "FrameMoverPopUpCloseButton", F.FrameMoverPopUp, "OptionsButtonTemplate")
	F.FrameMoverPopUp.lock:SetText(L["Lock"])
	if (IsAddOnLoaded("ElvUI")) then
		SN:SNCreateBG(F.FrameMoverPopUp.lock, "Button")
	end
	F.FrameMoverPopUp.lock:SetPoint("BOTTOM", F.FrameMoverPopUp, "BOTTOM", 0, 5)
	F.FrameMoverPopUp.lock:SetWidth(50)

	F.FrameMoverPopUp.lock:SetScript("OnClick", function(self)
		F.FrameMoverPopUp:Hide()
		F.FrameMoverPopUp = nil
		SN:MoveFrames(true)
	end)
end

function SN:RegisterModuleOptions(name, optTable, displayName)
	moduleOptions[name] = optTable
	LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("SN"..name, optTable)
end