SecondJobQuestVars[3] = LibStub("AceAddon-3.0"):NewAddon("SJ", "AceConsole-3.0", "AceEvent-3.0", "AceHook-3.0")
local SJ=SecondJobQuestVars[3]
local PREFIX = "[SecondJob]"
local VERSION="r60"
local characterInfo = nil
local debug=false
local allowUpdates=true
local questList=SecondJobQuestVars[1]
local order=SecondJobQuestVars[2]


SJ.defaults = {
	char = {
		icon = {
			hide = false,
		},
		framePosition = {
			x = 0,
			y = 0,
			anchor = "CENTER"
		},
		frameVisibility ={
			hide = false
		},
		showLoginMessage=true,
		tracked={
			--MoP Stuff
			Sha=true,
			galleon=false,
			Oondasta=false,
			Nalak=false,
			Cele=false,
			Ordos=false,
			ElderCharms=true,
			Blingtron=true,
			Klaxxi=true,
			KlaxxiRev=false,
			GoldenLotus=true,
			ShadoPan=false,
			AugustCelestials=false,
			ShieldWall=true,
			DominanceOffensive=false,
			Anglers=true,
			Anglersfish=false,
			TillersCooking=false,
			Tillers=false,
			CookingApprentice=false,
			CloudSerpentsHonored=false,
			KirinTorOffensive=false,
			SunreaverOnslaught=false,
			--CloudSerpentsRevered=false,
			Lorewalkers=false,
			TillersWorkOrders=false,

			--Cataclysm Stuff
			Ramkahen=false,
			WildhammerClan=false,
			DragonmawClan=false,
			TherazaneHonored=false,
			TherazaneRevered=false,
			BaradinsWardensTB=false,
			BaradinsWardensTBP=false,

			--Wrath Stuff
			WrathRaid=false,

			--Professions
			CataFishing=false,
			WrathFishing=false,
			BCFishing=false,
			CataCooking=false,
			WrathCooking=false,
			BCCooking=false,
			WrathJC=false,
			CataJC=false
		}
	},
}
SJ.LDB = LibStub("LibDataBroker-1.1"):NewDataObject("SJList", {
	type = "launcher",
	text = "SecondJob",
	icon = "Interface\\CURSOR\\QuestRepeatable.blp",
	OnTooltipShow = function(tt)
		tt:AddLine("SecondJob")
		tt:AddLine("|cffffff00" .. "Left Click to open options")
		tt:AddLine("|cffffff00" .. "Right Click to show/hide tracking frame")
	end,
	OnClick = function(self, button) if button=="LeftButton" then SJ:showOptions() end if button=="RightButton" then SJ:toggleFrame() end end,
})
SJ.icon = LibStub("LibDBIcon-1.0")

function SJ:RecreateTrackingFrame()

	for k,v in pairs(self.sjquestFrame.quests) do 
		self.sjquestFrame.quests[k].headerText:SetText("")
		self.sjquestFrame.quests[k]=nil 
	end
	local offset = 0
	offset = offset + 18
	local name=""
	local group={}
	for i=1, table.getn(order), 1 do	
		group=questList[order[i]]
		name=order[i]
		if self.db.char.tracked[name] then
			self:CreateQuestInSJquestFrame(group["name"],name, offset)
			offset = offset + 16
		end
	end
end

function SJ:CreateTrackingFrame()
    self.sjquestFrame = CreateFrame("Frame","sjquestFrame",UIParent)
	self.sjquestFrame:SetMovable(true)
	self.sjquestFrame:EnableMouse(true)
	self.sjquestFrame:SetClampedToScreen(true)
	self.sjquestFrame:RegisterForDrag("LeftButton")
	self.sjquestFrame:SetScript("OnDragStart", function(frame)
			frame:StartMoving() 
	end)
	local blank;
	self.sjquestFrame:SetScript("OnDragStop", function(frame)
			frame:StopMovingOrSizing()
			self.db.char.framePosition.anchor, blank, blank, self.db.char.framePosition.x, self.db.char.framePosition.y = frame:GetPoint()
		end)
	self.sjquestFrame:SetBackdropColor(0,0,0,1);
	self.sjquestFrame:SetHeight(200)
	self.sjquestFrame:SetWidth(200)
	self.sjquestFrame:SetAlpha(1.0)
	
	-- Create empty array to store quests
	self.sjquestFrame.quests = {}
	
	-- Vertical offset to keep track of position of new text lines
	local offset = 0
	
	-- Create the title text
	local title = self.sjquestFrame:CreateFontString("TitleText", nil, "GameFontNormalLarge")
	title:SetText("|cffFFB90FSecondJob|r")
	title:SetPoint("TOPLEFT", self.sjquestFrame, "TOPLEFT", -4, -offset)
	title:Show()
	
	-- Adjust offset for beginning of list
	offset = offset + 18
	local name=""
	local group ={}
	for i=1, table.getn(order), 1 do	
		group=questList[order[i]]
		name=order[i]
		if self.db.char.tracked[name] then
			self:CreateQuestInSJquestFrame(group["name"],name, offset)
		
		offset = offset + 16
		end
	end

	self.sjquestFrame:SetHeight(32)
	self.sjquestFrame:SetPoint(self.db.char.framePosition.anchor, nil, self.db.char.framePosition.anchor, self.db.char.framePosition.x, self.db.char.framePosition.y-16)
	self.sjquestFrame:SetPoint("TOPLEFT", 5, 15)
end

function SJ:CreateQuestInSJquestFrame(questTitle, questId, offset)
	self.sjquestFrame.quests[questId] = {}
	local mytext=SJ:isGroupCompletedByIndex(questId)
	self.sjquestFrame.quests[questId].headerText = self.sjquestFrame:CreateFontString("QuestHeader"..questId, nil, "ChatFontNormal")
	self.sjquestFrame.quests[questId].headerText:SetText(questTitle.." "..mytext)
	self.sjquestFrame.quests[questId].headerText:SetPoint("TOPLEFT", self.sjquestFrame, "TOPLEFT", 16, -offset)
	self.sjquestFrame.quests[questId].headerText:Show()
	
end

function SJ:toggleFrame()
	if not self.sjquestFrame:IsShown() then
		SJ.db.char.frameVisibility.hide=false
		self.sjquestFrame:Show()
		cbTrackingFrame:SetChecked(true) 
		allowUpdates=true
	else
		self.sjquestFrame:Hide()
		SJ.db.char.frameVisibility.hide=true
		cbTrackingFrame:SetChecked(false) 
		allowUpdates=false
	end
end

function SJ:toggleDebug()
	if debug then
		debug=false
		DEFAULT_CHAT_FRAME:AddMessage("Debug disabled")
	else
		debug=true
		DEFAULT_CHAT_FRAME:AddMessage("Debug enabled!")
	end
end

function SJ:OnInitialize()

	RegisterAddonMessagePrefix(PREFIX)
	SJ:RegisterChatCommand("sj_toggle", "toggleFrame")
	SJ:RegisterChatCommand("sj_toggle_debug", "toggleDebug")
	SJ:RegisterChatCommand("sj_refresh", "Refresh")
	SJ:RegisterChatCommand("sj_version", "version")
	SJ:RegisterChatCommand("sj_test2", "test2")
	SJ:RegisterChatCommand("sj_options", "showOptions")
	self.db = LibStub("AceDB-3.0"):New("SecondJobDB", self.defaults,global)
	self.icon:Register("SJList", self.LDB, self.db.char.icon)
	self:CreateTrackingFrame()
	if SJ.db.char.frameVisibility.hide then
		self.sjquestFrame:Hide()
		allowUpdates=false
	end
	SJ:loadOptionsFrame()
	--fsSJVersionNum:setText(VERSION)
	fsSJVersionNum:SetText(VERSION)
	frmOptions:Hide()
end

function SJ:OnEnable()
	if self.db.char.showLoginMessage then
		self:Print("Addon SecondJob enabled.  Use '/sj_options' to configure")
	end
	characterInfo = UnitName("player").."|"..GetRealmName().."|"..string.upper(UnitFactionGroup("player"))

	-- ADD options panels to blizz addons interface options area
	frmOptions2.name="SecondJob"
	frmOptions2.okay= function (self)   SJ:Button1_OnClick()  end --DEFAULT_CHAT_FRAME:AddMessage("OK1 clicked")
	frmOptions2.cancel = function (self)  SJ:loadOptionsFrame()  end -- NEED TO WRITE CANCEL FUNCTION
	InterfaceOptions_AddCategory(frmOptions2)

	frmOptions.name="SJ: MoP"
	frmOptions.parent="SecondJob"
	--frmOptions.okay= Not needed. All will be handled in the parent's OK button, apparently.
	InterfaceOptions_AddCategory(frmOptions)
	frmOptionsCata.name="SJ: Cata"
	frmOptionsCata.parent="SecondJob"
	InterfaceOptions_AddCategory(frmOptionsCata)

	frmWrathOptions.name="SJ: Wrath"
	frmWrathOptions.parent="SecondJob"
	InterfaceOptions_AddCategory(frmWrathOptions)

	frmProfessions.name="SJ: Professions"
	frmProfessions.parent="SecondJob"
	InterfaceOptions_AddCategory(frmProfessions)

	frmOptions:Hide()
	frmOptions2:Hide()
	frmOptionsCata:Hide()
	frmProfessions:Hide()
	frmWrathOptions:Hide()

end

function SJ:version()
	self:Print("Version:"..VERSION)

end
--[[
function SJ:Test()
	local j=1
	--for i=1,GetNumTradeSkills() do
	for i=GetNumTradeSkills(), 1, -1 do
	--for i=1,100 do
		local cooldown = GetTradeSkillCooldown(i)
		local name = GetTradeSkillInfo(i)
		if name=="Sha Crystal" then
	
			print("sha crystal"..cooldown)
		end
		if name=="Scroll of Wisdom" then
	
			print("Scroll of Wisdom"..cooldown)
		end

	--	if cooldown then
        
	--	   print("Cooldown remaining for " .. name .. "("..i.."): " .. SecondsToTime(cooldown))
	--	print(name)
	--	end
		j=j+1
	end
	prof1, prof2, archaeology, fishing, cooking, firstAid = GetProfessions()
	print("prof1: "..GetProfessionInfo(prof1))
	print("prof2: "..GetProfessionInfo(prof2))

	print (j.." total")
end
--]]

local frame, events = CreateFrame("Frame"), {};
function events:QUEST_FINISHED(...)
if debug then DEFAULT_CHAT_FRAME:AddMessage("Event QUEST_FINISHED Fired!") end
SJ:Refresh()
end
function events:QUEST_LOG_UPDATE(...)
if debug then DEFAULT_CHAT_FRAME:AddMessage("Event QUEST_LOG_UPDATE Fired") end
SJ:Refresh()
end
frame:SetScript("OnEvent", function(self, event, ...)
 events[event](self, ...); -- call one of the functions above
end);
for k, v in pairs(events) do
 frame:RegisterEvent(k); -- Register all events for which handlers have been defined
end

local total=0

function SJ:Refresh()
	if debug then DEFAULT_CHAT_FRAME:AddMessage("Start refresh!") end
	SJ:updateGroups()
end

local function onUpdate(self,elapsed)
    total = total + elapsed
    if total >= 30 then
       if debug then DEFAULT_CHAT_FRAME:AddMessage("Start refresh!") end
		if allowUpdates then
			SJ:Refresh()
		end
		total=0
    end
end
local f = CreateFrame("frame")
f:SetScript("OnUpdate", onUpdate)
function SJ:isGroupCompletedByIndex(index)
	local completed="N"
	local group=questList[index]["quests"]
	for questInd, quest in pairs(group) do
		if type(quest)~="table" then 
			if debug then DEFAULT_CHAT_FRAME:AddMessage("checkingquest "..quest) end
			if  IsQuestFlaggedCompleted(quest) then
				completed="Y"
			else
				completed="N"
			end
		else 
			for id, q in pairs(quest) do 
				completed="N"
				if type(q)~="table" then	
					if debug then DEFAULT_CHAT_FRAME:AddMessage("checkingq "..q) end
					if  IsQuestFlaggedCompleted(q) then
						completed="Y"
					end
				else 
					local quantity=1
					
					quantity=q["qty"]
					--print("quantity "..quantity )
					local quests=q["quests"]
					local counter=0
					for id1, q1 in pairs(quests) do
						--if debug then DEFAULT_CHAT_FRAME:AddMessage("checkingq1 "..q1) end
						--print("checkingq1 in "..index.." "..q1[1])
						if  IsQuestFlaggedCompleted(q1) then
							if debug then DEFAULT_CHAT_FRAME:AddMessage("completed:  "..q1) end
							counter=counter+1
							if counter>=quantity then
								completed="Y"

								break
							end
						end
					end
				
				end
				if completed=="N" then break end
			end		
			if completed=="Y" then break end
		end
		
	end
	
	if completed=="N" then
		if index=="ElderCharms" then
			local name, currentAmount, texture, earnedThisWeek, weeklyMax, totalMax, isDiscovered = GetCurrencyInfo(738)
			if currentAmount>=50 then
				completed = "|cFFFF0000N |cFF00FF00("..currentAmount..")|r"	
			else
				completed = "|cFFFF0000N ("..currentAmount..")|r"
			end
		else
			completed="|cFFFF0000N|r"
		end
    else
		completed="|cFF00FF00Y|r"
	end
	if debug then DEFAULT_CHAT_FRAME:AddMessage(" status: "..completed) end
	return completed	
end
--[[function SJ:isGroupCompletedByIndex(index)
	local completed="N"
	local group=questList[index]["quests"]
	for questInd, quest in pairs(group) do
		if type(quest)~="table" then 
			if debug then DEFAULT_CHAT_FRAME:AddMessage("checkingquest "..quest) end
			if  IsQuestFlaggedCompleted(quest) then
				completed="Y"
			else
				completed="N"
			end
		else 
			for id, q in pairs(quest) do 
				completed="N"
				if type(q)~="table" then	
					if debug then DEFAULT_CHAT_FRAME:AddMessage("checkingq "..q) end
					if  IsQuestFlaggedCompleted(q) then
						completed="Y"
					end
				else 
			
					for id1, q1 in pairs(q) do
						if debug then DEFAULT_CHAT_FRAME:AddMessage("checkingq1 "..q1) end
						if  IsQuestFlaggedCompleted(q1) then
							completed="Y"
							break
						end
					end
				
				end
				if completed=="N" then break end
			end		
			if completed=="Y" then break end
		end
		
	end
	
	if completed=="N" then
		if index=="ElderCharms" then
			name, currentAmount, texture, earnedThisWeek, weeklyMax, totalMax, isDiscovered = GetCurrencyInfo(738)
			if currentAmount>=90 then
				completed = "|cFFFF0000N |cFF00FF00("..currentAmount..")|r"	
			else
				completed = "|cFFFF0000N ("..currentAmount..")|r"
			end
		else
			completed="|cFFFF0000N|r"
		end
    else
		completed="|cFF00FF00Y|r"
	end
	if debug then DEFAULT_CHAT_FRAME:AddMessage(" status: "..completed) end
	return completed	
end--]]


function SJ:updateGroups()
	local name=""
	local group={}
	for i=1, table.getn(order), 1 do	
		
		group=questList[order[i]]
		name=order[i]
		local c="N"
		if self.db.char.tracked[name] then	
			c=SJ:isGroupCompletedByIndex(name)
			if debug then DEFAULT_CHAT_FRAME:AddMessage(name .. "|" .. group["name"].."|".. c) end
			self.sjquestFrame.quests[name].headerText:SetText(group["name"].." "..c)
			--self.sjquestFrame.quests[name].headerText:SetText(c .. " " ..group["name"])
		end
	end
end

--hide the options panel when it's loaded.
--[[
function SJ:frmOptions_OnLoad()
	frmOptions:Hide()
end
--]]
--show the options panel
function SJ:showOptions()

	allowUpdates=false
	--frmOptions:Show()
	InterfaceOptionsFrame_OpenToCategory("SecondJob")

end

--another test function
function SJ:test2()
--[[	self.db.char.icon.hide= not self.db.char.icon.hide
	if self.db.char.icon.hide then
		self.icon:Hide("SJList")
	else
		self.icon:Show("SJList")
	end--]]
--	self:createTabOptions()
end

--load the variables into the checkboxes.
function SJ:loadOptionsFrame()
	if self.db.char.tracked.Sha then
		cbSha:SetChecked(true)
	end
	if self.db.char.tracked.Galleon then
		cbGalleon:SetChecked(true)
	end
	if self.db.char.tracked.Oondasta then
		cbOondasta:SetChecked(true)
	end
	if self.db.char.tracked.Nalak then
		cbNalak:SetChecked(true)
	end
	if self.db.char.tracked.Cele then
		cbCele:SetChecked(true)
	end
	if self.db.char.tracked.Ordos then
		cbOrdos:SetChecked(true)
	end
	if self.db.char.tracked.ElderCharms then
		cbElder:SetChecked(true)
	end
	if self.db.char.tracked.Blingtron then
		cbBling:SetChecked(true)
	end
	if self.db.char.tracked.Klaxxi then
		cbKlaxxi:SetChecked(true)
	end	
	if self.db.char.tracked.KlaxxiRev then
		cbKlaxxiRev:SetChecked(true)
	end	
	if self.db.char.tracked.GoldenLotus then
		cbGoldenLotus:SetChecked(true)
	end
	if self.db.char.tracked.ShadoPan then
		cbShadoPan:SetChecked(true)
	end
	if self.db.char.tracked.AugustCelestials then
		cbAugCele:SetChecked(true)
	end
	if self.db.char.tracked.ShieldWall then
		cbShieldWall:SetChecked(true)
	end
	if self.db.char.tracked.DominanceOffensive then
		cbShieldWall:SetChecked(true)
	end
	if self.db.char.tracked.Anglers then
		cbAnglers:SetChecked(true)
	end
	if self.db.char.tracked.AnglersFish then
		cbAnglersFish:SetChecked(true)
	end
	if self.db.char.tracked.TillersCooking then
		cbTillersCooking:SetChecked(true)
	end
	if self.db.char.tracked.Tillers then
		cbTillers:SetChecked(true)
	end
	if self.db.char.tracked.CookingApprentice then
		cbCookingApprentice:SetChecked(true)
	end
	if self.db.char.tracked.CloudSerpentsHonored then
		cbCloudSerpentsHonored:SetChecked(true)
	end
	--[[if self.db.char.tracked.CloudSerpentsRevered then
		cbCloudSerpentsRevered:SetChecked(true)
	end--]]
	if self.db.char.tracked.Lorewalkers then
		cbLorewalkers:SetChecked(true)
	end
	if self.db.char.tracked.TillersWorkOrders then
		cbTillersWorkOrders:SetChecked(true)
	end

	if self.db.char.tracked.KirinTorOffensive then
		cbKirinTorOffensive:SetChecked(true)
	end
	if self.db.char.tracked.SunreaverOnslaught then
		cbSunreaverOnslaught:SetChecked(true)
	end
	if self.db.char.tracked.Ramkahen then
		cbRamkahen:SetChecked(true)
	end
	if self.db.char.tracked.WildhammerClan then
		cbWildhammerClan:SetChecked(true)
	end
	if self.db.char.tracked.DragonmawClan then
		cbDragonmawClan:SetChecked(true)
	end
	if self.db.char.tracked.TherazaneHonored then
		cbTherazaneHonored:SetChecked(true)
	end
	if self.db.char.tracked.TherazaneRevered then
		cbTherazaneRevered:SetChecked(true)
	end
	if self.db.char.tracked.BaradinsWardensTB then
		cbBaradinsWardensTB:SetChecked(true)
	end
	if self.db.char.tracked.BaradinsWardensTBP then
		cbBaradinsWardensTBP:SetChecked(true)
	end
	if self.db.char.tracked.CataFishing then
		cbCataFishing:SetChecked(true)
	end
	if self.db.char.tracked.WrathFishing then
		cbWrathFishing:SetChecked(true)
	end
	if self.db.char.tracked.BCFishing then
		cbBCFishing:SetChecked(true)
	end
	if self.db.char.tracked.WrathRaid then
		cbWrathRaid:SetChecked(true)
	end
	
	if self.db.char.tracked.CataCooking then
		cbCataCooking:SetChecked(true)
	end
	if self.db.char.tracked.WrathCooking then
		cbWrathCooking:SetChecked(true)
	end
	if self.db.char.tracked.BCCooking then
		cbBCCooking:SetChecked(true)
	end
	if self.db.char.tracked.WrathJC then
		cbWrathJC:SetChecked(true)
	end
	if self.db.char.tracked.CataJC then
		cbCataJC:SetChecked(true)
	end
	--Config Options
	if not self.db.char.icon.hide then
		cbMiniMapIcon:SetChecked(true)
	end
	if not self.db.char.frameVisibility.hide then
		cbTrackingFrame:SetChecked(true) 
	end
		if self.db.char.showLoginMessage then
		cbShowMessage:SetChecked(true)
	end
	btnSJOK:SetScript("OnClick", function() SJ:Button1_OnClick() end)
end

--[[the OK button in the options panel. When clicked, change the tracking frame.
--]]
function SJ:Button1_OnClick()
	if cbSha:GetChecked() then
		self.db.char.tracked.Sha=true	
	else
		self.db.char.tracked.Sha=false
	end
	if cbGalleon:GetChecked() then
		self.db.char.tracked.Galleon=true	
	else
		self.db.char.tracked.Galleon=false
	end
	if cbOondasta:GetChecked() then
		self.db.char.tracked.Oondasta=true	
	else
		self.db.char.tracked.Oondasta=false
	end
	if cbNalak:GetChecked() then
		self.db.char.tracked.Nalak=true	
	else
		self.db.char.tracked.Nalak=false
	end
	if cbCele:GetChecked() then
		self.db.char.tracked.Cele=true	
	else
		self.db.char.tracked.Cele=false
	end
	if cbOrdos:GetChecked() then
		self.db.char.tracked.Ordos=true	
	else
		self.db.char.tracked.Ordos=false
	end
	if cbElder:GetChecked() then
		self.db.char.tracked.ElderCharms=true	
	else
		self.db.char.tracked.ElderCharms=false
	end
	
	if cbBling:GetChecked() then
		self.db.char.tracked.Blingtron=true	
	else
		self.db.char.tracked.Blingtron=false
	end
	
	if cbKlaxxi:GetChecked() then
		self.db.char.tracked.Klaxxi=true	
	else
		self.db.char.tracked.Klaxxi=false
	end

	if cbKlaxxiRev:GetChecked() then
		self.db.char.tracked.KlaxxiRev=true	
	else
		self.db.char.tracked.KlaxxiRev=false
	end
	
	if cbGoldenLotus:GetChecked() then
		self.db.char.tracked.GoldenLotus=true	
	else
		self.db.char.tracked.GoldenLotus=false
	end
	
	if cbShadoPan:GetChecked() then
		self.db.char.tracked.ShadoPan=true	
	else
		self.db.char.tracked.ShadoPan=false
	end
	
	if cbAugCele:GetChecked() then
		self.db.char.tracked.AugustCelestials=true	
	else
		self.db.char.tracked.AugustCelestials=false
	end
	
	if cbShieldWall:GetChecked() then
		self.db.char.tracked.ShieldWall=true	
	else
		self.db.char.tracked.ShieldWall=false
	end

	if cbDominanceOffensive:GetChecked() then
		self.db.char.tracked.DominanceOffensive=true	
	else
		self.db.char.tracked.DominanceOffensive=false
	end
	if cbAnglers:GetChecked() then
		self.db.char.tracked.Anglers=true	
	else
		self.db.char.tracked.Anglers=false
	end
	if cbAnglersFish:GetChecked() then
		self.db.char.tracked.AnglersFish=true	
	else
		self.db.char.tracked.AnglersFish=false
	end
	if cbTillersCooking:GetChecked() then
		self.db.char.tracked.TillersCooking=true	
	else
		self.db.char.tracked.TillersCooking=false
	end
	if cbTillers:GetChecked() then
		self.db.char.tracked.Tillers=true	
	else
		self.db.char.tracked.Tillers=false
	end
	if cbCookingApprentice:GetChecked() then
		self.db.char.tracked.CookingApprentice=true	
	else
		self.db.char.tracked.CookingApprentice=false
	end
	if cbCloudSerpentsHonored:GetChecked() then
		self.db.char.tracked.CloudSerpentsHonored=true	
	else
		self.db.char.tracked.CloudSerpentsHonored=false
	end
	if cbKirinTorOffensive:GetChecked() then
		self.db.char.tracked.KirinTorOffensive=true	
	else
		self.db.char.tracked.KirinTorOffensive=false
	end
	if cbSunreaverOnslaught:GetChecked() then
		self.db.char.tracked.SunreaverOnslaught=true	
	else
		self.db.char.tracked.SunreaverOnslaught=false
	end
	--[[if cbCloudSerpentsRevered:GetChecked() then
		self.db.char.tracked.CloudSerpentsRevered=true	
	else
		self.db.char.tracked.CloudSerpentsRevered=false
	end--]]
	if cbLorewalkers:GetChecked() then
		self.db.char.tracked.Lorewalkers=true	
	else
		self.db.char.tracked.Lorewalkers=false
	end
	if cbTillersWorkOrders:GetChecked() then
		self.db.char.tracked.TillersWorkOrders=true	
	else
		self.db.char.tracked.TillersWorkOrders=false
	end
	if cbRamkahen:GetChecked() then
		self.db.char.tracked.Ramkahen=true	
	else
		self.db.char.tracked.Ramkahen=false
	end
	if cbWildhammerClan:GetChecked() then
		self.db.char.tracked.WildhammerClan=true	
	else
		self.db.char.tracked.WildhammerClan=false
	end
	if cbDragonmawClan:GetChecked() then
		self.db.char.tracked.DragonmawClan=true	
	else
		self.db.char.tracked.DragonmawClan=false
	end

	if cbTherazaneHonored:GetChecked() then
		self.db.char.tracked.TherazaneHonored=true	
	else
		self.db.char.tracked.TherazaneHonored=false
	end
	if cbTherazaneRevered:GetChecked() then
		self.db.char.tracked.TherazaneRevered=true	
	else
		self.db.char.tracked.TherazaneRevered=false
	end
	if cbBaradinsWardensTB:GetChecked() then
		self.db.char.tracked.BaradinsWardensTB=true	
	else
		self.db.char.tracked.BaradinsWardensTB=false
	end
	if cbBaradinsWardensTBP:GetChecked() then
		self.db.char.tracked.BaradinsWardensTBP=true	
	else
		self.db.char.tracked.BaradinsWardensTBP=false
	end

	if cbCataFishing:GetChecked() then
		self.db.char.tracked.CataFishing=true	
	else
		self.db.char.tracked.CataFishing=false
	end
	if cbWrathFishing:GetChecked() then
		self.db.char.tracked.WrathFishing=true	
	else
		self.db.char.tracked.WrathFishing=false
	end
	if cbBCFishing:GetChecked() then
		self.db.char.tracked.BCFishing=true	
	else
		self.db.char.tracked.BCFishing=false
	end

	if cbCataCooking:GetChecked() then
		self.db.char.tracked.CataCooking=true	
	else
		self.db.char.tracked.CataCooking=false
	end

	if cbWrathCooking:GetChecked() then
		self.db.char.tracked.WrathCooking=true	
	else
		self.db.char.tracked.WrathCooking=false
	end

	if cbBCCooking:GetChecked() then
		self.db.char.tracked.BCCooking=true	
	else
		self.db.char.tracked.BCCooking=false
	end
	if cbWrathRaid:GetChecked() then
		self.db.char.tracked.WrathRaid=true	
	else
		self.db.char.tracked.WrathRaid=false
	end
	if cbWrathJC:GetChecked() then
		self.db.char.tracked.WrathJC=true	
	else
		self.db.char.tracked.WrathJC=false
	end
	if cbCataJC:GetChecked() then
		self.db.char.tracked.CataJC=true	
	else
		self.db.char.tracked.CataJC=false
	end
	if cbMiniMapIcon:GetChecked() then
		self.db.char.icon.hide=false
		self.icon:Show("SJList")
	else
		self.db.char.icon.hide=true
		self.icon:Hide("SJList")
	end
	if cbShowMessage:GetChecked() then
		self.db.char.showLoginMessage=true	
	else
		self.db.char.showLoginMessage=false
	end
	if cbTrackingFrame:GetChecked() then
		SJ.db.char.frameVisibility.hide=false
		self.sjquestFrame:Show()
		allowUpdates=true
	else
		SJ.db.char.frameVisibility.hide=true
		self.sjquestFrame:Hide()
		allowUpdates=false
	end
		
	frmOptions:Hide()
	SJ:RecreateTrackingFrame()
	--allowUpdates=true

end
