local ADDON, data = ...

function SanityCheck_CreateOptions ()
    -- Default values!
    g_SanityCheck_config = g_SanityCheck_config or {}

    g_SanityCheck_config.EnchMinLvl = g_SanityCheck_config.EnchMinLvl or 483
    g_SanityCheck_config.GemMinLvl = g_SanityCheck_config.GemMinLvl or 483
    
    --g_SanityCheck_config.StrictStats = g_SanityCheck_config.Strict or true -- Err... this doesn't work for booleans. And isn't necessary :P

    g_SanityCheck_config.ReadyToRaid = g_SanityCheck_config.ReadyToRaid or {}
    g_SanityCheck_config.ReadyToRaid.Flask = g_SanityCheck_config.ReadyToRaid.Flask or {[3]=true, [4]=true}
    g_SanityCheck_config.ReadyToRaid.Food = g_SanityCheck_config.ReadyToRaid.Food or {[3]=true, [4]=true}

    -- GUI stuff!
    local Options = CreateFrame ("Frame", "SanityCheckOptions", UIParent);
    Options.name = "SanityCheck";
    Options.okay = SaveOptions
    Options:Hide ()
    InterfaceOptions_AddCategory(Options);
    
    Options.okay = function ()
        --
    end
    
    Options.refresh = function ()
        for i=1, #data.difficulties do
            Options.CheckFlask[i]:SetChecked (g_SanityCheck_config.ReadyToRaid.Flask[i])
            Options.CheckFood[i]:SetChecked (g_SanityCheck_config.ReadyToRaid.Food[i])
        end
        Options.txtEnchMinLvl:SetNumber (tonumber(g_SanityCheck_config.EnchMinLvl))
        Options.txtGemMinLvl:SetNumber (tonumber(g_SanityCheck_config.GemMinLvl))
        Options.chkStrictStats:SetChecked (g_SanityCheck_config.StrictStats)
        Options.chkHideWhenAwesome:SetChecked (g_SanityCheck_config.HideWhenAwesome)
        SanityCheck_ddSkinsText:SetText (g_SanityCheck_config.skin or 'Classic')
    end

    local Title = Options:CreateFontString (nil, "ARTWORK", "GameFontNormalLarge")
    Title:SetPoint("TOPLEFT", 8, -16)
    Title:SetText(Options.name)
    Options.Title = Title

    -- Flasks and food
    local TitleCheckFlask = Options:CreateFontString (nil, "ARTWORK", "GameFontHighlight")
    TitleCheckFlask:SetPoint("TOPLEFT", 8, -48)
    TitleCheckFlask:SetText('Check for:          Flask     Food')
    Options.TitleCheckFlask = TitleCheckFlask

    Options.CheckFlask = {}
    Options.CheckFood = {}
    Options.Labels = {}

    for i=1, #data.difficulties do
        local lbl = Options:CreateFontString (nil, "ARTWORK", "GameFontHighlightSmall")
        lbl:SetPoint("TOPLEFT", TitleCheckFlask, "BOTTOMLEFT", 5, -17 - (i-1)*24)
        lbl:SetText (data.difficulties[i])
        
        table.insert (Options.Labels, lbl)
        
        local chkFlask = CreateFrame ("CheckButton", nil, Options, "UICheckButtonTemplate")
        chkFlask.idx = i
        chkFlask:SetPoint("TOPLEFT", TitleCheckFlask, "BOTTOMLEFT", 95, -6 - (i-1)*24)
        chkFlask:SetScript ("OnClick", function (self, ...)
            g_SanityCheck_config.ReadyToRaid.Flask[self.idx] = self:GetChecked ()
            frmSanityCheck.needAuraScan = true
        end)

        Options.CheckFlask[i] = chkFlask

        local chkFood = CreateFrame ("CheckButton", nil, Options, "UICheckButtonTemplate")
        chkFood.idx = i
        chkFood:SetPoint("TOPLEFT", TitleCheckFlask, "BOTTOMLEFT", 140, -6 - (i-1)*24)        
        chkFood:SetScript ("OnClick", function (self, ...)
            g_SanityCheck_config.ReadyToRaid.Food[self.idx] = self:GetChecked ()
            frmSanityCheck.needAuraScan = true
        end)

        Options.CheckFood[i] = chkFood
    end
    
    
    -- Gems/ enchants 
    local TitleGemsAndEnchants = Options:CreateFontString (nil, "ARTWORK", "GameFontHighlight")
    TitleGemsAndEnchants:SetPoint("TOPLEFT", 8, -190)
    TitleGemsAndEnchants:SetText('Minimum item levels:')
    Options.TitleGemsAndEnchants = TitleGemsAndEnchants

    local function MakeOptionLabel (frm, txt)
        local lbl = frm:CreateFontString(nil, "BACKGROUND", "GameFontHighlightSmall")
        lbl:SetTextColor (1,1,1)
        lbl:SetText (txt)
        lbl:SetJustifyH ("LEFT")
        
        return lbl
    end
    
    local function MakeOptionTextbox (frm)
        local txt = CreateFrame ("EditBox", nil, frm)
        txt:SetBackdrop ({
            bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",  
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
            tile = true,
            tileSize = 32,
            edgeSize = 8,
        })
        txt:SetTextColor (1,1,1)
        txt:SetFont ('Fonts\\ARIALN.TTF', 14, "")
        txt:SetAutoFocus (false)
        txt:SetTextInsets (4, 4, 0, 0)
        txt:SetScript ("OnEscapePressed", txt.ClearFocus)
        txt:SetNumeric (true)
        
        return txt
    end
    
    Options.lblEnchMinLvl = MakeOptionLabel (Options, "Don't require enchants on items lower than ilvl:")
    Options.lblEnchMinLvl:SetPoint ("TOPLEFT", TitleGemsAndEnchants, "TOPLEFT", 5, -20)
    Options.lblEnchMinLvl:SetSize (154, 34)
    
    Options.txtEnchMinLvl = MakeOptionTextbox (Options)
    Options.txtEnchMinLvl:SetPoint ("TOPLEFT", TitleGemsAndEnchants, "TOPLEFT", 170, -27)
    Options.txtEnchMinLvl:SetSize (46, 22)
    Options.txtEnchMinLvl:SetScript ("OnEditFocusLost", function (self)
        g_SanityCheck_config.EnchMinLvl = self:GetNumber()
        frmSanityCheck.needGearScan = true
    end)
    Options.txtEnchMinLvl:SetScript ("OnEditFocusGained", function (self)
        self:HighlightText ()
    end)
    
    -- 
    Options.lblGemMinLvl = MakeOptionLabel(Options, "Don't require gems in items lower than ilvl:")
    Options.lblGemMinLvl:SetPoint ("TOPLEFT", TitleGemsAndEnchants, "TOPLEFT", 5, -50)
    Options.lblGemMinLvl:SetSize (154, 34)
    
    Options.txtGemMinLvl = MakeOptionTextbox (Options)
    Options.txtGemMinLvl:SetPoint ("TOPLEFT", TitleGemsAndEnchants, "TOPLEFT", 170, -57)
    Options.txtGemMinLvl:SetSize (46, 22)
    Options.txtGemMinLvl:SetScript ("OnEditFocusLost", function (self)
        g_SanityCheck_config.GemMinLvl = self:GetNumber()
        frmSanityCheck.needGearScan = true
    end)
    Options.txtGemMinLvl:SetScript ("OnEditFocusGained", function (self)
        self:HighlightText ()
    end)
    
    -- Misc
    local TitleMisc = Options:CreateFontString (nil, "ARTWORK", "GameFontHighlight")
    TitleMisc:SetPoint("TOPLEFT", 8, -300)
    TitleMisc:SetText('Miscellaneous:')
    Options.TitleMisc = TitleMisc

    Options.chkStrictStats = CreateFrame ("CheckButton", '', Options, "InterfaceOptionsCheckButtonTemplate")
    Options.chkStrictStats:SetPoint("TOPLEFT", TitleMisc, "BOTTOMLEFT", 0, -6)
    Options.chkStrictStats.Text:SetText ("Strict stat checking")
    Options.chkStrictStats:SetScript ("OnClick", function (self, ...)
        g_SanityCheck_config.StrictStats = self:GetChecked ()
        frmSanityCheck.needGearScan = true
    end)
    Options.chkStrictStats:SetScript("OnEnter", function(self, motion, ...)
        GameTooltip:SetOwner (self, "ANCHOR_TOPLEFT")
        GameTooltip:AddLine ('Strict stat checking', 1, 1, 0)
        GameTooltip:AddLine ('Disabling this option will prevent SanityCheck from warning you about some stats', 1, 1, 1)
        GameTooltip:AddLine ('that you might find yourself wearing while leveling, e.g. dodge rating for rogues.', 1, 1, 1)
        GameTooltip:Show ()
    end)
    Options.chkStrictStats:SetScript("OnLeave", function(self, motion, ...)
        GameTooltip:Hide ()
    end)

    Options.chkHideWhenAwesome = CreateFrame ("CheckButton", '', Options, "InterfaceOptionsCheckButtonTemplate")
    Options.chkHideWhenAwesome:SetPoint("TOPLEFT", TitleMisc, "BOTTOMLEFT", 0, -31)
    Options.chkHideWhenAwesome.Text:SetText ("Hide UI when everything's awesome")
    Options.chkHideWhenAwesome:SetScript ("OnClick", function (self, ...)
        g_SanityCheck_config.HideWhenAwesome = self:GetChecked ()
        frmSanityCheck.needGearScan = true
        frmSanityCheck.needAuraScan = true
    end)
    Options.chkHideWhenAwesome:SetScript("OnEnter", function(self, motion, ...)
        GameTooltip:SetOwner (self, "ANCHOR_TOPLEFT")
        GameTooltip:AddLine ('Hide when awesome', 1, 1, 0)
        GameTooltip:AddLine ('Enabling this will make the add-on\'s interface disappear when it has nothing to tell you.', 1, 1, 1)
        GameTooltip:AddLine ('That way you can put it somewhere visible, and never see it until it actually has something important for you.', 1, 1, 1)
        GameTooltip:Show ()
    end)
    Options.chkHideWhenAwesome:SetScript("OnLeave", function(self, motion, ...)
        GameTooltip:Hide ()
    end)
    
    -- Skins
    local TitleSkins = Options:CreateFontString (nil, "ARTWORK", "GameFontHighlight")
    TitleSkins:SetPoint("TOPLEFT", 8, -400)
    TitleSkins:SetText('Skins:')
    Options.TitleSkins = TitleSkins
    
    Options.ddSkins = CreateFrame("Button", "SanityCheck_ddSkins", Options, "UIDropDownMenuTemplate")
    Options.ddSkins:SetPoint("TOPLEFT", TitleSkins, "BOTTOMLEFT", 0, -10)
    Options.ddSkins.initialize = function (self)
        local selected = g_SanityCheck_config.skin
        for k,v in pairs(data.skins) do
            info = {} --UIDropDownMenu_CreateInfo()
            info.text = k
            info.value = k
            info.checked = (k == selected  or  (k == 'Classic') and (selected == nil))
            info.func = function (self)
                UIDropDownMenu_SetSelectedID (Options.ddSkins, self:GetID())
                frmSanityCheck_Parent:Hide ()
                local x, y = frmSanityCheck_Parent:GetCenter() 
                g_SanityCheck_config.skin = self:GetText ()
                data.skins[g_SanityCheck_config.skin].build (x,y)
                --frmSanityCheck_Parent:SetPoint("CENTER", UIParent, "BOTTOMLEFT", x, y)
                
                frmSanityCheck.needGearScan = true
                frmSanityCheck.needAuraScan = true
            end
            UIDropDownMenu_AddButton (info)
        end
    end
    UIDropDownMenu_SetWidth (Options.ddSkins, 160);
    UIDropDownMenu_SetButtonWidth (Options.ddSkins, 160)
    UIDropDownMenu_JustifyText (Options.ddSkins, "LEFT")
end

