local ADDON, data = ...
local _G = _G

local STR = "ITEM_MOD_STRENGTH_SHORT"
local AGI = "ITEM_MOD_AGILITY_SHORT"
local INT = "ITEM_MOD_INTELLECT_SHORT"
local SPI = "ITEM_MOD_SPIRIT_SHORT"
local DODGE = "ITEM_MOD_DODGE_RATING_SHORT"
local CRIT = "ITEM_MOD_CRIT_RATING_SHORT"
local PARRY = "ITEM_MOD_PARRY_RATING_SHORT"
local EXP = "ITEM_MOD_EXPERTISE_RATING_SHORT"

data.statNames = {
    [STR] = 'Strength',
    [AGI] = 'Agility',
    [INT] = 'Intellect',
    [SPI] = 'Spirit',
    [DODGE] = 'Dodge',
    [CRIT] = 'Critical Strike',
    [PARRY] = 'Parry',
    [HIT] = 'Hit',
    [EXP] = 'Expertise',
}

data.wrongStats = {
    ["DPS_STR"] = {AGI, INT, SPI},
    ["DPS_AGI"] = {STR, INT, SPI},
    ["DPS_INT"] = {STR, AGI},
    ["DPS_INT_HYBRID"] = {STR, AGI},
    
    ["TANK_STR"] = {AGI, INT, SPI},
    ["TANK_AGI"] = {STR, INT, SPI},
    
    ["HEALER"] = {STR, AGI, EXP, DODGE, PARRY},
}

data.slightlyWrongStats = {
    ["DPS_STR"] = {DODGE, PARRY},
    ["DPS_AGI"] = {DODGE, PARRY},
    ["DPS_INT"] = {DODGE, PARRY, SPI},
    ["DPS_INT_HYBRID"] = {DODGE, PARRY},
    
    ["TANK_STR"] = {},
    ["TANK_AGI"] = {},
    
    ["HEALER"] = {HIT},
}
------------------------------------------------------------------

data.classification = {
    --                   Blood              Frost           Unholy
    ['Death Knight'] =  {"TANK_STR",        "DPS_STR",      "DPS_STR"},
    
    --                   Balance            Feral           Guardian        Resto
    ['Druid'] =         {"DPS_INT_HYBRID",  "DPS_AGI",      "TANK_AGI",     "HEALER"},
    
    --                   BM                 MM              Surv
    ['Hunter'] =        {"DPS_AGI",         "DPS_AGI",      "DPS_AGI"},
    
    --                   Arcane             Fire            Frost
    ['Mage'] =          {"DPS_INT",         "DPS_INT",      "DPS_INT"},
    
    --                   Brewmaster         Mistweaver      Windwalker
    ['Monk'] =          {"TANK_AGI",        "HEALER",       "DPS_AGI"},

    --                   Holy               Protection      Retribution
    ['Paladin'] =       {"HEALER",          "TANK_STR",     "DPS_STR"},
    
    --                   Discipline         Holy            Shadow
    ['Priest'] =        {"HEALER",          "HEALER",       "DPS_INT_HYBRID"},
    
    --                   Assassination      Combat          Subtlety
    ['Rogue'] =         {"DPS_AGI",         "DPS_AGI",      "DPS_AGI"},
    
    --                   Elemental          Enhancement     Restoration
    ['Shaman'] =        {"DPS_INT_HYBRID",  "DPS_AGI",      "HEALER"},

    --                   Affliction         Demonology      Destruction
    ['Warlock'] =       {"DPS_INT",         "DPS_INT",      "DPS_INT"},

    --                   Arms               Fury            Protection
    ['Warrior'] =       {"DPS_STR",         "DPS_STR",      "TANK_STR"},
}

------------------------------------------------------------------

local TANK = 'TANK'
local HEAL = 'HEALER'
local DPS = 'DAMAGER'

data.verbs = {
    [TANK] = 'tank',
    [HEAL] = 'heal',
    [DPS] = 'DPS',
}

data.roles = {
    ['Death Knight'] = {TANK, DPS, DPS},
    ['Druid'] = {DPS, DPS, TANK, HEAL},
    ['Hunter'] = {DPS, DPS, DPS},
    ['Mage'] = {DPS, DPS, DPS},
    ['Monk'] = {TANK, HEAL, DPS},
    ['Paladin'] = {HEAL, TANK, DPS},
    ['Priest'] = {HEAL, HEAL, DPS},
    ['Rogue'] = {DPS, DPS, DPS},
    ['Shaman'] = {DPS, DPS, HEAL},
    ['Warlock'] = {DPS, DPS, DPS},
    ['Warrior'] = {DPS, DPS, TANK},
}

------------------------------------------------------------------
------------------------------------------------------------------

local function BasicAuraMessage (auraName)
    return 'Missing aura: '..auraName
end

local function BasicVerifyAuraExists (auraName)
    return function ()
        if HasAura ('player', auraName) then
            return true, ''
        else
            return false, BasicAuraMessage (auraName)
        end
    end
end
------------------------------------------------------------------

local function BasicVerifyStance (number, name)
    return function ()
        local form = _G.GetShapeshiftForm ()
        if form==number or (form~=0 and number=='any') then
            return true, ''
        else
            return false, 'You should probably use '..name
        end
    end
end

------------------------------------------------------------------

function HasAura (unit, aura)
    local name = _G.UnitAura (unit,aura) or _G.UnitDebuff (unit, aura)
    return name~=nil
end

------------------------------------------------------------------

function CountAurasFromList (unit, tblAuras)
    local ret = 0
    for i,aura in pairs(tblAuras) do
        if HasAura(unit, aura) then
            ret = ret+1
        end
    end
    
    return ret
end

------------------------------------------------------------------

function GetItemInfoBySlot (unit, slot)
    local link = _G.GetInventoryItemLink (unit, slot)
    if not link then return nil end
    
    name, link, quality, iLevel, reqLevel, class, subclass, maxStack, equipSlot, texture, vendorPrice = _G.GetItemInfo(link) 
    ret = {
        ['name'] = name,
        ['link'] = link,
        ['quality'] = quality,
        ['iLevel'] = iLevel,
        ['reqLevel'] = reqLevel,
        ['class'] = class,
        ['subclass'] = subclass,
        ['maxStack'] = maxStack,
        ['equipSlot'] = equipSlot,
        ['texture'] = texture,
        ['vendorPrice'] = vendorPrice,
    }
    
    return ret
end

------------------------------------------------------------------
--  Shields and weapons
local function ShieldIsEquipped ()
    local link = _G.GetInventoryItemLink ('player', INVSLOT_OFFHAND)
    local _,subclass
    
    if link then
        _,_,_,_,_,_,subclass =  _G.GetItemInfo(link)
    end
     
    return (link~=nil  and  subclass=='Shields')
end

local function VerifyShieldEquipped ()
    if ShieldIsEquipped() then
        return true, ''
    else
        return false, 'You should probably use a shield!'
    end
end

local function VerifyShieldNotEquipped ()
    if not ShieldIsEquipped() then
        return true, ''
    else
        return false, 'Are you sure you should be using a shield?'
    end
end


local function VerifyDualWielding ()
    local slots = {INVSLOT_MAINHAND, INVSLOT_OFFHAND}
    local types = {INVTYPE_WEAPON, INVTYPE_2HWEAPON}
    
    for i,slot in pairs(slots) do
        local itemInfo = _G.GetItemInfoBySlot('player', slot)
        if itemInfo~=nil and itemInfo['class']~='Weapon' then
            return false, 'You should probably be dual-wielding!'
        end
    end
    
    return true, ''
end

function Has2HanderEquipped ()
    local link = _G.GetInventoryItemLink ('player', INVSLOT_MAINHAND)
    if not link then return false end
    
    local _,_,_,_,_,_,_,_, equipSlot = _G.GetItemInfo (link)
    return equipSlot=='INVTYPE_2HWEAPON' or equipSlot=='INVTYPE_RANGEDRIGHT' or equipSlot=='INVTYPE_RANGED'
end

------------------------------------------------------------------

local function NoneRequired ()
    return true, ''
end
------------------------------------------------------------------

local function VerifyPetExists ()
    if _G.UnitName('pet')~=nil  or  _G.IsMounted('player')  or  _G.UnitOnTaxi('player')  or  _G.UnitIsDeadOrGhost('player') then
        return true,''
    else
        return false,"Aren't you feeling lonely without a pet?"
    end
end

-----------------------------------------------------------------
------------------------------------------------------------------
-- Class stuff

local function MageVerifyAura ()
    if _G.UnitLevel('player') < 36  or  HasAura ('player', 'Frost Armor') or HasAura ('player', 'Molten Armor') or HasAura ('player', 'Mage Armor') then
        return true, ''
    else
        return false, 'Missing aura: Mage/ Molten/ Frost armor'
    end
end

-----------------------------------------------------------------

local function PriestVerifyAura ()
    if _G.UnitLevel('player') < 10  or  _G.UnitIsDeadOrGhost('player')  or  HasAura ('player', 'Inner Fire') or HasAura ('player', 'Inner Will') then
        return true, ''
    else
        return false, 'Missing aura: Inner Fire/ Inner Will'
    end
end

-----------------------------------------------------------------

local function RogueVerifyAura ()
    local poisons = {'Deadly Poison', 'Wound Poison', 'Crippling Poison', 'Mind-numbing Poison', 'Paralytic Poison', 'Leeching Poison'}
    
    if _G.UnitLevel('player') < 20  or CountAurasFromList('player', poisons)==2 then
        return true,''
    else
        return false,'You should poison up those weapons!'
    end
end

-----------------------------------------------------------------

local function ShamanVerifyAura ()
    if _G.UnitIsDeadOrGhost('player')  or  _G.UnitLevel('player') < 10  or  HasAura ('player', 'Lightning Shield') or HasAura ('player', 'Water Shield') then
        return true, ''
    else
        return false, 'Missing aura: Lightning/ Water Shield'
    end
end

-----------------------------------------------------------------

local function ShamanMaxEnchants ()
    if _G.GetSpecialization('player')==2  and  _G.UnitLevel('player') >= 30 then
        return 2
    elseif _G.UnitLevel('player') >= 10 then
        return 1
    else
        return 0    
    end
end
-----------------------------------------------------------------

local function ShamanCountEnchants ()
    local hasMainHandEnchant, mainHandExpiration, mainHandCharges, hasOffHandEnchant, offHandExpiration, offHandCharges = GetWeaponEnchantInfo()
    return (hasMainHandEnchant or 0) + (hasOffHandEnchant or 0)
end
-----------------------------------------------------------------

local function ShamanVerifyWeaponImbue ()
    if ShamanMaxEnchants() == ShamanCountEnchants() then
        return true,''
    else
        return false,'You should imbue up those weapons!'
    end
end

-----------------------------------------------------------------

local function WarlockVerifyAura ()
    if VerifyPetExists()  or  HasAura ('player', 'Grimoire of Sacrifice') then
        return true, ''
    else
        return false, "Aren't you lonely without a pet?"
    end
end

-----------------------------------------------------------------

local function VerifyDefensiveStance ()
    if _G.GetShapeshiftForm()==2 then
        return true, ''
    else
        return false, 'You may want to switch to defensive stance!'
    end
end


data.verifyAuras = {
    
    ['Death Knight'] = {                                        -- Death Knight
        [1] = BasicVerifyAuraExists ('Blood Presence'),             -- Blood
        [2] = BasicVerifyAuraExists ('Frost Presence'),             -- Frost
        [3] = { BasicVerifyAuraExists ('Unholy Presence'),          -- Unholy
                VerifyPetExists,
        },
    },
    
    ['Druid'] = {                                               -- Druid
        [1] = NoneRequired,                                         -- Balance
        [2] = NoneRequired,                                         -- Feral
        [3] = NoneRequired,                                         -- Guardian
        [4] = NoneRequired,                                         -- Restoration
    },
    
    ['Hunter'] = {                                              -- Hunter
        [1] = { BasicVerifyStance ('any', 'an aspect'),             -- Beast Mastery
                VerifyPetExists,
        },
        [2] = { BasicVerifyStance ('any', 'an aspect'),             -- Marksmanship
                VerifyPetExists,
        },
        [3] = { BasicVerifyStance ('any', 'an aspect'),             -- Survival
                VerifyPetExists,
        },
    },
    
    ['Mage'] = {                                                -- Mage
        [1] = { MageVerifyAura,                                     -- Arcane
        },
        [2] = { MageVerifyAura,                                     -- Fire
        },
        [3] = { MageVerifyAura,                                     -- Frost
                VerifyPetExists,
        },
    },
    
    ['Monk'] = {                                                -- Monk
        [1] = BasicVerifyStance (1, 'Stance of the Sturdy Ox'),     -- Brewmaster
        [2] = NoneRequired,                                         -- Mistweaver
        [3] = NoneRequired,                                         -- Windwalker
    },
    
    ['Paladin'] = {                                             -- Paladin
        [1] = { BasicVerifyStance ('any', 'a seal'),                -- Holy
                VerifyPaladinBuffs,
        },
        [2] = { BasicVerifyAuraExists ('Righteous Fury'),           -- Protection
                BasicVerifyStance ('any', 'a seal'),
                VerifyShieldEquipped,
                VerifyPaladinBuffs,
        },
        [3] = { BasicVerifyStance ('any', 'a seal'),                -- Retribution
                VerifyPaladinBuffs,
        },
    },
    
    ['Priest'] = {                                              -- Priest
        [1] = PriestVerifyAura,                                     -- Discipline
        [2] = PriestVerifyAura,                                     -- Holy
        [3] = PriestVerifyAura,                                     -- Shadow
    },
    
    ['Rogue'] = {                                               -- Rogue
        [1] = { RogueVerifyAura,                                    -- Assassination
                VerifyDualWielding,
        },
        [2] = { RogueVerifyAura,                                    -- Combat
                VerifyDualWielding,
        },
        [3] = { RogueVerifyAura,                                    -- Subtlety
                VerifyDualWielding,
        },
    },
    
    ['Shaman'] = {                                              -- Shaman
        [1] = { ShamanVerifyAura,                                   -- Elemental
                ShamanVerifyWeaponImbue,
        },
        [2] = { ShamanVerifyAura,                                   -- Enhancement
                VerifyDualWielding,
                ShamanVerifyWeaponImbue,
        },
        [3] = { ShamanVerifyAura,                                   -- Restoration
                ShamanVerifyWeaponImbue,
        },
    },
    
    ['Warlock'] = {                                             -- Warlock
        [1] = WarlockVerifyAura,                                    -- Affliction
        [2] = WarlockVerifyAura,                                    -- Demonology
        [3] = WarlockVerifyAura,                                    -- Destruction
    },
    
    ['Warrior'] = {                                             -- Warrior
        [1] = { VerifyShieldNotEquipped,                            -- Arms
        },
        [2] = { VerifyShieldNotEquipped,                            -- Fury
                VerifyDualWielding
        },
        [3] = { BasicVerifyStance (2, 'Defensive Stance'),          -- Protection
                VerifyShieldEquipped,
        },
    },
}


-----------------------------------------------------------------
-----------------------------------------------------------------
-- Raid buffs

data.raidBuffs = {
    ['Stats']           = {'Mark of the Wild', 'Legacy of the Emperor', 'Blessing of Kings', 'Embrace of the Shale Spider'},
    ['Stamina']         = {'Power Word: Fortitude', 'Dark Intent', 'Commanding Shout', 'Qiraji Fortitude'},
    ['Attack Power']    = {'Horn of Winter', 'Trueshot Aura', 'Battle Shout'},
    ['Haste']           = {'Unholy Aura', "Swiftblade's Cunning", 'Unleashed Rage'},
    ['Spell Power']     = {'Arcane Brilliance', 'Dalaran Brilliance', 'Burning Wrath', 'Dark Intent', 'Still Water'},
    ['Spell Haste']     = {'Moonkin Aura', 'Mind Quickening', 'Elemental Oath'},
    ['Critical Strike'] = {'Leader of the Pack', 'Arcane Brilliance', 'Dalaran Brilliance', 'Legacy of the White Tiger'},
    ['Mastery']         = {'Blessing of Might'},
}

data.buffTypesByName = {
    ['Arcane Brilliance'] = {'Spell Power', 'Critical Strike'},
    ['Mark of the Wild'] = {'Stats'},
    ['Dark Intent'] = {'Stamina', 'Spell Power'},
    ['Blessing of Might'] = {'Mastery'},
    ['Blessing of Kings'] = {'Stats'},
    ['Legacy of the Emperor'] = {'Stats'},
    ['Legacy of the White Tiger'] = {'Critical Strike'},
    ['Power Word: Fortitude'] = {'Stamina'},    
}

-----------------------------------------------------------------

local function HasRaidBuff (buffType, who)
    -- parameter is a type of raid buff, e.g. 'Stats'
    for i,v in ipairs(data.raidBuffs[buffType]) do
        if HasAura (who, v) then
            return true
        end
    end
    
    return false
end

-----------------------------------------------------------------

local function VerifyRaidBuffs (name)
    -- parameter is a name of a specific buff, e.g. 'Arcane Brilliance'
    return function ()
        local hasAllBuffs, groupType, who
        local num = _G.GetNumGroupMembers()
        if _G.IsInRaid() then
            groupType = 'raid'
        else
            groupType = 'party'
        end
        for i=1,num do
            who = groupType..i
            if _G.UnitInRange(who) and not _G.UnitIsDeadOrGhost (who) then
                hasAllBuffs = true
                for i,v in ipairs(data.buffTypesByName[name]) do
                    if not HasRaidBuff(v, who) then
                        hasAllBuffs = false
                        break
                    end
                end
                if not hasAllBuffs then
                    return false, 'Someone in your raid needs '..name
                end
            end
        end
        if num<2 then   -- Ungrouped / solo scenario
            if _G.UnitIsDeadOrGhost ('player') then
                return true,''
            end
            
            for i,v in ipairs(data.buffTypesByName[name]) do
                if HasRaidBuff(v, 'player') then
                    return true,''
                end
            end
            
            return false, 'You should probably use '..name
        end
 
        return true,''
    end
end

-----------------------------------------------------------------

local function VerifyMonkBuffs ()
    local ret,msg = VerifyRaidBuffs('Legacy of the Emperor')()
    if not ret then 
        return ret,msg 
    end
    
    if GetSpecialization()==3 then
        return VerifyRaidBuffs('Legacy of the White Tiger')()
    end
end

-----------------------------------------------------------------

local function VerifyPaladinBuffs ()
    -- Damn paladins have to do everything different
    if not (VerifyRaidBuffs('Blessing of Kings')() or VerifyRaidBuffs('Blessing of Might')()) then
        return false, 'You should probably use a Blessing'
    end
    
    return true, ''
end

-----------------------------------------------------------------

data.verifyRaidBuffs = {
    ['Death Knight'] =  NoneRequired, 
    ['Druid'] =         VerifyRaidBuffs ('Mark of the Wild'),
    ['Hunter'] =        NoneRequired,
    ['Mage'] =          VerifyRaidBuffs ('Arcane Brilliance'),
    ['Monk'] =          VerifyMonkBuffs,
    ['Paladin'] =       VerifyPaladinBuffs,
    ['Priest'] =        VerifyRaidBuffs ('Power Word: Fortitude'),
    ['Rogue'] =         NoneRequired,
    ['Shaman'] =        NoneRequired,
    ['Warlock'] =       VerifyRaidBuffs ('Dark Intent'),
    ['Warrior'] =       NoneRequired,
}

-----------------------------------------------------------------

data.slots = {
    [INVSLOT_HEAD]          = 'Head',
    [INVSLOT_NECK]          = 'Neck',
    [INVSLOT_SHOULDER]      = 'Shoulder',
    [INVSLOT_CHEST]         = 'Chest',
    [INVSLOT_WAIST]         = 'Belt',
    [INVSLOT_LEGS]          = 'Legs',
    [INVSLOT_FEET]          = 'Feet',
    [INVSLOT_WRIST]         = 'Wrist',
    [INVSLOT_HAND]          = 'Hands',
    [INVSLOT_FINGER1]       = 'Ring 1',
    [INVSLOT_FINGER2]       = 'Ring 2',
    [INVSLOT_TRINKET1]      = 'Trinket 1',
    [INVSLOT_TRINKET2]      = 'Trinket 2',
    [INVSLOT_BACK]          = 'Cloak',
    [INVSLOT_MAINHAND]      = 'Main hand',
    [INVSLOT_OFFHAND]       = 'Off hand'
}

data.slots_Enchantable = {
    [INVSLOT_SHOULDER]      = true,
    [INVSLOT_CHEST]         = true,
    [INVSLOT_LEGS]          = true,
    [INVSLOT_FEET]          = true,
    [INVSLOT_WRIST]         = true,
    [INVSLOT_HAND]          = true,
    [INVSLOT_BACK]          = true,
    [INVSLOT_MAINHAND]      = true
}

-----------------------------------------------------------------

data.professionIds = {
    Blacksmithing = 164,
    Leatherworking = 165,
    Alchemy = 171,
    Herbalism = 182,
    Mining = 186,
    Tailoring = 197,
    Engineering = 202,
    Enchanting = 333,
    Skinning = 393,
    Jewelcrafting = 755,
    Inscription = 773,
}

-----------------------------------------------------------------

data.flasks = {
    'Flask of the Warm Sun',
    'Flask of Spring Blossoms',
    'Flask of Falling Leaves',
    'Flask of the Earth',
    'Flask of Winter\'s Bite',
}

-----------------------------------------------------------------

data.difficulties = {
    [1] = 'LFR',
    [2] = 'Flex',
    [3] = 'Normal',
    [4] = 'Heroic',
}

-----------------------------------------------------------------

data.difficultyFromID = {
    [3] = 3,
    [4] = 3,
    [5] = 4,
    [6] = 4,
    [7] = 1,
    [14] = 2,
}