local ADDON, data = ...

local SkinName = 'Shaman'

------------------------------------------------------------------

local function CreateLight (name, parent, texture)
    local f = CreateFrame ("Frame", name, parent)
    f:SetBackdrop ({bgFile = "Interface\\Addons\\"..ADDON.."\\gfx\\"..texture})
    
    f:SetScript("OnEnter", function(self, motion, ...)
        GameTooltip:SetOwner (self, "ANCHOR_TOP")
        self:GenerateTooltip ()
        GameTooltip:Show ()
    end)
    f:SetScript("OnLeave", function(self, motion, ...)
        GameTooltip:Hide ()
    end)
    
    function f:Light ()
        self:SetAlpha (1)
        self.isOn = true
    end
    function f:Dark ()
        self:SetAlpha (0)
        self.isOn = false
    end
    f:Dark()
    
    return f
end

------------------------------------------------------------------

local function BuildGui (x,y)
    -- Main frame
    do  
        local f = CreateFrame ("Frame", 'frmSanityCheck_Parent', UIParent)
        f:SetSize(130,120)
        f:SetPoint ("CENTER", UIParent, "BOTTOMLEFT", x or 100, y or 100)
        f:SetBackdrop ({bgFile = "Interface\\Addons\\"..ADDON.."\\gfx\\shamanbg"})
        
        -- Since this one is the main frame, we need the whole movability thing
        f:SetMovable (true)
        f:RegisterForDrag ("LeftButton")
        f:SetUserPlaced (true)
        --f:SetClampedToScreen (true)
        f:EnableMouse (true)
        f:SetScript("OnMouseDown", function(self, button)
            if button=='LeftButton' then
                self:StartMoving ()
                GameTooltip:Hide ()
            elseif button=='RightButton' then
                
            end
        end)
        f:SetScript("OnMouseUp", function(self, button)
            self:StopMovingOrSizing ()
        end)

        frmSanityCheck_Parent = f
    end
    
    -- Primary warning light
    do
        local f = CreateLight ('frmSanityCheck_Light1', frmSanityCheck_Parent, 'shaman1')
        f:SetSize (17.5,17.5)
        f:SetPoint ("TOP", frmSanityCheck_Parent, "TOP", -1, -8.5)
        
        function f:GenerateTooltip ()
            if self.isOn then
                GameTooltip:AddDoubleLine ('SanityCheck', '', 1.0, 1.0, 1.0, 1.0, 1.0, 0.0)
                
                local txt = frmSanityCheck.GetTooltipText_Light1 ()
                for k,v in pairs(txt) do
                    GameTooltip:AddLine (v, 1.0, 0.5, 0.5)
                end
            else
                GameTooltip:AddLine ('SanityCheck', 1.0, 1.0, 1.0)
                GameTooltip:AddLine ('Your gear and buffs appear to be fine!', 1.0, 0.5, 0.5)
            end
        end
        
        frmSanityCheck.frmLight1 = f
        frmSanityCheck_Light1 = f
    end
    
    -- Secondary warning light
    do
        local f = CreateLight ('frmSanityCheck_Light2', frmSanityCheck_Parent, 'shaman2')
        f:SetSize (18,18)
        f:SetPoint ("TOP", frmSanityCheck_Parent, "TOP", -0.5, -31.5)
        
        function f:GenerateTooltip ()
            if self.isOn then
                GameTooltip:AddDoubleLine ('SanityCheck', 'Right-click to generate shopping list', 1.0, 1.0, 1.0, 1.0, 1.0, 0.0)
                
                local txt = frmSanityCheck.GetTooltipText_Light2 ()
                for k,v in pairs(txt) do
                    GameTooltip:AddLine (v, 1.0, 0.5, 0.5)
                end
            else
                GameTooltip:AddLine ('SanityCheck', 1.0, 1.0, 1.0)
                GameTooltip:AddLine ('Your gear and buffs appear to be fine!', 1.0, 0.5, 0.5)
            end
        end
        
        f:SetScript("OnMouseDown", function(self, button)
            if button=='RightButton' then
                frmShoppingList:Generate()
            end
        end)
       
        frmSanityCheck.frmLight2 = f
        frmSanityCheck_Light2 = f
    end

    -- Tertiary warning light
    do
        local f = CreateLight ('frmSanityCheck_Light3', frmSanityCheck_Parent, 'shaman3')
        f:SetSize (17,17)
        f:SetPoint ("TOP", frmSanityCheck_Parent, "TOP", -13, -44.5)
        
        function f:GenerateTooltip ()
            if self.isOn then
                GameTooltip:AddDoubleLine ('SanityCheck', 'Even More Warnings', 1.0, 1.0, 1.0, 1.0, 1.0, 0.0)
                
                local txt = frmSanityCheck.GetTooltipText_Light3 ()
                for k,v in pairs(txt) do
                    GameTooltip:AddLine (v, 1.0, 0.5, 0.5)
                end
            else
                GameTooltip:AddLine ('SanityCheck', 1.0, 1.0, 1.0)
                GameTooltip:AddLine ('Nothing to see here, move along now!', 1.0, 0.5, 0.5)
            end
        end
        
        frmSanityCheck.frmLight3 = f
        frmSanityCheck_Light3 = f
    end

    -- 4th warning light
    do
        local f = CreateLight ('frmSanityCheck_Light4', frmSanityCheck_Parent, 'shaman4')
        f:SetSize (17,17)
        f:SetPoint ("TOP", frmSanityCheck_Parent, "TOP", 14.5, -44.5)
        
        function f:GenerateTooltip ()
            if self.isOn then
                GameTooltip:AddDoubleLine ('SanityCheck', 'Consumables', 1.0, 1.0, 1.0, 1.0, 1.0, 0.0)
            
                local txt = frmSanityCheck.GetTooltipText_Light4 ()
                for k,v in pairs(txt) do
                    GameTooltip:AddLine (v, 1.0, 0.5, 0.5)
                end
            else
                GameTooltip:AddDoubleLine ('SanityCheck', 'Missing consumables', 1.0, 1.0, 1.0, 1.0, 1.0, 0.0)
                GameTooltip:AddLine ('Looks like you\'ve got everything you need!', 1.0, 0.5, 0.5)
            end
        end
        
        frmSanityCheck.frmLight4 = f
        frmSanityCheck_Light4 = f
    end
end

data.skins = data.skins or {}
data.skins[SkinName] = {
    ['build'] = BuildGui
}
