local ADDON, data = ...

local SkinName = 'Classic'

------------------------------------------------------------------

local function CreateLightFrame (name, parent)
    local f = CreateFrame ("Frame", name, parent)
    f:SetBackdrop ({
        bgFile = "Interface\\Addons\\SanityCheck\\red.tga",  
        edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
        edgeSize = 8,
    })

    f.lbl = f:CreateFontString(nil, "BACKGROUND", "GameFontNormal")
    f.lbl:SetPoint ("CENTER", f, "CENTER")
    f.lbl:SetSize (100,30)
    f.lbl:SetTextColor (1.0,1.0,1.0)
    f.lbl:SetJustifyH ("CENTER")
    
    f:SetScript("OnEnter", function(self, motion, ...)
        GameTooltip:SetOwner (self, "ANCHOR_TOP")
        self:GenerateTooltip ()
        GameTooltip:Show ()
    end)
    f:SetScript("OnLeave", function(self, motion, ...)
        GameTooltip:Hide ()
    end)

    return f
end

------------------------------------------------------------------

local function BuildGui (x,y)
    -- Primary warning light
    do
        local f = CreateLightFrame ('frmSanityCheck_Light1', UIParent)
        f:SetPoint ("CENTER", UIParent, "BOTTOMLEFT", x or 100, y or 100)
        f:SetSize (100,40)
        
        f.elapsed = 0
        f.itBlinker = iter_cycle ({1.0, 0.0, 0.0, 0.9}, {0.3, 0.0, 0.0, 0.65} )
        f.blinkInterval = 0.55
        f.blink = true
        function f:Light ()
            if not self.isOn then
                self.lbl:SetText ("OMG N00b!")
                if self.isOn==false then
                    self.blink = true
                end
                self.isOn = true
                self:SetScript ("OnUpdate", self.OnUpdate)  
            end
        end
        function f:Dark ()
            self:SetBackdropColor (0.0, 0.0, 0.0, 0.5)
            self.lbl:SetText ("You're awesome.")
            self.isOn = false
            self:SetScript ("OnUpdate", nil)
        end
        f:Dark ()
        
        function f:GenerateTooltip ()
            if self.isOn then
                GameTooltip:AddDoubleLine ('SanityCheck', 'Right-click to stop blinking', 1.0, 1.0, 1.0, 1.0, 1.0, 0.0)
                
                local txt = frmSanityCheck.GetTooltipText_Light1 ()
                for k,v in pairs(txt) do
                    GameTooltip:AddLine (v, 1.0, 0.5, 0.5)
                end
            else
                GameTooltip:AddLine ('SanityCheck', 1.0, 1.0, 1.0)
                GameTooltip:AddLine ('Your gear and buffs appear to be fine!', 1.0, 0.5, 0.5)
            end
        end
        
        -- Since this one is the main frame, we need the whole movability thing
        f:SetMovable (true)
        f:RegisterForDrag ("LeftButton")
        f:SetUserPlaced (true)
        f:SetClampedToScreen (true)
        f:EnableMouse (true)
        f:SetScript("OnMouseDown", function(self, button)
            if button=='LeftButton' then
                self:StartMoving ()
                GameTooltip:Hide ()
            elseif button=='RightButton' then
                self.blink = false
            end
        end)
        f:SetScript("OnMouseUp", function(self, button)
            self:StopMovingOrSizing ()
        end)

        -- It needs to blink...
        function f:OnUpdate (elapsed, ...)
            self.elapsed = self.elapsed + elapsed
            
            if self.elapsed > self.blinkInterval then
                self.elapsed = 0
                if self.blink then
                    self:SetBackdropColor (_G.unpack(self.itBlinker:next()))
                else
                    self:SetBackdropColor (_G.unpack(self.itBlinker.values[1]))
                end
            end
        end
        
        frmSanityCheck.frmLight1 = f
        frmSanityCheck_Light1 = f
    end
    
    -- Secondary warning light
    do
        local f = CreateLightFrame ('frmSanityCheck_Light2', frmSanityCheck_Light1)
        f:SetPoint ("TOPLEFT", frmSanityCheck_Light1, "TOPRIGHT")
        f:SetSize (20,20)
        
        function f:Light ()
            self:SetBackdropColor (0.9, 0.5, 0.0, 0.85)
            self.lbl:SetText ('!')
            self.isOn = true
        end
        function f:Dark ()
            self:SetBackdropColor (0.0, 0.0, 0.0, 0.5)
            self.lbl:SetText ('')
            self.isOn = false
        end
        f:Dark()
        
        function f:GenerateTooltip ()
            if self.isOn then
                GameTooltip:AddDoubleLine ('SanityCheck', 'Right-click to generate shopping list', 1.0, 1.0, 1.0, 1.0, 1.0, 0.0)
                
                local txt = frmSanityCheck.GetTooltipText_Light2 ()
                for k,v in pairs(txt) do
                    GameTooltip:AddLine (v, 1.0, 0.5, 0.5)
                end
            else
                GameTooltip:AddLine ('SanityCheck', 1.0, 1.0, 1.0)
                GameTooltip:AddLine ('You seem to have all your gems and enchants!', 1.0, 0.5, 0.5)
            end
        end
        
        
        f:SetScript("OnMouseDown", function(self, button)
            if button=='RightButton' then
                frmShoppingList:Generate()
            end
        end)
       
        frmSanityCheck.frmLight2 = f
        frmSanityCheck_Light2 = f
    end

    -- Tertiary warning light
    do
        local f = CreateLightFrame ('frmSanityCheck_Light3', frmSanityCheck_Light1)
        f:SetPoint ("BOTTOMRIGHT", frmSanityCheck_Light1, "BOTTOMLEFT")
        f:SetSize (20,20)
        
        function f:Light ()
            self:SetBackdropColor (0.6, 0.75, 1.0, 0.85)
            self.lbl:SetText ('!')
            self.isOn = true
        end
        function f:Dark ()
            self:SetBackdropColor (0.0, 0.0, 0.0, 0.5)
            self.lbl:SetText ('')
            self.isOn = false
        end
        f:Dark()
        
        function f:GenerateTooltip ()
            if self.isOn then
                GameTooltip:AddDoubleLine ('SanityCheck', 'Even More Warnings', 1.0, 1.0, 1.0, 1.0, 1.0, 0.0)
                
                local txt = frmSanityCheck.GetTooltipText_Light3 ()
                for k,v in pairs(txt) do
                    GameTooltip:AddLine (v, 1.0, 0.5, 0.5)
                end
            else
                GameTooltip:AddLine ('SanityCheck', 1.0, 1.0, 1.0)
                GameTooltip:AddLine ('Nothing to see here, move along now!', 1.0, 0.5, 0.5)
            end
        end

        
        frmSanityCheck.frmLight3 = f
        frmSanityCheck_Light3 = f
    end

    -- 4th warning light
    do
        local f = CreateLightFrame ('frmSanityCheck_Light4', frmSanityCheck_Light1)
        f:SetPoint ("BOTTOMLEFT", frmSanityCheck_Light1, "BOTTOMRIGHT")
        f:SetSize (20,20)
        
        function f:Light ()
            self:SetBackdropColor (1.0, 0.9, 0.0, 0.85)
            self.lbl:SetText ('!')
            self.isOn = true
        end
        function f:Dark ()
            self:SetBackdropColor (0.0, 0.0, 0.0, 0.5)
            self.lbl:SetText ('')
            self.isOn = false
        end
        f:Dark()
        
        function f:GenerateTooltip ()
            if self.isOn then
                GameTooltip:AddDoubleLine ('SanityCheck', 'Consumables', 1.0, 1.0, 1.0, 1.0, 1.0, 0.0)
            
                local txt = frmSanityCheck.GetTooltipText_Light4 ()
                for k,v in pairs(txt) do
                    GameTooltip:AddLine (v, 1.0, 0.5, 0.5)
                end
            else
                GameTooltip:AddDoubleLine ('SanityCheck', 'Consumables', 1.0, 1.0, 1.0, 1.0, 1.0, 0.0)
                GameTooltip:AddLine ('Looks like you\'ve got everything you need!', 1.0, 0.5, 0.5)
            end
        end
        
        frmSanityCheck.frmLight4 = f
        frmSanityCheck_Light4 = f
    end

    --  Configure button
    do
        local f = CreateFrame ("Frame", nil, frmSanityCheck_Light1)
        f:SetPoint ("TOPRIGHT", frmSanityCheck_Light1, "TOPLEFT")
        f:SetSize (20,20)
        f:SetBackdrop ({
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
            edgeSize = 10,
        })
        
        local btn = CreateFrame ("Button", nil, f, "UIPanelButtonTemplate")
        btn:SetAllPoints (f)
        btn:SetFrameStrata("LOW")
        
        btn:SetScript("OnEnter", function(self, motion, ...)
            GameTooltip:SetOwner (self, "ANCHOR_TOP")
            GameTooltip:AddLine ('Configure', 1.0, 1.0, 1.0)
            GameTooltip:Show ()
        end)
        btn:SetScript("OnLeave", function(self, motion, ...)
            GameTooltip:Hide ()
        end)
        btn:SetScript("OnClick", function (self,...)
            --frmSanityCheckConfig:Show()
            InterfaceOptionsFrame_OpenToCategory (SanityCheckOptions)
            InterfaceOptionsFrame_OpenToCategory (SanityCheckOptions)   -- Calling twice to circumvent a silly Blizz bug
        end)

        frmSanityCheck.btnConfig = btn
    end
    
    frmSanityCheck_Parent = frmSanityCheck_Light1
end

data.skins = data.skins or {}
data.skins[SkinName] = {
    ['build'] = BuildGui
}
