local RogueDefib_FrameMain;

local RogueDefib_Button1 = "BUTTON1";
local RogueDefib_Button2 = "BUTTON2";
local RogueDefib_Button3 = "BUTTON3";
local RogueDefib_Button4 = "BUTTON4";
local RogueDefib_Button5 = "BUTTON5";
local RogueDefib_Button6 = "BUTTON6";
local RogueDefib_Button7 = "BUTTON7";
local RogueDefib_Button8 = "BUTTON8";

local RogueDefib_DeadlyPoisonButton = "BUTTON1";
local RogueDefib_EnvenomButton = "BUTTON2";
local RogueDefib_EviscerateButton = "BUTTON2";
local RogueDefib_GarroteButton = "BUTTON3";
local RogueDefib_HemorragheButton = "BUTTON3";
local RogueDefib_RuptureButton = "BUTTON4";
local RogueDefib_SliceAndDiceButton = "BUTTON5";

local TEXTURE_DEADLYPOISON = "Interface\\AddOns\\RogueDefibrillator\\DeadlyPoison.tga";
local TEXTURE_SLICEANDDICE = "Interface\\AddOns\\RogueDefibrillator\\SliceAndDice.tga";
local TEXTURE_GARROTE = "Interface\\AddOns\\RogueDefibrillator\\Garrote.tga";
local TEXTURE_HEMORRAGHE = "Interface\\AddOns\\RogueDefibrillator\\Hemorraghe.tga";
local TEXTURE_RUPTURE = "Interface\\AddOns\\RogueDefibrillator\\Rupture.tga";
local TEXTURE_ENVENOM = "Interface\\AddOns\\RogueDefibrillator\\Envenom.tga";
local TEXTURE_EVISCERATE = "Interface\\AddOns\\RogueDefibrillator\\Eviscerate.tga";
local TEXTURE_COMBO_POINT = "Interface\\AddOns\\RogueDefibrillator\\ComboPoint.tga";
local TEXTURE_USE = "Interface\\AddOns\\RogueDefibrillator\\Use.tga";

local RogueDefib_FrameMainButtons = {};
local RogueDefib_FrameMainButtonsOrder_Assissination = {RogueDefib_DeadlyPoisonButton, RogueDefib_EnvenomButton, RogueDefib_GarroteButton, RogueDefib_RuptureButton, RogueDefib_SliceAndDiceButton};
local RogueDefib_FrameMainButtonsTextureOrder_Assissination = {TEXTURE_DEADLYPOISON, TEXTURE_ENVENOM, TEXTURE_GARROTE, TEXTURE_RUPTURE, TEXTURE_SLICEANDDICE};
local RogueDefib_FrameMainButtonsOrder_Subtlety = {RogueDefib_DeadlyPoisonButton, RogueDefib_EviscerateButton, RogueDefib_HemorragheButton, RogueDefib_RuptureButton, RogueDefib_SliceAndDiceButton};
local RogueDefib_FrameMainButtonsTextureOrder_Subtlety = {TEXTURE_DEADLYPOISON, TEXTURE_EVISCERATE, TEXTURE_HEMORRAGHE, TEXTURE_RUPTURE, TEXTURE_SLICEANDDICE};
local RogueDefib_FrameMainButtonsFontSizes = {18,18,18,18,18,24,14,14};

local RogueDefib_OnDragStart = function(self) self:StartMoving() end;
local RogueDefib_OnDragStop = function(self) self:StopMovingOrSizing() end;

local spellDeadlyPoison = 2818;
local spellSliceAndDice = 5171;
local spellHemorrhage = 16511;
local spellRupture = 1943;
local spellEnvenom = 32645;
local spellGarrote = 703;
local spellEviscerate = 2098;

local SET_EXP_TIME = "expTime";
local SET_COUNT = "count";

local inCombat = false;
local enemyTarget = false;
local showMainFrame = false;

local slicendice_left = 0;

local comboPoints;

local _time = GetTime();
local alternateTimer = 0.3;
local alternateLeft = _time + alternateTimer;
local alternate = false;

local spec = nil;
local ASSASSINATION = 259;
local SUBTLETY = 261;

local buttonSize = 40;

function RogueDefib_SetBackdrop(frame)
	local backdrop;
	
	if (frame:IsMouseEnabled()) then
		backdrop = {
			bgFile = "Interface\\DialogFrame\\UI-DialogBox-Gold-Background",  
			edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Gold-Border",
			tile = true,
			tileSize = 32,
			edgeSize = 32,
			insets = {left = 11,right = 12,top = 12,bottom = 11}
		}
		frame:SetBackdrop(backdrop);
	else
		backdrop = {
			bgFile = nil,  
			edgeFile = nil,
			tile = true,
			tileSize = 32,
			edgeSize = 32,
			insets = {left = 11,right = 12,top = 12,bottom = 11}
		}
		frame:SetBackdrop(backdrop);
	end
end

function RogueDefib_CommandHandler(msg)
	if (msg == "unlock") then
		RogueDefib_FrameMain:EnableMouse(true);
		RogueDefib_SetBackdrop(RogueDefib_FrameMain);
	end
	if (msg == "lock") then
		RogueDefib_FrameMain:EnableMouse(false);
		RogueDefib_SetBackdrop(RogueDefib_FrameMain);
	end
end

function RogueDefib_OnClick()
end

function RogueDefib_OnUpdate(self)
	RogueDefib_UpdateAlternate();
	
	if (spec == nil) then
		RogueDefib_SetSpec();
		return;
	end
	
	if (showMainFrame) then
		RogueDefib_UpdateEnergy();
		RogueDefib_UpdateHaste();
		RogueDefib_UpdateRegen();
		
		if (spec == ASSASSINATION) then
			RogueDefib_UpdateEnvenom();
		end
		
		RogueDefib_UpdateSliceAndDice();
		
		RogueDefib_UpdateBuffs();
		RogueDefib_UpdateDebuffs();
	end
end

function RogueDefib_FormatTime(time)
	if (time >= 60) then
		return ceil(time / 60).."m";
	elseif(time >= 1) then
		return floor(time);
	else
		return "."..floor(time*10);
	end
end

function RogueDefib_UpdateAlternate()
	_time = GetTime();
	if (alternateLeft < _time) then
		alternateLeft = _time + alternateTimer;
		alternate = not alternate;
	end
end

function RogueDefib_UpdateComboPoints()
	comboPoints = GetComboPoints("player", "target");
	
	for i = 1,5 do
		RogueDefib_FrameMainButtons[RogueDefib_FrameMainButtonsOrder_Assissination[i]].cpframe:Hide();
	end
	if (comboPoints > 0) then
		for i = 1,comboPoints do
			RogueDefib_FrameMainButtons[RogueDefib_FrameMainButtonsOrder_Assissination[i]].cpframe:Show();
		end
	end
end

function RogueDefib_UpdateHaste()
	local button = RogueDefib_FrameMainButtons[RogueDefib_Button7];
	button.text:SetText(string.format("%3.0f", GetMeleeHaste()));
end

function RogueDefib_UpdateRegen()
	local button = RogueDefib_FrameMainButtons[RogueDefib_Button8];
	button.text:SetText(string.format("%3.1f", GetPowerRegen()));
end

function RogueDefib_UpdateEnvenom()
	local use = false;
	
	if (slicendice_left == nil) then
		use = false;
	else
		if (slicendice_left - _time <= 5) then
			if (comboPoints == nil) then
				use = false;
			else
				if (comboPoints > 0) then
					use = true;
				else
					use = false;
				end
			end
		else
			use = false;
		end
	end
	
	use = use and alternate and inCombat;
	if (use) then
		RogueDefib_FrameMainButtons[RogueDefib_EnvenomButton].useframe:Show();
	else
		RogueDefib_FrameMainButtons[RogueDefib_EnvenomButton].useframe:Hide();
	end
end

function RogueDefib_UpdateSliceAndDice()
	local use = false;

	if (slicendice_left == nil) then
		use = true;
	else
		use = false;
	end

	use = use and alternate and inCombat;
	if (use) then
		RogueDefib_FrameMainButtons[RogueDefib_SliceAndDiceButton].useframe:Show();
	else
		RogueDefib_FrameMainButtons[RogueDefib_SliceAndDiceButton].useframe:Hide();
	end
end

function RogueDefib_UpdateEnergy()
	local power, powerMax, green;
	local threshold = 0.68;
	local button = RogueDefib_FrameMainButtons[RogueDefib_Button6];
	
	power = UnitPower("player", 3);
	powerMax = UnitPowerMax("player", 3);
	
	if (inCombat) then
		if (power/powerMax > threshold) then
			green = 1 - ((power-(powerMax*threshold)) / (powerMax-(powerMax*threshold)));
			button.text:SetTextColor(1,green,0,1);
		else
			button.text:SetTextColor(1,1,0,1);
		end
	else
		button.text:SetTextColor(1,1,0,1);
	end

	button.text:SetText(power);
end

function RogueDefib_SetSpec()
	local specialization = GetSpecialization();
	if (specialization == nil) then
	else
		local id,_,_,_,_,_ = GetSpecializationInfo(specialization);
		spec = id;
		RogueDefib_SetButtons(spec);
	end
end

function RogueDefib_CheckDebuff(spell,setValue,emptyValue)
	local name, expTime, count, result;
	
	name,_,_,count,_,_,expTime = UnitDebuff("target", GetSpellInfo(spell));
	if(name) then
		if (setValue == SET_EXP_TIME) then result = expTime end
		if (setValue == SET_COUNT) then result = count end
	else
		result = emptyValue;
	end
	
	return result;
end

function RogueDefib_CheckDebuffs()
	local name, expTime, count;

	RogueDefib_FrameMainButtons[RogueDefib_DeadlyPoisonButton].text.expTime = RogueDefib_CheckDebuff(spellDeadlyPoison,SET_EXP_TIME,nil);
	
	if (spec == ASSASSINATION) then
	end
	if (spec == SUBTLETY) then
		RogueDefib_FrameMainButtons[RogueDefib_HemorragheButton].text.expTime = RogueDefib_CheckDebuff(spellHemorrhage,SET_EXP_TIME,nil);
	end
	
	RogueDefib_FrameMainButtons[RogueDefib_RuptureButton].text.expTime = RogueDefib_CheckDebuff(spellRupture,SET_EXP_TIME,nil);
end

function RogueDefib_UpdateDebuffs()
	if(RogueDefib_FrameMainButtons[RogueDefib_DeadlyPoisonButton].text.expTime) then
		RogueDefib_FrameMainButtons[RogueDefib_DeadlyPoisonButton].text:SetText(RogueDefib_FormatTime(RogueDefib_FrameMainButtons[RogueDefib_DeadlyPoisonButton].text.expTime-_time));
	else
		RogueDefib_FrameMainButtons[RogueDefib_DeadlyPoisonButton].text:SetText("");
	end

	if (spec == ASSASSINATION) then
		if(RogueDefib_FrameMainButtons[RogueDefib_GarroteButton].text.expTime) then
			RogueDefib_FrameMainButtons[RogueDefib_GarroteButton].text:SetText(RogueDefib_FormatTime(RogueDefib_FrameMainButtons[RogueDefib_GarroteButton].text.expTime-_time));
		else
			RogueDefib_FrameMainButtons[RogueDefib_GarroteButton].text:SetText("");
		end
	end
	if (spec == SUBTLETY) then
		if(RogueDefib_FrameMainButtons[RogueDefib_HemorragheButton].text.expTime) then
			RogueDefib_FrameMainButtons[RogueDefib_HemorragheButton].text:SetText(RogueDefib_FormatTime(RogueDefib_FrameMainButtons[RogueDefib_HemorragheButton].text.expTime-_time));
		else
			RogueDefib_FrameMainButtons[RogueDefib_HemorragheButton].text:SetText("");
		end
	end

	if(RogueDefib_FrameMainButtons[RogueDefib_RuptureButton].text.expTime) then
		RogueDefib_FrameMainButtons[RogueDefib_RuptureButton].text:SetText(RogueDefib_FormatTime(RogueDefib_FrameMainButtons[RogueDefib_RuptureButton].text.expTime-_time));
	else
		RogueDefib_FrameMainButtons[RogueDefib_RuptureButton].text:SetText("");
	end
end

function RogueDefib_CheckBuff(spell,setValue,emptyValue)
	local name, expTime, count, result;
	
	name,_,_,count,_,_,expTime = UnitBuff("player", GetSpellInfo(spell));
	if(name) then
		if (setValue == SET_EXP_TIME) then result = expTime end
		if (setValue == SET_COUNT) then result = count end
	else
		result = emptyValue;
	end
	
	return result;
end

function RogueDefib_CheckBuffs()
	slicendice_left = RogueDefib_CheckBuff(spellSliceAndDice,SET_EXP_TIME,nil);

	RogueDefib_FrameMainButtons[RogueDefib_SliceAndDiceButton].text.expTime = slicendice_left;
	
	if (spec == ASSASSINATION) then
		RogueDefib_FrameMainButtons[RogueDefib_EnvenomButton].text.expTime = RogueDefib_CheckBuff(spellEnvenom,SET_EXP_TIME,nil);
	end
end

function RogueDefib_UpdateBuffs()
	if(RogueDefib_FrameMainButtons[RogueDefib_SliceAndDiceButton].text.expTime) then
		RogueDefib_FrameMainButtons[RogueDefib_SliceAndDiceButton].text:SetText(RogueDefib_FormatTime(RogueDefib_FrameMainButtons[RogueDefib_SliceAndDiceButton].text.expTime-_time));
	else
		RogueDefib_FrameMainButtons[RogueDefib_SliceAndDiceButton].text:SetText("");
	end

	if (spec == ASSASSINATION) then
		if(RogueDefib_FrameMainButtons[RogueDefib_EnvenomButton].text.expTime) then
			RogueDefib_FrameMainButtons[RogueDefib_EnvenomButton].text:SetText(RogueDefib_FormatTime(RogueDefib_FrameMainButtons[RogueDefib_EnvenomButton].text.expTime-_time));
		else
			RogueDefib_FrameMainButtons[RogueDefib_EnvenomButton].text:SetText("");
		end
	end
	if (spec == SUBTLETY) then
	end
end

function RogueDefib_OnLoad(self)
	local _,class = UnitClass("player");

	if(class == "ROGUE") then
		self:SetScript("OnEvent", RogueDefib_OnEvent);
	else
		return;
	end
		
	SLASH_RDEF1 = "/rdef";
	SlashCmdList["RDEF"] = RogueDefib_CommandHandler;

	self:RegisterEvent("UNIT_AURA");
	self:RegisterEvent("PLAYER_TARGET_CHANGED");
	self:RegisterEvent("UPDATE_SHAPESHIFT_FORM");
	self:RegisterEvent("ADDON_LOADED");
	self:RegisterEvent("UNIT_FACTION");
	self:RegisterEvent("SPELL_UPDATE_COOLDOWN");
	self:RegisterEvent("PLAYER_REGEN_DISABLED");
	self:RegisterEvent("PLAYER_REGEN_ENABLED");
	self:RegisterEvent("UNIT_COMBO_POINTS");
	self:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED");
		
	RogueDefib_CreateFrame();
end

function RogueDefib_CreateFrame()
	RogueDefib_FrameMain = CreateFrame("Frame", "FrameMain", UIParent);
	RogueDefib_FrameMain:Hide();
	RogueDefib_FrameMain:EnableMouse(false);
	RogueDefib_FrameMain:SetMovable(true);
	RogueDefib_FrameMain:SetBackdrop(backdrop);
	RogueDefib_FrameMain:SetPoint("TOP",UIParent,"CENTER",0,0);
	RogueDefib_FrameMain:SetHeight(60);
	RogueDefib_FrameMain:SetWidth(20+(8*buttonSize)+20);
	RogueDefib_FrameMain:RegisterForDrag("LeftButton");
	RogueDefib_FrameMain:SetScript("OnDragStart", RogueDefib_OnDragStart);
	RogueDefib_FrameMain:SetScript("OnDragStop", RogueDefib_OnDragStop);
	RogueDefib_FrameMain:SetScript("OnUpdate", RogueDefib_OnUpdate);

	RogueDefib_SetBackdrop(RogueDefib_FrameMain);

	for i = 1,8 do
		RogueDefib_FrameMainButtons["BUTTON" .. i] = RogueDefib_CreateIconButton(RogueDefib_FrameMain,"BUTTON" .. i,i-1,40,40,RogueDefib_FrameMainButtonsFontSizes[i],nil);
	end
	
	RogueDefib_FrameMainButtons[RogueDefib_Button7].text:SetTextColor(0,1,0,1);
	RogueDefib_FrameMainButtons[RogueDefib_Button8].text:SetTextColor(0,1,0,1);
end

function RogueDefib_OnEvent(self, event, ...)
	arg1 = ...;

	if(UnitAffectingCombat("player")) then
		inCombat = true;
	else
		inCombat = false;
	end
	if(UnitExists("target") and UnitCanAttack("player", "target") and not UnitIsDead("target")) then
		enemyTarget = true
	else
		enemyTarget = false
	end
	if(enemyTarget) then
		showMainFrame = true;
	else
		showMainFrame = false;
	end

	--showMainFrame = true;
	
	if(event == "UNIT_AURA") then
		if(showMainFrame) then
			RogueDefib_CheckBuffs();
			RogueDefib_CheckDebuffs();
		end
	end 
	
	if(event == "UNIT_COMBO_POINTS") then
		RogueDefib_UpdateComboPoints();
	end
	
	if(event == "SPELL_UPDATE_COOLDOWN") then
	end

	if(event == "PLAYER_TARGET_CHANGED") then
		if(showMainFrame) then
			RogueDefib_CheckBuffs();
			RogueDefib_CheckDebuffs();
			RogueDefib_UpdateComboPoints();
		end
	end

	if (event == "ACTIVE_TALENT_GROUP_CHANGED") then
		local id,_,_,_,_,_ = GetSpecializationInfo(GetSpecialization());
		spec = id;
		RogueDefib_SetButtons();
	end
	
	if(event == "ADDON_LOADED" and arg1 == "RogueDefibrillator") then
		print("Rogue Defibrillator Loaded! SlashCmdList '/rdef' Options 'lock' and 'unlock'");
	end
	
	if (showMainFrame) then
		RogueDefib_FrameMain:Show();
	else
		RogueDefib_FrameMain:Hide();
	end
end

function RogueDefib_SetButtons()
	if (spec == 259) then
		for i, f in pairs(RogueDefib_FrameMainButtonsOrder_Assissination) do 
			RogueDefib_SetIconButton(RogueDefib_FrameMain,f,RogueDefib_FrameMainButtonsTextureOrder_Assissination[i]);
		end
		
		showMainFrame = true;
		return;
	end
	if (spec == 261) then
		for i, f in pairs(RogueDefib_FrameMainButtonsOrder_Assissination) do 
			RogueDefib_SetIconButton(RogueDefib_FrameMain,f,RogueDefib_FrameMainButtonsTextureOrder_Subtlety[i]);
		end

		showMainFrame = true;
		return;
	end
	
	showMainFrame = false;
end

function RogueDefib_SetIconButton(parent,name,iconTexture)
	local button = RogueDefib_FrameMainButtons[name];

	if (iconTexture) then
		button.icon:SetTexture(iconTexture)	
	end
end

function RogueDefib_CreateIconButton(parent,name,positionInFrame,height,width,fontSize,iconTexture)
	local button;
	
	button = CreateFrame("Button", name, parent);
	button:ClearAllPoints();
	button:SetHeight(height);
	button:SetWidth(width);
	button:SetPoint("TOPLEFT",(positionInFrame*width)+10,-10);
	button:EnableMouse(false);
	button:Show();

	button.text = button:CreateFontString(nil,"OVERLAY","GameFontNormal");
	button.text:SetAllPoints();
	button.text:SetFont("Interface\\AddOns\\RogueDefibrillator\\Bazooka.ttf",fontSize,"");
	
	button.cpframe = CreateFrame("Frame", nil, button);
	button.cpframe:SetFrameStrata("BACKGROUND");
	button.cpframe:SetPoint("CENTER");
	button.cpframe:SetWidth(height);
	button.cpframe:SetHeight(width);
	button.cpframe:Hide();

	button.cpicon = button.cpframe:CreateTexture(nil,"BACKGROUND");
	button.cpicon:SetTexture(TEXTURE_COMBO_POINT);
	button.cpicon:SetAllPoints(button.cpframe);
	button.cpicon:Show();

	button.useframe = CreateFrame("Frame", nil, button);
	button.useframe:SetFrameStrata("BACKGROUND");
	button.useframe:SetPoint("CENTER");
	button.useframe:SetWidth(height);
	button.useframe:SetHeight(width);
	button.useframe:Hide();

	button.useicon = button.useframe:CreateTexture(nil,"BACKGROUND");
	button.useicon:SetTexture(TEXTURE_USE);
	button.useicon:SetAllPoints(button.useframe);
	button.useicon:Show();
	
	button.icon = button:CreateTexture(nil,"ARTWORK")
	button.icon:SetAllPoints(button)
	button.icon:SetVertexColor(1,1,1,1);
	button.icon:Show();
		
	return button;
end