RicoMiniMap = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0")
RicoMiniMap:RegisterDB("RicoMiniMapDB")
local dewdrop = AceLibrary("Dewdrop-2.0")
local RicoMiniMapHidden = false
local strataNames = {"BACKGROUND", "LOW", "MEDIUM", "HIGH", "DIALOG", "FULLSCREEN", "FULLSCREEN_DIALOG", "TOOLTIP"}
local L = AceLibrary("AceLocale-2.2"):new("RicoMM")

-- Pretend I'm CleanMinimap so addons like Titan Panel will play nice with me
CleanMinimap = true

L:RegisterTranslations("enUS", function() return {
	["Locked"] = true,
	["Prevent dragging the map or buttons"] = true,
	["Show Coordinates"] = true,
	["Show your location coordiates"] = true,
	["Show Coordinate Tenths"] = true,
	["Show your location with tenths"] = true,
	["Coordinates Position"] = true,
	["Choose the location of the coordinates"] = true,
	["Inside Top"] = true,
	["Outside Top"] = true,
	["Inside Bottom"] = true,
	["Outside Bottom"] = true,
	["Show Zoom Buttons"] = true,
	["Show the zoom in and zoom out buttons"] = true,
	["Show Map Button"] = true,
	["Show the world map button"] = true,
	["Show Time Button"] = true,
	["Show the time button"] = true,
	["Show Zone Text"] = true,
	["Show the default zone text"] = true,
	["Show Minimap Border"] = true,
	["Toggle the minimap border"] = true,
	["Show Menu"] = true,
	["Toggle showing the menu on right-click.  '/rmm menu' to re-enable"] = true,
	["Shape"] = true,
	["Choose the shape of the minimap"] = true,
	["Bottom Left"] = true,
	["Bottom Left corner is rounded"] = true,
	["Square"] = true,
	["All four corners square"] = true,
	["Round"] = true,
	["All four corners round"] = true,
	["Strata"] = true,
	["Change the minimap strata"] = true,
	["Scale"] = true,
	["Scale the minimap from 50% to 150% in 1% increments"] = true,
	["Transparency"] = true,
	["Set the transparency of the MiniMap"] = true,
	["Zone Text Location"] = true,
	["Set the location of the zone text"] = true,
	["A customizable MiniMap"] = true,
	["config"] = true,
	["Open the config menu."] = true,
	["reset"] = true,
	["Reset the minimap's position."] = true,
	["menu"] = true,
	["Enable the menu on right-click."] = true,
	["hide"] = true,
	["Hide the entire minimap."] = true,
	["show"] = true,
	["Show the minimap."] = true,
}end)


L:RegisterTranslations("zhCN", function() return {
	["Locked"] = "",
	["Prevent dragging the map or buttons"] = "ֹ϶Сͼ߰ť",
	["Show Coordinates"] = "ʾ",
	["Show your location coordiates"] = "ʾ㵱ǰ",
	["Show Coordinate Tenths"] ="ʾ߾",
	["Show your location with tenths"] ="ʹø߾ʾ㵱ǰ",
	["Coordinates Position"] = "λ",
	["Choose the location of the coordinates"] = "ѡʾλ",
	["Inside Top"] = "",
	["Outside Top"] = "",
	["Inside Bottom"] = "ײ",
	["Outside Bottom"] = "ײ",
	["Show Zoom Buttons"] = "ʾŰť",
	["Show the zoom in and zoom out buttons"] = "ʾСͼŰť",
	["Show Map Button"] = "ʾͼť",
	["Show the world map button"] = "ʾͼť",
	["Show Time Button"] = "ʾʱ䰴ť",
	["Show the time button"] = "ʾϵͳʱ䰴ť",
	["Show Zone Text"] = "ʾ",
	["Show the default zone text"] = "ʾĬ",
	["Show Minimap Border"] = "ʾСͼ߿",
	["Toggle the minimap border"] = "лʾСͼ߿",
	["Show Menu"] = "ʾĿ¼",
	["Toggle showing the menu on right-click.  '/rmm menu' to re-enable"] = "лһСͼʾĿ¼,'/rmm Ŀ¼'",
	["Shape"] = "״",
	["Choose the shape of the minimap"] = "ѡСͼ״",
	["Bottom Left"] = "1/4Բ",
	["Bottom Left corner is rounded"] = "ײΪԲ",
	["Square"] = "",
	["All four corners square"] = "",
	["Round"] = "Բ",
	["All four corners round"] = "Բ",
	["Strata"] = "",
	["Change the minimap strata"] = "ıСͼ",
	["Scale"] = "",
	["Scale the minimap from 50% to 150% in 1% increments"] = "СͼŷΧΪ50%~150.",
	["Transparency"] = "͸",
	["Set the transparency of the MiniMap"] = "Сͼ͸",
	["Zone Text Location"] = "λ",
	["Set the location of the zone text"] = "λ",
	["A customizable MiniMap"] = "ԶСͼ.",
	["config"] = "",
	["Open the config menu."] = "Ŀ¼",
	["reset"] = "",
	["Reset the minimap's position."] = "Сͼλ",
	["menu"] = "Ŀ¼",
	["Enable the menu on right-click."] = "һʾĿ¼",
	["hide"] = "",
	["Hide the entire minimap."] = "Сͼ",
	["show"] = "ʾ",
	["Show the minimap."] = "ʾСͼ",
}end)


RicoMiniMap_OptionTable = {
	type    = "group",
	handler = RicoMiniMap,
	args = {
		RicoMiniMap_DragLock = {
			type = "toggle",
			order= 1,
			name = L["Locked"],
			desc = L["Prevent dragging the map or buttons"],
			get  = function() return RicoMiniMap:IsLocked() end,
			set  = function() RicoMiniMap:ToggleLocked() end,
		},
		RicoMiniMap_Coordinates = {
			type = "toggle",
			order= 2,
			name = L["Show Coordinates"],
			desc = L["Show your location coordiates"],
			get  = function() return RicoMiniMap:IsShowingCoordinates() end,
			set  = function() RicoMiniMap:ToggleShowingCoordinates() end,
		},
		RicoMiniMap_CoordinateTenths = {
			type = "toggle",
			order= 3,
			name = L["Show Coordinate Tenths"],
			desc = L["Show your location with tenths"],
			get  = function() return RicoMiniMap:IsShowingCoordinateTenths() end,
			set  = function() RicoMiniMap:ToggleShowingCoordinateTenths() end,
		},
		RicoMiniMap_CoordPos={
			type ="group",
			order=4, 
			name =L["Coordinates Position"], 
			desc =L["Choose the location of the coordinates"],
			args ={
				CoordPos3 = {
					type = "toggle", 
					order= 3, 
					name = L["Inside Top"], 
					desc = L["Inside Top"],
					get  = function() return(RicoMiniMap:GetCoordinatesPosition() == 3) end,
					set  = function() RicoMiniMap:SetCoordinatesPosition(3) RicoMiniMap:UpdateCoordinatesPosition() end
				},
				CoordPos4 = {
					type = "toggle", 
					order= 4, 
					name = L["Outside Top"], 
					desc = L["Outside Top"],
					get  = function() return(RicoMiniMap:GetCoordinatesPosition() == 4) end,
					set  = function() RicoMiniMap:SetCoordinatesPosition(4) RicoMiniMap:UpdateCoordinatesPosition() end
				},
				CoordPos1 = {
					type = "toggle", 
					order= 1, 
					name = L["Inside Bottom"], 
					desc = L["Inside Bottom"],
					get  = function() return(RicoMiniMap:GetCoordinatesPosition() == 1) end,
					set  = function() RicoMiniMap:SetCoordinatesPosition(1) RicoMiniMap:UpdateCoordinatesPosition() end
				},
				CoordPos2 = {
					type = "toggle", 
					order= 2, 
					name = L["Outside Bottom"], 
					desc = L["Outside Bottom"],
					get  = function() return(RicoMiniMap:GetCoordinatesPosition() == 2) end,
					set  = function() RicoMiniMap:SetCoordinatesPosition(2) RicoMiniMap:UpdateCoordinatesPosition() end
				},
			},
		},
		RicoMiniMap_ZoomButtons = {
			type = "toggle",
			order= 5,
			name = L["Show Zoom Buttons"],
			desc = L["Show the zoom in and zoom out buttons"],
			get  = function() return RicoMiniMap:IsShowingZoomButtons() end,
			set  = function() RicoMiniMap:ToggleShowingZoomButtons() end,
		},
		RicoMiniMap_MapButton = {
			type = "toggle",
			order= 6,
			name = L["Show Map Button"],
			desc = L["Show the world map button"],
			get  = function() return RicoMiniMap:IsShowingMapButton() end,
			set  = function() RicoMiniMap:ToggleShowingMapButton() end,
		},
		RicoMiniMap_TimeButton = {
			type = "toggle",
			order= 6.5,
			name = L["Show Time Button"],
			desc = L["Show the time button"],
			get  = function() return RicoMiniMap:IsShowingTimeButton() end,
			set  = function() RicoMiniMap:ToggleShowingTimeButton() end,
		},
		RicoMiniMap_ZoneLabel = {
			type = "toggle",
			order= 7,
			name = L["Show Zone Text"],
			desc = L["Show the default zone text"],
			get  = function() return RicoMiniMap:IsShowingZoneText() end,
			set  = function() RicoMiniMap:ToggleShowingZoneText() end,
		},
		RicoMiniMap_Border = {
			type = "toggle",
			order= 8,
			name = L["Show Minimap Border"],
			desc = L["Toggle the minimap border"],
			get  = function() return RicoMiniMap:IsShowingBorder() end,
			set  = function() RicoMiniMap:ToggleShowingBorder() end,
		},
		RicoMiniMap_RCMenu = {
			type = "toggle",
			order= 9,
			name = L["Show Menu"],
			desc = L["Toggle showing the menu on right-click.  '/rmm menu' to re-enable"],
			get  = function() return RicoMiniMap:IsShowingMenu() end,
			set  = function() RicoMiniMap:ToggleShowingMenu() end,
		},
		RicoMiniMap_Shape={
			type ="group",
			order= 10, 
			name =L["Shape"], 
			desc =L["Choose the shape of the minimap"],
			args ={
				Shape1 = {
					type = "toggle", 
					order= 1, 
					name = L["Bottom Left"], 
					desc = L["Bottom Left corner is rounded"],
					get  = function() return(RicoMiniMap:GetShape() == 1) end,
					set  = function() RicoMiniMap:SetShape(1) RicoMiniMap:UpdateShape() end
				},
				Shape2 = {
					type = "toggle", 
					order= 2, 
					name = L["Square"], 
					desc = L["All four corners square"],
					get  = function() return(RicoMiniMap:GetShape() == 2) end,
					set  = function() RicoMiniMap:SetShape(2) RicoMiniMap:UpdateShape() end
				},
				Shape3 = {
					type = "toggle", 
					order= 3, 
					name = L["Round"], 
					desc = L["All four corners round"],
					get  = function() return(RicoMiniMap:GetShape() == 3) end,
					set  = function() RicoMiniMap:SetShape(3) RicoMiniMap:UpdateShape() end
				},
			},
		},
		RicoMiniMap_Strata = {
			type = "range",
			order = 7,
			name = L["Strata"],
			desc = L["Change the minimap strata"],
      max = 8, 
      min = 1,
      step = 1,
      get = "GetMapStrata",
      set = "SetMapStrata",
		},
		RicoMiniMap_Scale = {
			type = "range",
			order = 11,
			name = L["Scale"],
			desc = L["Scale the minimap from 50% to 150% in 1% increments"],
      max = 1.5, 
      min = 0.5,
      step = 0.01,
      isPercent = true,
      get = "GetMapScale",
      set = "SetMapScale",
		},
		RicoMiniMap_Alpha = {
			type = "range",
			order = 12,
			name = L["Transparency"],
			desc = L["Set the transparency of the MiniMap"],
			max = 1,
			min = 0.1,
			step = 0.05,
			get = "GetAlpha",
			set = "SetAlpha",
		},
		RicoMiniMap_ZoneTextLocation = {
			type = "range",
			order = 13,
			name = L["Zone Text Location"],
			desc = L["Set the location of the zone text"],
			max = 0,
			min = -30,
			step = 1,
			get = "GetZoneTextLocation",
			set = "SetZoneTextLocation",
		},
	},
}

RicoMiniMap:RegisterDefaults('profile', {
  	ShowCoordinates = true,
  	ShowTenths = true,
  	ShowZoneText = false,
  	ZoneTextOffset = 30,
  	ShowZoomButtons = false,
  	ShowMapButton = false,
  	ShowTime = false,
  	Scale = 1.25,
  	Strata = 1,
  	Shape = 1,
  	CoordinatesPosition = 1,
  	Alpha = 1
	}
)

function RicoMiniMap:OnInitialize()
	self:RegisterEvent("MINIMAP_UPDATE_ZOOM")

	self.slashOptions = {
		name = "RicoMiniMap",
		desc = L["A customizable MiniMap"],
		type = "group",
		args = {
			[L["config"]] = {
				name = L["config"],
				type = "execute",
				desc = L["Open the config menu."],
				func = function() dewdrop:Open(Minimap) end,
			},
			[L["reset"]] = {
				name = L["reset"],
				type = "execute",
				desc = L["Reset the minimap's position."],
				func = function() MinimapCluster:ClearAllPoints() MinimapCluster:SetPoint("CENTER") end,
			},				
			[L["menu"]] = {
				name = L["menu"],
				type = "execute",
				desc = L["Enable the menu on right-click."],
				func = function() self.db.profile.ShowMenu = true RicoMiniMap:UpdateMinimapMenu() end,
			},				
			[L["hide"]] = {
				name = L["hide"],
				type = "execute",
				desc = L["Hide the entire minimap."],
				func = function() RicoMiniMapHidden = true RicoMiniMap:UpdateShape() end,
			},				
			[L["show"]] = {
				name = L["show"],
				type = "execute",
				desc = L["Show the minimap."],
				func = function() RicoMiniMapHidden = false RicoMiniMap:UpdateShape() end,
			},				
		}
	}

	if self.db.char.HasMoved == nil then
		MinimapCluster:ClearAllPoints()
		MinimapCluster:SetPoint("TOPRIGHT", UIParent)
		self.db.char.HasMoved = true
	end
	
	MinimapCluster:SetScale(RicoMiniMap:GetMapScale())
	MinimapCluster:SetMovable(true)
	Minimap:RegisterForDrag("LeftButton")
	Minimap:SetScript("OnDragStart", function() self:MapDrag(true) end)
	Minimap:SetScript("OnDragStop", function() self:MapDrag(false) end)

	MinimapZoneTextButton:ClearAllPoints()
	MinimapZoneTextButton:SetPoint("TOPRIGHT", -20, self.db.profile.ZoneTextLocation)
	MinimapZoneTextButton:SetFrameStrata("LOW")

	MinimapBorderTop:Hide()
	MinimapToggleButton:Hide()
	
	self.OnMenuRequest = RicoMiniMap_OptionTable
	self.overrideMenu = true
	self:RegisterChatCommand({"/RicoMiniMap", "/rmm"}, self.slashOptions)

	self.buttons = {
		b1 = MiniMapBattlefieldFrame,
		b2 = MiniMapMeetingStoneFrame,
		b3 = MiniMapWorldMapButton,
		b4 = MiniMapMailFrame,
		b6 = MiniMapTracking,
		b7 = MinimapZoomIn,
		b8 = MinimapZoomOut,
		b9 = MiniMapVoiceChatFrame
	}
	for _, button in pairs(self.buttons) do
		button:SetMovable(true)
		button:RegisterForDrag("LeftButton")
		button:SetScript("OnDragStart", function() self:ButtonDrag(true) end)
		button:SetScript("OnDragStop", function() self:ButtonDrag(false) end)
	end

	self.mmframes = {
		f1 = QuestWatchFrame,
		f2 = QuestTimerFrame,
		f3 = TicketStatusFrame,
		f4 = DurabilityFrame
	}
	for _, mmframe in pairs(self.mmframes) do
		mmframe:SetMovable(true)
		mmframe:RegisterForDrag("LeftButton")
		mmframe:SetScript("OnDragStart", function() self:MMFrameDrag(true) end)
		mmframe:SetScript("OnDragStop", function() self:MMFrameDrag(false) end)
	end

	RicoMiniMap:UpdateZoomButtons()
	RicoMiniMap:UpdateShape()
	RicoMiniMap:UpdateCoordinatesPosition()
	RicoMiniMap:UpdateAlpha()
	RicoMiniMap:UpdateMinimapMenu()
	
	if RicoMiniMap:IsShowingMapButton() then
		MiniMapWorldMapButton:Show()
	else
		MiniMapWorldMapButton:Hide()
	end

	if RicoMiniMap:IsShowingTimeButton() then
		GameTimeFrame:Show()
	else
		GameTimeFrame:Hide()
	end

	if RicoMiniMap:IsShowingZoneText() then
		MinimapZoneTextButton:Show()
	else
		MinimapZoneTextButton:Hide()
	end
	
end

function RicoMiniMap_OnLoad()
end

function RicoMiniMap:MapDrag(moving)
	if moving and RicoMiniMap:IsLocked() == false then
		MinimapCluster.isMoving = true
		MinimapCluster:StartMoving()
	elseif MinimapCluster.isMoving then
		MinimapCluster.isMoving = false
		MinimapCluster:StopMovingOrSizing()
	end
end

function RicoMiniMap:ButtonDrag(moving)
	local function getPos()
		local mapShape = RicoMiniMap:GetShape()
		local cx, cy = GetCursorPosition(UIParent)
		local mx, my = Minimap:GetLeft(), Minimap:GetBottom()
		local z = Minimap:GetEffectiveScale()
		local vector = (math.deg(math.atan2(cy / z - my - 70, mx - cx / z + 70)))
		if mapShape == 3 then
			x = 52 - 81 * cos(vector)
			y = 81 * sin(vector) - 54
		else
			--DEFAULT_CHAT_FRAME:AddMessage(mapShape.."/"..vector)
			x = 52 - math.max(-81, math.min(110 * cos(vector), 81))
			y = math.max(-81, math.min(110 * sin(vector), 81)) - 54
			if mapShape == 1 and vector > -90 and vector < 0 then
				x = 52 - 81 * cos(vector)
				y = 81 * sin(vector) - 54
			end
		end
		return x, y
	end
	if moving and RicoMiniMap:IsLocked() == false then
		this.isMoving = true
		this:SetScript("OnUpdate", function()
			local x, y = getPos()
      		this:ClearAllPoints()
			this:SetPoint("TOPLEFT", Minimap, "TOPLEFT", x, y)
		end)
		this:StartMoving()
	elseif this.isMoving then
		this.isMoving = false
		this:StopMovingOrSizing()
		this:SetScript("OnUpdate", nil)
	end
end

function RicoMiniMap:MMFrameDrag(moving)
	if moving and RicoMiniMap:IsLocked() == false then
		this.isMoving = true
		this:StartMoving()
	elseif this.isMoving then
		this.isMoving = false
		this:StopMovingOrSizing()
	end
end

function RicoMiniMap:IsLocked()
	if self.db.profile.Locked == nil then
		self.db.profile.Locked = false
	end
	return self.db.profile.Locked
end

function RicoMiniMap:ToggleLocked()
	if self.db.profile.Locked == true then
	  self.db.profile.Locked = false
 		QuestWatchFrame:EnableMouse(true)
 	else
	  self.db.profile.Locked = true
 		QuestWatchFrame:EnableMouse(false)
	end
	return self.db.profile.Locked
end

function RicoMiniMap:IsShowingCoordinates()
	if self.db.profile.ShowCoordinates == nil then
		self.db.profile.ShowCoordinates = true
	end
	return self.db.profile.ShowCoordinates
end

function RicoMiniMap:ToggleShowingCoordinates()
	self.db.profile.ShowCoordinates = not self.db.profile.ShowCoordinates
	return self.db.profile.ShowCoordinates
end

function RicoMiniMap:IsShowingCoordinateTenths()
	if self.db.profile.ShowTenths == nil then
		self.db.profile.ShowTenths = true
	end
	return self.db.profile.ShowTenths
end

function RicoMiniMap:ToggleShowingCoordinateTenths()
	self.db.profile.ShowTenths = not self.db.profile.ShowTenths
	return self.db.profile.ShowTenths
end

function RicoMiniMap:IsShowingZoomButtons()
	if self.db.profile.ShowZoomButtons == nil then
		self.db.profile.ShowZoomButtons = false
	end
	return self.db.profile.ShowZoomButtons
end

function RicoMiniMap:ToggleShowingZoomButtons()
	self.db.profile.ShowZoomButtons = not self.db.profile.ShowZoomButtons
	RicoMiniMap:UpdateZoomButtons()
	return self.db.profile.ShowZoomButtons
end

function RicoMiniMap:UpdateZoomButtons()
	if RicoMiniMap:IsShowingZoomButtons() then
		MinimapZoomIn:Show()
  	MinimapZoomOut:Show()	
	else
		MinimapZoomIn:Hide()
  	MinimapZoomOut:Hide()	
	end
end

function RicoMiniMap:IsShowingMapButton()
	if self.db.profile.ShowMapButton == nil then
		self.db.profile.ShowMapButton = false
	end
	return self.db.profile.ShowMapButton
end

function RicoMiniMap:ToggleShowingMapButton()
	self.db.profile.ShowMapButton = not self.db.profile.ShowMapButton
	if RicoMiniMap:IsShowingMapButton() then
		MiniMapWorldMapButton:Show()
	else
		MiniMapWorldMapButton:Hide()
	end
	return self.db.profile.ShowMapButton
end

function RicoMiniMap:IsShowingTimeButton()
	if self.db.profile.ShowTimeButton == nil then
		self.db.profile.ShowTimeButton = false
	end
	return self.db.profile.ShowTimeButton
end

function RicoMiniMap:ToggleShowingTimeButton()
	self.db.profile.ShowTimeButton = not self.db.profile.ShowTimeButton
	if RicoMiniMap:IsShowingTimeButton() then
		GameTimeFrame:Show()
	else
		GameTimeFrame:Hide()
	end
	return self.db.profile.ShowTimeButton
end

function RicoMiniMap:IsShowingZoneText()
	if self.db.profile.ShowZoneText == nil then
		self.db.profile.ShowZoneText = false
	end
	return self.db.profile.ShowZoneText
end

function RicoMiniMap:ToggleShowingZoneText()
	self.db.profile.ShowZoneText = not self.db.profile.ShowZoneText
	if RicoMiniMap:IsShowingZoneText() then
		MinimapZoneTextButton:Show()
	else
		MinimapZoneTextButton:Hide()
	end
	return self.db.profile.ShowZoneText
end

function RicoMiniMap:GetMapScale()
	if self.db.profile.Scale == nil then
		self.db.profile.Scale = 1.25
	end
	return self.db.profile.Scale
end

function RicoMiniMap:SetMapScale(value)
	MinimapCluster:SetScale(value)
	self.db.profile.Scale = value
end

function RicoMiniMap:GetMapStrata()
	if self.db.profile.Strata == nil then
		self.db.profile.Strata = 1
	end
	return self.db.profile.Strata
end

function RicoMiniMap:SetMapStrata(value)
	MinimapCluster:SetFrameStrata(strataNames[value])
	self.db.profile.Strata = value
end

function RicoMiniMap:GetAlpha()
	if self.db.profile.Alpha == nil then
		self.db.profile.Alpha = 1
	end
	return self.db.profile.Alpha
end

function RicoMiniMap:SetAlpha(value)
	self.db.profile.Alpha = value
	RicoMiniMap:UpdateAlpha()
end

function RicoMiniMap:UpdateAlpha()
	local value = self.db.profile.Alpha
	if value ~= nil then
		Minimap:SetAlpha(value)
	end
end

function RicoMiniMap:GetZoneTextLocation()
	if self.db.profile.ZoneTextLocation == nil then
		self.db.profile.ZoneTextLocation = -20
	end
	return self.db.profile.ZoneTextLocation
end

function RicoMiniMap:SetZoneTextLocation(value)
	MinimapZoneTextButton:ClearAllPoints()
	MinimapZoneTextButton:SetPoint("TOPRIGHT", -20, value)
	self.db.profile.ZoneTextLocation = value
end

function RicoMiniMap:GetShape()
	if self.db.profile.Shape == nil then
		self.db.profile.Shape = 1
	end
	return self.db.profile.Shape
end

function RicoMiniMap:SetShape(value)
	self.db.profile.Shape = value
end

function RicoMiniMap:UpdateShape()
	if RicoMiniMapHidden then
		MinimapCluster:Hide()
	else
		MinimapCluster:Show()
		local value = self.db.profile.Shape
		local texture = "Interface\\Minimap\\UI-Minimap-Border"
		local mask = "textures\\MinimapMask"
		
		if value == 1 then
			texture = "Interface\\AddOns\\RicoMiniMap\\BLRoundMinimap"
			mask = "Interface\\AddOns\\RicoMiniMap\\BLRoundMinimapMask"
		end
		
		if value == 2 then
			texture = "Interface\\AddOns\\RicoMiniMap\\SquareMinimap"
			mask = "Interface\\AddOns\\RicoMiniMap\\SquareMinimapMask"
		end
		
		if RicoMiniMap:IsShowingBorder() then
			MinimapBorder:Show()
			MinimapBorder:SetTexture(texture)
			MinimapBorder:SetDrawLayer("ARTWORK")
		else
			MinimapBorder:Hide()
		end
		Minimap:SetMaskTexture(mask)
		RicoMiniMap:UpdateCoordinatesPosition()
	end
end

function RicoMiniMap:GetCoordinatesPosition()
	if self.db.profile.CoordinatesPosition == nil then
		self.db.profile.CoordinatesPosition = 1
	end
	return self.db.profile.CoordinatesPosition
end

function RicoMiniMap:SetCoordinatesPosition(value)
	self.db.profile.CoordinatesPosition = value
end

function RicoMiniMap:UpdateCoordinatesPosition()
	local value = self.db.profile.CoordinatesPosition
	RicoMinimap_CoordinatesFrame:ClearAllPoints()
	if value == 1 then
		if self.db.profile.Shape == 1 then
			RicoMinimap_CoordinatesFrame:SetPoint("BOTTOM", "Minimap", "BOTTOM", 30, 0)
		else
			RicoMinimap_CoordinatesFrame:SetPoint("BOTTOM", "Minimap", "BOTTOM", 0, 0)
		end
		RicoMinimap_CoordinatesFrame:SetBackdropColor(0, 0, 0, 0)
		RicoMinimap_CoordinatesFrame:SetBackdropBorderColor(0, 0, 0, 0)
	end
	if value == 2 then
		if self.db.profile.Shape == 1 then
			RicoMinimap_CoordinatesFrame:SetPoint("TOP", "Minimap", "BOTTOM", 30, 0)
		else
			RicoMinimap_CoordinatesFrame:SetPoint("TOP", "Minimap", "BOTTOM", 0, 0)
		end
		RicoMinimap_CoordinatesFrame:SetBackdropColor(0, 0, 0, 1)
		RicoMinimap_CoordinatesFrame:SetBackdropBorderColor(0, 0, 0, 1)
	end
	if value == 3 then
		if self.db.profile.Shape == 1 then
			RicoMinimap_CoordinatesFrame:SetPoint("TOP", "Minimap", "TOP", 30, 0)
		else
			RicoMinimap_CoordinatesFrame:SetPoint("TOP", "Minimap", "TOP", 0, 0)
		end
		RicoMinimap_CoordinatesFrame:SetBackdropColor(0, 0, 0, 0)
		RicoMinimap_CoordinatesFrame:SetBackdropBorderColor(0, 0, 0, 0)
	end
	if value == 4 then
		if self.db.profile.Shape == 1 then
			RicoMinimap_CoordinatesFrame:SetPoint("BOTTOM", "Minimap", "TOP", 30, 0)
		else
			RicoMinimap_CoordinatesFrame:SetPoint("BOTTOM", "Minimap", "TOP", 0, 0)
		end
		RicoMinimap_CoordinatesFrame:SetBackdropColor(0, 0, 0, 1)
		RicoMinimap_CoordinatesFrame:SetBackdropBorderColor(0, 0, 0, 1)
	end
end

function RicoMiniMap:IsShowingBorder()
	if self.db.profile.ShowBorder == nil then
		self.db.profile.ShowBorder = true
	end
	return self.db.profile.ShowBorder
end

function RicoMiniMap:ToggleShowingBorder()
	self.db.profile.ShowBorder = not self.db.profile.ShowBorder
	RicoMiniMap:UpdateShape()
	return self.db.profile.ShowBorder
end

function RicoMiniMap:IsShowingMenu()
	if self.db.profile.ShowMenu == nil then
		self.db.profile.ShowMenu = true
	end
	return self.db.profile.ShowMenu
end

function RicoMiniMap:ToggleShowingMenu()
	self.db.profile.ShowMenu = not self.db.profile.ShowMenu
	RicoMiniMap:UpdateMinimapMenu()
	return self.db.profile.ShowMenu
end

function RicoMiniMap:UpdateMinimapMenu()
	if RicoMiniMap:IsShowingMenu() then
		dewdrop:Register(Minimap,
			'children', function()
				dewdrop:FeedAceOptionsTable(RicoMiniMap_OptionTable)
			end
		)
	else
		dewdrop:Unregister(Minimap)
	end
end



------------------
-- Coordinates text
function RicoMiniMap_updateLocText()
	if RicoMiniMap:IsShowingCoordinates() then
		RicoMinimap_CoordinatesFrame:Show()
		local x, y = GetPlayerMapPosition('player')
		if x == 0 and y == 0 then 
			RicoMinimap_CoordinatesText:SetText('')
		else
			if RicoMiniMap:IsShowingCoordinateTenths() then
				RicoMinimap_CoordinatesText:SetText(string.format('%.1f, %.1f', x*100, y*100))
			else
				RicoMinimap_CoordinatesText:SetText(string.format('%.0f, %.0f', x*100, y*100))
			end
		end
		RicoMinimap_CoordinatesFrame:SetWidth(RicoMinimap_CoordinatesText:GetWidth() + 20)
		RicoMinimap_CoordinatesFrame:SetHeight(RicoMinimap_CoordinatesText:GetHeight() + 12)
	else
		RicoMinimap_CoordinatesFrame:Hide()
	end
end

-------------------------------
-- Zooming with the mouse wheel
function MiniMap_OnMouseWheel(value)
		if value > 0 then
			RicoMinimap_ZoomIn()
		elseif value < 0 then
			RicoMinimap_ZoomOut()
		end
end

function RicoMinimap_ZoomIn()
	if Minimap:GetZoom() == 5 then
		Minimap:SetZoom(5)
	else
		Minimap:SetZoom(Minimap:GetZoom() + 1)
	end
end

function RicoMinimap_ZoomOut()
	if Minimap:GetZoom() == 0 then
		Minimap:SetZoom(0)
	else
		Minimap:SetZoom(Minimap:GetZoom() - 1)
	end
end

-----------------
-- Event handlers
function RicoMiniMap:MINIMAP_UPDATE_ZOOM()
	if (tonumber(GetCVar("minimapInsideZoom")) == Minimap:GetZoom()) then
		self.inside = true
	else
		self.inside = false
	end
	if(self.inside) then
		Minimap:SetAlpha(1)
	else
		Minimap:SetAlpha(self.db.profile.Alpha)
	end
end

-- Fubar and Cartographer compatibility
function GetMinimapShape()
  local myShape = RicoMiniMap:GetShape()
	local shape = "CORNER-BOTTOMLEFT"
	if myShape == 2 then shape = "SQUARE" end
	if myShape == 3 then shape = "ROUND" end
	return shape
end
