RESTED_MSG_VERSION = GetAddOnMetadata("Rested","Version");
RESTED_MSG_ADDONNAME = "Rested Reporter";

-- Colours
COLOR_RED = "|cffff0000";
COLOR_GREEN = "|cff00ff00";
COLOR_BLUE = "|cff0000ff";
COLOR_PURPLE = "|cff700090";
COLOR_YELLOW = "|cffffff00";
COLOR_ORANGE = "|cffff6d00";
COLOR_GREY = "|cff808080";
COLOR_GOLD = "|cffcfb52b";
COLOR_NEON_BLUE = "|cff4d4dff";
COLOR_END = "|r";

local Rested = {};
Rested.maxLevel = 80;

function Rested_OnLoad()
	this:RegisterEvent("PLAYER_XP_UPDATE");
	this:RegisterEvent("UPDATE_EXHAUSTION");
	this:RegisterEvent("CHANNEL_UI_UPDATE");
	this:RegisterEvent("ADDON_LOADED");

	--register slash commands
	SLASH_RESTED1 = "/rested";
	SlashCmdList["RESTED"] = function(msg) Rested_Command(msg); end
	Rested.debug = false;
	Rested.info = false;
end

function Rested_ADDON_LOADED()
	Rested.name = UnitName("player");
	Rested.realm = GetRealmName();

	-- init unsaved variables
	-- Global
	if Rested_options == nil then
		Rested_options = {};
	end
	if Rested_options.maxCutOff == nil then
		Rested_options.maxCutOff = 7;    -- in days
	end
	if Rested_options.maxStale == nil then
		Rested_options.maxStale = 10;    -- in days
	end

	if Rested_restedState == nil then
		Rested_restedState = {};
		Rested_Print("restedState init");
	end

	-- find or init the realm
	realmFound, playerFound = false, false;
	for k,v in pairs(Rested_restedState) do
		if (k == Rested.realm) then
			realmFound = true;
			break;
		end
	end
	if not realmFound then
		Rested_restedState[Rested.realm] = {};
	end

	-- find or init the player
	for k,v in pairs(Rested_restedState[Rested.realm]) do
		if (k == Rested.name) then
			playerFound = true;
			break;
		end
	end
	if not playerFound then
		Rested_restedState[Rested.realm][Rested.name] = {};
		Rested_restedState[Rested.realm][Rested.name]["initAt"] = time();
		Rested_restedState[Rested.realm][Rested.name]["restedPC"] = 0;
		Rested_PrintToonCount();
	end

	Rested_restedState[Rested.realm][Rested.name]["updated"] = time();

	--Rested_Print("Addon_Loaded End");
end

function Rested_Print( msg, showName)
	-- print to the chat frame
	-- set showName to false to suppress the addon name printing
	if (showName == nil) or (showName) then
		msg = COLOR_RED..RESTED_MSG_ADDONNAME.."> "..COLOR_END..msg;
	end
	DEFAULT_CHAT_FRAME:AddMessage( msg );
end

function Rested_PrintStatus()
--	Rested_Print("Status Report");
	Rested_Print("Version: "..RESTED_MSG_VERSION);
--	Rested_Print("Memory usage: "..collectgarbage("count").." kB");
	Rested_Print("Max Level nagtime: "..COLOR_GREEN..Rested_options.maxCutOff..COLOR_END.." Days.");
	Rested_Print("Max Level stale time: "..COLOR_GREEN..Rested_options.maxStale..COLOR_END.." Days.");
	Rested_PrintToonCount();
end

function Rested_PrintToonCount()
	local realmCount = 0;
	local nameCount = 0;
	for r, v in pairs(Rested_restedState) do
		for n, _ in pairs(v) do
			nameCount = nameCount + 1;
		end
		realmCount = realmCount + 1;
	end
	Rested_Print(nameCount .." toons found on ".. realmCount .." realms.");
end

function Rested_Debug( msg )
	-- Print Debug Messages
	if Rested.debug then
		msg = "debug-"..msg;
		Rested_Print( msg );
	end
end

function Rested_OnEvent(event, arg1, arg2, arg3, ...)
	-- ... is open ended arguments
	if (event == "ADDON_LOADED") then
		Rested_ADDON_LOADED();
	elseif (event == "UPDATE_EXHAUSTION") then
		Rested_SaveRestedState();
	elseif (event == "CHANNEL_UI_UPDATE") then
		Rested_SaveRestedState();
	end
end

function Rested_ParseCmd(msg)
	if msg then
		local a,b,c = strfind(msg, "(%S+)");  --contiguous string of non-space characters
		if a then
			return c, strsub(msg, b+2);
		else
			return "";
		end
	end
end

-- slash function handle
function Rested_Command(msg)
	--cmd will be nothing
	local cmd, param = Rested_ParseCmd(msg);
	
	if (cmd == "help") then
		Rested_PrintHelp();
		return;
	elseif (cmd == "status") then
		Rested_PrintStatus();
	elseif (cmd == "nagtime") then
		Rested_setNagTime( param );
	elseif (cmd == "skills") then
		Rested_PrintSkills();
	elseif (cmd == "max") then
		Rested_ReportMax();
	elseif (cmd == "stale") then
		Rested_ReportStale();
	else
		if (cmd ~= nil) and (string.sub(cmd,1,1) == "-") then
			Rested_RemoveFromRested( string.sub(cmd,2) );
			return;
		end
		Rested_SaveRestedState();
		Rested_Report();
	end
end

function Rested_PrintHelp()
	Rested_Print("/Rested           -> Rested Report");
	Rested_Print("/Rested -name     -> Remove name from tracking");
	Rested_Print("/Rested help      -> Shows this menu");
	Rested_Print("/Rested status    -> Shows status info");
	Rested_Print("/Rested max       -> Shows list of max level toons");
	Rested_Print("/Rested stale     -> Shows list of stale toons");
	Rested_Print("/Rested nagtime # -> Set # of nag days for max lvl toons");
end

function Rested_SaveRestedState()
	Rested.rested = GetXPExhaustion();		-- XP till Exhaustion
	if (Rested.rested == nil) then
		Rested.rested = 0;
	end
	if (Rested.rested > 0) then
		Rested.restedPC = (Rested.rested / UnitXPMax("player")) * 100;
	else
		Rested.restedPC = 0;
	end

	if (Rested.info) then
		Rested_Print("UPDATE_EXHAUSTION fired at "..time()..": "..Rested.restedPC.."%");
	end
	if (Rested.realm ~= nil) and (Rested.name ~= nil) then
		Rested_restedState[Rested.realm][Rested.name]["restedPC"] = Rested.restedPC;
		Rested_restedState[Rested.realm][Rested.name]["updated"] = time();
		Rested_restedState[Rested.realm][Rested.name]["lvlNow"] = UnitLevel("player");
		Rested_restedState[Rested.realm][Rested.name]["xpMax"] = UnitXPMax("player");
		Rested_restedState[Rested.realm][Rested.name]["xpNow"] = UnitXP("player");
		Rested_restedState[Rested.realm][Rested.name]["isResting"] = IsResting();
	else
		Rested_Print("Realm and name not known");
	end
end

function Rested_Report()
	count = 0;
	charList = {};
	Rested_Print("Toon Rested Report", false);
	for r,v in pairs(Rested_restedState) do
		for n,v in pairs(Rested_restedState[r]) do
			if v["lvlNow"]~=Rested.maxLevel and v["restedPC"]~=150 then
				timeSince = time() - v["updated"];
				if v["isResting"] then		-- http://www.wowwiki.com/Rested
					restRate = (5/(8*3600));	-- 5% every 8 hours (5 seems to much)
					code = "+";
				else
					restRate = (5/(32*3600));	-- quarter rate 5% every 32 hours
					code = "-";
				end
				restAdded = restRate * timeSince;
				strOut = v["lvlNow"]..code.." ";
				restedVal = v["restedPC"] + restAdded + 0;
				restedSum = (string.format("%0.2f", restedVal) * 1);
				if restedSum > 150 then
					restedSum = 150;
					strOut = strOut .. COLOR_GREEN.."Fully Rested"..COLOR_END;
				else
					restAdded = (string.format("%0.2f", restAdded));
					restedSum = restedSum.."%";
					if (v["xpNow"] ~= nil) then    -- logic for previous version where xpNow was not stored.
						lvlPCLeft = ((v["xpMax"] - v["xpNow"]) / v["xpMax"]) * 100;
						if (restedVal >= lvlPCLeft) then
							restedSum = COLOR_GREEN..restedSum..COLOR_END;
						end
					end
					restNeeded = 150 - restedVal;
					timeTilRested = restNeeded / restRate;
					strOut = strOut .. restedSum .." ".. SecondsToTime(timeTilRested);
				end
				count = count + 1;
				strOut = strOut..": "..r..":"..n;
				table.insert( charList, {restedVal, strOut} );
			end
		end
	end
	if count > 0 then
		table.sort( charList, function( a,b ) return a[1] < b[1] end );
		table.foreach( charList, function(k,v) Rested_Print("  "..v[2], false) end );
	else
		Rested_Print("No toons are <" ..Rested.maxLevel.." and were not saved with 150% rested state.", false); 
	end
end

function Rested_ReportMax()
	count = 0;
	charList = {};
	local timeCutOff = Rested_options.maxCutOff * 86400;
	local stale = Rested_options.maxStale * 86400;
	for realm,restedHere in pairs(Rested_restedState) do
		for n,v in pairs(restedHere) do
			if (v.lvlNow == Rested.maxLevel) then
				timeSince = time() - v.updated;
				if (timeSince > timeCutOff) and (timeSince <= stale) then
					strOut = SecondsToTime(timeSince) ..": ".. realm ..":".. n;
					table.insert( charList, {timeSince, strOut} );
					count = count + 1;
				end
			end
		end
	end
	if (count > 0) then
		Rested_Print("Max Level toons:", false);
		table.sort(charList, function(a, b) return a[1] < b[1] end );
		table.foreach(charList, function(k, v) Rested_Print("  "..v[2], false) end );
	else
		Rested_Print("No max level toons need to be played", false);
	end
end

function Rested_ReportStale()
	-- reports on any toon that has not been seen for maxStale number of days
	count = 0;
	charList = {};
	local stale = Rested_options.maxStale * 86400;
	for realm, restedHere in pairs(Rested_restedState) do
		for n,v in pairs(restedHere) do
			timeSince = time() - v.updated;
			if (timeSince > stale) then
				strOut = v.lvlNow .." :: ".. SecondsToTime(timeSince) .." : ".. realm ..":".. n;
				table.insert(charList, {timeSince, strOut});
				count = count + 1;
			end
		end
	end
	if (count > 0) then
		Rested_Print("Toons not seen in ".. Rested_options.maxStale .." days.", false);
		table.sort(charList, function(a, b) return a[1] < b[1] end);
		table.foreach(charList, function(k, v) Rested_Print(" "..v[2], false) end);
	else
		Rested_Print("No tracked toons are stale.", false);
	end
end

function Rested_RemoveFromRested( cName )
	cName = string.upper( cName );
	if (cName == string.upper(Rested.name)) then
		Rested_Print("Cannot remove current toon from rested list");
		return
	end
	local numRemoved = 0;
	for r,v in pairs( Rested_restedState ) do
		for n,v in pairs( Rested_restedState[r] ) do
			if (string.upper( n ) == cName) then
				Rested_Print(COLOR_RED.."Removing "..r..":"..n.." from the rested list"..COLOR_END);
				Rested_restedState[r][n] = nil;
				numRemoved = numRemoved + 1;
			end
		end
		local count = 0;
		for n,v in pairs( Rested_restedState[r] ) do
			count = count + 1;
		end
		if (count == 0) then
			Rested_Print(COLOR_RED.."Pruning realm "..r..COLOR_END);
			Rested_restedState[r] = nil;
		end
	end
	if ( numRemoved == 0 ) then
		Rested_Print("No rested record was removed");
	end
	Rested_PrintToonCount();
end

function Rested_setNagTime( param )
	-- need to check for integer value
	a = strfind( param, "[^0-9]" );
	if a then
		Rested_Debug("Bad Data. Nothing changed.");
	else
		Rested_options.maxCutOff = param * 1;
		Rested_Print("Max level nagtime set to "..Rested_options.maxCutOff.." days.");
	end
end

function Rested_PrintSkills()
	numskills =	GetNumSkillLines();
	for i=1, numskills do
		skillname, isHeader, isExpanded, skillRank, _, _, skillMaxRank = GetSkillLineInfo(i);
		if not isHeader then
			Rested_Print(skillname..": ".. skillRank.."/"..skillMaxRank);
		end
	end
end
