local frame = CreateFrame("FRAME");
frame:RegisterEvent("ADDON_LOADED");
frame:RegisterEvent("PLAYER_LOGOUT");
function frame:OnEvent(event, arg1)
 if event == "ADDON_LOADED" and arg1 == "RepCalc" then
  if RC_RepName then RC_RunSetup = true; RC_ConfShown = false; frame:UnregisterEvent("ADDON_LOADED"); end
 elseif event == "PLAYER_LOGOUT" then
  if RC_Visible == false then RC_RepName = nil; RC_RepNum = nil; frame:UnregisterEvent("PLAYER_LOGOUT"); end
 end
end
frame:SetScript("OnEvent", frame.OnEvent);

SLASH_REPCALC1 = '/repcalc';
function SlashCmdList.REPCALC(msg, editbox)
  if RC_RunSetup == nil then 
    RepConfig_Show(); RC_RunSetup = true 
  elseif RC_ConfShown == false then 
    OpenReps() 
  end
end

SLASH_RCCONFIG1 = '/rcconfig';
function SlashCmdList.RCCONFIG(msg, editbox)
 if RC_RunSetup == nil then 
   RC_RunSetup = true; FillConfig(); RepConfig_Show()
 else 
   RepCalc_Hide()
   HideBars()
   RepConfig_Show()
 end
end

function HideBars()
  for i = 1, 10 do
    local bar = getglobal("statbar" .. i)
    if bar then bar:Hide(); end
  end
end

function RepCalc_Show()
   local rcheader = getglobal("RepCalc_Header")
   local frame1 = getglobal("RepCalc_Frame1")
   rcheader:Show()
   for num = 1, 10 do
	tempframe = getglobal("RepCalc_Frame" .. num)
	tempframe:Show()
   end
end

function RepCalc_Hide()
   RC_Visible = false
   local rcheader = getglobal("RepCalc_Header")
   HideBars()
   rcheader:Hide()
   for num = 1, 10 do
      tempframe = getglobal("RepCalc_Frame" .. num)
      tempframe:Hide()
   end
end

function RepConfig_Show()
   local rc_config = getglobal("RepCalc_Config")
   FillConfig()
   rc_config:Show()
   RC_ConfShown = true
end

function RepConfig_Hide()
   local rc_config = getglobal("RepCalc_Config")
   rc_config:Hide()
   RC_ConfShown = false
end

function MakeBar(num, value)
	local reppercent = RepPercent(RC_RepName[value])
	local bar = getglobal("statbar" .. num)
	if not bar then 
		bar = CreateFrame("StatusBar", "statbar" .. num, fra);
	end
	bar:SetSize(20, 210)
	bar:SetFrameStrata("LOW");
	bar:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
	bar:SetPoint("TOPLEFT", "RepCalc_Frame" .. num)
	bar:SetAllPoints("RepCalc_Frame" .. num)
	bar:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar")
	bar:SetMinMaxValues(0, 1000)
	bar:SetValue(reppercent)
	bar:SetStatusBarColor(0, 1, 0, 0.9)
	bar:Show()
end

function CalcRepReq(faction)
	local topVal
	local earntVal
	local totalReq
	local factionIndex = 1
	repeat
		  local name, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
		    canToggleAtWar, isHeader, isCollapsed, hasRep, isWatched, isChild = GetFactionInfo(factionIndex)
		  if not name then break; -- no more factions
		  elseif name == faction then
		    if bottomValue == 21000 then totalReq = (topValue - earnedValue) -- revered
		    elseif bottomValue == 9000 then totalReq = (topValue - earnedValue)+21000; end -- honored
		    topVal = topValue - bottomValue
		    earntVal = earnedValue - bottomValue
		    break
		  end
		  factionIndex = factionIndex+1
	until factionIndex > 200
	return topVal, earntVal, totalReq
end

function RepBarText(faction)
	local RepText
	local RepColor = 0
	local EarntAmt = 0
	local MaxAmt = 0
	local factionIndex = 1
	for factionIndex = 1, 200 do
	  local name, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
	   canToggleAtWar, isHeader, isCollapsed, hasRep, isWatched, isChild = GetFactionInfo(factionIndex)
	  if not name then break; end
	  if name == faction then
	    MaxAmt = topValue - bottomValue 
	    EarntAmt = earnedValue - bottomValue 
	    RepColor = standingId - 5
            RepText = name .. " (" .. EarntAmt .. "/" .. MaxAmt .. ") "
	    break
	  end
	end
	return RepText, RepColor
end

function FillConfig()

 local tempName = ""
 local highVal = 0
 local prevVal = 0
 local repPercent
 local standID = 0
 if not RC_RepNum then RC_RepNum = {} end
 RC_RepName = {}

 --loop thru for 20 checkboxes
 for i = 1, 20 do

   for idx = 1, 200 do -- loop thru all reps
     local name, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
      canToggleAtWar, isHeader, isCollapsed, hasRep, isWatched, isChild = GetFactionInfo(idx)

     if not name then break end -- last one reached

     if standingId > 5 and standingId < 8 and isHeader == nil and name ~= "Guild" then 
      if earnedValue > highVal then
 	if earnedValue < prevVal or prevVal == 0 then
 	  highVal = earnedValue
 	  tempName = name
 	  repPercent = ceil((earnedValue - bottomValue) / (topValue - bottomValue) * 100)
	  standID = standingId
 	end
      end
     end

   end

  if RC_RepName[i-1] == tempName and i > 1 then break; -- run out of reps
  else
   prevVal = highVal; highVal = 0
   if RC_RepNum[1] == nil then RC_RepNum[i] = 0; end RC_RepName[i] = tempName
   local checkbox = getglobal("RepCalc_Config_CheckButton" .. i)
   if standID == 6 then getglobal(checkbox:GetName().."Text"):SetText("H " .. tempName .. " (" .. repPercent .. "%)")
   else getglobal(checkbox:GetName().."Text"):SetText("R " .. tempName .. " (" .. repPercent .. "%)") end
   if RC_RepNum[i] == 1 then checkbox:SetChecked(true); end
  end

 end
 
 for i = 1, 20 do -- Hide unused checkboxes
  if RC_RepName[i] == nil then
     local checkbox = getglobal("RepCalc_Config_CheckButton" .. i)
     checkbox:Hide()
  end
 end

 local errString = getglobal("TitleError") -- Hide/Show error text if no reps
 if tempName == "" then 
   errString:Show()
 else 
   errString:Hide()
 end

end

function RCConfig_Button()
 for i = 1, 20 do
   local checkbox = getglobal("RepCalc_Config_CheckButton" .. i)
   if checkbox:GetChecked() then RC_RepNum[i] = 1
   else RC_RepNum[i] = 0 end
 end
 RepConfig_Hide()
 HideBars()
 OpenReps()
end

function OpenReps()
   local rcheader = getglobal("RepCalc_Header")
   rcheader:Show()
   RC_Visible = true
   UpdateReps()
end

function UpdateReps()
  local barnum = 1
  local maxbars = 1
  local headerframe = getglobal("RepCalc_Header")
  headerframe:Show();
  for repnum = 1, 20 do
	if RC_RepNum[repnum] == 1 then
		local frtext = getglobal("Frame" .. barnum .. "Text")
		local fr = getglobal("RepCalc_Frame" .. barnum)
		local frback = getglobal("RepCalc_Frame" .. barnum .. "_Background")
		if maxbars <= 10 then
			RepText, RepColor = RepBarText(RC_RepName[repnum]) 
			fr:Show()
			frtext:SetText(RepText)
			frback:SetTexture(0, 0, 0, 0.4)
			MakeBar(barnum, repnum)
			barnum=barnum+1
			maxbars=maxbars+1
		end
	end
  end
end

function ShowRepInfo(barnum)
  local x = 1
  local RC_Bonus = 1
  for i = 1, 20 do
    if RC_RepNum[i] == 1 then
      if x < barnum then x=x+1
      else
        --Calc any rep bonuses
        if UnitRace("player") == "Human" then RC_Bonus = 0.9 end
        if IsInGuild() == 1 then
          if GetGuildLevel() > 11 then RC_Bonus = RC_Bonus - 0.1
          elseif GetGuildLevel() > 3 then RC_Bonus = RC_Bonus - 0.05
          end
        end
	--Calc requirements to exalted
        local RepName = RC_RepName[i]
	local RepTop, RepAmt, RepTotal = CalcRepReq(RepName)
	local itemAmount
	local dailyReps = {"Darkmoon Faire", "Baradin's Wardens", "Hellscream's Reach", "Wildhammer Clan", "Dragonmaw Clan", "Therazane", "Netherwing"}
	if RepName ~= GetGuildInfo("player") and RepName ~= "Wintersaber Trainers" then RepTotal = RepTotal*RC_Bonus end
	for i = 1, 6 do -- reps with dailies
	  if dailyReps[i] == RepName then
	    local dailyAmt = ceil(RepTotal / 250)
	    DEFAULT_CHAT_FRAME:AddMessage("RepCalc: Approx " .. dailyAmt ..  " dailies required to reach exalted with " .. RepName .. ".", 0, 0.7, 1);
	  end
	end
	if RepName == "Cenarion Circle" then 
	  itemAmt = ceil(RepTotal / 500) * 10
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You require " .. itemAmt ..  " \124cffffffff\124Hitem:20404:0:0:0:0:0:0:0:0\124h[Encrypted Twilight Text]\124h\124r to reach exalted with Cenarion Circle.", 0, 0.7, 1);
	elseif RepName == "Kurenai" or RepName == "Mag'har" then
	  itemAmt = ceil(RepTotal / 500) * 10
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You require " .. itemAmt ..  " \124cffffffff\124Hitem:25433:0:0:0:0:0:0:0:0\124h[Obsidian Warbeads]\124h\124r to reach exalted with " .. RepName ..  ".", 0, 0.7, 1);
	elseif RepName == "The Consortium" then
	  itemAmt = ceil(RepTotal / 250) * 10
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You require " .. itemAmt ..  " \124cffffffff\124Hitem:25433:0:0:0:0:0:0:0:0\124h[Obsidian Warbeads]\124h\124r or \124cffffffff\124Hitem:29209:0:0:0:0:0:0:0:0\124h[Zaxxis Insignia]\124h\124r to reach exalted with " .. RepName ..  ".", 0, 0.7, 1);
	--elseif RepName == "Cenarion Expedition" then -- ** Currently unavailable quest
	  --itemAmt = ceil(RepTotal / 75)
	  --DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You require " .. itemAmt ..  " \124cffffffff\124Hitem:24368:0:0:0:0:0:0:0:0\124h[Coilfang Armaments]\124h\124r to reach exalted with " .. RepName ..  ".", 0, 0.7, 1);
	elseif RepName == "Sporereggar" then
	  itemAmt = ceil(RepTotal / 750)* 5
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You require " .. itemAmt ..  " \124cffffffff\124Hitem:24246:0:0:0:0:0:0:0:0\124h[Sanguine Hibiscus]\124h\124r to reach exalted with " .. RepName ..  ".", 0, 0.7, 1);
	elseif RepName == "Wintersabre Trainers" then
	  RepTotal = RepTotal - 10000;
	  itemAmt = ceil(RepTotal / 1500)
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You have " .. itemAmt ..  " days of daily quests until exalted with " .. RepName ..  ".", 0, 0.7, 1);
	elseif RepName == "Ravenholdt" then
	  itemAmt = ceil(RepTotal / 75) * 5
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You require " .. itemAmt ..  " \124cffffffff\124Hitem:16885:0:0:0:0:0:0:0:0\124h[Heavy Junkbox]\124h\124r to reach exalted with " .. RepName ..  ".", 0, 0.7, 1);
	elseif RepName == "Sha'tari Skyguard" then
	  itemAmt = ceil(RepTotal / 150) * 6
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You require " .. itemAmt ..  " \124cffffffff\124Hitem:32388:0:0:0:0:0:0:0:0\124h[Shadow Dust]\124h\124r to reach exalted with " .. RepName ..  ".", 0, 0.7, 1);
	elseif RepName == GetGuildInfo("player") then
	  itemAmt = ceil(RepTotal / 4375)
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You have " .. itemAmt ..  " weeks of capped reputation until exalted with your guild.", 0, 0.7, 1);
	elseif RepName == "The Sons of Hodir" or RepName == "Ogri'la" then
	  local dailyAmt = ceil(RepTotal / 350)
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: Approx " .. dailyAmt ..  " dailies required to reach exalted with " .. RepName .. ".", 0, 0.7, 1);
	elseif RepName == "The Kalu'ak" then
	  local dailyAmt = ceil(RepTotal / 500)
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: Approx " .. dailyAmt ..  " dailies required to reach exalted with " .. RepName .. ".", 0, 0.7, 1);
	elseif RepName == "Timbermaw Hold" then
	  local itemAmt = ceil(RepTotal / 2000)* 5
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You require " .. itemAmt ..  " \124cffffffff\124Hitem:21383:0:0:0:0:0:0:0:0\124h[Winterfall Spirit Beads]\124h\124r to reach exalted with " .. RepName ..  ".", 0, 0.7, 1);
	elseif RepName == "The Scale of the Sands" then
	  local itemAmt = ceil(RepTotal / 7800)
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: Approx " .. itemAmt ..  " full Hyjal Summit clears to reach exalted with " .. RepName ..  ".", 0, 0.7, 1);
	elseif RepName == "The Scryers" then
	  local itemAmt = ceil(RepTotal / 350)
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You require " .. itemAmt ..  " \124cff1eff00\124Hitem:29739:0:0:0:0:0:0:0:0\124h[Arcane Tome]\124h\124r to reach exalted with " .. RepName ..  ".", 0, 0.7, 1);
	elseif RepName == "The Aldor" then
	  local itemAmt = ceil(RepTotal / 350)
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You require " .. itemAmt ..  " \124cff1eff00\124Hitem:29740:0:0:0:0:0:0:0:0\124h[Fel Armament]\124h\124r to reach exalted with " .. RepName ..  ".", 0, 0.7, 1);
	elseif RepName == "Silverwing Sentinels" or RepName == "Warsong Outriders" then
	  local itemAmt = ceil(RepTotal / 35)
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You require " .. itemAmt ..  " Warsong Gulch flag captures to reach exalted with " .. RepName ..  ".", 0, 0.7, 1);
	elseif RepName == "The League of Arathor" or RepName == "The Defilers" then
	  local itemAmt = ceil(RepTotal / 100)
	  DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You require " .. itemAmt ..  " Arathi Basin wins to reach exalted with " .. RepName ..  ".", 0, 0.7, 1);
	end
        break;
      end
    end
  end
end

function RepPercent(faction)
	local RepPercent = 0
	local factionIndex = 1
	repeat
	  local name, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
	    canToggleAtWar, isHeader, isCollapsed, hasRep, isWatched, isChild = GetFactionInfo(factionIndex)
	  if name == faction then RepPercent = ((earnedValue - bottomValue) / (topValue - bottomValue))*1000; break end
	  if not name then break; end
	  factionIndex = factionIndex + 1
	until factionIndex > 200
	RepPercent = floor(RepPercent)
	return RepPercent
end