SLASH_REPCALC1 = '/repcalc';
function SlashCmdList.REPCALC(msg, editbox)
 if RC_RunSetup == nil then RepConfig_Show(); RC_RunSetup = true; else OpenReps(); end
end

SLASH_RCCONFIG1 = '/rcconfig';
function SlashCmdList.RCCONFIG(msg, editbox)
 RC_RunSetup = true
 RepCalc_Hide();
 HideBars();
 RepConfig_Show();
end

function HideBars()
	local bar
	for i = 1, 16 do
		bar = getglobal("statbar" .. i)
		if bar then bar:Hide(); end
	end
end

function MakeBar(num, value)
	local bar
	local fra = CreateFrame("Frame", "BarFrame", UIParent)
	local reppercent = RepPercent(RC_RepName[value])

	fra:SetFrameStrata("BACKGROUND")
	fra:SetPoint("CENTER",0,0)
	fra:SetHeight(20)
	fra:SetWidth(200)
	fra:SetBackdropColor(1,1,1,1)
	fra:Show()
	bar = getglobal("statbar" .. num)
	if not bar then 
		bar = CreateFrame("StatusBar", "statbar" .. num, fra);
	end
	bar:SetBackdropBorderColor(1,1,1,1);
	bar:SetFrameStrata("BACKGROUND");
	bar:SetWidth(200);
	bar:SetHeight(20);
	bar:SetPoint("CENTER", UIParent, "CENTER", 0, 0);
	bar:SetAllPoints("RepCalc_Frame" .. (num - 1));
	bar:SetStatusBarTexture("Interface\\Tooltips\\UI-Tooltip-Background");
	bar:SetMinMaxValues(0, 1000);
	bar:SetValue(reppercent); 
	if CalcRepReq(RC_RepName[value]) < 39000 then bar:SetStatusBarColor(0, 1, 0, 0.8); else bar:SetStatusBarColor(1, 1, 0, 0.8); end
	bar:SetPoint("TOPLEFT", "RepCalc_Frame" .. (num - 1));
	bar:Show();
end

function RepCalc_Show()
   local rcheader = getglobal("RepCalc_Header")
   rcheader:Show();
   local frame1 = getglobal("RepCalc_Frame1")
   local framex = 1
   for num = 1, 10 do
	tempframe = getglobal("RepCalc_Frame" .. num)
	 tempframe:Show();
   end
end

function RepCalc_Hide()
   local rcheader = getglobal("RepCalc_Header")
   HideBars();
   rcheader:Hide();
   local frame1 = getglobal("RepCalc_Frame1")
   local framex = 1
   for num = 1, 16 do
	tempframe = getglobal("RepCalc_Frame" .. num)
	 tempframe:Hide();
   end
end

function RepConfig_Show()
   local rc_config = getglobal("RepCalc_Config")
   local race = UnitRace("player");
   if race == "Human" then RC_Human = 1.1 else RC_Human = 1 end
   englishFaction, localizedFaction = UnitFactionGroup("player")
   if englishFaction == "Alliance" then 
	for num = 7, 12 do
	  local chkbox = getglobal("RepCalc_Config_CheckButton" .. num)
	  chkbox:Hide();
	end
	local fontstring = getglobal("HeaderHorde")
	fontstring:Hide();
   else
	for num = 1, 6 do
	  local chkbox = getglobal("RepCalc_Config_CheckButton" .. num)
	  chkbox:Hide();
	end
	local fontstring = getglobal("HeaderAlliance")
	fontstring:Hide();

   end
   rc_config:Show();
end

function RepConfig_Hide()
   local rc_config = getglobal("RepCalc_Config")
   rc_config:Hide();
end

function SearchInv(search)
 local ItemTotal = 0
  for bag = 0,4 do
    for slot = 1,GetContainerNumSlots(bag) do
      local item = GetContainerItemLink(bag,slot)
      if item and item:find(search) then
        local texture, itemCount, locked, quality, readable = GetContainerItemInfo(bag,slot);
	ItemTotal = ItemTotal + itemCount
      end
    end
  end
  return ItemTotal
end

function RepCC()
	local InvResult = 0;
	local RepReqAmt = 0;
	local CC_Texts = 0;
	RepReqAmt = CalcRepReq("Cenarion Circle");
	if RepReqAmt == 0 then
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You are already exalted with Cenarion Circle.", 0, 0.7, 1)
	elseif RepReqAmt == -1 then
		DEFAULT_CHAT_FRAME:AddMessage("You don't have that rep!", 0, 0.7, 1)
	else
		InvResult = SearchInv("Encrypted Twilight Text");
		CC_Texts = ceil((RepReqAmt / (500*RC_Human))) * 10;
		CC_Texts = CC_Texts - InvResult;
		if InvResult == 0 then
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: " .. CC_Texts .. " Encrypted Twilight Texts required to reach exalted with Cenarion Circle.", 0, 0.7, 1);	
		else
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You have" .. InvResult .. " of " .. CC_Texts .. " Encrypted Twilight Texts (" .. InvResult .. " in bags removed) required to reach exalted with Cenarion Circle.", 0, 0.7, 1);	
		end
	end
end

function RepKurenai()
	local InvResult = 0;
	local RepReqAmt = 0;
	local K_Beads = 0;
	RepReqAmt = CalcRepReq("Kurenai");
	if RepReqAmt == 0 then
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You are already exalted with Kurenai.", 0, 0.7, 1)
	elseif RepReqAmt == -1 then
		DEFAULT_CHAT_FRAME:AddMessage("You don't have that rep!", 0, 0.7, 1)
	else
		InvResult = SearchInv("Obsidian Warbeads");
		K_Beads = ceil((RepReqAmt / (500*RC_Human))) * 10;
		if InvResult == 0 then 
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: " .. K_Beads .. " Obsidian Warbeads required to reach exalted with Kurenai.", 0, 0.7, 1);	
		else
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You have " .. InvResult .. " of " .. K_Beads .. " Obsidian Warbeads required to reach exalted with Kurenai.", 0, 0.7, 1);	
		end
	end
end

function RepMagHar()
	local InvResult = 0;
	local RepReqAmt = 0;
	local M_Beads = 0;
	RepReqAmt = CalcRepReq("Mag'har");
	if RepReqAmt == 0 then
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You are already exalted with Mag'har.", 0, 0.7, 1)
	elseif RepReqAmt == -1 then
		DEFAULT_CHAT_FRAME:AddMessage("You don't have that rep!", 0, 0.7, 1)
	else
		InvResult = SearchInv("Obsidian Warbeads");
		M_Beads = ceil((RepReqAmt / (500*RC_Human))) * 10;
		if InvResult == 0 then 
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: " .. M_Beads .. " Obsidian Warbeads required to reach exalted with Mag'har.", 0, 0.7, 1);	
		else
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You have " .. InvResult .. " of " .. M_Beads .. " Obsidian Warbeads required to reach exalted with Mag'har.", 0, 0.7, 1);	
		end
	end
end

function RepConsortium()
	local InvResult = 0
	local InvResult1 = 0
	local InvResult2 = 0
	local RepReqAmt = 0
	local C_Beads = 0
	RepReqAmt = CalcRepReq("The Consortium");
	if RepReqAmt == 0 then
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You are already exalted with The Consortium.", 0, 0.7, 1)
	elseif RepReqAmt == -1 then
		DEFAULT_CHAT_FRAME:AddMessage("You don't have that rep!", 0, 0.7, 1)
	else
		InvResult1 = SearchInv("Obsidian Warbeads");
		InvResult2 = SearchInv("Zaxxis Insignia");
		InvTotal = InvResult + InvResult2
		C_Beads = ceil((RepReqAmt / (250*RC_Human))) * 10;
		if InvResult == 0 then 
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: " .. C_Beads .. " Obsidian Warbeads or Zaxxis Insignia's required to reach exalted with The Consortium.", 0, 0.7, 1);	
		else 
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You have " .. InvResult .. " of " .. C_Beads .. " Obsidian Warbeads or Zaxxis Insignia's required to reach exalted with The Consortium.", 0, 0.7, 1);	
		end
	end
end

function RepZandalar()
	local InvResult = 0;
	local RepReqAmt = 0;
	local Z_Bijous = 0;
	RepReqAmt = CalcRepReq("Zandalar Tribe");
	if RepReqAmt == 0 then
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You are already exalted with Zandalar Tribe.", 0, 0.7, 1)
	elseif RepReqAmt == -1 then
		DEFAULT_CHAT_FRAME:AddMessage("You don't have that rep!", 0, 0.7, 1)
	else
		Z_Bijous = ceil((RepReqAmt / (125*RC_Human)));
		Z_Coins = ceil((RepReqAmt / (75*RC_Human)));
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: " .. Z_Bijous .. " Bijou's or " .. Z_Coins .. " coin hand-ins required to reach exalted with Zandalar Tribe.", 0, 0.7, 1);	
	end
end

function RepCE()
	local InvResult = 0;
	local RepReqAmt = 0;
	local CE_Arma = 0;
	RepReqAmt = CalcRepReq("Cenarion Expedition");
	if RepReqAmt == 0 then
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You are already exalted with Cenarion Expedition.", 0, 0.7, 1)
	elseif RepReqAmt == -1 then
		DEFAULT_CHAT_FRAME:AddMessage("You don't have that rep!", 0, 0.7, 1)
	else
		InvResult = SearchInv("Coilfang Armaments");
		CE_Arma = ceil((RepReqAmt / (75*RC_Human)));
		if InvResult == 0 then 
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: " .. CE_Arma .. " Coilfang Armaments required to reach exalted with Cenarion Expedition.", 0, 0.7, 1);	
		else 
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You have " .. InvResult .. " of " .. CE_Arma .. " Coilfang Armaments required to reach exalted with Cenarion Expedition.", 0, 0.7, 1);	
		end
	end
end


function RepSpore()
	local InvResult = 0
	local RepReqAmt = 0
	local Hibis = 0
	RepReqAmt = CalcRepReq("Sporeggar");
	if RepReqAmt == 0 then
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You are already exalted with Sporeggar.", 0, 0.7, 1)
	elseif RepReqAmt == -1 then
		DEFAULT_CHAT_FRAME:AddMessage("You don't have that rep!", 0, 0.7, 1)
	else
		InvResult = SearchInv("Sanguine Hibiscus");
		Hibis = ceil((RepReqAmt / (750*RC_Human)));
		if InvResult == 0 then 
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: " .. Hibis .. " Sanguine Hibiscus required to reach exalted with Sporeggar.", 0, 0.7, 1);	
		else 
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You have " .. InvResult .. " of " .. Hibis .. " Sanguine Hibiscus required to reach exalted with Sporeggar.", 0, 0.7, 1);	
		end
	end
end

function RepWinter()
	local InvResult = 0;
	local RepReqAmt = 0;
	local WintQuest = 0;
	RepReqAmt = CalcRepReq("Wintersaber Trainers");
	if RepReqAmt == 0 then
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You are already exalted with Wintersaber Trainers.", 0, 0.7, 1)
	elseif RepReqAmt == -1 then
		DEFAULT_CHAT_FRAME:AddMessage("You don't have that rep!", 0, 0.7, 1)
	else
		WintQuest = ceil((RepReqAmt / (250*RC_Human)));
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: " .. WintQuest .. " 'Winterfall Intrusion' quest hand-ins required to reach exalted with Wintersaber Trainers.", 0, 0.7, 1);	
	end
end

function RepRaven()
	local InvResult = 0
	local RepReqAmt = 0
	local JunkBox = 0
	RepReqAmt = CalcRepReq("Ravenholdt");
	if RepReqAmt == 0 then
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You are already exalted with Ravenholdt.", 0, 0.7, 1)
	elseif RepReqAmt == -1 then
		DEFAULT_CHAT_FRAME:AddMessage("You don't have that rep!", 0, 0.7, 1)
	else
		InvResult = SearchInv("Heavy Junkbox");
		JunkBox = ceil((RepReqAmt / (75*RC_Human))) * 5;
		if InvResult == 0 then 
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: " .. JunkBox .. " Heavy Junkboxes required to reach exalted with Ravenholdt.", 0, 0.7, 1);	
		else 
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You have " .. InvResult .. " of " .. JunkBox .. " Heavy Junkboxes required to reach exalted with Ravenholdt.", 0, 0.7, 1);	
		end
	end
end

function RepShatari()
	local InvResult = 0
	local RepReqAmt = 0
	local ShadDust = 0
	RepReqAmt = CalcRepReq("Sha'tari Skyguard");
	if RepReqAmt == 0 then
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You are already exalted with Sha'tari Skyguard.", 0, 0.7, 1)
	elseif RepReqAmt == -1 then
		DEFAULT_CHAT_FRAME:AddMessage("You don't have that rep!", 0, 0.7, 1)
	else
		InvResult = SearchInv("Shadow Dust");
		ShadDust = ceil((RepReqAmt / (150*RC_Human))) * 6;
		if InvResult == 0 then 
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: " .. ShadDust .. " Shadow Dust required to reach exalted with Sha'tari Skyguard.", 0, 0.7, 1);	
		else 
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You have " .. InvResult .. " of " .. ShadDust .. " Shadow Dust required to reach exalted with Sha'tari Skyguard.", 0, 0.7, 1);	
		end
	end
end

function RepDMF()
	local InvResult = 0
	local RepReqAmt = 0
	local DFDecks = 0
	RepReqAmt = CalcRepReq("Darkmoon Faire");
	if RepReqAmt == 0 then
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You are already exalted with Darkmoon Faire.", 0, 0.7, 1)
	elseif RepReqAmt == -1 then
		DEFAULT_CHAT_FRAME:AddMessage("You don't have that rep!", 0, 0.7, 1)
	else
		DFDecks = ceil((RepReqAmt / (350*RC_Human)));
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: " .. DFDecks .. " Epic Decks required to reach exalted with Darkmoon Faire.", 0, 0.7, 1);	
	end
end

function RepShend()
	local InvResult = 0
	local RepReqAmt = 0
	local Librams = 0
	RepReqAmt = CalcRepReq("Shen'dralar");
	if RepReqAmt == 0 then
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You are already exalted with Shen'dralar.", 0, 0.7, 1)
	elseif RepReqAmt == -1 then
		DEFAULT_CHAT_FRAME:AddMessage("You don't have that rep!", 0, 0.7, 1)
	else
		Librams = ceil((RepReqAmt / (500*RC_Human)));
		InvResult = SearchInv("Libram of Rapidity") + SearchInv("Libram of Focus") + SearchInv("Libram of Protection");
		if InvResult == 0 then
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: " .. Librams .. " Librams required to reach exalted with Shen'dralar.", 0, 0.7, 1);
		else
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You have " .. InvResult .. " of " .. Librams .. " Librams required to reach exalted with Shen'dralar.", 0, 0.7, 1);
		end
	end
end

function RepCities(repnum)
	local RepReqAmt = 0
	local RuneStacks = 0
	local InvStacks = 0
	InvStacks = SearchInv("Runecloth");
	RepReqAmt = CalcRepReq(RC_RepName[repnum]);
	if RepReqAmt == 0 then
		DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You are already exalted with " .. RC_RepName[repnum] .. ".", 0, 0.7, 1)
	else
		RuneStacks = ceil(RepReqAmt / (75*RC_Human));
		if InvStacks > 0 then
			InvStacks = floor(InvStacks / 20)
			RuneStacks = RuneStacks - InvStacks
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: You have " .. InvStacks .. " of " .. RuneStacks .. " stacks of Runecloth required to reach exalted with " .. RC_RepName[repnum] .. ".", 0, 0.7, 1);	
		else
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: " .. RuneStacks .. " stacks of Runecloth required to reach exalted with " .. RC_RepName[repnum] .. ".", 0, 0.7, 1);	
		end
	end
end

function CalcRepReq(faction)
	local factionIndex = 1
	local lastFactionName
	local RepRemain = -1
	repeat
	  local name, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
	    canToggleAtWar, isHeader, isCollapsed, hasRep, isWatched, isChild = GetFactionInfo(factionIndex)
	  if name == lastFactionName then break end
	  lastFactionName = name
	  if name == faction then
	   if earnedValue < 42000 then 
		RepRemain = 42000 - earnedValue;
	   else
	        RepRemain = 0;
	   end
	  end
	  factionIndex = factionIndex + 1
	until factionIndex > 200
	return RepRemain
end

function RepBarText(faction)
	local RepText
	local RepColor = 0
	local EarntAmt = 0
	local MaxAmt = 0
	local Standing
	local factionIndex = 1
	local lastFactionName
	repeat
	  local name, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
	    canToggleAtWar, isHeader, isCollapsed, hasRep, isWatched, isChild = GetFactionInfo(factionIndex)
	  if name == lastFactionName then break end
	  lastFactionName = name
	  if name == faction then
	   if standingId == 4 then Standing = "Neutral"; MaxAmt = 3000; EarntAmt = earnedValue; RepColor = 0;
	   elseif standingId == 5 then Standing = "Friendly"; MaxAmt = 6000; EarntAmt = earnedValue - 3000; RepColor = 1;
	   elseif standingId == 6 then Standing = "Honored"; MaxAmt = 12000; EarntAmt = earnedValue - 9000; RepColor = 2;
	   elseif standingId == 7 then Standing = "Revered"; MaxAmt = 21000; EarntAmt = earnedValue - 21000; RepColor = 3;
	   elseif standingId == 8 then Standing = "Exalted"; MaxAmt = 1000; EarntAmt = earnedValue - 42000; RepColor = 4;
	   end
	   RepText = name .. " (" .. EarntAmt .. " / " .. MaxAmt .. ") "
	  end
	  factionIndex = factionIndex + 1
	until factionIndex > 200
	return RepText, RepColor
end

function RCConfig_Button()
   RC_RepNum = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
   RC_RepName = {"Darnassus", "Exodar", "Gnomeregan Exiles", "Ironforge", "Stormwind", "Kurenai", "Darkspear Trolls", "Orgrimmar", "Silvermoon City", "Thunder Bluff", "Undercity", "Mag'har", "Cenarion Circle", "Cenarion Expedition", "The Consortium", "Zandalar Tribe", "Sporeggar", "Wintersaber Trainers", "Ravenholdt", "Sha'tari Skyguard", "Darkmoon Faire", "Shen'dralar"}
   
   for num = 1, 22 do
	local chkbox = getglobal("RepCalc_Config_CheckButton" .. num)
	if (chkbox:GetChecked()) then RC_RepNum[num] = 1 else RC_RepNum[num] = 0 end
   end
   RepConfig_Hide();
   HideBars();
   OpenReps();
end

function OpenReps()
   local rcheader = getglobal("RepCalc_Header")
   rcheader:Show();
   UpdateReps();
end

function UpdateReps(repnum)
 local barnum = 1
 local headerframe = getglobal("RepCalc_Header")
 headerframe:Show();
 for repnum = 1,22 do
	if RC_RepNum[repnum] == 1 then
		local temptext = getglobal("Frame" .. barnum .. "Text")
		local tempframe = getglobal("RepCalc_Frame" .. barnum)
		local tempframeback = getglobal("RepCalc_Frame" .. barnum .. "_Background")
		local checkbox = getglobal("RepCalc_Config_CheckButton" .. repnum)

		if CalcRepReq(RC_RepName[repnum]) == -1 then 
			DEFAULT_CHAT_FRAME:AddMessage("RepCalc: " .. RC_RepName[repnum] .. " doesn't exist, removed.", 0, 0.7, 1);	
			checkbox:SetChecked(false);
			RC_RepNum[repnum] = 0
		else 
			local reppercent = 0
			RepText, RepColor = RepBarText(RC_RepName[repnum]) 
			barnum = barnum + 1
			tempframe:Show();
			temptext:SetText(RepText);
			if RepColor == 0 then tempframeback:SetTexture(0.5, 0.5, 0, 0.2);
			elseif RepColor == 1 then tempframeback:SetTexture(0, 1, 0, 0.2);
			elseif RepColor == 2 then tempframeback:SetTexture(0, 1, 0, 0.2);
			elseif RepColor == 3 then tempframeback:SetTexture(0, 1, 0, 0.2);
			elseif RepColor == 4 then tempframeback:SetTexture(0, 1, 0, 0.2);
			end
			MakeBar(barnum, repnum);
		end
	end
 end
end

function ShowRepInfo(barnum)
	local tempnum = 1
	local repnum = 1
	while repnum < 23 do
		if RC_RepNum[repnum] == 1 then
			if tempnum < barnum then tempnum = tempnum + 1
			else
				if repnum <= 5 then RepCities(repnum);
				elseif repnum == 6 then RepKurenai();
				elseif repnum >= 7 and repnum <= 11 then RepCities(repnum);
				elseif repnum == 12 then RepMaghar();
				elseif repnum == 13 then RepCC();
				elseif repnum == 14 then RepCE();
				elseif repnum == 15 then RepConsortium();
				elseif repnum == 16 then RepZandalar();
				elseif repnum == 17 then RepSpore();
				elseif repnum == 18 then RepWinter();
				elseif repnum == 19 then RepRaven();
				elseif repnum == 20 then RepShatari();
				elseif repnum == 21 then RepDMF();
				elseif repnum == 22 then RepShend();
				end
				repnum = 23
			end

		end
		repnum = repnum + 1
	end
end

function RepPercent(faction)
	local RepPercent = 0
	local EarntAmt = 0
	local MaxAmt = 0
	local Standing
	local factionIndex = 1
	local lastFactionName
	repeat
	  local name, description, standingId, bottomValue, topValue, earnedValue, atWarWith,
	    canToggleAtWar, isHeader, isCollapsed, hasRep, isWatched, isChild = GetFactionInfo(factionIndex)
	  if name == lastFactionName then break end
	  lastFactionName = name
	  if name == faction then
	   if standingId == 4 then RepPercent = (earnedValue/3000)*1000
	   elseif standingId == 5 then RepPercent = ((earnedValue-3000)/6000)*1000
	   elseif standingId == 6 then RepPercent = ((earnedValue-9000)/12000)*1000
	   elseif standingId == 7 then RepPercent = ((earnedValue-21000)/21000)*1000
	   elseif standingId == 8 then RepPercent = ((earnedValue-42000)/2000)*1000
	   end
	  end
	  factionIndex = factionIndex + 1
	until factionIndex > 200
	RepPercent = floor(RepPercent)
	return RepPercent
end