SLASH_RACHF1 = '/rachf';
function SlashCmdList.RACHF(msg, editbox)
	local frame = getglobal("RaidAch_Frame")
	if frame == nil then RaidAch_Frame_Create(); ShowAch(1); RAF_RID = 1; else frame:Show() end
end

function RaidAch_Frame_Create()

	local frame = CreateFrame("Frame", "RaidAch_Frame", UIParent)
	frame:SetFrameStrata("MEDIUM")
	frame:SetMovable(true)
	frame:EnableMouse(true)
	frame:RegisterForDrag("LeftButton")
	frame:SetScript("OnDragStart", frame.StartMoving)
	frame:SetScript("OnDragStop", frame.StopMovingOrSizing)
	frame:SetPoint("CENTER"); 
	frame:SetWidth(520); frame:SetHeight(588);
	local tex = frame:CreateTexture("ARTWORK");
	tex:SetAllPoints();
	tex:SetTexture(0, 0, 0); tex:SetAlpha(0.6);
	frame:Show();

	local scrollframe = CreateFrame("ScrollFrame", "RaidAch_ScrollFrame", frame) 
	scrollframe:SetPoint("TOPLEFT", 10, -55) 
	scrollframe:SetPoint("BOTTOMRIGHT", -5, 10) 
	frame.scrollframe = scrollframe

	local scrollbar = CreateFrame("Slider", "RaidAch_Slider", scrollframe, "UIPanelScrollBarTemplate") 
	scrollbar:SetPoint("TOPLEFT", frame, "TOPRIGHT", 0, -16) 
	scrollbar:SetPoint("BOTTOMLEFT", frame, "BOTTOMRIGHT", 0, 16) 
	scrollbar:SetMinMaxValues(1, 100) 
	scrollbar:SetValueStep(50) 
	scrollbar.scrollStep = 50
	scrollbar:SetValue(0) 
	scrollbar:SetWidth(16) 
	scrollbar:SetScript("OnValueChanged", 
		function (self, value) self:GetParent():SetVerticalScroll(value) end) 
	
	local scrollbg = scrollbar:CreateTexture(nil, "BACKGROUND") 
	scrollbg:SetAllPoints(scrollbar) 
	scrollbg:SetTexture(0, 0, 0, 0.6) 
	frame.scrollbar = scrollbar 

	scrollframe:EnableMouseWheel(true)
	scrollframe:SetScript("OnMouseWheel",
		function(self, delta) 
			local x = scrollbar:GetValue(); local y = scrollbar:GetValueStep()*3
			if #RList > 7 then -- Only work if scrollbar is up
				if delta == 1 then scrollbar:SetValue(x-y)
				else scrollbar:SetValue(x+y) end 
			end
	end)

	local content = CreateFrame("Frame", "RaidAch_Content", scrollframe) 
	content:SetSize(128, 128) 
	scrollframe.content = content 
	scrollframe:SetScrollChild(content)

	-- Border
	local backdrop = {
	  bgFile = "Interface\\Tooltips\\UI-Toolip-Background",  
	  edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
	  tile = false, tileSize = 8, edgeSize = 8,
	  insets = { left = 2, right = 2, top = 2, bottom = 2 }
	}
	frame:SetBackdrop(backdrop)
	
	-- Header Text
	local ttl = frame:CreateFontString("$parent_HeaderText","OVERLAY","GameFontNormal")
	ttl:SetPoint("TOPLEFT",frame,"TOPLEFT",8,-5);
	ttl:SetText("Raid Achievement Filter");
	ttl:Show();

	-- Close Button
	local btn = CreateFrame("BUTTON", nil, frame, "UIPanelCloseButton")
	btn:SetPoint("TOPRIGHT", frame, "TOPRIGHT", 5, 5);
	btn:SetAlpha(1);
	btn:Show();
	btn:Enable();

	-- Hide Completed button
	local btn2 = CreateFrame("CheckButton", "$parent_Option", frame, "ChatConfigCheckButtonTemplate")
	btn2:SetPoint("TOPRIGHT", -105, -25);
	_G[btn2:GetName() .. "Text"]:SetText("Hide Completed")
	btn2:RegisterForClicks("AnyUp");
	btn2:SetScript("OnClick", function (self, button, down) 
	  if RAF_RID ~= nil then ShowAch(RAF_RID); end
	end)

	-- Raids list dropdown
	local dropDown = CreateFrame("Button", "RaidAch_Dropdown", frame, "UIDropDownMenuTemplate")
	UIDropDownMenu_Initialize(dropDown)
	UIDropDownMenu_SetText(dropDown, "Filter by Raid Instance")
	dropDown:SetPoint("TOPLEFT", frame, "TOPLEFT", -10, -20);
	UIDropDownMenu_SetWidth(dropDown, 200)	dropDown:SetAlpha(1);
	dropDown:SetScript("OnClick", function() 
		ToggleDropDownMenu(1, nil, dropDown, dropDown, 0, 0)
	end)

	local info = {}
	dropDown.initialize = function(self, level)
	    if not level then return end
		wipe(info)
	      if level == 1 then
		-- Create the title of the menu
		info.isTitle = 1
		info.text = "Filter by Raid Instance"
		info.notCheckable = 1
		UIDropDownMenu_AddButton(info, level)

		info.disabled     = nil
		info.isTitle      = nil
		info.notCheckable = nil
		info.checked = false
		dd_Array = {"Malygos (10/25 Player)","Sartharion (10 Player)","Sartharion (25 Player)","Naxx (10 Player)","Naxx (25 Player)","Ulduar (10 Player)","Ulduar (25 Player)","Onyxia's Lair (10/25 Player)",
			"Trial of the Crusader (10 Player)","Trial of the Crusader (25 Player)","Icecrown Citadel (10 Player)","Icecrown Citadel (25 Player)","Halion (10/25 Player)",
			"Blackwing Descent","The Bastion of Twilight","Throne of the Four Winds","Firelands","Dragon Soul"}
		for i = 1, #dd_Array do
		  info.text = dd_Array[i]
		  info.func = function(frame) UIDropDownMenu_SetText(dropDown, dd_Array[i]); ShowAch(i); RAF_RID = i; end
		  UIDropDownMenu_AddButton(info, level)
		end
	     end
	end
end

function ach_Add(fr_name, ach_ID, indent_num)

	local IDNumber, Name, Points, Completed, Month, Day, Year, Description, Flags, Image, RewardText, isGuildAch = GetAchievementInfo(ach_ID)
	local frame = getglobal("RaidAch_Content")
	
	local fra = getglobal(fr_name);
	if fra == nil then fra = CreateFrame("Frame", fr_name, frame); fra.texture = fra:CreateTexture(); end
	fra:SetSize(500,70)
	fra:SetPoint("TOPLEFT", frame, "TOPLEFT", 0, indent_num);
	fra.texture:SetAllPoints(fra)
	if Completed == true then 
		fra.texture:SetTexture("Interface\\AchievementFrame\\UI-Achievement-AchievementBackground", "BACKGROUND")
		fra.texture:SetTexCoord(0, 1, 0, 0.5);
		fra:SetScript("OnMouseDown", function(self, button) if button == "LeftButton" then ChatEdit_InsertLink(GetAchievementLink(ach_ID)); end; end) -- clear the AchTracked stuff
	elseif Completed == false then
		fra.texture:SetTexture("Interface\\AchievementFrame\\UI-Achievement-Parchment-Horizontal-Desaturated", "BACKGROUND")
		fra.texture:SetTexCoord(0, 1, 0, 0.5);
		fra:SetScript("OnMouseDown", function(self, button) 
		  if button == "LeftButton" then ChatEdit_InsertLink(GetAchievementLink(ach_ID)); 
		  elseif button == "RightButton" then AddTrackedAchievement(ach_ID); end; 
		end)
	end
	fra:SetScript("OnDragStart", frame.StartMoving)
	fra:SetScript("OnDragStop", frame.StopMovingOrSizing)
	fra:Show()

	local fraicon = getglobal(fr_name .. "icon")
	if fraicon == nil then 
		fraicon = CreateFrame("Frame",fr_name .. "icon",fra) 
		fraicon.texture = fraicon:CreateTexture()
	end
	fraicon:SetSize(45,45)
	fraicon:SetPoint("TOPLEFT",fr_name,"TOPLEFT",2,-2)
	fraicon.texture:SetTexture(Image, "ARTWORK")
	fraicon.texture:SetAllPoints(fraicon)
	fraicon.texture:SetTexCoord(0,1,0,1)
	if Completed == true then fraicon.texture:SetVertexColor(1,1,1,1) else fraicon.texture:SetVertexColor(.55, .55, .55, 1) end
	fraicon:Show()

	local frashield = getglobal(fr_name .. "shield")
	if frashield == nil then 
		frashield = CreateFrame("Frame",fr_name .. "shield",fra) 
		frashield.texture = frashield:CreateTexture()
	end
	frashield.texture:SetTexture("Interface\\AchievementFrame\\UI-Achievement-Shields", "ARTWORK")
	frashield:SetSize(65,65)
	frashield:SetPoint("TOPRIGHT",fr_name,"TOPRIGHT",-1,-2)
	frashield.texture:SetAllPoints(frashield)
	if Completed == true then frashield.texture:SetTexCoord(0, 0.5, 0, 0.5) else frashield.texture:SetTexCoord(0.5, 1, 0, 0.5) end
	frashield:Show()

	local pts = getglobal(fr_name .. "shield_Points")
	if pts == nil then pts = frashield:CreateFontString(fr_name .. "shield_Points","OVERLAY","GameFontNormalLarge") end
	if Completed == true then pts:SetFontObject("GameFontNormalLarge") else pts:SetFontObject("GameFontDisableLarge") end
	pts:SetPoint("CENTER",frashield,"CENTER",0,3)
	pts:SetText(Points)
	pts:Show()

	local achnm = getglobal(fr_name .. "AchName")
	if achnm == nil then achnm = fra:CreateFontString(fr_name .. "AchName","OVERLAY","GameTooltipHeaderText") end
	if Completed == true then achnm:SetFontObject("GameFontWhite") else achnm:SetFontObject("GameFontDisable") end
	achnm:SetPoint("TOPLEFT",fra,"TOPLEFT",54,-6)
	achnm:SetText(Name)
	achnm:Show()

	local achdsc = getglobal(fr_name .. "AchDesc")
	if achdsc == nil then achdsc = fra:CreateFontString(fr_name .. "AchDesc","OVERLAY","GameFontBlackSmall") end
	if Completed == true then achdsc:SetFontObject("AchievementDescriptionFont") else achdsc:SetFontObject("AchievementDescriptionFont") end
	achdsc:SetSize(375,80)
	achdsc:SetJustifyH("LEFT"); achdsc:SetJustifyV("TOP"); 
	achdsc:CanWordWrap(1); achdsc:SetMaxLines(3);
	achdsc:SetPoint("TOPLEFT",fra,"TOPLEFT",54,-22)
	achdsc:SetText(Description)
	achdsc:Show()

end

function ShowAch(Raid)

	if Raid == 1 then RList = {1869,622,1874, 1870,623,1875} end -- Malygos
	if Raid == 2 then RList = {1876,2047,624,2051,2049,2050} end --Sarth10
	if Raid == 3 then RList = {625,2048,1877,2054,2052,2053} end --Sarth25
	if Raid == 4 then RList = {2176,1858,2184,574,1856,1997,572,2178,2182,2180,562,564,578,576,2146,2147,568,566,1996} end --Naxx10
	if Raid == 5 then RList = {2177,1859,2185,575,1857,2140,573,2179,2183,2181,563,565,579,577,2147,569,567,2139} end --Naxx25
	if Raid == 6 then RList = {2919,3159,2945,2947,2961,2980,3006,2985,2953,2971,3008,3097,3180,2982,2967,3012,3058,2927,2939,2941,2940,3182,2963,3181,2973,2955,3015,2923,3009,3177,3178,3179,3176,2979,2937,2931,2934,2933,3076,3138,2915,3036,3158,3056,2913,2914,2959,2989,2996,2925,2911,2977,2969,2930,3003,2909,2888,2892,2890,2894,2886,3014,2907,3157,3141,2905,2975,2951} end --Ulduar10
	if Raid == 7 then RList = {2921,3164,2946,2948,2962,2981,3007,2984,2954,2972,3010,3098,3189,2983,2968,3013,3059,2928,2942,2944,2943,3184,2965,3188,2974,2956,3016,2924,3011,3185,3186,3187,3183,3118,2938,2932,2936,2935,3077,2995,2917,3037,3163,3057,2918,2916,2960,3237,2997,2926,2912,2978,2970,2929,3002,2910,2889,2893,2891,2895,2887,3017,2908,3161,3162,2906,2976,2952} end --Ulduar25
	if Raid == 8 then RList = {4396,4397,4404,4407,4402,4405,4403,4406} end --Onyxia10
	if Raid == 9 then RList = {3797,3996,3800,3799,3798,3936,3918,3917} end --ToC10
	if Raid == 10 then RList = {3813,3997,3816,3815,3937,3812,3916} end --Toc25
	if Raid == 11 then RList = {4580,4583,4601,4534,4538,4532,4577,4535,4636,4628,4630,4631,4629,4536,4537,4578,4581,4539,4579,4531,4529,4527,4530,4582,4528} end --ICC10
	if Raid == 12 then RList = {4620,4621,4610,4614,4615,4611,4632,4634,4635,4633,4612,4613,4616,4622,4618,4619,4604,4606,4607,4597,4584,4617,4605} end --ICC25
	if Raid == 13 then RList = {4815,4816,4817,4818} end --Halion
	if Raid == 14 then RList = {5306,5309,5310,5308,4849,5307,5094,5115,5107,5108,5109,5116,4842} end --BWD
	if Raid == 15 then RList = {5300,4852,5311,5312,5313,5118,5117,5119,5120,4850} end --BoT
	if Raid == 16 then RList = {4851,5304,5305,5122,5123} end --Throne
	if Raid == 17 then RList = {5802,5821,5829,5810,5813,5830,5799,5855,5807,5808,5806,5809,5805,5804,5803} end --Firelands
	if Raid == 18 then RList = {6174,6128,6129,6175,6084,6105,6133,6180,6109,6110,6111,6112,6113,6114,6115,6116,6177} end --DragonSoul

	local chkbox = getglobal("RaidAch_Frame_Option")
	local scrollbar = getglobal("RaidAch_Slider")

	for i = 1, 68 do
		local fra = getglobal("ach_Frame" .. i)
		if fra ~= nil then fra:Hide(); end
	end

	local maxid = 1
	local indent = 0
	franum = 1
	for i = 1, #RList do
		local IDNumber, Name, Points, Completed = GetAchievementInfo(RList[i])
		if Completed == true and chkbox:GetChecked() == nil then 
			ach_Add("ach_Frame" .. maxid, RList[i], indent)
			maxid=maxid+1
			indent=indent-75
		elseif Completed == false then 
			ach_Add("ach_Frame" .. maxid, RList[i], indent)
			maxid=maxid+1
			indent=indent-75
		end
	end
	maxid=(maxid*75) -- 75px per achievement box
	if maxid > 600 then maxid = maxid - 595; scrollbar:Show(); scrollbar:Enable(); 
	else maxid = 100; scrollbar:Hide(); scrollbar:Disable(); end -- hide scrollbar if not needed
	scrollbar:SetMinMaxValues(1, maxid) 
	scrollbar:SetValueStep(maxid/100)
	scrollbar:SetValue(0)

end