--[[

	[R]aid [A]chievement [Q]uery
	============================

	Useage: /raq

	Written by: Jonas Fllman <jonas@fallman.org>
		aka Tanoh at Earthen Ring(EU)

--]]


RAQ_DEBUG = false;
local RAQ_NUMBER_BUTTON = 14;
local RAQ_NUMBER_COLUMN = 17;
local RAQ_UPDATE_INTERVAL = 1.0; -- Check timer once every second.
local RAQ_TIMEOUT = 3; -- Timeout in seconds.
local RAQ_CURRENT_PAGE = 1;

local RAQ_TEXTURE = {
	["yes"] = [[Interface\AddOns\RAQ\media\true]],
	["no"] = [[Interface\AddOns\RAQ\media\false]],
};

local RAQ_NUM_SCAN;
local RAQ_SCAN_FAILED = "Scan failed";
local RAQ_queue = {};
local _RAQ_Timer = nil;
local _unitID;

RAQ_CHECK = {};
RAQ_DATA = {};
RAQ_DATA_LIST = {};



function RAQ_SetTimer(timeout,callback)
	_RAQ_Timer = {};
	_RAQ_Timer = {
		["timeout"] = timeout,
		["callback"] = callback,
	};
end

function RAQ_KillTimer()
	_RAQ_Timer = nil;
end

function RAQ_UpdateHeaderTooltip(self)
	if( self.criteriaName ~= nil ) then
		GameTooltip:SetOwner(self, "ANCHOR_TOPLEFT");
		GameTooltip:AddLine(self.criteriaName);
		GameTooltip:AddLine(self.criteriaDesc, 1, 1, 1, 1);
		GameTooltip:SetMinimumWidth(100);
		GameTooltip:Show();
	else
		GameTooltip:Hide();
	end
end

function RAQ_HideHeaderTooltip(self)
	GameTooltip:Hide();
end

function RAQ_UpdateHeader()
	local i,col,last,j,texture,name,temp,desc;

	RAQ_DO_CHECK = UIDropDownMenu_GetSelectedValue(RAQAchievementSelectionDropDown);

	-- Hide everything
	for i=1,RAQ_NUMBER_COLUMN do
		getglobal("RAQFrameDataHeaderColumn"..i):Hide();
		getglobal("RAQFrameDataNeededColumn"..i.."Caption"):SetText("");
		for j=1,RAQ_NUMBER_BUTTON do
			getglobal("RAQFrameDataLine"..j.."Column"..i):Hide();
			getglobal("RAQFrameDataLine"..j.."Status"):SetText("");
		end
	end

	getglobal("RAQFrameDataNeededPlayer"):Show();

	-- Populate header with texture and achievement info
	last = 0;
	offset = (RAQ_CURRENT_PAGE-1) * RAQ_NUMBER_COLUMN;

	for i=1,RAQ_NUMBER_COLUMN do
		j = i + offset;
		if( j <= RAQ_CHECK[RAQ_DO_CHECK].count ) then
			col = getglobal("RAQFrameDataHeaderColumn"..i);
			col.achievementID = RAQ_CHECK[RAQ_DO_CHECK].achievementList[j];

			texture = select(10,GetAchievementInfo(col.achievementID));
			name = select(2,GetAchievementInfo(col.achievementID));
			desc = select(8,GetAchievementInfo(col.achievementID));

			col.criteriaName = name;
			col.criteriaDesc = desc;
			col.link = GetAchievementLink(col.achievementID);
			col.dataID = j;

			col:SetNormalTexture(texture);
			col:Show();
		end
	end

	-- Reanchor the next and prev buttons.
	local temp = getglobal("RAQFramePrevPage");
	temp:ClearAllPoints();
	temp:SetPoint("BOTTOMLEFT", getglobal("RAQFrameDataHeaderColumn1"), "TOPLEFT", 0, 0 );
	temp:Show();
	if( RAQ_CURRENT_PAGE > 1 ) then
		temp:Enable();
	else
		temp:Disable();
	end

	temp = getglobal("RAQFrameNextPage");
	temp:ClearAllPoints();
	temp:SetPoint("BOTTOMRIGHT", getglobal("RAQFrameDataHeaderColumn"..(RAQ_NUMBER_COLUMN)), "TOPRIGHT", 0, 0 );
	temp:Show();
	if( (offset+RAQ_NUMBER_COLUMN) >= RAQ_CHECK[RAQ_DO_CHECK].count ) then
		temp:Disable();
	else
		temp:Enable();
	end
	
	-- Set title text and anchors
	temp = getglobal("RAQFrameDataTitleText");
	temp:ClearAllPoints();
	temp:SetPoint("BOTTOMLEFT", "RAQFrameDataHeaderColumn1", "TOPLEFT", 0, 0 );
	temp:SetPoint("TOPRIGHT", getglobal("RAQFrameDataHeaderColumn"..(RAQ_NUMBER_COLUMN)), "TOPRIGHT", 0, 16 );
	temp:SetText(RAQ_DO_CHECK);
	temp:Show();
end

-- Debug function to fake data
function RAQ_FakeData()
	local i,_unitName,completed,needed;

	for i=1,(25-#RAQ_queue) do
		_unitName = "Fake#"..i;
		table.insert(RAQ_DATA_LIST,_unitName);
		
		if( RAQ_DATA[_unitName] == nil ) then
			RAQ_DATA[_unitName] = {};
		end
		if( math.random(20) == 1 ) then
			RAQ_DATA[_unitName]["_status"] = "TIMEOUT";
		else
			RAQ_DATA[_unitName]["_status"] = "SUCCESS";
			RAQ_DATA[_unitName]["_data"] = {};
			needed = 0;
			for k,v in ipairs(RAQ_CHECK[RAQ_DO_CHECK].achievementList) do
				if( math.random(5) ~= 1 ) then
					completed = true;
				else
					completed = false;
					needed = needed + 1;
				end
				table.insert(RAQ_DATA[_unitName]["_data"],completed);
			end
			RAQ_DATA[_unitName]["_needed"] = needed;
		end
	end
end

function RAQ_StartRaidScan()
	local prefix,count;

	RAQ_UpdateHeader();

	RAQ_queue = {};
	RAQ_DATA_LIST = {};

	if( GetNumRaidMembers() <= 5 and not UnitInRaid("player") ) then
		prefix = "party";
		count = GetNumPartyMembers();
		
		-- Hack in ourselves
		table.insert(RAQ_queue, {
			["unitid"] = "player",
			["name"] = UnitName("player"),
		});
	else
		prefix = "raid";
		count = GetNumRaidMembers();
	end

	for i=1,count do
		table.insert(RAQ_queue, {
			["unitid"] = prefix..i,
			["name"] = UnitName(prefix..i),
		});
	end
	
	if( RAQ_DEBUG == true ) then
		RAQ_FakeData();
	end

	RAQ_NUM_SCAN = #RAQ_queue;
	RAQ_RunQueue();
end

function RAQ_UpdateProgress()
	local header = getglobal("RAQFrameDataHeaderPlayer");
	if( #RAQ_queue > 0 ) then
		header:SetText(string.format("Scaning: %d/%d",(RAQ_NUM_SCAN-#RAQ_queue),RAQ_NUM_SCAN));
	else
		header:SetText("");
	end
end

function RAQ_RunQueue()
	local nextID = next(RAQ_queue);

	RAQ_UpdateProgress();
	if( nextID ~= nil ) then
		if( SetAchievementComparisonUnit(RAQ_queue[nextID].unitid) ) then
			_unitID = RAQ_queue[nextID].unitid;
			_unitName = RAQ_queue[nextID].name;
			RAQ_SetTimer(RAQ_TIMEOUT,
				function()
					ClearAchievementComparisonUnit();
					if( RAQ_DATA[_unitName] == nil ) then
						RAQ_DATA[_unitName] = {};
					end
					RAQ_DATA[_unitName]["_status"] = "TIMEOUT";
					table.insert(RAQ_DATA_LIST,_unitName);
					RAQ_RunQueue();
				end);
		else
			print("[RAQ] Failed to SetAchievementComparisonUnit("..RAQ_queue[nextID]..").");
		end
		table.remove(RAQ_queue,nextID);
	end
	RAQ_UpdateUIList();
end

function RAQ_UpdateUIList()
	local j,texture,xoffset,yoffset,who,needed;

	table.sort(RAQ_DATA_LIST);

	xoffset = (RAQ_CURRENT_PAGE-1) * RAQ_NUMBER_COLUMN;
	FauxScrollFrame_Update(RAQFrameScrollList,#RAQ_DATA_LIST,RAQ_NUMBER_BUTTON,22);
	yoffset = FauxScrollFrame_GetOffset(RAQFrameScrollList);

	for k=1,RAQ_NUMBER_BUTTON do
		if( k+yoffset <= #RAQ_DATA_LIST ) then
			who = RAQ_DATA_LIST[k+yoffset];
			getglobal("RAQFrameDataLine"..k.."Player"):SetText(who);
			if( RAQ_DATA[who]["_status"] == "SUCCESS" ) then
				getglobal("RAQFrameDataLine"..k.."Status"):SetText("");
				for j=1,RAQ_NUMBER_COLUMN do
					j2 = j + xoffset;
					if( j2 <= RAQ_CHECK[RAQ_DO_CHECK].count ) then
						if( RAQ_DATA[who]["_data"][j2] == true ) then
							texture = RAQ_TEXTURE["yes"];
						else
							texture = RAQ_TEXTURE["no"];
						end
						getglobal("RAQFrameDataLine"..k.."Column"..j):SetNormalTexture(texture);
						getglobal("RAQFrameDataLine"..k.."Column"..j):Show();
					else
						getglobal("RAQFrameDataLine"..k.."Column"..j):Hide();
					end
					j = j + 1;
				end
				getglobal("RAQFrameDataLine"..k.."Needed"):SetText(RAQ_DATA[who]["_needed"]);
			else
				local status = getglobal("RAQFrameDataLine"..k.."Status");
				local width;

				if( RAQ_CHECK[RAQ_DO_CHECK].count > RAQ_NUMBER_COLUMN ) then
					width = RAQ_NUMBER_COLUMN * 22;
				else
					width = RAQ_CHECK[RAQ_DO_CHECK].count * 22;
				end
				status:SetWidth(width);
				status:SetText(RAQ_SCAN_FAILED);
				status:Show();
				for j=1,RAQ_NUMBER_COLUMN do
					getglobal("RAQFrameDataLine"..k.."Column"..j):Hide();
				end
				getglobal("RAQFrameDataLine"..k.."Needed"):SetText("");
			end
		else
			getglobal("RAQFrameDataLine"..k.."Player"):SetText("");
			getglobal("RAQFrameDataLine"..k.."Status"):SetText("");
			getglobal("RAQFrameDataLine"..k.."Needed"):SetText("");
			for j=1,RAQ_NUMBER_COLUMN do
				getglobal("RAQFrameDataLine"..k.."Column"..j):Hide();
			end
		end
	end

	-- Update needed column
	local column,needed;
	for j=1,RAQ_NUMBER_COLUMN do
		column = getglobal("RAQFrameDataNeededColumn"..j.."Caption");
		j2 = j + xoffset;
		if( RAQ_DO_CHECK ~= nil and j2 <= RAQ_CHECK[RAQ_DO_CHECK].count ) then
			needed = 0;
			for i,v in ipairs(RAQ_DATA_LIST) do
				if( RAQ_DATA[v]["_status"] == "SUCCESS" ) then
					if( RAQ_DATA[v]["_data"][j2] ~= true ) then
						needed = needed + 1;
					end
				end
			end
			column:SetText(needed);
		else
			column:SetText("");
		end
	end
end

function RAQ_OnLoad()
	this:RegisterEvent("INSPECT_ACHIEVEMENT_READY");

	getglobal("RAQFrameTitleText"):SetText("RAQ version "..GetAddOnMetadata("RAQ", "Version"));

	RAQ_InitAchievements();

	-- Count number of criterieas.
	for k,v in pairs(RAQ_CHECK) do
		local count = 0;
		for k2,v2 in ipairs(v.achievementList) do
			count = count + 1;
		end
		v.count = count;
	end



	-- Headers
	local theFrame = CreateFrame("Button","RAQFrameDataHeader", RAQFrame, "RAQFrameDataLineTemplate");
	theFrame:SetPoint("TOPLEFT", "RAQFrame", "TOPLEFT", 15, -70 );
	-- Create columns
	for j=1,RAQ_NUMBER_COLUMN do
		local tempFrame = CreateFrame("Button","RAQFrameDataHeaderColumn"..j, getglobal("RAQFrameDataHeader"), "RAQFrameDataButtonTemplate");
		getglobal(tempFrame:GetName().."Caption"):SetText("");

		if( j == 1 ) then
			tempFrame:SetPoint("TOPLEFT", "RAQFrameDataHeaderNeeded", "TOPRIGHT", 0, 0 );
		else
			tempFrame:SetPoint("TOPLEFT", "RAQFrameDataHeaderColumn"..(j-1), "TOPRIGHT", 2, 0 );
		end

		-- Add tooltips and click support to header buttons
		tempFrame:SetScript("OnEnter", RAQ_UpdateHeaderTooltip);
		tempFrame:SetScript("OnLeave", RAQ_HideHeaderTooltip);
		tempFrame:SetScript("OnClick", RAQ_HandleButton);
	end
	getglobal("RAQFrameDataHeaderPlayer"):SetText("");
	
	-- "Needed by" line below the header
	local theFrame = CreateFrame("Button","RAQFrameDataNeeded", RAQFrame, "RAQFrameDataLineTemplate");
	theFrame:SetPoint("TOPLEFT", "RAQFrameDataHeader", "BOTTOMLEFT", 0, 0 );
	local tempPlayer = getglobal("RAQFrameDataNeededPlayer");
	
	tempPlayer:SetText("Needed by ");
	tempPlayer:SetJustifyH("RIGHT");
	tempPlayer:Hide();
	tempPlayer:SetWidth(tempPlayer:GetWidth() + getglobal("RAQFrameDataNeededNeeded"):GetWidth());
	getglobal("RAQFrameDataNeededNeeded"):SetWidth(0);
	getglobal("RAQFrameDataNeededNeeded"):Hide();


	-- Create columns
	for j=1,RAQ_NUMBER_COLUMN do
		local tempFrame = CreateFrame("Button","RAQFrameDataNeededColumn"..j, getglobal("RAQFrameDataHeader"), "RAQFrameDataButtonTemplate");
		getglobal(tempFrame:GetName().."Caption"):SetText("");
		getglobal(tempFrame:GetName().."Caption"):SetJustifyH("CENTER");

		if( j == 1 ) then
			tempFrame:SetPoint("TOPLEFT", "RAQFrameDataNeededPlayer", "TOPRIGHT", 0, 0 );
		else
			tempFrame:SetPoint("TOPLEFT", "RAQFrameDataNeededColumn"..(j-1), "TOPRIGHT", 2, 0 );
		end
	end

	-- The actual buttons
	for i=1,RAQ_NUMBER_BUTTON do
		local theFrame = CreateFrame("Button","RAQFrameDataLine"..i, RAQFrame, "RAQFrameDataLineTemplate");

		if( i == 1 ) then
			theFrame:SetPoint("TOPLEFT", "RAQFrameDataNeeded", "BOTTOMLEFT", 0, 0 );
		else
			theFrame:SetPoint("TOPLEFT", "RAQFrameDataLine"..(i-1), "BOTTOMLEFT", 0, 0 );
		end
	
		getglobal("RAQFrameDataLine"..i.."Player"):SetText("");
		-- Create columns
		for j=1,RAQ_NUMBER_COLUMN do
			local tempFrame = CreateFrame("Button","RAQFrameDataLine"..i.."Column"..j, getglobal("RAQFrameDataLine"..i), "RAQFrameDataButtonTemplate");
			getglobal(tempFrame:GetName().."Caption"):SetText("");

			if( j == 1 ) then
				tempFrame:SetPoint("TOPLEFT", "RAQFrameDataLine"..i.."Needed", "TOPRIGHT", 0, 0 );
			else
				tempFrame:SetPoint("TOPLEFT", "RAQFrameDataLine"..i.."Column"..(j-1), "TOPRIGHT", 2, 0 );
			end
		end
	end

	-- Create a FauxScrollFrame and anchor it
	tempFrame = CreateFrame('ScrollFrame', 'RAQFrameScrollList', RAQFrame, 'FauxScrollFrameTemplate');
	tempFrame:SetPoint('TOPLEFT', "RAQFrameDataLine1", 0, 0);
	tempFrame:SetWidth((RAQ_NUMBER_COLUMN * 22) + 95); 
	tempFrame:SetHeight((RAQ_NUMBER_BUTTON-1) * 22);
	tempFrame:SetScript('OnShow', RAQ_UpdateUIList);
	tempFrame:SetScript('OnVerticalScroll', function(self, offset)
		FauxScrollFrame_OnVerticalScroll(self, offset, 22, RAQ_UpdateUIList);
	end)
	tempFrame:Show();

	-- Create drop down selection for achievement.
	RAQ_CreateAchievementSelectionDropDown();

	SLASH_RAQ1 = "/raq";
	SlashCmdList["RAQ"] = function(msg)
		RAQFrame:Show();
	end
	
	SLASH_RAQS1 = "/raqs";
	SlashCmdList["RAQS"] = function(msg)
		RAQ_StartRaidScan();
	end

	this.TimeSinceLastUpdate = 0;
end

function RAQ_UpdateHandler(self, elapsed)
	if( _RAQ_Timer ~= nil ) then
		self.TimeSinceLastUpdate = self.TimeSinceLastUpdate + elapsed;
		if( self.TimeSinceLastUpdate > RAQ_UPDATE_INTERVAL ) then
			self.TimeSinceLastUpdate = 0;
			_RAQ_Timer.timeout = _RAQ_Timer.timeout - 1;
			if( _RAQ_Timer.timeout == 0 ) then
				local callback = _RAQ_Timer.callback;
				RAQ_KillTimer();
				callback();
			end
		end
	end
end

function RAQ_EventHandler(event)
	if( event == "INSPECT_ACHIEVEMENT_READY" ) then
		-- Only trigger if we have a timer active, as this gets called for other stuff. Like "normal" achievement compares.
		if( _RAQ_Timer ~= nil ) then
			local k,v,i,needed,completed,month,day,year,completedOut;

			RAQ_DO_CHECK = UIDropDownMenu_GetSelectedValue(RAQAchievementSelectionDropDown);
			RAQ_KillTimer();

			if( RAQ_DATA[_unitName] == nil ) then
				RAQ_DATA[_unitName] = {};
			end
			RAQ_DATA[_unitName]["_status"] = "SUCCESS";
			RAQ_DATA[_unitName]["_data"] = {};
			i = 1;
			needed = 0;
			for k,v in ipairs(RAQ_CHECK[RAQ_DO_CHECK].achievementList) do
				completed = select(1,GetAchievementComparisonInfo(v));

				-- For some reason this is needed
				if( completed == true ) then
					completedOut = true;
				else
					completedOut = false;
					needed = needed + 1;
				end
				table.insert(RAQ_DATA[_unitName]["_data"],completedOut);
			end
			RAQ_DATA[_unitName]["_needed"] = needed;
			table.insert(RAQ_DATA_LIST,_unitName);
			ClearAchievementComparisonUnit();
			RAQ_RunQueue();
		end
	end
end

function RAQ_GetAnnounceTarget()
	if( GetNumRaidMembers() > 0 ) then
		return "RAID", nil;
	elseif( GetNumPartyMembers() > 0 ) then
		return "PARTY", nil;
	elseif( RAQ_DEBUG == true ) then
		return "CHANNEL", 4;
	else
		return nil, nil;
	end
end

function RAQ_StatusReport(self)
	local out = {};
	local target,targetNum = RAQ_GetAnnounceTarget();

	if( target ~= nil ) then
		out["incomplete"] = {};
		out["unknown"] = {};
		for k,v in ipairs(RAQ_DATA_LIST) do
			if( RAQ_DATA[v] ~= nil ) then
				if( RAQ_DATA[v]["_status"] == "SUCCESS" ) then
					if( RAQ_DATA[v]["_data"][self.dataID] == false ) then
						table.insert(out["incomplete"],v);
					end
				else
					table.insert(out["unknown"],v);
				end
			end
		end

		table.sort(out["incomplete"]);
		table.sort(out["unknown"]);

		local incomplete = table.concat(out["incomplete"],", ");
		local unknown = table.concat(out["unknown"],", ");

		if( incomplete == "" ) then incomplete = "No one"; end

		SendChatMessage("[RAQ] "..self.link..":",target,nil,targetNum);
		SendChatMessage(string.format("Needed by (%d of %d): %s",#out["incomplete"],#RAQ_DATA_LIST-#out["unknown"],incomplete),target,nil,targetNum);
		if( unknown ~= "" ) then
			SendChatMessage(string.format("Not scanned (%d): %s",#out["unknown"],unknown),target,nil,targetNum);
		end
	else
		print("You are not in a raid or a party. Nothing to announce to.");
	end
end

function RAQ_HandleButton(self)
	local buttonID = self:GetID();

	if( buttonID == 1 ) then
		-- Scan button
		RAQ_StartRaidScan();
	elseif( buttonID == 2 ) then
		-- Clear data button
		RAQ_DATA = {};
		RAQ_DATA_LIST = {};
		RAQ_UpdateUIList();
	elseif( buttonID == 3 or buttonID == 4 ) then
		-- Prev / next button
		if( buttonID == 3 ) then
			RAQ_CURRENT_PAGE = RAQ_CURRENT_PAGE - 1;
		else
			RAQ_CURRENT_PAGE = RAQ_CURRENT_PAGE + 1;
		end
		RAQ_UpdateHeader();
		RAQ_UpdateUIList();
	elseif( string.match(self:GetName(),"RAQFrameDataHeaderColumn") ) then
		RAQ_StatusReport(self);
	else
		local buttonIDOut = buttonID;
		if( buttonIDOut == nil ) then
			buttonIDOut = "(nil)";
		end
		print("[RAQ] Unknown button, name is '"..self:GetName().."' id is '"..buttonIDOut.."'");
	end
end

function RAQ_CreateAchievementSelectionDropDown()
	CreateFrame("Frame", "RAQAchievementSelectionDropDown", RAQFrame, "UIDropDownMenuTemplate");

	local temp = getglobal("RAQAchievementSelectionDropDown");

	temp:ClearAllPoints();
	temp:SetPoint("TOPLEFT", RAQFrame, 10, -25);
	temp:Show();

	local scan = getglobal("RAQFrameScanButton");
	scan:ClearAllPoints();
	scan:SetPoint("TOPLEFT", temp, "TOPRIGHT", 0, -2);

	local t = {};
	for k in pairs(RAQ_CHECK) do
		table.insert(t, k);
	end
	table.sort(t);

	local function OnClick(self, arg1)
		RAQ_CURRENT_PAGE = 1;
		UIDropDownMenu_SetSelectedValue(RAQAchievementSelectionDropDown, self.value);
	end

	local function initialize(self, level)
		local info = UIDropDownMenu_CreateInfo();
		for i,k in ipairs(t) do
			info = UIDropDownMenu_CreateInfo();
			info.func = OnClick;
			info.arg1 = k;
			info.text = k;
			info.value = k;
			UIDropDownMenu_AddButton(info, level);
		end
	end

	UIDropDownMenu_Initialize(RAQAchievementSelectionDropDown, initialize);
	UIDropDownMenu_SetWidth(RAQAchievementSelectionDropDown, 250);
	UIDropDownMenu_SetButtonWidth(RAQAchievementSelectionDropDown, 230);
	UIDropDownMenu_SetSelectedValue(RAQAchievementSelectionDropDown, t[1]);
	UIDropDownMenu_JustifyText(RAQAchievementSelectionDropDown, "LEFT");
	
	if( RAQ_DEBUG == true ) then
		UIDropDownMenu_SetSelectedValue(RAQAchievementSelectionDropDown, "Various Ulduar (25 player)");
	end
end

function RAQ_InitAchievements()
	-- FIXME: Add comments to achievement IDs for easier changing if Blizzard change something.
	RAQ_CHECK = { 
		["Glory of the Icecrown Raider (25 player)"] = {
			["achievementList"] = {
				4632,
				4633,
				4634,
				4635,
				4610,
				4611,
				4612,
				4613,
				4614,
				4615,
				4616,
				4617,
				4618,
				4619,
				4620,
				4621,
				4622
			},
		},
		["Glory of the Icecrown Raider (10 player)"] = {
			["achievementList"] = {
				4628,
				4629,
				4630,
				4631,
				4534,
				4535,
				4536,
				4537,
				4538,
				4577,
				4578,
				4582,
				4539,
				4579,
				4580,
				4601
			},
		},

		["Glory of the Ulduar Raider (25 player)"] = {
			["achievementList"] = {
				3057,
				2929,
				2924,
				3059,
				2944,
				2954,
				3007,
				3184,
				3183,
				3187,
				3189,
				3188,
				3163
			},
		},
		["Glory of the Ulduar Raider (10 player)"] = {
			["achievementList"] = {
				3056,
				2930,
				2923,
				3058,
				2941,
				2953,
				3006,
				3182,
				3176,
				3179,
				3180,
				3181,
				3158
			},
		},

		["Various Ulduar (25 player)"] = {
			["achievementList"] = {
				2921,
				3164,
				2946,
				2948,
				2962,
				2981,
				2904,
				2984,
				2972,
				3010,
				3098,
				2983,
				2968,
				3005,
				3013,
				2928,
				2942,
				2943,
				2965,
				2974,
				2956,
				3016,
				3011,
				3185,
				3186,
				3118,
				2938,
				2932,
				2936,
				2935,
				3077,
				2995,
				2917,
				3037,
				2918,
				2916,
				2960,
				3237,
				2997,
				2926,
				2912,
				2978,
				2970,
				3002,
				2910,
				2889,
				2893,
				2891,
				2895,
				2887,
				3017,
				2908,
				3161,
				3162,
				2906,
				2976,
				2952
			},
		},
		["Various Ulduar (10 player)"] = {
			["achievementList"] = {
				2919,
				3159,
				2945,
				2947,
				2903,
				2961,
				2980,
				2985,
				2971,
				3008,
				3097,
				2982,
				2967,
				3004,
				3012,
				3316,
				2927,
				2939,
				2940,
				2963,
				2973,
				2955,
				3015,
				3009,
				3177,
				3178,
				2979,
				2937,
				2931,
				2934,
				2933,
				3076,
				3138,
				2915,
				3036,
				2913,
				2914,
				2959,
				2989,
				2996,
				2925,
				2911,
				2977,
				2969,
				3003,
				2909,
				2888,
				2892,
				2890,
				2894,
				2886,
				3014,
				2907,
				3157,
				3141,
				2905,
				2975,
				2951
			}
		},

		["Call of the Crusade (25 player)"] = {
			["achievementList"] = {
				3819,
				3818,
				3817,
				3916,
				3812,
				3937,
				3814,
				3815,
				3816,
				3997,
				3813
			},
		},
		["Call of the Crusade (10 player)"] = {
			["achievementList"] = {
				4080,
				3810,
				3809,
				3808,
				3917,
				3918,
				3936,
				3798,
				3799,
				3800,
				3996,
				3797
			},
		},

		["Glory of the Hero"] = {
			["achievementList"] = {
				1919,
				2150,
				2036,
				2037,
				1296,
				1297,
				1860,
				1862,
				2038,
				2056,
				2151,
				2039,
				2057,
				1816,
				1865,
				2041,
				2153,
				1864,
				2152,
				2040,
				2058,
				1866,
				2154,
				2155,
				1867,
				1834,
				2042,
				1817,
				1872,
				2043,
				1873,
				2156,
				2157,
				1871,
				1868,
				2044,
				2045,
				2046
			},
		},

		["Lich King (10 player)"] = {
			["achievementList"] = {
				1869,
				2176,
				1858,
				1876,
				2148,
				4016,
				2047,
				4818,
				2184,
				574,
				624,
				1856,
				4403,
				1997,
				4402,
				4396,
				572,
				4404,
				2178,
				2182,
				2180,
				562,
				564,
				578,
				576,
				2146,
				568,
				566,
				1996,
				622,
				4817,
				2051,
				2187,
				2049,
				2050,
				1874
			},
		},
		["Lich King (25 player)"] = {
			["achievementList"] = {
				1870,
				2177,
				1859,
				625,
				2149,
				4017,
				2048,
				4816,
				2185,
				575,
				1877,
				1857,
				4406,
				2140,
				4405,
				4397,
				573,
				4407,
				2179,
				2183,
				2181,
				563,
				565,
				579,
				577,
				2147,
				2186,
				569,
				567,
				2139,
				623,
				4815,
				2054,
				2052,
				2053,
				1875
			},
		},
	};
end
