CreateFrame("frame", "QSAlert")
local qs = QSAlert

local fadeout
local function QSAlert_Alert(link)
	local frame, text
	if not QSAlertFrame then
		frame = CreateFrame("frame", "QSAlertFrame")
		frame:Hide()
		frame:EnableMouse(false)
		frame:SetMovable(false)
		frame:SetPoint("center", UIParent, "center", 0, 100)
		frame:SetHeight(1)
		frame:SetWidth(1)

		text = frame:CreateFontString("QSAlertFrameText", "background", "GameFontHighlightLarge")
		text:SetPoint("center", frame, "center")

		frame:SetScript("OnUpdate", function(self, elapsed)
			fadeout = (fadeout and fadeout + elapsed) or elapsed
			if fadeout >= 5 then
				fadeout = nil
				self:Hide()
			elseif fadeout >= 1 then
				self:SetAlpha((4 - (fadeout - 1)) / 4) -- math is hard
			end
		end)
	end
	frame = frame or QSAlertFrame
	text = text or QSAlertFrameText
	text:SetText(("This item begins a quest!\n%s"):format(link))
	frame:SetAlpha(1)
	frame:Show()
	PlaySoundFile([[Sound\Interface\LevelUp.wav]])
end

local alertedItems = { }
local function QSAlert_OnEvent(self, event, bag)
	for slot = 1, GetContainerNumSlots(bag) do
		local link = GetContainerItemLink(bag, slot)
		if link then
			local itemID = ({strsplit(":", link)})[2]
			if not alertedItems[itemID] then
				local tip
				if not QSTooltip then
					tip = CreateFrame("GameTooltip", "QSTooltip", UIParent, "GameTooltipTemplate")
					tip:SetWidth(1)
					tip:SetHeight(1)
					tip:Hide()
				end
				tip = tip or QSTooltip
				tip:SetOwner(UIParent, "ANCHOR_NONE")
				tip:SetBagItem(bag, slot)
				for i = 1, tip:NumLines() do
					if ((_G["QSTooltipTextLeft"..i]):GetText()):find(ITEM_STARTS_QUEST) then
						QSAlert_Alert(link)
						alertedItems[itemID] = true
						return
					end
				end
				tip:Hide()
			end
		end
	end
end

qs:SetScript("OnEvent", QSAlert_OnEvent)
qs:RegisterEvent("BAG_UPDATE")