PyriteStacks = LibStub("AceAddon-3.0"):NewAddon("PyriteStacks", "AceEvent-3.0")
local addon = PyriteStacks

local vehicle
local debuffStacks
local expirationTime

function addon:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("PyriteStacksDB")
end

function addon:OnEnable()
	self:RegisterEvent("UNIT_ENTERED_VEHICLE")
	self:RegisterEvent("UNIT_EXITED_VEHICLE")
	
	vehicle = nil
end

function addon:OnDisable()
	if self.frame then
		self.frame:Hide()
	end
end

function addon:SetupFrames()
	local BWPyriteStacks = CreateFrame("Frame", "BWPyriteStacksFrame", UIParent)
	BWPyriteStacks:SetWidth(64)
	BWPyriteStacks:SetHeight(64)
	BWPyriteStacks:ClearAllPoints()
	BWPyriteStacks:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
	
	local texture = BWPyriteStacks:CreateTexture(nil, "BACKGROUND")
	texture:SetBlendMode("BLEND")
	texture:SetAllPoints(BWPyriteStacks)
	texture:SetTexture("Interface\\Icons\\Ability_Vehicle_LiquidPyrite _blue")
	BWPyriteStacks.background = texture
	
	BWPyriteStacks:EnableMouse(true)
	BWPyriteStacks:SetMovable(true)
	BWPyriteStacks:SetClampedToScreen(true)
	BWPyriteStacks:RegisterForDrag("LeftButton")
	BWPyriteStacks:SetScript("OnDragStart", function()
		this:StartMoving()
	end)
	BWPyriteStacks:SetScript("OnDragStop", function()
		this:StopMovingOrSizing()
		self:SavePosition()
	end)
	BWPyriteStacks:SetScript("OnUpdate", function(_, e)
		self:Update()
	end)
	
	local text1 = BWPyriteStacks:CreateFontString(nil, "OVERLAY")
	text1:ClearAllPoints()
	text1:SetPoint("TOP", BWPyriteStacks, "BOTTOM", 0, 0)
	text1:SetJustifyH("CENTER")
	text1:SetFont("Fonts\\FRIZQT__.TTF", 12, "OUTLINE")
	BWPyriteStacks.time = text1
	
	local text2 = BWPyriteStacks:CreateFontString(nil, "OVERLAY")
	text2:SetWidth(64)
	text2:SetHeight(64)
	text2:ClearAllPoints()
	text2:SetPoint("TOPLEFT", BWPyriteStacks, "TOPLEFT", 0, 0)
	text2:SetJustifyH("CENTER")
	text2:SetJustifyV("MIDDLE")
	text2:SetFont("Fonts\\FRIZQT__.TTF", 36, "OUTLINE")
	text2:SetText("|cFFFFFFFF0")
	BWPyriteStacks.count = text2
	
	BWPyriteStacks:Hide()
		
	local x = self.db.char.posx
	local y = self.db.char.posy
	if x and y then
		local s = BWPyriteStacks:GetEffectiveScale()
		BWPyriteStacks:ClearAllPoints()
		BWPyriteStacks:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", x / s, y / s)
	end
	
	self.frame = BWPyriteStacks
end

function addon:SavePosition()
	local s = self.frame:GetEffectiveScale()
	self.db.char.posx = self.frame:GetLeft() * s
	self.db.char.posy = self.frame:GetTop() * s
end

do
	local debuffName = GetSpellInfo(62489)
	function addon:Update()
		local power = UnitPower("vehicle")
		if power >= 50 then
			self.frame.background:SetVertexColor(1, 1, 1, 1)
		else
			--ramp up alpha wrt energy from 30 to 50, providing a visual jump (.68 -> 1) at 50
			self.frame.background:SetVertexColor(1, 1, 1, max(0.3, (power-15)*2/100))
		end
		
		local name, _, _, count, _, _, etime = UnitDebuff("target", debuffName, "", "PLAYER")
		if name then
			expirationTime = etime
			debuffStacks = count
		else
			expirationTime = 0
			debuffStacks = 0
		end
		
		local remaining = expirationTime - GetTime()
		if debuffStacks and remaining >= 0 then
			local color = "00FF00"
			if remaining <= 3 then
				color = "FF0000" --red
			elseif remaining <= 6 then
				color = "FFAA00" --dark orange
			elseif remaining <= 7.5 then
				color = "FFD500" --light orange
			elseif remaining <= 10 then
				color = "2BFF00" --almost green
			end
			
			self.frame.time:SetFormattedText("|cFF%s%0.1f s|r", color, remaining)
			self.frame.time:Show()
		else
			self.frame.time:Hide()
		end
		
		self.frame.count:SetText("|cFFFFFFFF"..debuffStacks.."|r")
	end
end

function addon:UNIT_ENTERED_VEHICLE(_, unitId)
	if unitId == "player" then
		guid = tonumber(string.sub(UnitGUID("vehicle"), -12, -7), 16)
		if guid == 33109 then
			vehicle = true
			debuffStacks = 0
			expirationTime = 0
			
			if not self.frame then
				self:SetupFrames()
			end
			self.frame:Show()
		end
	end
end

function addon:UNIT_EXITED_VEHICLE(_, unitId)
	if vehicle and unitId == "player" then
		self.frame:Hide()
		
		vehicle = nil
		debuffStacks = nil
		expirationTime = nil
	end
end
