
local bg_1 = { 
	bgFile = "Interface/Tooltips/UI-Tooltip-Background",
	edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
	tile = true,
	tileSize = 16,
	edgeSize = 16,
	insets = {
		left = 4,
		right = 4,
		top = 4,
		bottom = 4
	}
}

local function _createFrame(name, parent, width, height, anchor, x, y)
	local FRAME = CreateFrame("Frame", name, parent) 
	local TITLE_REGION = FRAME:CreateTitleRegion()
	FRAME:SetSize(width, height) 
	FRAME:SetPoint(anchor, x, y) 
	FRAME:SetBackdrop(bg_1)
	FRAME:SetBackdropColor(0,0,0,1)
	FRAME:EnableMouse(true)
	FRAME:SetMovable(true)
	FRAME:SetToplevel(true)
	TITLE_REGION:SetAllPoints()
	FRAME:Hide()
end

local function _createShadowedLabel(name, parent, text, r,b,g,a, sr,sb,sg,sa, anchor, x, y)
	local SHADOWLABEL = parent:CreateFontString(name, "Overlay", "GameTooltipText")
	SHADOWLABEL:SetText(text)
	SHADOWLABEL:SetPoint(anchor, x, y)
	SHADOWLABEL:SetTextColor(r, b, g, a)
	SHADOWLABEL:SetShadowColor(sr, sb, sg, sa)
	SHADOWLABEL:SetShadowOffset(1, -1)
	SHADOWLABEL:SetFont("Fonts\\FRIZQT__.TTF", 10)
end

local function _createButton(name, parent, width, height, text, anchor, x, y, func)
	local BUTTON = CreateFrame("Button", name, parent, "UIPanelButtonTemplate")
	BUTTON:SetSize(width, height) 
	BUTTON:SetPoint(anchor, x, y) 
	BUTTON:SetText(text)
	BUTTON:SetScript("OnClick", func)
end

local function pORE_GOLD(Value)
	if Value == nil then return 0 end
	local Gold = math.floor(Value / 100)
	return Gold / 100
end


_createFrame("pORE_DataSyncMenu", UIParent, 240, 128, "CENTER", 0, 0)
_createButton("pORE_DataSyncMenu_Close", pORE_DataSyncMenu, 20, 20, "x", "TOPLEFT", 210, 10, function() pORE_DataSyncMenu:Hide() end)
_createShadowedLabel("pORE_DataSyncMenu_Title", pORE_DataSyncMenu, "Data Synchronization", 1, 1, 1, 1, 0, 0.5, 1, 1, "CENTER", 0, 54)
_createButton("pORE_SyncButton_TSM", pORE_DataSyncMenu, 220, 30, "Sync to TSM AuctionDB", "CENTER", 0, 20, function() pORE_TSM_getData() pORE_DataSyncMenu:Hide() end)
_createButton("pORE_SyncButton_Auctioneer", pORE_DataSyncMenu, 220, 30, "Sync to Auctioneer", "CENTER", 0, -10, function() pORE_Auctioneer_getData() pORE_DataSyncMenu:Hide() end)
_createButton("pORE_SyncButton_Auctionator", pORE_DataSyncMenu, 220, 30, "Sync to Auctionator", "CENTER", 0, -40, function() pORE_Auctionator_getData() pORE_DataSyncMenu:Hide() end)

pORE_TSM_getData = function()
	if TSMAPI then print("TSM AuctionDB Loaded!") else print("Failed to locate TSM AuctionDB\nPlease confirm TSM is installed.") return end
	
	_G["pORE_RedGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(TSMAPI:GetItemValue(76131, "DBMinBuyout")) )
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[1].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76696, "DBMinBuyout")))
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[2].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76694, "DBMinBuyout")))
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[3].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76692, "DBMinBuyout")))
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[4].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76695, "DBMinBuyout")))
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[5].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76693, "DBMinBuyout")))
	
	_G["pORE_BlueGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(TSMAPI:GetItemValue(76138, "DBMinBuyout")) )
	_G["pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[1].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76636, "DBMinBuyout")))
	_G["pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[2].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76639, "DBMinBuyout")))
	_G["pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[3].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76638, "DBMinBuyout")))
	_G["pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[4].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76637, "DBMinBuyout")))
	
	_G["pORE_YellowGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(TSMAPI:GetItemValue(76142, "DBMinBuyout")) )
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[1].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76700, "DBMinBuyout")))
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[2].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76701, "DBMinBuyout")))
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[3].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76699, "DBMinBuyout")))
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[4].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76697, "DBMinBuyout")))
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[5].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76698, "DBMinBuyout")))
	
	_G["pORE_PurpleGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(TSMAPI:GetItemValue(76141, "DBMinBuyout")) )
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[1].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76681, "DBMinBuyout")))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[2].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(89680, "DBMinBuyout")))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[3].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76690, "DBMinBuyout")))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[4].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76684, "DBMinBuyout")))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[5].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76680, "DBMinBuyout")))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[6].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76688, "DBMinBuyout")))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[7].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76685, "DBMinBuyout")))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[8].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76686, "DBMinBuyout")))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[9].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76683, "DBMinBuyout")))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[10].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76687, "DBMinBuyout")))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[11].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76691, "DBMinBuyout")))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[12].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(89674, "DBMinBuyout")))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[13].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76689, "DBMinBuyout")))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[14].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76682, "DBMinBuyout")))
	
	_G["pORE_GreenGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(TSMAPI:GetItemValue(76139, "DBMinBuyout")) )
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[1].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76646, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[2].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76655, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[3].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76644, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[4].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76651, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[5].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76654, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[6].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76652, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[7].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76642, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[8].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76640, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[9].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(93705, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[10].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76641, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[11].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76656, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[12].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76649, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[13].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76653, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[14].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76643, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[15].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76650, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[16].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76657, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[17].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76648, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[18].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76647, "DBMinBuyout")))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[19].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76645, "DBMinBuyout")))
	
	_G["pORE_OrangeGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(TSMAPI:GetItemValue(76140, "DBMinBuyout")) )
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[1].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76670, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[2].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76672, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[3].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76665, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[4].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76659, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[5].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76658, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[6].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76666, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[7].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76669, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[8].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76673, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[9].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76661, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[10].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76671, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[11].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76675, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[12].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76662, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[13].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76660, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[14].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76668, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[15].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76663, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[16].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76679, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[17].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76674, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[18].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76678, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[19].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76664, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[20].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76676, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[21].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76667, "DBMinBuyout")))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[22].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76677, "DBMinBuyout")))
	
	_G["pORE_MetaGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(TSMAPI:GetItemValue(76132, "DBMinBuyout")) )
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[1].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76884, "DBMinBuyout")))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[2].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76895, "DBMinBuyout")))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[3].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76885, "DBMinBuyout")))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[4].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76890, "DBMinBuyout")))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[5].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76897, "DBMinBuyout")))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[6].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76879, "DBMinBuyout")))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[7].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76892, "DBMinBuyout")))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[8].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76896, "DBMinBuyout")))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[9].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76887, "DBMinBuyout")))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[10].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76894, "DBMinBuyout")))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[11].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76893, "DBMinBuyout")))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[12].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76891, "DBMinBuyout")))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[13].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76886, "DBMinBuyout")))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[14].."Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(76888, "DBMinBuyout")))
	
	_G["pORE_MiscItem_PriceList_ListFrame_ORE_1Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(72092, "DBMinBuyout")))
	_G["pORE_MiscItem_PriceList_ListFrame_ORE_2Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(72093, "DBMinBuyout")))
	_G["pORE_MiscItem_PriceList_ListFrame_ORE_3Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(72094, "DBMinBuyout")))
	_G["pORE_MiscItem_PriceList_ListFrame_ORE_4Price"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(72103, "DBMinBuyout")))
	_G["pORE_MiscItem_PriceList_ListFrame_ENCHANTING_DUSTPrice"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(74249, "DBMinBuyout")))
	_G["pORE_MiscItem_PriceList_ListFrame_ENCHANTING_ESSENCEPrice"]:SetText(pORE_GOLD(TSMAPI:GetItemValue(74250, "DBMinBuyout")))	
	
	pORE_Save_GemPrices()
end

pORE_Auctioneer_getData = function()
	if AucAdvanced then print("Auctioneer Data Loaded!") else print("Failed to locate Auctioneer Database\nPlease confirm Auctioneer is installed.") return end
	
	_G["pORE_RedGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76131))) )
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[1].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76696))))
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[2].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76694))))
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[3].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76692))))
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[4].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76695))))
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[5].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76693))))
	
	_G["pORE_BlueGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76138))) )
	_G["pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[1].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76636))))
	_G["pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[2].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76639))))
	_G["pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[3].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76638))))
	_G["pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[4].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76637))))
	
	_G["pORE_YellowGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76142))) )
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[1].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76700))))
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[2].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76701))))
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[3].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76699))))
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[4].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76697))))
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[5].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76698))))
	
	_G["pORE_PurpleGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76141))) )
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[1].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76681))))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[2].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(89680))))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[3].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76690))))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[4].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76684))))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[5].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76680))))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[6].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76688))))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[7].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76685))))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[8].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76686))))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[9].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76683))))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[10].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76687))))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[11].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76691))))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[12].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(89674))))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[13].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76689))))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[14].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76682))))
	
	_G["pORE_GreenGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76139))) )
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[1].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76646))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[2].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76655))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[3].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76644))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[4].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76651))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[5].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76654))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[6].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76652))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[7].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76642))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[8].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76640))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[9].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(93705))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[10].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76641))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[11].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76656))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[12].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76649))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[13].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76653))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[14].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76643))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[15].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76650))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[16].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76657))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[17].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76648))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[18].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76647))))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[19].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76645))))
	
	_G["pORE_OrangeGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76140))) )
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[1].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76670))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[2].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76672))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[3].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76665))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[4].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76659))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[5].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76658))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[6].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76666))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[7].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76669))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[8].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76673))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[9].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76661))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[10].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76671))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[11].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76675))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[12].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76662))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[13].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76660))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[14].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76668))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[15].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76663))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[16].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76679))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[17].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76674))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[18].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76678))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[19].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76664))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[20].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76676))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[21].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76667))))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[22].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76677))))
	
	_G["pORE_MetaGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76132))) )
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[1].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76884))))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[2].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76895))))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[3].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76885))))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[4].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76890))))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[5].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76897))))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[6].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76879))))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[7].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76892))))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[8].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76896))))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[9].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76887))))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[10].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76894))))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[11].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76893))))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[12].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76891))))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[13].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76886))))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[14].."Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(76888))))
	
	_G["pORE_MiscItem_PriceList_ListFrame_ORE_1Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(72092))))
	_G["pORE_MiscItem_PriceList_ListFrame_ORE_2Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(72093))))
	_G["pORE_MiscItem_PriceList_ListFrame_ORE_3Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(72094))))
	_G["pORE_MiscItem_PriceList_ListFrame_ORE_4Price"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(72103))))
	_G["pORE_MiscItem_PriceList_ListFrame_ENCHANTING_DUSTPrice"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(74249))))
	_G["pORE_MiscItem_PriceList_ListFrame_ENCHANTING_ESSENCEPrice"]:SetText(pORE_GOLD(select(6, AucAdvanced.Modules.Util.SimpleAuction.Private.GetItems(74250))))
	
	pORE_Save_GemPrices()
end

pORE_Auctionator_getData = function()
	if GetAuctionBuyout then print("Auctionator Data Loaded!") else print("Failed to locate Auctionator Database\nPlease confirm Auctionator is installed.") return end
	
	_G["pORE_RedGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(GetAuctionBuyout(76131)) )
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[1].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76696)))
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[2].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76694)))
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[3].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76692)))
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[4].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76695)))
	_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[5].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76693)))
	
	_G["pORE_BlueGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(GetAuctionBuyout(76138)) )
	_G["pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[1].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76636)))
	_G["pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[2].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76639)))
	_G["pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[3].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76638)))
	_G["pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[4].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76637)))
	
	_G["pORE_YellowGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(GetAuctionBuyout(76142)) )
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[1].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76700)))
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[2].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76701)))
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[3].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76699)))
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[4].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76697)))
	_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[5].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76698)))
	
	_G["pORE_PurpleGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(GetAuctionBuyout(76141)) )
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[1].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76681)))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[2].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(89680)))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[3].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76690)))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[4].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76684)))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[5].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76680)))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[6].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76688)))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[7].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76685)))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[8].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76686)))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[9].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76683)))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[10].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76687)))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[11].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76691)))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[12].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(89674)))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[13].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76689)))
	_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[14].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76682)))
	
	_G["pORE_GreenGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(GetAuctionBuyout(76139)) )
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[1].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76646)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[2].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76655)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[3].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76644)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[4].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76651)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[5].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76654)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[6].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76652)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[7].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76642)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[8].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76640)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[9].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(93705)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[10].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76641)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[11].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76656)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[12].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76649)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[13].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76653)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[14].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76643)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[15].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76650)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[16].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76657)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[17].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76648)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[18].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76647)))
	_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[19].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76645)))
	
	_G["pORE_OrangeGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(GetAuctionBuyout(76140)) )
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[1].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76670)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[2].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76672)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[3].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76665)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[4].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76659)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[5].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76658)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[6].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76666)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[7].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76669)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[8].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76673)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[9].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76661)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[10].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76671)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[11].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76675)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[12].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76662)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[13].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76660)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[14].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76668)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[15].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76663)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[16].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76679)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[17].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76674)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[18].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76678)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[19].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76664)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[20].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76676)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[21].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76667)))
	_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[22].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76677)))
	
	_G["pORE_MetaGem_PriceList_ListFrame_RawPrice"]:SetText( pORE_GOLD(GetAuctionBuyout(76132)) )
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[1].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76884)))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[2].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76895)))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[3].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76885)))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[4].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76890)))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[5].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76897)))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[6].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76879)))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[7].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76892)))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[8].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76896)))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[9].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76887)))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[10].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76894)))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[11].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76893)))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[12].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76891)))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[13].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76886)))
	_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[14].."Price"]:SetText(pORE_GOLD(GetAuctionBuyout(76888)))
	
	_G["pORE_MiscItem_PriceList_ListFrame_ORE_1Price"]:SetText(pORE_GOLD(GetAuctionBuyout(72092)))
	_G["pORE_MiscItem_PriceList_ListFrame_ORE_2Price"]:SetText(pORE_GOLD(GetAuctionBuyout(72093)))
	_G["pORE_MiscItem_PriceList_ListFrame_ORE_3Price"]:SetText(pORE_GOLD(GetAuctionBuyout(72094)))
	_G["pORE_MiscItem_PriceList_ListFrame_ORE_4Price"]:SetText(pORE_GOLD(GetAuctionBuyout(72103)))
	_G["pORE_MiscItem_PriceList_ListFrame_ENCHANTING_DUSTPrice"]:SetText(pORE_GOLD(GetAuctionBuyout(74249)))
	_G["pORE_MiscItem_PriceList_ListFrame_ENCHANTING_ESSENCEPrice"]:SetText(pORE_GOLD(GetAuctionBuyout(74250)))
	
	pORE_Save_GemPrices()
end




















