
local bg_1 = { 
	bgFile = "Interface/Tooltips/UI-Tooltip-Background",
	edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
	tile = true,
	tileSize = 16,
	edgeSize = 16,
	insets = {
		left = 4,
		right = 4,
		top = 4,
		bottom = 4
	}
}

local function _createFrame(name, parent, width, height, anchor, x, y)
	local FRAME = CreateFrame("Frame", name, parent) 
	FRAME:SetSize(width, height) 
	FRAME:SetPoint(anchor, x, y) 
	FRAME:SetBackdrop(bg_1)
	FRAME:SetBackdropColor(0,0,0,1)
end

local function _createMainFrame(name, width, height, anchor, x, y)
	local MAIN_FRAME = CreateFrame("Frame", name, UIParent) 
	local TITLE_REGION = MAIN_FRAME:CreateTitleRegion()
	MAIN_FRAME:SetSize(width, height) 
	MAIN_FRAME:SetPoint(anchor, x, y) 
	MAIN_FRAME:EnableMouse(true)
	MAIN_FRAME:SetMovable(true)
	MAIN_FRAME:SetToplevel(true)
	MAIN_FRAME:SetBackdrop(bg_1)
	MAIN_FRAME:SetBackdropColor(0,0,0,1)
	MAIN_FRAME:SetScript("OnShow", function() PlaySound("igCharacterInfoOpen") end) 
	MAIN_FRAME:SetScript("OnHide", function() PlaySound("igCharacterInfoClose") end)
	tinsert(UISpecialFrames, MAIN_FRAME:GetName())
	MAIN_FRAME:Hide()
	TITLE_REGION:SetAllPoints()
end

local function _createLabel(name, parent, text, r,b,g,a, anchor, x, y)
	local LABEL = parent:CreateFontString(name, "Overlay", "GameTooltipText")
	LABEL:SetText(text)
	LABEL:SetPoint(anchor, x, y)
	LABEL:SetTextColor(r, b, g, a)
	LABEL:SetFont("Fonts\\FRIZQT__.TTF", 10)
end

local function _createShadowedLabel(name, parent, text, r,b,g,a, sr,sb,sg,sa, anchor, x, y)
	local SHADOWLABEL = parent:CreateFontString(name, "Overlay", "GameTooltipText")
	SHADOWLABEL:SetText(text)
	SHADOWLABEL:SetPoint(anchor, x, y)
	SHADOWLABEL:SetTextColor(r, b, g, a)
	SHADOWLABEL:SetShadowColor(sr, sb, sg, sa)
	SHADOWLABEL:SetShadowOffset(1, -1)
	SHADOWLABEL:SetFont("Fonts\\FRIZQT__.TTF", 10)
end

local function _createTextField(name, parent, width, height, anchor, x, y)
	local TEXT = CreateFrame("EditBox", name, parent, "InputBoxTemplate")
	TEXT:SetSize(width, height)
	TEXT:SetPoint(anchor, x, y)
	TEXT:SetAutoFocus(false)
	TEXT:SetText("0")
	TEXT:SetCursorPosition(0)
end

local function _createIMG(name, parent, width, height, img, anchor, x, y)
	local IMG_FRAME = CreateFrame("Frame", name, parent) 
	local TEXTURE = IMG_FRAME:CreateTexture()
	IMG_FRAME:SetSize(width, height) 
	IMG_FRAME:SetPoint(anchor, x, y) 
	TEXTURE:SetAllPoints()
	TEXTURE:SetTexture(img)
end

local function _createCheckBox(name, parent, text, ttip, anchor, x, y, mark)
	CHECKBOX = CreateFrame("CheckButton", name, parent, "ChatConfigCheckButtonTemplate")
	CHECKBOX:SetPoint(anchor, x, y) 
	_G[CHECKBOX:GetName().."Text"]:SetText("  "..text)
	CHECKBOX.tooltip = ttip
	CHECKBOX:SetChecked(mark)
	_G[CHECKBOX:GetName().."Text"]:SetFont("Fonts\\FRIZQT__.TTF", 12)
	CHECKBOX:SetScript("PostClick", function() pORE_SaveOptionStates() end)
end

local function _createButton(name, parent, width, height, text, anchor, x, y, func)
	local BUTTON = CreateFrame("Button", name, parent, "UIPanelButtonTemplate")
	BUTTON:SetSize(width, height) 
	BUTTON:SetPoint(anchor, x, y) 
	BUTTON:SetText(text)
	BUTTON:SetScript("OnClick", func)
end



_createMainFrame("pORE", 500, 618, "CENTER", 0, 0)
_createButton("pORE_CloseButton", pORE, 60, 20, "Close", "TOPLEFT", 430, -12, function() pORE_ToggleAddon() end)
pORE_CloseButton:SetBackdropColor(0, 0, 0, 0.15)
_createButton("pORE_SyncButton", pORE, 60, 20, "Sync", "TOPLEFT", 10, -12, function() pORE_DataSyncMenu:Show() end)
pORE_SyncButton:SetBackdropColor(0, 0, 0, 0.15)

_createFrame("pORE_Title", pORE, 480, 40, "TOPLEFT", 10, -10)
_createIMG("pORE_Title_IMG", pORE_Title, 256, 32, "Interface\\AddOns\\ProspectORE\\images\\ProspectORE", "CENTER", 0, 0)
_createLabel("pORE_Title_Ver", pORE_Title, "v"..pORE_INFO.version, 0.7, 0.7, 0.7, 1, "RIGHT", -14, -10)

_createFrame("pORE_ProspectAmount", pORE, 240, 128, "TOPLEFT", 10, -60)
_createShadowedLabel("pORE_ProspectAmount_Title", pORE_ProspectAmount, "Amount to Prospect", 1, 1, 1, 1, 0, 0.5, 1, 1, "CENTER", 0, 54)
_createLabel("pORE_ProspectAmount_Items", pORE_ProspectAmount, "ITEM", 1, 1, 0, 1, "CENTER", -60, 34)
_createLabel("pORE_ProspectAmount_Stacks", pORE_ProspectAmount, "STACK(s) of 20", 1, 1, 0, 1, "CENTER", 60, 34)
_createLabel("pORE_ProspectAmount_ORE_1", pORE_ProspectAmount, pORE_ITEMS.ORE_1.name, 1, 1, 1, 1, "LEFT", 10, 14)
_createTextField("pORE_ProspectAmount_ORE_1_Stacks", pORE_ProspectAmount, 100, 20, "RIGHT", -10, 14)
_createLabel("pORE_ProspectAmount_ORE_2", pORE_ProspectAmount, pORE_ITEMS.ORE_2.name, 1, 1, 1, 1, "LEFT", 10, -6)
_createTextField("pORE_ProspectAmount_ORE_2_Stacks", pORE_ProspectAmount, 100, 20, "RIGHT", -10, -6)
_createLabel("pORE_ProspectAmount_ORE_3", pORE_ProspectAmount, pORE_ITEMS.ORE_3.name, 1, 1, 1, 1, "LEFT", 10, -26)
_createTextField("pORE_ProspectAmount_ORE_3_Stacks", pORE_ProspectAmount, 100, 20, "RIGHT", -10, -26)
_createLabel("pORE_ProspectAmount_ORE_4", pORE_ProspectAmount, pORE_ITEMS.ORE_4.name, 1, 1, 1, 1, "LEFT", 10, -46)
_createTextField("pORE_ProspectAmount_ORE_4_Stacks", pORE_ProspectAmount, 100, 20, "RIGHT", -10, -46)

_createFrame("pORE_Options", pORE, 240, 128, "TOPLEFT", 250, -60)
_createShadowedLabel("pORE_Options_Title", pORE_Options, "Options", 1, 1, 1, 1, 0, 0.5, 1, 1, "CENTER", 0, 54)
_createCheckBox("pORE_Options_Alchemy", pORE_Options, "Alchemy Access", pORE_TOOLTIPS.alchemy, "LEFT", 10, 34, true)
_createCheckBox("pORE_Options_Transmute", pORE_Options, "Transmute Specialist", pORE_TOOLTIPS.transmute, "LEFT", 30, 14, true)
_createCheckBox("pORE_Options_MetaGemOnly", pORE_Options, "Force Meta Gems", pORE_TOOLTIPS.metagems, "LEFT", 30, -6, true)
_createCheckBox("pORE_Options_Enchanting", pORE_Options, "Disenchant Access", pORE_TOOLTIPS.enchanting, "LEFT", 10, -26, true)
_createCheckBox("pORE_Options_RawGemOnly", pORE_Options, "Raw Gems Only", pORE_TOOLTIPS.rawgems, "LEFT", 10, -46, false)

_createFrame("pORE_Results", pORE, 300, 300, "TOPLEFT", 10, -188)
_createShadowedLabel("pORE_Results_Title", pORE_Results, "Prospect(ed) Results", 1, 1, 1, 1, 0, 0.5, 1, 1, "CENTER", 0, 140)
_createLabel("pORE_Results_rRedGem", pORE_Results, pORE_ITEMS.RARE_RED_GEM.name, 0.2, 0.6, 1, 1, "LEFT", 35, 108)
_createLabel("pORE_Results_rRedGemValue", pORE_Results, "0", 1, 1, 1, 1, "RIGHT", -35, 108)
_createLabel("pORE_Results_rBlueGem", pORE_Results, pORE_ITEMS.RARE_BLUE_GEM.name, 0.2, 0.6, 1, 1, "LEFT", 35, 92)
_createLabel("pORE_Results_rBlueGemValue", pORE_Results, "0", 1, 1, 1, 1, "RIGHT", -35, 92)
_createLabel("pORE_Results_rYellowGem", pORE_Results, pORE_ITEMS.RARE_YELLOW_GEM.name, 0.2, 0.6, 1, 1, "LEFT", 35, 76)
_createLabel("pORE_Results_rYellowGemValue", pORE_Results, "0", 1, 1, 1, 1, "RIGHT", -35, 76)
_createLabel("pORE_Results_rPurpleGem", pORE_Results, pORE_ITEMS.RARE_PURPLE_GEM.name, 0.2, 0.6, 1, 1, "LEFT", 35, 60)
_createLabel("pORE_Results_rPurpleGemValue", pORE_Results, "0", 1, 1, 1, 1, "RIGHT", -35, 60)
_createLabel("pORE_Results_rGreenGem", pORE_Results, pORE_ITEMS.RARE_GREEN_GEM.name, 0.2, 0.6, 1, 1, "LEFT", 35, 44)
_createLabel("pORE_Results_rGreenGemValue", pORE_Results, "0", 1, 1, 1, 1, "RIGHT", -35, 44)
_createLabel("pORE_Results_rOrangeGem", pORE_Results, pORE_ITEMS.RARE_ORANGE_GEM.name, 0.2, 0.6, 1, 1, "LEFT", 35, 28)
_createLabel("pORE_Results_rOrangeGemValue", pORE_Results, "0", 1, 1, 1, 1, "RIGHT", -35, 28)
_createLabel("pORE_Results_rTotal", pORE_Results, "TOTAL:", 1, 1, 1, 1, "LEFT", 60, 12)
_createLabel("pORE_Results_rTotalValue", pORE_Results, "0", 1, 1, 1, 1, "RIGHT", -60, 12)
_createLabel("pORE_Results_uRedGem", pORE_Results, pORE_ITEMS.UNCOMMON_RED_GEM.name, 0, 0.8, 0, 1, "LEFT", 35, -28)
_createLabel("pORE_Results_uRedGemValue", pORE_Results, "0", 1, 1, 1, 1, "RIGHT", -35, -28)
_createLabel("pORE_Results_uBlueGem", pORE_Results, pORE_ITEMS.UNCOMMON_BLUE_GEM.name, 0, 0.8, 0, 1, "LEFT", 35, -44)
_createLabel("pORE_Results_uBlueGemValue", pORE_Results, "0", 1, 1, 1, 1, "RIGHT", -35, -44)
_createLabel("pORE_Results_uYellowGem", pORE_Results, pORE_ITEMS.UNCOMMON_YELLOW_GEM.name, 0, 0.8, 0, 1, "LEFT", 35, -60)
_createLabel("pORE_Results_uYellowGemValue", pORE_Results, "0", 1, 1, 1, 1, "RIGHT", -35, -60)
_createLabel("pORE_Results_uPurpleGem", pORE_Results, pORE_ITEMS.UNCOMMON_PURPLE_GEM.name, 0, 0.8, 0, 1, "LEFT", 35, -76)
_createLabel("pORE_Results_uPurpleGemValue", pORE_Results, "0", 1, 1, 1, 1, "RIGHT", -35, -76)
_createLabel("pORE_Results_uGreenGem", pORE_Results, pORE_ITEMS.UNCOMMON_GREEN_GEM.name, 0, 0.8, 0, 1, "LEFT", 35, -92)
_createLabel("pORE_Results_uGreenGemValue", pORE_Results, "0", 1, 1, 1, 1, "RIGHT", -35, -92)
_createLabel("pORE_Results_uOrangeGem", pORE_Results, pORE_ITEMS.UNCOMMON_ORANGE_GEM.name, 0, 0.8, 0, 1, "LEFT", 35, -108)
_createLabel("pORE_Results_uOrangeGemValue", pORE_Results, "0", 1, 1, 1, 1, "RIGHT", -35, -108)
_createLabel("pORE_Results_uTotal", pORE_Results, "TOTAL:", 1, 1, 1, 1, "LEFT", 60, -124)
_createLabel("pORE_Results_uTotalValue", pORE_Results, "0", 1, 1, 1, 1, "RIGHT", -60, -124)

_createFrame("pORE_ScanAuction", pORE, 300, 300, "TOPLEFT", 10, -188)
_createShadowedLabel("pORE_ScanAuction_Title", pORE_ScanAuction, "Scanning Auction House", 1, 1, 1, 1, 0, 0.5, 1, 1, "CENTER", 0, 140)
_createIMG("pORE_ScanAuction_ProgressBar", pORE_ScanAuction, 280, 20, "Interface\\AddOns\\ProspectORE\\images\\ProgressBar", "TOPLEFT", 10, -32)
_createLabel("pORE_ScanAuction_ProgressBarText", pORE_ScanAuction_ProgressBar, "Overall Progress (0%)", 1, 1, 1, 1, "LEFT", 80, 0)
_createLabel("pORE_ScanAuction_Progress", pORE_ScanAuction, "Currently Scanning:", 1, 1, 1, 1, "TOPLEFT", 10, -70)
_createLabel("pORE_ScanAuction_ItemName", pORE_ScanAuction, " ", 1, 1, 1, 1, "TOPLEFT", 30, -90)
_createLabel("pORE_ScanAuction_StatusReport", pORE_ScanAuction, " ", 1, 1, 1, 1, "TOPLEFT", 10, -110)
_createLabel("pORE_ScanAuction_StatusReportCompleted", pORE_ScanAuction, " ", 1, 1, 1, 1, "TOPRIGHT", -10, -110)
_createCheckBox("pORE_ScanAuction_QuickScan", pORE_ScanAuction, "Enable Fast Scan", pORE_TOOLTIPS.quickscan, "BOTTOMLEFT", 10, 10, true)
pORE_ScanAuction:Hide()

_createFrame("pORE_Recommendation", pORE, 300, 300, "TOPLEFT", 10, -188)
_createShadowedLabel("pORE_Recommendation_Title", pORE_Recommendation, "Recommended Actions", 1, 1, 1, 1, 0, 0.5, 1, 1, "CENTER", 0, 140)
_createLabel("pORE_Recommendation_List", pORE_Recommendation, pORE_DEFAULT.recommended, 1, 1, 1, 1, "TOPLEFT", 10, -30)
pORE_Recommendation:Hide()

_createFrame("pORE_Details", pORE, 300, 300, "TOPLEFT", 10, -188)
_createShadowedLabel("pORE_Details_Title", pORE_Details, "Additional Details", 1, 1, 1, 1, 0, 0.5, 1, 1, "CENTER", 0, 140)
_createLabel("pORE_Details_RedGem_Name", pORE_Details, "|cffff5555"..pORE_ITEMS.RARE_RED_GEM.name.."|cffffffff:", 1, 1, 1, 1, "TOPLEFT", 30, -30)
_createLabel("pORE_Details_RedGem_Profit", pORE_Details, "+0|cffedda74g", 1, 1, 1, 1, "TOPLEFT", 150, -30)
_createLabel("pORE_Details_RedGem_Percent", pORE_Details, "(0%)", 1, 1, 1, 1, "TOPLEFT", 240, -30)
_createLabel("pORE_Details_BlueGem_Name", pORE_Details, "|cff5555ff"..pORE_ITEMS.RARE_BLUE_GEM.name.."|cffffffff:", 1, 1, 1, 1, "TOPLEFT", 30, -44)
_createLabel("pORE_Details_BlueGem_Profit", pORE_Details, "+0|cffedda74g", 1, 1, 1, 1, "TOPLEFT", 150, -44)
_createLabel("pORE_Details_BlueGem_Percent", pORE_Details, "(0%)", 1, 1, 1, 1, "TOPLEFT", 240, -44)
_createLabel("pORE_Details_YellowGem_Name", pORE_Details, "|cffffff55"..pORE_ITEMS.RARE_YELLOW_GEM.name.."|cffffffff:", 1, 1, 1, 1, "TOPLEFT", 30, -58)
_createLabel("pORE_Details_YellowGem_Profit", pORE_Details, "+0|cffedda74g", 1, 1, 1, 1, "TOPLEFT", 150, -58)
_createLabel("pORE_Details_YellowGem_Percent", pORE_Details, "(0%)", 1, 1, 1, 1, "TOPLEFT", 240, -58)
_createLabel("pORE_Details_PurpleGem_Name", pORE_Details, "|cffff55ff"..pORE_ITEMS.RARE_PURPLE_GEM.name.."|cffffffff:", 1, 1, 1, 1, "TOPLEFT", 30, -72)
_createLabel("pORE_Details_PurpleGem_Profit", pORE_Details, "+0|cffedda74g", 1, 1, 1, 1, "TOPLEFT", 150, -72)
_createLabel("pORE_Details_PurpleGem_Percent", pORE_Details, "(0%)", 1, 1, 1, 1, "TOPLEFT", 240, -72)
_createLabel("pORE_Details_GreenGem_Name", pORE_Details, "|cff33ff33"..pORE_ITEMS.RARE_GREEN_GEM.name.."|cffffffff:", 1, 1, 1, 1, "TOPLEFT", 30, -86)
_createLabel("pORE_Details_GreenGem_Profit", pORE_Details, "+0|cffedda74g", 1, 1, 1, 1, "TOPLEFT", 150, -86)
_createLabel("pORE_Details_GreenGem_Percent", pORE_Details, "(0%)", 1, 1, 1, 1, "TOPLEFT", 240, -86)
_createLabel("pORE_Details_OrangeGem_Name", pORE_Details, "|cffff9933"..pORE_ITEMS.RARE_ORANGE_GEM.name.."|cffffffff:", 1, 1, 1, 1, "TOPLEFT", 30, -100)
_createLabel("pORE_Details_OrangeGem_Profit", pORE_Details, "+0|cffedda74g", 1, 1, 1, 1, "TOPLEFT", 150, -100)
_createLabel("pORE_Details_OrangeGem_Percent", pORE_Details, "(0%)", 1, 1, 1, 1, "TOPLEFT", 240, -100)
_createLabel("pORE_Details_MetaGem_Name", pORE_Details, "|cffccffff"..pORE_ITEMS.META_GEM.name.."|cffffffff:", 1, 1, 1, 1, "TOPLEFT", 30, -122)
_createLabel("pORE_Details_MetaGem_Profit", pORE_Details, "+0|cffedda74g", 1, 1, 1, 1, "TOPLEFT", 150, -122)
_createLabel("pORE_Details_MetaGem_Percent", pORE_Details, "(0%)", 1, 1, 1, 1, "TOPLEFT", 240, -122)
_createLabel("pORE_Details_Jewelry_Name", pORE_Details, "|cffccffcc".."Rings & Necklaces|cffffffff:", 1, 1, 1, 1, "TOPLEFT", 30, -144)
_createLabel("pORE_Details_Jewelry_Profit", pORE_Details, "+0|cffedda74g", 1, 1, 1, 1, "TOPLEFT", 150, -144)
_createLabel("pORE_Details_Jewelry_Percent", pORE_Details, "(0%)", 1, 1, 1, 1, "TOPLEFT", 240, -144)
_createLabel("pORE_Details_EnchantDust_Name", pORE_Details, "|cffccffcc"..pORE_ITEMS.ENCHANTING_DUST.name.."|cffffffff:", 1, 1, 1, 1, "TOPLEFT", 30, -166)
_createLabel("pORE_Details_EnchantDust_Profit", pORE_Details, "+0|cffedda74g", 1, 1, 1, 1, "TOPLEFT", 150, -166)
_createLabel("pORE_Details_EnchantDust_Percent", pORE_Details, "(0%)", 1, 1, 1, 1, "TOPLEFT", 240, -166)
_createLabel("pORE_Details_EnchantEssence_Name", pORE_Details, "|cffccffcc"..pORE_ITEMS.ENCHANTING_ESSENCE.name.."|cffffffff:", 1, 1, 1, 1, "TOPLEFT", 30, -180)
_createLabel("pORE_Details_EnchantEssence_Profit", pORE_Details, "+0|cffedda74g", 1, 1, 1, 1, "TOPLEFT", 150, -180)
_createLabel("pORE_Details_EnchantEssence_Percent", pORE_Details, "(0%)", 1, 1, 1, 1, "TOPLEFT", 240, -180)
_createShadowedLabel("pORE_Details_SPACER", pORE_Details, "----------------------------------------------------------------", 1, 1, 1, 1, 0, 0.5, 1, 1, "CENTER", 0, -55)
_createLabel("pORE_Details_EstProspect_Name", pORE_Details, "Estimated Prospecting Time:", 1, 1, 1, 1, "TOPLEFT", 30, -220)
_createLabel("pORE_Details_EstProspect_Time", pORE_Details, "0|cffedda74m", 1, 1, 1, 1, "TOPLEFT", 200, -220)
_createLabel("pORE_Details_EstCrafting_Name", pORE_Details, "Estimated Crafting Time:", 1, 1, 1, 1, "TOPLEFT", 30, -234)
_createLabel("pORE_Details_EstCrafting_Time", pORE_Details, "0|cffedda74m", 1, 1, 1, 1, "TOPLEFT", 200, -234)
_createLabel("pORE_Details_EstDisenchant_Name", pORE_Details, "Estimated Disenchant Time:", 1, 1, 1, 1, "TOPLEFT", 30, -248)
_createLabel("pORE_Details_EstDisenchant_Time", pORE_Details, "0|cffedda74m", 1, 1, 1, 1, "TOPLEFT", 200, -248)
_createLabel("pORE_Details_EstOverall_Name", pORE_Details, "Estimated Overall Process:", 1, 1, 1, 1, "TOPLEFT", 30, -270)
_createLabel("pORE_Details_EstOverall_Time", pORE_Details, "0|cffedda74m", 1, 1, 1, 1, "TOPLEFT", 200, -270)

pORE_Details:Hide()

_createFrame("pORE_ItemPrices", pORE, 180, 420, "TOPLEFT", 310, -188)
_createShadowedLabel("pORE_ItemPrices_Title", pORE_ItemPrices, "Item Price(s)", 1, 1, 1, 1, 0, 0.5, 1, 1, "CENTER", 0, 200)
_createButton("pORE_ItemPrices_RedGemDetails", pORE_ItemPrices, 160, 26, pORE_ITEMS.RARE_RED_GEM.name, "TOP", 0, -27, function() pORE_Button_PriceList(1) pORE_Save_GemPrices() end)
_createButton("pORE_ItemPrices_BlueGemDetails", pORE_ItemPrices, 160, 26, pORE_ITEMS.RARE_BLUE_GEM.name, "TOP", 0, -53, function() pORE_Button_PriceList(2) pORE_Save_GemPrices() end)
_createButton("pORE_ItemPrices_YellowGemDetails", pORE_ItemPrices, 160, 26, pORE_ITEMS.RARE_YELLOW_GEM.name, "TOP", 0, -79, function() pORE_Button_PriceList(3) pORE_Save_GemPrices() end)
_createButton("pORE_ItemPrices_PurpleGemDetails", pORE_ItemPrices, 160, 26, pORE_ITEMS.RARE_PURPLE_GEM.name, "TOP", 0, -105, function() pORE_Button_PriceList(4) pORE_Save_GemPrices() end)
_createButton("pORE_ItemPrices_GreenGemDetails", pORE_ItemPrices, 160, 26, pORE_ITEMS.RARE_GREEN_GEM.name, "TOP", 0, -131, function() pORE_Button_PriceList(5) pORE_Save_GemPrices() end)
_createButton("pORE_ItemPrices_OrangeGemDetails", pORE_ItemPrices, 160, 26, pORE_ITEMS.RARE_ORANGE_GEM.name, "TOP", 0, -157, function() pORE_Button_PriceList(6) pORE_Save_GemPrices() end)
_createButton("pORE_ItemPrices_MetaGemDetails", pORE_ItemPrices, 160, 26, pORE_ITEMS.META_GEM.name, "TOP", 0, -193, function() pORE_Button_PriceList(7) pORE_Save_GemPrices() end)
_createButton("pORE_ItemPrices_MiscItemDetails", pORE_ItemPrices, 160, 26, "Misc Items", "TOP", 0, -229, function() pORE_Button_PriceList(8) pORE_Save_GemPrices() end)
_createButton("pORE_ItemPrices_ScanAuctionHouse", pORE_ItemPrices, 160, 32, "Scan Auction House", "BOTTOM", 0, 118, function() pORE_StartAuctionScan() end)
_createButton("pORE_ItemPrices_Calculate", pORE_ItemPrices, 160, 32, "Calculate", "BOTTOM", 0, 82, function() pORE_CalculateData() pORE_Save_GemPrices() end)
_createButton("pORE_ItemPrices_Recommendations", pORE_ItemPrices, 160, 32, "Recommendations", "BOTTOM", 0, 46, function() pORE_Button_Recommended() end)
_createButton("pORE_ItemPrices_Details", pORE_ItemPrices, 160, 32, "Details", "BOTTOM", 0, 10, function() pORE_Button_Details() end)

_createFrame("pORE_EstProfit", pORE, 300, 120, "TOPLEFT", 10, -488)
_createShadowedLabel("pORE_EstProfit_Title", pORE_EstProfit, "Estimated Revenue", 1, 1, 1, 1, 0, 0.5, 1, 1, "CENTER", 0, 50)
_createLabel("pORE_EstProfit_Cost", pORE_EstProfit, "COST:", 1, 1, 1, 1, "LEFT", 10, 14)
_createLabel("pORE_EstProfit_Revenue", pORE_EstProfit, "REVENUE:", 1, 1, 1, 1, "LEFT", 10, -2)
_createLabel("pORE_EstProfit_Profit", pORE_EstProfit, "PROFIT:", 1, 1, 1, 1, "LEFT", 10, -18)
_createIMG("pORE_EstProfit_ORE_1_IMG", pORE_EstProfit, 16, 16, "Interface\\AddOns\\ProspectORE\\images\\Ore1", "LEFT", 80, 35)
_createLabel("pORE_EstProfit_ORE_1_Cost", pORE_EstProfit, "0", 1, 1, 1, 1, "LEFT", 80, 14)
_createLabel("pORE_EstProfit_ORE_1_Revenue", pORE_EstProfit, "0", 1, 1, 1, 1, "LEFT", 80, -2)
_createLabel("pORE_EstProfit_ORE_1_Profit", pORE_EstProfit, "0", 1, 1, 1, 1, "LEFT", 80, -18)
_createIMG("pORE_EstProfit_ORE_2_IMG", pORE_EstProfit, 16, 16, "Interface\\AddOns\\ProspectORE\\images\\Ore2", "LEFT", 135, 35)
_createLabel("pORE_EstProfit_ORE_2_Cost", pORE_EstProfit, "0", 1, 1, 1, 1, "LEFT", 135, 14)
_createLabel("pORE_EstProfit_ORE_2_Revenue", pORE_EstProfit, "0", 1, 1, 1, 1, "LEFT", 135, -2)
_createLabel("pORE_EstProfit_ORE_2_Profit", pORE_EstProfit, "0", 1, 1, 1, 1, "LEFT", 135, -18)
_createIMG("pORE_EstProfit_ORE_3_IMG", pORE_EstProfit, 16, 16, "Interface\\AddOns\\ProspectORE\\images\\Ore3", "LEFT", 190, 35)
_createLabel("pORE_EstProfit_ORE_3_Cost", pORE_EstProfit, "0", 1, 1, 1, 1, "LEFT", 190, 14)
_createLabel("pORE_EstProfit_ORE_3_Revenue", pORE_EstProfit, "0", 1, 1, 1, 1, "LEFT", 190, -2)
_createLabel("pORE_EstProfit_ORE_3_Profit", pORE_EstProfit, "0", 1, 1, 1, 1, "LEFT", 190, -18)
_createIMG("pORE_EstProfit_ORE_4_IMG", pORE_EstProfit, 16, 16, "Interface\\AddOns\\ProspectORE\\images\\Ore4", "LEFT", 245, 35)
_createLabel("pORE_EstProfit_ORE_4_Cost", pORE_EstProfit, "0", 1, 1, 1, 1, "LEFT", 245, 14)
_createLabel("pORE_EstProfit_ORE_4_Revenue", pORE_EstProfit, "0", 1, 1, 1, 1, "LEFT", 245, -2)
_createLabel("pORE_EstProfit_ORE_4_Profit", pORE_EstProfit, "0", 1, 1, 1, 1, "LEFT", 245, -18)
_createLabel("pORE_EstProfit_GrandTotal", pORE_EstProfit, "GRAND TOTAL:", 1, 1, 1, 1, "LEFT", 10, -40)
_createLabel("pORE_EstProfit_GrandTotalValue", pORE_EstProfit, "0", 1, 1, 1, 1, "LEFT", 110, -40)

function _createRedGemPriceFrame()
	local L_FrameHeight = 107 + ( 20 * table.getn(pORE_ITEMS.RARE_RED_GEM.cut) )
	local M_FrameHeight = 53 + L_FrameHeight
	_createFrame("pORE_RedGem_PriceList", pORE, 320, M_FrameHeight, "TOPLEFT", 500, 0)
	_createFrame("pORE_RedGem_PriceList_TitleFrame", pORE_RedGem_PriceList, 310, 43, "TOPLEFT", 5, -5)
	_createShadowedLabel("pORE_RedGem_PriceList_Title", pORE_RedGem_PriceList_TitleFrame, pORE_ITEMS.RARE_RED_GEM.name.." Details", 1, 1, 1, 1, 0.8, 0, 0, 1, "CENTER", 0, 0)
	_createFrame("pORE_RedGem_PriceList_ListFrame", pORE_RedGem_PriceList, 310, L_FrameHeight, "TOPLEFT", 5, -48)
	_createLabel("pORE_RedGem_PriceList_ListFrame_Item", pORE_RedGem_PriceList_ListFrame, "ITEM", 1, 1, 0, 1, "TOPLEFT", 40, -20)
	_createLabel("pORE_RedGem_PriceList_ListFrame_Gold", pORE_RedGem_PriceList_ListFrame, "GOLD", 1, 1, 0, 1, "TOPRIGHT", -40, -20)
	_createLabel("pORE_RedGem_PriceList_ListFrame_Raw", pORE_RedGem_PriceList_ListFrame, pORE_ITEMS.RARE_RED_GEM.name.." (Raw)", 1, 1, 1, 1, "TOPLEFT", 40, -54)
	_createTextField("pORE_RedGem_PriceList_ListFrame_RawPrice", pORE_RedGem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, -50)
	for i = 1, table.getn(pORE_ITEMS.RARE_RED_GEM.cut) do
		local Y_PoS = -60 + (-20 * i)
		_createLabel("pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[i], pORE_RedGem_PriceList_ListFrame, pORE_ITEMS.RARE_RED_GEM.cut[i].." "..pORE_ITEMS.RARE_RED_GEM.name, 1, 1, 1, 1, "TOPLEFT", 10, Y_PoS)
		_createTextField("pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[i].."Price", pORE_RedGem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, Y_PoS)
		_G["pORE_RedGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_RED_GEM.cut[i]]:SetFont("Fonts\\FRIZQT__.TTF", 12)
	end
	pORE_RedGem_PriceList:Hide()
end
_createRedGemPriceFrame()

function _createBlueGemPriceFrame()
	local L_FrameHeight = 107 + ( 20 * table.getn(pORE_ITEMS.RARE_BLUE_GEM.cut) )
	local M_FrameHeight = 53 + L_FrameHeight
	_createFrame("pORE_BlueGem_PriceList", pORE, 320, M_FrameHeight, "TOPLEFT", 500, 0)
	_createFrame("pORE_BlueGem_PriceList_TitleFrame", pORE_BlueGem_PriceList, 310, 43, "TOPLEFT", 5, -5)
	_createShadowedLabel("pORE_BlueGem_PriceList_Title", pORE_BlueGem_PriceList_TitleFrame, pORE_ITEMS.RARE_BLUE_GEM.name.." Details", 1, 1, 1, 1, 0, 0, 0.8, 1, "CENTER", 0, 0)
	_createFrame("pORE_BlueGem_PriceList_ListFrame", pORE_BlueGem_PriceList, 310, L_FrameHeight, "TOPLEFT", 5, -48)
	_createLabel("pORE_BlueGem_PriceList_ListFrame_Item", pORE_BlueGem_PriceList_ListFrame, "ITEM", 1, 1, 0, 1, "TOPLEFT", 40, -20)
	_createLabel("pORE_BlueGem_PriceList_ListFrame_Gold", pORE_BlueGem_PriceList_ListFrame, "GOLD", 1, 1, 0, 1, "TOPRIGHT", -40, -20)
	_createLabel("pORE_BlueGem_PriceList_ListFrame_Raw", pORE_BlueGem_PriceList_ListFrame, pORE_ITEMS.RARE_BLUE_GEM.name.." (Raw)", 1, 1, 1, 1, "TOPLEFT", 40, -54)
	_createTextField("pORE_BlueGem_PriceList_ListFrame_RawPrice", pORE_BlueGem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, -50)
	for i = 1, table.getn(pORE_ITEMS.RARE_BLUE_GEM.cut) do
		local Y_PoS = -60 + (-20 * i)
		_createLabel("pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[i], pORE_BlueGem_PriceList_ListFrame, pORE_ITEMS.RARE_BLUE_GEM.cut[i].." "..pORE_ITEMS.RARE_BLUE_GEM.name, 1, 1, 1, 1, "TOPLEFT", 10, Y_PoS)
		_createTextField("pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[i].."Price", pORE_BlueGem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, Y_PoS)
		_G["pORE_BlueGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_BLUE_GEM.cut[i]]:SetFont("Fonts\\FRIZQT__.TTF", 12)
	end
	pORE_BlueGem_PriceList:Hide()
end
_createBlueGemPriceFrame()

function _createYellowGemPriceFrame()
	local L_FrameHeight = 107 + ( 20 * table.getn(pORE_ITEMS.RARE_YELLOW_GEM.cut) )
	local M_FrameHeight = 53 + L_FrameHeight
	_createFrame("pORE_YellowGem_PriceList", pORE, 320, M_FrameHeight, "TOPLEFT", 500, 0)
	_createFrame("pORE_YellowGem_PriceList_TitleFrame", pORE_YellowGem_PriceList, 310, 43, "TOPLEFT", 5, -5)
	_createShadowedLabel("pORE_YellowGem_PriceList_Title", pORE_YellowGem_PriceList_TitleFrame, pORE_ITEMS.RARE_YELLOW_GEM.name.." Details", 1, 1, 1, 1, 0.8, 0.8, 0, 1, "CENTER", 0, 0)
	_createFrame("pORE_YellowGem_PriceList_ListFrame", pORE_YellowGem_PriceList, 310, L_FrameHeight, "TOPLEFT", 5, -48)
	_createLabel("pORE_YellowGem_PriceList_ListFrame_Item", pORE_YellowGem_PriceList_ListFrame, "ITEM", 1, 1, 0, 1, "TOPLEFT", 40, -20)
	_createLabel("pORE_YellowGem_PriceList_ListFrame_Gold", pORE_YellowGem_PriceList_ListFrame, "GOLD", 1, 1, 0, 1, "TOPRIGHT", -40, -20)
	_createLabel("pORE_YellowGem_PriceList_ListFrame_Raw", pORE_YellowGem_PriceList_ListFrame, pORE_ITEMS.RARE_YELLOW_GEM.name.." (Raw)", 1, 1, 1, 1, "TOPLEFT", 40, -54)
	_createTextField("pORE_YellowGem_PriceList_ListFrame_RawPrice", pORE_YellowGem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, -50)
	for i = 1, table.getn(pORE_ITEMS.RARE_YELLOW_GEM.cut) do
		local Y_PoS = -60 + (-20 * i)
		_createLabel("pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[i], pORE_YellowGem_PriceList_ListFrame, pORE_ITEMS.RARE_YELLOW_GEM.cut[i].." "..pORE_ITEMS.RARE_YELLOW_GEM.name, 1, 1, 1, 1, "TOPLEFT", 10, Y_PoS)
		_createTextField("pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[i].."Price", pORE_YellowGem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, Y_PoS)
		_G["pORE_YellowGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_YELLOW_GEM.cut[i]]:SetFont("Fonts\\FRIZQT__.TTF", 12)
	end
	pORE_YellowGem_PriceList:Hide()
end
_createYellowGemPriceFrame()

function _createPurpleGemPriceFrame()
	local L_FrameHeight = 107 + ( 20 * table.getn(pORE_ITEMS.RARE_PURPLE_GEM.cut) )
	local M_FrameHeight = 53 + L_FrameHeight
	_createFrame("pORE_PurpleGem_PriceList", pORE, 320, M_FrameHeight, "TOPLEFT", 500, 0)
	_createFrame("pORE_PurpleGem_PriceList_TitleFrame", pORE_PurpleGem_PriceList, 310, 43, "TOPLEFT", 5, -5)
	_createShadowedLabel("pORE_PurpleGem_PriceList_Title", pORE_PurpleGem_PriceList_TitleFrame, pORE_ITEMS.RARE_PURPLE_GEM.name.." Details", 1, 1, 1, 1, 0.8, 0.34, 0.8, 1, "CENTER", 0, 0)
	_createFrame("pORE_PurpleGem_PriceList_ListFrame", pORE_PurpleGem_PriceList, 310, L_FrameHeight, "TOPLEFT", 5, -48)
	_createLabel("pORE_PurpleGem_PriceList_ListFrame_Item", pORE_PurpleGem_PriceList_ListFrame, "ITEM", 1, 1, 0, 1, "TOPLEFT", 40, -20)
	_createLabel("pORE_PurpleGem_PriceList_ListFrame_Gold", pORE_PurpleGem_PriceList_ListFrame, "GOLD", 1, 1, 0, 1, "TOPRIGHT", -40, -20)
	_createLabel("pORE_PurpleGem_PriceList_ListFrame_Raw", pORE_PurpleGem_PriceList_ListFrame, pORE_ITEMS.RARE_PURPLE_GEM.name.." (Raw)", 1, 1, 1, 1, "TOPLEFT", 40, -54)
	_createTextField("pORE_PurpleGem_PriceList_ListFrame_RawPrice", pORE_PurpleGem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, -50)
	for i = 1, table.getn(pORE_ITEMS.RARE_PURPLE_GEM.cut) do
		local Y_PoS = -60 + (-20 * i)
		_createLabel("pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[i], pORE_PurpleGem_PriceList_ListFrame, pORE_ITEMS.RARE_PURPLE_GEM.cut[i].." "..pORE_ITEMS.RARE_PURPLE_GEM.name, 1, 1, 1, 1, "TOPLEFT", 10, Y_PoS)
		_createTextField("pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[i].."Price", pORE_PurpleGem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, Y_PoS)
		_G["pORE_PurpleGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_PURPLE_GEM.cut[i]]:SetFont("Fonts\\FRIZQT__.TTF", 12)
	end
	pORE_PurpleGem_PriceList:Hide()
end
_createPurpleGemPriceFrame()

function _createGreenGemPriceFrame()
	local L_FrameHeight = 107 + ( 20 * table.getn(pORE_ITEMS.RARE_GREEN_GEM.cut) )
	local M_FrameHeight = 53 + L_FrameHeight
	_createFrame("pORE_GreenGem_PriceList", pORE, 320, M_FrameHeight, "TOPLEFT", 500, 0)
	_createFrame("pORE_GreenGem_PriceList_TitleFrame", pORE_GreenGem_PriceList, 310, 43, "TOPLEFT", 5, -5)
	_createShadowedLabel("pORE_GreenGem_PriceList_Title", pORE_GreenGem_PriceList_TitleFrame, pORE_ITEMS.RARE_GREEN_GEM.name.." Details", 1, 1, 1, 1, 0, 0.8, 0, 1, "CENTER", 0, 0)
	_createFrame("pORE_GreenGem_PriceList_ListFrame", pORE_GreenGem_PriceList, 310, L_FrameHeight, "TOPLEFT", 5, -48)
	_createLabel("pORE_GreenGem_PriceList_ListFrame_Item", pORE_GreenGem_PriceList_ListFrame, "ITEM", 1, 1, 0, 1, "TOPLEFT", 40, -20)
	_createLabel("pORE_GreenGem_PriceList_ListFrame_Gold", pORE_GreenGem_PriceList_ListFrame, "GOLD", 1, 1, 0, 1, "TOPRIGHT", -40, -20)
	_createLabel("pORE_GreenGem_PriceList_ListFrame_Raw", pORE_GreenGem_PriceList_ListFrame, pORE_ITEMS.RARE_GREEN_GEM.name.." (Raw)", 1, 1, 1, 1, "TOPLEFT", 40, -54)
	_createTextField("pORE_GreenGem_PriceList_ListFrame_RawPrice", pORE_GreenGem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, -50)
	for i = 1, table.getn(pORE_ITEMS.RARE_GREEN_GEM.cut) do
		local Y_PoS = -60 + (-20 * i)
		_createLabel("pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[i], pORE_GreenGem_PriceList_ListFrame, pORE_ITEMS.RARE_GREEN_GEM.cut[i].." "..pORE_ITEMS.RARE_GREEN_GEM.name, 1, 1, 1, 1, "TOPLEFT", 10, Y_PoS)
		_createTextField("pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[i].."Price", pORE_GreenGem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, Y_PoS)
		_G["pORE_GreenGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_GREEN_GEM.cut[i]]:SetFont("Fonts\\FRIZQT__.TTF", 12)
	end
	pORE_GreenGem_PriceList:Hide()
end
_createGreenGemPriceFrame()

function _createOrangeGemPriceFrame()
	local L_FrameHeight = 107 + ( 20 * table.getn(pORE_ITEMS.RARE_ORANGE_GEM.cut) )
	local M_FrameHeight = 53 + L_FrameHeight
	_createFrame("pORE_OrangeGem_PriceList", pORE, 320, M_FrameHeight, "TOPLEFT", 500, 0)
	_createFrame("pORE_OrangeGem_PriceList_TitleFrame", pORE_OrangeGem_PriceList, 310, 43, "TOPLEFT", 5, -5)
	_createShadowedLabel("pORE_OrangeGem_PriceList_Title", pORE_OrangeGem_PriceList_TitleFrame, pORE_ITEMS.RARE_ORANGE_GEM.name.." Details", 1, 1, 1, 1, 0.8, 0.4, 0, 1, "CENTER", 0, 0)
	_createFrame("pORE_OrangeGem_PriceList_ListFrame", pORE_OrangeGem_PriceList, 310, L_FrameHeight, "TOPLEFT", 5, -48)
	_createLabel("pORE_OrangeGem_PriceList_ListFrame_Item", pORE_OrangeGem_PriceList_ListFrame, "ITEM", 1, 1, 0, 1, "TOPLEFT", 40, -20)
	_createLabel("pORE_OrangeGem_PriceList_ListFrame_Gold", pORE_OrangeGem_PriceList_ListFrame, "GOLD", 1, 1, 0, 1, "TOPRIGHT", -40, -20)
	_createLabel("pORE_OrangeGem_PriceList_ListFrame_Raw", pORE_OrangeGem_PriceList_ListFrame, pORE_ITEMS.RARE_ORANGE_GEM.name.." (Raw)", 1, 1, 1, 1, "TOPLEFT", 40, -54)
	_createTextField("pORE_OrangeGem_PriceList_ListFrame_RawPrice", pORE_OrangeGem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, -50)
	for i = 1, table.getn(pORE_ITEMS.RARE_ORANGE_GEM.cut) do
		local Y_PoS = -60 + (-20 * i)
		_createLabel("pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[i], pORE_OrangeGem_PriceList_ListFrame, pORE_ITEMS.RARE_ORANGE_GEM.cut[i].." "..pORE_ITEMS.RARE_ORANGE_GEM.name, 1, 1, 1, 1, "TOPLEFT", 10, Y_PoS)
		_createTextField("pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[i].."Price", pORE_OrangeGem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, Y_PoS)
		_G["pORE_OrangeGem_PriceList_ListFrame_"..pORE_ITEMS.RARE_ORANGE_GEM.cut[i]]:SetFont("Fonts\\FRIZQT__.TTF", 12)
	end
	pORE_OrangeGem_PriceList:Hide()
end
_createOrangeGemPriceFrame()

function _createMetaGemPriceFrame()
	local L_FrameHeight = 107 + ( 20 * table.getn(pORE_ITEMS.META_GEM.cut) )
	local M_FrameHeight = 53 + L_FrameHeight
	_createFrame("pORE_MetaGem_PriceList", pORE, 320, M_FrameHeight, "TOPLEFT", 500, 0)
	_createFrame("pORE_MetaGem_PriceList_TitleFrame", pORE_MetaGem_PriceList, 310, 43, "TOPLEFT", 5, -5)
	_createShadowedLabel("pORE_MetaGem_PriceList_Title", pORE_MetaGem_PriceList_TitleFrame, pORE_ITEMS.META_GEM.name.." Details", 1, 1, 1, 1, 0.8, 0.8, 0.8, 1, "CENTER", 0, 0)
	_createFrame("pORE_MetaGem_PriceList_ListFrame", pORE_MetaGem_PriceList, 310, L_FrameHeight, "TOPLEFT", 5, -48)
	_createLabel("pORE_MetaGem_PriceList_ListFrame_Item", pORE_MetaGem_PriceList_ListFrame, "ITEM", 1, 1, 0, 1, "TOPLEFT", 40, -20)
	_createLabel("pORE_MetaGem_PriceList_ListFrame_Gold", pORE_MetaGem_PriceList_ListFrame, "GOLD", 1, 1, 0, 1, "TOPRIGHT", -40, -20)
	_createLabel("pORE_MetaGem_PriceList_ListFrame_Raw", pORE_MetaGem_PriceList_ListFrame, pORE_ITEMS.META_GEM.name.." (Raw)", 1, 1, 1, 1, "TOPLEFT", 40, -54)
	_createTextField("pORE_MetaGem_PriceList_ListFrame_RawPrice", pORE_MetaGem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, -50)
	for i = 1, table.getn(pORE_ITEMS.META_GEM.cut) do
		local Y_PoS = -60 + (-20 * i)
		_createLabel("pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[i], pORE_MetaGem_PriceList_ListFrame, pORE_ITEMS.META_GEM.cut[i].." "..pORE_ITEMS.META_GEM.name, 1, 1, 1, 1, "TOPLEFT", 10, Y_PoS)
		_createTextField("pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[i].."Price", pORE_MetaGem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, Y_PoS)
		_G["pORE_MetaGem_PriceList_ListFrame_"..pORE_ITEMS.META_GEM.cut[i]]:SetFont("Fonts\\FRIZQT__.TTF", 12)
	end
	pORE_MetaGem_PriceList:Hide()
end
_createMetaGemPriceFrame()

function _createMiscItemPriceFrame()
	local MiscItemList = {pORE_ITEMS.ORE_1.name, pORE_ITEMS.ORE_2.name, pORE_ITEMS.ORE_3.name, pORE_ITEMS.ORE_4.name, pORE_ITEMS.ENCHANTING_DUST.name, pORE_ITEMS.ENCHANTING_ESSENCE.name}
	local MiscItemName = {"ORE_1", "ORE_2", "ORE_3", "ORE_4", "ENCHANTING_DUST", "ENCHANTING_ESSENCE"}
	local offSet = 20
	local L_FrameHeight = 107 + ( 20 * table.getn(MiscItemList) - offSet )
	local M_FrameHeight = 53 + L_FrameHeight
	_createFrame("pORE_MiscItem_PriceList", pORE, 320, M_FrameHeight, "TOPLEFT", 500, 0)
	_createFrame("pORE_MiscItem_PriceList_TitleFrame", pORE_MiscItem_PriceList, 310, 43, "TOPLEFT", 5, -5)
	_createShadowedLabel("pORE_MiscItem_PriceList_Title", pORE_MiscItem_PriceList_TitleFrame, "Miscellaneous Item Details", 1, 1, 1, 1, 0.7, 0.7, 0.7, 1, "CENTER", 0, 0)
	_createFrame("pORE_MiscItem_PriceList_ListFrame", pORE_MiscItem_PriceList, 310, L_FrameHeight, "TOPLEFT", 5, -48)
	_createLabel("pORE_MiscItem_PriceList_ListFrame_Item", pORE_MiscItem_PriceList_ListFrame, "ITEM", 1, 1, 0, 1, "TOPLEFT", 40, -20)
	_createLabel("pORE_MiscItem_PriceList_ListFrame_Gold", pORE_MiscItem_PriceList_ListFrame, "GOLD", 1, 1, 0, 1, "TOPRIGHT", -40, -20)
	--_createLabel("pORE_MiscItem_PriceList_ListFrame_Raw", pORE_MiscItem_PriceList_ListFrame, pORE_ITEMS.META_GEM.name.." (Raw)", 1, 1, 1, 1, "TOPLEFT", 40, -54)
	--_createTextField("pORE_MiscItem_PriceList_ListFrame_RawPrice", pORE_MiscItem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, -50)
	for i = 1, table.getn(MiscItemList) do
		local Y_PoS = -60 + (-20 * i) + offSet
		_createLabel("pORE_MiscItem_PriceList_ListFrame_"..MiscItemName[i], pORE_MiscItem_PriceList_ListFrame, MiscItemList[i], 1, 1, 1, 1, "TOPLEFT", 10, Y_PoS)
		_createTextField("pORE_MiscItem_PriceList_ListFrame_"..MiscItemName[i].."Price", pORE_MiscItem_PriceList_ListFrame, 80, 20, "TOPRIGHT", -10, Y_PoS)
		_G["pORE_MiscItem_PriceList_ListFrame_"..MiscItemName[i]]:SetFont("Fonts\\FRIZQT__.TTF", 12)
	end
	pORE_MiscItem_PriceList:Hide()
end
_createMiscItemPriceFrame()











