
local function getGemAverage(Item, Database)
	local ListSize = table.getn(Database)
	local OrderList = {}
	local TopSeller = {}
	local Average = 0
	
	for i = 1, ListSize do
		table.insert(OrderList, tonumber(_G["pORE_"..Item.."_PriceList_ListFrame_"..Database[i].."Price"]:GetText()))
	end
	table.sort(OrderList, function(a, b) return a > b end)
	
	for i = 1, 3 do
		if OrderList[i] == nil then OrderList = 0 end
	end
	
	Average = (OrderList[1] + OrderList[2] + OrderList[3]) / 3
	
	for i = 1, 3 do
		for j = 1, ListSize do
			if OrderList[i] == tonumber(_G["pORE_"..Item.."_PriceList_ListFrame_"..Database[j].."Price"]:GetText()) then
				table.insert(TopSeller, Database[j])
			end
		end
	end
	
	-- v1.01 Fix (Prevent Duplicate Recommendations) --
	local function getCount(Table, item)			 --
		local count = 0								 --
		for i, j in pairs(Table) do					 --
			if item == j then count = count + 1 end  --
		end											 --
		return count
	end

	local function filterTable(Table)
		local filteredTable = {}
		for i, j in ipairs(Table) do
			if(getCount(filteredTable, j) == 0) then
				filteredTable[#filteredTable + 1] = j--
			end										 --
		end											 --
		return filteredTable						 --
	end												 --
	-- --------------------------------------------- --
	
	return Average, filterTable(TopSeller)
end

pORE_CalculateData = function()
	local ENCHANTING = pORE_Options_Enchanting:GetChecked()
	local ALCHEMY = pORE_Options_Alchemy:GetChecked()
	local TRANSMUTE = pORE_Options_Transmute:GetChecked()
	local FORCE_META = pORE_Options_MetaGemOnly:GetChecked()
	local FORCE_UNCUT = pORE_Options_RawGemOnly:GetChecked()
	
	local ENCHANTING_GOOD = false
	
	local RED_GEM_UNCUT_AV = tonumber(_G["pORE_RedGem_PriceList_ListFrame_RawPrice"]:GetText())
	local BLUE_GEM_UNCUT_AV = tonumber(_G["pORE_BlueGem_PriceList_ListFrame_RawPrice"]:GetText())
	local YELLOW_GEM_UNCUT_AV = tonumber(_G["pORE_YellowGem_PriceList_ListFrame_RawPrice"]:GetText())
	local PURPLE_GEM_UNCUT_AV = tonumber(_G["pORE_PurpleGem_PriceList_ListFrame_RawPrice"]:GetText())
	local GREEN_GEM_UNCUT_AV = tonumber(_G["pORE_GreenGem_PriceList_ListFrame_RawPrice"]:GetText())
	local ORANGE_GEM_UNCUT_AV = tonumber(_G["pORE_OrangeGem_PriceList_ListFrame_RawPrice"]:GetText())
	local META_GEM_UNCUT_AV = tonumber(_G["pORE_MetaGem_PriceList_ListFrame_RawPrice"]:GetText())
	
	local RED_GEM_CUT_AV, RED_GEM_TOP_CUTS = getGemAverage("RedGem", pORE_ITEMS.RARE_RED_GEM.cut)
	local BLUE_GEM_CUT_AV, BLUE_GEM_TOP_CUTS = getGemAverage("BlueGem", pORE_ITEMS.RARE_BLUE_GEM.cut)
	local YELLOW_GEM_CUT_AV, YELLOW_GEM_TOP_CUTS = getGemAverage("YellowGem", pORE_ITEMS.RARE_YELLOW_GEM.cut)
	local PURPLE_GEM_CUT_AV, PURPLE_GEM_TOP_CUTS = getGemAverage("PurpleGem", pORE_ITEMS.RARE_PURPLE_GEM.cut)
	local GREEN_GEM_CUT_AV, GREEN_GEM_TOP_CUTS = getGemAverage("GreenGem", pORE_ITEMS.RARE_GREEN_GEM.cut)
	local ORANGE_GEM_CUT_AV, ORANGE_GEM_TOP_CUTS = getGemAverage("OrangeGem", pORE_ITEMS.RARE_ORANGE_GEM.cut)
	local META_GEM_CUT_AV, META_GEM_TOP_CUTS = getGemAverage("MetaGem", pORE_ITEMS.META_GEM.cut)
	
	local GEM_VALUE_STATUS = {red = false, blue = false, yellow = false, purple = false, green = false, orange = false, meta = false}
	
	if RED_GEM_CUT_AV > RED_GEM_UNCUT_AV then GEM_VALUE_STATUS.red = true  end
	if BLUE_GEM_CUT_AV > BLUE_GEM_UNCUT_AV then GEM_VALUE_STATUS.blue = true end
	if YELLOW_GEM_CUT_AV > YELLOW_GEM_UNCUT_AV then GEM_VALUE_STATUS.yellow = true end
	if PURPLE_GEM_CUT_AV > PURPLE_GEM_UNCUT_AV then GEM_VALUE_STATUS.purple = true end
	if GREEN_GEM_CUT_AV > GREEN_GEM_UNCUT_AV then GEM_VALUE_STATUS.green = true end
	if ORANGE_GEM_CUT_AV > ORANGE_GEM_UNCUT_AV then GEM_VALUE_STATUS.orange = true end
	if META_GEM_CUT_AV > META_GEM_UNCUT_AV then GEM_VALUE_STATUS.meta = true end
	
	local ENCHANT_DUST = tonumber(_G["pORE_MiscItem_PriceList_ListFrame_ENCHANTING_DUSTPrice"]:GetText())
	local ENCHANT_ESSENCE = tonumber(_G["pORE_MiscItem_PriceList_ListFrame_ENCHANTING_ESSENCEPrice"]:GetText())
	
	local ORE_1 = tonumber(_G["pORE_MiscItem_PriceList_ListFrame_ORE_1Price"]:GetText())
	local ORE_2 = tonumber(_G["pORE_MiscItem_PriceList_ListFrame_ORE_2Price"]:GetText())
	local ORE_3 = tonumber(_G["pORE_MiscItem_PriceList_ListFrame_ORE_3Price"]:GetText())
	local ORE_4 = tonumber(_G["pORE_MiscItem_PriceList_ListFrame_ORE_4Price"]:GetText())
	
	local ORE_1_PROSPECT = pORE_ProspectAmount_ORE_1_Stacks:GetNumber()
	local ORE_2_PROSPECT = pORE_ProspectAmount_ORE_2_Stacks:GetNumber()
	local ORE_3_PROSPECT = pORE_ProspectAmount_ORE_3_Stacks:GetNumber()
	local ORE_4_PROSPECT = pORE_ProspectAmount_ORE_4_Stacks:GetNumber()
	
	local DETAIL_RED_GEMS = 0
	local DETAIL_BLUE_GEMS = 0
	local DETAIL_YELLOW_GEMS = 0
	local DETAIL_PURPLE_GEMS = 0
	local DETAIL_GREEN_GEMS = 0
	local DETAIL_ORANGE_GEMS = 0
	local DETAIL_META_GEMS = 0
	local DETAIL_JEWELRY = 0
	local DETAIL_ENCHANT_DUST = 0
	local DETAIL_ENCHANT_ESSENCE = 0
	local DETAIL_PROSPECT = ORE_1_PROSPECT + ORE_2_PROSPECT + ORE_3_PROSPECT + ORE_4_PROSPECT
	local DETAIL_CRAFT = 0
	local DETAIL_FLAGS = {enchanting = false, meta = false}
		
	local ORE_1_RARE_RED, ORE_1_RARE_BLUE, ORE_1_RARE_YELLOW, ORE_1_RARE_PURPLE, ORE_1_RARE_GREEN, ORE_1_RARE_ORANGE =
		(ORE_1_PROSPECT * 0.04), (ORE_1_PROSPECT * 0.05), (ORE_1_PROSPECT * 0.05), (ORE_1_PROSPECT * 0.05), (ORE_1_PROSPECT * 0.05), (ORE_1_PROSPECT * 0.04)
	local ORE_1_UNCOMMON_RED, ORE_1_UNCOMMON_BLUE, ORE_1_UNCOMMON_YELLOW, ORE_1_UNCOMMON_PURPLE, ORE_1_UNCOMMON_GREEN, ORE_1_UNCOMMON_ORANGE =
		(ORE_1_PROSPECT * 0.24), (ORE_1_PROSPECT * 0.25), (ORE_1_PROSPECT * 0.24), (ORE_1_PROSPECT * 0.23), (ORE_1_PROSPECT * 0.24), (ORE_1_PROSPECT * 0.23)
	local ORE_1_JEWELRY = (ORE_1_UNCOMMON_RED + ORE_1_UNCOMMON_BLUE + ORE_1_UNCOMMON_YELLOW + ORE_1_UNCOMMON_PURPLE + ORE_1_UNCOMMON_GREEN + ORE_1_UNCOMMON_ORANGE) * 4 / 3
		
	local ORE_2_RARE_RED, ORE_2_RARE_BLUE, ORE_2_RARE_YELLOW, ORE_2_RARE_PURPLE, ORE_2_RARE_GREEN, ORE_2_RARE_ORANGE =
		(ORE_2_PROSPECT * 0.04), (ORE_2_PROSPECT * 0.05), (ORE_2_PROSPECT * 0.05), (ORE_2_PROSPECT * 0.04), (ORE_2_PROSPECT * 0.04), (ORE_2_PROSPECT * 0.04)
	local ORE_2_UNCOMMON_RED, ORE_2_UNCOMMON_BLUE, ORE_2_UNCOMMON_YELLOW, ORE_2_UNCOMMON_PURPLE, ORE_2_UNCOMMON_GREEN, ORE_2_UNCOMMON_ORANGE =
		(ORE_2_PROSPECT * 0.23), (ORE_2_PROSPECT * 0.24), (ORE_2_PROSPECT * 0.23), (ORE_2_PROSPECT * 0.24), (ORE_2_PROSPECT * 0.24), (ORE_2_PROSPECT * 0.23)
	local ORE_2_JEWELRY = (ORE_2_UNCOMMON_RED + ORE_2_UNCOMMON_BLUE + ORE_2_UNCOMMON_YELLOW + ORE_2_UNCOMMON_PURPLE + ORE_2_UNCOMMON_GREEN + ORE_2_UNCOMMON_ORANGE) * 4 / 3
		
	local ORE_3_RARE_RED, ORE_3_RARE_BLUE, ORE_3_RARE_YELLOW, ORE_3_RARE_PURPLE, ORE_3_RARE_GREEN, ORE_3_RARE_ORANGE =
		(ORE_3_PROSPECT * 0.16), (ORE_3_PROSPECT * 0.17), (ORE_3_PROSPECT * 0.16), (ORE_3_PROSPECT * 0.16), (ORE_3_PROSPECT * 0.17), (ORE_3_PROSPECT * 0.16)
	local ORE_3_UNCOMMON_RED, ORE_3_UNCOMMON_BLUE, ORE_3_UNCOMMON_YELLOW, ORE_3_UNCOMMON_PURPLE, ORE_3_UNCOMMON_GREEN, ORE_3_UNCOMMON_ORANGE =
		(ORE_3_PROSPECT * 0.17), (ORE_3_PROSPECT * 0.17), (ORE_3_PROSPECT * 0.17), (ORE_3_PROSPECT * 0.16), (ORE_3_PROSPECT * 0.17), (ORE_3_PROSPECT * 0.16)
	local ORE_3_JEWELRY = (ORE_3_UNCOMMON_RED + ORE_3_UNCOMMON_BLUE + ORE_3_UNCOMMON_YELLOW + ORE_3_UNCOMMON_PURPLE + ORE_3_UNCOMMON_GREEN + ORE_3_UNCOMMON_ORANGE) * 4 / 3
	
	local ORE_4_RARE_RED, ORE_4_RARE_BLUE, ORE_4_RARE_YELLOW, ORE_4_RARE_PURPLE, ORE_4_RARE_GREEN, ORE_4_RARE_ORANGE =
		(ORE_4_PROSPECT * 0.17), (ORE_4_PROSPECT * 0.17), (ORE_4_PROSPECT * 0.16), (ORE_4_PROSPECT * 0.16), (ORE_4_PROSPECT * 0.16), (ORE_4_PROSPECT * 0.16)
	local ORE_4_UNCOMMON_RED, ORE_4_UNCOMMON_BLUE, ORE_4_UNCOMMON_YELLOW, ORE_4_UNCOMMON_PURPLE, ORE_4_UNCOMMON_GREEN, ORE_4_UNCOMMON_ORANGE =
		(ORE_4_PROSPECT * 0.17), (ORE_4_PROSPECT * 0.17), (ORE_4_PROSPECT * 0.17), (ORE_4_PROSPECT * 0.17), (ORE_4_PROSPECT * 0.16), (ORE_4_PROSPECT * 0.17)
	local ORE_4_JEWELRY = (ORE_4_UNCOMMON_RED + ORE_4_UNCOMMON_BLUE + ORE_4_UNCOMMON_YELLOW + ORE_4_UNCOMMON_PURPLE + ORE_4_UNCOMMON_GREEN + ORE_4_UNCOMMON_ORANGE) * 4 / 3
	
	local GEM_QTY_EST = {}
	
	local EST_RARE_RED_GEMS = math.floor((ORE_1_RARE_RED + ORE_2_RARE_RED + ORE_3_RARE_RED + ORE_4_RARE_RED) * 4)
	local ETS_RARE_BLUE_GEMS = math.floor((ORE_1_RARE_BLUE + ORE_2_RARE_BLUE + ORE_3_RARE_BLUE + ORE_4_RARE_BLUE) * 4)
	local ETS_RARE_YELLOW_GEMS = math.floor((ORE_1_RARE_YELLOW + ORE_2_RARE_YELLOW + ORE_3_RARE_YELLOW + ORE_4_RARE_YELLOW) * 4)
	local ETS_RARE_PURPLE_GEMS = math.floor((ORE_1_RARE_PURPLE + ORE_2_RARE_PURPLE + ORE_3_RARE_PURPLE + ORE_4_RARE_PURPLE) * 4)
	local ETS_RARE_GREEN_GEMS = math.floor((ORE_1_RARE_GREEN + ORE_2_RARE_GREEN + ORE_3_RARE_GREEN + ORE_4_RARE_GREEN) * 4)
	local ETS_RARE_ORANGE_GEMS = math.floor((ORE_1_RARE_ORANGE + ORE_2_RARE_ORANGE + ORE_3_RARE_ORANGE + ORE_4_RARE_ORANGE) * 4)
	
	local EST_UNCOMMON_RED_GEMS = math.floor((ORE_1_UNCOMMON_RED + ORE_2_UNCOMMON_RED + ORE_3_UNCOMMON_RED + ORE_4_UNCOMMON_RED) * 4)
	local ETS_UNCOMMON_BLUE_GEMS = math.floor((ORE_1_UNCOMMON_BLUE + ORE_2_UNCOMMON_BLUE + ORE_3_UNCOMMON_BLUE + ORE_4_UNCOMMON_BLUE) * 4)
	local ETS_UNCOMMON_YELLOW_GEMS = math.floor((ORE_1_UNCOMMON_YELLOW + ORE_2_UNCOMMON_YELLOW + ORE_3_UNCOMMON_YELLOW + ORE_4_UNCOMMON_YELLOW) * 4)
	local ETS_UNCOMMON_PURPLE_GEMS = math.floor((ORE_1_UNCOMMON_PURPLE + ORE_2_UNCOMMON_PURPLE + ORE_3_UNCOMMON_PURPLE + ORE_4_UNCOMMON_PURPLE) * 4)
	local ETS_UNCOMMON_GREEN_GEMS = math.floor((ORE_1_UNCOMMON_GREEN + ORE_2_UNCOMMON_GREEN + ORE_3_UNCOMMON_GREEN + ORE_4_UNCOMMON_GREEN) * 4)
	local ETS_UNCOMMON_ORANGE_GEMS = math.floor((ORE_1_UNCOMMON_ORANGE + ORE_2_UNCOMMON_ORANGE + ORE_3_UNCOMMON_ORANGE + ORE_4_UNCOMMON_ORANGE) * 4)
	
	local GEM_QTY_EST = {EST_RARE_RED_GEMS,ETS_RARE_BLUE_GEMS,ETS_RARE_YELLOW_GEMS,ETS_RARE_PURPLE_GEMS,ETS_RARE_GREEN_GEMS,ETS_RARE_ORANGE_GEMS,EST_UNCOMMON_RED_GEMS,ETS_UNCOMMON_BLUE_GEMS,
		ETS_UNCOMMON_YELLOW_GEMS,ETS_UNCOMMON_PURPLE_GEMS,ETS_UNCOMMON_GREEN_GEMS,ETS_UNCOMMON_ORANGE_GEMS}
	pORE_Set_ProspectedData(GEM_QTY_EST)
	
	local TOTAL_JEWELRY = (ORE_1_JEWELRY + ORE_2_JEWELRY + ORE_3_JEWELRY + ORE_4_JEWELRY)
	if ((ENCHANT_DUST * TOTAL_JEWELRY * 0.87) + (ENCHANT_ESSENCE * TOTAL_JEWELRY * 0.17)) > TOTAL_JEWELRY * 9 then ENCHANTING_GOOD = true else ENCHANTING_GOOD = false end
	DETAIL_CRAFT = TOTAL_JEWELRY
	DETAIL_ENCHANT_DUST = ENCHANT_DUST * TOTAL_JEWELRY * 0.87
	DETAIL_ENCHANT_ESSENCE = ENCHANT_ESSENCE * TOTAL_JEWELRY * 0.17
	
	local function getCost(orePrice, oreQuantity, Jewelry)
		local Cost = (orePrice * oreQuantity * 20) + (Jewelry * 1.2)
		return math.floor(Cost)
	end

	local function getRevenue(rRED, rBLUE, rYELLOW, rPURPLE, rGREEN, rORANGE, JEWELRY)
		local RED_GEM_VALUE
		local BLUE_GEM_VALUE
		local YELLOW_GEM_VALUE
		local PURPLE_GEM_VALUE
		local GREEN_GEM_VALUE
		local ORANGE_GEM_VALUE
		local META_GEM_VALUE
		
		local JEWELRY_VALUE
		
		local TOTAL_VALUE = 0
		
		local TRANSMUTE_BONUS = 1
		local RING_NECK_VALUE = 9
		
		if TRANSMUTE then TRANSMUTE_BONUS = 1.1 else TRANSMUTE_BONUS = 1.0 end
		
		local META_GEMS = (rPURPLE + rGREEN + rORANGE) / 6 * TRANSMUTE_BONUS
		
		if RED_GEM_CUT_AV > RED_GEM_UNCUT_AV then RED_GEM_VALUE = rRED * 4 * RED_GEM_CUT_AV	else RED_GEM_VALUE = rRED * 4 * RED_GEM_UNCUT_AV end
		if BLUE_GEM_CUT_AV > BLUE_GEM_UNCUT_AV then BLUE_GEM_VALUE = rBLUE * 4 * BLUE_GEM_CUT_AV else BLUE_GEM_VALUE = rBLUE * 4 * BLUE_GEM_UNCUT_AV end
		if YELLOW_GEM_CUT_AV > YELLOW_GEM_UNCUT_AV then YELLOW_GEM_VALUE = rYELLOW * 4 * YELLOW_GEM_CUT_AV else YELLOW_GEM_VALUE = rYELLOW * 4 * YELLOW_GEM_UNCUT_AV end
		if PURPLE_GEM_CUT_AV > PURPLE_GEM_UNCUT_AV then PURPLE_GEM_VALUE = rPURPLE * 4 * PURPLE_GEM_CUT_AV else PURPLE_GEM_VALUE = rPURPLE * 4 * PURPLE_GEM_UNCUT_AV end
		if GREEN_GEM_CUT_AV > GREEN_GEM_UNCUT_AV then GREEN_GEM_VALUE = rGREEN * 4 * GREEN_GEM_CUT_AV else GREEN_GEM_VALUE = rGREEN * 4 * GREEN_GEM_UNCUT_AV end
		if ORANGE_GEM_CUT_AV > ORANGE_GEM_UNCUT_AV then ORANGE_GEM_VALUE = rORANGE * 4 * ORANGE_GEM_CUT_AV else ORANGE_GEM_VALUE = rORANGE * 4 * ORANGE_GEM_UNCUT_AV end
		if META_GEM_CUT_AV > META_GEM_UNCUT_AV then META_GEM_VALUE = META_GEMS * 4 * META_GEM_CUT_AV else META_GEM_VALUE = META_GEMS * 4 * META_GEM_UNCUT_AV end
		
		if FORCE_UNCUT then
			RED_GEM_VALUE = rRED * 4 * RED_GEM_UNCUT_AV
			BLUE_GEM_VALUE = rBLUE * 4 * BLUE_GEM_UNCUT_AV
			YELLOW_GEM_VALUE = rYELLOW * 4 * YELLOW_GEM_UNCUT_AV
			PURPLE_GEM_VALUE = rPURPLE * 4 * PURPLE_GEM_UNCUT_AV
			GREEN_GEM_VALUE = rGREEN * 4 * GREEN_GEM_UNCUT_AV
			ORANGE_GEM_VALUE = rORANGE * 4 * ORANGE_GEM_UNCUT_AV
			META_GEM_VALUE = META_GEMS * 4 * META_GEM_UNCUT_AV
		end
		
		if ENCHANTING and ENCHANTING_GOOD then
			JEWELRY_VALUE = (JEWELRY * ENCHANT_DUST * 0.87) + (JEWELRY * ENCHANT_ESSENCE * 0.17)
			DETAIL_FLAGS.enchanting = true
		else
			JEWELRY_VALUE = JEWELRY * RING_NECK_VALUE
			DETAIL_FLAGS.enchanting = false
		end
		
		DETAIL_RED_GEMS = DETAIL_RED_GEMS + RED_GEM_VALUE
		DETAIL_BLUE_GEMS = DETAIL_BLUE_GEMS + BLUE_GEM_VALUE
		DETAIL_YELLOW_GEMS = DETAIL_YELLOW_GEMS + YELLOW_GEM_VALUE
		DETAIL_PURPLE_GEMS = DETAIL_PURPLE_GEMS + PURPLE_GEM_VALUE
		DETAIL_GREEN_GEMS = DETAIL_GREEN_GEMS + GREEN_GEM_VALUE
		DETAIL_ORANGE_GEMS = DETAIL_ORANGE_GEMS + ORANGE_GEM_VALUE
		DETAIL_META_GEMS = DETAIL_META_GEMS + META_GEM_VALUE
		DETAIL_JEWELRY = DETAIL_JEWELRY + JEWELRY_VALUE
		
		if META_GEM_VALUE > ((PURPLE_GEM_VALUE + GREEN_GEM_VALUE + ORANGE_GEM_VALUE)) or FORCE_META then
			TOTAL_VALUE = RED_GEM_VALUE + BLUE_GEM_VALUE + YELLOW_GEM_VALUE + META_GEM_VALUE + JEWELRY_VALUE
			if TOTAL_VALUE < 1 then else DETAIL_FLAGS.meta = true end
		else
			TOTAL_VALUE = RED_GEM_VALUE + BLUE_GEM_VALUE + YELLOW_GEM_VALUE + PURPLE_GEM_VALUE + GREEN_GEM_VALUE + ORANGE_GEM_VALUE + JEWELRY_VALUE
			if TOTAL_VALUE < 1 then else DETAIL_FLAGS.meta = false end
		end
		
		-- Ver 1.11 Fix (Meta Gems recommended while unable to craft them) ------------------------------------------------------------------------- --
		if ALCHEMY then else																														 --
			TOTAL_VALUE = RED_GEM_VALUE + BLUE_GEM_VALUE + YELLOW_GEM_VALUE + PURPLE_GEM_VALUE + GREEN_GEM_VALUE + ORANGE_GEM_VALUE + JEWELRY_VALUE  --
			if TOTAL_VALUE < 1 then else DETAIL_FLAGS.meta = false end																				 --
		end																																			 --
		-- ----------------------------------------------------------------------------------------------------------------------------------------- --
		
		return math.floor(TOTAL_VALUE * 0.92)
	end
	
	pORE_Set_Recommended(RED_GEM_TOP_CUTS, BLUE_GEM_TOP_CUTS, YELLOW_GEM_TOP_CUTS, PURPLE_GEM_TOP_CUTS, GREEN_GEM_TOP_CUTS, ORANGE_GEM_TOP_CUTS, META_GEM_TOP_CUTS, GEM_VALUE_STATUS, ENCHANTING_GOOD)
	
	local ORE_1_COST = getCost(ORE_1, ORE_1_PROSPECT, ORE_1_JEWELRY)
	local ORE_1_REVENUE = getRevenue(ORE_1_RARE_RED, ORE_1_RARE_BLUE, ORE_1_RARE_YELLOW, ORE_1_RARE_PURPLE, ORE_1_RARE_GREEN, ORE_1_RARE_ORANGE, ORE_1_JEWELRY)
	local ORE_1_PROFIT = ORE_1_REVENUE - ORE_1_COST
	
	local ORE_2_COST = getCost(ORE_2, ORE_2_PROSPECT, ORE_2_JEWELRY)
	local ORE_2_REVENUE = getRevenue(ORE_2_RARE_RED, ORE_2_RARE_BLUE, ORE_2_RARE_YELLOW, ORE_2_RARE_PURPLE, ORE_2_RARE_GREEN, ORE_2_RARE_ORANGE, ORE_2_JEWELRY)
	local ORE_2_PROFIT = ORE_2_REVENUE - ORE_2_COST
	
	local ORE_3_COST = getCost(ORE_3, ORE_3_PROSPECT, ORE_3_JEWELRY)
	local ORE_3_REVENUE = getRevenue(ORE_3_RARE_RED, ORE_3_RARE_BLUE, ORE_3_RARE_YELLOW, ORE_3_RARE_PURPLE, ORE_3_RARE_GREEN, ORE_3_RARE_ORANGE, ORE_3_JEWELRY)
	local ORE_3_PROFIT = ORE_3_REVENUE - ORE_3_COST
	
	local ORE_4_COST = getCost(ORE_4, ORE_4_PROSPECT, ORE_4_JEWELRY)
	local ORE_4_REVENUE = getRevenue(ORE_4_RARE_RED, ORE_4_RARE_BLUE, ORE_4_RARE_YELLOW, ORE_4_RARE_PURPLE, ORE_4_RARE_GREEN, ORE_4_RARE_ORANGE, ORE_4_JEWELRY)
	local ORE_4_PROFIT = ORE_4_REVENUE - ORE_4_COST
	
	local REV_EST = {ORE_1_COST,ORE_1_REVENUE,ORE_1_PROFIT,ORE_2_COST,ORE_2_REVENUE,ORE_2_PROFIT,ORE_3_COST,ORE_3_REVENUE,ORE_3_PROFIT,ORE_4_COST,ORE_4_REVENUE,ORE_4_PROFIT}
	pORE_Set_RevenueData(REV_EST)
	
	pORE_Set_Details(DETAIL_RED_GEMS, DETAIL_BLUE_GEMS, DETAIL_YELLOW_GEMS, DETAIL_PURPLE_GEMS, DETAIL_GREEN_GEMS, DETAIL_ORANGE_GEMS, DETAIL_META_GEMS, DETAIL_JEWELRY, DETAIL_ENCHANT_DUST, DETAIL_ENCHANT_ESSENCE, DETAIL_PROSPECT, DETAIL_CRAFT, DETAIL_FLAGS)

end

























