-----------------------------
-- Bunch of functions inc! --
-----------------------------
---------------------
-- Binding control --
---------------------
local function PA_Bind(parent, button, clear, state)
	if(clear) then
		ClearOverrideBindings(parent);
	elseif(state == "Enable") then
		if(not button:IsEnabled()) then button:Enable(); end
		SetOverrideBindingClick(parent, true, button:GetText(), parent:GetName());
	end
	if(state == "Disable" and button:IsEnabled()) then button:Disable() end
end

function PA_ButtonControl(Button,state)
	if(Button == "Master") then
		if(state == "Enable") then
			PA_SavedSettings["MasterChecked"] = true
			MinimapButton:Enable()
			PA_Minimap:Show()
			MillingButton:Enable()
			HerbButton:Enable()
			ProspectingButton:Enable()
			OreButton:Enable()
			EnchantingButton:Enable()
			MaterialButton:Enable()
			if(PA_SavedSettings["MillingChecked"]) then 
				UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Milling)
				if(MillingID>=5) then PA_Bind(MillingBB, MillingBind, false, state) end
			end
			if(PA_SavedSettings["HerbChecked"]) then
				UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Herb)
				if(HerbID>=5) then PA_Bind(HerbBB, HerbBind, false, state) end
			end
			if(PA_SavedSettings["ProspectingChecked"]) then
				UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Prospecting)
				if(ProspectingID>=5) then PA_Bind(ProspectingBB, ProspectingBind, false, state) end
			end
			if(PA_SavedSettings["OreChecked"]) then
				UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Ore)
				if(OreID>=5) then PA_Bind(OreBB, OreBind, false, state) end
			end
			if(PA_SavedSettings["EnchantingChecked"]) then
				UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Enchanting)
				if(EnchantingID>=5) then PA_Bind(EnchantingBB, EnchantingBind, false, state) end
			end
			if(PA_SavedSettings["MaterialChecked"]) then
				UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Material)
				if(MaterialID>=5) then PA_Bind(MaterialBB, MaterialBind, false, state) end
			end
		end
		if(state == "Disable") then
			PA_SavedSettings["MasterChecked"] = false
			MinimapButton:Disable()
			PA_Minimap:Hide()
			MillingButton:Disable()
			PA_Bind(MillingBB, MillingBind, true, state)
			HerbButton:Disable()
			PA_Bind(HerbBB, HerbBind, true, state)
			ProspectingButton:Disable()
			PA_Bind(ProspectingBB, ProspectingBind, true, state)
			OreButton:Disable()
			PA_Bind(OreBB, OreBind, true, state)
			EnchantingButton:Disable()
			PA_Bind(EnchantingBB, EnchantingBind, true, state)
			MaterialButton:Disable()
			PA_Bind(MaterialBB, MaterialBind, true, state)
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Milling)
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Herb)
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Prospecting)
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Ore)
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Enchanting)
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Material)
		end
		if(state == "Startup") then
			MinimapButton:Enable()
			MillingButton:Enable()
			HerbButton:Enable()
			ProspectingButton:Enable()
			OreButton:Enable()
			EnchantingButton:Enable()
			MaterialButton:Enable()
			if(PA_SavedSettings["MillingChecked"]) then 
				UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Milling)
				if(MillingID>=5) then PA_Bind(MillingBB, MillingBind, false, "Enable") end
			end
			if(PA_SavedSettings["HerbChecked"]) then
				UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Herb)
				if(HerbID>=5) then PA_Bind(HerbBB, HerbBind, false, "Enable") end
			end
			if(PA_SavedSettings["ProspectingChecked"]) then
				UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Prospecting)
				if(ProspectingID>=5) then PA_Bind(ProspectingBB, ProspectingBind, false, "Enable") end
			end
			if(PA_SavedSettings["OreChecked"]) then
				UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Ore)
				if(OreID>=5) then PA_Bind(OreBB, OreBind, false, "Enable") end
			end
			if(PA_SavedSettings["EnchantingChecked"]) then
				UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Enchanting)
				if(EnchantingID>=5) then PA_Bind(EnchantingBB, EnchantingBind, false, "Enable") end
			end
			if(PA_SavedSettings["MaterialChecked"]) then
				UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Material)
				if(MaterialID>=5) then PA_Bind(MaterialBB, MaterialBind, false, "Enable") end
			end
		end
		if(state == "startup2") then
			MinimapButton:Disable()
			MillingButton:Disable()
			PA_Bind(MillingBB, MillingBind, true, "Disable")
			HerbButton:Disable()
			PA_Bind(HerbBB, HerbBind, true, "disable")
			ProspectingButton:Disable()
			PA_Bind(ProspectingBB, ProspectingBind, true, "Disable")
			OreButton:Disable()
			PA_Bind(OreBB, OreBind, true, "Disable")
			EnchantingButton:Disable()
			PA_Bind(EnchantingBB, EnchantingBind, true, "Disable")
			MaterialButton:Disable()
			PA_Bind(MaterialBB, MaterialBind, true, "Disable")
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Milling)
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Herb)
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Prospecting)
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Ore)
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Enchanting)
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Material)
		end
	end
	if(Button == "Minimap") then
		if(state == "Enable") then PA_SavedSettings["MinimapChecked"] = true end
		if(state == "Disable") then PA_SavedSettings["MinimapChecked"] = false end
	end
	if(Button == "Milling") then
		if(state == "Enable") then
			PA_SavedSettings["MillingChecked"] = true
			UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Milling)
			if(MillingID>=5) then PA_Bind(MillingBB, MillingBind, false, state) end
		end
		if(state == "Disable") then
			PA_SavedSettings["MillingChecked"] = false
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Milling)
			PA_Bind(MillingBB, MillingBind, true, state)
		end
		MillingButton:SetChecked(PA_SavedSettings["MillingChecked"])
	end
	if(Button == "Herb") then
		if(state == "Enable") then
			PA_SavedSettings["HerbChecked"] = true
			UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Herb)
			if(HerbID>=5) then PA_Bind(HerbBB, HerbBind, false, true) end
		end
		if(state == "Disable") then
			PA_SavedSettings["HerbChecked"] = false
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Herb)
			PA_Bind(HerbBB, HerbBind, true, state)
		end
		HerbButton:SetChecked(PA_SavedSettings["HerbChecked"])
	end
	if(Button == "Prospecting") then
		if(state == "Enable") then
			PA_SavedSettings["ProspectingChecked"] = true
			UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Prospecting)
			if(ProspectingID>=5) then PA_Bind(ProspectingBB, ProspectingBind, false, state) end
		end
		if(state == "Disable") then
			PA_SavedSettings["ProspectingChecked"] = false
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Prospecting)
			PA_Bind(ProspectingBB, ProspectingBind, true, state)
		end
		ProspectingButton:SetChecked(PA_SavedSettings["ProspectingChecked"])
	end
	if(Button == "Ore") then
		if(state == "Enable") then
			PA_SavedSettings["OreChecked"] = true
			UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Ore)
			if(OreID>=5) then PA_Bind(OreBB, OreBind, false, state) end
		end
		if(state == "Disable") then
			PA_SavedSettings["OreChecked"] = false
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Ore)
			PA_Bind(OreBB, OreBind, true, state)
		end
		OreButton:SetChecked(PA_SavedSettings["OreChecked"])
	end
	if(Button == "Enchanting") then
		if(state == "Enable") then
			PA_SavedSettings["EnchantingChecked"] = true
			UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Enchanting)
			if(EnchantingID>=5) then PA_Bind(EnchantingBB, EnchantingBind, false, state) end
		end
		if(state == "Disable") then
			PA_SavedSettings["EnchantingChecked"] = false
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Enchanting)
			PA_Bind(EnchantingBB, EnchantingBind, true, state)
		end
		EnchantingButton:SetChecked(PA_SavedSettings["EnchantingChecked"])
	end
	if(Button == "Material") then
		if(state == "Enable") then
			PA_SavedSettings["MaterialChecked"] = true
			UIDropDownMenu_EnableDropDown(PA_interface_dropdownmenu_Material)
			if(MaterialID>=5) then PA_Bind(MaterialBB, MaterialBind, false, state) end
		end
		if(state == "Disable") then
			PA_SavedSettings["MaterialChecked"] = false
			UIDropDownMenu_DisableDropDown(PA_interface_dropdownmenu_Material)
			PA_Bind(MaterialBB, MaterialBind, true, state)
		end
		MaterialButton:SetChecked(PA_SavedSettings["MaterialChecked"])
	end
end
--------------------------
-- Button creator stuff --
--------------------------
local function createCheckbutton(parent, x_loc, y_loc, IDname, displayname, description)
	local checkbutton = CreateFrame("CheckButton", "PA_interface_checkbutton_" .. IDname, parent);
	checkbutton:SetNormalTexture("Interface/Buttons/UI-CheckBox-Up")
	checkbutton:SetPushedTexture("Interface/Buttons/UI-CheckBox-Down")
	checkbutton:SetHighlightTexture("Interface/Buttons/UI-CheckBox-Highlight","ADD")
	checkbutton:SetCheckedTexture("Interface/Buttons/UI-CheckBox-Check")
	checkbutton:SetDisabledCheckedTexture("Interface/Buttons/UI-CheckBox-Check-Disabled")
	checkbutton:SetPoint("TOPLEFT", x_loc, y_loc);
	checkbutton:SetSize(32,32);
	checkbuttonText = checkbutton:CreateFontString("checkbuttonText", "ARTWORK","GameFontHighlight")
	checkbuttonText:SetText(displayname);
	checkbuttonText:SetPoint("LEFT", "$parent", "RIGHT", 0, 1)
	checkbutton:SetScript("OnEnter", function(self)
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
		GameTooltip:SetText(displayname, nil, nil, nil, nil, 1);
		GameTooltip:AddLine(description, 1.0, 1.0, 1.0, 1.0);
		GameTooltip:Show();
	end)
	checkbutton:SetScript("OnLeave", function(self) GameTooltip:Hide() end)
	return checkbutton;
end

----------------------------
-- FontText creator stuff --
----------------------------
local function createFonttext(parent, x_loc, y_loc, text, fonttemplate)
	local title = parent:CreateFontString(nil, "ARTWORK", fonttemplate);
	title:SetPoint("TOPLEFT", x_loc, y_loc)
	title:SetText(text)
end

--------------------------------
-- DropDownMenu creator stuff --
--------------------------------
function PA_CreateMenu(parent, x_loc, y_loc, IDname, displayname, description)
	local menu = CreateFrame("Button", "PA_interface_dropdownmenu_" .. IDname, parent, "UIDropDownMenuTemplate")
	
	menu:SetPoint("TOPLEFT", x_loc, y_loc)
	menu:Show()
	
	local function OnClick(self)
		if(menu == PA_interface_dropdownmenu_Milling) then
			PA_SavedSettings["MillingKey"] = self:GetID()
			UIDropDownMenu_SetSelectedID(menu, self:GetID())
			MillingID = self:GetID();
			if(MillingID>=5) then PA_Bind(MillingBB, MillingBind, false, "Enable") else PA_Bind(MillingBB, MillingBind, true, "Disable") end
		end
		if(menu == PA_interface_dropdownmenu_Herb) then
			PA_SavedSettings["HerbKey"] = self:GetID()
			UIDropDownMenu_SetSelectedID(menu, self:GetID())
			HerbID = self:GetID();
			if(HerbID>=5) then PA_Bind(HerbBB, HerbBind, false, "Enable") else PA_Bind(HerbBB, HerbBind, true, "Disable") end
		end
		if(menu == PA_interface_dropdownmenu_Prospecting) then
			PA_SavedSettings["ProspectingKey"] = self:GetID()
			UIDropDownMenu_SetSelectedID(menu, self:GetID())
			ProspectingID = self:GetID();
			if(ProspectingID>=5) then PA_Bind(ProspectingBB, ProspectingBind, false, "Enable") else PA_Bind(ProspectingBB, ProspectingBind, true, "Disable") end
		end
		if(menu == PA_interface_dropdownmenu_Ore) then
			PA_SavedSettings["OreKey"] = self:GetID()
			UIDropDownMenu_SetSelectedID(menu, self:GetID())
			OreID = self:GetID();
			if(OreID>=5) then PA_Bind(OreBB, OreBind, false, "Enable") else PA_Bind(OreBB, OreBind, true, "Disable") end
		end
		if(menu == PA_interface_dropdownmenu_Enchanting) then
			PA_SavedSettings["EnchantingKey"] = self:GetID()
			UIDropDownMenu_SetSelectedID(menu, self:GetID())
			EnchantingID = self:GetID();
			if(EnchantingID>=5) then PA_Bind(EnchantingBB, EnchantingBind, false, "Enable") else PA_Bind(EnchantingBB, EnchantingBind, true, "Disable") end
		end
		if(menu == PA_interface_dropdownmenu_Material) then
			PA_SavedSettings["MaterialKey"] = self:GetID()
			UIDropDownMenu_SetSelectedID(menu, self:GetID())
			MaterialID = self:GetID();
			if(MaterialID>=5) then PA_Bind(MaterialBB, MaterialBind, false, "Enable") else PA_Bind(MaterialBB, MaterialBind, true, "Disable") end
		end
	end
	
	local function init(self, level)
		for _,v in next, {
			"Always",
			"Shift",
			"Ctrl",
			"Alt",
			"Custom"
		}do
			info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.func = OnClick
			UIDropDownMenu_AddButton(info, level)
		end
	end
	
	menu:SetScript('OnEnter', function(self)
		GameTooltip:SetOwner(self,"ANCHOR_TOPRIGHT")
		GameTooltip:SetText(displayname, nil, nil, nil, 1, 1)
		GameTooltip:AddLine(description, 1, 1, 1)
		GameTooltip:Show()
	end)
	menu:SetScript('OnLeave', function(self) GameTooltip:Hide() end)
	
	UIDropDownMenu_Initialize(menu, init)
	UIDropDownMenu_SetWidth(menu, 75);
	UIDropDownMenu_SetButtonWidth(menu, 50)
	UIDropDownMenu_JustifyText(menu, "LEFT")
end

--------------------
-- Binding button --
--------------------
function PA_CreateBB(parent, x_loc, y_loc, IDname)
	bindbutton = CreateFrame("Button","PA_bindbutton_"..IDname,parent,"UIPanelButtonTemplate")
	bindbutton:SetPoint("TOPLEFT",x_loc,y_loc)
	bindbutton:SetWidth(100)
	bindbutton:SetHeight(22)
	bindbutton:EnableKeyboard(false)
	bindbutton:SetText("Not Bound")
	
	bindbutton:SetScript("OnEnter", function(self)
		GameTooltip:SetOwner(self,"ANCHOR_TOP")
		GameTooltip:SetText("Bind a key to show "..IDname.." results", nil, nil, nil, 1, 1)
		GameTooltip:AddLine("|cff00ff00Left-click|r to start binding, click again or press ESCAPE to cancel", 1, 1, 1)
		GameTooltip:AddLine("|cff00ff00Right-click|r to unbind the key", 1, 1, 1)
		GameTooltip:Show()
	end)
	bindbutton:SetScript("OnLeave", function(self) GameTooltip:Hide() end)
	
	return bindbutton;
end

-------------------
-- Minimap stuff --
-------------------
function PA_Minimap_Init(parent)
	local menu = CreateFrame("Frame", "PA_Minimap_Menu", parent, "UIDropDownMenuTemplate")
	
	local icons = {
		"", -- space holder
		"Interface\\ICONS\\Ability_miling",
		"Interface\\ICONS\\Trade_herbalism",
		"Interface\\ICONS\\Inv_misc_gem_bloodgem_01",
		"Interface\\ICONS\\Trade_mining",
		"Interface\\ICONS\\Trade_Engraving",
		"Interface\\ICONS\\INV_Enchant_Disenchant"
	}
	
	local function OnClick(self, arg1, _, checked) if not(arg1==Close) and (checked) then PA_ButtonControl(arg1,"Enable") else PA_ButtonControl(arg1,"Disable") end end
	
	local function init(self, level)
		info = UIDropDownMenu_CreateInfo()
		for k,v in next, {
			"Toggle options",
			"Milling",
			"Herb",
			"Prospecting",
			"Ore",
			"Enchanting",
			"Material",
			"Close"
		}do
			if(v=="Toggle options") then
				info.text = v;
				info.isTitle = true;
				info.notCheckable = true;
				UIDropDownMenu_AddButton(info, level)
			else
				if(v=="Close") then
					info.text = v
					info.func = OnClick
					info.arg1 = v
					info.icon = nil
					info.notCheckable = true;
					info.keepShownOnClick = false;
					UIDropDownMenu_AddButton(info, level)
				else
					info.text = v.." results"
					info.func = OnClick
					info.arg1 = v
					info.icon = icons[k]
					info.checked = PA_SavedSettings[v.."Checked"];
					info.isTitle = false;
					info.disabled = false;
					info.isNotRadio = true;
					info.notCheckable = false;
					info.keepShownOnClick = true;
					UIDropDownMenu_AddButton(info, level)
				end
			end
		end
	end
	UIDropDownMenu_Initialize(menu, init, "MENU")
end

local function moveButton(self)
	local centerX, centerY = Minimap:GetCenter()
	local x, y = GetCursorPosition()
	x, y = x / self:GetEffectiveScale() - centerX, y / self:GetEffectiveScale() - centerY
	centerX, centerY = math.abs(x), math.abs(y)
	centerX, centerY = (centerX / math.sqrt(centerX^2 + centerY^2)) * 80, (centerY / sqrt(centerX^2 + centerY^2)) * 80
	centerX = x < 0 and -centerX or centerX
	centerY = y < 0 and -centerY or centerY
	self:ClearAllPoints()
	self:SetPoint("CENTER", centerX, centerY)
	PA_SavedSettings["Minimap_PosX"] = centerX
	PA_SavedSettings["Minimap_PosY"] = centerY
end
local function PA_Minimap_Create()
	PA_Minimap = CreateFrame("Button", "Profession Assistance", Minimap)
	PA_Minimap:SetSize(31, 31)
	PA_Minimap:SetFrameStrata("MEDIUM")
	PA_Minimap:SetPoint("CENTER", PA_SavedSettings["Minimap_PosX"], PA_SavedSettings["Minimap_PosY"])
	PA_Minimap:SetMovable(true)
	PA_Minimap:SetHighlightTexture("Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight")
	
	local overlay = PA_Minimap:CreateTexture(nil, "OVERLAY")
	overlay:SetSize(53, 53)
	overlay:SetTexture("Interface\\Minimap\\MiniMap-TrackingBorder")
	overlay:SetPoint("TOPLEFT")
	
	local icon = PA_Minimap:CreateTexture(nil, "ARTWORK")
	icon:SetSize(18.5, 18.5)
	icon:SetTexture("Interface\\ICONS\\INV_Hammer_20")
	icon:SetPoint("TOPLEFT", 7, -5.5)
	
	PA_Minimap:SetScript("OnMouseDown", function(self, button)
		if button == "LeftButton" then
			icon:SetPoint("TOPLEFT", 7, -5.5)
			icon:SetSize(18,18)
			ToggleDropDownMenu(1, nil, PA_Minimap_Menu, self, 0, 0);
		else
			if IsShiftKeyDown() then
				icon:SetPoint("TOPLEFT", 7, -5.5)
				icon:SetSize(18,18)
				self:SetScript("OnUpdate", moveButton)
			else
				icon:SetPoint("TOPLEFT", 7, -5.5)
				icon:SetSize(18,18)
				PA_Panel:Show();
			end
		end
	end)
	PA_Minimap:SetScript("OnMouseUp", function(self)
		self:SetScript("OnUpdate", nil)
		icon:SetSize(18.5,18.5)
		icon:SetPoint("TOPLEFT", 7, -5.5)
	end)
	
	PA_Minimap:SetScript("OnEnter", function(self)
		GameTooltip:SetOwner(self,"ANCHOR_BOTTOMLEFT")
		GameTooltip:SetText("Profession Assistance", nil, nil, nil, 1, 1)
		GameTooltip:AddLine(" ")
		GameTooltip:AddLine("|cff00ff00Left-click|r to open sub-menu.", 1, 1, 1)
		GameTooltip:AddLine("|cff00ff00Right-click|r to open interface panel.", 1, 1, 1)
		GameTooltip:AddLine("|cff00ff00Shift+Right-click|r to drag this icon.", 1, 1, 1)
		GameTooltip:Show()
	end)
	PA_Minimap:SetScript("OnLeave", function(self) GameTooltip:Hide() end)
	
	if(MinimapButton:IsEnabled() and MinimapButton:GetChecked()) then PA_Minimap:Show() else PA_Minimap:Hide() end
	MinimapButton:SetScript("OnClick", function()
		if(MinimapButton:GetChecked()) then
			PA_ButtonControl("Minimap","Enable")
			PA_Minimap:Show()
		else
			PA_ButtonControl("Minimap","Disable")
			PA_Minimap:Hide()
		end
	end);
	
	PA_Minimap_Init(PA_Minimap)
end

--------------------------
-- Interface AddOns tab --
--------------------------
local InterfaceFrame = CreateFrame("Frame")
InterfaceFrame:RegisterEvent("PLAYER_LOGIN");
InterfaceFrame:SetScript("OnEvent", function(self,event,...)
	if(type(PA_SavedSettings) ~= "table") then PA_SavedSettings = {} end
	
	if(PA_SavedSettings["MasterChecked"] == nil) then PA_SavedSettings["MasterChecked"] = true
	else PA_SavedSettings["MasterChecked"] = PA_SavedSettings["MasterChecked"] end
	
	if(PA_SavedSettings["MinimapChecked"] == nil) then PA_SavedSettings["MinimapChecked"] = true
	else PA_SavedSettings["MinimapChecked"] = PA_SavedSettings["MinimapChecked"] end
	
	if(PA_SavedSettings["Minimap_PosX"] == nil) then PA_SavedSettings["Minimap_PosX"] = -78.5
	else PA_SavedSettings["Minimap_PosX"] = PA_SavedSettings["Minimap_PosX"] end
	
	if(PA_SavedSettings["Minimap_PosY"] == nil) then PA_SavedSettings["Minimap_PosY"] = -16
	else PA_SavedSettings["Minimap_PosY"] = PA_SavedSettings["Minimap_PosY"] end
	
	if(PA_SavedSettings["MillingChecked"] == nil) then PA_SavedSettings["MillingChecked"] = true
	else PA_SavedSettings["MillingChecked"] = PA_SavedSettings["MillingChecked"] end
	
	if(PA_SavedSettings["HerbChecked"] == nil) then PA_SavedSettings["HerbChecked"] = true
	else PA_SavedSettings["HerbChecked"] = PA_SavedSettings["HerbChecked"] end
	
	if(PA_SavedSettings["ProspectingChecked"] == nil) then PA_SavedSettings["ProspectingChecked"] = true
	else PA_SavedSettings["ProspectingChecked"] = PA_SavedSettings["ProspectingChecked"] end
	
	if(PA_SavedSettings["OreChecked"] == nil) then PA_SavedSettings["OreChecked"] = true
	else PA_SavedSettings["OreChecked"] = PA_SavedSettings["OreChecked"] end
	
	if(PA_SavedSettings["EnchantingChecked"] == nil) then PA_SavedSettings["EnchantingChecked"] = true
	else PA_SavedSettings["EnchantingChecked"] = PA_SavedSettings["EnchantingChecked"] end
	
	if(PA_SavedSettings["MaterialChecked"] == nil) then PA_SavedSettings["MaterialChecked"] = true
	else PA_SavedSettings["MaterialChecked"] = PA_SavedSettings["MaterialChecked"] end
	
	if(PA_SavedSettings["MillingKey"] == nil) then PA_SavedSettings["MillingKey"] = 1
	else PA_SavedSettings["MillingKey"] = PA_SavedSettings["MillingKey"] end
	
	if(PA_SavedSettings["MillingBind"] == nil) then PA_SavedSettings["MillingBind"] = "Not Bound"
	else PA_SavedSettings["MillingBind"] = PA_SavedSettings["MillingBind"] end
	
	if(PA_SavedSettings["HerbKey"] == nil) then PA_SavedSettings["HerbKey"] = 1
	else PA_SavedSettings["HerbKey"] = PA_SavedSettings["HerbKey"] end
	
	if(PA_SavedSettings["HerbBind"] == nil) then PA_SavedSettings["HerbBind"] = "Not Bound"
	else PA_SavedSettings["HerbBind"] = PA_SavedSettings["HerbBind"] end
	
	if(PA_SavedSettings["ProspectingKey"] == nil) then PA_SavedSettings["ProspectingKey"] = 1
	else PA_SavedSettings["ProspectingKey"] = PA_SavedSettings["ProspectingKey"] end
	
	if(PA_SavedSettings["ProspectingBind"] == nil) then PA_SavedSettings["ProspectingBind"] = "Not Bound"
	else PA_SavedSettings["ProspectingBind"] = PA_SavedSettings["ProspectingBind"] end
	
	if(PA_SavedSettings["OreKey"] == nil) then PA_SavedSettings["OreKey"] = 1
	else PA_SavedSettings["OreKey"] = PA_SavedSettings["OreKey"] end
	
	if(PA_SavedSettings["OreBind"] == nil) then PA_SavedSettings["OreBind"] = "Not Bound"
	else PA_SavedSettings["OreBind"] = PA_SavedSettings["OreBind"] end
	
	if(PA_SavedSettings["EnchantingKey"] == nil) then PA_SavedSettings["EnchantingKey"] = 1
	else PA_SavedSettings["EnchantingKey"] = PA_SavedSettings["EnchantingKey"] end
	
	if(PA_SavedSettings["EnchantingBind"] == nil) then PA_SavedSettings["EnchantingBind"] = "Not Bound"
	else PA_SavedSettings["EnchantingBind"] = PA_SavedSettings["EnchantingBind"] end
	
	if(PA_SavedSettings["MaterialKey"] == nil) then PA_SavedSettings["MaterialKey"] = 1
	else PA_SavedSettings["MaterialKey"] = PA_SavedSettings["MaterialKey"] end
	
	if(PA_SavedSettings["MaterialBind"] == nil) then PA_SavedSettings["MaterialBind"] = "Not Bound"
	else PA_SavedSettings["MaterialBind"] = PA_SavedSettings["MaterialBind"] end
	
	------------------
	-- Layout panel --
	------------------
	PA_Panel = CreateFrame( "Frame", "PA_Panel", UIParent);
	PA_Panel:SetBackdrop({
		bgFile = "Interface/DialogFrame/UI-DialogBox-Background",
		edgeFile = "Interface/DialogFrame/UI-DialogBox-Border", tile = true, tileSize = 32, edgeSize = 32,
		insets = { left = 11, right = 11, top = 12, bottom = 10 }
	});
	
	PA_Panel:SetFrameStrata("HIGH")
	PA_Panel:SetPoint("CENTER",0,0)
	PA_Panel:SetSize(824,568)
	PA_Panel:SetClampedToScreen(true)
	PA_Panel:EnableMouse(true)
	tinsert(UISpecialFrames, PA_Panel:GetName()) -- Makes it able to close when ESC is pressed
	
	PA_Panel:CreateTexture("$parentHeader", "ARTWORK");
	PA_PanelHeader:SetTexture("Interface/DialogFrame/UI-DialogBox-Header");
	PA_PanelHeader:SetSize(300,68);
	PA_PanelHeader:SetPoint("TOP",0,12);
	PA_Panel:CreateFontString("$parentHeaderText","ARTWORK","GameFontNormal");
	PA_PanelHeaderText:SetPoint("TOP","$parentHeader","TOP",0,-14);
	PA_PanelHeaderText:SetText("Profession Assistance");
	
	PA_Panel_Button = CreateFrame("BUTTON", "$parent_Button", PA_Panel, "UIPanelButtonTemplate")
	PA_Panel_Button:SetPoint("BOTTOMRIGHT",-22,15)
	PA_Panel_Button:SetWidth(100)
	PA_Panel_Button:SetText("Close")
	PA_Panel_Button:SetScript("OnClick", function(self) PA_Panel:Hide(); end)
	
	--Hide it because we don't need to see it straight away!
	PA_Panel:Hide();
	
	-- Show the panel with slash command
	SLASH_PA1,SLASH_PA2,SLASH_PA3,SLASH_PA4 = '/PA','/Profession','/Proffesion Assistance','/Profession_Assistance';
	function SlashCmdList.PA(msg, editbox) PA_Panel:Show(); end
	
	-----------------------
	-- Categories frames --
	-----------------------
	PA_Panel_Categories = CreateFrame( "Frame", "$parent_Categories", PA_Panel);
	PA_Panel_Categories:SetBackdrop({edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tileSize = 16, edgeSize = 16,});
	PA_Panel_Categories:SetSize(780,489);
	PA_Panel_Categories:SetPoint("TOPLEFT",22,-40);
	
	-----------------
	-- create tabs --
	-----------------
	PA_Panel_Categories.selectedTab = 1;
	PA_Panel_Categories.subFrames = {};
	PA_Panel_Categories.name = PA_Panel_Categories:GetName();
	
	PA_Panel_Categories.showSubFrame = function(name)
		for index, value in pairs(PA_Panel_Categories.subFrames) do
			if("$parentTab"..index == "$parentTab"..PA_Panel_Categories.selectedTab) then
				_G[value]:Show()
			else _G[value]:Hide() end
		end
	end

	local updatePanel = function(panel)
		PanelTemplates_UpdateTabs(panel)
		panel.showSubFrame(panel.name.."Tab"..panel.selectedTab)
	end

	local setPanel = function(panel,id)
		PanelTemplates_SetTab(panel, id)
		updatePanel(panel)
	end

	local createTab = function(parent, index, name)
		local tab = CreateFrame("Button", "$parentTab"..index, parent, "OptionsFrameTabButtonTemplate")
		tab.id = index
		tab:SetWidth(50)
		if index == 1 then tab:SetPoint("TOPLEFT",5,24) else tab:SetPoint("LEFT", "$parentTab"..index-1, "RIGHT", -15, 0) end
		tab:HookScript("OnClick", function(self) setPanel(self:GetParent(), self.id) end)
		tab:SetText(string.sub(name,string.len(parent.name)+2))
		PanelTemplates_TabResize(tab)
	end
	
	--create subframes
	local createSubFrame = function(parent,name)
		local subframe = CreateFrame("Frame", "$parent_"..name, parent)
		subframe:SetAllPoints()
		tinsert(parent.subFrames,subframe:GetName())
	end
	
	-- createSubFrame(parent,name)
	createSubFrame(PA_Panel_Categories,"Main")
	createSubFrame(PA_Panel_Categories,"Options")
	PA_Panel_Categories.numTabs = #PA_Panel_Categories.subFrames
	
	for i = 1, PA_Panel_Categories.numTabs do
		--createTab(Parent,Index,Name)
		createTab(PA_Panel_Categories,i,PA_Panel_Categories.subFrames[i])
	end
	
	updatePanel(PA_Panel_Categories)
	PA_Panel_Categories:HookScript("OnShow",updatePanel)
	
	-- Main panel
	
	-- title
	--createFonttext(Parent, Positionx, Positiony, text, template)
	createFonttext(PA_Panel_Categories_Main, 15, -15, "Profession Assistance", "GameFontNormalLarge")
	
	-- content
	createFonttext(PA_Panel_Categories_Main, 20, -80, "|cffffcc00Version|r     "..GetAddOnMetadata("Profession_Assistance","Version"), "GameFontHighlight")
	createFonttext(PA_Panel_Categories_Main, 20, -95, "|cffffcc00Notes|r       "..GetAddOnMetadata("Profession_Assistance","Notes"), "GameFontHighlight")
	createFonttext(PA_Panel_Categories_Main, 20, -125, "|cffffcc00Author|r     "..GetAddOnMetadata("Profession_Assistance","Author"), "GameFontHighlight")
	createFonttext(PA_Panel_Categories_Main, 20, -140, "|cffffcc00Credits|r     "..GetAddOnMetadata("Profession_Assistance","X-Credits"), "GameFontHighlight")
	
	-- Options panel
	
	-- title
	createFonttext(PA_Panel_Categories_Options, 15, -15, "Options", "GameFontNormalLarge")
	
	-- global
	createFonttext(PA_Panel_Categories_Options, 20, -60, "|cffffcc00Global|r", "GameFontNormalLarge")
	-- createCheckbutton(Parent, Positionx, positiony, label, description);
	MasterButton = createCheckbutton(PA_Panel_Categories_Options, 15, -80, "Master", "Enabled", "Master switch");
	MasterButton:SetChecked(PA_SavedSettings["MasterChecked"])
	
	-- Minimap
	createFonttext(PA_Panel_Categories_Options, 20, -140, "|cffffcc00Minimap Button|r", "GameFontNormalLarge")
	MinimapButton = createCheckbutton(PA_Panel_Categories_Options, 15, -160, "Minimap", "Enabled", "Toggle minimap button");
	MinimapButton:SetChecked(PA_SavedSettings["MinimapChecked"])
	
	-- Milling
	createFonttext(PA_Panel_Categories_Options, 320, -60, "|cffffcc00Milling|r", "GameFontNormalLarge")	
	MillingButton = createCheckbutton(PA_Panel_Categories_Options, 315, -80, "Milling", "Enable Milling", "Toggle milling information on herbs");
	MillingButton:SetChecked(PA_SavedSettings["MillingChecked"])
	MillingBind = PA_CreateBB(PA_Panel_Categories_Options, 450, -133, "Milling")
	
	createFonttext(PA_Panel_Categories_Options, 320, -115, "Shown when: ", "GameFontNormalSmall")
	PA_CreateMenu(PA_Panel_Categories_Options, 305, -130, "Milling", "Appearance control: ","Select one option to make it appear on keyhold or just always");
	UIDropDownMenu_SetSelectedID(PA_interface_dropdownmenu_Milling, PA_SavedSettings["MillingKey"])
	
	HerbButton = createCheckbutton(PA_Panel_Categories_Options, 315, -170, "Herb", "Enable Herb", "Toggle herb information on pigments");
	HerbButton:SetChecked(PA_SavedSettings["HerbChecked"])
	HerbBind = PA_CreateBB(PA_Panel_Categories_Options, 450, -223, "Herb")
	
	createFonttext(PA_Panel_Categories_Options, 320, -205, "Shown when: ", "GameFontNormalSmall")
	PA_CreateMenu(PA_Panel_Categories_Options, 305, -220, "Herb", "Appearance control: ","Select one option to make it appear on keyhold or just always");
	UIDropDownMenu_SetSelectedID(PA_interface_dropdownmenu_Herb, PA_SavedSettings["HerbKey"])
	
	-- Prospecting
	createFonttext(PA_Panel_Categories_Options, 20, -280, "|cffffcc00Prospecting|r", "GameFontNormalLarge")
	ProspectingButton = createCheckbutton(PA_Panel_Categories_Options, 15, -300, "Prospecting", "Enable Prospecting", "Toggle prospecting information on ores");
	ProspectingButton:SetChecked(PA_SavedSettings["ProspectingChecked"])
	ProspectingBind = PA_CreateBB(PA_Panel_Categories_Options, 150, -353, "Prospecting")
	
	createFonttext(PA_Panel_Categories_Options, 20, -335, "Shown when: ", "GameFontNormalSmall")
	PA_CreateMenu(PA_Panel_Categories_Options, 5, -350, "Prospecting", "Appearance control", "Select one option to make it appear on keyhold or just always")
	UIDropDownMenu_SetSelectedID(PA_interface_dropdownmenu_Prospecting, PA_SavedSettings["ProspectingKey"])
	
	OreButton = createCheckbutton(PA_Panel_Categories_Options, 15, -390, "Ore", "Enable Ore", "Toggle ore information on gems");
	OreButton:SetChecked(PA_SavedSettings["OreChecked"])
	OreBind = PA_CreateBB(PA_Panel_Categories_Options, 150, -448, "Ore")
	
	createFonttext(PA_Panel_Categories_Options, 20, -425, "Shown when: ", "GameFontNormalSmall")
	PA_CreateMenu(PA_Panel_Categories_Options, 5, -445, "Ore", "Appearance control", "Select one option to make it appear on keyhold or just always")
	UIDropDownMenu_SetSelectedID(PA_interface_dropdownmenu_Ore, PA_SavedSettings["OreKey"])
	
	-- Enchanting
	createFonttext(PA_Panel_Categories_Options, 320, -280, "|cffffcc00Enchanting|r", "GameFontNormalLarge")
	EnchantingButton = createCheckbutton(PA_Panel_Categories_Options, 315, -300, "Enchanting", "Enable Enchanting", "Toggle enchanting information on gear");
	EnchantingButton:SetChecked(PA_SavedSettings["EnchantingChecked"])
	EnchantingBind = PA_CreateBB(PA_Panel_Categories_Options, 450, -353, "Enchanting")
	
	createFonttext(PA_Panel_Categories_Options, 320, -335, "Shown when: ", "GameFontNormalSmall")
	PA_CreateMenu(PA_Panel_Categories_Options, 305, -350, "Enchanting", "Appearance control", "Select one option to make it appear on keyhold or just always")
	UIDropDownMenu_SetSelectedID(PA_interface_dropdownmenu_Enchanting, PA_SavedSettings["EnchantingKey"])
	
	MaterialButton = createCheckbutton(PA_Panel_Categories_Options, 315, -390, "Material", "Enable Materials", "Toggle gear source information on enchanting materials");
	MaterialButton:SetChecked(PA_SavedSettings["MaterialChecked"])
	MaterialBind = PA_CreateBB(PA_Panel_Categories_Options, 450, -448, "Material")
	
	createFonttext(PA_Panel_Categories_Options, 320, -425, "Shown when: ", "GameFontNormalSmall")
	PA_CreateMenu(PA_Panel_Categories_Options, 305, -445, "Material", "Appearance control", "Select one option to make it appear on keyhold or just always")
	UIDropDownMenu_SetSelectedID(PA_interface_dropdownmenu_Material, PA_SavedSettings["MaterialKey"])
	
	---------------------------
	-- Changing settings part --
	---------------------------
	-- Master button
	MasterButton:SetScript("OnClick", function() if(MasterButton:GetChecked()) then PA_ButtonControl("Master","Enable") else PA_ButtonControl("Master","Disable") end end);
	--PA_ButtonControl(ButtonName,state)
	if(PA_SavedSettings["MasterChecked"])then PA_ButtonControl("Master","startup") else PA_ButtonControl("Master","startup2") end
	
	local oldKey="";
	
	-- Milling stuff
	MillingButton:SetScript("OnClick", function() if(MillingButton:GetChecked()) then PA_ButtonControl("Milling","Enable") else PA_ButtonControl("Milling","Disable") end end);
	MillingID = PA_SavedSettings["MillingKey"]
	if(MillingID>=5 and MillingButton:GetChecked()) then MillingBind:Enable() else MillingBind:Disable() end
	
	MillingBind:SetScript("OnMouseDown", function(self, button)
		if(MillingBind:IsEnabled()) then
			if(button == "LeftButton") then
				if(MillingBind:GetText() == "?") then
					MillingBind:EnableKeyboard(false)
					MillingBind:SetText(oldKey)
				else
					MillingBind:EnableKeyboard(true)
					oldKey = MillingBind:GetText()
					MillingBind:SetText("?")
				end
			else
				PA_Bind(MillingBB, MillingBind, true, "Enable")
				MillingBind:SetText("Not Bound")
				PA_SavedSettings["MillingBind"] = MillingBind:GetText()
			end
		end
	end);
	local MillingBB = CreateFrame("BUTTON", "MillingBB")
	MillingBind:SetScript("OnKeyUp", function(self,key)
		if(MillingBind:IsEnabled()) then
			if(IsShiftKeyDown()) then
				MillingBind:SetText("SHIFT-"..key)
				MillingBind:EnableKeyboard(false)
			end
			if(IsControlKeyDown()) then
				MillingBind:SetText("CTRL-"..key)
				MillingBind:EnableKeyboard(false)
			end
			if(IsAltKeyDown()) then
				MillingBind:SetText("ALT-"..key)
				MillingBind:EnableKeyboard(false)
			end
			if(not IsModifierKeyDown()) then
				MillingBind:SetText(key)
				MillingBind:EnableKeyboard(false)
			end
			if(key == "ESCAPE") then
				MillingBind:SetText(oldKey);
				MillingBind:EnableKeyboard(false)
			else
				PA_Bind(MillingBB, MillingBind, false, "Enable")
				PA_SavedSettings["MillingBind"] = MillingBind:GetText()
			end
		end
	end);
	MillingBind:EnableKeyboard(false)
	
	MillingBB:SetScript("OnMouseDown", function(self, button) MillingID=6 end)
	MillingBB:SetScript("OnMouseUp", function(self, button) MillingID=5 end)
	
	MillingBind:SetText(PA_SavedSettings["MillingBind"])
	if(PA_SavedSettings["MillingBind"]~="Not Bound" and MillingBind:IsEnabled()) then PA_Bind(MillingBB, MillingBind, false, "Enable")end
	
	
	HerbButton:SetScript("OnClick", function() if(HerbButton:GetChecked()) then PA_ButtonControl("Herb","Enable") else PA_ButtonControl("Herb","Disable") end end);
	HerbID = PA_SavedSettings["HerbKey"]
	if(HerbID>=5 and HerbButton:GetChecked()) then HerbBind:Enable() else HerbBind:Disable() end
	
	HerbBind:SetScript("OnMouseDown", function(self, button)
		if(HerbBind:IsEnabled()) then
			if(button == "LeftButton") then
				if(HerbBind:GetText() == "?") then
					HerbBind:EnableKeyboard(false)
					HerbBind:SetText(oldKey)
				else
					HerbBind:EnableKeyboard(true)
					oldKey = HerbBind:GetText()
					HerbBind:SetText("?")
				end
			else
				PA_Bind(HerbBB, HerbBind, true, "Enable")
				HerbBind:SetText("Not Bound")
				PA_SavedSettings["HerbBind"] = HerbBind:GetText()
			end
		end
	end);
	local HerbBB = CreateFrame("BUTTON", "HerbBB")
	HerbBind:SetScript("OnKeyUp", function(self,key)
		if(HerbBind:IsEnabled()) then
			if(IsShiftKeyDown()) then
				HerbBind:SetText("SHIFT-"..key)
				HerbBind:EnableKeyboard(false)
			end
			if(IsControlKeyDown()) then
				HerbBind:SetText("CTRL-"..key)
				HerbBind:EnableKeyboard(false)
			end
			if(IsAltKeyDown()) then
				HerbBind:SetText("ALT-"..key)
				HerbBind:EnableKeyboard(false)
			end
			if(not IsModifierKeyDown()) then
				HerbBind:SetText(key)
				HerbBind:EnableKeyboard(false)
			end
			if(key == "ESCAPE") then
				HerbBind:SetText(oldKey);
				HerbBind:EnableKeyboard(false)
			else
				PA_Bind(HerbBB, HerbBind, false, "Enable")
				PA_SavedSettings["HerbBind"] = HerbBind:GetText()
			end
		end
	end);
	HerbBind:EnableKeyboard(false)
	
	HerbBB:SetScript("OnMouseDown", function(self, button) HerbID=6 end)
	HerbBB:SetScript("OnMouseUp", function(self, button) HerbID=5 end)
	
	HerbBind:SetText(PA_SavedSettings["HerbBind"])
	if(PA_SavedSettings["HerbBind"]~="Not Bound" and HerbBind:IsEnabled()) then PA_Bind(HerbBB, HerbBind, false, "Enable") end
	
	
	-- Prospecting stuff
	ProspectingButton:SetScript("OnClick", function() if(ProspectingButton:GetChecked()) then PA_ButtonControl("Prospecting","Enable") else PA_ButtonControl("Prospecting","Disable") end end);
	ProspectingID = PA_SavedSettings["ProspectingKey"]
	if(ProspectingID>=5 and ProspectingButton:GetChecked()) then ProspectingBind:Enable() else ProspectingBind:Disable() end
	
	ProspectingBind:SetScript("OnMouseDown", function(self, button)
		if(ProspectingBind:IsEnabled()) then
			if(button == "LeftButton") then
				if(ProspectingBind:GetText() == "?") then
					ProspectingBind:EnableKeyboard(false)
					ProspectingBind:SetText(oldKey)
				else
					ProspectingBind:EnableKeyboard(true)
					oldKey = ProspectingBind:GetText()
					ProspectingBind:SetText("?")
				end
			else
				PA_Bind(ProspectingBB, ProspectingBind, true, "Enable")
				ProspectingBind:SetText("Not Bound")
				PA_SavedSettings["ProspectingBind"] = ProspectingBind:GetText()
			end
		end
	end);
	local ProspectingBB = CreateFrame("BUTTON", "ProspectingBB")
	ProspectingBind:SetScript("OnKeyUp", function(self,key)
		if(ProspectingBind:IsEnabled()) then
			if(IsShiftKeyDown()) then
				ProspectingBind:SetText("SHIFT-"..key)
				ProspectingBind:EnableKeyboard(false)
			end
			if(IsControlKeyDown()) then
				ProspectingBind:SetText("CTRL-"..key)
				ProspectingBind:EnableKeyboard(false)
			end
			if(IsAltKeyDown()) then
				ProspectingBind:SetText("ALT-"..key)
				ProspectingBind:EnableKeyboard(false)
			end
			if(not IsModifierKeyDown()) then
				ProspectingBind:SetText(key)
				ProspectingBind:EnableKeyboard(false)
			end
			if(key == "ESCAPE") then
				ProspectingBind:SetText(oldKey);
				ProspectingBind:EnableKeyboard(false)
			else
				PA_Bind(ProspectingBB, ProspectingBind, false, "Enable")
				PA_SavedSettings["ProspectingBind"] = ProspectingBind:GetText()
			end
		end
	end);
	ProspectingBind:EnableKeyboard(false)
	
	ProspectingBB:SetScript("OnMouseDown", function(self, button) ProspectingID=6 end)
	ProspectingBB:SetScript("OnMouseUp", function(self, button) ProspectingID=5 end)
	
	ProspectingBind:SetText(PA_SavedSettings["ProspectingBind"])
	if(PA_SavedSettings["ProspectingBind"]~="Not Bound" and ProspectingBind:IsEnabled()) then PA_Bind(ProspectingBB, ProspectingBind, false, "Enable") end
	
	
	OreButton:SetScript("OnClick", function() if(OreButton:GetChecked()) then PA_ButtonControl("Ore","Enable") else PA_ButtonControl("Ore","Disable") end end);
	OreID = PA_SavedSettings["OreKey"]
	if(OreID>=5 and OreButton:GetChecked()) then OreBind:Enable() else OreBind:Disable() end
	
	OreBind:SetScript("OnMouseDown", function(self, button)
		if(OreBind:IsEnabled()) then
			if(button == "LeftButton") then
				if(OreBind:GetText() == "?") then
					OreBind:EnableKeyboard(false)
					OreBind:SetText(oldKey)
				else
					OreBind:EnableKeyboard(true)
					oldKey = OreBind:GetText()
					OreBind:SetText("?")
				end
			else
				PA_Bind(OreBB, OreBind, true, "Enable")
				OreBind:SetText("Not Bound")
				PA_SavedSettings["OreBind"] = OreBind:GetText()
			end
		end
	end);
	local OreBB = CreateFrame("BUTTON", "OreBB")
	OreBind:SetScript("OnKeyUp", function(self,key)
		if(OreBind:IsEnabled()) then
			if(IsShiftKeyDown()) then
				OreBind:SetText("SHIFT-"..key)
				OreBind:EnableKeyboard(false)
			end
			if(IsControlKeyDown()) then
				OreBind:SetText("CTRL-"..key)
				OreBind:EnableKeyboard(false)
			end
			if(IsAltKeyDown()) then
				OreBind:SetText("ALT-"..key)
				OreBind:EnableKeyboard(false)
			end
			if(not IsModifierKeyDown()) then
				OreBind:SetText(key)
				OreBind:EnableKeyboard(false)
			end
			if(key == "ESCAPE") then
				OreBind:SetText(oldKey);
				OreBind:EnableKeyboard(false)
			else
				PA_Bind(OreBB, OreBind, false, "Enable")
				PA_SavedSettings["OreBind"] = OreBind:GetText()
			end
		end
	end);
	OreBind:EnableKeyboard(false)
	
	OreBB:SetScript("OnMouseDown", function(self, button) OreID=6 end)
	OreBB:SetScript("OnMouseUp", function(self, button) OreID=5 end)
	
	OreBind:SetText(PA_SavedSettings["OreBind"])
	if(PA_SavedSettings["OreBind"]~="Not Bound" and OreBind:IsEnabled()) then PA_Bind(OreBB, OreBind, false, "Enable") end
	
	
	-- Enchanting stuff
	EnchantingButton:SetScript("OnClick", function() if(EnchantingButton:GetChecked()) then PA_ButtonControl("Enchanting","Enable") else PA_ButtonControl("Enchanting","Disable") end end);
	EnchantingID = PA_SavedSettings["EnchantingKey"]
	if(EnchantingID>=5 and EnchantingButton:GetChecked()) then EnchantingBind:Enable() else EnchantingBind:Disable() end
	
	EnchantingBind:SetScript("OnMouseDown", function(self, button)
		if(EnchantingBind:IsEnabled()) then
			if(button == "LeftButton") then
				if(EnchantingBind:GetText() == "?") then
					EnchantingBind:EnableKeyboard(false)
					EnchantingBind:SetText(oldKey)
				else
					EnchantingBind:EnableKeyboard(true)
					oldKey = EnchantingBind:GetText()
					EnchantingBind:SetText("?")
				end
			else
				PA_Bind(EnchantingBB, EnchantingBind, true, "Enable")
				EnchantingBind:SetText("Not Bound")
				PA_SavedSettings["EnchantingBind"] = EnchantingBind:GetText()
			end
		end
	end);
	local EnchantingBB = CreateFrame("BUTTON", "EnchantingBB")
	EnchantingBind:SetScript("OnKeyUp", function(self,key)
		if(EnchantingBind:IsEnabled()) then
			if(IsShiftKeyDown()) then
				EnchantingBind:SetText("SHIFT-"..key)
				EnchantingBind:EnableKeyboard(false)
			end
			if(IsControlKeyDown()) then
				EnchantingBind:SetText("CTRL-"..key)
				EnchantingBind:EnableKeyboard(false)
			end
			if(IsAltKeyDown()) then
				EnchantingBind:SetText("ALT-"..key)
				EnchantingBind:EnableKeyboard(false)
			end
			if(not IsModifierKeyDown()) then
				EnchantingBind:SetText(key)
				EnchantingBind:EnableKeyboard(false)
			end
			if(key == "ESCAPE") then
				EnchantingBind:SetText(oldKey);
				EnchantingBind:EnableKeyboard(false)
			else
				PA_Bind(EnchantingBB, EnchantingBind, false, "Enable")
				PA_SavedSettings["EnchantingBind"] = EnchantingBind:GetText()
			end
		end
	end);
	EnchantingBind:EnableKeyboard(false)
	
	EnchantingBB:SetScript("OnMouseDown", function(self, button) EnchantingID=1 end)
	EnchantingBB:SetScript("OnMouseUp", function(self, button) EnchantingID=5 end)
	
	EnchantingBind:SetText(PA_SavedSettings["EnchantingBind"])
	if(EnchantingBind:GetText()~="Not Bound" and EnchantingBind:IsEnabled()) then PA_Bind(EnchantingBB, EnchantingBind, false, "Enable") end
	
	MaterialButton:SetScript("OnClick", function() if(MaterialButton:GetChecked()) then PA_ButtonControl("Material","Enable") else PA_ButtonControl("Material","Disable") end end);
	MaterialID = PA_SavedSettings["MaterialKey"]
	if(MaterialID>=5 and MaterialButton:GetChecked()) then MaterialBind:Enable() else MaterialBind:Disable() end
	
	MaterialBind:SetScript("OnMouseDown", function(self, button)
		if(MaterialBind:IsEnabled()) then
			if(button == "LeftButton") then
				if(MaterialBind:GetText() == "?") then
					MaterialBind:EnableKeyboard(false)
					MaterialBind:SetText(oldKey)
				else
					MaterialBind:EnableKeyboard(true)
					oldKey = MaterialBind:GetText()
					MaterialBind:SetText("?")
				end
			else
				PA_Bind(MaterialBB, MaterialBind, true, "Enable")
				MaterialBind:SetText("Not Bound")
				PA_SavedSettings["MaterialBind"] = MaterialBind:GetText()
			end
		end
	end);
	local MaterialBB = CreateFrame("BUTTON", "MaterialBB")
	MaterialBind:SetScript("OnKeyUp", function(self,key)
		if(MaterialBind:IsEnabled()) then
			if(IsShiftKeyDown()) then
				MaterialBind:SetText("SHIFT-"..key)
				MaterialBind:EnableKeyboard(false)
			end
			if(IsControlKeyDown()) then
				MaterialBind:SetText("CTRL-"..key)
				MaterialBind:EnableKeyboard(false)
			end
			if(IsAltKeyDown()) then
				MaterialBind:SetText("ALT-"..key)
				MaterialBind:EnableKeyboard(false)
			end
			if(not IsModifierKeyDown()) then
				MaterialBind:SetText(key)
				MaterialBind:EnableKeyboard(false)
			end
			if(key == "ESCAPE") then
				MaterialBind:SetText(oldKey);
				MaterialBind:EnableKeyboard(false)
			else
				PA_Bind(MaterialBB, MaterialBind, false, "Enable")
				PA_SavedSettings["MaterialBind"] = MaterialBind:GetText()
			end
		end
	end);
	MaterialBind:EnableKeyboard(false)
	
	MaterialBB:SetScript("OnMouseDown", function(self, button) MaterialID=6 end)
	MaterialBB:SetScript("OnMouseUp", function(self, button) MaterialID=5 end)
	
	MaterialBind:SetText(PA_SavedSettings["MaterialBind"])
	if(PA_SavedSettings["MaterialBind"]~="Not Bound" and MaterialBind:IsEnabled()) then PA_Bind(MaterialBB, MaterialBind, false, "Enable") end
	
	-- Minimap button
	PA_Minimap_Create()
end);