-------------------
-- General stuff --
-------------------
T_Quality = {
	"|cff1eff00", -- Uncommon
	"|cff0070dd", -- Rare
	"|cffa335ee" -- Epic
}

-----------------------
-- General stuff end --
-----------------------

---------------
-- Herb info --
---------------

T_Pigments = {
	-- Pandaria pigments --
	["79251"] = { -- Shadow Pigment
		[1] = {Icon["Mop"]..Skill["Mop"][2]};
		[2] = {1,2,3,4,5,6, T_Text[1]};
	};
	["79253"] = { -- Misty Pigment
		[1] = {Icon["Mop"]..Skill["Mop"][2]};
		[2] = {1, T_Text[3]};
		[3] = {2,3,4,5,6, T_Text[5]};
	};
	
	-- Cataclysm pigments --	
	["61979"] = { -- Ashen Pigment
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 475"};
		[2] = {7,8,9,10,11,12, T_Text[1]};
	};
	["61980"] = { -- Burning Embers
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 475"};
		[2] = {7,8, T_Text[3]};
		[3] = {9,10,11,12, T_Text[5]};
	};
	
	-- Wrath of the Lich King pigments --
	["39343"] = { -- Azure Pigment
		[1] = {Icon["Wrath"]..Skill["Wrath"][1]};
		[2] = {13,14,15,16,17,18,19,20, T_Text[1]};
	};
	["43109"] = { -- Icy Pigment
		[1] = {Icon["Wrath"]..Skill["Wrath"][1]};
		[2] = {13,14,15, T_Text[3]};
		[3] = {16,17,18,19,20, T_Text[5]};
	};
	
	-- The Burning Crusade pigments --
	["39342"] = { -- Nether Pigment
		[1] = {Icon["Bc"]..Skill["Bc"][2]};
		[2] = {21,22,23,24,25,26,27,28, T_Text[1]};
	};
	["43108"] = { -- Ebon Pigment
		[1] = {Icon["Bc"]..Skill["Bc"][2]};
		[2] = {21,22,23,24, T_Text[3]};
		[3] = {25,26,27,28, T_Text[5]};
	};
	
	-- Vanilla pigments (Skill: 225) --
	["39341"] = { -- Silvery Pigment
		[1] = {Skill["Van"][11]};
		[2] = {29,30,31,32,33, T_Text[1]};
	};
	["43107"] = { -- Sapphire Pigment
		[1] = {Skill["Van"][11]};
		[2] = {29,30,31, T_Text[3]};
		[3] = {32,33, T_Text[5]};
	};
	
	-- Vanilla pigments (Skill: 175) --
	["39340"] = { -- Violet Pigment
		[1] = {Skill["Van"][9]};
		[2] = {34,35,36,37,38,39,40, T_Text[1]};
	};
	["43106"] = { -- Ruby Pigment
		[1] = {Skill["Van"][9]};
		[2] = {34,35,36, T_Text[3]};
		[3] = {37,38,39,40, T_Text[5]};
	};
	
	-- Vanilla pigments (Skill: 125) --
	["39339"] = { -- Emerald Pigment
		[1] = {Skill["Van"][7]};
		[2] = {41,42,43,44, T_Text[1]};
	};
	["43105"] = { -- Indigo Pigment
		[1] = {Skill["Van"][7]};
		[2] = {41,42, T_Text[3]};
		[3] = {43,44, T_Text[5]};
	};
	
	-- Vanilla pigments (Skill: 75) --
	["39338"] = { -- Golden Pigment
		[1] = {Skill["Van"][5]};
		[2] = {45,46,47,48, T_Text[1]};
	};
	["43104"] = { -- Burnt Pigments
		[1] = {Skill["Van"][5]};
		[2] = {45,46, T_Text[3]};
		[3] = {47,48, T_Text[5]};
	};
	
	-- Vanilla pigments (Skill: 25) --
	["39334"] = { -- Dusky Pigment
		[1] = {Skill["Van"][3]};
		[2] = {49,50,51,52,53, T_Text[1]};
	};
	["43103"]	= { -- Verdant Pigment
		[1] = {Skill["Van"][3]};
		[2] = {49,50, T_Text[3]};
		[3] = {51,52,53, T_Text[5]};
	};
	
	-- Vanilla pigments (Skill: 1) --
	["39151"] = { -- Alabaster Pigment
		[1] = {Skill["Van"][1]};
		[2] = {54,55,56, T_Text[1]};
	};
}

T_Herb2 = {
	-- Pandaria herbs --
	"\124cffffffff\124Hitem:79011:0:0:0:0:0:0:0:0:0:0\124h[Fool's Cap]\124h\124r", -- Fool's Cap
	"\124cffffffff\124Hitem:72234:0:0:0:0:0:0:0:0:0:0\124h[Green Tea Leaf]\124h\124r", -- Green Tea Leaf
	"\124cffffffff\124Hitem:89639:0:0:0:0:0:0:0:0:0:0\124h[Desecrated Herb]\124h\124r", -- Desecrated Herb
	"\124cffffffff\124Hitem:72237:0:0:0:0:0:0:0:0:0:0\124h[Rain Poppy]\124h\124r", -- Rain Poppy
	"\124cffffffff\124Hitem:72235:0:0:0:0:0:0:0:0:0:0\124h[Silkweed]\124h\124r", -- Silkweed
	"\124cffffffff\124Hitem:79010:0:0:0:0:0:0:0:0:0:0\124h[Snow Lily]\124h\124r", -- Snow Lily
	
	-- Cataclysm herbs --
	"\124cffffffff\124Hitem:52987:0:0:0:0:0:0:0:0:0:0\124h[Twilight Jasmine]\124h\124r", -- Twilight Jasmine
	"\124cffffffff\124Hitem:52988:0:0:0:0:0:0:0:0:0:0\124h[Whiptail]\124h\124r", -- Whiptail
	"\124cffffffff\124Hitem:52984:0:0:0:0:0:0:0:0:0:0\124h[Stormvine]\124h\124r", -- Stormvine
	"\124cffffffff\124Hitem:52983:0:0:0:0:0:0:0:0:0:0\124h[Cinderbloom]\124h\124r", -- Cinderbloom
	"\124cffffffff\124Hitem:52986:0:0:0:0:0:0:0:0:0:0\124h[Heartblossom]\124h\124r", -- Heartblossom
	"\124cffffffff\124Hitem:52985:0:0:0:0:0:0:0:0:0:0\124h[Azshara's Veil]\124h\124r", -- Azshara's Veil
	
	-- Wrath of the Lich King herbs --
	"\124cffffffff\124Hitem:36903:0:0:0:0:0:0:0:0:0:0\124h[Adder's Tongue]\124h\124r", -- Adder's Tongue
	"\124cffffffff\124Hitem:36906:0:0:0:0:0:0:0:0:0:0\124h[Icethorn]\124h\124r", -- Icethorn
	"\124cffffffff\124Hitem:36905:0:0:0:0:0:0:0:0:0:0\124h[Lichbloom]\124h\124r", -- Lichbloom
	"\124cffffffff\124Hitem:37921:0:0:0:0:0:0:0:0:0:0\124h[Deadnettle]\124h\124r", -- Deadnettle
	"\124cffffffff\124Hitem:39970:0:0:0:0:0:0:0:0:0:0\124h[Fire Leaf]\124h\124r", -- Fire Leaf
	"\124cffffffff\124Hitem:36901:0:0:0:0:0:0:0:0:0:0\124h[Goldclover]\124h\124r", -- Goldclover
	"\124cffffffff\124Hitem:36907:0:0:0:0:0:0:0:0:0:0\124h[Talandra's Rose]\124h\124r", -- Talandra's Rose
	"\124cffffffff\124Hitem:36904:0:0:0:0:0:0:0:0:0:0\124h[Tiger Lily]\124h\124r", -- Tiger Lily
	
	-- The Burning Crusade herbs --
	"\124cffffffff\124Hitem:22790:0:0:0:0:0:0:0:0:0:0\124h[Ancient Lichen]\124h\124r", -- Ancient Lichen
	"\124cffffffff\124Hitem:22793:0:0:0:0:0:0:0:0:0:0\124h[Mana Thistle]\124h\124r", -- Mana Thistle
	"\124cffffffff\124Hitem:22791:0:0:0:0:0:0:0:0:0:0\124h[Netherbloom]\124h\124r", -- Netherbloom
	"\124cffffffff\124Hitem:22792:0:0:0:0:0:0:0:0:0:0\124h[Nightmare Vine]\124h\124r", -- Nightmare Vine
	"\124cffffffff\124Hitem:22786:0:0:0:0:0:0:0:0:0:0\124h[Dreaming Glory]\124h\124r", -- Dreaming Glory
	"\124cffffffff\124Hitem:22785:0:0:0:0:0:0:0:0:0:0\124h[Felweed]\124h\124r", -- Felweed
	"\124cffffffff\124Hitem:22787:0:0:0:0:0:0:0:0:0:0\124h[Ragveil]\124h\124r", -- Ragveil
	"\124cffffffff\124Hitem:22789:0:0:0:0:0:0:0:0:0:0\124h[Terocone]\124h\124r", -- Terocone
	
	-- Vanilla herbs (Skill: 225) --
	"\124cffffffff\124Hitem:13467:0:0:0:0:0:0:0:0:0:0\124h[Icecap]\124h\124r", -- Icecap
	"\124cffffffff\124Hitem:13465:0:0:0:0:0:0:0:0:0:0\124h[Mountain Silversage]\124h\124r", -- Mountain Silversage
	"\124cffffffff\124Hitem:13466:0:0:0:0:0:0:0:0:0:0\124h[Sorrowmoss]\124h\124r", -- Sorrowmoss
	"\124cffffffff\124Hitem:13464:0:0:0:0:0:0:0:0:0:0\124h[Golden Sansam]\124h\124r", -- Golden Sansam
	"\124cffffffff\124Hitem:13463:0:0:0:0:0:0:0:0:0:0\124h[Dreamfoil]\124h\124r", -- Dreamfoil
	
	-- Vanilla herbs (Skill: 175) --
	"\124cffffffff\124Hitem:8839:0:0:0:0:0:0:0:0:0:0\124h[Blindweed]\124h\124r", -- Blindweed
	"\124cffffffff\124Hitem:8845:0:0:0:0:0:0:0:0:0:0\124h[Ghost Mushroom]\124h\124r", -- Ghost Mushroom
	"\124cffffffff\124Hitem:8846:0:0:0:0:0:0:0:0:0:0\124h[Gromsblood]\124h\124r", -- Gromsblood
	"\124cffffffff\124Hitem:8831:0:0:0:0:0:0:0:0:0:0\124h[Purple Lotus]\124h\124r", -- Purple Lotus
	"\124cffffffff\124Hitem:4625:0:0:0:0:0:0:0:0:0:0\124h[Firebloom]\124h\124r", -- Firebloom
	"\124cffffffff\124Hitem:8838:0:0:0:0:0:0:0:0:0:0\124h[Sungrass]\124h\124r", -- Sungrass
	"\124cffffffff\124Hitem:8836:0:0:0:0:0:0:0:0:0:0\124h[Arthas' Tears]\124h\124r", -- Arthas' Tears
	
	-- Vanilla herbs (Skill: 125) --
	"\124cffffffff\124Hitem:3819:0:0:0:0:0:0:0:0:0:0\124h[Dragon's Teeth]\124h\124r", -- Dragon's Teeth
	"\124cffffffff\124Hitem:3358:0:0:0:0:0:0:0:0:0:0\124h[Khadgar's Whisker]\124h\124r", -- Khadgar's Whisker
	"\124cffffffff\124Hitem:3821:0:0:0:0:0:0:0:0:0:0\124h[Goldthorn]\124h\124r", -- Goldthorn
	"\124cffffffff\124Hitem:3818:0:0:0:0:0:0:0:0:0:0\124h[Fadeleaf]\124h\124r", -- Fadeleaf
	
	-- Vanilla herbs (Skill: 75) --
	"\124cffffffff\124Hitem:3357:0:0:0:0:0:0:0:0:0:0\124h[Liferoot]\124h\124r", -- Liferoot
	"\124cffffffff\124Hitem:3356:0:0:0:0:0:0:0:0:0:0\124h[Kingsblood]\124h\124r", -- Kingsblood
	"\124cffffffff\124Hitem:3369:0:0:0:0:0:0:0:0:0:0\124h[Grave Moss]\124h\124r", -- Grave Moss
	"\124cffffffff\124Hitem:3355:0:0:0:0:0:0:0:0:0:0\124h[Wild Steelbloom]\124h\124r", -- Wild Steelbloom
	
	-- Vanilla herbs (Skill: 25) --
	"\124cffffffff\124Hitem:2453:0:0:0:0:0:0:0:0:0:0\124h[Bruiseweed]\124h\124r", -- Bruiseweed
	"\124cffffffff\124Hitem:3820:0:0:0:0:0:0:0:0:0:0\124h[Stranglekelp]\124h\124r", -- Stranglekelp
	"\124cffffffff\124Hitem:2450:0:0:0:0:0:0:0:0:0:0\124h[Briarthorn]\124h\124r", -- Brairthorn
	"\124cffffffff\124Hitem:785:0:0:0:0:0:0:0:0:0:0\124h[Mageroyal]\124h\124r", -- Mageroyal
	"\124cffffffff\124Hitem:2452:0:0:0:0:0:0:0:0:0:0\124h[Swiftthistle]\124h\124r", -- Swifthistle
	
	-- Vanilla herbs (Skill: 1) --
	"\124cffffffff\124Hitem:2449:0:0:0:0:0:0:0:0:0:0\124h[Earthroot]\124h\124r", -- Earthroot
	"\124cffffffff\124Hitem:2447:0:0:0:0:0:0:0:0:0:0\124h[Peacebloom]\124h\124r", -- Peacebloom
	"\124cffffffff\124Hitem:765:0:0:0:0:0:0:0:0:0:0\124h[Silverleaf]\124h\124r" -- Silverleaf
}

-------------------
-- Herb info end --
-------------------

---------------
-- Ores info --
---------------

T_Gems = {
	-- Pandaria gems --
	["90407"] = { -- Sparkling Shard
		[1] = {Icon["Mop"]..Skill["Mop"][2].." - 600"};
		[2] = {1,2,3, T_Text[1]};
		[3] = {4, T_Text[2]};
	};
	["76134"] = { -- Sunstone
		[1] = {Icon["Mop"]..Skill["Mop"][2].." - 600"};
		[2] = {1,2,3, T_Text[1]};
		[3] = {4, T_Text[2]};
	};
	["76136"] = { -- Pandarian Garnet
		[1] = {Icon["Mop"]..Skill["Mop"][2].." - 600"};
		[2] = {1,2,3, T_Text[1]};
		[3] = {4, T_Text[2]};
	};
	["76137"] = { -- Alexandrite
		[1] = {Icon["Mop"]..Skill["Mop"][2].." - 600"};
		[2] = {1,2,3, T_Text[1]};
		[3] = {4, T_Text[2]};
	};
	["76133"] = { -- Lapis Lazuli
		[1] = {Icon["Mop"]..Skill["Mop"][2].." - 600"};
		[2] = {1,2,3, T_Text[1]};
		[3] = {4, T_Text[2]};
	};
	["76130"] = { -- Tiger Opal
		[1] = {Icon["Mop"]..Skill["Mop"][2].." - 600"};
		[2] = {1,2,3, T_Text[1]};
		[3] = {4, T_Text[2]};
	};
	["76135"] = { -- Roguestone
		[1] = {Icon["Mop"]..Skill["Mop"][2].." - 600"};
		[2] = {1,2,3, T_Text[1]};
		[3] = {4, T_Text[2]};
	};
	["76141"] = { -- Imperial Amethyst
		[1] = {Icon["Mop"]..Skill["Mop"][2].." - 600"};
		[2] = {1,2, T_Text[6]};
		[3] = {3,4, T_Text[7]};
	};
	["76138"] = { -- River's Heart
		[1] = {Icon["Mop"]..Skill["Mop"][2].." - 600"};
		[2] = {1,2, T_Text[6]};
		[3] = {3,4, T_Text[7]};
	};
	["76142"] = { -- Sun's Radiance
		[1] = {Icon["Mop"]..Skill["Mop"][2].." - 600"};
		[2] = {1,2, T_Text[6]};
		[3] = {3,4, T_Text[7]};
	};
	["76139"] = { -- Wild Jade
		[1] = {Icon["Mop"]..Skill["Mop"][2].." - 600"};
		[2] = {1,2, T_Text[6]};
		[3] = {3,4, T_Text[7]};
	};
	["76131"] = { -- Primordial Ruby
		[1] = {Icon["Mop"]..Skill["Mop"][2].." - 600"};
		[2] = {1,2, T_Text[6]};
		[3] = {3,4, T_Text[7]};
	};
	["76140"] = { -- Vermilion Onyx
		[1] = {Icon["Mop"]..Skill["Mop"][2].." - 600"};
		[2] = {1,2, T_Text[6]};
		[3] = {3,4, T_Text[7]};
	};
	
	-- Cataclysm gems --
	["52327"] = { -- Volatile Earth
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 500"};
		[2] = {5, T_Text[1]};
	};
	["52181"] = { -- Hessonite
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 500"};
		[2] = {7, T_Text[5]};
		[3] = {5,6, T_Text[6]};
	};
	["52178"] = { -- Zephyrite
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 500"};
		[2] = {7, T_Text[5]};
		[3] = {5,6, T_Text[6]};
	};
	["52177"] = { -- Carnelian
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 500"};
		[2] = {7, T_Text[5]};
		[3] = {5,6, T_Text[6]};
	};
	["52180"] = { -- Nightstone
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 500"};
		[2] = {7, T_Text[5]};
		[3] = {5,6, T_Text[6]};
	};
	["52182"] = { -- Jasper
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 500"};
		[2] = {7, T_Text[5]};
		[3] = {5,6, T_Text[6]};
	};
	["52179"] = { -- Alicite
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 500"};
		[2] = {7, T_Text[5]};
		[3] = {5,6, T_Text[6]};
	};
	["52192"] = { -- Dream Emerald
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 500"};
		[2] = {5,6, T_Text[7]};
		[3] = {7, T_Text[8]};
	};
	["52190"] = { -- Inferno Ruby
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 500"};
		[2] = {5,6, T_Text[7]};
		[3] = {7, T_Text[8]};
	};
	["52195"] = { -- Amberjewel
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 500"};
		[2] = {5,6, T_Text[7]};
		[3] = {7, T_Text[8]};
	};
	["52194"] = { -- Demonseye
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 500"};
		[2] = {5,6, T_Text[7]};
		[3] = {7, T_Text[8]};
	};
	["52193"] = { -- Ember Topaz
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 500"};
		[2] = {5,6, T_Text[7]};
		[3] = {7, T_Text[8]};
	};
	["52191"] = { -- Ocean Sapphire
		[1] = {Icon["Cata"]..Skill["Cata"][1].." - 500"};
		[2] = {5,6, T_Text[7]};
		[3] = {7, T_Text[8]};
	};
	
	-- Wrath of the Lich King gems --
	["36926"] = { -- Shadow Crystal
		[1] = {Icon["Wrath"]..Skill["Wrath"][2].." - 450"};
		[2] = {10,8, T_Text[5]};
		[3] = {9, T_Text[6]};
	};
	["36929"] = { -- Huge Citrine
		[1] = {Icon["Wrath"]..Skill["Wrath"][2].." - 450"};
		[2] = {10,8, T_Text[5]};
		[3] = {9, T_Text[6]};
	};
	["36923"] = { -- Chalcedony
		[1] = {Icon["Wrath"]..Skill["Wrath"][2].." - 450"};
		[2] = {10,8, T_Text[5]};
		[3] = {9, T_Text[6]};
	};
	["36917"] = { -- Bloodstone
		[1] = {Icon["Wrath"]..Skill["Wrath"][2].." - 450"};
		[2] = {10,8, T_Text[5]};
		[3] = {9, T_Text[6]};
	};
	["36932"] = { -- Dark Jade
		[1] = {Icon["Wrath"]..Skill["Wrath"][2].." - 450"};
		[2] = {10,8, T_Text[5]};
		[3] = {9, T_Text[6]};
	};
	["36920"] = { -- Sun Crystal
		[1] = {Icon["Wrath"]..Skill["Wrath"][2].." - 450"};
		[2] = {10,8, T_Text[5]};
		[3] = {9, T_Text[6]};
	};
	["36930"] = { -- Monarch Topaz
		[1] = {Icon["Wrath"]..Skill["Wrath"][2].." - 450"};
		[2] = {8,9, T_Text[7]};
		[3] = {10, T_Text[8]};
	};
	["36933"] = { -- Forest Emerald
		[1] = {Icon["Wrath"]..Skill["Wrath"][2].." - 450"};
		[2] = {8,9, T_Text[7]};
		[3] = {10, T_Text[8]};
	};
	["36924"] = { -- Sky Sapphire
		[1] = {Icon["Wrath"]..Skill["Wrath"][2].." - 450"};
		[2] = {8,9, T_Text[7]};
		[3] = {10, T_Text[8]};
	};
	["36921"] = { -- Autumn's Glow
		[1] = {Icon["Wrath"]..Skill["Wrath"][2].." - 450"};
		[2] = {8,9, T_Text[7]};
		[3] = {10, T_Text[8]};
	};
	["36918"] = { -- Scarlet Ruby
		[1] = {Icon["Wrath"]..Skill["Wrath"][2].." - 450"};
		[2] = {8,9, T_Text[7]};
		[3] = {10, T_Text[8]};
	};
	["36927"] = { -- Twilight Opal
		[1] = {Icon["Wrath"]..Skill["Wrath"][2].." - 450"};
		[2] = {8,9, T_Text[7]};
		[3] = {10, T_Text[8]};
	};
	["36931"] = { -- Ametrine
		[1] = {Icon["Wrath"]..Skill["Wrath"][5]};
		[2] = {8, T_Text[7]};
	};
	["36934"] = { -- Eye of Zul
		[1] = {Icon["Wrath"]..Skill["Wrath"][5]};
		[2] = {8, T_Text[7]};
	};
	["36922"] = { -- King's Amber
		[1] = {Icon["Wrath"]..Skill["Wrath"][5]};
		[2] = {8, T_Text[7]};
	};
	["36925"] = { -- Majestic Zircon
		[1] = {Icon["Wrath"]..Skill["Wrath"][5]};
		[2] = {8, T_Text[7]};
	};
	["36919"] = { -- Cardinal Ruby
		[1] = {Icon["Wrath"]..Skill["Wrath"][5]};
		[2] = {8, T_Text[7]};
	};
	["36928"] = { -- Dreadstone
		[1] = {Icon["Wrath"]..Skill["Wrath"][5]};
		[2] = {8, T_Text[7]};
	};
	
	-- The Burning Crusade gems --
	["24243"] = { -- Adamantite Powder
		[1] = {Icon["Bc"]..Skill["Bc"][4]};
		[2] = {11, T_Text[1]};
	};
	["23112"] = { -- Golden Draenite
		[1] = {Icon["Bc"]..Skill["Bc"][2].." - 325"};
		[2] = {11,12, T_Text[6]};
	};
	["23117"] = { -- Azure Moonstone
		[1] = {Icon["Bc"]..Skill["Bc"][2].." - 325"};
		[2] = {11,12, T_Text[6]};
	};
	["23077"] = { -- Blood Garnet
		[1] = {Icon["Bc"]..Skill["Bc"][2].." - 325"};
		[2] = {11,12, T_Text[6]};
	};
	["23079"] = { -- Deep Peridot
		[1] = {Icon["Bc"]..Skill["Bc"][2].." - 325"};
		[2] = {11,12, T_Text[6]};
	};
	["21929"] = { -- Flame Spessarite
		[1] = {Icon["Bc"]..Skill["Bc"][2].." - 325"};
		[2] = {11,12, T_Text[6]};
	};
	["23107"] = { -- Shadow Draenite
		[1] = {Icon["Bc"]..Skill["Bc"][2].." - 325"};
		[2] = {11,12, T_Text[6]};
	};
	["23439"] = { -- Noble Topaz
		[1] = {Icon["Bc"]..Skill["Bc"][2].." - 325"};
		[2] = {11, T_Text[7]};
		[3] = {12, T_Text[8]};
	};
	["23440"] = { -- Dawnstone
		[1] = {Icon["Bc"]..Skill["Bc"][2].." - 325"};
		[2] = {11, T_Text[7]};
		[3] = {12, T_Text[8]};
	};
	["23436"] = { -- Living Ruby
		[1] = {Icon["Bc"]..Skill["Bc"][2].." - 325"};
		[2] = {11, T_Text[7]};
		[3] = {12, T_Text[8]};
	};
	["23441"] = { -- Nightseye
		[1] = {Icon["Bc"]..Skill["Bc"][2].." - 325"};
		[2] = {11, T_Text[7]};
		[3] = {12, T_Text[8]};
	};
	["23438"] = { -- Star of Elune
		[1] = {Icon["Bc"]..Skill["Bc"][2].." - 325"};
		[2] = {11, T_Text[7]};
		[3] = {12, T_Text[8]};
	};
	["23437"] = { -- Talasite
		[1] = {Icon["Bc"]..Skill["Bc"][2].." - 325"};
		[2] = {11, T_Text[7]};
		[3] = {12, T_Text[8]};
	};
	
	-- Vanilla gems --
	["12800"] = { -- Azerothian Diamond
		[1] = {Skill["Van"][9].." - 250"};
		[2] = {13, T_Text[4]};
		[3] = {14, T_Text[8]};
	};
	["12361"] = { -- Blue Sapphire
		[1] = {Skill["Van"][9].." - 250"};
		[2] = {13, T_Text[4]};
		[3] = {14, T_Text[8]};
	};
	["12364"] = { -- Huge Emerald
		[1] = {Skill["Van"][9].." - 250"};
		[2] = {13, T_Text[4]};
		[3] = {14, T_Text[8]};
	};
	["12799"] = { -- Large Opal
		[1] = {Skill["Van"][9].." - 250"};
		[2] = {13, T_Text[4]};
		[3] = {14, T_Text[8]};
	};
	["7910"] = { -- Star Ruby
		[1] = {Skill["Van"][7].." - 250"};
		[2] = {14, T_Text[4]};
		[3] = {13, T_Text[7]};
		[4] = {15, T_Text[8]};
	};
	["7909"] = { -- Aquamarine
		[1] = {Skill["Van"][4].." - 175"};
		[2] = {14, T_Text[4]};
		[3] = {15,16, T_Text[7]};
	};
	["3864"] = { -- Citrine
		[1] = {Skill["Van"][4].." - 175"};
		[2] = {14,15, T_Text[4]};
		[3] = {16, T_Text[7]};
	};
	["1529"] = { -- Jade
		[1] = {Skill["Van"][4].." - 125"};
		[2] = {15, T_Text[4]};
		[3] = {16, T_Text[7]};
	};
	["1705"] = { -- Lesser Moonstone
		[1] = {Skill["Van"][4].." - 125"};
		[2] = {15,16, T_Text[4]};
	};
	["1206"] = { -- Moss Agate
		[1] = {Skill["Van"][4]};
		[2] = {16, T_Text[4]};
	};
	["1210"] = { -- Shadowgem
		[1] = {Skill["Van"][1].." - 50"};
		[2] = {16, T_Text[4]};
		[3] = {17, T_Text[6]};
	};
	["818"] = { -- Tigerseye
		[1] = {Skill["Van"][1]};
		[2] = {17, T_Text[3]};
	};
	["774"] = { -- Malachite
		[1] = {Skill["Van"][1]};
		[2] = {17, T_Text[3]};
	};
}

T_Ores2 = {
	-- Pandaria ores --
	"\124cff1eff00\124Hitem:72094:0:0:0:0:0:0:0:0:0:0\124h[Black Trillium Ore]\124h\124r", -- Black Trillium Ore
	"\124cff1eff00\124Hitem:72103:0:0:0:0:0:0:0:0:0:0\124h[White Trillium Ore]\124h\124r", -- White Trillium Ore
	"\124cffffffff\124Hitem:72093:0:0:0:0:0:0:0:0:0:0\124h[Kyparite]\124h\124r", -- Kyparite
	"\124cffffffff\124Hitem:72092:0:0:0:0:0:0:0:0:0:0\124h[Ghost Iron Ore]\124h\124r", -- Ghost Iron Ore
	
	-- Cataclysm ores --``
	"\124cff1eff00\124Hitem:52183:0:0:0:0:0:0:0:0:0:0\124h[Pyrite Ore]\124h\124r", -- Pyrite Ore
	"\124cffffffff\124Hitem:52185:0:0:0:0:0:0:0:0:0:0\124h[Elementium Ore]\124h\124r", -- Elementium Ore
	"\124cffffffff\124Hitem:53038:0:0:0:0:0:0:0:0:0:0\124h[Obsidium Ore]\124h\124r", -- Obsidium Ore
	
	-- Wrath of the Lich King ores --
	"\124cff1eff00\124Hitem:36910:0:0:0:0:0:0:0:0:0:0\124h[Titanium Ore]\124h\124r", -- Titanium Ore
	"\124cffffffff\124Hitem:36912:0:0:0:0:0:0:0:0:0:0\124h[Saronite Ore]\124h\124r", -- Saronite Ore
	"\124cffffffff\124Hitem:36909:0:0:0:0:0:0:0:0:0:0\124h[Cobalt Ore]\124h\124r", -- Cobalt Ore
	
	-- The Burning Crusade ores --
	"\124cffffffff\124Hitem:23425:0:0:0:0:0:0:0:0:0:0\124h[Adamantite Ore]\124h\124r", -- Adamantite Ore
	"\124cffffffff\124Hitem:23424:0:0:0:0:0:0:0:0:0:0\124h[Fel Iron Ore]\124h\124r", -- Fel Iron Ore
	
	-- Vanilla ores --
	"\124cffffffff\124Hitem:10620:0:0:0:0:0:0:0:0:0:0\124h[Thorium Ore]\124h\124r", -- Thorium Ore
	"\124cffffffff\124Hitem:3858:0:0:0:0:0:0:0:0:0:0\124h[Mithril Ore]\124h\124r", -- Mithril Ore
	"\124cffffffff\124Hitem:2772:0:0:0:0:0:0:0:0:0:0\124h[Iron Ore]\124h\124r", -- Iron Ore
	"\124cffffffff\124Hitem:2771:0:0:0:0:0:0:0:0:0:0\124h[Tin Ore]\124h\124r", -- Tin Ore
	"\124cffffffff\124Hitem:2770:0:0:0:0:0:0:0:0:0:0\124h[Copper Ore]\124h\124r" -- Copper Ore
}

-------------------
-- Ores info end --
-------------------

---------------------
-- Disenchant info --
---------------------

T_Dis = {
	-- Dust
	["74249"] = { -- Spirit Dust
		Icon["Mop"]..Skill["Mop"][1],
		"Gear level: 364-437",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][3],
		T_Quality[1]..T_Text["Disenchant"][4]
	},
	["52555"] = { -- Hypnotic Dust
		Icon["Cata"]..Skill["Cata"][1].." - 475",
		"Gear level: 272-333",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][3],
		T_Quality[1]..T_Text["Disenchant"][4]
	},
	["34054"] = { -- Infinite Dust
		Icon["Wrath"]..Skill["Wrath"][1].." - 350",
		"Gear level: 130-200",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][3],
		T_Quality[1]..T_Text["Disenchant"][4]
	},
	["22445"] = { -- Arcane Dust
		Icon["Bc"]..Skill["Bc"][1].." - 275",
		"Gear level: 80-120",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][3],
		T_Quality[1]..T_Text["Disenchant"][4]
	},
	["16204"] = { -- Illusion Dust
		Skill["Van"][10].." - 225",
		"Gear level: 56-65",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][3],
		T_Quality[1]..T_Text["Disenchant"][4]
	},
	["11176"] = { -- Dream Dust
		Skill["Van"][8].." - 175",
		"Gear level: 46-55",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][3],
		T_Quality[1]..T_Text["Disenchant"][4]
	},
	["11137"] = { -- Vision Dust
		Skill["Van"][6].." - 125",
		"Gear level: 36-45",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][3],
		T_Quality[1]..T_Text["Disenchant"][4]
	},
	["11083"] = { -- Soul Dust
		Skill["Van"][4].." - 75",
		"Gear level: 26-35",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][3],
		T_Quality[1]..T_Text["Disenchant"][4]
	},
	["10940"] = { -- Strange Dust
		Skill["Van"][1].." - 25",
		"Gear level: 5-25",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][3],
		T_Quality[1]..T_Text["Disenchant"][4]
	},
	
	-- Essence
	["74250"] = { -- Mysterious Essence
		Icon["Mop"]..Skill["Mop"][1],
		"Gear level: 364-437",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["52719"] = { -- Greater Celestial Essence
		Icon["Cata"]..Skill["Cata"][3],
		"Gear level: 306-333",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["52718"] = { -- Lesser Celestial Essence
		Icon["Cata"]..Skill["Cata"][1],
		"Gear level: 272-305",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["34055"] = { -- Greater Cosmic Essence
		Icon["Wrath"]..Skill["Wrath"][2],
		"Gear level: 152-200",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["34056"] = { -- Lesser Cosmic Essence
		Icon["Wrath"]..Skill["Wrath"][1],
		"Gear level: 130-151",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["22446"] = { -- Greater Planar Essence
		Icon["Bc"]..Skill["Bc"][2],
		"Gear level: 100-120",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["22447"] = { -- Lesser Planar Essence
		Icon["Bc"]..Skill["Bc"][1],
		"Gear level: 80-99",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["16203"] = { -- Greater Eternal Essence
		Skill["Van"][11],
		"Gear level: 61-65",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["16202"] = { -- Lesser Eternal Essence
		Skill["Van"][10],
		"Gear level: 56-60",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["11175"] = { -- Greater Nether Essence
		Skill["Van"][9],
		"Gear level: 51-55",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["11174"] = { -- Lesser Nether Essence
		Skill["Van"][8],
		"Gear level: 46-50",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["11135"] = { -- Greater Mystic Essence
		Skill["Van"][7],
		"Gear level: 41-45",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["11134"] = { -- Lesser Mystic Essence
		Skill["Van"][6],
		"Gear level: 36-40",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["11082"] = { -- Greater Astral Essence
		Skill["Van"][5],
		"Gear level: 31-35",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["10998"] = { -- Lesser Astral Essence
		Skill["Van"][4],
		"Gear level: 26-30",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["10939"] = { -- Greater Magic Essence
		Skill["Van"][3],
		"Gear level: 16-20",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	["10938"] = { -- Lesser Magic Essence
		Skill["Van"][1],
		"Gear level: 5-15",
		T_Quality[1].."Uncommon|r",
		T_Quality[1]..T_Text["Disenchant"][4],
		T_Quality[1]..T_Text["Disenchant"][3]
	},
	
	-- Shard
	["74247"] = { -- Ethereal Shard
		Icon["Mop"]..Skill["Mop"][4],
		"Gear level: 425-476",
		T_Quality[2].."Rare|r",
		T_Quality[2]..T_Text["Disenchant"][1],
		T_Quality[2]..T_Text["Disenchant"][1]
	},
	["74252"] = { -- Small Ethereal Shard
		Icon["Mop"]..Skill["Mop"][3],
		"Gear level: 393-424",
		T_Quality[2].."Rare|r",
		T_Quality[2]..T_Text["Disenchant"][1],
		T_Quality[2]..T_Text["Disenchant"][1]
	},
	["52721"] = { -- Heavenly Shard
		Icon["Cata"]..Skill["Cata"][2],
		"Gear level: 306-346",
		T_Quality[2].."Rare|r",
		T_Quality[2]..T_Text["Disenchant"][1],
		T_Quality[2]..T_Text["Disenchant"][1]
	},
	["52720"] = { -- Small Heavenly Shard
		Icon["Cata"]..Skill["Cata"][2],
		"Gear level: 272-305",
		T_Quality[2].."Rare|r",
		T_Quality[2]..T_Text["Disenchant"][1],
		T_Quality[2]..T_Text["Disenchant"][1]
	},
	["34052"] = { -- Dream Shard
		Icon["Wrath"]..Skill["Wrath"][1].." - 350",
		"Gear level: 152-200",
		T_Quality[1].."Uncommon|r & "..T_Quality[2].."Rare|r",
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][2],
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][2]
	},
	["34053"] = { -- Small Dream Shard
		Icon["Wrath"]..Skill["Wrath"][1],
		"Gear level: 130-164",
		T_Quality[1].."Uncommon|r & "..T_Quality[2].."Rare|r",
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][2],
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][2]
	},
	["22449"] = { -- Large Prismatic Shard
		Icon["Bc"]..Skill["Bc"][2],
		"Gear level: 100-120",
		T_Quality[1].."Uncommon|r & "..T_Quality[2].."Rare|r",
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][2],
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][2]
	},
	["22448"] = { -- Small Prismatic Shard
		Icon["Bc"]..Skill["Bc"][1],
		"Gear level: 66-99",
		T_Quality[1].."Uncommon|r & "..T_Quality[2].."Rare|r",
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][2],
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][2]
	},
	["14344"] = { -- Large Brilliant Shard
		Skill["Van"][11],
		"Gear level: 61-65",
		T_Quality[1].."Uncommon|r & "..T_Quality[2].."Rare|r",
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][2],
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][2]
	},
	["14343"] = { -- Small Brilliant Shard
		Skill["Van"][10],
		"Gear level: 56-60",
		T_Quality[1].."Uncommon|r & "..T_Quality[2].."Rare|r",
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][2],
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][2]
	},
	["11178"] = { -- Large Radiant Shard
		Skill["Van"][9],
		"Gear level: 51-55",
		T_Quality[1].."Uncommon|r & "..T_Quality[2].."Rare|r",
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][1],
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][1]
	},
	["11177"] = { -- Small Radiant Shard
		Skill["Van"][8],
		"Gear level: 46-50",
		T_Quality[1].."Uncommon|r & "..T_Quality[2].."Rare|r",
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][1],
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][1]
	},
	["11139"] = { -- Large Glowing Shard
		Skill["Van"][7],
		"Gear level: 41-45",
		T_Quality[1].."Uncommon|r & "..T_Quality[2].."Rare|r",
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][1],
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][1]
	},
	["11138"] = { -- Small Glowing Shard
		Skill["Van"][6],
		"Gear level: 36-40",
		T_Quality[1].."Uncommon|r & "..T_Quality[2].."Rare|r",
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][1],
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][1]
	},
	["11084"] = { -- Large Glimmering Shard
		Skill["Van"][5],
		"Gear level: 31-35",
		T_Quality[1].."Uncommon|r & "..T_Quality[2].."Rare|r",
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][1],
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][1]
	},
	["10978"] = { -- Small Glimmering Shard
		Skill["Van"][4],
		"Gear level: 51-55",
		T_Quality[1].."Uncommon|r & "..T_Quality[2].."Rare|r",
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][1],
		T_Quality[1]..T_Text["Disenchant"][6].."|r"..T_Quality[2]..T_Text["Disenchant"][1]
	},
	
	-- Crystal
	["74248"] = { -- Sha Crystal
		Icon["Mop"]..Skill["Mop"][5],
		"Gear level: 420-566",
		T_Quality[3].."Epic|r",
		T_Quality[3]..T_Text["Disenchant"][1],
		T_Quality[3]..T_Text["Disenchant"][1]
	},
	["52722"] = { -- Maelstrom Crystal
		Icon["Cata"]..Skill["Cata"][3],
		"Gear level: 300-416",
		T_Quality[3].."Epic|r",
		T_Quality[3]..T_Text["Disenchant"][1],
		T_Quality[3]..T_Text["Disenchant"][1]
	},
	["34057"] = { -- Abyss Crystal
		Icon["Wrath"]..Skill["Wrath"][1].." - 350",
		"Gear level: 130-200",
		T_Quality[2].."Rare|r & "..T_Quality[3].."Epic|r",
		T_Quality[2]..T_Text["Disenchant"][7].."|r"..T_Quality[3]..T_Text["Disenchant"][1],
		T_Quality[2]..T_Text["Disenchant"][7].."|r"..T_Quality[3]..T_Text["Disenchant"][1]
	},
	["22450"] = { -- Void Crystal
		Icon["Bc"]..Skill["Bc"][2].." - 300",
		"Gear level: 66-164",
		T_Quality[2].."Rare|r & "..T_Quality[3].."Epic|r",
		T_Quality[2]..T_Text["Disenchant"][7].."|r"..T_Quality[3]..T_Text["Disenchant"][1],
		T_Quality[2]..T_Text["Disenchant"][7].."|r"..T_Quality[3]..T_Text["Disenchant"][1]
	},
	["20725"] = { -- Nexus Crystal
		Skill["Van"][10].." - 225",
		"Gear level: 56-80",
		T_Quality[2].."Rare|r & "..T_Quality[3].."Epic|r",
		T_Quality[2]..T_Text["Disenchant"][7].."|r"..T_Quality[3]..T_Text["Disenchant"][1],
		T_Quality[2]..T_Text["Disenchant"][7].."|r"..T_Quality[3]..T_Text["Disenchant"][1]
	}
}

-------------------
-- Gear info end --
-------------------