---------------
-- Functions --
---------------
local function MillingDraw(key, itemID, self)
	if(MillingButton:GetChecked() and MillingButton:IsEnabled() and key) then
		for HerbID, HerbResult in pairs(T_Herb) do
			if(itemID == HerbID) then
				local r,g,b = 0,1,0.5
				self:AddLine(" ")
				self:AddLine("Milling result:  "..HerbResult[1][1],r,g,b)
				
				for _,Value in ipairs(HerbResult) do
					for i=1,#Value-1,1 do
						if(type(Value[i]) == 'number') then
							self:AddLine(T_Milling[Value[i]]..Value[#Value],r,g,b)
						end
					end
				end
			end
		end
	end
end
local function HerbDraw(key, itemID, self)
	if(HerbButton:GetChecked() and HerbButton:IsEnabled() and key) then
		for PigmentID, PigmentResult in pairs(T_Pigments) do
			if(itemID == PigmentID) then
				local r,g,b = 0,1,0.5
				self:AddLine(" ")
				self:AddLine("Milled from:  "..PigmentResult[1][1],r,g,b)
				
				for _,Value in ipairs(PigmentResult) do
					for i=1,#Value-1,1 do
						if(type(Value[i]) == 'number') then
							self:AddLine(T_Herb2[Value[i]]..Value[#Value],r,g,b)
						end
					end
				end
			end
		end
	end
end
local function ProspectingDraw(key, itemID, self)
	if(ProspectingButton:GetChecked() and ProspectingButton:IsEnabled() and key) then
		for OreID, OreResult in pairs(T_Ores) do
			if(itemID == OreID) then
				local r,g,b = 1,0.5,0
				self:AddLine(" ")
				self:AddLine("Prospecting result:  "..OreResult[1][1],r,g,b)
				
				for _,Value in ipairs(OreResult) do
					for i=1,#Value-1,1 do
						if(type(Value[i]) == 'number') then
							self:AddLine(T_Pros[Value[i]]..Value[#Value],r,g,b)
						end
					end
				end
			end
		end
	end
end
local function OreDraw(key, itemID, self)
	if(OreButton:GetChecked() and OreButton:IsEnabled() and key) then
		for GemID, GemResult in pairs(T_Gems) do
			if(itemID == GemID) then
				local r,g,b = 1,0.5,0
				self:AddLine(" ")
				self:AddLine("Prospected from:  "..GemResult[1][1],r,g,b)
				
				for _,Value in ipairs(GemResult) do
					for i=1,#Value-1,1 do
						if(type(Value[i]) == 'number') then
							self:AddLine(T_Ores2[Value[i]]..Value[#Value],r,g,b)
						end
					end
				end
			end
		end
	end
end
local function EnchantingDraw(key, name, quality, itemLevel, itemType, itemEquipLoc, itemID, self)
	if(EnchantingButton:GetChecked() and EnchantingButton:IsEnabled() and key) then
		if(not(itemEquipLoc=='' or itemEquipLoc==_G["INVTYPE_BODY"] or itemEquipLoc==_G["INVTYPE_RELIC"] or
		itemEquipLoc==_G["INVTYPE_TABARD"] or itemEquipLoc==_G["INVTYPE_BAG"] or itemEquipLoc==_G["INVTYPE_QUIVER"])) then
			for _,ItemLevel in ipairs(T_iLvl) do
				for num=ItemLevel[1], ItemLevel[2],1 do
					if(itemLevel==num) then
						local r,g,b = 1,0,0.9
						if(quality==2) then
							if(itemType==_G["ARMOR"]) then
								self:AddLine(" ")
								self:AddLine("Disenchanting result:  "..ItemLevel[3][1][1],r,g,b)
								for Key,Result in ipairs(ItemLevel[3]) do
									if not(Key==1) then
										self:AddLine(T_Dis_Result[Result[1]][Result[2]]..Result[3],r,g,b)
									end
								end
							end
							if(itemType==_G["ENCHSLOT_WEAPON"]) then
								self:AddLine(" ")
								self:AddLine("Disenchanting result:  "..ItemLevel[3][1][1],r,g,b)
								for Key,Result in ipairs(ItemLevel[4]) do
									self:AddLine(T_Dis_Result[Result[1]][Result[2]]..Result[3],r,g,b)
								end
							end
						end
					end
				end
				if(type(ItemLevel[5]) == "number") then
					for num=ItemLevel[5], ItemLevel[6],1 do
						if(itemLevel==num) then
							local r,g,b = 1,0,0.9
							if(quality==3 and (itemType==_G["ARMOR"] or itemType==_G["ENCHSLOT_WEAPON"])) then
								self:AddLine(" ")
								self:AddLine("Disenchanting result:  "..ItemLevel[7][1][1],r,g,b)
								for Key,Result in ipairs(ItemLevel[7]) do
									if not(Key==1) then
										if not(string.find(name,"Contender's")) then
											self:AddLine(T_Dis_Result[Result[1]][Result[2]]..Result[3],r,g,b)
										else
											self:AddLine(T_Dis_Result[Result[4]][Result[5]]..Result[6],r,g,b)
										end
									end
								end	
							end
						end
					end
				end
				if(type(ItemLevel[8]) == "number") then
					for num=ItemLevel[8], ItemLevel[9],1 do
						if(itemLevel==num) then
							local r,g,b = 1,0,0.9
							if(quality==4 and (itemType==_G["ARMOR"] or itemType==_G["ENCHSLOT_WEAPON"])) then
								self:AddLine(" ")
								self:AddLine("Disenchanting result:  "..ItemLevel[10][1][1],r,g,b)
								for Key,Result in ipairs(ItemLevel[10]) do
									if not(Key==1) then
										self:AddLine(T_Dis_Result[Result[1]][Result[2]]..Result[3],r,g,b)
									end
								end	
							end
						end
					end
				end
			end
		end
	end
end
local function MaterialDraw(key, itemID, self)
	if(MaterialButton:GetChecked() and MaterialButton:IsEnabled() and key) then
		for DisID,DisResult in pairs(T_Dis) do
			if(itemID == DisID) then
				local r,g,b = 1,0,0.9
				self:AddLine(" ")
				self:AddLine("Disenchanted from:  "..DisResult[1],r,g,b)
				
				self:AddLine(DisResult[2],r,g,b)
				self:AddLine("Gear quality: "..DisResult[3],r,g,b)
				self:AddLine("Chance from armor:"..DisResult[4].."|r",r,g,b)
				self:AddLine("Chance from weapon:"..DisResult[5].."|r",r,g,b)
			end
		end
	end
end
-------------
-- Tooltip --
-------------
local TooltipItem = function(self, ...)
	local name, link = self:GetItem();
	if(link) then
		local _, _, quality, itemLevel, _, itemType, _, _, itemEquipLoc = GetItemInfo(link)
		local _, itemID = strsplit(":", link)
		local PA_KeyBinding = {
			[1] = true;
			[2] = IsShiftKeyDown();
			[3] = IsControlKeyDown();
			[4] = IsAltKeyDown();
			[5] = false;
			[6] = true; -- added this extra to prevent conflicting
		}
		
		----------------
		-- Herbs part --
		----------------
		MillingDraw(PA_KeyBinding[MillingID], itemID, self)
		HerbDraw(PA_KeyBinding[HerbID], itemID, self)
		
		----------------------
		-- Prospecting part --
		----------------------
		ProspectingDraw(PA_KeyBinding[ProspectingID], itemID, self)
		OreDraw(PA_KeyBinding[OreID], itemID, self)
		
		---------------------
		-- Enchanting part --
		---------------------
		EnchantingDraw(PA_KeyBinding[EnchantingID], name, quality, itemLevel, itemType, itemEquipLoc, itemID, self)
		MaterialDraw(PA_KeyBinding[MaterialID], itemID, self)
	end
end

local ChatTooltipItem = function(self, ...)
	local name, link = self:GetItem();
	if(link) then
		local _, _, quality, itemLevel, _, itemType, _, _, itemEquipLoc = GetItemInfo(link)
		local _, itemID = strsplit(":", link)
		
		----------------
		-- Herbs part --
		----------------
		MillingDraw(true, itemID, self)
		HerbDraw(true, itemID, self)
		
		----------------------
		-- Prospecting part --
		----------------------
		ProspectingDraw(true, itemID, self)
		OreDraw(true, itemID, self)
		
		---------------------
		-- Enchanting part --
		---------------------
		EnchantingDraw(true, name, quality, itemLevel, itemType, itemEquipLoc, itemID, self)
		MaterialDraw(true, itemID, self)
	end
end

for _, obj in next, {
	GameTooltip,
	ShoppingTooltip1,
	ShoppingTooltip2,
	ShoppingTooltip3,
} do
	obj:HookScript("OnTooltipSetItem", TooltipItem)
end

ItemRefTooltip:HookScript("OnTooltipSetItem", ChatTooltipItem)