-- UI FUNCTIONS --

function PoJ_Drag_Start(object, condition)
  if condition then
    object.drag = true
    object:StartMoving()
  end
end


function PoJ_Drag_Stop(object)
  object.drag = nil
  object:StopMovingOrSizing()
end


function PoJ_EnableButton(button, enable)
  if enable then
    button:Enable()
  else
    button:Disable()
  end
end


function PoJ_ExtendKeyRing()
  local frameid = IsBagOpen(KEYRING_CONTAINER)
	if frameid then
    local frame = getglobal("ContainerFrame" .. frameid)
		frame:Hide()
    local size = frame.size
    if size < GetContainerNumSlots(KEYRING_CONTAINER) then
      size = size + 4
    end
		ContainerFrame_GenerateFrame(frame, size, KEYRING_CONTAINER)
	end
end


function PoJ_GemCounter_Update()
  local show
  local red, yellow, blue = PoJ_GetGemColorCount()
  PoJ_GemCounter_RedCount:SetText(red)
  PoJ_GemCounter_YellowCount:SetText(yellow)
  PoJ_GemCounter_BlueCount:SetText(blue)
  show = red > 0 or yellow > 0 or blue > 0
  PoJ_ShowObject(PoJ_GemCounter_Red, show)
  PoJ_ShowObject(PoJ_GemCounter_RedCount, show)
  PoJ_ShowObject(PoJ_GemCounter_Yellow, show)
  PoJ_ShowObject(PoJ_GemCounter_YellowCount, show)
  PoJ_ShowObject(PoJ_GemCounter_Blue, show)
  PoJ_ShowObject(PoJ_GemCounter_BlueCount, show)
end


function PoJ_GetFaintColor(color)
  local faintcolor = {}
  faintcolor.r = 1 - (1 - color.r) / 2
  faintcolor.g = 1 - (1 - color.g) / 2
  faintcolor.b = 1 - (1 - color.b) / 2
  return faintcolor
end


function PoJ_GetResolution()
  local width, height = string.match(GetCVar("gxResolution"), "(%d+)x(%d+)")
  return {width = tonumber(width), height = tonumber(height)}
end


function PoJ_MinimapIcon_SetTooltip()
  PoJ_ShowTooltip("Piece of Justice")
end


function PoJ_MinimapIcon_Update()
  if this.drag then
    local d_min = 77
    local m_x = -53
    local m_y = -56
    local scale = UIParent:GetScale()
    local x, y = GetCursorPosition()
    x = PoJ_Round(x / scale - Minimap:GetRight()) + 18
    y = PoJ_Round(y / scale - Minimap:GetTop()) + 14
    local vec_x = x - m_x
    local vec_y = y - m_y
    local d = sqrt(vec_x^2 + vec_y^2)
    if d <= d_min then
      local f = d_min / d
      x = PoJ_Round(m_x + vec_x * f)
      y = PoJ_Round(m_y + vec_y * f)
    end
    PoJ_SetMinimapIconPos(x, y)
  end
end


function PoJ_SetDoubleChatEditWidth()
  if PoJ_Vars.ChatDouble then
    ChatFrame1EditBox:SetPoint("TOPRIGHT", "UIParent", "RIGHT", -ChatFrame1:GetLeft(), 0)
  else
    ChatFrame1EditBox:SetPoint("TOPRIGHT", "ChatFrame1", "BOTTOMRIGHT", 5, -2)
  end
end


function PoJ_SetFontColor(fontstring, enable)
  if enable then
    fontstring:SetTextColor(1, 0.8, 0, 1)
  else
    fontstring:SetTextColor(0.5, 0.5, 0.5, 1)
  end
end


function PoJ_SetMinimapIconPos(x, y)
  PoJ_Vars.Minimap_x = x
  PoJ_Vars.Minimap_y = y
  PoJ_Minimap_Icon:SetPoint("TOPRIGHT", "Minimap", "TOPRIGHT", x, y)
end


function PoJ_SetStatusBarFont()
  local font = "Fonts\\ARIALN.TTF"
  local fontsize = iif(PoJ_Vars.StatusSmallFont, 12, 14)
  local fontsizepet = iif(PoJ_Vars.StatusSmallFont, 10, 14)
  local fontflag = "outline"
  PlayerFrameHealthBarText:SetFont(font, fontsize, fontflag)
  PlayerFrameManaBarText:SetFont(font, fontsize, fontflag)
  TargetFrameTextureFrameHealthBarText:SetFont(font, fontsize, fontflag)
  TargetFrameTextureFrameManaBarText:SetFont(font, fontsize, fontflag)
  for i = 1, 4 do
    getglobal("PartyMemberFrame" .. i .. "HealthBarText"):SetFont(font, fontsize, fontflag)
    getglobal("PartyMemberFrame" .. i .. "ManaBarText"):SetFont(font, fontsize, fontflag)
  end
  PetFrameHealthBarText:SetFont(font, fontsizepet, fontflag)
  PetFrameManaBarText:SetFont(font, fontsizepet, fontflag)
  PetFrameManaBarText:SetPoint("CENTER", "PetFrame", "TOPLEFT", 82, iif(PoJ_Vars.StatusSmallFont, -36, -38))
end


function PoJ_ShowBottomtip(tooltip, head, text, errortext)
  local parent = this
  local show = false
  tooltip:ClearLines()
  tooltip:ClearAllPoints()
  if not parent or not parent:IsVisible() then
    parent = UIParent
  end
  GameTooltip_SetDefaultAnchor(tooltip, parent)
  if head and head ~= "" then
    tooltip:AddLine(head, 1, 1, 1, 1)
    show = true
  end
  if errortext and errortext ~= "" then
    tooltip:AddLine(errortext, 1, 0, 0, 1)
    show = true
  end
  if text and text ~= "" then
    tooltip:AddLine(text, 1, 0.82, 0, 1)
    show = true
  end
  if show then
    tooltip:Show()
  end
end


function PoJ_ShowGemCounter()
  PoJ_ShowObject(PoJ_GemCounter, PoJ_Vars.GemCounterShow)
end


function PoJ_ShowMenuDeco()
  PoJ_ShowObject(MainMenuBarLeftEndCap , not PoJ_Vars.NoMenuDeco)
  PoJ_ShowObject(MainMenuBarRightEndCap, not PoJ_Vars.NoMenuDeco)
end


function PoJ_ShowMinimapIcon()
  PoJ_ShowObject(PoJ_Minimap_Icon, PoJ_Vars.MinimapIcon)
end


function PoJ_ShowObject(object, show)
  if show then
    object:Show()
  else
    object:Hide()
  end
end


function PoJ_ShowTooltip(head, text)
  local objectname = this:GetName()
  GameTooltip:SetOwner(getglobal(objectname), "ANCHOR_TOP")
  GameTooltip:ClearLines()
  GameTooltip:ClearAllPoints()
  GameTooltip:SetPoint("TOPRIGHT", objectname, "BOTTOMRIGHT", -2, 2)
  if head and head ~= "" then
    GameTooltip:AddLine(head)
  end
  if text and text ~= "" then
    GameTooltip:AddLine(text, 1, 1, 1, 1)
  end
  GameTooltip:Show()
end


function PoJ_TargetIconButton_OnClick(button)
  local index = this:GetID()
  this:SetChecked(false)
  if GetRaidTargetIndex("target") == index then
    index = 0
  end
  SetRaidTarget("target", index)
end

function PoJ_TargetIconButton_OnLoad()
  local texture = getglobal(this:GetName() .. "Icon")
  texture:SetTexture("Interface\\TargetingFrame\\UI-RaidTargetingIcons")
  SetRaidTargetIconTexture(texture, this:GetID())
  this:RegisterForClicks("LeftButtonUp", "RightButtonUp")
end


function PoJ_ToggleFrame(frame, uiframe)
  if frame:IsVisible() then
    if uiframe and not InCombatLockdown() then
      HideUIPanel(frame)
    else
      frame:Hide()
    end
  elseif not InCombatLockdown() then
    if uiframe then
      ShowUIPanel(frame)
    else
      frame:Show()
    end
  end
end


function PoJ_UpdateAllActionButtons()
  local buttonname
  for i = 1, 5 do
    if i == 1 then
      buttonname = "ActionButton"
    elseif i == 2 then
      buttonname = "MultiBarBottomLeftButton"
    elseif i == 3 then
      buttonname = "MultiBarBottomRightButton"
    elseif i == 4 then
      buttonname = "MultiBarLeftButton"
    elseif i == 5 then
      buttonname = "MultiBarRightButton"
    end
    for j = 1, 12 do
      ActionButton_Update(getglobal(buttonname .. j))
    end
  end
end


function PoJ_UpdateActionButtonMacroName(button)
  if not button then
    button = this
  end
	local macroname = getglobal(button:GetName().."Name")
  if not PoJ_Vars.NoMacroNames and not IsConsumableAction(button.action) and not IsStackableAction(button.action) then
    macroname:SetText(GetActionText(button.action))
  else
    macroname:SetText("")
  end
end


function PoJ_UpdateTargetClass()
  PoJ_TargetClassName:Hide()
  if PoJ_Vars.PvPClasses and UnitExists("target") and UnitIsPlayer("target") and UnitIsEnemy("target", "player") then
    local locclass = UnitClass("target")
    for class, classname in pairs(POJ_STRING.CLASS) do
      if classname == locclass then
        local color = PoJ_GetFaintColor(RAID_CLASS_COLORS[class])
        PoJ_TargetClassNameText:SetText(locclass)
        PoJ_TargetClassNameText:SetTextColor(color.r, color.g, color.b)
        PoJ_TargetClassName:Show()
      end
    end
  end
end


function PoJ_UpdateTargetIcons()
  PoJ_ShowObject(PoJ_TargetIcons, PoJ_Vars.RaidIcons and UnitExists("target") and (UnitIsFriend("target", "player") or not UnitIsPlayer("target")) --[[and (PoJ_GetGroupType() == "party" or IsRaidLeader() or IsRaidOfficer())]])
end
