function PoJ_ActivateTab()
  PlaySound("igCharacterInfoTab")
  getglobal("PoJ_OptionsTab" .. PoJ_Options.selectedTab).frame:Hide()
  this.frame:Show()
  PanelTemplates_Tab_OnClick(this, PoJ_Options)
end


function PoJ_CraftList_DropDown_Initialize()
  if PoJ_Vars.SkillCooldowns then
    local info
    info = { text = PoJ_Vars.SkillCooldowns[this.index].charname .. " - " .. PoJ_Vars.SkillCooldowns[this.index].skill, isTitle = 1, notCheckable = 1}
    UIDropDownMenu_AddButton(info)
    info = { text = POJ_STRING.WOW.DELETE, value = "delete", arg1 = this.index, notCheckable = 1, func = PoJ_CraftList_DropDown_OnClick }
    UIDropDownMenu_AddButton(info)
    PlaySound("igMainMenuOpen")
  end
end


function PoJ_CraftList_DropDown_OnClick()
  if this.value == "delete" then
    table.remove(PoJ_Vars.SkillCooldowns, this.arg1)
  end
end


function PoJ_CraftList_OnLoad()
  local buttonname
  local columnwidths = {}
  FauxScrollFrame_SetOffset(PoJ_CraftListScrollFrame, 0)
  PoJ_UpdateFrame_Prepare(1)
  for j = 1, 5 do
    columnwidths[j] = getglobal("PoJ_CraftList_Header" .. j):GetWidth() - 2
  end
  for i = 1, 20 do
    buttonname = "PoJ_CraftListButton" .. i
    for j = 1, 5 do
      getglobal(buttonname .. "_Column" .. j):SetWidth(columnwidths[j])
    end
  end
end


function PoJ_CraftList_OnUpdate(elapsed)
  this.LastUpdate = this.LastUpdate + elapsed
  if this.LastUpdate > this.UpdateRate then
    PoJ_CraftList_Update()
  end
end


function PoJ_CraftList_SetRemind(index, setremind)
  index = index + FauxScrollFrame_GetOffset(PoJ_CraftListScrollFrame)
  if setremind then
    setremind = true
  end
  PoJ_Vars.SkillCooldowns[index].remind = setremind
end


function PoJ_CraftList_Sort(a, b)
  if a.endtime < b.endtime then
    return true
  elseif a.endtime == b.endtime then
    if a.realm < b.realm then
      return true
    elseif a.realm == b.realm then
      if a.charname < b.charname then
        return true
      elseif a.charname == b.charname then
        return a.skill < b.skill
      end
    end
  end
end


function PoJ_CraftList_Update()
  local button, buttonname, cdcharname, cdrealm, endtime, fontstring, index, samechar
  local charname = UnitName("player")
  local cooldowncount = #PoJ_Vars.SkillCooldowns
  local now = time()
  local offset = FauxScrollFrame_GetOffset(PoJ_CraftListScrollFrame)
  local realm = GetRealmName()
  local showscrollbar = cooldowncount > 20
  for i = 1, 20 do
    buttonname = "PoJ_CraftListButton" .. i
    button = getglobal(buttonname)
    index = offset + i
    if index > cooldowncount then
      button.index = nil
      button:Hide()
    else
      button.index = index
      cdrealm = PoJ_Vars.SkillCooldowns[index].realm
      fontstring = getglobal(buttonname .. "_Column1")
      if cdrealm == realm then
        fontstring:SetTextColor(1, 1, 1)
      else
        fontstring:SetTextColor(0.5, 0.5, 0.5)
      end
      fontstring:SetText(cdrealm)
      cdcharname = PoJ_Vars.SkillCooldowns[index].charname
      fontstring = getglobal(buttonname .. "_Column2")
      samechar = cdcharname == charname and cdrealm == realm
      if samechar then
        fontstring:SetTextColor(1, 1, 1)
      else
        fontstring:SetTextColor(0.5, 0.5, 0.5)
      end
      fontstring:SetText(cdcharname)
      fontstring = getglobal(buttonname .. "_Column3")
      if samechar then
        fontstring:SetTextColor(1, 1, 1)
      else
        fontstring:SetTextColor(0.5, 0.5, 0.5)
      end
      fontstring:SetText(PoJ_Vars.SkillCooldowns[index].skill)
      getglobal(buttonname .. "_Column4_Check"):SetChecked(PoJ_Vars.SkillCooldowns[index].remind)
      endtime = PoJ_Vars.SkillCooldowns[index].endtime
      fontstring = getglobal(buttonname .. "_Column5")
      if endtime == 0 then
        fontstring:SetTextColor(0, 1, 0)
        fontstring:SetText(POJ_STRING.OUTPUT.READY)
      elseif endtime > now + 3600 then
        fontstring:SetTextColor(1, 0, 0)
        fontstring:SetText(SecondsToTime(endtime - now))
      elseif endtime > now then
        fontstring:SetTextColor(1, 1, 0)
        fontstring:SetText(SecondsToTime(endtime - now))
      else
        fontstring:SetText()
      end
      button:Show()
    end
  end
  FauxScrollFrame_Update(PoJ_CraftListScrollFrame, cooldowncount, 20, 16)
end


function PoJ_CraftListButton_OnClick(button)
  if button == "RightButton" then
    ToggleDropDownMenu(1, nil, PoJ_CraftList_DropDown, this)
  end
end


function PoJ_CraftListHeader_OnLoad()
  local id = this:GetID()
  if id == 1 then
    this:SetText(POJ_STRING.CRAFTLIST.REALM)
    --this.sortType = "realm"
    WhoFrameColumn_SetWidth(this, 150)
  elseif id == 2 then
    this:SetText(POJ_STRING.CRAFTLIST.CHARNAME)
    --this.sortType = "char"
    WhoFrameColumn_SetWidth(this, 85)
  elseif id == 3 then
    this:SetText(POJ_STRING.CRAFTLIST.SKILL)
    --this.sortType = "skill"
    WhoFrameColumn_SetWidth(this, 120)
  elseif id == 4 then
    this:SetText(POJ_STRING.OUTPUT.REMIND)
    --this.sortType = "remind"
    WhoFrameColumn_SetWidth(this, 80)
  elseif id == 5 then
    this:SetText(POJ_STRING.CRAFTLIST.COOLDOWN)
    --this.sortType = "cooldown"
    WhoFrameColumn_SetWidth(this, 100)
  end
end


function PoJ_ErrorSuppressionCheckBox_GetIndex(name)
  local n = string.match(name, "PoJ_CharOpt_ErrorSuppression_Check_Error(%w+)")
  return tonumber(n)
end


function PoJ_ErrorSuppressionCheckBox_OnClick()
  PoJ_Option_SetValue(true, iif(this:GetChecked(), true, nil), "ErrSupp_" .. PoJ.ErrorSuppression[PoJ_ErrorSuppressionCheckBox_GetIndex(this:GetName())].name)
  PoJ_SetErrorSuppressions()
end


function PoJ_ErrorSuppressionCheckBox_OnLoad()
  local name = this:GetName()
  n = PoJ_ErrorSuppressionCheckBox_GetIndex(name)
  if PoJ.ErrorSuppression[n] then
    getglobal(name .. "_Label"):SetText(n)
    getglobal(name .. "_Label"):SetText('"' .. PoJ.ErrorSuppression[n].text .. '"')
    this:Show()
  end
  this.ischaropt = true
end


function PoJ_ErrorSuppressionCheckBox_OnShow()
  this:SetChecked(PoJ_Option_GetValue(true, "ErrSupp_" .. PoJ.ErrorSuppression[PoJ_ErrorSuppressionCheckBox_GetIndex(this:GetName())].name))
end


function PoJ_Option_GetValue(ischaropt, ...)
  local opt = iif(ischaropt, PoJ_CVars, PoJ_Vars)
  local vararg = {...}
  for i = 1, #vararg do
    if opt[vararg[i]] == nil then
      return nil
    end
    opt = opt[vararg[i]]
    if i == #vararg then
      return opt
    elseif type(opt) ~= "table" then
      return nil
    end
  end
  return nil
end


function PoJ_Option_SetValue(ischaropt, value, ...)
  local opt = iif(ischaropt, PoJ_CVars, PoJ_Vars)
  local vararg = {...}
  for i = 1, #vararg do
    if i == #vararg then
      opt[vararg[i]] = value
      return true
    else
      if opt[vararg[i]] == nil then
        opt[vararg[i]] = {}
      end
      opt = opt[vararg[i]]
      if type(opt) ~= "table" then
        return false
      end
    end
  end
end


function PoJ_OptionCheckBox_Enable(button, enable)
  local label = getglobal(button:GetName() .. "_Label")
  PoJ_EnableButton(button, enable)
  if label then
    PoJ_OptionLabel_Enable(label, enable)
  end
end


function PoJ_OptionCheckBox_EnableSlaves(button)
  if not button then
    button = this
  end
  local doenable = button:IsEnabled() == 1 and button:GetChecked()
  for _, slave in ipairs(button.slaves) do
    if slave:IsObjectType("CheckButton") then
      PoJ_OptionCheckBox_Enable(slave, doenable)
    elseif slave:IsObjectType("FontString") then
      PoJ_OptionLabel_Enable(slave, doenable)
    end
    if slave.slaves then
      PoJ_OptionCheckBox_EnableSlaves(slave)
    end
  end
end


function PoJ_OptionCheckBox_GetIndex(name, toupper)
  local a, b = string.match(name, "PoJ_(%w+)[_%w]*_Check_(%w+)")
  if toupper then
    a, b = strupper(a), strupper(b)
  end
  return a, b
end


function PoJ_OptionCheckBox_OnClick()
  local _, a = PoJ_OptionCheckBox_GetIndex(this:GetName())
  PoJ_Option_SetValue(this.ischaropt, iif(this:GetChecked(), true, nil), a)
  if this.slaves then
    PoJ_OptionCheckBox_EnableSlaves()
  end
  if this.func then
    this.func(PoJ_GetTableItemList(this.funcparams))
    if this.func2 then
      this.func2(PoJ_GetTableItemList(this.func2params))
    end
  end
end


function PoJ_OptionCheckBox_OnEnter()
  local name = this:GetName()
  local a, b = PoJ_OptionCheckBox_GetIndex(name, true)
  if this.text then
    b = this.text
  end
  if b then
    b = b .. "_TIP"
  end
  if a and b and POJ_STRING[a] and POJ_STRING[a][b] then
    PoJ_ShowOptionTooltip(POJ_STRING[a][b])
  else
    GameTooltip:Hide()
  end
end


function PoJ_OptionCheckBox_OnLoad()
  local name = this:GetName()
  local a, b = PoJ_OptionCheckBox_GetIndex(name, true)
  if a then
    if this.text then
      b = this.text
    end
    if b and POJ_STRING[a] and POJ_STRING[a][b] then
      getglobal(name .. "_Label"):SetText(POJ_STRING[a][b])
    else
      getglobal(name .. "_Label"):SetText(a .. ", " .. b)
    end
    if a == "CHAROPT" then
      this.ischaropt = true
    end
  end
end


function PoJ_OptionCheckBox_OnShow()
  local _, a = PoJ_OptionCheckBox_GetIndex(this:GetName())
  this:SetChecked(PoJ_Option_GetValue(this.ischaropt, a))
  if this.condition then
    PoJ_OptionCheckBox_Enable(this, PoJ_Eval(this.condition))
  end
  if this.slaves then
    PoJ_OptionCheckBox_EnableSlaves()
  end
end


function PoJ_OptionFrame_OnLoad()
  local name = this:GetName()
  local title = strmatch(name, "PoJ_(%w+)")
  getglobal(name .. "_Title"):SetText(POJ_STRING.OPTION[strupper(title)])
  PoJ_Version:SetText("v " .. PoJ.Version)
  this:Hide()
end


function PoJ_OptionFrameBox_OnLoad()
  local name   = this:GetName()
  local a, b = strmatch(name, "PoJ_(%w+)_(%w+)")
  local string = getglobal(name .. "_Title")
  if string then
    a, b = strupper(a), strupper(b) .. "_TITLE"
    if a and b and POJ_STRING[a] and POJ_STRING[a][b] then
      string:SetText(POJ_STRING[a][b])
    else
      string:SetText("[" .. name .. "]")
    end
  end
  this:SetBackdropBorderColor(0.4, 0.4, 0.4)
  this:SetBackdropColor(0.15, 0.15, 0.15)
end


function PoJ_OptionLabel_Enable(label, enable)
  if enable then
    label:SetTextColor(1, 0.82, 0)
  else
    label:SetTextColor(0.5, 0.5, 0.5)
  end
end


function PoJ_OptionRadioButton_GetIndex(name, toupper)
  local a, b, c = string.match(name, "PoJ_(%w+)[_%w]*_Option_(%w+)_(%w+)")
  if toupper then
    a, b, c = strupper(a), strupper(b), strupper(c)
  end
  return a, b, c
end


function PoJ_OptionRadioButton_OnClick()
  local _, a, b = PoJ_OptionRadioButton_GetIndex(this:GetName())
  if not this:GetChecked() then
    this:SetChecked(true)
  end
  PoJ_Option_SetValue(this.ischaropt, this:GetID(), a)
  for index, button in pairs(this:GetParent().radiogroups[a]) do
    if index ~= b then
      button:SetChecked(nil)
    end
  end
  if this.func then
    this.func(PoJ_GetTableItemList(this.funcparams))
  end
end


function PoJ_OptionRadioButton_OnEnter()
  local name = this:GetName()
  local a, b, c = PoJ_OptionRadioButton_GetIndex(name, true)
  c = c .. "_TIP"
  if a and b and c and POJ_STRING[a] and POJ_STRING[a][b] and POJ_STRING[a][b][c] then
    PoJ_ShowOptionTooltip(POJ_STRING[a][b][c])
  else
    GameTooltip:Hide()
  end
end


function PoJ_OptionRadioButton_OnLoad()
  local name = this:GetName()
  getglobal(name .. "_DisabledCheckedTexture"):SetDesaturated(1)
  local a, b, c = PoJ_OptionRadioButton_GetIndex(name, true)
  if a then
    if b and c and POJ_STRING[a] and POJ_STRING[a][b] and POJ_STRING[a][b][c] then
      getglobal(name .. "_Label"):SetText(POJ_STRING[a][b][c])
    else
      getglobal(name .. "_Label"):SetText("label not found: " .. a .. ", " .. b .. ", " .. c)
    end
    if a == "CHAROPT" then
      this.ischaropt = true
    end
  end
  
  local parent = this:GetParent()
  _, b, c = PoJ_OptionRadioButton_GetIndex(name)
  if b and c then
    if not parent.radiogroups then
      parent.radiogroups = {}
    end
    if not parent.radiogroups[b] then
      parent.radiogroups[b] = {}
    end
    parent.radiogroups[b][c] = this
  end
end


function PoJ_OptionRadioButton_OnShow()
  local _, a, _ = PoJ_OptionRadioButton_GetIndex(this:GetName())
  if PoJ_Option_GetValue(this.ischaropt, a) == tonumber(this:GetID()) then
    this:SetChecked(true)
  end
end


function PoJ_Options_OnLoad()
  local c
  
  PoJ_UpdateFrame_Prepare()
  PanelTemplates_SetNumTabs(this, 6)
  PanelTemplates_SetTab(this, 1)
  PoJ_OptionsTab1.frame = PoJ_WoWUIOpt
  PoJ_OptionsTab2.frame = PoJ_PoJUIOpt
  PoJ_OptionsTab3.frame = PoJ_Messages
  PoJ_OptionsTab4.frame = PoJ_WorldOpt
  PoJ_OptionsTab5.frame = PoJ_CharOpt
  PoJ_OptionsTab6.frame = PoJ_Craft
  PoJ_OptionsTab1:SetText(POJ_STRING.OPTION.WOWUIOPT_TAB)
  PoJ_OptionsTab2:SetText(POJ_STRING.OPTION.POJUIOPT_TAB)
  PoJ_OptionsTab3:SetText(POJ_STRING.OPTION.MESSAGES_TAB)
  PoJ_OptionsTab4:SetText(POJ_STRING.OPTION.WORLDOPT_TAB)
  PoJ_OptionsTab5:SetText(POJ_STRING.OPTION.CHAROPT_TAB)
  PoJ_OptionsTab6:SetText(POJ_STRING.OPTION.CRAFT_TAB)
  PoJ_OptionsTab1.frame:Show()
  
  PoJ_WoWUIOpt_Targets_Check_StatusSmallFont.func   = PoJ_SetStatusBarFont
  PoJ_WoWUIOpt_Targets_Check_TargetColors.func      = PoJ_SetTargetNameColors
  PoJ_WoWUIOpt_QuestLog_Check_QuestLevels.func      = QuestLog_Update
  PoJ_WoWUIOpt_Chat_Check_ChatDouble.func           = PoJ_SetDoubleChatEditWidth
  PoJ_WoWUIOpt_Chat_Check_ChatTimeStamp.func        = PoJ_ModifyTimeStamp
  PoJ_WoWUIOpt_Chat_Check_HideChannelJoins.func     = PoJ_SetChatChannelJoins
  PoJ_WoWUIOpt_Raid_Check_ShowRaidGroup.func        = PoJ_ShowRaidGroup
  PoJ_WoWUIOpt_Menubar_Check_NoMenuDeco.func        = PoJ_ShowMenuDeco
  PoJ_WoWUIOpt_Menubar_Check_NoMacroNames.func      = PoJ_UpdateAllActionButtons
  PoJ_WoWUIOpt_Menubar_Label_ShowAction:SetText(POJ_STRING.WOWUIOPT.SHOWACTION .. ":")
  c = PoJ.ActionbarTimeColors.cooldown
  PoJ_WoWUIOpt_Menubar_Check_ShowActionCD_Label:SetTextColor(c.r, c.g, c.b)
  c = PoJ.ActionbarTimeColors.debuff
  PoJ_WoWUIOpt_Menubar_Check_ShowActionOT_Label:SetTextColor(c.r, c.g, c.b)
  c = PoJ.ActionbarTimeColors.buff
  PoJ_WoWUIOpt_Menubar_Check_ShowActionBD_Label:SetTextColor(c.r, c.g, c.b)
  
  PoJ_PoJUIOpt_Minimap_Check_MinimapIcon.func     = PoJ_ShowMinimapIcon
  PoJ_PoJUIOpt_ActionBar_Check_ActionBarShow.func = PoJ_ShowActionBar
  PoJ_PoJUIOpt_ActionBar_Check_ActionBarShow.slaves = {
    PoJ_PoJUIOpt_ActionBar_Option_ActionBarRows_1,
    PoJ_PoJUIOpt_ActionBar_Option_ActionBarRows_2,
    PoJ_PoJUIOpt_ActionBar_Option_ActionBarRows_4,
    PoJ_PoJUIOpt_ActionBar_Check_ActionBarIdent,
    PoJ_PoJUIOpt_ActionBar_Check_ActionBarDice,
    PoJ_PoJUIOpt_ActionBar_Check_ActionBarNotes,
  }
  PoJ_PoJUIOpt_ActionBar_Option_ActionBarRows_1.func = PoJ_SetActionBarPos
  PoJ_PoJUIOpt_ActionBar_Option_ActionBarRows_2.func = PoJ_SetActionBarPos
  PoJ_PoJUIOpt_ActionBar_Option_ActionBarRows_4.func = PoJ_SetActionBarPos
  PoJ_PoJUIOpt_ActionBar_Check_ActionBarIdent.func   = PoJ_ActionBar_Setup
  PoJ_PoJUIOpt_ActionBar_Check_ActionBarIdent.slaves = {
    PoJ_PoJUIOpt_ActionBar_Check_ActionBarIdentPart,
    PoJ_PoJUIOpt_ActionBar_Check_ActionBarIdentRaid,
  }
  PoJ_PoJUIOpt_ActionBar_Check_ActionBarDice.func   = PoJ_ActionBar_Setup
  PoJ_PoJUIOpt_ActionBar_Check_ActionBarNotes.func  = PoJ_ActionBar_Setup
  PoJ_PoJUIOpt_Gems_Check_GemCounterShow.func       = PoJ_ShowGemCounter
  PoJ_PoJUIOpt_Coord_Check_CoordShow.func           = PoJ_ShowCoords
  PoJ_PoJUIOpt_Coord_Check_CoordShowMap.func        = PoJ_ShowCoords_Map
  PoJ_PoJUIOpt_PvE_Check_RaidIcons.func             = PoJ_UpdateTargetIcons
  PoJ_PoJUIOpt_PvP_Check_PvPClasses.func            = PoJ_UpdateTargetClass
  
  PoJ_Messages_Remind_Edit_RemindInterval_LeftText:SetText(POJ_STRING.MESSAGES.REMINDINTERVAL_LEFT)
  PoJ_Messages_Remind_Edit_RemindInterval_RightText:SetText(POJ_STRING.OUTPUT.MINUTES)
  PoJ_Messages_General_Check_ShowLevelUps.slaves = {PoJ_Messages_General_Check_GratsOnLevelUp}
  PoJ_Messages_Remind_Check_RemindItems.func     = PoJ_ItemRemind
  
  PoJ_CharOpt_Char_Check_DuelIgnore.slaves = {
    PoJ_CharOpt_Char_Check_DuelFriends,
    PoJ_CharOpt_Char_Check_DuelGuild,
    PoJ_CharOpt_Char_Check_DuelGroup,
  }
  PoJ_CharOpt_Hunter_Check_AuraActivation.text = "ASPECTACTIVATION"
  PoJ_CharOpt_Hunter_Check_AuraActivation_Label:SetText(POJ_STRING.CHAROPT.ASPECTACTIVATION)
  PoJ_CharOpt_Hunter_Check_AuraActivation2.condition = "PoJ.HasAura2Skills"
  
  local height = 20 * #PoJ.ErrorSuppression + 50
  PoJ_CharOpt_ErrorSuppression:SetHeight(height)
  local frame = getglobal("PoJ_CharOpt_" .. PoJ.ClassString)
  if frame then
    PoJ_CharOpt_ErrorSuppression:SetWidth(270)
    frame:SetHeight(height)
    frame:Show()
  end
  
  PoJ.OptionsLoaded = true
  
end


function PoJ_Options_OnUpdate()
  PoJ_UpdateFrame_Update(PoJ_Clock, PoJ_GetGameTimeString)
end


function PoJ_OptionSlider_OnLoad()
  local name = this:GetName()
  local a = strupper(string.match(name, "PoJ_Slider_(%w+)"))
  if a then
    if POJ_STRING.SLIDER[a] then
      getglobal(name .. "Text"):SetText(POJ_STRING.SLIDER[a])
    end
    if POJ_STRING.SLIDER[a .. "_HIGH"] then
      getglobal(name .. "High"):SetText(POJ_STRING.SLIDER[a .. "_HIGH"])
    end
    if POJ_STRING.SLIDER[a .. "_LOW"] then
      getglobal(name .. "Low"):SetText(POJ_STRING.SLIDER[a .. "_LOW"])
    end
  end
end


function PoJ_PlayerNames_OnClick()
  local a, b = string.match(this:GetName(), "PoJ_WorldOpt_PlayerNames_Check_(%w+)_(%w+)")
  PoJ_Option_SetValue(nil, iif(this:GetChecked(), true, nil), "PlayerNamesShow", a, b)
  PoJ_SetPlayerNamesVisibility(true)
end


function PoJ_PlayerNames_OnLoad()
  local obj
  local master = PoJ_WorldOpt_PlayerNames_Check_PlayerNames
  PoJ_OptionFrameBox_OnLoad()
  this.wholabels = {"Rank", "Guild", "Self", "Play", "Pets", "Crea", "Comp", "NPCs"}
  this.who = {"Rank", "Guild", "Self", "PlayF", "PlayE", "PetsF", "PetsE", "CreaF", "CreaE", "Comp", "NPCs"}
  this.where = {"City", "Inst", "In10", "In40", "Raid", "BG", "NoUI", "Norm"}
  master.func = PoJ_SetPlayerNamesVisibility
  master.funcparams = {true}
  master.slaves = {}
  for _, c in ipairs(this.wholabels) do
    obj = getglobal("PoJ_WorldOpt_PlayerNames_" .. c)
    obj:SetText(POJ_STRING.WORLDOPT["PLAYERNAMES_" .. strupper(c)])
    table.insert(master.slaves, obj)
  end
  for _, d in ipairs(this.where) do
    obj = getglobal("PoJ_WorldOpt_PlayerNames_" .. d)
    obj:SetText(POJ_STRING.WORLDOPT["PLAYERNAMES_" .. strupper(d)])
    table.insert(master.slaves, obj)
  end
  for _, c in ipairs(this.who) do
    for _, d in ipairs(this.where) do
      table.insert(master.slaves, getglobal("PoJ_WorldOpt_PlayerNames_Check_" .. c .. "_" .. d))
    end
  end
end


function PoJ_PlayerNames_OnShow()
  for _, c in ipairs(this.who) do
    for _, d in ipairs(this.where) do
      getglobal("PoJ_WorldOpt_PlayerNames_Check_" .. c .. "_" .. d):SetChecked(PoJ_Option_GetValue(nil, "PlayerNamesShow", c, d))
    end
  end
  PoJ_SetPlayerNamesVisibility()
end


function PoJ_PlayerNames_SetColors(index)
  for _, d in ipairs(PoJ_WorldOpt_PlayerNames.where) do
    if d == index then
      getglobal("PoJ_WorldOpt_PlayerNames_" .. d):SetTextColor(0.7, 0.85, 1)
    else
      getglobal("PoJ_WorldOpt_PlayerNames_" .. d):SetTextColor(1, 0.82, 0)
    end
  end
end


function PoJ_SetMenuBarPos(x)
  if x then
    PoJ_Vars.MenuBarPos = x
  end
  PoJ.SettingMainMenuBarPosition = true
  MainMenuBar:SetPoint("BOTTOM", "UIParent", "BOTTOM", PoJ_Vars.MenuBarPos, 0)
  PoJ.SettingMainMenuBarPosition = nil
end


function PoJ_SetupSlider(slider, minvalue, maxvalue, step, value)
  slider:SetMinMaxValues(minvalue, maxvalue)
  slider:SetValueStep(step)
  slider:SetValue(value)
end


function PoJ_ShowOptionTooltip(tooltip)
  if tooltip then
    GameTooltip:SetOwner(this, "ANCHOR_RIGHT")
    GameTooltip:SetText(tooltip)
  else
    GameTooltip:Hide()
  end
end


function PoJ_ShowRaidGroup()
  PoJ_SetUnitName(PlayerName, "player")
  PoJ_SetUnitName(TargetFrameTextureFrameName, "target")
  PlayerFrame_UpdateGroupIndicator()
end
