PoJ_Vars  = {}  -- list of variables saved between sessions
PoJ_CVars = {}  -- list of variables saved between sessions per character


function PoJ_OnLoad()
  
  this.ActionButton = {}
  this.AddonComm    = "Piece of Justice"
  this.LastText     = ""
  this.LastUpdate   = 0
  this.PartyLvl     = {}
  this.Spells       = {}
  this.TimerQueue   = {}
  this.UpdateRate   = 0.25
  this.URL          = "http://www.piece-of-justice.net/"
  this.Version      = "1.11.2"
  
  -- define locale string constants
  local locale = GetLocale()
  if locale == "deDE" then
    PoJ_DefineStringConstants_de()
  elseif locale == "enGB" or  locale == "enUS" then
    PoJ_DefineStringConstants_en()
  else
    PoJ_Write("Sorry, your locale version (" .. locale .. ") is not supported by Piece of Justice", false)
    DisableAddOn("Piece of Justice")
    return
  end
  
  -- set player class
  local _, charclass = UnitClass("player")
  PoJ.ClassString = strsub(charclass, 1, 1) .. strlower(strsub(charclass, 2))
  
  -- define lists
  PoJ_DefineLists()
  
  -- set class specific options
  if PoJ_DefineClassConstants[PoJ.ClassString] then
    PoJ_DefineClassConstants[PoJ.ClassString]()
  end
  
  -- register events to wait for at startup
  this:RegisterEvent("ADDON_LOADED"    )
  this:RegisterEvent("SPELLS_CHANGED"  )
  this:RegisterEvent("VARIABLES_LOADED")
  
  -- register slash command
  SlashCmdList["PieceOfJustice"] = PoJ_SlashCommandHandler
  SLASH_PieceOfJustice1 = "/poj"
  
end


function PoJ_OnUpdate()
  
  PoJ_Timer_Check()
  
  this.LastUpdate = this.LastUpdate + arg1
  if this.LastUpdate > this.UpdateRate then
    if PoJ.SpellsLoaded and PoJ.LastActionBarLock ~= LOCK_ACTIONBAR then
      if LOCK_ACTIONBAR == "0" then
        MainMenuBarPageNumber:SetTextColor(1, 0, 0)
      elseif LOCK_ACTIONBAR == "1" then
        MainMenuBarPageNumber:SetTextColor(1, 0.82, 0)
      end
      PoJ.LastActionBarLock = LOCK_ACTIONBAR
    end
    if PoJ.ClassString == "Shaman" then
      PoJ_SpellCooldown("Reincarnation")
    elseif PoJ.ClassString == "Warlock" then
      PoJ_SoulstoneCooldown()
    end
  end
end


function PoJ_SlashCommandHandler(command)
  if command == "" then
    PoJ_ToggleFrame(PoJ_Options)
  else
    local arg = {}
    for word in string.gmatch(command, "[^%s]+") do
      table.insert(arg, word)
    end
    local args = #arg
    local cmd = strlower(arg[1])
    if cmd == "help" then
      for _, helpline in ipairs(POJ_STRING.HELP) do
        PoJ_Comment(helpline, true)
      end
    elseif cmd == "item" then
      if args > 1 then
        local item = PoJ_GetItemLink(arg[2])
        if item then
          PoJ_Comment(item, true)
        else
          PoJ_Comment(POJ_STRING.OUTPUT.ITEMNOTFOUND, true)
        end
      end
    elseif cmd == "timer" then
      if args > 2 then
        local minutes = tonumber(arg[2])
        local text = table.concat(arg, " ", 3)
        local timerid = 1
        local timername = "TextRemind" .. timerid
        while PoJ_Timer_Exists(timername) do
          timerid = timerid + 1
          timername = "TextRemind" .. timerid
        end
        PoJ_Timer_Add(GetTime() + 60 * minutes, timername, "FUNCTION", {func = PoJ_TextRemind, params = {text}})
        PoJ_Comment(POJ_STRING.OUTPUT.TIMERSET .. " - " .. minutes .. " " .. POJ_STRING.OUTPUT.MINUTES .. ": " .. text, true)
      end
    end
  end
end


PoJ_DefineClassConstants = {}


function PoJ_DefineClassConstants.Hunter()
  PoJ.AspectCheetah = GetSpellInfo(5118)
  PoJ.AspectPack = GetSpellInfo(13159)
  PoJ.TrueshotAura = GetSpellInfo(19506)
  PoJ.AuraSkills = {
    {name = PoJ.AspectCheetah  },
    {name = PoJ.AspectPack     },
    {name = GetSpellInfo(13161)},
    {name = GetSpellInfo(13163)},
    {name = GetSpellInfo(13165)},
    {name = GetSpellInfo(20043)},
    {name = GetSpellInfo(34074)},
    {name = GetSpellInfo(61846)},
  }
end


function PoJ_DefineClassConstants.Paladin()
  PoJ.AuraSkills = {
    {name = GetSpellInfo(  465)},
    {name = GetSpellInfo( 7294)},
    {name = GetSpellInfo(19746)},
    {name = GetSpellInfo(19876)},
    {name = GetSpellInfo(19888)},
    {name = GetSpellInfo(19891)},
  }
end


function PoJ_DefineClassConstants.Shaman()
  PoJ.Spells.Reincarnation = {name = GetSpellInfo(20608)}
end


function PoJ_DefineClassConstants.Warlock()
  PoJ.SoulstoneIDs = {5232, 16892, 16893, 16895, 16896, 22116, 36895}
end


function PoJ_DefineLists()
  PoJ.ActionbarTimeColors = {
    buff     = {r = 0.6, g = 0.6, b = 1  },
    cooldown = {r = 1  , g = 0.6, b = 0.6},
    debuff   = {r = 0.4, g = 1  , b = 0.4},
  }
  
  PoJ.ErrorSuppression = {
    { name = "ERR_ABILITY_COOLDOWN", text = ERR_ABILITY_COOLDOWN }
  }
  
  if PoJ.ClassString == "Deathknight" then
    PoJ.ErrorSuppression[2] = { name = "ERR_SPELL_COOLDOWN"    , text = ERR_SPELL_COOLDOWN     }
    PoJ.ErrorSuppression[3] = { name = "ERR_OUT_OF_RUNES"      , text = ERR_OUT_OF_RUNES       }
    PoJ.ErrorSuppression[4] = { name = "ERR_OUT_OF_RUNIC_POWER", text = ERR_OUT_OF_RUNIC_POWER }
  elseif PoJ.ClassString == "Druid" then
    PoJ.ErrorSuppression[2] = { name = "ERR_SPELL_COOLDOWN"    , text = ERR_SPELL_COOLDOWN     }
    PoJ.ErrorSuppression[3] = { name = "ERR_OUT_OF_MANA"       , text = ERR_OUT_OF_MANA        }
    PoJ.ErrorSuppression[4] = { name = "ERR_OUT_OF_ENERGY"     , text = ERR_OUT_OF_ENERGY      }
    PoJ.ErrorSuppression[5] = { name = "ERR_OUT_OF_RAGE"       , text = ERR_OUT_OF_RAGE        }
  elseif PoJ.ClassString == "Rogue" then
    PoJ.ErrorSuppression[2] = { name = "ERR_OUT_OF_ENERGY"     , text = ERR_OUT_OF_ENERGY      }
  elseif PoJ.ClassString == "Warrior" then
    PoJ.ErrorSuppression[2] = { name = "ERR_OUT_OF_RAGE"       , text = ERR_OUT_OF_RAGE        }
  else
    PoJ.ErrorSuppression[2] = { name = "ERR_SPELL_COOLDOWN"    , text = ERR_SPELL_COOLDOWN     }
    PoJ.ErrorSuppression[3] = { name = "ERR_OUT_OF_MANA"       , text = ERR_OUT_OF_MANA        }
  end
  
  PoJ.SkillCooldownItems = {
    15846, -- Salt Shaker
  }
  
  PoJ.UseItems = {
    {itemid = 13143, slots = {11, 12}, bufftexture = "Interface\\Icons\\INV_Misc_Head_Dragon_01"   }, -- Mark of the Dragon Lord
    {itemid = 13937, slots = {16    }, bufftexture = "Interface\\Icons\\Spell_Totem_WardOfDraining"}, -- Headmaster's Charge
  }
end


function PoJ_DefineVars()
  PoJ.PlayerDead = UnitIsDeadOrGhost("player")
  
  if PoJ_Vars.ActionBar_x == nil then
    PoJ_Vars.ActionBar_x = 5
  end
  if PoJ_Vars.ActionBar_y == nil then
    PoJ_Vars.ActionBar_y = 300
  end
  if PoJ_Vars.ActionBarRows == nil then
    PoJ_Vars.ActionBarRows = 1
  end
  
  if PoJ_Vars.MenuBarPos == nil then
    PoJ_Vars.MenuBarPos = 0
  end
  
  if PoJ_Vars.Minimap_x == nil then
    PoJ_Vars.Minimap_x = 16
  end
  if PoJ_Vars.Minimap_y == nil then
    PoJ_Vars.Minimap_y = -121
  end
  PoJ_SetMinimapIconPos(PoJ_Vars.Minimap_x, PoJ_Vars.Minimap_y)
  
  if not PoJ_Vars.Notes then
    PoJ_Vars.Notes = {}
  end
  
  if PoJ_Vars.RemindRepeatTime == nil then
    PoJ_Vars.RemindRepeatTime = 3
  end
  
  if PoJ_Vars.ShowComments == nil then
    PoJ_Vars.ShowComments = true
  end
  
  if not PoJ_Vars.SkillCooldowns then
    PoJ_Vars.SkillCooldowns = {}
  end
  
  if not PoJ_CVars.Notes then
    PoJ_CVars.Notes = {}
  end
  
  PoJ_DefineVars_Convert()
  PoJ_Timer_Add(GetTime() + 3, "DefineVars_CVars" , "FUNCTION", {func = PoJ_DefineVars_CVars})
end


function PoJ_DefineVars_Convert()
  -- delete old settings
  PoJ_Vars.FastTrade = nil
  PoJ_Vars.StatusBarShow = nil
  PoJ_Vars.StatusModify = nil
  PoJ_Vars.StatusTarget = nil
  PoJ_Vars.TargetParty = nil
  PoJ_Vars.TargetPet = nil
  PoJ_CVars.ActionBarManastone = nil
  PoJ_CVars.CancelSalvation = nil
  PoJ_CVars.ShowSummonFailure = nil
  PoJ_CVars.ShowSummonMessage = nil
  PoJ_CVars.ShowSummonSuccess = nil
end


function PoJ_DefineVars_CVars()
  local value
  if PoJ_Vars.PlayerNamesShow == nil then
    PoJ_Vars.PlayerNamesShow = {}
  end
  if PoJ_Vars.PlayerNamesShow.Self == nil then
    value = PoJ_GetCVarFlag("UnitNameOwn")
    PoJ_Vars.PlayerNamesShow.Self = {Norm = value, City = value, Inst = value, Raid = value, BG = value, NoUI = value}
  end
  if PoJ_Vars.PlayerNamesShow.Rank == nil then
    value = PoJ_GetCVarFlag("UnitNamePlayerPVPTitle")
    PoJ_Vars.PlayerNamesShow.Rank = {Norm = value, City = value, Inst = value, Raid = value, BG = value, NoUI = value}
  end
  if PoJ_Vars.PlayerNamesShow.Guild == nil then
    value = PoJ_GetCVarFlag("UnitNamePlayerGuild")
    PoJ_Vars.PlayerNamesShow.Guild = {Norm = value, City = value, Inst = value, Raid = value, BG = value, NoUI = value}
  end
  if PoJ_Vars.PlayerNamesShow.NPCs == nil then
    value = PoJ_GetCVarFlag("UnitNameNPC")
    PoJ_Vars.PlayerNamesShow.NPCs = {Norm = value, City = value, Inst = value, Raid = value, BG = value, NoUI = value}
  end
  -- add new vars for patch 2.4
  if PoJ_Vars.PlayerNamesShow.Comp == nil then
    value = PoJ_GetCVarFlag("UnitNameCompanionName")
    PoJ_Vars.PlayerNamesShow.Comp = {Norm = value, City = value, Inst = value, Raid = value, BG = value, NoUI = value}
    if PoJ_Vars.PlayerNamesShow.Play then
      PoJ_Vars.PlayerNamesShow.PlayF = PoJ_Vars.PlayerNamesShow.Play
      PoJ_Vars.PlayerNamesShow.PlayE = PoJ_Vars.PlayerNamesShow.Play
      PoJ_Vars.PlayerNamesShow.Play  = nil
    else
      value = PoJ_GetCVarFlag("UnitNameFriendlyPlayerName")
      PoJ_Vars.PlayerNamesShow.PlayF = {Norm = value, City = value, Inst = value, Raid = value, BG = value, NoUI = value}
      value = PoJ_GetCVarFlag("UnitNameEnemyPlayerName")
      PoJ_Vars.PlayerNamesShow.PlayE = {Norm = value, City = value, Inst = value, Raid = value, BG = value, NoUI = value}
    end
    value = PoJ_GetCVarFlag("UnitNameFriendlyPetName")
    PoJ_Vars.PlayerNamesShow.PetsF = {Norm = value, City = value, Inst = value, Raid = value, BG = value, NoUI = value}
    value = PoJ_GetCVarFlag("UnitNameEnemyPetName")
    PoJ_Vars.PlayerNamesShow.PetsE = {Norm = value, City = value, Inst = value, Raid = value, BG = value, NoUI = value}
    value = PoJ_GetCVarFlag("UnitNameFriendlyCreationName")
    PoJ_Vars.PlayerNamesShow.CreaF = {Norm = value, City = value, Inst = value, Raid = value, BG = value, NoUI = value}
    value = PoJ_GetCVarFlag("UnitNameEnemyCreationName")
    PoJ_Vars.PlayerNamesShow.CreaE = {Norm = value, City = value, Inst = value, Raid = value, BG = value, NoUI = value}
  end
  -- new vars for 10/25 man instances
  if PoJ_Vars.PlayerNamesShow.Rank.In10 == nil then
    PoJ_Vars.PlayerNamesShow.Rank.In10 = PoJ_Vars.PlayerNamesShow.Rank.Inst
    PoJ_Vars.PlayerNamesShow.Rank.In40 = PoJ_Vars.PlayerNamesShow.Rank.Inst
    PoJ_Vars.PlayerNamesShow.Guild.In10 = PoJ_Vars.PlayerNamesShow.Guild.Inst
    PoJ_Vars.PlayerNamesShow.Guild.In40 = PoJ_Vars.PlayerNamesShow.Guild.Inst
    PoJ_Vars.PlayerNamesShow.Self.In10 = PoJ_Vars.PlayerNamesShow.Self.Inst
    PoJ_Vars.PlayerNamesShow.Self.In40 = PoJ_Vars.PlayerNamesShow.Self.Inst
    PoJ_Vars.PlayerNamesShow.PlayE.In10 = PoJ_Vars.PlayerNamesShow.PlayE.Inst
    PoJ_Vars.PlayerNamesShow.PlayE.In40 = PoJ_Vars.PlayerNamesShow.PlayE.Inst
    PoJ_Vars.PlayerNamesShow.PlayF.In10 = PoJ_Vars.PlayerNamesShow.PlayF.Inst
    PoJ_Vars.PlayerNamesShow.PlayF.In40 = PoJ_Vars.PlayerNamesShow.PlayF.Inst
    PoJ_Vars.PlayerNamesShow.PetsE.In10 = PoJ_Vars.PlayerNamesShow.PetsE.Inst
    PoJ_Vars.PlayerNamesShow.PetsE.In40 = PoJ_Vars.PlayerNamesShow.PetsE.Inst
    PoJ_Vars.PlayerNamesShow.PetsF.In10 = PoJ_Vars.PlayerNamesShow.PetsF.Inst
    PoJ_Vars.PlayerNamesShow.PetsF.In40 = PoJ_Vars.PlayerNamesShow.PetsF.Inst
    PoJ_Vars.PlayerNamesShow.CreaE.In10 = PoJ_Vars.PlayerNamesShow.CreaE.Inst
    PoJ_Vars.PlayerNamesShow.CreaE.In40 = PoJ_Vars.PlayerNamesShow.CreaE.Inst
    PoJ_Vars.PlayerNamesShow.CreaF.In10 = PoJ_Vars.PlayerNamesShow.CreaF.Inst
    PoJ_Vars.PlayerNamesShow.CreaF.In40 = PoJ_Vars.PlayerNamesShow.CreaF.Inst
    PoJ_Vars.PlayerNamesShow.Comp.In10 = PoJ_Vars.PlayerNamesShow.Comp.Inst
    PoJ_Vars.PlayerNamesShow.Comp.In40 = PoJ_Vars.PlayerNamesShow.Comp.Inst
    PoJ_Vars.PlayerNamesShow.NPCs.In10 = PoJ_Vars.PlayerNamesShow.NPCs.Inst
    PoJ_Vars.PlayerNamesShow.NPCs.In40 = PoJ_Vars.PlayerNamesShow.NPCs.Inst
  end
end
