-- strings for English version of "Piece of Justice"

function PoJ_DefineStringConstants_en()
  
  local cmdcolor = "|cffffffff"
  local epiccolor = PoJ_ColorString(ITEM_QUALITY_COLORS[4])
  local helpcolor = "|cffffff00"
  local poj = "|cffffa040Piece of Justice|r"
  local playerclass = UnitClass("player")
  local playername  = UnitName("player")
  
  BINDING_HEADER_POJ           = "Piece of Justice"
  BINDING_NAME_POJ_TOGGLE      = "Options"
  BINDING_NAME_POJ_TOGGLENOTES = "Notebook"
  BINDING_NAME_POJ_ACTION1     = "PoJ ActionBar Button 1"
  BINDING_NAME_POJ_ACTION2     = "PoJ ActionBar Button 2"
  BINDING_NAME_POJ_ACTION3     = "PoJ ActionBar Button 3"
  BINDING_NAME_POJ_ACTION4     = "PoJ ActionBar Button 4"
  
  POJ_STRING_PALADIN_AURA      = "Remind of Activation of Auras (e.g. after death)"
  
  POJ_STRING = {
    
    ACTIONBAR = {
      DICE          = "Roll",
      DICE_TIP      = "Rolls a random number between\n1 and 100\n(same as " .. cmdcolor .. "/random|r)",
      NOTES         = "Notebook",
      NOTES_TIP     = "Shows/hides the notebook.",
      TARGETID      = "Target Identification",
      TARGETID_TIP  = "Communicates information about the current target to the members of a group.\nIf there is no group (or if the option is not activated) the information is displayes as a comment.\n\nRightclick for communication menu",
      TARGETTOGUILD = "Guild",
      TARGETTOPARTY = "Group",
      TARGETTORAID  = "Raid",
      TARGETTOSELF  = "Chat Window",
    },
    
    CHAROPT = {
      ASPECTACTIVATION              = "Remind of Activation of Aspects",
      ASPECTACTIVATION_TIP          = "Remind of activation of aspects\nafter these were deactivated (e.g. by death)",
      ASPECTAUTOCANCEL              = "Deactivate Aspect of the Cheetah/Pack",
      ASPECTAUTOCANCEL_TIP          = "Automatically Deactivate Aspect of the Cheetah resp. Aspect of the Pack\nif combat mode is active",
      AURAACTIVATION                = "Remind of Activation of Auras",
      AURAACTIVATION_TIP            = "Remind of activation of auras\nafter these were deactivated (e.g. by death)",
      AURAACTIVATION2               = "Remind of Activation of Trueshot Aura",
      AURAACTIVATION2_TIP           = "Remind of activation of the Trueshot Aura\nafter it has run out or was deactivated",
      CHAR_TITLE                    = "Class Independent Settings",
      DRUID_TITLE                   = "Druid Settings",
      DUELFRIENDS                   = "Friends",
      DUELFRIENDS_TIP               = "Accept duel requests by friends",
      DUELGROUP                     = "Group Members",
      DUELGROUP_TIP                 = "Accept duel requests by group members",
      DUELGUILD                     = "Guild Members",
      DUELGUILD_TIP                 = "Accept duel requests by guild members",
      DUELIGNORE                    = "Reject Duel Request except from",
      DUELIGNORE_TIP                = "Automatically reject all duel requests",
      ERRORSUPPRESSION_TITLE        = "Suppress Error Texts",
      HUNTER_TITLE                  = "Hunter Settings",
      MAGE_TITLE                    = "Mage Settings",
      PALADIN_TITLE                 = "Paladin Settings",
      PICKPOCKETAUTOLOOT            = "Loot Picked Pockets Automatically",
      PICKPOCKETAUTOLOOT_TIP        = "Automatically loot when pocketpicking;\nin this way you can steal while stealthing past",
      RADARACTIVATION               = "Reactivate Last Tracking Skill",
      RADARACTIVATION_TIP           = "Reactivate the last used tracking skill when shifting back from " .. GetSpellInfo(768) .. " and " .. GetSpellInfo(5225) .. " was activated",
      ROGUE_TITLE                   = "Rogue Settings",
      SHAMAN_TITLE                  = "Shaman Settings",
      SHOWREINCARNATIONCOOLDOWN     = "Show Reincarnation Cooldown",
      SHOWREINCARNATIONCOOLDOWN_TIP = "Show a backward running timer with reincarnation cooldown\nleft below the player portrait",
      SHOWSOULSTONECOOLDOWN         = "Show Soulstone Cooldown",
      SHOWSOULSTONECOOLDOWN_TIP     = "Show a backward running timer with the soulstone cooldown\nleft below the player portrait",
      SHOWSOULSTONEMESSAGE          = "Notify Group of Soulstones Set",
      SHOWSOULSTONEMESSAGE_TIP      = "Notify setting of soulstones in group chat",
      SHOWSOULSTONENOTICE           = "Notice When Soulstone is available",
      SHOWSOULSTONENOTICE_TIP       = "Display a notice in the chat window when the soulstone is available",
      WARLOCK_TITLE                 = "Warlock Settings",
      WARRIOR_TITLE                 = "Warrior Settings",
    },
    
    CLASS = {
      DEATHKNIGHT = "Deathknight",
      DRUID       = "Druid",
      HUNTER      = "Hunter",
      MAGE        = "Mage",
      PALADIN     = "Paladin",
      PRIEST      = "Priest",
      ROGUE       = "Rogue",
      SHAMAN      = "Shaman",
      WARLOCK     = "Warlock",
      WARRIOR     = "Warrior",
    },
    
    CRAFTLIST = {
      CHARNAME = "Character",
      COOLDOWN = "Cooldown",
      REALM    = "Realm",
      SKILL    = "Skill",
    },
    
    GEMDESCRIPTION = {
      BLUE       = "Matches a Blue Socket.",
      GREEN1     = "Matches a Yellow or Blue Socket.",
      GREEN2     = "Matches a Blue or Yellow Socket.",
      META       = "Only fits in a meta gem slot.",
      ORANGE1    = "Matches a Red or Yellow Socket.",
      ORANGE2    = "Matches a Yellow or Red Socket.",
      PRISMATIC  = "Matches a Red, Yellow or Blue Socket.",
      PRISMATIC2 = "Matches any socket.",
      PURPLE1    = "Matches a Red or Blue Socket.",
      PURPLE2    = "Matches a Blue or Red Socket.",
      RED        = "Matches a Red Socket.",
      YELLOW     = "Matches a Yellow Socket.",
    },
    
    HELP = {
      helpcolor .. "/poj item <id>|r - Tries to create a link for the item with internal ID <id>, e.g. for the Hearthstone: /poj item 6948",
      helpcolor .. "/poj timer <min> <text>|r - Displays the reminder <text> inin <min> minutes, e.g. /poj timer 30 Auction over soon!",
    },
    
    MESSAGES = {
      ERRORSTOCHAT          = "Redirect Popups to Chat",
      ERRORSTOCHAT_TIP      = "Redirect many popup messages (addon errors, etc.) to the chat window",
      GENERAL_TITLE         = "General Messages",
      GRATSONLEVELUP        = "Congratulate Automatically",
      GRATSONLEVELUP_TIP    = "Automatically generate a congratulation emote if the player who levelled up is in range",
      POSTHOMETOPARTY       = "Broadcast Hearthstone Setting",
      POSTHOMETOPARTY_TIP   = "Broadcast setting of the hearthstone in group chat",
      REMIND_TITLE          = "Reminders/Notices",
      REMINDINTERVAL_LEFT   = "Remind Interval:",
      REMINDITEMS           = "Reminders for Special Items",
      REMINDITEMS_TIP       = "Reminds of the use of certain items\nwhen their cooldown has run off\nintegrated items:\n- " .. epiccolor .. "Headmaster's Charge|r\n- " .. epiccolor .. "Mark of the Dragon Lord|r",
      REMINDREPEAT          = "Repeat Reminders",
      REMINDREPEAT_TIP      = "Repeat Reminders after a certain amount of time,\nas long as the reason for it persists",
      REMINDSOUND           = "Play Sound",
      REMINDSOUND_TIP       = "Play a sound, when a reminder or notice is displayed",
      SHOWLEVELUPS          = "Notify on Level Ups",
      SHOWLEVELUPS_TIP      = "Displays a message in the chat window whenever a group member levels up",
      SHOWONLINEFRIENDS     = "Show Friends/Guild Members",
      SHOWONLINEFRIENDS_TIP = "Show online friends and guild members after logging in",
      SHOWTRADEPLAYER       = "Show Player Info",
      SHOWTRADEPLAYER_TIP   = "Show information about the trade partner (name, class) when a trade is started",
      TRADE_TITLE           = "Trade",
    },
    
    MOB = {
      BOSS      = "Boss",
      CHAMPION  = "Champion",
      DEAD      = "dead",
      ELITE     = "Elite",
      INFIGHT   = "in combat",
      MINIPET   = "Small Pet",
      MOB       = "Mob",
      NPC       = "NPC",
      PET       = "Pet",
      PLAYER    = "Player",
      RARE      = "Rare",
      RAREELITE = "Elite, Rare",
      TOTEM     = "Totem",
    },
    
    NOTES = {
      CHAR      = "Notes for " .. playername,
      GENERAL   = "General Notes",
      NAME      = "Change Title",
      NAMETITLE = "Note Title",
      TITLE     = "Notebook",
    },
    
    OPTION = {
      CHAROPT      = "Character Spezific Options for " .. playername,
      CHAROPT_TAB  = "Character",
      CRAFT        = "Craft Cooldowns",
      CRAFT_TAB    = "Crafting",
      MESSAGES     = "PoJ Message Options",
      MESSAGES_TAB = "Messages",
      POJUIOPT     = "PoJ Interface Options",
      POJUIOPT_TAB = "PoJ Interface",
      WORLDOPT     = "Game World Options",
      WORLDOPT_TAB = "Game World",
      WOWUIOPT     = "Additional WoW Interface Options",
      WOWUIOPT_TAB = "WoW Interface",
    },
    
    OUTPUT = {
      ASPECTREMIND          = "Activate Aspect",
      AURAREMIND            = "Activate Aura",
      BUFFCANCEL            = "%s deactivated",
      DUELREJECT            = "Rejected duel against %s",
      HEARTHSTONESET        = "Hearthstone set",
      ITEMNOTFOUND          = "Item not found.",
      ITEMREMIND            = "Use Item",
      KEYRINGEXTEND         = "Enlarge Keyring",
      LEVELUP               = "%s levelled up to %d",
      LEVELUPGRATS          = "%s levelled up to %d (automatic congratulations)",
      LEVELUPTOOFAR         = "%s levelled up to %d (out of range for congratulations)",
      MINUTES               = "minutes",
      NEWVERSION            = "A new version (%s) of " .. poj .. " has been released.",
      NOTICE                = "Notice",
      ONLINEFRIENDS         = "Friends Online",
      ONLINEGUILD           = "Guild Members Online",
      ONLINENOFRIENDS       = "No Friends Online",
      ONLINENOGUILD         = "No Guild Members Online",
      RADARREMIND           = "Activate Tracking",
      READY                 = "ready",
      REMIND                = "Reminder",
      SOULSTONENOTICE       = "Soulstone Available",
      SOULSTONERESURRECTION = "Soulstone Resurrection",
      SOULSTONESET          = "Soulstone set for %s",
      TIMERSET              = "Timer set",
      TRADESTART            = "Trade with",
    },
    
    POJUIOPT = {
      ACTIONBAR_TITLE        = "PoJ ActionBar",
      ACTIONBARDICE          = "Show Roll Button",
      ACTIONBARDICE_TIP      = "Show a roll button in the PoJ actionbar",
      ACTIONBARIDENT         = "Show Target Identification",
      ACTIONBARIDENT_TIP     = "Show a target identification button in the PoJ actionbar",
      ACTIONBARIDENTPART     = "Send to Group",
      ACTIONBARIDENTPART_TIP = "Send target identifications in group chat",
      ACTIONBARIDENTRAID     = "Send to Raid",
      ACTIONBARIDENTRAID_TIP = "Send target identifications in raid chat",
      ACTIONBARNOTES         = "Show Notebook",
      ACTIONBARNOTES_TIP     = "Show a button button for the PoJ notebook in the PoJ actionbar",
      ACTIONBARROWS = {
        ["1"]                = "1x4",
        ["1_TIP"]            = "1 row containing 4 buttons",
        ["2"]                = "2x2",
        ["2_TIP"]            = "2 rows containing 2 buttons each",
        ["4"]                = "4x1",
        ["4_TIP"]            = "4 rows containing 1 button each",
      },
      ACTIONBARSHOW          = "Show Actionbar",
      ACTIONBARSHOW_TIP      = "Show Piece of Justice action bar",
      COORD_TITLE            = "Coordinates",
      COORDSHOW              = "Show beneath Minimap",
      COORDSHOW_TIP          = "Show area coordinates beneath the WoW minimap",
      COORDSHOWMAP           = "Show on World Map",
      COORDSHOWMAP_TIP       = "Show area coordinates on the lower border of the WoW world map",
      GEMS_TITLE             = "Gems",
      GEMCOUNTERSHOW         = "Show Gem Color Counter",
      GEMCOUNTERSHOW_TIP     = "Show counter for currently used color categories in the character window.\n(for meta conditions)",
      MENUBAR_TITLE          = "WoW ActionBar Menu",
      MINIMAP_TITLE          = "PoJ Minimap Icon",
      MINIMAPICON            = "Show Minimap Icon",
      MINIMAPICON_TIP        = "Show an icon for Piece of Justice at the minimap",
      PVE_TITLE              = "PvE",
      PVP_TITLE              = "PvP",
      PVPCLASSES             = "Show Enemy Player Classes",
      PVPCLASSES_TIP         = "Show the class of an enemy player above the target window",
      RAIDICONS              = "Show Raid Target Icon Buttons",
      RAIDICONS_TIP          = "Show small raid icon buttons above the target window",
    },
    
    SKILL = {
      ALCHEMY           = "Alchemy",
      ALCHEMY_TRANSMUTE = "Transmute",
      ENCHANTING        = "Enchanting",
      ENCHANTING_SPHERE = "Sphere",
    },
    
    SLIDER = {
      MENUBARPOS      = "Horizontal Position",
      MENUBARPOS_HIGH = "Right",
      MENUBARPOS_LOW  = "Left",
    },
    
    WORLDOPT = {
      PLAYERNAMES       = "Show Names Depending on Situation",
      PLAYERNAMES_BG    = "Batteground",
      PLAYERNAMES_CITY  = "In City",
      PLAYERNAMES_COMP  = "Companions",
      PLAYERNAMES_CREA  = "Creation\nFriend/Enemy",
      PLAYERNAMES_GUILD = "Players'\nGuilds",
      PLAYERNAMES_INST  = "Instance (5 man)",
      PLAYERNAMES_IN10  = "Instance (10 man)",
      PLAYERNAMES_IN40  = "Instance (> 10)",
      PLAYERNAMES_NORM  = "Otherwise",
      PLAYERNAMES_NOUI  = "Without Interface",
      PLAYERNAMES_NPCS  = "NPCs and\nPets",
      PLAYERNAMES_PETS  = "Pets\nFriend/Enemy",
      PLAYERNAMES_PLAY  = "Players\nFriend/Enemy",
      PLAYERNAMES_RAID  = "In Raid",
      PLAYERNAMES_RANK  = "Players'\nRanks",
      PLAYERNAMES_SELF  = "Own\nName",
      PLAYERNAMES_TIP   = "show/hide names, ranks and guilds depending on the current situation",
      PLAYERNAMES_TITLE = "Names",
    },
    
    WOW = {
      CASTCHANNELSTRING = "Channeled",
      CASTTIMESTRING    = "([%d%.]+) sec cast",
      CHARGESTRING      = "(%d+) Charges",
      CITYNAMES         = {"Dalaran", "Darnassus", "Ironforge", "Orgrimmar", "Shattrath", "Silvermoon", "Stormwind City", "The Exodar", "The Undercity", "Thunder Bluff"},
      CITYINSTANCE      = {"Deeprun Tram"},
      DELETE            = "Delete",
      SPELLRANK         = "Rank",
      UNITLEVEL         = "Level",
    },
  
    WOWUIOPT = {
      AUTOFACTION          = "Change Faction Group automatically",
      AUTOFACTION_TIP      = "Automatically change faction group in the experience bar when gaining positive reputation",
      BUFFDURATION         = "Show Detailled Duration",
      BUFFDURATION_TIP     = "Shows buff and debuff durations split to the second when less than\nan hour is remaining and the WoW option \"Buff Duration\" is activated",
      BUFFS_TITLE          = "Buffs",
      CHAT_TITLE           = "Chat",
      CHATDOUBLE           = "Enlarge Chat Input",
      CHATDOUBLE_TIP       = "Enlarge the chat input box to whole screen width",
      CHATTIMESTAMP        = "Space After Timestamp",
      CHATTIMESTAMP_TIP    = "Insert a space after each timestamp",
      CHATTRANSLATION      = "Translate Links to English",
      CHATTRANSLATION_TIP  = "Item, enchant and skill names in chat will be translated to English\nif the name is stored in cache",
      HIDECHANNELJOINS     = "Hide Channel Joins/Leaves",
      HIDECHANNELJOINS_TIP = "Hide messages on other players' joins and leaves for user defined channels",
      MENUBAR_TITLE        = "WoW Actionbar Menu",
      NOMACRONAMES         = "Hide Macro Names",
      NOMACRONAMES_TIP     = "Hide names of macros on the WoW action buttons",
      NOMENUDECO           = "Hide Menu Decoration",
      NOMENUDECO_TIP       = "Hide the menu decoration (stone eagles) on both sides of the WoW main menu",
      QUESTLEVELS          = "Show Quest Level",
      QUESTLEVELS_TIP      = "Add quest level and one letter specification to the quest titles in the quest log",
      QUESTLOG_TITLE       = "Quest Log",
      RAID_TITLE           = "Raid",
      REPUTATION_TITLE     = "Reputation",
      SHOWACTION           = "Show Times",
      SHOWACTIONBD         = "Buff Run Times",
      SHOWACTIONBD_TIP     = "Show own buff run times as text on the WoW action buttons (blue)",
      SHOWACTIONCD         = "Show Cooldown Times",
      SHOWACTIONCD_TIP     = "Show cooldown times as text on the WoW action buttons (red)",
      SHOWACTIONOT         = "Show Optimal Reminding Cast Time",
      SHOWACTIONOT_TIP     = "Show optimal reminding cast times as text on the WoW action buttons (green)\nWhen this time runs out a spell (e.g. a damage over time spell) should be renewed to make the debuff run on the current target without losing time.",
      SHOWRAIDGROUP        = "Show Group Number",
      SHOWRAIDGROUP_TIP    = "Show players' group number in raids after the name",
      SPAMFILTER           = "Spam Filter",
      SPAMFILTER_TIP       = "Scan incoming chat for advertisement and filter it out",
      STATUSSMALLFONT      = "Small Status Bar Font",
      STATUSSMALLFONT_TIP  = "Use a smaller font size for status bar text",
      TARGETCOLORS         = "Use Faction Colors for Targets' Names",
      TARGETCOLORS_TIP     = "Display the names of all shown targets in faction colors (red/yellow/green/blue)",
      TARGETS_TITLE        = "Target Displays",
    },
  
  }
  
end
