-- Zeichenketten fr die deutsche Version von "Piece of Justice"

function PoJ_DefineStringConstants_de()
  
  local cmdcolor = "|cffffffff"
  local epiccolor = "|c" .. PoJ_ColorString(ITEM_QUALITY_COLORS[4])
  local helpcolor = "|cffffff00"
  local playerclass = UnitClass("player")
  local playername  = UnitName("player")
  local poj = "|cffffa040Piece of Justice|r"
  
  local ae = "\195\164" -- 
  local oe = "\195\182" -- 
  local Ue = "\195\156" -- 
  local ue = "\195\188" -- 
  local ss = "\195\159" -- 
  
  BINDING_HEADER_POJ           = "Piece of Justice"
  BINDING_NAME_POJ_TOGGLE      = "Einstellungen"
  BINDING_NAME_POJ_TOGGLENOTES = "Notizblock"
  BINDING_NAME_POJ_ACTION1     = "PoJ-Aktionsleiste Button 1"
  BINDING_NAME_POJ_ACTION2     = "PoJ-Aktionsleiste Button 2"
  BINDING_NAME_POJ_ACTION3     = "PoJ-Aktionsleiste Button 3"
  BINDING_NAME_POJ_ACTION4     = "PoJ-Aktionsleiste Button 4"
  
  POJ_STRING = {
    
    ACTIONBAR = {
      DICE          = "W" .. ue .. "rfeln",
      DICE_TIP      = "W" .. ue .. "rfelt eine Zufallszahl zwischen\n1 und 100\n(entspricht " .. cmdcolor .. "/random|r bzw. " .. cmdcolor .. "/w" .. ue .. "rfeln|r)",
      NOTES         = "Notizblock",
      NOTES_TIP     = "Zeigt/verbirgt den Notizblock.",
      TARGETID      = "Zielidentifikation",
      TARGETID_TIP  = Ue .. "bermittelt Informationen " .. ue .. "ber das aktuelle Ziel an die Mitglieder der Gruppe.\nIst keine Gruppe vorhanden (oder die Einstellung deaktiviert), so wird die Information als Kommentar ausgegeben.\n\nRechtsklick f" .. ue .. "r Kommunikationsmen" .. ue,
      TARGETTOGUILD = "Gilde",
      TARGETTOPARTY = "Gruppe",
      TARGETTORAID  = "Schlachtgruppe",
      TARGETTOSELF  = "Chatfenster",
    },
    
    CHAROPT = {
      ASPECTACTIVATION              = "Erinnerung an Aspekte",
      ASPECTACTIVATION_TIP          = "Erinnert an die Aktivierung von Aspekten,\nwenn diese deaktiviert wurden (z.B. nach dem Tod)",
      ASPECTAUTOCANCEL              = "Aspekt des Geparden/Rudels deaktivieren",
      ASPECTAUTOCANCEL_TIP          = "Deaktiviert Aspekt des Geparden bzw. Aspekt des Rudels automatisch,\nwenn der Kampfmodus aktiv wird",
      AURAACTIVATION                = "Erinnerung an Aktivierung von Auren",
      AURAACTIVATION_TIP            = "Erinnert an die Aktivierung von Auren,\nwenn diese deaktiviert wurden (z.B. nach dem Tod)",
      AURAACTIVATION2               = "Erinnerung an Aura des Volltreffers",
      AURAACTIVATION2_TIP           = "Erinnert an die Aktivierung der Aura des Volltreffers,\nwenn diese abgelaufen ist oder deaktiviert wurde",
      CHAR_TITLE                    = "Klassenunabh" .. ae .. "ngige Einstellungen",
      DRUID_TITLE                   = "Druiden-Einstellungen",
      DUELFRIENDS                   = "Freunden",
      DUELFRIENDS_TIP               = "Duellaufforderungen von Freunden akzeptieren",
      DUELGROUP                     = "Gruppenmitgliedern",
      DUELGROUP_TIP                 = "Duellaufforderungen von Gruppenmitgliedern akzeptieren",
      DUELGUILD                     = "Gildenmitgliedern",
      DUELGUILD_TIP                 = "Duellaufforderungen von Gildenmitgliedern akzeptieren",
      DUELIGNORE                    = "Aufforderungen zu Duellen automatisch ablehnen au" .. ss .. "er von",
      DUELIGNORE_TIP                = "Lehnt alle Duellaufforderungen automatisch ab",
      ERRORSUPPRESSION_TITLE        = "Fehlertexte unterdr" .. ue .. "cken",
      HUNTER_TITLE                  = "J" .. ae .. "ger-Einstellungen",
      MAGE_TITLE                    = "Magier-Einstellungen",
      PALADIN_TITLE                 = "Paladin-Einstellungen",
      PICKPOCKETAUTOLOOT            = "Bei Taschendiebstahl auto-pl" .. ue .. "ndern",
      PICKPOCKETAUTOLOOT_TIP        = "Pl" .. ue .. "ndert die Beute bei einem Taschendiebstahl automatisch,\nsodass man im Vorbeischleichen stehlen kann",
      RADARACTIVATION               = "Letzte Aufsp" .. ue .. "rfertigkeit reaktivieren",
      RADARACTIVATION_TIP           = "Reaktiviert die zuletzt verwendete Aufsp" .. ue .. "rfertigkeit beim Wechseln aus der " .. GetSpellInfo(768) .. ",\nwenn " .. GetSpellInfo(5225) .. " aktiviert wurde",
      ROGUE_TITLE                   = "Schurken-Einstellungen",
      SHAMAN_TITLE                  = "Schamanen-Einstellungen",
      SHOWREINCARNATIONCOOLDOWN     = "Abklingzeit von Reinkarnation anzeigen",
      SHOWREINCARNATIONCOOLDOWN_TIP = "Zeigt einen r" .. ue .. "ckw" .. ae .. "rts laufenden Zeitz" .. ae .. "hler mit der Abklingzeit von Reinkarnation\nlinks unterhalb des Spielerportraits an",
      SHOWSOULSTONECOOLDOWN         = "Abklingzeit des Seelensteins anzeigen",
      SHOWSOULSTONECOOLDOWN_TIP     = "Zeigt einen r" .. ue .. "ckw" .. ae .. "rts laufenden Zeitz" .. ae .. "hler mit der Abklingzeit des Seelensteins\nlinks unterhalb des Spielerportraits an",
      SHOWSOULSTONEMESSAGE          = "Seelensteine an Gruppe melden",
      SHOWSOULSTONEMESSAGE_TIP      = "Verk" .. ue .. "ndet das Setzen von Seelensteinen im Gruppenchat",
      SHOWSOULSTONENOTICE           = "Hinweis, wenn  Seelenstein verf" .. ue .. "gbar",
      SHOWSOULSTONENOTICE_TIP       = "Gibt einen Hinweis im Chatfenster aus, sobald der Seelenstein verf" .. ue .. "gbar ist",
      WARLOCK_TITLE                 = "Hexenmeister-Einstellungen",
      WARRIOR_TITLE                 = "Krieger-Einstellungen",
    },
    
    CLASS = {
      DEATHKNIGHT = "Todesritter",
      DRUID       = "Druide",
      HUNTER      = "J" .. ae .. "ger",
      MAGE        = "Magier",
      PALADIN     = "Paladin",
      PRIEST      = "Priester",
      ROGUE       = "Schurke",
      SHAMAN      = "Schamane",
      WARLOCK     = "Hexenmeister",
      WARRIOR     = "Krieger",
    },
    
    CRAFTLIST = {
      CHARNAME = "Charakter",
      COOLDOWN = "Abklingzeit",
      REALM    = "Realm",
      SKILL    = "Fertigkeit",
    },
    
    GEMDESCRIPTION = {
      BLUE       = "Am besten f" .. ue .. "r einen blauen Sockel geeignet.",
      GREEN1     = "Am besten f" .. ue .. "r einen gelben oder blauen Sockel geeignet.",
      GREEN2     = "Am besten f" .. ue .. "r einen blauen oder gelben Sockel geeignet.",
      META       = "Passt nur in einen Sockel der Kategorie Meta.",
      ORANGE1    = "Am besten f" .. ue .. "r einen roten oder gelben Sockel geeignet.",
      ORANGE2    = "Am besten f" .. ue .. "r einen gelben oder roten Sockel geeignet.",
      PRISMATIC  = "Am besten f" .. ue .. "r einen roten, gelben oder blauen Sockel geeignet.",
      PRISMATIC2 = "F" .. ue .. "r jeden Sockel geeignet.",
      PURPLE1    = "Am besten f" .. ue .. "r einen roten oder blauen Sockel geeignet.",
      PURPLE2    = "Am besten f" .. ue .. "r einen blauen oder roten Sockel geeignet.",
      RED        = "Am besten f" .. ue .. "r einen roten Sockel geeignet.",
      YELLOW     = "Am besten f" .. ue .. "r einen gelben Sockel geeignet.",
    },
    
    HELP = {
      helpcolor .. "/poj item <id>|r - Versucht, eine Verkn" .. ue .. "pfung auf den Gegenstand mit der internen ID <id> zu erstellen, z.B. f" .. ue .. "r den Ruhestein: /poj item 6948",
      helpcolor .. "/poj timer <min> <text>|r - Gibt in <min> Minuten die Erinnerungsmeldung <text> aus, z.B. /poj timer 30 Auktion l" .. ae .. "uft bald ab!",
    },
    
    MESSAGES = {
      ERRORSTOCHAT          = "Popup-Meldungen in den Chat umleiten",
      ERRORSTOCHAT_TIP      = "Leitet viele Popup-Meldungen (Addon-Fehler, etc.) in das Chatfenster um",
      GENERAL_TITLE         = "Allgemeine Meldungen",
      GRATSONLEVELUP        = "automatisch gratulieren",
      GRATSONLEVELUP_TIP    = "Erzeugt einen automatischen Gratulations-Emote, wenn der aufgestiegene Spieler in Reichweite ist",
      POSTHOMETOPARTY       = "Ruhesteinsetzung mitteilen",
      POSTHOMETOPARTY_TIP   = "Verk" .. ue .. "ndet das Setzen des Ruhesteins im Gruppenchat",
      REMIND_TITLE          = "Erinnerungen/Hinweise",
      REMINDINTERVAL_LEFT   = "Erinnerungsintervall:",
      REMINDITEMS           = "Erinnerungen f" .. ue .. "r spezielle Gegenst" .. ae .. "nde",
      REMINDITEMS_TIP       = "Erinnert an die Benutzung bestimmter Gegenst" .. ae .. "nde,\nwenn deren Abklingzeit abgelaufen ist\nIntegrierte Gegenst" .. ae .. "nde:\n- " .. epiccolor .. "Attacke des Direktors|r\n- " .. epiccolor .. "Mal des Drachenlords|r",
      REMINDREPEAT          = "Erinnerungen wiederholen",
      REMINDREPEAT_TIP      = "Wiederholt Erinnerungen nach einer bestimmten Zeit,\nso lange bis der Grund f" .. ue .. "r die Erinnerung beseitigt wurde",
      REMINDSOUND           = "akustisches Signal ausgeben",
      REMINDSOUND_TIP       = "Spielt einen Ton ab, wenn eine Erinnerung oder ein Hindweis erfolgt",
      SHOWLEVELUPS          = "Hinweise bei Stufenaufstieg",
      SHOWLEVELUPS_TIP      = "Gibt eine Meldung im Chatfenster aus, wenn ein Gruppenmitglied eine neue Stufe erreicht",
      SHOWONLINEFRIENDS     = "Freunde/Gildenmitglieder anzeigen",
      SHOWONLINEFRIENDS_TIP = "Zeigt beim Einloggen an, welche Freunde und Gildenmitglieder online sind",
      SHOWTRADEPLAYER       = "Spielerinfos anzeigen",
      SHOWTRADEPLAYER_TIP   = "Zeigt beim Start eines Handels Informationen " .. ue .. "ber den Handelspartner an (Name, Klasse)",
      TRADE_TITLE           = "Handel",
    },
    
    MOB = {
      BOSS      = "Boss",
      CHAMPION  = "Champion",
      DEAD      = "tot",
      ELITE     = "Elite",
      INFIGHT   = "im Kampf",
      MINIPET   = "Haustier",
      MOB       = "Mob",
      NPC       = "NSC",
      PET       = "Begleiter",
      PLAYER    = "Spieler",
      RARE      = "selten",
      RAREELITE = "Elite, selten",
      TOTEM     = "Totem",
    },
    
    NOTES = {
      CHAR      = "Notizen f" .. ue .. "r " .. playername,
      GENERAL   = "Allgemeine Notizen",
      NAME      = "Titel " .. ae .. "ndern",
      NAMETITLE = "Titel der Notiz",
      TITLE     = "Notizblock",
    },
    
    OPTION = {
      CHAROPT      = "Charakterspezifische Einstellungen f" .. ue .. "r " .. playername,
      CHAROPT_TAB  = "Charakter",
      CRAFT        = "Abklingzeiten f" .. ue .. "r Berufe",
      CRAFT_TAB    = "Berufe",
      MESSAGES     = "Einstellungen f" .. ue .. "r PoJ-Meldungen",
      MESSAGES_TAB = "Meldungen",
      POJUIOPT     = "Einstellungen der PoJ-Oberfl" .. ae .. "chenelemente",
      POJUIOPT_TAB = "PoJ-Oberfl" .. ae .. "che",
      WORLDOPT     = "Einstellungen f" .. ue .. "r Elemente der Spielwelt",
      WORLDOPT_TAB = "Spielwelt",
      WOWUIOPT     = "Einstellungen f" .. ue .. "r WoW-Oberfl" .. ae .. "chenelemente",
      WOWUIOPT_TAB = "WoW-Oberfl" .. ae .. "che",
    },
    
    OUTPUT = {
      ASPECTREMIND          = "Aspekt aktivieren",
      AURAREMIND            = "Aura aktivieren",
      BUFFCANCEL            = "%s deaktiviert",
      DUELREJECT            = "Duell gegen %s abgelehnt",
      HEARTHSTONESET        = "Ruhestein gesetzt",
      ITEMNOTFOUND          = "Gegenstand nicht gefunden.",
      ITEMREMIND            = "Gegenstand benutzen",
      KEYRINGEXTEND         = "Schl" .. ue .. "sselbund vergr" .. oe .. ss .. "ern",
      LEVELUP               = "%s ist auf Stufe %d gestiegen",
      LEVELUPGRATS          = "%s ist auf Stufe %d gestiegen (automatische Gratulation)",
      LEVELUPTOOFAR         = "%s ist auf Stufe %d gestiegen (au" .. ss .. "er Reichweite f" .. ue .. "r Gratulation)",
      MINUTES               = "Minuten",
      NEWVERSION            = "Es gibt eine neue Version (%s) von " .. poj .. ".",
      NOTICE                = "Hinweis",
      ONLINEFRIENDS         = "Freunde online",
      ONLINEGUILD           = "Gildenmitglieder online",
      ONLINENOFRIENDS       = "Keine Freunde online",
      ONLINENOGUILD         = "Keine Gildenmitglieder online",
      RADARREMIND           = "Kartensuche aktivieren",
      READY                 = "bereit",
      REMIND                = "Erinnerung",
      SOULSTONENOTICE       = "Seelenstein verf" .. ue .. "gbar",
      SOULSTONERESURRECTION = "Seelenstein-Auferstehung",
      SOULSTONESET          = "Seelenstein gesetzt auf %s",
      TIMERSET              = "Timer gesetzt",
      TRADESTART            = "Handel mit",
    },
    
    POJUIOPT = {
      ACTIONBAR_TITLE        = "PoJ-Aktionsleiste",
      ACTIONBARDICE          = "W" .. ue .. "rfel anzeigen",
      ACTIONBARDICE_TIP      = "Den Button f" .. ue .. "r den W" .. ue .. "rfel in der PoJ-Aktionsleiste anzeigen",
      ACTIONBARIDENT         = "Zielidentifikation anzeigen",
      ACTIONBARIDENT_TIP     = "Den Button f" .. ue .. "r die Zielidentifikation in der PoJ-Aktionsleiste anzeigen",
      ACTIONBARIDENTPART     = "an Gruppe schicken",
      ACTIONBARIDENTPART_TIP = "Die Identifikation eines Ziels im Gruppenchat senden",
      ACTIONBARIDENTRAID     = "an Schlachtgruppe schicken",
      ACTIONBARIDENTRAID_TIP = "Die Identifikation eines Ziels im Schlachtgruppenchat senden",
      ACTIONBARNOTES         = "Notizblock anzeigen",
      ACTIONBARNOTES_TIP     = "Den Button f" .. ue .. "r das PoJ-Notizbuch in der PoJ-Aktionsleiste anzeigen",
      ACTIONBARROWS = {
        ["1"]                = "1x4",
        ["1_TIP"]            = "1 Zeile mit 4 Buttons",
        ["2"]                = "2x2",
        ["2_TIP"]            = "2 Zeilen mit je 2 Buttons",
        ["4"]                = "4x1",
        ["4_TIP"]            = "4 Zeilen mit je 1 Button",
      },
      ACTIONBARSHOW          = "Aktionsleiste anzeigen",
      ACTIONBARSHOW_TIP      = "Die Aktionsleiste von Piece of Justice anzeigen",
      COORD_TITLE            = "Koordinaten",
      COORDSHOW              = "unter der Minikarte anzeigen",
      COORDSHOW_TIP          = "Zonenkoordinaten underhalb der WoW-Minikarte anzeigen",
      COORDSHOWMAP           = "auf der Weltkarte anzeigen",
      COORDSHOWMAP_TIP       = "Zonenkoordinaten am unteren Rand der WoW-Weltkarte anzeigen",
      GEMS_TITLE             = "Edelsteine",
      GEMCOUNTERSHOW         = "Farbz" .. ae .. "hler anzeigen",
      GEMCOUNTERSHOW_TIP     = "Die Anzahl der derzeit benutzten Farbkategorien im Charakterfenster anzeigen.\n(f" .. ue .. "r Metabedingungen)",
      MINIMAP_TITLE          = "PoJ-Kartensymbol",
      MINIMAPICON            = "Kartensymbol anzeigen",
      MINIMAPICON_TIP        = "Ein Symbol f" .. ue .. "r Piece of Justice an der Minikarte anzeigen",
      PVE_TITLE              = "PvE",
      PVP_TITLE              = "PvP",
      PVPCLASSES             = "Klassen gegnerischer Spieler anzeigen",
      PVPCLASSES_TIP         = "Die Klasse eines gegnerischen Spielers " .. ue .. "ber dem Zielfenster anzeigen",
      RAIDICONS              = "Buttons f" .. ue .. "r Schlachtzugsymbole anzeigen",
      RAIDICONS_TIP          = "Kleine Buttons f" .. ue .. "r Schlachtzugsymbole " .. ue .. "ber dem Zielfenster anzeigen",
    },
    
    SKILL = {
      ALCHEMY           = "Alchemie",
      ALCHEMY_TRANSMUTE = "Transmutieren",
      ENCHANTING        = "Verzauberkunst",
      ENCHANTING_SPHERE = "Sph" .. ae .. "re",
    },
    
    SLIDER = {
      MENUBARPOS      = "horizontale Position",
      MENUBARPOS_HIGH = "rechts",
      MENUBARPOS_LOW  = "links",
    },
    
    WORLDOPT = {
      PLAYERNAMES       = "Namen situationsbedingt anzeigen",
      PLAYERNAMES_BG    = "auf Schlachtfeldern",
      PLAYERNAMES_CITY  = "in Hauptst" .. ae .. "dten",
      PLAYERNAMES_COMP  = "Gef" .. ae .. "hrten",
      PLAYERNAMES_CREA  = "Kreation\nFreund/Feind",
      PLAYERNAMES_GUILD = "Spieler-\ngilden",
      PLAYERNAMES_INST  = "in Instanzen (5er)",
      PLAYERNAMES_IN10  = "in Instanzen (10er)",
      PLAYERNAMES_IN40  = "in Instanzen (> 10)",
      PLAYERNAMES_NORM  = "ansonsten",
      PLAYERNAMES_NOUI  = "ohne Interface",
      PLAYERNAMES_NPCS  = "NSCs",
      PLAYERNAMES_PETS  = "Begleiter\nFreund/Feind",
      PLAYERNAMES_PLAY  = "Spieler\nFreund/Feind",
      PLAYERNAMES_RAID  = "in Schlachtgruppen",
      PLAYERNAMES_RANK  = "Spieler-\nr" .. ae .. "nge",
      PLAYERNAMES_SELF  = "eigener\nName",
      PLAYERNAMES_TIP   = "Namen, R" .. ae .. "nge und Gilden je nach Situation ein-/ausblenden",
      PLAYERNAMES_TITLE = "Namen",
    },
    
    WOW = {
      CASTCHANNELSTRING = "Kanalisiert",
      CASTTIMESTRING    = "Wirken in ([%d,]+) Sek%.",
      CHARGESTRING      = "(%d+) Aufladungen",
      CITYNAMES         = {"Dalaran", "Darnassus", "Die Exodar", "Donnerfels", "Eisenschmiede", "Orgrimmar", "Shattrath", "Silbermond", "Sturmwind", "Unterstadt"},
      CITYINSTANCE      = {"Die Tiefenbahn"},
      DELETE            = "L" .. oe .. "schen",
      SPELLRANK         = "Rang",
      UNITLEVEL         = "Stufe",
    },
  
    WOWUIOPT = {
      AUTOFACTION          = "Fraktion automatisch wechseln",
      AUTOFACTION_TIP      = "Wechselt bei positivem Rufzuwachs automatisch die Fraktion in der Erfahrungsleiste",
      BUFFDURATION         = "Restdauern sekundengenau anzeigen",
      BUFFDURATION_TIP     = "Zeigt bei eingeschalteter WoW-Option \"St" .. ae .. "rkungszauberdauer\" die\nRestdauern von St" .. ae .. "rkungs- und Schw" .. ae .. "chungszaubern auf die Sekunde\ngenau an, sobald diese weniger als eine Stunde betragen",
      BUFFS_TITLE          = "St" .. ae .. "rkungszauber",
      CHAT_TITLE           = "Chat",
      CHATDOUBLE           = "Chateingabe verbreitern",
      CHATDOUBLE_TIP       = "Vergr" .. oe .. ss .. "ert die Eingabebox f" .. ue .. "r den Chat " .. ue .. "ber die gesamte Bildschirmbreite",
      CHATTIMESTAMP        = "Leerzeichen nach Zeitstempel",
      CHATTIMESTAMP_TIP    = "F" .. ue .. "gt ein Leerzeichen nach jedem Zeitstempel ein",
      CHATTRANSLATION      = "Links auf Deutsch " .. ue .. "bersetzen",
      CHATTRANSLATION_TIP  = "Namen von Gegenst" .. ae .. "nden, Verzauberungen und\nFertigkeiten im Chat werden auf Deutsch " .. ue .. "bersetzt,\nwenn der entsprechende Name im Cache gespeichert ist",
      HIDECHANNELJOINS     = "Channelzu/-abg" .. ae .. "nge verstecken",
      HIDECHANNELJOINS_TIP = "Versteckt Meldungen, dass andere Spieler einen benutzerdefinierten Channel betreten oder verlassen",
      MENUBAR_TITLE        = "WoW-Aktionsleistenmen" .. ue,
      NOMACRONAMES         = "Makronamen ausblenden",
      NOMACRONAMES_TIP     = "Auf den WoW-Aktionsbuttons die Makronamen verstecken",
      NOMENUDECO           = "Men" .. ue .. "verzierungen ausblenden",
      NOMENUDECO_TIP       = "Die Verzierungen (Steinadler) auf den Seiten des WoW-Hauptmen" .. ue .. "s ausblenden",
      QUESTLEVELS          = "Queststufen anzeigen",
      QUESTLEVELS_TIP      = "Den Questtiteln im Questlog die Queststufe sowie eine Abk" .. ue .. "rzung der Spezifikation hinzuf" .. ue .. "gen",
      QUESTLOG_TITLE       = "Questlog",
      RAID_TITLE           = "Schlachtgruppe",
      REPUTATION_TITLE     = "Ruf",
      SHOWACTION           = "Zeiten anzeigen",
      SHOWACTIONBD         = "St" .. ae .. "rkungszauberlaufzeiten",
      SHOWACTIONBD_TIP     = "Auf den WoW-Aktionsbuttons die Restlaufzeiten von eigenen St" .. ae .. "rkungszaubern anzeigen (blau)",
      SHOWACTIONCD         = "Abklingzeiten",
      SHOWACTIONCD_TIP     = "Auf den WoW-Aktionsbuttons die Abklingzeiten als Text anzeigen (rot)",
      SHOWACTIONOT         = "Optimale Restlaufzeiten",
      SHOWACTIONOT_TIP     = "Auf den WoW-Aktionsbuttons die optimalen Restlaufzeiten als Text anzeigen (gr" .. ue .. "n)\nNach Ablauf dieser Zeit kann ein Spruch (z.B. vom Typ Schaden " .. ue .. "ber Zeit) neu gewirkt werden,\num ohne Zeitverlust weiter auf dem aktuellen Ziel wirken zu k" .. oe .. "nnen.",
      SHOWRAIDGROUP        = "Gruppennummer anzeigen",
      SHOWRAIDGROUP_TIP    = "Zeigt in Schlachtgruppen die Gruppennummer von Spielern hinter deren Namen an",
      SPAMFILTER           = "Spamfilter",
      SPAMFILTER_TIP       = "Durchsucht den ankommenden Chat nach Werbenachrichten und blendet diese aus",
      STATUSSMALLFONT      = "kleinere Schrift f" .. ue .. "r Statusbalken",
      STATUSSMALLFONT_TIP  = "Eine geringere Schriftgr" .. oe .. ss .. "e f" .. ue .. "r den Text der Statusbalken benutzen",
      TARGETCOLORS         = "Zielnamen farbkodieren",
      TARGETCOLORS_TIP     = "Die Namen aller angezeigten Ziele farbig darstellen (rot/gelb/gr" .. ue .. "n/blau)",
      TARGETS_TITLE        = "Zielanzeigen",
},
    
  }
  
end
