function PoJ_SetHooks()
  PoJ_SetHook_ActionButton_OnUpdate()
  PoJ_SetHook_ActionButton_Update()
  PoJ_SetHook_ActionButton_UpdateCooldown()
  PoJ_SetHook_CancelUnitBuff()
  PoJ_SetHook_ChatFrame_OnEvent()
  PoJ_SetHook_ContainerFrame_GenerateFrame()
  PoJ_SetHook_ContainerFrame_UpdateCooldown()
  PoJ_SetHook_ERRORMESSAGE()
  InterfaceOptionsSocialPanelTimestamps_SetValue()
  PoJ_SetHook_MainMenuBar_SetPoint()
  PoJ_SetHook_PlayerFrame_UpdateGroupIndicator()
  PoJ_SetHook_QuestLog_Update()
  PoJ_SetHook_SecondsToTimeAbbrev()
  PoJ_SetHook_StaticPopup_Show()
  PoJ_SetHook_ToggleFrame()
  PoJ_SetHook_UIParent_ShowHide()
  PoJ_SetHook_UnitFrame_Update()
  PoJ_SetHook_WorldMap_ToggleSize()
end


function PoJ_SetHook_ActionButton_OnUpdate()
  hooksecurefunc(
    "ActionButton_OnUpdate",
    function(elapsed)
      PoJ_WoWActionButtonUpdate()
    end
  )
end


function PoJ_SetHook_ActionButton_Update()
  hooksecurefunc(
    "ActionButton_Update",
    PoJ_UpdateActionButtonMacroName
  )
end


function PoJ_SetHook_ActionButton_UpdateCooldown()
  hooksecurefunc(
    "ActionButton_UpdateCooldown",
    PoJ_WoWActionButtonUpdate
  )
end


function PoJ_SetHook_CancelUnitBuff()
  hooksecurefunc(
    "CancelUnitBuff",
    function(unit, index, mine)
      if unit == "player" then
        PoJ.LastCancelledBuffName = UnitBuff("player", index, mine)
        PoJ.LastCancelledBuffTime = GetTime()
      end
    end
  )
end


function PoJ_SetHook_ChatFrame_OnEvent()
  local ChatFrame_OnEvent_default = ChatFrame_OnEvent
  
  function ChatFrame_OnEvent(self, event, ...)
    
    local blocked
    
    -- link translation
    if PoJ_Vars.ChatTranslation and (event == "CHAT_MSG_BATTLEGROUND" or event == "CHAT_MSG_BATTLEGROUND_LEADER" or event == "CHAT_MSG_CHANNEL" or event == "CHAT_MSG_EMOTE" or event == "CHAT_MSG_GUILD" or event == "CHAT_MSG_OFFICER" or event == "CHAT_MSG_PARTY" or event == "CHAT_MSG_RAID" or event == "CHAT_MSG_RAID_LEADER" or event == "CHAT_MSG_RAID_WARNING" or event == "CHAT_MSG_SAY" or event == "CHAT_MSG_WHISPER" or event == "CHAT_MSG_YELL") then
      local link, linkend, linkstart, linktype, namenew, nameold
      linkstart = 0
      while linkstart do
        linkstart, linkend, link = strfind(arg1, "(|H%a+:[:%d]+|h%[[^%[%]]+%]|h)", linkstart + 1)
        namenew = nil
        if link then
          linktype, nameold = string.match(link, "|H(%a+):[:%d]+|h%[([^%[%]]+)%]|h")
          if linktype == "item" then
            namenew = GetItemInfo(link)
            if not namenew then
              PoJ_ShowBottomtip(PoJ_Tooltip)
              PoJ_Tooltip:SetHyperlink(string.match(link, "|H(%a+:[:%d]+)|h%[[^%[%]]+%]|h"))
              PoJ_Tooltip:Show()
              PoJ_Tooltip:Hide()
            end
          elseif linktype == "spell" then
            namenew = GetSpellInfo(string.match(link, "|Hspell:(%d+)|h%[[^%[%]]+%]|h"))
          elseif linktype == "enchant" then
            PoJ_ShowBottomtip(PoJ_Tooltip)
            PoJ_Tooltip:SetHyperlink(string.match(link, "|H(%a+:[:%d]+)|h%[[^%[%]]+%]|h"))
            PoJ_Tooltip:Show()
            PoJ_Tooltip:Hide()
          end
          if namenew and namenew ~= nameold then
            arg1 = strsub(arg1, 1, linkstart - 1) .. string.gsub(link, nameold, namenew) .. strsub(arg1, linkend + 1)
          end
        end
      end
    end
    
    -- spam filter
    if PoJ_Vars.SpamFilter and (event == "CHAT_MSG_CHANNEL" or event == "CHAT_MSG_EMOTE" or event == "CHAT_MSG_SAY" or event == "CHAT_MSG_WHISPER" or event == "CHAT_MSG_YELL") then
      local now = time()
      if arg2 == PoJ_LastSpammer and now < PoJ_LastSpamTime + 10 then
        blocked = true
      else
        local low = strlower(arg1)
        if strfind(low, "w w w.+c o m") then
          blocked = true
        else
          local count = 0
          local nospace = string.gsub(low, " ", "")
          if strfind(nospace, "www[%.,]") or strfind(nospace, "[%.,]co[mn]") or strfind(nospace, "[%.,]net") then
            count = count + 1
          end
          if strfind(nospace, "free") or strfind(nospace, "gold") or strfind(nospace, "level") or strfind(nospace, "peon") or strfind(nospace, "price") or strfind(nospace, "profession") or strfind(nospace, "service") or strfind(nospace, "00g") or strfind(nospace, "24.7") then
            count = count + 1
          end
          if strfind(arg1, "EUR") or strfind(nospace, "$") or strfind(nospace, "\226\130\172") then
            count = count + 1
          end
          if count > 1 then
            blocked = true
          end
        end
      end
      if blocked then
        PoJ_LastSpammer = arg2
        PoJ_LastSpamTime = now
      end
    end
    
    if not blocked then
      ChatFrame_OnEvent_default(self, event, ...)
    end
    
  end
  
end


function PoJ_SetHook_ContainerFrame_GenerateFrame()
  hooksecurefunc(
    "ContainerFrame_GenerateFrame",
    function(frame, size, id)
      if id == KEYRING_CONTAINER then
        PoJ_KeyRingExtendButton:SetParent(frame)
        PoJ_KeyRingExtendButton:SetPoint("TOPRIGHT", frame, "TOPRIGHT", -10, -31)
        if size == GetContainerNumSlots(KEYRING_CONTAINER) then
          PoJ_KeyRingExtendButton:Hide()
        else
          PoJ_KeyRingExtendButton:Show()
        end
      elseif PoJ_KeyRingExtendButton:GetParent() == frame then
        PoJ_KeyRingExtendButton:Hide()
      end
    end
  )
end


function PoJ_SetHook_ContainerFrame_UpdateCooldown()
  hooksecurefunc(
    "ContainerFrame_UpdateCooldown",
    function(container, button)
      local link = GetContainerItemLink(container, button:GetID())
      local itemid, name = PoJ_GetItemInfoFromLink(link)
      if itemid then
        local cooldown, duration, enable, start
        local systime = GetTime()
        for _, id in ipairs(PoJ.SkillCooldownItems) do
          if id == itemid then
            start, duration, enable = GetItemCooldown(id)
            if start <= systime then
              if start > 0 then
                cooldown = PoJ_GetCooldownEndTime(start, duration) - systime
              else
                cooldown = nil
              end
              PoJ_SaveCraftCooldown(nil, nil, name, cooldown)
            end
          end
        end
      end
    end
  )
end


function PoJ_SetHook_ERRORMESSAGE()
  local _ERRORMESSAGE_default = geterrorhandler()
  
  function PoJ_ErrorHandler(message)
    if PoJ_Vars.ErrorsToChat then
      local now = time()
      if message ~= PoJ.LastScriptError or message == PoJ.LastScriptError and now > PoJ.LastScriptErrorTime + 10 then
        PoJ_Write("|cffff0000" .. message .. "|r")
        PoJ.LastScriptErrorTime = now
      end
      PoJ.LastScriptError = message
    else
      _ERRORMESSAGE_default(message)
    end
  end
  
  seterrorhandler(PoJ_ErrorHandler)
end


function InterfaceOptionsSocialPanelTimestamps_SetValue()
  hooksecurefunc(
    InterfaceOptionsSocialPanelTimestamps,
    "SetValue",
    function(value)
      PoJ_ModifyTimeStamp()
    end
  )
end


function PoJ_SetHook_MainMenuBar_SetPoint()
  hooksecurefunc(
    MainMenuBar,
    "SetPoint",
    function(anchor, frame, relative, x, y)
      if PoJ.SettingMainMenuBarPosition ~= true then
        if InCombatLockdown() == nil then
          PoJ_SetMenuBarPos()
        end
      end
    end
  )
end


function PoJ_SetHook_PlayerFrame_UpdateGroupIndicator()
  local PlayerFrame_UpdateGroupIndicator_default = PlayerFrame_UpdateGroupIndicator
  
  function PlayerFrame_UpdateGroupIndicator()
    if PoJ_Vars.ShowRaidGroup or not UnitInRaid("player") then
      if PlayerFrameGroupIndicator:IsShown() then
        PlayerFrameGroupIndicator:Hide()
      end
    else
      PlayerFrame_UpdateGroupIndicator_default()
    end
  end
  
end


function PoJ_SetHook_QuestLog_Update()
  hooksecurefunc(
    "QuestLog_UpdateQuestCount",
    function()
      if InCombatLockdown() == nil and PoJ_Vars.QuestLevels and PoJ.ENABLE_COLORBLIND_MODE == nil then
         PoJ.ENABLE_COLORBLIND_MODE = ENABLE_COLORBLIND_MODE
         ENABLE_COLORBLIND_MODE = "1"
      end
    end
  )
  
  hooksecurefunc(
    "QuestLogControlPanel_UpdateState",
    function()
      if InCombatLockdown() == nil and PoJ_Vars.QuestLevels and PoJ.ENABLE_COLORBLIND_MODE then
         ENABLE_COLORBLIND_MODE = PoJ.ENABLE_COLORBLIND_MODE
         PoJ.ENABLE_COLORBLIND_MODE = nil
      end
    end
  )
end


function PoJ_SetHook_SecondsToTimeAbbrev()
  local SecondsToTimeAbbrev_default = SecondsToTimeAbbrev
  
  function SecondsToTimeAbbrev(seconds)
    if PoJ_Vars.BuffDuration then
      return PoJ_GetTimeString(seconds)
    else
      return SecondsToTimeAbbrev_default(seconds)
    end
  end
  
end


function PoJ_SetHook_StaticPopup_Show()
  hooksecurefunc(
    "StaticPopup_Show",
    function(which, text_arg1, text_arg2, data)
      if which == "ADDON_ACTION_FORBIDDEN" or which == "HELP_TICKET_QUEUE_DISABLED" or which == "MACRO_ACTION_FORBIDDEN" then
        if PoJ_Vars.ErrorsToChat then
          PoJ_Write("|cffff0000" .. format(StaticPopupDialogs[which].text, text_arg1, text_arg2) .. "|r")
          StaticPopup_Hide(which)
        end
      elseif which == "DUEL_REQUESTED" then
        if PoJ_CVars.DuelIgnore and not (PoJ_CVars.DuelFriends and PoJ_IsFriend(arg1) or PoJ_CVars.DuelGroup and PoJ_IsInGroup(arg1) or PoJ_CVars.DuelGuild and PoJ_IsInGuild(arg1)) then
          StaticPopup_Hide(which)
          CancelDuel()
          PoJ_Comment(format(POJ_STRING.OUTPUT.DUELREJECT, arg1))
        end
      end
    end
  )
end


function PoJ_SetHook_ToggleFrame()
  hooksecurefunc(
    "ToggleFrame",
    function(frame)
      if frame == WorldMapFrame and not WorldMapFrame:IsVisible() then
        PoJ_SetPlayerNamesVisibility()
      end
    end
  )
end


function PoJ_SetHook_TradeSkillFrame_SetSelection()
  hooksecurefunc(
    "TradeSkillFrame_SetSelection",
    function(id)
      if id then
        local skillName, skillType = GetTradeSkillInfo(id)
        if skillType and skillType ~= "header" then
          local headerName
          for i = id - 1, 1, -1 do
            headerName, skillType = GetTradeSkillInfo(i)
            if skillType == "header" then
              break
            end
          end
          PoJ_SaveCraftCooldown(GetTradeSkillLine(), headerName, skillName, GetTradeSkillCooldown(id))
        end
      end
    end
  )
end


function PoJ_SetHook_UIParent_ShowHide()
  hooksecurefunc(UIParent, "Hide", PoJ_SetPlayerNamesVisibility)
  hooksecurefunc(UIParent, "Show", PoJ_SetPlayerNamesVisibility)
end


function PoJ_SetHook_UnitFrame_Update()
  hooksecurefunc(
    "UnitFrame_Update",
    function()
      PoJ_SetUnitName(this.name, this.unit)
    end
  )
end


function PoJ_SetHook_WorldMap_ToggleSize()
  hooksecurefunc("WorldMap_ToggleSizeDown", PoJ_UpdateCoordPositions)
  hooksecurefunc("WorldMap_ToggleSizeUp", PoJ_UpdateCoordPositions)
end
