PoJ_EH  = {}


function PoJ_RegisterEvents()
  this:RegisterEvent("ADDON_ACTION_FORBIDDEN")
  this:RegisterEvent("CHAT_MSG_ADDON")
  this:RegisterEvent("CHAT_MSG_SYSTEM")
  this:RegisterEvent("COMBAT_TEXT_UPDATE")
  this:RegisterEvent("CONFIRM_BINDER")
  this:RegisterEvent("FRIENDLIST_UPDATE")
  this:RegisterEvent("GUILD_ROSTER_UPDATE")
  this:RegisterEvent("LOOT_OPENED")
  this:RegisterEvent("MINIMAP_UPDATE_TRACKING")
  this:RegisterEvent("PARTY_LEADER_CHANGED")
  this:RegisterEvent("PARTY_MEMBERS_CHANGED")
  this:RegisterEvent("PLAYER_ALIVE")
  this:RegisterEvent("PLAYER_CONTROL_GAINED")
  this:RegisterEvent("PLAYER_DEAD")
  this:RegisterEvent("PLAYER_ENTERING_WORLD")
  this:RegisterEvent("PLAYER_REGEN_DISABLED")
  this:RegisterEvent("PLAYER_REGEN_ENABLED")
  this:RegisterEvent("PLAYER_TARGET_CHANGED")
  this:RegisterEvent("PLAYER_UNGHOST")
  this:RegisterEvent("RAID_ROSTER_UPDATE")
  this:RegisterEvent("TRADE_SHOW")
  this:RegisterEvent("UNIT_INVENTORY_CHANGED")
  this:RegisterEvent("UNIT_AURA")
  this:RegisterEvent("UNIT_LEVEL")
  this:RegisterEvent("UNIT_SPELLCAST_FAILED")
  this:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED")
  this:RegisterEvent("UNIT_SPELLCAST_SENT")
  this:RegisterEvent("UNIT_SPELLCAST_START")
  this:RegisterEvent("UNIT_SPELLCAST_STOP")
  this:RegisterEvent("UPDATE_MOUSEOVER_UNIT")
  this:RegisterEvent("WORLD_MAP_UPDATE")
  this:RegisterEvent("ZONE_CHANGED_NEW_AREA")
end


function PoJ_OnEvent(event)
  if PoJ_EH[event] then
    PoJ_EH[event]()
  else
    local arg, out
    PoJ_Debug("PoJ - unhandled registered event: " .. event)
    for i = 1, 9 do
      arg = getglobal("arg" .. i)
      if arg then
        if type(arg) == "string" then
          out = '"' .. arg .. '"'
        else
          out = tostring(arg)
        end
        PoJ_Debug("   - arg" .. i .. " = " .. out)
      else
        break
      end
    end
  end
end


function PoJ_EH.ADDON_ACTION_FORBIDDEN()
  PoJ_Debug("addon " .. arg1 .. " blocked - function call: " .. arg2)
end


function PoJ_EH.ADDON_LOADED()
  if arg1 == "Blizzard_CraftUI" then
    PoJ_SetHook_CraftFrame_SetSelection()
  elseif arg1 == "Blizzard_TradeSkillUI" then
    PoJ_SetHook_TradeSkillFrame_SetSelection()
  elseif arg1 == "XPerl_Player" then
    PoJ_Cooldown:ClearAllPoints()
    PoJ_Cooldown:SetPoint("BOTTOMLEFT", "XPerl_Player", "TOPLEFT", 5, -1)
  elseif arg1 == "XPerl_Target" then
    PoJ_TargetIcons:ClearAllPoints()
    PoJ_TargetIcons:SetPoint("BOTTOMLEFT", "XPerl_Target", "TOPLEFT", 6, -5)
    PoJ_UpdateTargetIcons()
  end
end


function PoJ_EH.CHAT_MSG_ADDON()
  if arg1 == PoJ.AddonComm then
    if PoJ_Vars.ShowAddonComm and arg4 ~= UnitName("player") then
      PoJ_Comment("|cffffff00[" .. arg3 .. "." .. arg4 .. "] " .. arg2 .. "|r", true)
    end
    if arg2 == "!version" then
      PoJ_AddonMessage("version", "WHISPER", arg4)
    elseif strsub(arg2, 1, 8) == "version=" then
      local newer
      local version, subversion = strmatch(arg2, "version=(%d+%.%d+%.%d+)(%a*)")
      if subverion == "" then
        if not PoJ_Vars.NewestVersion then
          newer = true
        elseif PoJ_VersionCompare(PoJ_Vars.NewestVersion, version) then
          newer = true
        elseif PoJ_VersionCompare(version, PoJ.Version) then
          PoJ_AddonMessage("version", "WHISPER", arg4)
        end
        if newer then
          PoJ_Vars.NewestVersion = version
          PoJ_VersionCheck()
        end
      end
    end
  end
end


function PoJ_EH.CHAT_MSG_SYSTEM()
  if PoJ_Vars.PostHomeToParty and PoJ.BindToHome and arg1 == format(ERR_DEATHBIND_SUCCESS_S, PoJ.BindToHome) then
    if PoJ_GetGroupType() == "party" then
      local subzone = GetSubZoneText()
      local realzone = GetRealZoneText()
      if subzone ~= PoJ.BindToHome and subzone ~= "" then
        if realzone == PoJ.BindToHome then
          PoJ.BindToHome = subzone
        else
          PoJ.BindToHome = PoJ.BindToHome .. ", " .. subzone
        end
      end
      if realzone ~= subzone then
        PoJ.BindToHome = PoJ.BindToHome .. ", " .. realzone
      end
      PoJ_SendToGroup(POJ_STRING.OUTPUT.HEARTHSTONESET .. ": " .. PoJ.BindToHome)
    end
    PoJ.BindToHome = nil
  end
end


function PoJ_EH.COMBAT_TEXT_UPDATE()
  if PoJ_Vars.AutoFaction and arg1 == "FACTION" and tonumber(arg3) > 0 then
    local index = PoJ_GetFactionIndex(arg2)
    if index and index > 0 then
      SetWatchedFactionIndex(index)
    end
  end
end


function PoJ_EH.CONFIRM_BINDER()
  PoJ.BindToHome = arg1
end


function PoJ_EH.FRIENDLIST_UPDATE()
  local class, level, name, online, status, zone
  PoJ.FriendCount = 0
  PoJ.FriendList = ""
  for i = 1, GetNumFriends() do
    name, level, class, zone, online, status = GetFriendInfo(i)
    if online then
      PoJ.FriendCount = PoJ.FriendCount + 1
      PoJ.FriendList = PoJ.FriendList .. ", " .. name .. iif(status == "", "", " " .. status)
    end
  end
  if PoJ.FriendCount ~= 0 then
    PoJ.FriendList = strsub(PoJ.FriendList, 3)
  end
  PoJ_ShowFriendList()
end


function PoJ_EH.GUILD_ROSTER_UPDATE()
  if IsInGuild() then
    local name, online, status
    PoJ.GuildMemberCount = 0
    PoJ.GuildMemberList = ""
    local playername = UnitName("player")
    for i = 1, GetNumGuildMembers() do
      name, _, _, _, _, _, _, _, online, status = GetGuildRosterInfo(i)
      if online then
        PoJ.GuildMemberCount = PoJ.GuildMemberCount + 1
        if name ~= playername then
          PoJ.GuildMemberList = PoJ.GuildMemberList .. ", " .. name .. iif(status == "", "", " " .. status)
        end
      end
    end
    PoJ.GuildRosterOk = PoJ.GuildMemberCount > 0
    if PoJ.GuildMemberCount > 1 then
      PoJ.GuildMemberList = strsub(PoJ.GuildMemberList, 3)
    end
    PoJ_ShowFriendList()
  end
end


function PoJ_EH.LOOT_OPENED()
  if PoJ.ClassString == "Rogue" and PoJ_CVars.PickPocketAutoLoot and PoJ.LastAction == GetSpellInfo(921) then
    local moneystring
    for i = 1, GetNumLootItems() do
      if LootSlotIsCoin(i) then
        _, moneystring = GetLootSlotInfo(i)
        info = ChatTypeInfo.MONEY
        ChatFrame1:AddMessage(format(YOU_LOOT_MONEY, string.gsub(moneystring, "\n", ", ")), info.r, info.g, info.b, info.id)
      end
      LootSlot(i)
    end
    PoJ.LastAction = nil
  end
end


function PoJ_EH.MINIMAP_UPDATE_TRACKING()
  PoJ_SetTracking(arg1 and true)
end


function PoJ_EH.PARTY_LEADER_CHANGED()
  PoJ_UpdateTargetIcons()
end


function PoJ_EH.PARTY_MEMBERS_CHANGED()
  PoJ_CheckGroupType()
  PoJ_UpdateTargetIcons()
end


function PoJ_EH.PLAYER_ALIVE()
  PoJ_PlayerAlive()
end


function PoJ_EH.PLAYER_CONTROL_GAINED()
  if PoJ.AuraZonePause then
    PoJ_Timer_Add(GetTime() + 1, "AuraRemind", "FUNCTION", {func = PoJ_AuraRemind}, true)
  end
end


function PoJ_EH.PLAYER_DEAD()
  PoJ.AuraActive = nil
  PoJ.OnMount = nil
  PoJ.PlayerDead = true
end


function PoJ_EH.PLAYER_ENTERING_WORLD()
  PoJ_ActionBar_Setup()
  PoJ_PlayerAlive()
end


function PoJ_EH.PLAYER_REGEN_DISABLED()
  PoJ_DeactivateRunAspect()
  PoJ_ActionBar_Setup(true)
end


function PoJ_EH.PLAYER_REGEN_ENABLED()
  PoJ_ActionBar_Setup()
  PoJ_SetMenuBarPos()
  for i = 1, 4 do
    PartyMemberFrame_UpdateMember(getglobal("PartyMemberFrame" .. i))
  end
end


function PoJ_EH.PLAYER_TARGET_CHANGED()
  PoJ_UpdateTargetClass()
  PoJ_UpdateTargetIcons()
end


function PoJ_EH.PLAYER_UNGHOST()
  PoJ_PlayerAlive()
end


function PoJ_EH.RAID_ROSTER_UPDATE()
  PoJ_CheckGroupType()
  if PoJ_Vars.ShowRaidGroup then
    PoJ_SetUnitName(PlayerName, "player")
    PoJ_SetUnitName(TargetFrameTextureFrameName, "target")
  end
  PoJ_SetPlayerNamesVisibility()
  PoJ_UpdateTargetIcons()
end


function PoJ_EH.SPELLS_CHANGED(reloaded)
  
  PoJ_LookForAvailableSpells()
  
  if not PoJ.SpellsLoaded then
    
    local settime = GetTime() + 3
    
    -- do guild startup stuff
    if not reloaded then
      PoJ_Timer_Add(settime, "GuildStartup" , "FUNCTION", {func = PoJ_GuildStartup})
    end
    
    -- reminders
    PoJ_ItemRemind_CheckItems(true)
    PoJ_Timer_Add(settime, "AuraRemind" , "FUNCTION", {func = PoJ_AuraRemind }, true)
    PoJ_Timer_Add(settime, "CraftRemind", "FUNCTION", {func = PoJ_CraftRemind, params = {true}}, true)
    PoJ_Timer_Add(settime, "ItemRemind" , "FUNCTION", {func = PoJ_ItemRemind }, true)
    PoJ_Timer_Add(settime, "SetTracking", "FUNCTION", {func = PoJ_SetTracking})
    
    -- call startup stuff
    PoJ_Timer_Add(settime, "PlayerNamesVisibility", "FUNCTION", {func = PoJ_SetPlayerNamesVisibility})
    PoJ_Timer_Add(settime, "VersionNotice", "FUNCTION", {func = PoJ_VersionCheck})
    
    -- save spell load state
    PoJ.SpellsLoaded = true
    
  end
  
end


function PoJ_EH.TRADE_SHOW()
  if PoJ_Vars.ShowTradePlayer and UnitExists("NPC") then
    PoJ_Comment(POJ_STRING.OUTPUT.TRADESTART .. " " .. UnitName("NPC") .. " (Lv " .. UnitLevel("NPC") .. " " .. UnitRace("NPC") .. " " .. UnitClass("NPC") .. ")", true)
  end
end


function PoJ_EH.UNIT_AURA()
  if arg1 == "player" and not UnitIsDeadOrGhost("player") then
    local aurareminddone, itemreminddone
    local changed, state = PoJ_MountStateChanged()
    if changed and not state then
      if PoJ.AuraZonePause or PoJ.ClassString == "Hunter" or PoJ.ClassString == "Paladin" then
        PoJ_AuraRemind()
        aurareminddone = true
      end
      if PoJ.ItemZonePause then
        PoJ_ItemRemind()
        itemreminddone = true
      end
    end
    if PoJ_Vars.RemindItems and not itemreminddone then
      for i, item in ipairs(PoJ.UseItems) do
        if PoJ.UseItems[i].active and not PoJ_ItemRemind_IsBuffActive(i) then
          PoJ_ItemRemind()
          break
        end
      end
    end
    PoJ_SetTracking()
  end
end


function PoJ_EH.UNIT_LEVEL()
  if string.match(arg1, "party%d") then
    PoJ_SavePartyLevel(arg1, true)
  end
end


function PoJ_EH.UNIT_INVENTORY_CHANGED()
  if arg1 == "player" then
    PoJ_GemCounter_Update()
    PoJ_ItemRemind_CheckItems()
  end
end


function PoJ_EH.UNIT_SPELLCAST_FAILED()
  if arg1 == "player" then
    PoJ.CurrentSpell       = nil
    PoJ.CurrentSpellTarget = nil
  end
end


function PoJ_EH.UNIT_SPELLCAST_INTERRUPTED()
  if arg1 == "player" then
    PoJ.CurrentSpell       = nil
    PoJ.CurrentSpellTarget = nil
  end
end


function PoJ_EH.UNIT_SPELLCAST_SENT()
  if arg1 == "player" then
    PoJ.LastAction = arg2
  end
end


function PoJ_EH.UNIT_SPELLCAST_START()
  if arg1 == "player" then
    PoJ.SpellInProgress = arg2
    local spell = arg2
    if PoJ.CurrentSpell ~= spell then
      PoJ.CurrentSpell = nil
      local message
      if PoJ.ClassString == "Warlock" then
        if spell == POJ_STRING.OUTPUT.SOULSTONERESURRECTION then
          PoJ.CurrentSpellTarget = PoJ_GetSpellTargetName("player")
          PoJ.CurrentSpell       = iif(PoJ.CurrentSpellTarget, spell, nil)
        end
      end
      if message then
        PoJ_SendToGroup(message)
      end
    end
  end
end


function PoJ_EH.UNIT_SPELLCAST_STOP()
  if arg1 == "player" then
    PoJ.SpellInProgress = nil
    if PoJ.CurrentSpell then
      if PoJ.ClassString == "Mage" then
        if PoJ.SpellCompletedFunc then
          PoJ_Timer_Add(GetTime() + 1, "SpellCompleted", "FUNCTION", {func = PoJ.SpellCompletedFunc})
          PoJ.SpellCompletedFunc = nil
        end
        PoJ.CurrentSpell = nil
      elseif PoJ.ClassString == "Warlock" then
        if PoJ.CurrentSpell == POJ_STRING.OUTPUT.SOULSTONERESURRECTION then
          PoJ_Timer_Add(GetTime() + 1, "SpellCompleted", "FUNCTION", {func = PoJ_SpellCompleted, params = {PoJ.CurrentSpell, PoJ.CurrentSpellTarget}})
        end
      end
    end
  end
end


function PoJ_EH.UPDATE_MOUSEOVER_UNIT()
  
  -- safe spell target
  if SpellIsTargeting() then
    PoJ.LastMouseOverSpellTarget = {
      name      = UnitName("mouseover"),
      isfriend  = UnitIsFriend("mouseover", "player"),
      isingroup = UnitInParty("mouseover"),
      isplayer  = UnitIsPlayer("mouseover"),
      isself    = UnitIsUnit("mouseover", "player")
    }
  else
    PoJ.LastMouseOverSpellTarget = nil
  end
  
end


function PoJ_EH.VARIABLES_LOADED()
  
  -- hook functions of the WoW UI
  PoJ_SetHooks()
  
  -- define PoJ variables
  PoJ_DefineVars()
  
  -- register events
  PoJ_RegisterEvents()
  
  -- do startup stuff
  PoJ_ModifyTimeStamp()
  PoJ_SetActionBarPos()
  PoJ_SetChatChannelJoins(true)
  PoJ_SetDoubleChatEditWidth()
  PoJ_SetErrorSuppressions()
  PoJ_SetMenuBarPos()
  PoJ_SetStatusBarFont()
  PoJ_SetTargetNameColors()
  PoJ_ShowActionBar()
  PoJ_ShowCoords()
  PoJ_ShowCoords_Map()
  PoJ_ShowGemCounter()
  PoJ_ShowMenuDeco()
  PoJ_ShowMinimapIcon()
  PoJ_ShowRaidGroup()
  
  -- if spells already available, trigger SPELLS_CHANGED event by self (i.e. UI was reloaded) and set some variables
  if GetSpellName(1, BOOKTYPE_SPELL) then
    PoJ_EH.SPELLS_CHANGED(true)
    PoJ.FriendsListed = true
  end
  
  -- important stuff done
  PoJ_VarsLoaded = true
  
  -- sort skill cooldown table
  table.sort(PoJ_Vars.SkillCooldowns, PoJ_CraftList_Sort)
  
  -- save party levels if already in party (e.g. after disconnection)
  for i = 1, GetNumPartyMembers() - 1 do
    PoJ_SavePartyLevel("party" .. i, false)
  end
  
end


function PoJ_EH.WORLD_MAP_UPDATE()
  PoJ_SavePartyLevels()
  PoJ_SetPlayerNamesVisibility()
end


function PoJ_EH.ZONE_CHANGED_NEW_AREA()
  PoJ_SetPlayerNamesVisibility()
  if PoJ.AuraZonePause then
    PoJ_AuraRemind()
  end
  if PoJ.ItemZonePause then
    PoJ_ItemRemind()
  end
  PoJ_SetTracking()
end