﻿PVPSound_SoundQueue 							= { }
PVPSound_KillSoundQueue 						= { }
PVPSound_SoundEffectQueue 						= { }

local PVPSound_NextUpdate 						= 0.3100
local PVPSound_NextKillUpdate					= 0.3000
local PVPSound_NextEffectUpdate					= 0.3000

local addon, ns = ...
local PS = ns.PS

-- Sound Queue
function PVPSound_AddToQueue(file)
	-- This function will add file to the Sound Queue to be played
	-- If the sound could not be found in the sound lengths table then just play it
	-- This is a table of soundlengths according to the selected SoundPack
	if (PS_SoundPackName == "UnrealTournament3" or PS_SoundPackName == "Custom") and PS_BattlegroundSoundEngine == true then
		if file ~= nil then
			local SoundLengthTable = getglobal("PVPSound_"..PS.SoundPack.."Durations")
			if SoundLengthTable ~= nil then
				local i
				local FileFoundLength
				-- Is there .mp3 at the end?
				if (not string.find(file, ".mp3", string.len(file) - 3)) and (not string.find(file, ".MP3", string.len(file) - 3)) and (not string.find(file, ".mP3", string.len(file) - 3)) and (not string.find(file, ".Mp3", string.len(file) - 3)) then
					-- If not then add it
					file = file..".mp3"
				end
				for i = 1, table.getn(SoundLengthTable) do
					if string.upper(SoundLengthTable[i].dir) == string.upper(file) then
						FileFoundLength = SoundLengthTable[i].duration
					end
				end
				if FileFoundLength then
					local Table = {dir = file, length = FileFoundLength}
					-- Insert the sound into the Sound Queue
					table.insert(PVPSound_SoundQueue, Table)
				else
					-- Not in the sound table so just play it
					PlaySoundFile(file, PS_Channel)
				end
			else
				PlaySoundFile(file, PS_Channel)
			end
		end
	else
		-- We've got lengths for UnrealTournament3 and Custom SoundPacks only, if that's not selected or SoundEngine is disabled then just play it
		if file ~= nil then
			PlaySoundFile(file, PS_Channel)
		end
	end
end

function PVPSound_ClearSoundQueue()
	-- This function will clear all the sounds from the Sound Queue
	local i
	for i = table.getn(PVPSound_SoundQueue), 1, -1 do
		table.remove(PVPSound_SoundQueue, i)
	end
end

function PVPSound_PlayNextSound()
	-- This function will play the next sound in the Sound Queue and return how long that sound will be played
	-- If there is no sound in the Sound Queue it will just return 0.3100
	if PVPSound_SoundInQueue() then
		local x
		PlaySoundFile(PVPSound_SoundQueue[1].dir, PS_Channel)
		x = PVPSound_SoundQueue[1].length
		table.remove(PVPSound_SoundQueue, 1)
		return x
	else
		return 0.3100
	end
end

function PVPSound_SoundInQueue()
	-- This function will return 1 if there is a sound in the Sound Queue, nil otherwise
	if table.getn(PVPSound_SoundQueue) > 0 then
		return 1
	else
		return nil
	end
end

function PVPSound_UpdateSoundEngine(self, elapsed)
	if PS_BattlegroundSoundEngine == true then
		self.TimeSinceLastUpdate = self.TimeSinceLastUpdate + elapsed
		while self.TimeSinceLastUpdate > PVPSound_NextUpdate do
			self.TimeSinceLastUpdate = self.TimeSinceLastUpdate - PVPSound_NextUpdate
			PVPSound_NextUpdate = PVPSound_PlayNextSound()
		end
	end
end

-- Kill Sound Queue
function PVPSound_AddKillToQueue(killtype, file)
	-- This function will add file to the Kill Sound Queue to be played
	-- If the sound could not be found in the sound lengths table then just play it
	-- This is a table of soundlengths according to the selected SoundPack
	if (PS_SoundPackName == "UnrealTournament3" or PS_SoundPackName == "Custom") and PS_KillSoundEngine == true then
		if killtype ~= nil and file ~= nil then
			local KillSoundLengthTable = getglobal("PVPSound_"..PS.SoundPack..killtype.."Durations")
			if KillSoundLengthTable ~= nil then
				local i
				local KillFileFoundLength
				-- Is there .mp3 at the end?
				if (not string.find(file, ".mp3", string.len(file) - 3)) and (not string.find(file, ".MP3", string.len(file) - 3)) and (not string.find(file, ".mP3", string.len(file) - 3)) and (not string.find(file, ".Mp3", string.len(file) - 3)) then
					-- If not then add it
					file = file..".mp3"
				end
				for i = 1, table.getn(KillSoundLengthTable) do
					if string.upper(KillSoundLengthTable[i].dir) == string.upper(file) then
						KillFileFoundLength = KillSoundLengthTable[i].duration
					end
				end
				if KillFileFoundLength then
					local KillTable = {dir = file, length = KillFileFoundLength}
					-- Insert the sound into the Kill Sound Queue
					table.insert(PVPSound_KillSoundQueue, KillTable)
				else
					-- Not in the sound table so just play it
					PlaySoundFile(file, PS_Channel)
				end
			else
				PlaySoundFile(file, PS_Channel)
			end
		end
	else
		-- We've got lengths for UnrealTournament3 and Custom SoundPacks only, if that's not selected or SoundEngine is disabled then just play it
		if file ~= nil then
			PlaySoundFile(file, PS_Channel)
		end
	end
end

function PVPSound_ClearKillSoundQueue()
	-- This function will clear all the sounds from the Kill Sound Queue
	local i
	for i = table.getn(PVPSound_KillSoundQueue), 1, -1 do
		table.remove(PVPSound_KillSoundQueue, i)
	end
end

function PVPSound_PlayNextKillSound()
	-- This function will play the next sound in the Kill Sound Queue and return how long that sound will be played
	-- If there is no sound in the Kill Sound Queue it will just return 0.3000
	if PVPSound_KillSoundInQueue() then
		local x
		PlaySoundFile(PVPSound_KillSoundQueue[1].dir, PS_Channel)
		x = PVPSound_KillSoundQueue[1].length
		table.remove(PVPSound_KillSoundQueue, 1)
		return x
	else
		return 0.3000
	end
end

function PVPSound_KillSoundInQueue()
	-- This function will return 1 if there is a sound in the Kill Sound Queue, nil otherwise
	if table.getn(PVPSound_KillSoundQueue) > 0 then
		return 1
	else
		return nil
	end
end

function PVPSound_UpdateKillSoundEngine(self, elapsed)
	if PS_KillSoundEngine == true then
		self.TimeSinceLastKillUpdate = self.TimeSinceLastKillUpdate + elapsed
		while self.TimeSinceLastKillUpdate > PVPSound_NextKillUpdate do
			self.TimeSinceLastKillUpdate = self.TimeSinceLastKillUpdate - PVPSound_NextKillUpdate
			PVPSound_NextKillUpdate = PVPSound_PlayNextKillSound()
		end
	end
end

-- Sound Effect Queue
function PVPSound_AddEffectToQueue(killtype, file)
	-- This function will add file to the Effect Sound Queue to be played
	-- If the sound could not be found in the sound lengths table then just play it
	-- This is a table of soundlengths according to the selected SoundPack
	if (PS_SoundPackName == "UnrealTournament3" or PS_SoundPackName == "Custom") then
		if file ~= nil then
			local SoundEffectLengthTable = getglobal("PVPSound_"..PS.SoundPack..killtype.."Durations")
			if SoundEffectLengthTable ~= nil then
				local i
				local EffectFileFoundLength
				-- Is there .mp3 at the end?
				if (not string.find(file, ".mp3", string.len(file) - 3)) and (not string.find(file, ".MP3", string.len(file) - 3)) and (not string.find(file, ".mP3", string.len(file) - 3)) and (not string.find(file, ".Mp3", string.len(file) - 3)) then
					-- If not then add it
					file = file..".mp3"
				end
				for i = 1, table.getn(SoundEffectLengthTable) do
					if string.upper(SoundEffectLengthTable[i].dir) == string.upper(file) then
						EffectFileFoundLength = SoundEffectLengthTable[i].duration
					end
				end
				if EffectFileFoundLength then
					local EffectTable = {dir = file, length = EffectFileFoundLength}
					-- Insert the sound into the Effect Sound Queue
					table.insert(PVPSound_SoundEffectQueue, EffectTable)
				end
			end
		end
	end
end

function PVPSound_ClearSoundEffectQueue()
	-- This function will clear all the sounds from the Effect Sound Queue
	local i
	for i = table.getn(PVPSound_SoundEffectQueue), 1, -1 do
		table.remove(PVPSound_SoundEffectQueue, i)
	end
end

function PVPSound_PlayNextSoundEffect()
	-- This function will play the next sound in the Effect Sound Queue and return how long that sound will be played or return 0.0001
	-- If there is no sound in the Effect Sound Queue it will just return 0.3000
	if PVPSound_SoundEffectInQueue() then
		if string.upper(PVPSound_SoundEffectQueue[1].dir) == string.upper(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Effects\\KillingMaxRank.mp3") or string.upper(PVPSound_SoundEffectQueue[1].dir) == string.upper(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Effects\\MultiKillingMaxRank.mp3") then
			PlaySoundFile(PVPSound_SoundEffectQueue[1].dir, PS_Channel)
			table.remove(PVPSound_SoundEffectQueue, 1)
			return 0.0001
		else
			local x
			x = PVPSound_SoundEffectQueue[1].length
			table.remove(PVPSound_SoundEffectQueue, 1)
			return x
		end
	else
		return 0.3000
	end
end

function PVPSound_SoundEffectInQueue()
	-- This function will return 1 if there is a sound in the Effect Sound Queue, nil otherwise
	if table.getn(PVPSound_SoundEffectQueue) > 0 then
		return 1
	else
		return nil
	end
end

function PVPSound_UpdateSoundEffectEngine(self, elapsed)
	if PS_SoundEffect == true then
		self.TimeSinceLastEffectUpdate = self.TimeSinceLastEffectUpdate + elapsed
		while self.TimeSinceLastEffectUpdate > PVPSound_NextEffectUpdate do
			self.TimeSinceLastEffectUpdate = self.TimeSinceLastEffectUpdate - PVPSound_NextEffectUpdate
			PVPSound_NextEffectUpdate = PVPSound_PlayNextSoundEffect()
		end
	end
end