﻿PVPSound_PaybackQueue							= { }
PVPSound_RetributionQueue						= { }

local PVPSound_NextPayUpdate 					= 0.3300
local PVPSound_NextRetUpdate 					= 0.3300

local PaybackQueueNumber
local AlreadyPaybackQueued
local RetributionQueueNumber
local AlreadyRetributionQueued

local addon, ns = ...
local PS = ns.PS

-- Payback Queue
function PVPSound_AddToPaybackQueue(name)
	-- This function will add the name and the killtime into the Payback Queue
	if name ~= nil then
		local i
		for i = 1, table.getn(PVPSound_PaybackQueue) do
			-- If the name is already in the queue
			if string.upper(PVPSound_PaybackQueue[i].dir) == string.upper(name) then
				PaybackQueueNumber = i
				AlreadyPaybackQueued = true
			end
		end
		if AlreadyPaybackQueued == true then
			PVPSound_PaybackQueue[PaybackQueueNumber].killtime = GetTime()
		else
			local PaybackTable = {dir = name, killtime = GetTime()}
			table.insert(PVPSound_PaybackQueue, PaybackTable)
		end
		AlreadyPaybackQueued = false
	end
end

function PVPSound_ClearPaybackQueue()
	-- This function will clear all possible Payback names and killtimes from the Payback Queue
	local i
	for i = table.getn(PVPSound_PaybackQueue), 1, -1 do
		table.remove(PVPSound_PaybackQueue, i)
	end
end

function PVPSound_DeleteFirstPayback()
	-- This function will delete the first name and killtime from the Payback Queue if its in the queue since more than the Payback Kill time, and return 0.3300
	-- If there is no name and killtime in the Payback Queue it will just return 0.3300
	if PVPSound_PaybackInQueue() then
		if GetTime() - PS.PaybackKillTime > PVPSound_PaybackQueue[1].killtime then
			table.remove(PVPSound_PaybackQueue, 1)
		end
	end
	return 0.3300
end

function PVPSound_PaybackInQueue()
	-- This function will return 1 if there is a name in the Payback Queue, nil otherwise
	if table.getn(PVPSound_PaybackQueue) > 0 then
		return 1
	else
		return nil
	end
end

function PVPSound_UpdatePaybackSound(self, elapsed)
	if PS_PaybackSound == true then
		self.TimeSinceLastPayUpdate = self.TimeSinceLastPayUpdate + elapsed
		while self.TimeSinceLastPayUpdate > PVPSound_NextPayUpdate do
			self.TimeSinceLastPayUpdate = self.TimeSinceLastPayUpdate - PVPSound_NextPayUpdate
			PVPSound_NextPayUpdate = PVPSound_DeleteFirstPayback()
		end
	end
end

-- Retribution Queue
function PVPSound_AddToRetributionQueue(name)
	-- This function will add the name and the killtime into the Retribution queue
	if name ~= nil then
		local i
		for i = 1, table.getn(PVPSound_RetributionQueue) do
			-- If the name is already in the queue
			if string.upper(PVPSound_RetributionQueue[i].dir) == string.upper(name) then
				RetributionQueueNumber = i
				AlreadyRetributionQueued = true
			end
		end
		if AlreadyRetributionQueued == true then
			PVPSound_RetributionQueue[RetributionQueueNumber].killtime = GetTime()
		else
			local RetributionTable = {dir = name, killtime = GetTime()}
			table.insert(PVPSound_RetributionQueue, RetributionTable)
		end
		AlreadyRetributionQueued = false
	end
end

function PVPSound_ClearRetributionQueue()
	-- This function will clear all possible Retribution names and killtimes from the Retribution Queue
	local i
	for i = table.getn(PVPSound_RetributionQueue), 1, -1 do
		table.remove(PVPSound_RetributionQueue, i)
	end
end

function PVPSound_DeleteFirstRetribution()
	-- This function will delete the first name and killtime from the Retribution Queue if its in the queue since more than Payback kill time, and return 0.3300
	-- If there is no name and killtime in the Retribution Queue it will just return 0.3300
	if PVPSound_RetributionInQueue() then
		if GetTime() - PS.PaybackKillTime > PVPSound_RetributionQueue[1].killtime then
			table.remove(PVPSound_RetributionQueue, 1)
		end
	end
	return 0.3300
end

function PVPSound_RetributionInQueue()
	-- This function will return 1 if there is a name in the Retribution Queue, nil otherwise
	if table.getn(PVPSound_RetributionQueue) > 0 then
		return 1
	else
		return nil
	end
end

function PVPSound_UpdateRetributionSound(self, elapsed)
	if PS_PaybackSound == true then
		self.TimeSinceLastRetUpdate = self.TimeSinceLastRetUpdate + elapsed
		while self.TimeSinceLastRetUpdate > PVPSound_NextRetUpdate do
			self.TimeSinceLastRetUpdate = self.TimeSinceLastRetUpdate - PVPSound_NextRetUpdate
			PVPSound_NextRetUpdate = PVPSound_DeleteFirstRetribution()
		end
	end
end