﻿function PVPSound_DataOnLoad()
	PVPSoundDataFrame:RegisterEvent("CHAT_MSG_ADDON")
	PVPSoundDataFrame:RegisterEvent("CHAT_MSG_EMOTE")
	PVPSoundDataFrame:RegisterEvent("ZONE_CHANGED_NEW_AREA")
end

local CheckLimit = 3.0000

-- Names
local PlayerName
local PlayerNameSpree
local KillerName
local KillerNameServer

-- Sprees
local Spree
local DeathSpree
local MessageSpree

-- Data Share
local SentTime
local ReceivedTime
local WasOutOfRange

-- PVPSound Addon Data Sharing
function PVPSound_DataOnEvent(self, event, prefix, message, channel, sender, ...)
	if PS_DataShare == true then
		if event == "CHAT_MSG_EMOTE" then
			local EventMessage = select(1, ...)
			-- If the sent data is in the time limit
			if ReceivedTime ~= nil and SentTime ~= nil and PlayerNameSpree ~= nil then
				if string.find(EventMessage, PlayerNameSpree) then
					if (ReceivedTime - SentTime) <= CheckLimit then
						WasOutOfRange = false
					else
						WasOutOfRange = true
					end
				else
					WasOutOfRange = true
				end
			end
		elseif event == "CHAT_MSG_ADDON" then
			-- If the Sent Data is from the registered prefix
			if prefix == "PVPSound" then
				-- If the sender is not nil and its not the player
				if sender ~= nil and sender ~= UnitName("player") then
					-- If the message is not nil
					if message ~= nil then
						-- Kill Data Share
						if string.find(message, "?") then
							-- If the sender is from CrossRealm
							if string.find(sender, "-") then
								ReceivedTime = tonumber(time())
								SentTime = tonumber(string.match(message, "(.+)?"))
								PlayerName = tostring(sender)
								Spree = tostring(string.match(message, "?(.+)"))
								PlayerNameSpree = tostring(""..PlayerName.." "..Spree.."")
							else
								ReceivedTime = tonumber(time())
								SentTime = tonumber(string.match(message, "(.+)?"))
								PlayerName = tostring(sender)
								Spree = tostring(string.match(message, "?(.+)"))
								PlayerNameSpree = tostring(""..PlayerName.." "..Spree.."")
							end
						elseif string.find(message, "+") then
							-- If the sender is from CrossRealm
							if string.find(sender,"-") and PS_HideServerName ~= false then
								PlayerName = tostring(string.match(sender, "(.+)-"))
								MessageSpree = tostring(string.match(message, "(.+)+"))
								-- If from -Azjol-Nerub
								if string.find(PlayerName, "-") and PS_HideServerName ~= false then
									PlayerName = tostring(string.match(PlayerName, "(.+)-"))
								end
								if WasOutOfRange == true then
									if PlayerName ~= nil and MessageSpree ~= nil then
										PVPSound_PrintKill(PlayerName, MessageSpree)
									end
								end
								WasOutOfRange = nil
							else
								PlayerName = tostring(sender)
								MessageSpree = tostring(string.match(message, "(.+)+"))
								if WasOutOfRange == true then
									if PlayerName ~= nil and MessageSpree ~= nil then
										PVPSound_PrintKill(PlayerName, MessageSpree)
									end
								end
								WasOutOfRange = nil
							end
						 -- Death Data Share
						elseif string.find(message, ":") then
							DeathSpree = tostring(string.match(message, "(.+):"))
							KillerNameServer = tostring(string.match(message, ":(.+)"))
							if KillerNameServer ~= nil then
								-- If the killer is NPC
								if string.sub(KillerNameServer, -1) == "!" then
									KillerName = KillerNameServer
								 -- If the killer is from CrossRealm
								else
									if KillerNameServer ~= sender then
										if string.find(KillerNameServer, "-") and PS_HideServerName ~= false then
											KillerName = tostring(string.match(KillerNameServer, "(.+)-"))
											-- If from -Azjol-Nerub
											if string.find(KillerNameServer, "-") and PS_HideServerName ~= false then
												KillerName = tostring(string.match(KillerNameServer, "(.+)-"))
											end
										else
											KillerName = tostring(KillerNameServer)
										end
									end
								end
								if DeathSpree ~= nil then
									if KillerName ~= nil then
										-- If the killer is NPC
										if string.sub(KillerName, -1) == "!" then
											KillerName = string.sub(KillerName, 1, string.len(KillerName)-1)
											if SenderName ~= nil and DeathSpree ~= nil and KillerName ~= nil then
												PVPSound_PrintDeath(SenderName, DeathSpree, KillerName)
											end
										else
											-- If sender is from CrossRealm
											if string.find(sender, "-") and PS_HideServerName ~= false then
												SenderName = tostring(string.match(sender, "(.+)-"))
												-- If from -Azjol-Nerub
												if string.find(SenderName, "-") and PS_HideServerName ~= false then
													SenderName = tostring(string.match(SenderName, "(.+)-"))
													if SenderName ~= nil and DeathSpree ~= nil and KillerName ~= nil then
														PVPSound_PrintDeath(SenderName, DeathSpree, KillerName)
													end
												else
													if SenderName ~= nil and DeathSpree ~= nil and KillerName ~= nil then
														PVPSound_PrintDeath(SenderName, DeathSpree, KillerName)
													end
												end
											else
												SenderName = tostring(sender)
												if SenderName ~= nil and DeathSpree ~= nil and KillerName ~= nil then
													PVPSound_PrintDeath(SenderName, DeathSpree, KillerName)
												end
											end
										end
									end
								end
							end
						else
							-- Nil everything
							Spree = nil
							DeathSpree = nil
							MessageSpree = nil
							PlayerName = nil
							PlayerNameSpree = nil
							KillerName = nil
							KillerNameServer = nil
							WasOutOfRange = nil
						end
					end
				end
			end
		elseif event == "ZONE_CHANGED_NEW_AREA" then
			-- Nil everything
			Spree = nil
			DeathSpree = nil
			MessageSpree = nil
			PlayerName = nil
			PlayerNameSpree = nil
			KillerName = nil
			KillerNameServer = nil
			WasOutOfRange = nil
		end
	end
end

function PVPSound_PrintKill(sender, message)
	if message == "FirstBloodMale" then
		print("|cFFFFA500"..sender.." "..Msg_FirstBloodMale.."|cFFFFFFFF")
	elseif message == "FirstBloodFemale" then
		print("|cFFFFA500"..sender.." "..Msg_FirstBloodFemale.."|cFFFFFFFF")
	elseif message == "KillingSpree" then
		print("|cFFFFA500"..sender.." "..Msg_KillingSpree.."|cFFFFFFFF")
	elseif message == "Rampage" then
		print("|cFFFFA500"..sender.." "..Msg_Rampage.."|cFFFFFFFF")
	elseif message == "Dominating" then
		print("|cFFFFA500"..sender.." "..Msg_Dominating.."|cFFFFFFFF")
	elseif message == "Unstoppable" then
		print("|cFFFFA500"..sender.." "..Msg_Unstoppable.."|cFFFFFFFF")
	elseif message == "Godlike" then
		print("|cFFFFA500"..sender.." "..Msg_Godlike.."|cFFFFFFFF")
	elseif message == "Massacre" then
		print("|cFFFFA500"..sender.." "..Msg_Massacre.."|cFFFFFFFF")
	end
end

function PVPSound_PrintDeath(sender, message, killer)
	if message == "FirstBlood" then
		print("|cFFFF4500"..sender..""..Msg_FirstBloodOver.." "..killer..".|cFFFFFFFF")
	elseif message == "KillingSpree" then
		print("|cFFFF4500"..sender..""..Msg_KillingSpreeOver.." "..killer..".|cFFFFFFFF")
	elseif message == "Rampage" then
		print("|cFFFF4500"..sender..""..Msg_RampageOver.." "..killer..".|cFFFFFFFF")
	elseif message == "Dominating" then
		print("|cFFFF4500"..sender..""..Msg_DominatingOver.." "..killer..".|cFFFFFFFF")
	elseif message == "Unstoppable" then
		print("|cFFFF4500"..sender..""..Msg_UnstoppableOver.." "..killer..".|cFFFFFFFF")
	elseif message == "Godlike" then
		print("|cFFFF4500"..sender..""..Msg_GodlikeOver.." "..killer..".|cFFFFFFFF")
	elseif message == "Massacre" then
		print("|cFFFF4500"..sender..""..Msg_MassacreOver.." "..killer..".|cFFFFFFFF")
	end
end