﻿function PVPSound_OnLoad()
	PVPSoundFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
	PVPSoundFrame:RegisterEvent("ZONE_CHANGED_NEW_AREA")
	PVPSoundFrame:RegisterEvent("PLAYER_DEAD")
	PVPSoundFrame:RegisterEvent("CHAT_MSG_BG_SYSTEM_NEUTRAL")
	PVPSoundFrame:RegisterEvent("CHAT_MSG_BG_SYSTEM_ALLIANCE")
	PVPSoundFrame:RegisterEvent("CHAT_MSG_BG_SYSTEM_HORDE")
	PVPSoundFrame:RegisterEvent("CHAT_MSG_MONSTER_YELL")
	PVPSoundFrame:RegisterEvent("CHAT_MSG_RAID_BOSS_EMOTE")
	PVPSoundFrame:RegisterEvent("WORLD_MAP_UPDATE")

	-- Slash Commands
	SlashCmdList["PVPSound"] = PVPSound_SlashCommands
	SLASH_PVPSound1 = "/ps"
	SLASH_PVPSound2 = "/pvpsound"

	-- Addon loaded message
	print("|cFF50C0FFPVPSound |cFFFFA500"..GetAddOnMetadata("PVPSound", "Version").."|cFF50C0FF loaded.")
end

function PVPSound_OnLoadTwo()
	PVPSoundFrameTwo:RegisterEvent("UPDATE_WORLD_STATES")

	-- Slash Commands
	SlashCmdList["PVPSound"] = PVPSound_SlashCommands
	SLASH_PVPSound1 = "/ps"
	SLASH_PVPSound2 = "/pvpsound"
end

function PVPSound_OnLoadThree()
	PVPSoundFrameThree:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")

	-- Slash Commands
	SlashCmdList["PVPSound"] = PVPSound_SlashCommands
	SLASH_PVPSound1 = "/ps"
	SLASH_PVPSound2 = "/pvpsound"
end

-- Default Settings
if PS_PVPMode == nil then
	PS_PVPMode = true
end
if PS_Emote == nil then
	PS_Emote = true
end
if PS_EmoteMode == nil then
	PS_EmoteMode = true
end
if PS_DeathMessage == nil then
	PS_DeathMessage = true
end
if PS_KillSound == nil then
	PS_KillSound = true
end
if PS_MultiKillSound == nil then
	PS_MultiKillSound = true
end
if PS_PaybackSound == nil then
	PS_PaybackSound = true
end
if PS_BattlegroundSound == nil then
	PS_BattlegroundSound = true
end
if PS_SoundEffect == nil then
	PS_SoundEffect = true
end
if PS_KillSoundEngine == nil then
	PS_KillSoundEngine = true
end
if PS_BattlegroundSoundEngine == nil then
	PS_BattlegroundSoundEngine = true
end
if PS_DataShare == nil then
	PS_DataShare = true
end
if PS_KillSct == nil then
	PS_KillSct = true
end
if PS_MultiKillSct == nil then
	PS_MultiKillSct = true
end
if PS_PaybackSct == nil then
	PS_PaybackSct = true
end
if PS_SctEngine == nil then
	PS_SctEngine = true
end
-- Intended name
if PSSctFrame == nil then
	if MikSBT then
		PSSctFrame = "Notification"
	elseif Parrot then
		PSSctFrame = "Notification"
	elseif SCT then
		PSSctFrame = "Frame 1"
	end
end
if PS_HideServerName == nil then
	PS_HideServerName = true
end
if PS_Channel == nil then
	PS_Channel = "Master"
end
if PS_SoundPackName == nil then
	PS_SoundPackName = "UnrealTournament3"
end
if PS_SoundPackLanguage == nil then
	PS_SoundPackLanguage = "Eng"
end
-- Data Share Register
if PS_DataShare == true then
	RegisterAddonMessagePrefix("PVPSound")
end

local addon, ns = ...
local PS = CreateFrame("Frame")
ns.PS = PS

-- Killing Settings
local TimerReset = false	-- Resets every timer and counter
local ResetTime = 1800		-- Automatically resets everything when no kills made in 30 minutes
local MultiKillTime = 16	-- If you get the Multi Kills in 16 sec difference you gain a Multi Kill rank, else resets
local KillCounter = 0		-- Starting number for Kill Counter
local RankStep = 1			-- How many kills need for the next rank after the First Blood
PS.KillTime = 60			-- If you get the Kills in 60 sec difference you gain a rank, else just replays your last rank and rank gaining continuing from that rank
PS.PaybackKillTime = 90		-- The time you can revenge the players they killed you, or the players can revenge you whom you killed

-- Localization
local Locale = GetLocale()

-- Player
local MyFaction
local MyGender

-- Battlegrounds
local IsRated
local BgIsOver
local SotaAttacker
local SotaRoundOver
local IocAllianceGateDown
local IocHordeGateDown
local AlreadyPlaySound
local LastScored

-- Battlefields
local TbAttacker
local WgAttacker

-- Zones
local MyZone
local InstanceType
local CurrentZoneId
local CurrentZoneText

-- Messages
local File
local Spree
local SendTime

-- Kills
local Kills
local MultiKills
local LastKill
local FirstKill
local FirstMultiKill
local PaybackKill
local RetributionKill

-- Deaths
local KilledMe
local KilledBy
local KilledWho
local GotKilledBy

-- Enemys
local ToEnemy
local FromEnemy
local ToEnemyPlayer
local ToEnemyPlayerAndNPC
local FromMyPets
local FromEnemyPlayer
local FromEnemyPlayerAndNPC

-- Warsong Gulch and Twin Peaks Time Remaining
local WSGandTPTimeobjectives = {TimeRemaining = nil}

local function WSGandTPTimeget_objective(id)
	if id then
		return "TimeRemaining"
	else
		return false
	end
end

local function WSGandTPTimeobj_state(id)
	if id == 6 then
		return 1 -- Time Remaining: 6 min.
	elseif id == 5 then
		return 2 -- Time Remaining: 5 min.
	elseif id == 4 then
		return 3 -- Time Remaining: 4 min.
	elseif id == 3 then
		return 4 -- Time Remaining: 3 min.
	elseif id == 2 then
		return 5 -- Time Remaining: 2 min.
	elseif id == 1 then
		return 6 -- Time Remaining: 1 min.
	else
		return 0
	end
end

-- Warsong Gulch and Twin Peaks Alliance Score
local WSGandTPAobjectives = {AllianceScore = nil}

local function WSGandTPAget_objective(id)
	if id then
		return "AllianceScore"
	else
		return false
	end
end

local function WSGandTPAobj_state(id)
	if id == 0 then
		return 1 -- Alliance Score: 0/3
	elseif id == 1 then
		return 2 -- Alliance Score: 1/3
	elseif id == 2 then
		return 3 -- Alliance Score: 2/3
	elseif id == 3 then
		return 4 -- Alliance Score: 3/3
	else
		return 0
	end
end

-- Warsong Gulch and Twin Peaks Horde Score
local WSGandTPHobjectives = {HordeScore = nil}

local function WSGandTPHget_objective(id)
	if id then
		return "HordeScore"
	else
		return false
	end
end

local function WSGandTPHobj_state(id)
	if id == 0 then
		return 1 -- Horde Score: 0/3
	elseif id == 1 then
		return 2 -- Horde Score: 1/3
	elseif id == 2 then
		return 3 -- Horde Score: 2/3
	elseif id == 3 then
		return 4 -- Horde Score: 3/3
	else
		return 0
	end
end

-- Arathi Basin
local ABobjectives = {Blacksmith = 0, Farm = 0, GoldMine = 0, LumberMill = 0, Stables = 0}

local function ABget_objective(id)
	if id >= 126 and id <= 130 then
		return "Blacksmith"
	elseif id >= 231 and id <= 235 then
		return "Farm"
	elseif id >= 316 and id <= 320 then
		return "GoldMine"
	elseif id >= 421 and id <= 425 then
		return "LumberMill"
	elseif id >= 536 and id <= 540 then
		return "Stables"
	else
		return false
	end
end

local function ABobj_state(id)
	if id == 128 or id == 233 or id == 318 or id == 423 or id == 538 then
		return 1 -- Alliance Bases
	elseif id == 130 or id == 235 or id == 320 or id == 425 or id == 540 then
		return 2 -- Horde Bases
	elseif id == 127 or id == 232 or id == 317 or id == 422 or id == 537 then
		return 3 -- Alliance trys to capture
	elseif id == 129 or id == 234 or id == 319 or id == 424 or id == 539 then
		return 4 -- Horde trys to capture
	else
		return 0 -- Noone controling
	end
end

-- Arathi Basin Alliance Bases
local ABBaseAobjectives = {AllianceBases = 0}

local function ABBaseAget_objective(id)
	if id then
		return "AllianceBases"
	else
		return false
	end
end

local function ABBaseAobj_state(id)
	if id == 4 then
		return 1 -- Alliance Bases: 4
	elseif id == 5 then
		return 2 -- Alliance Bases: 5
	else
		return 0
	end
end

-- Arathi Basin Horde Bases
local ABBaseHobjectives = {HordeBases = 0}

local function ABBaseHget_objective(id)
	if id then
		return "HordeBases"
	else
		return false
	end
end

local function ABBaseHobj_state(id)
	if id == 4 then
		return 1 -- Horde Bases: 4
	elseif id == 5 then
		return 2 -- Horde Bases: 5
	else
		return 0
	end
end

-- The Battle for Gilneas
local TBFGobjectives = {Lighthouse = 0, Mines = 0, Waterworks = 0}

local function TBFGget_objective(id)
	if id >= 106 and id <= 112 then
		return "Lighthouse"
	elseif id >= 216 and id <= 220 then
		return "Mines"
	elseif id >= 326 and id <= 330 then
		return "Waterworks"
	else
		return false
	end
end

local function TBFGobj_state(id)
	if id == 111 or id == 218 or id == 328 then
		return 1 -- Alliance Bases
	elseif id == 110 or id == 220 or id == 330 then
		return 2 -- Horde Bases
	elseif id == 109 or id == 217 or id == 327 then
		return 3 -- Alliance trys to capture
	elseif id == 112 or id == 219 or id == 329 then
		return 4 -- Horde trys to capture
	else
		return 0 -- Noone controling
	end
end

-- The Battle for Gilneas Alliance Bases
local TBFGBaseAobjectives = {AllianceBases = 0}

local function TBFGBaseAget_objective(id)
	if id then
		return "AllianceBases"
	else
		return false
	end
end

local function TBFGBaseAobj_state(id)
	if id == 2 then
		return 1 -- Alliance Bases: 2
	elseif id == 3 then
		return 2 -- Alliance Bases: 3
	else
		return 0
	end
end

-- The Battle for Gilneas Horde Bases
local TBFGBaseHobjectives = {HordeBases = 0}

local function TBFGBaseHget_objective(id)
	if id then
		return "HordeBases"
	else
		return false
	end
end

local function TBFGBaseHobj_state(id)
	if id == 2 then
		return 1 -- Horde Bases: 2
	elseif id == 3 then
		return 2 -- Horde Bases: 3
	else
		return 0
	end
end

-- Isle of Conquest
local IOCobjectives = {Quarry = 0, Workshop = 0, Hangar = 0, Docks = 0, Refinerie = 0}

local function IOCget_objective(id)
	if id >= 16 and id <= 20 then
		return "Quarry"
	elseif id >= 135 and id <= 139 then
		return "Workshop"
	elseif id >= 140 and id <= 144 then
		return "Hangar"
	elseif id >= 145 and id <= 149 then
		return "Docks"
	elseif id >= 150 and id <= 154 then
		return "Refinerie"
	else
		return false
	end
end

local function IOCobj_state(id)
	if id == 18 or id == 136 or id == 141 or id == 146 or id == 151 then
		return 1 -- Alliance Bases
	elseif id == 20 or id == 138 or id == 143 or id == 148 or id == 153 then
		return 2 -- Horde Bases
	elseif id == 17 or id == 137 or id == 142 or id == 147 or id == 152 then
		return 3 -- Alliance trys to capture
	elseif id == 19 or id == 139 or id == 144 or id == 149 or id == 154 then
		return 4 -- Horde trys to capture
	else
		return 0 -- Noone controling
	end
end

-- Strand of the Ancients
local SOTAobjectives = {AllianceDefense = 0, HordeDefense = 0, EastGraveyard = 0, WestGraveyard = 0, SouthGraveyard = 0, AllianceChamberofAncientRelics = 0, HordeChamberofAncientRelics = 0, GateoftheRedSun = 0, GateoftheBlueSapphire = 0, GateoftheYellowMoon = 0, GateofthePurpleAmethyst = 0, GateoftheGreenEmerald = 0}

local function SOTAget_objective(id)
	if id == 46 then
		return "AllianceDefense"
	elseif id == 48 then
		return "HordeDefense"
	elseif id >= 113 and id <= 115 then
		return "EastGraveyard"
	elseif id >= 213 and id <= 215 then
		return "WestGraveyard"
	elseif id >= 313 and id <= 315 then
		return "SouthGraveyard"
	elseif id >= 480 and id <= 482 then
		return "AllianceChamberofAncientRelics"
	elseif id >= 477 and id <= 479 then
		return "HordeChamberofAncientRelics"
	elseif id >= 577 and id <= 579 then
		return "GateoftheRedSun"
	elseif id >= 680 and id <= 682 then
		return "GateoftheBlueSapphire"
	elseif id >= 702 and id <= 704 then
		return "GateoftheYellowMoon"
	elseif id >= 805 and id <= 807 then
		return "GateofthePurpleAmethyst"
	elseif id >= 908 and id <= 910 then
		return "GateoftheGreenEmerald"
	else
		return false
	end
end

local function SOTAobj_state(id)
	if id == 115 or id == 215 or id == 315 then
		return 1 -- Alliance Graveyards
	elseif id == 113 or id == 213 or id == 313 then
		return 2 -- Horde Graveyards
	elseif id == 480 then
		return 3 -- Alliance Chamber Gate Undamaged
	elseif id == 481 then
		return 4 -- Alliance Chamber Gate Damaged
	elseif id == 482 then
		return 5 -- Alliance Chamber Gate Destroyed
	elseif id == 477 then
		return 6 -- Horde Chamber Gate Undamaged
	elseif id == 478 then
		return 7 -- Horde Chamber Gate Damaged
	elseif id == 479 then
		return 8 -- Horde Chamber Gate Destroyed
	elseif id == 577 or id == 680 or id == 702 or id == 805 or id == 908 then
		return 9 -- Other Gates Undamaged
	elseif id == 578 or id == 681 or id == 703 or id == 806 or id == 909 then
		return 10 -- Other Gates Damaged
	elseif id == 579 or id == 682 or id == 704 or id == 807 or id == 910 then
		return 11 -- Other Gates Destroyed
	else
		return 0
	end
end

-- Eye of the Storm Alliance Bases
local EOTSBaseAobjectives = {AllianceBases = nil}

local function EOTSBaseAget_objective(id)
	if id then
		return "AllianceBases"
	else
		return false
	end
end

local function EOTSBaseAobj_state(id)
	if id == 0 then
		return 1 -- Alliance Bases: 0
	elseif id == 1 then
		return 2 -- Alliance Bases: 1
	elseif id == 2 then
		return 3 -- Alliance Bases: 2
	elseif id == 3 then
		return 4 -- Alliance Bases: 3
	elseif id == 4 then
		return 5 -- Alliance Bases: 4
	else
		return 0
	end
end

-- Eye of the Storm Horde Bases
local EOTSBaseHobjectives = {HordeBases = nil}

local function EOTSBaseHget_objective(id)
	if id then
		return "HordeBases"
	else
		return false
	end
end

local function EOTSBaseHobj_state(id)
	if id == 0 then
		return 1 -- Horde Bases: 0
	elseif id == 1 then
		return 2 -- Horde Bases: 1
	elseif id == 2 then
		return 3 -- Horde Bases: 2
	elseif id == 3 then
		return 4 -- Horde Bases: 3
	elseif id == 4 then
		return 5 -- Horde Bases: 4
	else
		return 0
	end
end

-- Eye of the Storm Victory Points
local EOTSWINobjectives = {VictoryPoints = 0}

local function EOTSWINget_objective(id)
	if id then
		return "VictoryPoints"
	else
		return false
	end
end

local function EOTSWINobj_state(id)
	if id == 1600 then
		return 1 -- Victory Points: 1600/1600
	else
		return 0 -- Victory Points: 0-1599/1600
	end
end

-- Silvershard Mines Resources
local SMWINobjectives = {Resources = 0}

local function SMWINget_objective(id)
	if id then
		return "VictoryPoints"
	else
		return false
	end
end

local function SMWINobj_state(id)
	if id == 1600 then
		return 1 -- Resources: 1600/1600
	else
		return 0 -- Resources: 0-1599/1600
	end
end

-- Wintergrasp
local WGobjectives = {FlamewatchTower = 0, ShadowsightTower = 0, WintersEdgeTower = 0}

local function WGget_objective(id)
	if id >= 110 and id <= 153 then
		return "FlamewatchTower"
	elseif id >= 210 and id <= 253 then
		return "ShadowsightTower"
	elseif id >= 310 and id <= 353 then
		return "WintersEdgeTower"
	else
		return false
	end
end

local function WGobj_state(id)
	if id == 111 or id == 211 or id == 311 then
		return 1 -- Alliance Towers Undamaged
	elseif id == 110 or id == 210 or id == 310 then
		return 2 -- Horde Towers Undamaged
	elseif id == 150 or id == 250 or id == 350 then
		return 3 -- Alliance Towers Heavily Damaged
	elseif id == 151 or id == 251 or id == 351 then
		return 4 -- Alliance Towers Destroyed
	elseif id == 152 or id == 252 or id == 352 then
		return 5 -- Horde Towers Heavily Damaged
	elseif id == 153 or id == 253 or id == 353 then
		return 6 -- Horde Towers Destroyed
	else
		return 0
	end
end

-- Tol Barad
local TBobjectives = {TowersDestroyed = 0}

local function TBget_objective(id)
	if id then
		return "TowersDestroyed"
	else
		return false
	end
end

local function TBobj_state(id)
	if id == 0 then
		return 1 -- Towers Destroyed: 0
	elseif id == 1 then
		return 2 -- Towers Destroyed: 1
	elseif id == 2 then
		return 3 -- Towers Destroyed: 2
	elseif id == 3 then
		return 4 -- Towers Destroyed: 3
	else
		return 0
	end
end

-- Alterac Valley and Isle of Conquest Alliance Reinforcements
local AVandIOCAobjectives = {AllianceReinforcements = 0}

local function AVandIOCAget_objective(id)
	if id then
		return "AllianceReinforcements"
	else
		return false
	end
end

local function AVandIOCAobj_state(id)
	if id == 11 then
		return 1 -- Reinforcements: 11
	elseif id == 10 then
		return 2 -- Reinforcements: 10
	elseif id == 6 then
		return 3 -- Reinforcements: 6
	elseif id == 5 then
		return 4 -- Reinforcements: 5
	elseif id == 2 then
		return 5 -- Reinforcements: 2
	elseif id == 1 then
		return 6 -- Reinforcements: 1
	else
		return 0
	end
end

-- Alterac Valley and Isle of Conquest Horde Reinforcements
local AVandIOCHobjectives = {HordeReinforcements = 0}

local function AVandIOCHget_objective(id)
	if id then
		return "HordeReinforcements"
	else
		return false
	end
end

local function AVandIOCHobj_state(id)
	if id == 11 then
		return 1 -- Reinforcements: 11
	elseif id == 10 then
		return 2 -- Reinforcements: 10
	elseif id == 6 then
		return 3 -- Reinforcements: 6
	elseif id == 5 then
		return 4 -- Reinforcements: 5
	elseif id == 2 then
		return 5 -- Reinforcements: 2
	elseif id == 1 then
		return 6 -- Reinforcements: 1
	else
		return 0
	end
end

function PVPSound_OnEvent(self, event, ...)
	if Locale ~= "koKR" and Locale ~= "zhCN" and Locale ~= "zhTW" then
		if event == "PLAYER_ENTERING_WORLD" then
			-- SoundPack Settings
			if PS_SoundPackName == "UnrealTournament3" then
				PS.SoundPackDirectory = "Interface\\AddOns\\PVPSound\\Sounds\\"..PS_SoundPackName
			else
				PS.SoundPackDirectory = "Interface\\AddOns\\PVPSound_CustomSoundPack\\Sounds\\"..PS_SoundPackName
			end
			PS.SoundPack = PS_SoundPackName..""..PS_SoundPackLanguage
			MyFaction = UnitFactionGroup("player")
			CurrentZoneId = GetCurrentMapAreaID()
			CurrentZoneText = GetRealZoneText()
			InstanceType = select(2, IsInInstance())
			IsRated = IsRatedBattleground()
			TimerReset = true
			-- Battlegrounds
			if CurrentZoneId == 443 and InstanceType == "pvp" then
				MyZone = "Zone_WarsongGulch"
			elseif CurrentZoneId == 461 and InstanceType == "pvp" then
				MyZone = "Zone_ArathiBasin"
			elseif CurrentZoneId == 401 and InstanceType == "pvp" then
				MyZone = "Zone_AlteracValley"
			elseif (CurrentZoneId == 482 or CurrentZoneText == EOTS) and InstanceType == "pvp" then
				MyZone = "Zone_EyeoftheStorm"
			elseif CurrentZoneId == 540 and InstanceType == "pvp" then
				MyZone = "Zone_IsleofConquest"
			elseif CurrentZoneId == 512 and InstanceType == "pvp" then
				MyZone = "Zone_StrandoftheAncients"
			elseif CurrentZoneId == 626 and InstanceType == "pvp" then
				MyZone = "Zone_TwinPeaks"
			elseif CurrentZoneId == 736 and InstanceType == "pvp" then
				MyZone = "Zone_TheBattleforGilneas"
			elseif CurrentZoneId == 856 and InstanceType == "pvp" then
				MyZone = "Zone_TempleofKotmogu"
			elseif CurrentZoneId == 860 and InstanceType == "pvp" then
				MyZone = "Zone_SilvershardMines"
			 -- Battlefields
			elseif CurrentZoneId == 501 then
				MyZone = "Zone_Wintergrasp"
			elseif CurrentZoneId == 708 then
				MyZone = "Zone_TolBarad"
			 -- Arenas
			elseif InstanceType == "arena" then
				MyZone = "Zone_Arenas"
			else
				MyZone = ""
			end
			-- Payback Kill time
			if MyZone == "Zone_AlteracValley" or  MyZone == "Zone_IsleofConquest" or MyZone == "Zone_Wintergrasp" or MyZone == "Zone_TolBarad" then
				PS.PaybackKillTime = 120
			else
				PS.PaybackKillTime = 90
			end
			if UnitSex("player") == 2 then
				MyGender = "Male"
			elseif UnitSex("player") == 3 then
				MyGender = "Female"
			end
			if MyZone == "Zone_WarsongGulch" or MyZone == "Zone_TwinPeaks" then
				if select(4, GetWorldStateUIInfo(1)) ~= nil then
					-- Time Remaining
					local TimeRemaining = tonumber(string.match(select(4, GetWorldStateUIInfo(1)), "(%d+)"))
					WSGandTPTimeobjectives = {TimeRemaining = TimeRemaining}
				end
				if select(4, GetWorldStateUIInfo(2)) ~= nil and select(4, GetWorldStateUIInfo(3)) ~= nil then
					-- Alliance Score
					local AllianceScore = tonumber(string.match(select(4, GetWorldStateUIInfo(2)), "(%d)/"))
					WSGandTPAobjectives = {AllianceScore = AllianceScore}
					-- Horde Score
					local HordeScore = tonumber(string.match(select(4, GetWorldStateUIInfo(3)), "(%d)/"))
					WSGandTPHobjectives = {HordeScore = HordeScore}
				end
			end
			if MyZone == "Zone_EyeoftheStorm" then
				if select(4, GetWorldStateUIInfo(2)) ~= nil and select(4, GetWorldStateUIInfo(3)) ~= nil then
					-- Alliance Bases
					local AllianceBases = tonumber(string.match(select(4, GetWorldStateUIInfo(2)), "(%d)%s"))
					EOTSBaseAobjectives = {AllianceBases = AllianceBases}
					-- Horde Bases
					local HordeBases = tonumber(string.match(select(4, GetWorldStateUIInfo(3)), "(%d)%s"))
					EOTSBaseHobjectives = {HordeBases = HordeBases}
				end
			end
		end

		if event == "PLAYER_DEAD" then
			-- Death Data Share
			if KilledBy ~= nil then
				if PS_DataShare == true then
					if string.find(KilledBy, "!") then
						GotKilledBy = string.sub(KilledBy, 1, string.len(KilledBy)-1)
					else
						GotKilledBy = tostring(KilledBy)
					end
					if File == "FirstBlood.mp3" then
						if InstanceType == "pvp" then
							SendAddonMessage("PVPSound", "FirstBlood:"..GotKilledBy, "BATTLEGROUND")
						else
							SendAddonMessage("PVPSound", "FirstBlood:"..GotKilledBy, "RAID")
						end
					elseif File == "KillingSpree.mp3" then
						if InstanceType == "pvp" then
							SendAddonMessage("PVPSound", "KillingSpree:"..GotKilledBy, "BATTLEGROUND")
						else
							SendAddonMessage("PVPSound", "KillingSpree:"..GotKilledBy, "RAID")
						end
					elseif File == "Rampage.mp3" then
						if InstanceType == "pvp" then
							SendAddonMessage("PVPSound", "Rampage:"..GotKilledBy, "BATTLEGROUND")
						else
							SendAddonMessage("PVPSound", "Rampage:"..GotKilledBy, "RAID")
						end
					elseif File == "Dominating.mp3" then
						if InstanceType == "pvp" then
							SendAddonMessage("PVPSound", "Dominating:"..GotKilledBy, "BATTLEGROUND")
						else
							SendAddonMessage("PVPSound", "Dominating:"..GotKilledBy, "RAID")
						end
					elseif File == "Unstoppable.mp3" then
						if InstanceType == "pvp" then
							SendAddonMessage("PVPSound", "Unstoppable:"..GotKilledBy, "BATTLEGROUND")
						else
							SendAddonMessage("PVPSound", "Unstoppable:"..GotKilledBy, "RAID")
						end
					elseif File == "Godlike.mp3" then
						if InstanceType == "pvp" then
							SendAddonMessage("PVPSound", "Godlike:"..GotKilledBy, "BATTLEGROUND")
						else
							SendAddonMessage("PVPSound", "Godlike:"..GotKilledBy, "RAID")
						end
					elseif File == "Massacre.mp3" then
						if InstanceType == "pvp" then
							SendAddonMessage("PVPSound", "Massacre:"..GotKilledBy, "BATTLEGROUND")
						else
							SendAddonMessage("PVPSound", "Massacre:"..GotKilledBy, "RAID")
						end
					end
				end
				-- Death Messages
				if PS_DeathMessage == true then
					if string.sub(KilledBy, -1) == "!" then
						GotKilledBy = string.sub(KilledBy, 1, string.len(KilledBy)-1)
					else
						if string.find(KilledBy, "-") and PS_HideServerName ~= false then
							GotKilledBy = tostring(string.match(KilledBy, "(.+)-"))
							if string.find(GotKilledBy, "-") then
								GotKilledBy = tostring(string.match(GotKilledBy, "(.+)-"))
							end
						else
							GotKilledBy = tostring(KilledBy)
						end
					end
					if GotKilledBy ~= nil then
						print("|cFFFF4500"..Msg_YouGotKilledBy.." "..GotKilledBy.."!|cFFFFFFFF")
					end
					GotKilledBy = nil
				end
				KilledBy = nil
				File = nil
			end
			TimerReset = true
		end

		if PS_BattlegroundSound == true then
			if event == "ZONE_CHANGED_NEW_AREA" then
				CurrentZoneId = GetCurrentMapAreaID()
				CurrentZoneText = GetRealZoneText()
				InstanceType = select(2, IsInInstance())
				IsRated = IsRatedBattleground()
				BgIsOver = false
				SotaRoundOver = false
				IocAllianceGateDown = false
				IocHordeGateDown = false
				SOTAobjectives = {EastGraveyard = 0, WestGraveyard = 0, SouthGraveyard = 0}
				TimerReset = true
				-- Battlegrounds
				if CurrentZoneId == 443 and InstanceType == "pvp" then
					MyZone = "Zone_WarsongGulch"
				elseif CurrentZoneId == 461 and InstanceType == "pvp" then
					MyZone = "Zone_ArathiBasin"
				elseif CurrentZoneId == 401 and InstanceType == "pvp" then
					MyZone = "Zone_AlteracValley"
				elseif (CurrentZoneId == 482 or CurrentZoneText == EOTS) and InstanceType == "pvp" then
					MyZone = "Zone_EyeoftheStorm"
				elseif CurrentZoneId == 540 and InstanceType == "pvp" then
					MyZone = "Zone_IsleofConquest"
				elseif CurrentZoneId == 512 and InstanceType == "pvp" then
					MyZone = "Zone_StrandoftheAncients"
				elseif CurrentZoneId == 626 and InstanceType == "pvp" then
					MyZone = "Zone_TwinPeaks"
				elseif CurrentZoneId == 736 and InstanceType == "pvp" then
					MyZone = "Zone_TheBattleforGilneas"
				elseif CurrentZoneId == 856 and InstanceType == "pvp" then
					MyZone = "Zone_TempleofKotmogu"
				elseif CurrentZoneId == 860 and InstanceType == "pvp" then
					MyZone = "Zone_SilvershardMines"
				 -- Battlefields
				elseif CurrentZoneId == 501 then
					MyZone = "Zone_Wintergrasp"
				elseif CurrentZoneId == 708 then
					MyZone = "Zone_TolBarad"
				 -- Arenas
				elseif InstanceType == "arena" then
					MyZone = "Zone_Arenas"
				else
					MyZone = ""
				end
				-- Payback Kill time
				if MyZone == "Zone_AlteracValley" or  MyZone == "Zone_IsleofConquest" or MyZone == "Zone_Wintergrasp" or MyZone == "Zone_TolBarad" then
					PS.PaybackKillTime = 120
				else
					PS.PaybackKillTime = 90
				end
				-- Battleground PlaySounds
				if MyZone == "Zone_WarsongGulch" or MyZone == "Zone_EyeoftheStorm" or MyZone == "Zone_ArathiBasin" or MyZone == "Zone_AlteracValley" or MyZone == "Zone_IsleofConquest" or MyZone == "Zone_StrandoftheAncients" or MyZone == "Zone_TwinPeaks" or MyZone == "Zone_TheBattleforGilneas" or MyZone == "Zone_TempleofKotmogu" or MyZone == "Zone_SilvershardMines" then
					KillCounter = 0
					KilledMe = nil
					KilledBy = nil
					if IsRated == false then
						if MyFaction == "Alliance" and AlreadyPlaySound ~= true then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\PlayYouAreOnBlue.mp3")
							AlreadyPlaySound = true
						elseif MyFaction == "Horde" and AlreadyPlaySound ~= true then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\PlayYouAreOnRed.mp3")
							AlreadyPlaySound = true
						end
					else
						local AllianceSpellName = tostring(GetSpellLink(81748))
						local HordeSpellName = tostring(GetSpellLink(81744))
						-- Alliance RBG buff
						if  select(11, UnitBuff("player", AllianceSpellName)) == 81748 and AlreadyPlaySound ~= true then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\PlayYouAreOnBlue.mp3")
							AlreadyPlaySound = true
						end
						-- Horde RBG buff
						if select(11, UnitBuff("player", HordeSpellName)) == 81744 and AlreadyPlaySound ~= true then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\PlayYouAreOnRed.mp3")
							AlreadyPlaySound = true
						end
					end
				 -- Arena PlaySounds
				elseif MyZone == "Zone_Arenas" then
					KillCounter = 0
					KilledMe = nil
					KilledBy = nil
					PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\PrepareForBattle.mp3")
				 -- Wintergrasp PlaySounds
				elseif MyZone == "Zone_Wintergrasp" then
					KillCounter = 0
					KilledMe = nil
					KilledBy = nil
					local isActive = select(3, GetWorldPVPAreaInfo(1))
					if isActive == true then
						local i
						for i = 7, 7, 1 do
							local textureIndex = select(3, GetMapLandmarkInfo(i))
							if textureIndex then
								if textureIndex == 68 then
									WgAttacker = "Alliance"
								elseif textureIndex == 71 then
									WgAttacker = "Horde"
								end
							end
						end
						if WgAttacker == "Alliance" and MyFaction == "Alliance" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\PlayYouAreOnBlueAttackTheEnemyCore.mp3")
						elseif WgAttacker == "Alliance" and MyFaction == "Horde" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\PlayYouAreOnRedDefendYourCore.mp3")
						elseif WgAttacker == "Horde" and MyFaction == "Alliance" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\PlayYouAreOnBlueDefendYourCore.mp3")
						elseif WgAttacker == "Horde" and MyFaction == "Horde" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\PlayYouAreOnRedAttackTheEnemyCore.mp3")
						end
					end
				 -- Tol Barad PlaySounds
				elseif MyZone == "Zone_TolBarad" then
					KillCounter = 0
					KilledMe = nil
					KilledBy = nil
					local isActive = select(3, GetWorldPVPAreaInfo(2))
					if isActive == true then
						local i
						for i = 1, 1, 1 do
							local textureIndex = select(3, GetMapLandmarkInfo(i))
							if textureIndex then
								if textureIndex == 48 then
									TbAttacker = "Alliance"
								elseif textureIndex == 46 then
									TbAttacker = "Horde"
								end
							end
						end
						if TbAttacker == "Alliance" and MyFaction == "Alliance" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\PlayYouAreOnBlueAttackTheEnemyCore.mp3")
						elseif TbAttacker == "Alliance" and MyFaction == "Horde" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\PlayYouAreOnRedDefendYourCore.mp3")
						elseif TbAttacker == "Horde" and MyFaction == "Alliance" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\PlayYouAreOnBlueDefendYourCore.mp3")
						elseif TbAttacker == "Horde" and MyFaction == "Horde" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\PlayYouAreOnRedAttackTheEnemyCore.mp3")
						end
					end
				end
				 -- This stuff needs to be here
				AlreadyPlaySound = false
			end
			-- WinSounds
			if event == "CHAT_MSG_BG_SYSTEM_NEUTRAL" or event == "CHAT_MSG_BG_SYSTEM_ALLIANCE" or event == "CHAT_MSG_BG_SYSTEM_HORDE" or event == "CHAT_MSG_MONSTER_YELL" then
				local EventMessage = select(1, ...)
				if MyZone == "Zone_WarsongGulch" or MyZone == "Zone_EyeoftheStorm" or MyZone == "Zone_ArathiBasin" or MyZone == "Zone_AlteracValley" or MyZone == "Zone_IsleofConquest" or MyZone == "Zone_StrandoftheAncients" or MyZone == "Zone_TwinPeaks" or MyZone == "Zone_TheBattleforGilneas" or MyZone == "Zone_TempleofKotmogu" then
					if string.find(EventMessage, BG_ALLIANCE_WINS) and BgIsOver ~= true then
						PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\AllianceWins.mp3")
						BgIsOver = true
						PVPSound_ClearPaybackQueue()
						PVPSound_ClearRetributionQueue()
					elseif string.find(EventMessage, BG_HORDE_WINS) and BgIsOver ~= true then
						PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\HordeWins.mp3")
						BgIsOver = true
						PVPSound_ClearPaybackQueue()
						PVPSound_ClearRetributionQueue()
					end
				end
			end

			if event == "CHAT_MSG_BG_SYSTEM_NEUTRAL" then
				local EventMessage = select(1, ...)
				-- Waronsg Gulch and Twin Peaks Vulnerable
				if MyZone == "Zone_WarsongGulch" or MyZone == "Zone_TwinPeaks" then
					if string.find(EventMessage, BG_VULNERABLE) then
						PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\Overtime.mp3")
					end
				 -- Strand of the Ancients Attack and Defend Sounds
				elseif MyZone == "Zone_StrandoftheAncients" then
					if string.find(EventMessage, BG_SOTA_ROUND_ONE) or string.find(EventMessage, BG_SOTA_ROUND_TWO) then
						local i
						for i = 1, 1, 1 do
							local textureIndex = select(3, GetMapLandmarkInfo(i))
							if textureIndex then
								if textureIndex == 46 then
									SotaAttacker = "Horde"
								end
							end
						end
						for i = 8, 8, 1 do
							local textureIndex = select(3, GetMapLandmarkInfo(i))
							if textureIndex then
								if textureIndex == 48 then
									SotaAttacker = "Alliance"
								end
							end
						end
						if SotaAttacker == "Alliance" and MyFaction == "Alliance" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\AttackTheEnemyCore.mp3")
						elseif SotaAttacker == "Alliance" and MyFaction == "Horde" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\DefendYourCore.mp3")
						elseif SotaAttacker == "Horde" and MyFaction == "Alliance" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\DefendYourCore.mp3")
						elseif SotaAttacker == "Horde" and MyFaction == "Horde" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\AttackTheEnemyCore.mp3")
						end
					elseif string.find(EventMessage, BG_SOTA_ROUND_TWO_TWO) then
						PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\FinalRound.mp3")
					end
				end

			elseif event == "CHAT_MSG_BG_SYSTEM_ALLIANCE" or event == "CHAT_MSG_BG_SYSTEM_HORDE" then
				local EventMessage = select(1, ...)
				-- Waronsg Gulch and Twin Peaks
				if MyZone == "Zone_WarsongGulch" or MyZone == "Zone_TwinPeaks" then
					-- Alliance
					if event == "CHAT_MSG_BG_SYSTEM_ALLIANCE" then
						if string.find(EventMessage, BG_PICKED) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Flag_Taken.mp3")
						elseif string.find(EventMessage, BG_DROPPED) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Flag_Dropped.mp3")
						elseif string.find(EventMessage, BG_RETURNED) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Flag_Returned.mp3")
						end
					 -- Horde
					elseif event == "CHAT_MSG_BG_SYSTEM_HORDE" then
						if string.find(EventMessage, BG_PICKED) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Flag_Taken.mp3")
						elseif string.find(EventMessage, BG_DROPPED) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Flag_Dropped.mp3")
						elseif string.find(EventMessage, BG_RETURNED) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Flag_Returned.mp3")
						end
					end
				 -- Eye of the Storm Score Sounds
				elseif MyZone == "Zone_EyeoftheStorm" then
					if string.find(EventMessage, BG_CAPTURED) then
						if event == "CHAT_MSG_BG_SYSTEM_ALLIANCE" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Scores.mp3")
						elseif event == "CHAT_MSG_BG_SYSTEM_HORDE" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Scores.mp3")
						end
					end
				 -- Isle of Conquest Gate Destroyed
				elseif MyZone == "Zone_IsleofConquest" then
					if string.find(EventMessage, BG_IOC_GATE_DOWN) then
						if event == "CHAT_MSG_BG_SYSTEM_ALLIANCE" then
							if IocHordeGateDown ~= true then
								PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\BarricadeDestroyedRedCoreIsVulnerable.mp3")
								IocHordeGateDown = true
							else
								PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\BarricadeDestroyed.mp3")
							end
						elseif event == "CHAT_MSG_BG_SYSTEM_HORDE" then
							if IocAllianceGateDown ~= true then
								PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\BarricadeDestroyedBlueCoreIsVulnerable.mp3")
								IocAllianceGateDown = true
							else
								PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\BarricadeDestroyed.mp3")
							end
						end
					end
				 -- Temple of Kotmogu
				elseif MyZone == "Zone_TempleofKotmogu" then
					if event == "CHAT_MSG_BG_SYSTEM_ALLIANCE" then
						PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Orb_PickedUp.mp3")
					elseif event == "CHAT_MSG_BG_SYSTEM_HORDE" then
						PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Orb_PickedUp.mp3")
					end
				 -- Silvershard Mines
				elseif MyZone == "Zone_SilvershardMines" then
					if event == "CHAT_MSG_BG_SYSTEM_ALLIANCE" then
						if string.find(EventMessage, BG_CAPTURED) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Scores.mp3")
						end
					elseif event == "CHAT_MSG_BG_SYSTEM_HORDE" then
						if string.find(EventMessage, BG_CAPTURED) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Scores.mp3")
						end
					end
				end

			elseif event == "CHAT_MSG_MONSTER_YELL" then
				local EventMessage = select(1, ...)
				-- Alterac Valley
				if MyZone == "Zone_AlteracValley" then
					-- Bunkers and Towers Under Attack
					if string.find(EventMessage, BG_AV_BUNKER_UNDER_ATTACK) or string.find(EventMessage, BG_AV_TOWER_UNDER_ATTACK) or string.find(EventMessage, BG_AV_TOWER_POINT_UNDER_ATTACK) then
						if string.find(EventMessage, FACTION_ALLIANCE) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_TowerNode_Offense.mp3")
						elseif string.find(EventMessage, FACTION_HORDE) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_TowerNode_Offense.mp3")
						end
					 -- Graveyards Under Attack
					elseif string.find(EventMessage, BG_AV_GRAVEYARD_UNDER_ATTACK) or string.find(EventMessage, BG_AV_DUN_BALDAR_UNDER_ATTACK) or string.find(EventMessage, BG_AV_FROSTWOLF_RELIEF_HUT_UNDER_ATTACK) then
						if string.find(EventMessage, FACTION_ALLIANCE) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Node_Offense.mp3")
						elseif string.find(EventMessage, FACTION_HORDE) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Node_Offense.mp3")
						end
					 -- Bunkers and Towers Defense
					elseif string.find(EventMessage, BG_AV_BUNKER_TAKEN) or string.find(EventMessage, BG_AV_TOWER_TAKEN) or string.find(EventMessage, BG_AV_TOWER_POINT_TAKEN) then
						if string.find(EventMessage, FACTION_ALLIANCE) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_TowerNode_Defense.mp3")
						elseif string.find(EventMessage, FACTION_HORDE) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_TowerNode_Defense.mp3")
						end
					 -- Graveyards Defense
					elseif string.find(EventMessage, BG_AV_GRAVEYARD_TAKEN) or string.find(EventMessage, BG_AV_DUN_BALDAR_TAKEN) or string.find(EventMessage, BG_AV_FROSTWOLF_RELIEF_HUT_TAKEN) then
						if string.find(EventMessage, FACTION_ALLIANCE) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Node_Defense.mp3")
						elseif string.find(EventMessage, FACTION_HORDE) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Node_Defense.mp3")
						end
					 -- Bunkers and Towers Destroyed
					elseif string.find(EventMessage, BG_AV_BUNKER_DESTROYED) or string.find(EventMessage, BG_AV_TOWER_DESTROYED) or string.find(EventMessage, BG_AV_TOWER_POINT_DESTROYED) then
						if string.find(EventMessage, FACTION_ALLIANCE) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_TowerNode_Destroyed.mp3")
						elseif string.find(EventMessage, FACTION_HORDE) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_TowerNode_Destroyed.mp3")
						end
					end
				end

			elseif event == "CHAT_MSG_RAID_BOSS_EMOTE" then
				local EventMessage = select(1, ...)
				-- Wintergrasp
				if MyZone == "Zone_Wintergrasp" then
					local isActive = select(3, GetWorldPVPAreaInfo(1))
					-- WinSounds
					if string.find(EventMessage, BF_WG_ALLIANCE_WIN_DEFENDED) or string.find(EventMessage, BF_WG_ALLIANCE_WIN_CAPTURED) then
						PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\AllianceWins.mp3")
					elseif string.find(EventMessage, BF_WG_HORDE_WIN_DEFENDED) or string.find(EventMessage, BF_WG_HORDE_WIN_CAPTURED) then
						PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\HordeWins.mp3")
					end
					if isActive == true then
						-- Workshops
						if string.find(EventMessage, BF_WG_ALLIANCE_ATTACKED) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
						elseif string.find(EventMessage, BF_WG_ALLIANCE_CAPTURED) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
						elseif string.find(EventMessage, BF_WG_HORDE_ATTACKED) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
						elseif string.find(EventMessage, BF_WG_HORDE_CAPTURED) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
						end
					end
				 -- Tol Barad
				elseif MyZone == "Zone_TolBarad" then
					local isActive = select(3, GetWorldPVPAreaInfo(2))
					-- WinSounds
					if string.find(EventMessage, BF_TB_ALLIANCE_SUCCESSFULLY_DEFENDED) or string.find(EventMessage, BF_TB_ALLIANCE_SUCCESSFULLY_TAKEN) then
						PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\AllianceWins.mp3")
					elseif string.find(EventMessage, BF_TB_HORDE_SUCCESSFULLY_DEFENDED) or string.find(EventMessage, BF_TB_HORDE_SUCCESSFULLY_TAKEN) then
						PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\HordeWins.mp3")
					end
					if isActive == true then
						local i
						for i = 1, 1, 1 do
							local textureIndex = select(3, GetMapLandmarkInfo(i))
							if textureIndex then
								if textureIndex == 48 then
									TbAttacker = "Alliance"
								elseif textureIndex == 46 then
									TbAttacker = "Horde"
								end
							end
						end
						-- Bases
						if string.find(EventMessage, BF_TB_ALLIANCE_LOST_CONTROL) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
						elseif string.find(EventMessage, BF_TB_HORDE_LOST_CONTROL) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
						elseif string.find(EventMessage, BF_TB_ALLIANCE_TAKEN) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
						elseif string.find(EventMessage, BF_TB_HORDE_TAKEN) then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
						end
						-- Towers
						if string.find(EventMessage, BF_TB_DAMAGED) and TbAttacker == "Horde" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_TowerNode_HeavilyDamaged.mp3")
						elseif string.find(EventMessage, BF_TB_DAMAGED) and TbAttacker == "Alliance" then
							PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_TowerNode_HeavilyDamaged.mp3")
						end
					end
				 -- Strand of the Ancients Round One Finished
				elseif MyZone == "Zone_StrandoftheAncients" then
					if string.find(EventMessage, BG_SOTA_ROUND_ONE_FINISHED) then
						SotaRoundOver = true
						SOTAobjectives = {EastGraveyard = 0, WestGraveyard = 0, SouthGraveyard = 0}
						PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\EndOfRound.mp3")
					elseif string.find(EventMessage, BG_SOTA_LET_THE_BATTLE) then
						SotaRoundOver = false
					end
				 -- Eye of the Storm RBG Score Sounds
				elseif MyZone == "Zone_EyeoftheStorm" then
					if string.find(EventMessage, BG_EOTSRBG_ALLIANCE_CAPTURED) then
						PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Scores.mp3")
					elseif string.find(EventMessage, BG_EOTSRBG_HORDE_CAPTURED) then
						PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Scores.mp3")
					end
				 -- Temple of Kotmogu Orb Reset
				elseif MyZone == "Zone_TempleofKotmogu" then
					PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\OrbReturned.mp3")
				 -- Silvershard Mines Cart Arrived
				elseif MyZone == "Zone_SilvershardMines" then
					PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\MineShaftOpening.mp3")
				end

			elseif event == "WORLD_MAP_UPDATE" then
				-- Strand of the Ancients
				if MyZone == "Zone_StrandoftheAncients" then
					local i
					-- If the Round is not over yet
					if SotaRoundOver ~= true then
						-- East Graveyard
						for i = 2, 3, 1 do
							local textureIndex = select(3, GetMapLandmarkInfo(i))
							if textureIndex then
								local faketextureIndex = textureIndex+100
								local type = SOTAget_objective(faketextureIndex)
								if type then
									if SOTAobj_state(SOTAobjectives[type]) == 2 and SOTAobj_state(faketextureIndex) == 1 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Node_Defense.mp3")
									elseif SOTAobj_state(SOTAobjectives[type]) == 1 and SOTAobj_state(faketextureIndex) == 2 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Node_Defense.mp3")
									end
									SOTAobjectives[type] = faketextureIndex
								end
							end
						end
						-- South Graveyard
						for i = 9, 9, 1 do
							local textureIndex = select(3, GetMapLandmarkInfo(i))
							if textureIndex then
								local faketextureIndex = textureIndex+300
								local type = SOTAget_objective(faketextureIndex)
								if type then
									if SOTAobj_state(SOTAobjectives[type]) == 2 and SOTAobj_state(faketextureIndex) == 1 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Node_Defense.mp3")
									elseif SOTAobj_state(SOTAobjectives[type]) == 1 and SOTAobj_state(faketextureIndex) == 2 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Node_Defense.mp3")
									end
									SOTAobjectives[type] = faketextureIndex
								end
							end
						end
						-- West Graveyard
						for i = 12, 12, 1 do
							local textureIndex = select(3, GetMapLandmarkInfo(i))
							if textureIndex then
								local faketextureIndex = textureIndex+200
								local type = SOTAget_objective(faketextureIndex)
								if type then
									if SOTAobj_state(SOTAobjectives[type]) == 2 and SOTAobj_state(faketextureIndex) == 1 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Node_Defense.mp3")
									elseif SOTAobj_state(SOTAobjectives[type]) == 1 and SOTAobj_state(faketextureIndex) == 2 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Node_Defense.mp3")
									end
									SOTAobjectives[type] = faketextureIndex
								end
							end
						end
					end
					-- Alliance Chamber of Ancient Relics
					for i = 1, 2, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+400
							local type = SOTAget_objective(faketextureIndex)
							if type then
								if SOTAobj_state(SOTAobjectives[type]) == 4 and SOTAobj_state(faketextureIndex) == 5 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\BarricadeDestroyedBlueCoreIsVulnerable.mp3")
								end
								SOTAobjectives[type] = faketextureIndex
							end
						end
					end
					-- Horde Chamber of Ancient Relics
					for i = 1, 2, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+400
							local type = SOTAget_objective(faketextureIndex)
							if type then
								if SOTAobj_state(SOTAobjectives[type]) == 7 and SOTAobj_state(faketextureIndex) == 8 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\BarricadeDestroyedRedCoreIsVulnerable.mp3")
								end
								SOTAobjectives[type] = faketextureIndex
							end
						end
					end
					-- Gate of the Blue Sapphire
					for i = 3, 4, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+600
							local type = SOTAget_objective(faketextureIndex)
							if type then
								if SOTAobj_state(SOTAobjectives[type]) == 10 and SOTAobj_state(faketextureIndex) == 11 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\BarricadeDestroyed.mp3")
								end
								SOTAobjectives[type] = faketextureIndex
							end
						end
					end
					-- Gate of the Green Emerald
					for i = 4, 5, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+800
							local type = SOTAget_objective(faketextureIndex)
							if type then
								if SOTAobj_state(SOTAobjectives[type]) == 10 and SOTAobj_state(faketextureIndex) == 11 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\BarricadeDestroyed.mp3")
								end
								SOTAobjectives[type] = faketextureIndex
							end
						end
					end
					-- Gate of the Purple Amethyst
					for i = 5, 6, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+700
							local type = SOTAget_objective(faketextureIndex)
							if type then
								if SOTAobj_state(SOTAobjectives[type]) == 10 and SOTAobj_state(faketextureIndex) == 11 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\BarricadeDestroyed.mp3")
								end
								SOTAobjectives[type] = faketextureIndex
							end
						end
					end
					-- Gate of the Red Sun
					for i = 6, 7, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+500
							local type = SOTAget_objective(faketextureIndex)
							if type then
								if SOTAobj_state(SOTAobjectives[type]) == 10 and SOTAobj_state(faketextureIndex) == 11 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\BarricadeDestroyed.mp3")
								end
								SOTAobjectives[type] = faketextureIndex
							end
						end
					end
					-- Gate of the Yellow Moon
					for i = 7, 8, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+600
							local type = SOTAget_objective(faketextureIndex)
							if type then
								if SOTAobj_state(SOTAobjectives[type]) == 10 and SOTAobj_state(faketextureIndex) == 11 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\BarricadeDestroyed.mp3")
								end
								SOTAobjectives[type] = faketextureIndex
							end
						end
					end
				 -- Isle of Conquest
				elseif MyZone == "Zone_IsleofConquest" then
					-- Bases
					local i
					for i = 1, GetNumMapLandmarks(), 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local type = IOCget_objective(textureIndex)
							if type then
								if IOCobj_state(IOCobjectives[type]) == 3 and IOCobj_state(textureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif IOCobj_state(IOCobjectives[type]) == 4 and IOCobj_state(textureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif IOCobj_state(IOCobjectives[type]) == 1 and IOCobj_state(textureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif IOCobj_state(IOCobjectives[type]) == 2 and IOCobj_state(textureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								elseif IOCobj_state(IOCobjectives[type]) == 3 and IOCobj_state(textureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif IOCobj_state(IOCobjectives[type]) == 4 and IOCobj_state(textureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								end
								IOCobjectives[type] = textureIndex
							end
						end
					end
				 -- Wintergrasp
				elseif MyZone == "Zone_Wintergrasp" then
					local isActive = select(3, GetWorldPVPAreaInfo(1))
					if isActive == true then
						local i
						-- Flamewatch Tower
						for i = 5, 5, 1 do
							local name, _, textureIndex = GetMapLandmarkInfo(i)
							if name and textureIndex then
								local faketextureIndex = textureIndex+100
								local type = WGget_objective(faketextureIndex)
								if type then
									if WGobj_state(WGobjectives[type]) == 1 and WGobj_state(faketextureIndex) == 3 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_TowerNode_HeavilyDamaged.mp3")
									elseif WGobj_state(WGobjectives[type]) == 3 and WGobj_state(faketextureIndex) == 4 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_TowerNode_Destroyed.mp3")
									elseif WGobj_state(WGobjectives[type]) == 2 and WGobj_state(faketextureIndex) == 5 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_TowerNode_HeavilyDamaged.mp3")
									elseif WGobj_state(WGobjectives[type]) == 5 and WGobj_state(faketextureIndex) == 6 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_TowerNode_Destroyed.mp3")
									end
									WGobjectives[type] = faketextureIndex
								end
							end
						end
						-- Shadowsight Tower
						for i = 9, 9, 1 do
							local name, _, textureIndex = GetMapLandmarkInfo(i)
							if name and textureIndex then
								local faketextureIndex = textureIndex+200
								local type = WGget_objective(faketextureIndex)
								if type then
									if WGobj_state(WGobjectives[type]) == 1 and WGobj_state(faketextureIndex) == 3 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_TowerNode_HeavilyDamaged.mp3")
									elseif WGobj_state(WGobjectives[type]) == 3 and WGobj_state(faketextureIndex) == 4 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_TowerNode_Destroyed.mp3")
									elseif WGobj_state(WGobjectives[type]) == 2 and WGobj_state(faketextureIndex) == 5 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_TowerNode_HeavilyDamaged.mp3")
									elseif WGobj_state(WGobjectives[type]) == 5 and WGobj_state(faketextureIndex) == 6 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_TowerNode_Destroyed.mp3")
									end
									WGobjectives[type] = faketextureIndex
								end
							end
						end
						-- Winter's Edge Tower
						for i = 15, 15, 1 do
							local name, _, textureIndex = GetMapLandmarkInfo(i)
							if name and textureIndex then
								local faketextureIndex = textureIndex+300
								local type = WGget_objective(faketextureIndex)
								if type then
									if WGobj_state(WGobjectives[type]) == 1 and WGobj_state(faketextureIndex) == 3 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_TowerNode_HeavilyDamaged.mp3")
									elseif WGobj_state(WGobjectives[type]) == 3 and WGobj_state(faketextureIndex) == 4 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_TowerNode_Destroyed.mp3")
									elseif WGobj_state(WGobjectives[type]) == 2 and WGobj_state(faketextureIndex) == 5 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_TowerNode_HeavilyDamaged.mp3")
									elseif WGobj_state(WGobjectives[type]) == 5 and WGobj_state(faketextureIndex) == 6 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_TowerNode_Destroyed.mp3")
									end
									WGobjectives[type] = faketextureIndex
								end
							end
						end
					end
				end
			end
		end
	end
end

function PVPSound_OnEventTwo(self, event, ...)
	if Locale ~= "koKR" and Locale ~= "zhCN" and Locale ~= "zhTW" then
		if PS_BattlegroundSound == true then
			if event == "UPDATE_WORLD_STATES" then
				-- Waronsg Gulch and Twin Peaks
				if MyZone == "Zone_WarsongGulch" or MyZone == "Zone_TwinPeaks" then
					if BgIsOver ~= true then
						if select(4, GetWorldStateUIInfo(1)) ~= nil then
							-- Time Remaining
							local TimeRemaining = tonumber(string.match(select(4, GetWorldStateUIInfo(1)), "(%d+)"))
							if TimeRemaining then
								local type = WSGandTPTimeget_objective(TimeRemaining)
								if type then
									if WSGandTPTimeobj_state(WSGandTPTimeobjectives[type]) == 1 and WSGandTPTimeobj_state(TimeRemaining) == 2 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\CountDown\\5MinutesRemain.mp3")
									elseif WSGandTPTimeobj_state(WSGandTPTimeobjectives[type]) == 3 and WSGandTPTimeobj_state(TimeRemaining) == 4 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\CountDown\\3MinutesRemain.mp3")
									elseif WSGandTPTimeobj_state(WSGandTPTimeobjectives[type]) == 4 and WSGandTPTimeobj_state(TimeRemaining) == 5 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\CountDown\\2MinutesRemain.mp3")
									elseif WSGandTPTimeobj_state(WSGandTPTimeobjectives[type]) == 5 and WSGandTPTimeobj_state(TimeRemaining) == 6 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\CountDown\\1MinutesRemain.mp3")
									end
									WSGandTPTimeobjectives[type] = TimeRemaining
								end
							end
						end
					end
					if select(4, GetWorldStateUIInfo(2)) ~= nil and select(4, GetWorldStateUIInfo(3)) ~= nil then
						-- Alliance Score
						local AllianceScore = tonumber(string.match(select(4, GetWorldStateUIInfo(2)), "(%d)/"))
						-- Horde Score
						local HordeScore = tonumber(string.match(select(4, GetWorldStateUIInfo(3)), "(%d)/"))
						-- Alliance
						if AllianceScore and HordeScore then
							local type = WSGandTPAget_objective(AllianceScore)
							if type then
								if WSGandTPAobj_state(WSGandTPAobjectives[type]) == 1 and WSGandTPAobj_state(AllianceScore) == 2 and HordeScore == 0 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Takes_Lead.mp3")
									LastScored = "Alliance"
								elseif WSGandTPAobj_state(WSGandTPAobjectives[type]) == 2 and WSGandTPAobj_state(AllianceScore) == 3 and HordeScore == 1 then
									if LastScored == "Alliance" then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Scores.mp3")
									elseif LastScored == "Horde" then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Takes_Lead.mp3")
									else
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Scores.mp3")
									end
									LastScored = "Alliance"
								elseif WSGandTPAobj_state(WSGandTPAobjectives[type]) == 1 and WSGandTPAobj_state(AllianceScore) == 2 and HordeScore == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Scores.mp3")
									LastScored = "Alliance"
								elseif WSGandTPAobj_state(WSGandTPAobjectives[type]) == 1 and WSGandTPAobj_state(AllianceScore) == 2 and HordeScore == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Takes_Lead.mp3")
									LastScored = "Alliance"
								elseif WSGandTPAobj_state(WSGandTPAobjectives[type]) == 2 and WSGandTPAobj_state(AllianceScore) == 3 and HordeScore == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Takes_Lead.mp3")
									LastScored = "Alliance"
								elseif WSGandTPAobj_state(WSGandTPAobjectives[type]) == 2 and WSGandTPAobj_state(AllianceScore) == 3 and HordeScore == 0 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Inc_Lead.mp3")
									LastScored = "Alliance"
								end
								if PS_BattlegroundSoundEngine == true then
									-- 3/3 Scores
									if WSGandTPAobj_state(WSGandTPAobjectives[type]) == 3 and WSGandTPAobj_state(AllianceScore) == 4 and HordeScore == 0 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Scores.mp3")
									elseif WSGandTPAobj_state(WSGandTPAobjectives[type]) == 3 and WSGandTPAobj_state(AllianceScore) == 4 and HordeScore == 1 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Scores.mp3")
									elseif WSGandTPAobj_state(WSGandTPAobjectives[type]) == 3 and WSGandTPAobj_state(AllianceScore) == 4 and HordeScore == 2 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Scores.mp3")
									end
								end
								WSGandTPAobjectives[type] = AllianceScore
							end
						end
						-- Horde
						if AllianceScore and HordeScore then
							local type = WSGandTPHget_objective(HordeScore)
							if type then
								if WSGandTPHobj_state(WSGandTPHobjectives[type]) == 1 and WSGandTPHobj_state(HordeScore) == 2 and AllianceScore == 0 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Takes_Lead.mp3")
									LastScored = "Horde"
								elseif WSGandTPHobj_state(WSGandTPHobjectives[type]) == 2 and WSGandTPHobj_state(HordeScore) == 3 and AllianceScore == 1 then
									if LastScored == "Alliance" then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Takes_Lead.mp3")
									elseif LastScored == "Horde" then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Scores.mp3")
									else
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Scores.mp3")
									end
									LastScored = "Horde"
								elseif WSGandTPHobj_state(WSGandTPHobjectives[type]) == 1 and WSGandTPHobj_state(HordeScore) == 2 and AllianceScore == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Scores.mp3")
									LastScored = "Horde"
								elseif WSGandTPHobj_state(WSGandTPHobjectives[type]) == 1 and WSGandTPHobj_state(HordeScore) == 2 and AllianceScore == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Takes_Lead.mp3")
									LastScored = "Horde"
								elseif WSGandTPHobj_state(WSGandTPHobjectives[type]) == 2 and WSGandTPHobj_state(HordeScore) == 3 and AllianceScore == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Takes_Lead.mp3")
									LastScored = "Horde"
								elseif WSGandTPHobj_state(WSGandTPHobjectives[type]) == 2 and WSGandTPHobj_state(HordeScore) == 3 and AllianceScore == 0 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Inc_Lead.mp3")
									LastScored = "Horde"
								end
								if PS_BattlegroundSoundEngine == true then
									-- 3/3 Scores
									if WSGandTPHobj_state(WSGandTPHobjectives[type]) == 3 and WSGandTPHobj_state(HordeScore) == 4 and AllianceScore == 0 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Scores.mp3")
									elseif WSGandTPHobj_state(WSGandTPHobjectives[type]) == 3 and WSGandTPHobj_state(HordeScore) == 4 and AllianceScore == 1 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Scores.mp3")
									elseif WSGandTPHobj_state(WSGandTPHobjectives[type]) == 3 and WSGandTPHobj_state(HordeScore) == 4 and AllianceScore == 2 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Scores.mp3")
									end
								end
								WSGandTPHobjectives[type] = HordeScore
							end
						end
					end
				 -- Arathi Basin
				elseif MyZone == "Zone_ArathiBasin" then
					local i
					-- Blacksmith
					for i = 1, 1, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+100
							local type = ABget_objective(faketextureIndex)
							if type then
								if ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 1 and ABobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 2 and ABobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								end
								ABobjectives[type] = faketextureIndex
							end
						end
					end
					-- Farm
					for i = 2, 2, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+200
							local type = ABget_objective(faketextureIndex)
							if type then
								if ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 1 and ABobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 2 and ABobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								end
								ABobjectives[type] = faketextureIndex
							end
						end
					end
					-- Gold Mine
					for i = 3, 3, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+300
							local type = ABget_objective(faketextureIndex)
							if type then
								if ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 1 and ABobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 2 and ABobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								end
								ABobjectives[type] = faketextureIndex
							end
						end
					end
					-- Lumber Mill
					for i = 4, 4, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+400
							local type = ABget_objective(faketextureIndex)
							if type then
								if ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 1 and ABobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 2 and ABobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								end
								ABobjectives[type] = faketextureIndex
							end
						end
					end
					-- Stables
					for i = 5, 5, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+500
							local type = ABget_objective(faketextureIndex)
							if type then
								if ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 1 and ABobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 2 and ABobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 3 and ABobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif ABobj_state(ABobjectives[type]) == 4 and ABobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								end
								ABobjectives[type] = faketextureIndex
							end
						end
					end
					-- Alliance Dominating
					for i = 1, 1, 1 do
						if PS_BattlegroundSoundEngine == true then
							if select(4, GetWorldStateUIInfo(i)) ~= nil then
								local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d)%s"))
								if faketextureIndex then
									local type = ABBaseAget_objective(faketextureIndex)
									if type then
										if ABBaseAobj_state(ABBaseAobjectives[type]) == 1 and ABBaseAobj_state(faketextureIndex) == 2 then
											PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\AllianceDominating.mp3")
										end
										ABBaseAobjectives[type] = faketextureIndex
									end
								end
							end
						end
					end
					-- Horde Dominating
					for i = 2, 2, 1 do
						if PS_BattlegroundSoundEngine == true then
							if select(4, GetWorldStateUIInfo(i)) ~= nil then
								local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d)%s"))
								if faketextureIndex then
									local type = ABBaseHget_objective(faketextureIndex)
									if type then
										if ABBaseHobj_state(ABBaseHobjectives[type]) == 1 and ABBaseHobj_state(faketextureIndex) == 2 then
											PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\HordeDominating.mp3")
										end
										ABBaseHobjectives[type] = faketextureIndex
									end
								end
							end
						end
					end
				 -- The Battle for Gilneas
				elseif MyZone == "Zone_TheBattleforGilneas" then
					local i
					-- Lighthouse
					for i = 1, 1, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+100
							local type = TBFGget_objective(faketextureIndex)
							if type then
								if TBFGobj_state(TBFGobjectives[type]) == 3 and TBFGobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 4 and TBFGobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 4 and TBFGobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 3 and TBFGobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 1 and TBFGobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 2 and TBFGobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 3 and TBFGobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 4 and TBFGobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								end
								TBFGobjectives[type] = faketextureIndex
							end
						end
					end
					-- Mines
					for i = 2, 2, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+200
							local type = TBFGget_objective(faketextureIndex)
							if type then
								if TBFGobj_state(TBFGobjectives[type]) == 3 and TBFGobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 4 and TBFGobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 4 and TBFGobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 3 and TBFGobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 1 and TBFGobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 2 and TBFGobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 3 and TBFGobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 4 and TBFGobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								end
								TBFGobjectives[type] = faketextureIndex
							end
						end
					end
					-- Waterworks
					for i = 3, 3, 1 do
						local textureIndex = select(3, GetMapLandmarkInfo(i))
						if textureIndex then
							local faketextureIndex = textureIndex+300
							local type = TBFGget_objective(faketextureIndex)
							if type then
								if TBFGobj_state(TBFGobjectives[type]) == 3 and TBFGobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 4 and TBFGobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 4 and TBFGobj_state(faketextureIndex) == 1 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 3 and TBFGobj_state(faketextureIndex) == 2 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 1 and TBFGobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 2 and TBFGobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 3 and TBFGobj_state(faketextureIndex) == 4 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
								elseif TBFGobj_state(TBFGobjectives[type]) == 4 and TBFGobj_state(faketextureIndex) == 3 then
									PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
								end
								TBFGobjectives[type] = faketextureIndex
							end
						end
					end
					-- Alliance Dominating
					for i = 1, 1, 1 do
						if PS_BattlegroundSoundEngine == true then
							if select(4, GetWorldStateUIInfo(i)) ~= nil then
								local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d)%s"))
								if faketextureIndex then
									local type = TBFGBaseAget_objective(faketextureIndex)
									if type then
										if TBFGBaseAobj_state(TBFGBaseAobjectives[type]) == 1 and TBFGBaseAobj_state(faketextureIndex) == 2 then
											PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\AllianceDominating.mp3")
										end
										TBFGBaseAobjectives[type] = faketextureIndex
									end
								end
							end
						end
					end
					-- Horde Dominating
					for i = 2, 2, 1 do
						if PS_BattlegroundSoundEngine == true then
							if select(4, GetWorldStateUIInfo(i)) ~= nil then
								local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d)%s"))
								if faketextureIndex then
									local type = TBFGBaseHget_objective(faketextureIndex)
									if type then
										if TBFGBaseHobj_state(TBFGBaseHobjectives[type]) == 1 and TBFGBaseHobj_state(faketextureIndex) == 2 then
											PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\HordeDominating.mp3")
										end
										TBFGBaseHobjectives[type] = faketextureIndex
									end
								end
							end
						end
					end
				 -- Eye of the Storm
				elseif MyZone == "Zone_EyeoftheStorm" then
					if BgIsOver ~= true then
						if IsRated == false then
							local i
							if select(4, GetWorldStateUIInfo(2)) ~= nil then
								-- Alliance Bases
								for i = 2, 2, 1 do
									local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d)%s"))
									if faketextureIndex then
										local type = EOTSBaseAget_objective(faketextureIndex)
										if type then
											if EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 1 and EOTSBaseAobj_state(faketextureIndex) == 2 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
											elseif EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 2 and EOTSBaseAobj_state(faketextureIndex) == 3 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
											elseif EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 3 and EOTSBaseAobj_state(faketextureIndex) == 4 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
											elseif EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 4 and EOTSBaseAobj_state(faketextureIndex) == 5 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
												-- Alliance Dominating
												if PS_BattlegroundSoundEngine == true then
													PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\AllianceDominating.mp3")
												end
											elseif EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 5 and EOTSBaseAobj_state(faketextureIndex) == 4 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
											elseif EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 4 and EOTSBaseAobj_state(faketextureIndex) == 3 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
											elseif EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 3 and EOTSBaseAobj_state(faketextureIndex) == 2 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
											elseif EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 2 and EOTSBaseAobj_state(faketextureIndex) == 1 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
											end
											EOTSBaseAobjectives[type] = faketextureIndex
										end
									end
								end
								-- Alliance Victory Points
								for i = 2, 2, 1 do
									local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d+)/"))
									if faketextureIndex then
										local type = EOTSWINget_objective(faketextureIndex)
										if type then
											if EOTSWINobj_state(EOTSWINobjectives[type]) == 0 and EOTSWINobj_state(faketextureIndex) == 1 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\AllianceWins.mp3")
												BgIsOver = true
											end
											EOTSWINobjectives[type] = faketextureIndex
										end
									end
								end
							end
							if select(4, GetWorldStateUIInfo(3)) ~= nil then
								-- Horde Bases
								for i = 3, 3, 1 do
									local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d)%s"))
									if faketextureIndex then
										local type = EOTSBaseHget_objective(faketextureIndex)
										if type then
											if EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 1 and EOTSBaseHobj_state(faketextureIndex) == 2 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
											elseif EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 2 and EOTSBaseHobj_state(faketextureIndex) == 3 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
											elseif EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 3 and EOTSBaseHobj_state(faketextureIndex) == 4 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
											elseif EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 4 and EOTSBaseHobj_state(faketextureIndex) == 5 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
												-- Horde Dominating
												if PS_BattlegroundSoundEngine == true then
													PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\HordeDominating.mp3")
												end
											elseif EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 5 and EOTSBaseHobj_state(faketextureIndex) == 4 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
											elseif EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 4 and EOTSBaseHobj_state(faketextureIndex) == 3 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
											elseif EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 3 and EOTSBaseHobj_state(faketextureIndex) == 2 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
											elseif EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 2 and EOTSBaseHobj_state(faketextureIndex) == 1 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
											end
											EOTSBaseHobjectives[type] = faketextureIndex
										end
									end
								end
								-- Horde Victory Points
								for i = 3, 3, 1 do
									local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d+)/"))
									if faketextureIndex then
										local type = EOTSWINget_objective(faketextureIndex)
										if type then
											if EOTSWINobj_state(EOTSWINobjectives[type]) == 0 and EOTSWINobj_state(faketextureIndex) == 1 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\HordeWins.mp3")
												BgIsOver = true
											end
											EOTSWINobjectives[type] = faketextureIndex
										end
									end
								end
							end
						else
							local i
							if select(4, GetWorldStateUIInfo(1)) ~= nil then
								-- Alliance Bases
								for i = 1, 1, 1 do
									local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d)%s"))
									if faketextureIndex then
										local type = EOTSBaseAget_objective(faketextureIndex)
										if type then
											if EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 1 and EOTSBaseAobj_state(faketextureIndex) == 2 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
											elseif EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 2 and EOTSBaseAobj_state(faketextureIndex) == 3 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
											elseif EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 3 and EOTSBaseAobj_state(faketextureIndex) == 4 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
											elseif EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 4 and EOTSBaseAobj_state(faketextureIndex) == 5 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Defense.mp3")
												-- Alliance Dominating
												if PS_BattlegroundSoundEngine == true then
													PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\AllianceDominating.mp3")
												end
											elseif EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 5 and EOTSBaseAobj_state(faketextureIndex) == 4 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
											elseif EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 4 and EOTSBaseAobj_state(faketextureIndex) == 3 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
											elseif EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 3 and EOTSBaseAobj_state(faketextureIndex) == 2 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
											elseif EOTSBaseAobj_state(EOTSBaseAobjectives[type]) == 2 and EOTSBaseAobj_state(faketextureIndex) == 1 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Offense.mp3")
											end
											EOTSBaseAobjectives[type] = faketextureIndex
										end
									end
								end
								-- Alliance Victory Points
								for i = 1, 1, 1 do
									local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d+)/"))
									if faketextureIndex then
										local type = EOTSWINget_objective(faketextureIndex)
										if type then
											if EOTSWINobj_state(EOTSWINobjectives[type]) == 0 and EOTSWINobj_state(faketextureIndex) == 1 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\AllianceWins.mp3")
												BgIsOver = true
											end
											EOTSWINobjectives[type] = faketextureIndex
										end
									end
								end
							end
							if select(4, GetWorldStateUIInfo(2)) ~= nil then
								-- Horde Bases
								for i = 2, 2, 1 do
									local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d)%s"))
									if faketextureIndex then
										local type = EOTSBaseHget_objective(faketextureIndex)
										if type then
											if EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 1 and EOTSBaseHobj_state(faketextureIndex) == 2 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
											elseif EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 2 and EOTSBaseHobj_state(faketextureIndex) == 3 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
											elseif EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 3 and EOTSBaseHobj_state(faketextureIndex) == 4 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
											elseif EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 4 and EOTSBaseHobj_state(faketextureIndex) == 5 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_Base_Defense.mp3")
												-- Horde Dominating
												if PS_BattlegroundSoundEngine == true then
													PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\HordeDominating.mp3")
												end
											elseif EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 5 and EOTSBaseHobj_state(faketextureIndex) == 4 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
											elseif EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 4 and EOTSBaseHobj_state(faketextureIndex) == 3 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
											elseif EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 3 and EOTSBaseHobj_state(faketextureIndex) == 2 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
											elseif EOTSBaseHobj_state(EOTSBaseHobjectives[type]) == 2 and EOTSBaseHobj_state(faketextureIndex) == 1 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_Base_Offense.mp3")
											end
											EOTSBaseHobjectives[type] = faketextureIndex
										end
									end
								end
								-- Horde Victory Points
								for i = 2, 2, 1 do
									local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d+)/"))
									if faketextureIndex then
										local type = EOTSWINget_objective(faketextureIndex)
										if type then
											if EOTSWINobj_state(EOTSWINobjectives[type]) == 0 and EOTSWINobj_state(faketextureIndex) == 1 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\HordeWins.mp3")
												BgIsOver = true
											end
											EOTSWINobjectives[type] = faketextureIndex
										end
									end
								end
							end
						end
					end
				 -- Silvershard Mines
				elseif MyZone == "Zone_SilvershardMines" then
					if BgIsOver ~= true then
						local i
						if select(4, GetWorldStateUIInfo(1)) ~= nil then
							-- Alliance Resources
							for i = 1, 1, 1 do
								local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d+)/"))
								if faketextureIndex then
									local type = SMWINget_objective(faketextureIndex)
									if type then
										if SMWINobj_state(SMWINobjectives[type]) == 0 and SMWINobj_state(faketextureIndex) == 1 then
											PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\AllianceWins.mp3")
											BgIsOver = true
										end
										SMWINobjectives[type] = faketextureIndex
									end
								end
							end
						end
						if select(4, GetWorldStateUIInfo(2)) ~= nil then
							-- Horde Resources
							for i = 2, 2, 1 do
								local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d+)/"))
								if faketextureIndex then
									local type = SMWINget_objective(faketextureIndex)
									if type then
										if SMWINobj_state(SMWINobjectives[type]) == 0 and SMWINobj_state(faketextureIndex) == 1 then
											PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\GameStatus\\HordeWins.mp3")
											BgIsOver = true
										end
										SMWINobjectives[type] = faketextureIndex
									end
								end
							end
						end
					end
				 -- Tol Barad Towers Destroyed
				elseif MyZone == "Zone_TolBarad" then
					local isActive = select(3, GetWorldPVPAreaInfo(2))
					if isActive == true then
						local i
						for i = 1, 1, 1 do
							local textureIndex = select(3, GetMapLandmarkInfo(i))
							if textureIndex then
								if textureIndex == 48 then
									TbAttacker = "Alliance"
								elseif textureIndex == 46 then
									TbAttacker = "Horde"
								end
							end
						end
						if TbAttacker == "Alliance" then
							-- Towers Destroyed
							for i = 7, 7, 1 do
								if select(4, GetWorldStateUIInfo(i)) ~= nil then
									local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d)%s"))
									if faketextureIndex then
										local type = TBget_objective(faketextureIndex)
										if type then
											if TBobj_state(TBobjectives[type]) == 1 and TBobj_state(faketextureIndex) == 2 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_TowerNode_Destroyed.mp3")
											elseif TBobj_state(TBobjectives[type]) == 2 and TBobj_state(faketextureIndex) == 3 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_TowerNode_Destroyed.mp3")
											elseif TBobj_state(TBobjectives[type]) == 3 and TBobj_state(faketextureIndex) == 4 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\HORDE_TowerNode_Destroyed.mp3")
											end
											TBobjectives[type] = faketextureIndex
										end
									end
								end
							end
						elseif TbAttacker == "Horde" then
							-- Towers Destroyed
							for i = 7, 7, 1 do
								if select(4, GetWorldStateUIInfo(i)) ~= nil then
									local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), "(%d)%s"))
									if faketextureIndex then
										local type = TBget_objective(faketextureIndex)
										if type then
											if TBobj_state(TBobjectives[type]) == 1 and TBobj_state(faketextureIndex) == 2 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_TowerNode_Destroyed.mp3")
											elseif TBobj_state(TBobjectives[type]) == 2 and TBobj_state(faketextureIndex) == 3 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_TowerNode_Destroyed.mp3")
											elseif TBobj_state(TBobjectives[type]) == 3 and TBobj_state(faketextureIndex) == 4 then
												PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\"..MyZone.."\\ALLIANCE_TowerNode_Destroyed.mp3")
											end
											TBobjectives[type] = faketextureIndex
										end
									end
								end
							end
						end
					end
				 -- Alterac Valley and Isle of Conquest Countdown
				elseif MyZone == "Zone_AlteracValley" or MyZone == "Zone_IsleofConquest" then
					local i
					-- Alliance Reinforcements
					for i = 1, 1, 1 do
						if select(4, GetWorldStateUIInfo(i)) ~= nil then
							local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), ": (%d+)"))
							if faketextureIndex then
								local type = AVandIOCAget_objective(faketextureIndex)
								if type then
									if AVandIOCAobj_state(AVandIOCAobjectives[type]) == 1 and AVandIOCAobj_state(faketextureIndex) == 2 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\CountDown\\TenKillsRemain.mp3")
									elseif AVandIOCAobj_state(AVandIOCAobjectives[type]) == 3 and AVandIOCAobj_state(faketextureIndex) == 4 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\CountDown\\FiveKillsRemain.mp3")
									elseif AVandIOCAobj_state(AVandIOCAobjectives[type]) == 5 and AVandIOCAobj_state(faketextureIndex) == 6 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\CountDown\\OneKillRemains.mp3")
									end
									AVandIOCAobjectives[type] = faketextureIndex
								end
							end
						end
					end
					-- Horde Reinforcements
					for i = 2, 2, 1 do
						if select(4, GetWorldStateUIInfo(i)) ~= nil then
							local faketextureIndex = tonumber(string.match(select(4, GetWorldStateUIInfo(i)), ": (%d+)"))
							if faketextureIndex then
								local type = AVandIOCHget_objective(faketextureIndex)
								if type then
									if AVandIOCHobj_state(AVandIOCHobjectives[type]) == 1 and AVandIOCHobj_state(faketextureIndex) == 2 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\CountDown\\TenKillsRemain.mp3")
									elseif AVandIOCHobj_state(AVandIOCHobjectives[type]) == 3 and AVandIOCHobj_state(faketextureIndex) == 4 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\CountDown\\FiveKillsRemain.mp3")
									elseif AVandIOCHobj_state(AVandIOCHobjectives[type]) == 5 and AVandIOCHobj_state(faketextureIndex) == 6 then
										PVPSound_AddToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\CountDown\\OneKillRemains.mp3")
									end
									AVandIOCHobjectives[type] = faketextureIndex
								end
							end
						end
					end
				end
			end
		end
	end
end

function PVPSound_OnEventThree(self, event, ...)
	if Locale ~= "koKR" and Locale ~= "zhCN" and Locale ~= "zhTW" then
		if event == "COMBAT_LOG_EVENT_UNFILTERED" then
			local eventType, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, swingOverkill, spellOverkill
			if select(4, GetBuildInfo()) >= 40200 then
				eventType = select(2, ...)
				sourceGUID = select(4, ...)
				sourceName = select(5, ...)
				sourceFlags = select(6, ...)
				destGUID = select(8, ...)
				destName = select(9, ...)
				destFlags = select(10, ...)
				swingOverkill = select(13, ...)
				spellOverkill = select(16, ...)
			elseif select(4, GetBuildInfo()) >= 40100 then
				eventType = select(2, ...)
				sourceGUID = select(4, ...)
				sourceName = select(5, ...)
				sourceFlags = select(6, ...)
				destGUID = select(7, ...)
				destName = select(8, ...)
				destFlags = select(9, ...)
				swingOverkill = select(11, ...)
				spellOverkill = select(14, ...)
			elseif select(4, GetBuildInfo()) >= 40000 then
				eventType = select(2, ...)
				sourceGUID = select(3, ...)
				sourceName = select(4, ...)
				sourceFlags = select(5, ...)
				destGUID = select(6, ...)
				destName = select(7, ...)
				destFlags = select(8, ...)
				swingOverkill = select(10, ...)
				spellOverkill = select(13, ...)
			elseif select(4, GetBuildInfo()) >= 20400 then
				eventType = select(2, ...)
				sourceGUID = select(3, ...)
				sourceName = select(4, ...)
				sourceFlags = select(5, ...)
				destGUID = select(6, ...)
				destName = select(7, ...)
				destFlags = select(8, ...)
				swingOverkill = select(10, ...)
				spellOverkill = select(13, ...)
			end

			local PS_COMBATLOG_FILTER_MY_PETS					= bit.bor (COMBATLOG_OBJECT_AFFILIATION_MINE, COMBATLOG_OBJECT_REACTION_FRIENDLY, COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_TYPE_OBJECT, COMBATLOG_OBJECT_TYPE_GUARDIAN, COMBATLOG_OBJECT_TYPE_PET)
			local PS_COMBATLOG_FILTER_ENEMY_NPCS				= bit.bor (COMBATLOG_OBJECT_AFFILIATION_MASK, COMBATLOG_OBJECT_REACTION_MASK, COMBATLOG_OBJECT_CONTROL_NPC, COMBATLOG_OBJECT_TYPE_NPC)
			local PS_COMBATLOG_FILTER_ENEMY_PLAYERS				= bit.bor (COMBATLOG_OBJECT_AFFILIATION_MASK, COMBATLOG_OBJECT_REACTION_MASK, COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_TYPE_PLAYER)
			local PS_COMBATLOG_FILTER_ENEMY_PLAYERS_AND_NPCS	= bit.bor (COMBATLOG_OBJECT_AFFILIATION_MASK, COMBATLOG_OBJECT_REACTION_MASK, COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_TYPE_PLAYER, COMBATLOG_OBJECT_CONTROL_NPC, COMBATLOG_OBJECT_TYPE_NPC)
			local Message -- This stuff needs to be here

			-- To an Enemy
			if destName and not CombatLog_Object_IsA(destFlags, COMBATLOG_OBJECT_NONE) then
				ToEnemyPlayer = CombatLog_Object_IsA(destFlags, PS_COMBATLOG_FILTER_ENEMY_PLAYERS)
				ToEnemyPlayerAndNPC = CombatLog_Object_IsA(destFlags, PS_COMBATLOG_FILTER_ENEMY_PLAYERS_AND_NPCS)
			end
			-- From an Enemy or from My Pets
			if sourceName and not CombatLog_Object_IsA(sourceFlags, COMBATLOG_OBJECT_NONE) then
				FromMyPets = CombatLog_Object_IsA(sourceFlags, PS_COMBATLOG_FILTER_MY_PETS)
				FromEnemyNPC = CombatLog_Object_IsA(sourceFlags, PS_COMBATLOG_FILTER_ENEMY_NPCS)
				FromEnemyPlayer = CombatLog_Object_IsA(sourceFlags, PS_COMBATLOG_FILTER_ENEMY_PLAYERS)
				FromEnemyPlayerAndNPC = CombatLog_Object_IsA(sourceFlags, PS_COMBATLOG_FILTER_ENEMY_PLAYERS_AND_NPCS)
			end
			-- PVP and PVE Mode
			if PS_PVPMode == true then
				ToEnemy = ToEnemyPlayer
				FromEnemy = FromEnemyPlayer
			else
				ToEnemy = ToEnemyPlayerAndNPC
				FromEnemy = FromEnemyPlayerAndNPC
			end

			if (eventType == "PARTY_KILL" and sourceGUID == UnitGUID("player") and ToEnemy) or (eventType == "SWING_DAMAGE" and destGUID ~= UnitGUID("player") and FromMyPets and ToEnemy and tonumber(swingOverkill) ~= nil and tonumber(swingOverkill) ~= -1) or ((eventType == "RANGE_DAMAGE" or eventType == "SPELL_DAMAGE" or eventType == "SPELL_PERIODIC_DAMAGE") and destGUID ~= UnitGUID("player") and FromMyPets and ToEnemy and tonumber(spellOverkill) ~= nil and tonumber(spellOverkill) ~= -1) then
				if PS_PaybackSound == true then
					KilledWho = destName
					PVPSound_AddToPaybackQueue(KilledWho)
				end
				-- First Killing
				if not LastKill or (GetTime() - LastKill > ResetTime) or TimerReset then
					if PS_KillSound == true then
						PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\FirstBlood.mp3")
						-- Sound Effects
						if PS_SoundEffect == true then
							PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\FirstBlood.mp3")
						end
						-- Killing SCT
						if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
							Spree = FirstBlood
							PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\FirstBlood.mp3", Spree, PSSctFrame)
						end
					end
					File = "FirstBlood.mp3"
					if MyGender == "Male" then
						Message = Msg_FirstBloodMale
						-- Male Data Share
						if PS_DataShare == true then
							SendTime = time()
							if InstanceType == "pvp" then
								SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "BATTLEGROUND")
							else
								SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "RAID")
							end
						end
					elseif MyGender == "Female" then
						Message = Msg_FirstBloodFemale
						-- Female Data Share
						if PS_DataShare == true then
							SendTime = time()
							if InstanceType == "pvp" then
								SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "BATTLEGROUND")
							else
								SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "RAID")
							end
						end
					end
					-- RetributionKilling (First Blood)
					if PS_PaybackSound == true then
						RetributionKill = false
						for i = 1, table.getn(PVPSound_RetributionQueue) do
							if string.upper(PVPSound_RetributionQueue[i].dir) == string.upper(KilledWho) then
								RetributionKill = true
							end
						end
					end
					if RetributionKill == true then
						if PS_PaybackSound == true then
							PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Retribution.mp3")
							-- Sound Effects
							if PS_SoundEffect == true then
								PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Retribution.mp3")
							end
							-- Retribution SCT
							if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
								PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Retribution.mp3", Retribution, PSSctFrame)
							end
						end
					end
					KillCounter = 1
					Kills = 1
					if PS_MultiKillSound == true then
						if not LastKill or (GetTime() - LastKill > MultiKillTime) or TimerReset then
							MultiKills = 1
						end
					end
					TimerReset = false
				 -- Killing
				elseif (GetTime() - LastKill <= ResetTime) then
					KillCounter = KillCounter + 1
					if (GetTime() - LastKill <= PS.KillTime) then
						FirstKill = LastKill
						if (GetTime() - FirstKill <= PS.KillTime) then
							Kills = Kills + 1
							if Kills == 2 * RankStep then
								if PS_KillSound == true then
									PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\KillingSpree.mp3")
									-- Sound Effects
									if PS_SoundEffect == true then
										PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\KillingSpree.mp3")
									end
									-- Killing SCT
									if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
										Spree = KillingSpree
										PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\KillingSpree.mp3", Spree, PSSctFrame)
									end
								end
								File = "KillingSpree.mp3"
								Message = Msg_KillingSpree
								-- Data Share
								if PS_DataShare == true then
									SendTime = time()
									if InstanceType == "pvp" then
										SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "BATTLEGROUND")
									else
										SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "RAID")
									end
								end
							elseif Kills == 3 * RankStep then
								if PS_KillSound == true then
									PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Rampage.mp3")
									-- Sound Effects
									if PS_SoundEffect == true then
										PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Rampage.mp3")
									end
									-- Killing SCT
									if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
										Spree = Rampage
										PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Rampage.mp3", Spree, PSSctFrame)
									end
								end
								File = "Rampage.mp3"
								Message = Msg_Rampage
								-- Data Share
								if PS_DataShare == true then
									SendTime = time()
									if InstanceType == "pvp" then
										SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "BATTLEGROUND")
									else
										SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "RAID")
									end
								end
							elseif Kills == 4 * RankStep then
								if PS_KillSound == true then
									PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Dominating.mp3")
									-- Sound Effects
									if PS_SoundEffect == true then
										PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Dominating.mp3")
									end
									-- Killing SCT
									if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
										Spree = Dominating
										PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Dominating.mp3", Spree, PSSctFrame)
									end
								end
								File = "Dominating.mp3"
								Message = Msg_Dominating
								-- Data Share
								if PS_DataShare == true then
									SendTime = time()
									if InstanceType == "pvp" then
										SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "BATTLEGROUND")
									else
										SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "RAID")
									end
								end
							elseif Kills == 5 * RankStep then
								if PS_KillSound == true then
									PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Unstoppable.mp3")
									-- Sound Effects
									if PS_SoundEffect == true then
										PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Unstoppable.mp3")
									end
									-- Killing SCT
									if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
										Spree = Unstoppable
										PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Unstoppable.mp3", Spree, PSSctFrame)
									end
								end
								File = "Unstoppable.mp3"
								Message = Msg_Unstoppable
								-- Data Share
								if PS_DataShare == true then
									SendTime = time()
									if InstanceType == "pvp" then
										SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "BATTLEGROUND")
									else
										SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "RAID")
									end
								end
							elseif Kills == 6 * RankStep then
								if PS_KillSound == true then
									PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Godlike.mp3")
									-- Sound Effects
									if PS_SoundEffect == true then
										PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Godlike.mp3")
									end
									-- Killing SCT
									if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
										Spree = Godlike
										PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Godlike.mp3", Spree, PSSctFrame)
									end
								end
								File = "Godlike.mp3"
								Message = Msg_Godlike
								-- Data Share
								if PS_DataShare == true then
									SendTime = time()
									if InstanceType == "pvp" then
										SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "BATTLEGROUND")
									else
										SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "RAID")
									end
								end
							elseif Kills >= 7 * RankStep then
								if PS_KillSound == true then
									PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Massacre.mp3")
									-- Sound Effects
									if PS_SoundEffect == true then
										PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Effects\\KillingMaxRank.mp3")
										PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Massacre.mp3")
									end
									-- Killing SCT
									if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
										Spree = Massacre
										PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Massacre.mp3", Spree, PSSctFrame)
									end
								end
								File = "Massacre.mp3"
								Message = Msg_Massacre
								-- Data Share
								if PS_DataShare == true then
									SendTime = time()
									if InstanceType == "pvp" then
										SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "BATTLEGROUND")
									else
										SendAddonMessage("PVPSound", ""..SendTime.."?"..Message.."", "RAID")
									end
								end
							end
							-- RetributionKilling (0-60sec)
							if PS_PaybackSound == true then
								RetributionKill = false
								for i = 1, table.getn(PVPSound_RetributionQueue) do
									if string.upper(PVPSound_RetributionQueue[i].dir) == string.upper(KilledWho) then
										RetributionKill = true
									end
								end
							end
							if RetributionKill == true then
								if PS_PaybackSound == true then
									PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Retribution.mp3")
									-- Sound Effects
									if PS_SoundEffect == true then
										PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Retribution.mp3")
									end
									-- Retribution SCT
									if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
										PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Retribution.mp3", Retribution, PSSctFrame)
									end
								end
							end
							-- MultiKilling
							if PS_MultiKillSound == true then
								if (GetTime() - LastKill <= MultiKillTime) then
									FirstMultiKill = LastKill
									if (GetTime() - FirstMultiKill > MultiKillTime) then
										MultiKills = 1
									elseif (GetTime() - FirstMultiKill <= MultiKillTime) then
										MultiKills = MultiKills + 1
										if MultiKills == 2 then
											PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\DoubleKill.mp3")
											-- Sound Effects
											if PS_SoundEffect == true then
												PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\DoubleKill.mp3")
											end
											-- Multi Killing SCT
											if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
												Spree = DoubleKill
												PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\DoubleKill.mp3", Spree, PSSctFrame)
											end
										elseif MultiKills == 3 then
											PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\MultiKill.mp3")
											-- Sound Effects
											if PS_SoundEffect == true then
												PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\MultiKill.mp3")
											end
											-- Multi Killing SCT
											if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
												Spree = MultiKill
												PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\MultiKill.mp3", Spree, PSSctFrame)
											end
										elseif MultiKills == 4 then
											PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\MegaKill.mp3")
											-- Sound Effects
											if PS_SoundEffect == true then
												PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\MegaKill.mp3")
											end
											-- Multi Killing SCT
											if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
												Spree = MegaKill
												PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\MegaKill.mp3", Spree, PSSctFrame)
											end
										elseif MultiKills == 5 then
											PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\UltraKill.mp3")
											-- Sound Effects
											if PS_SoundEffect == true then
												PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\UltraKill.mp3")
											end
											-- Multi Killing SCT
											if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
												Spree = UltraKill
												PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\UltraKill.mp3", Spree, PSSctFrame)
											end
										elseif MultiKills > 5 then
											PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\MonsterKill.mp3")
											-- Sound Effects
											if PS_SoundEffect == true then
												PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Effects\\MultiKillingMaxRank.mp3")
												PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\MonsterKill.mp3")
											end
											-- Multi Killing SCT
											if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
												Spree = MonsterKill
												PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\MonsterKill.mp3", Spree, PSSctFrame)
											end
										end
									end
								end
							end
						end
					elseif (GetTime() - LastKill > PS.KillTime) then
						-- If triggers a kill after the Killing Time (60 sec) than replay the last KillSound without emote, SCT and Data Share
						if PS_KillSound == true then
							PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\"..File)
						end
						-- Create a blank table in the Sct Queue with "nil" string message
						if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
							PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\"..File, "nil", PSSctFrame)
						end
						-- RetributionKilling (60-90sec)
						if (GetTime() - LastKill < PS.PaybackKillTime) then
							if PS_PaybackSound == true then
								RetributionKill = false
								for i = 1, table.getn(PVPSound_RetributionQueue) do
									if string.upper(PVPSound_RetributionQueue[i].dir) == string.upper(KilledWho) then
										RetributionKill = true
									end
								end
							end
							if RetributionKill == true then
								if PS_PaybackSound == true then
									PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Retribution.mp3")
									-- Sound Effects
									if PS_SoundEffect == true then
										PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Retribution.mp3")
									end
									-- Retribution SCT
									if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
										PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Retribution.mp3", Retribution, PSSctFrame)
									end
								end
							end
						end
					end
				end
				-- Reseting MultiKilling
				if PS_MultiKillSound == true then
					if not LastKill or (GetTime() - LastKill > MultiKillTime) then
						MultiKills = 1
					end
				end
				LastKill = GetTime()
			 -- PaybackKilling
			elseif (eventType == "SWING_DAMAGE" and FromEnemy and destGUID == UnitGUID("player") and tonumber(swingOverkill) ~= nil and tonumber(swingOverkill) ~= -1) or ((eventType == "RANGE_DAMAGE" or eventType == "SPELL_DAMAGE" or eventType == "SPELL_PERIODIC_DAMAGE") and FromEnemy and destGUID == UnitGUID("player") and tonumber(spellOverkill) ~= nil and tonumber(spellOverkill) ~= -1) then
				-- If the killer is not nil
				if sourceName ~= nil then
					-- If the killer is not the player
					if sourceName ~= UnitName("player") then
						KilledMe = sourceName
						if FromEnemyPlayer then
							KilledBy = tostring(sourceName)
						elseif FromEnemyNPC then
							KilledBy = tostring(sourceName.."!")
						else
							KilledBy = tostring(sourceName)
						end
						if PS_PaybackSound == true then
							PVPSound_AddToRetributionQueue(KilledMe)
							PaybackKill = false
							for i = 1, table.getn(PVPSound_PaybackQueue) do
								if string.upper(PVPSound_PaybackQueue[i].dir) == string.upper(KilledMe) then
									PaybackKill = true
								end
							end
						end
						if PaybackKill == true then
							if PS_PaybackSound == true then
								PVPSound_AddKillToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Payback.mp3")
								-- Sound Effects
								if PS_SoundEffect == true then
									PVPSound_AddEffectToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Payback.mp3")
								end
								-- Payback SCT Swing
								if PS_KillSct == true or PS_MultiKillSct == true or PS_PaybackSct == true then
									PVPSound_AddSctToQueue(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Spree\\Payback.mp3", Payback, PSSctFrame)
								end
							end
						end
					end
				end
			 -- Environmental Deaths
			elseif eventType == "ENVIRONMENTAL" and destGUID == UnitGUID("player") then
				if sourceName ~= nil or sourceName == nil then
					KilledMe = nil
					KilledBy = nil
				end
			end
			-- Emotes and Fake Emotes
			if Message ~= nil then
				if (eventType == "PARTY_KILL" and sourceGUID == UnitGUID("player") and ToEnemy) or (eventType == "SWING_DAMAGE" and destGUID ~= UnitGUID("player") and FromMyPets and ToEnemy and tonumber(swingOverkill) ~= nil and tonumber(swingOverkill) ~= -1) or ((eventType == "RANGE_DAMAGE" or eventType == "SPELL_DAMAGE" or eventType == "SPELL_PERIODIC_DAMAGE") and destGUID ~= UnitGUID("player") and FromMyPets and ToEnemy and tonumber(spellOverkill) ~= nil and tonumber(spellOverkill) ~= -1) then
					if PS_Emote == true then
						if PS_EmoteMode == true then
							SendChatMessage(Message, "EMOTE")
							-- Data Share out of Emote range
							if PS_DataShare == true then
								if InstanceType == "pvp" then
									if Message == Msg_FirstBloodMale then
										SendAddonMessage("PVPSound", "FirstBloodMale+", "BATTLEGROUND")
									elseif Message == Msg_FirstBloodFemale then
										SendAddonMessage("PVPSound", "FirstBloodFemale+", "BATTLEGROUND")
									elseif Message == Msg_KillingSpree then
										SendAddonMessage("PVPSound", "KillingSpree+", "BATTLEGROUND")
									elseif Message == Msg_Rampage then
										SendAddonMessage("PVPSound", "Rampage+", "BATTLEGROUND")
									elseif Message == Msg_Dominating then
										SendAddonMessage("PVPSound", "Dominating+", "BATTLEGROUND")
									elseif Message == Msg_Unstoppable then
										SendAddonMessage("PVPSound", "Unstoppable+", "BATTLEGROUND")
									elseif Message == Msg_Godlike then
										SendAddonMessage("PVPSound", "Godlike+", "BATTLEGROUND")
									elseif Message == Msg_Massacre then
										SendAddonMessage("PVPSound", "Massacre+", "BATTLEGROUND")
									end
								else
									if Message == Msg_FirstBloodMale then
										SendAddonMessage("PVPSound", "FirstBloodMale+", "RAID")
									elseif Message == Msg_FirstBloodFemale then
										SendAddonMessage("PVPSound", "FirstBloodFemale+", "RAID")
									elseif Message == Msg_KillingSpree then
										SendAddonMessage("PVPSound", "KillingSpree+", "RAID")
									elseif Message == Msg_Rampage then
										SendAddonMessage("PVPSound", "Rampage+", "RAID")
									elseif Message == Msg_Dominating then
										SendAddonMessage("PVPSound", "Dominating+", "RAID")
									elseif Message == Msg_Unstoppable then
										SendAddonMessage("PVPSound", "Unstoppable+", "RAID")
									elseif Message == Msg_Godlike then
										SendAddonMessage("PVPSound", "Godlike+", "RAID")
									elseif Message == Msg_Massacre then
										SendAddonMessage("PVPSound", "Massacre+", "RAID")
									end
								end
							end
						elseif PS_EmoteMode == false then
							print("|cFFFFFF00"..sourceName.." "..Message.."|cFFFFFFFF")
							-- Data Share out of Fake Emote range
							if PS_DataShare == true then
								if InstanceType == "pvp" then
									if Message == Msg_FirstBloodMale then
										SendAddonMessage("PVPSound", "FirstBloodMale+", "BATTLEGROUND")
									elseif Message == Msg_FirstBloodFemale then
										SendAddonMessage("PVPSound", "FirstBloodFemale+", "BATTLEGROUND")
									elseif Message == Msg_KillingSpree then
										SendAddonMessage("PVPSound", "KillingSpree+", "BATTLEGROUND")
									elseif Message == Msg_Rampage then
										SendAddonMessage("PVPSound", "Rampage+", "BATTLEGROUND")
									elseif Message == Msg_Dominating then
										SendAddonMessage("PVPSound", "Dominating+", "BATTLEGROUND")
									elseif Message == Msg_Unstoppable then
										SendAddonMessage("PVPSound", "Unstoppable+", "BATTLEGROUND")
									elseif Message == Msg_Godlike then
										SendAddonMessage("PVPSound", "Godlike+", "BATTLEGROUND")
									elseif Message == Msg_Massacre then
										SendAddonMessage("PVPSound", "Massacre+", "BATTLEGROUND")
									end
								else
									if Message == Msg_FirstBloodMale then
										SendAddonMessage("PVPSound", "FirstBloodMale+", "RAID")
									elseif Message == Msg_FirstBloodFemale then
										SendAddonMessage("PVPSound", "FirstBloodFemale+", "RAID")
									elseif Message == Msg_KillingSpree then
										SendAddonMessage("PVPSound", "KillingSpree+", "RAID")
									elseif Message == Msg_Rampage then
										SendAddonMessage("PVPSound", "Rampage+", "RAID")
									elseif Message == Msg_Dominating then
										SendAddonMessage("PVPSound", "Dominating+", "RAID")
									elseif Message == Msg_Unstoppable then
										SendAddonMessage("PVPSound", "Unstoppable+", "RAID")
									elseif Message == Msg_Godlike then
										SendAddonMessage("PVPSound", "Godlike+", "RAID")
									elseif Message == Msg_Massacre then
										SendAddonMessage("PVPSound", "Massacre+", "RAID")
									end
								end
							end
						end
					else
						-- Data Share with Emote off
						if PS_DataShare == true then
							if InstanceType == "pvp" then
								if Message == Msg_FirstBloodMale then
									SendAddonMessage("PVPSound", "FirstBloodMale+", "BATTLEGROUND")
								elseif Message == Msg_FirstBloodFemale then
									SendAddonMessage("PVPSound", "FirstBloodFemale+", "BATTLEGROUND")
								elseif Message == Msg_KillingSpree then
									SendAddonMessage("PVPSound", "KillingSpree+", "BATTLEGROUND")
								elseif Message == Msg_Rampage then
									SendAddonMessage("PVPSound", "Rampage+", "BATTLEGROUND")
								elseif Message == Msg_Dominating then
									SendAddonMessage("PVPSound", "Dominating+", "BATTLEGROUND")
								elseif Message == Msg_Unstoppable then
									SendAddonMessage("PVPSound", "Unstoppable+", "BATTLEGROUND")
								elseif Message == Msg_Godlike then
									SendAddonMessage("PVPSound", "Godlike+", "BATTLEGROUND")
								elseif Message == Msg_Massacre then
									SendAddonMessage("PVPSound", "Massacre+", "BATTLEGROUND")
								end
							else
								if Message == Msg_FirstBloodMale then
									SendAddonMessage("PVPSound", "FirstBloodMale+", "RAID")
								elseif Message == Msg_FirstBloodFemale then
									SendAddonMessage("PVPSound", "FirstBloodFemale+", "RAID")
								elseif Message == Msg_KillingSpree then
									SendAddonMessage("PVPSound", "KillingSpree+", "RAID")
								elseif Message == Msg_Rampage then
									SendAddonMessage("PVPSound", "Rampage+", "RAID")
								elseif Message == Msg_Dominating then
									SendAddonMessage("PVPSound", "Dominating+", "RAID")
								elseif Message == Msg_Unstoppable then
									SendAddonMessage("PVPSound", "Unstoppable+", "RAID")
								elseif Message == Msg_Godlike then
									SendAddonMessage("PVPSound", "Godlike+", "RAID")
								elseif Message == Msg_Massacre then
									SendAddonMessage("PVPSound", "Massacre+", "RAID")
								end
							end
						end
					end
				end
			end
		end
	end
end

-- Slash Commands
function PVPSound_SlashCommands(arg1)
	if Locale ~= "koKR" and Locale ~= "zhCN" and Locale ~= "zhTW" then
		-- Arg1 is case sensitive
		-- Arg2 is converted to lower case
		local arg2 = string.lower(arg1)
		if arg2 == "" then
			PVPSound_PrintSlashMenu()
		elseif arg2 == "pvp" then
			PS_PVPMode = not PS_PVPMode
			if PS_PVPMode == true then
				print("|cFF50C0FF"..Opt_Mode..": |cFFADFF2F"..Opt_PVP.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_Mode..": |cFFFF4500"..Opt_PVE.."|cFFFFFFFF")
			end
		elseif arg2 == "emote" then
			PS_Emote = not PS_Emote
			if PS_Emote == true then
				print("|cFF50C0FF"..Opt_Emotes..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_Emotes..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif arg2 == "emotemode" or arg2 == "emote mode" then
			PS_EmoteMode = not PS_EmoteMode
			if PS_EmoteMode == true then
				print("|cFF50C0FF"..Opt_EmoteMode..": |cFFADFF2F"..Opt_Emote.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_EmoteMode..": |cFFFF4500"..Opt_ChatMessage.."|cFFFFFFFF")
			end
		elseif arg2 == "dm" or arg2 == "deathmessage" or arg2 == "death message" or arg2 == "deathmessages" or arg2 == "death messages" then
			PS_DeathMessage = not PS_DeathMessage
			if PS_DeathMessage == true then
				print("|cFF50C0FF"..Opt_DeathMsg..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_DeathMsg..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif arg2 == "ks" or arg2 == "killsound" or arg2 == "kill sound" or arg2 == "killsounds" or arg2 == "kill sounds" then
			PS_KillSound = not PS_KillSound
			if PS_KillSound == true then
				print("|cFF50C0FF"..Opt_KillSound..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_KillSound..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif arg2 == "mks" or arg2 == "multikillsound" or arg2 == "multikill sound" or arg2 == "multi kill sound" or arg2 == "multi killsound" or arg2 == "multikillsounds" or arg2 == "multikill sounds" or arg2 == "multi kill sounds" or arg2 == "multi killsounds" then
			PS_MultiKillSound = not PS_MultiKillSound
			if PS_MultiKillSound == true then
				print("|cFF50C0FF"..Opt_MultiKillSound..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_MultiKillSound..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif arg2 == "ps" or arg2 == "paysound" or arg2 == "pay sound" or arg2 == "paybacksound" or arg2 == "payback sound" or arg2 == "paysounds" or arg2 == "pay sounds" or arg2 == "paybacksounds" or arg2 == "payback sounds" then
			PS_PaybackSound = not PS_PaybackSound
			if PS_PaybackSound == true then
				print("|cFF50C0FF"..Opt_PaySound..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_PaySound..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif arg2 == "bs" or arg2 == "bgsound" or arg2 == "bg sound" or arg2 == "battlegroundsound" or arg2 == "battleground sound" or arg2 == "bgsounds" or arg2 == "bg sounds" or arg2 == "battlegroundsounds" or arg2 == "battleground sounds" then
			PS_BattlegroundSound = not PS_BattlegroundSound
			if PS_BattlegroundSound == true then
				print("|cFF50C0FF"..Opt_BgSound..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_BgSound..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif arg2 == "se" or arg2 == "soundeffect" or arg2 == "sound effect" or arg2 == "effectsound" or arg2 == "effect sound" then
			PS_SoundEffect = not PS_SoundEffect
			if PS_SoundEffect == true then
				print("|cFF50C0FF"..Opt_SoundEffect..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_SoundEffect..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif arg2 == "kse" or arg2 == "killsoundengine" or arg2 == "killsound engine" or arg2 == "kill sound engine" or arg2 == "kill soundengine" then
			PS_KillSoundEngine = not PS_KillSoundEngine
			if PS_KillSoundEngine == true then
				print("|cFF50C0FF"..Opt_KillSoundEngine..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_KillSoundEngine..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif arg2 == "bse" or arg2 == "bgsoundengine" or arg2 == "bgsound engine" or arg2 == "bg sound engine" or arg2 == "bg soundengine" or arg2 == "battleground soundengine" or arg2 == "battlegroundsoundengine" or arg2 == "battleground sound engine" or arg2 == "battlegroundsound engine" then
			PS_BattlegroundSoundEngine = not PS_BattlegroundSoundEngine
			if PS_BattlegroundSoundEngine == true then
				print("|cFF50C0FF"..Opt_BgSoundEngine..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_BgSoundEngine..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif arg2 == "ds" or arg2 == "datashare" or arg2 == "data share" or arg2 == "datasharing" or arg2 == "data sharing" then
			PS_DataShare = not PS_DataShare
			if PS_DataShare == true then
				print("|cFF50C0FF"..Opt_DataShare..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_DataShare..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif arg2 == "ksct" or arg2 == "killsct" or arg2 == "kill sct" then
			PS_KillSct = not PS_KillSct
			if PS_KillSct == true then
				print("|cFF50C0FF"..Opt_KillSct..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_KillSct..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif arg2 == "mksct" or arg2 == "multikillsct" or arg2 == "multikill sct" or arg2 == "multi kill sct" or arg2 == "multi killsct" then
			PS_MultiKillSct = not PS_MultiKillSct
			if PS_MultiKillSct == true then
				print("|cFF50C0FF"..Opt_MultiKillSct..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_MultiKillSct..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif arg2 == "psct" or arg2 == "paybacksct" or arg2 == "payback sct" then
			PS_PaybackSct = not PS_PaybackSct
			if PS_PaybackSct == true then
				print("|cFF50C0FF"..Opt_PaybackSct..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_PaybackSct..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif arg2 == "scte" or arg2 == "sctengine" or arg2 == "sct engine" then
			PS_SctEngine = not PS_SctEngine
			if PS_SctEngine == true then
				print("|cFF50C0FF"..Opt_SctEngine..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_SctEngine..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif string.find(arg1, "frame(.+)") then
			if string.find(arg1, "frame ") then
				PSSctFrame = tostring(string.match(arg1, "frame (.+)"))
			else
				PSSctFrame = tostring(string.match(arg1, "frame(.+)"))
			end
			if PSSctFrame ~= nil then
				print("|cFF50C0FF"..Opt_Frame..": |cFFADFF2F["..PSSctFrame.."]|cFFFFFFFF")
			end
		elseif arg2 == "hsn" or arg2 == "hideservername" or arg2 == "hideserver name" or arg2 == "hide server name" or arg2 == "hide servername" or arg2 == "hideservernames" or arg2 == "hideserver names" or arg2 == "hide server names" or arg2 == "hide servernames" or arg2 == "hs" or arg2 == "hide server" or arg2 == "hideserver" then
			PS_HideServerName = not PS_HideServerName
			if PS_HideServerName == true then
				print("|cFF50C0FF"..Opt_HideServerName..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
			else
				print("|cFF50C0FF"..Opt_HideServerName..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
			end
		elseif arg2 == "channelmaster" or arg2 == "channel master" then
			PS_Channel = "Master"
			if PS_Channel == "Master" then
				print("|cFF50C0FF"..Opt_Channel..": |cFFADFF2F"..Opt_Master.."|cFFFFFFFF")
			end
		elseif arg2 == "channelsound" or arg2 == "channel sound" then
			PS_Channel = "Sound"
			if PS_Channel == "Sound" then
				print("|cFF50C0FF"..Opt_Channel..": |cFFFF4500"..Opt_Sound.."|cFFFFFFFF")
			end
		elseif arg2 == "channelmusic" or arg2 == "channel music" then
			PS_Channel = "Music"
			if PS_Channel == "Music" then
				print("|cFF50C0FF"..Opt_Channel..": |cFFFF4500"..Opt_Music.."|cFFFFFFFF")
			end
		elseif arg2 == "channelambience" or arg2 == "channel ambience" then
			PS_Channel = "Ambience"
			if PS_Channel == "Ambience" then
				print("|cFF50C0FF"..Opt_Channel..": |cFFFF4500"..Opt_Ambience.."|cFFFFFFFF")
			end
		elseif arg2 == "test" then
			print("|cFF50C0FF"..Opt_Test.."...")
			PlaySoundFile(PS.SoundPackDirectory.."\\"..PS_SoundPackLanguage.."\\Test\\Pancake.mp3", PS_Channel)
			PVPSound_TriggerSct(Pancake, PSSctFrame)
		elseif arg2 == "reset" then
			PVPSound_ClearSoundQueue()
			PVPSound_ClearKillSoundQueue()
			PVPSound_ClearSoundEffectQueue()
			PVPSound_ClearPaybackQueue()
			PVPSound_ClearRetributionQueue()
			PVPSound_ClearSctQueue()
			TimerReset = true
			KillCounter = 0
			print("|cFF50C0FF"..Opt_Reset..".|cFFFFFFFF")
		else
			PVPSound_PrintSlashHelp()
		end
	end
end

function PVPSound_PrintSlashHelp()
	if Locale ~= "koKR" and Locale ~= "zhCN" and Locale ~= "zhTW" then
		print("|cFFFFA500PVPSound "..GetAddOnMetadata("PVPSound", "Version").." "..Opt_CmdList.."|cFFFFFFFF")
		print("|cFF50C0FF/ps - |cFFFFFFA0"..Opt_HelpStatus.."|cFFFFFFFF")
		print("|cFF50C0FF/ps pvp - |cFFFFFFA0"..Opt_HelpMode.."|cFFFFFFFF")
		print("|cFF50C0FF/ps emote - |cFFFFFFA0"..Opt_HelpEmote.."|cFFFFFFFF")
		print("|cFF50C0FF/ps emotemode - |cFFFFFFA0"..Opt_HelpEmoteMode.."|cFFFFFFFF")
		print("|cFF50C0FF/ps deathmessage - |cFFFFFFA0"..Opt_HelpDeathMessage.."|cFFFFFFFF")
		print("|cFF50C0FF/ps killsound - |cFFFFFFA0"..Opt_HelpKillSound.."|cFFFFFFFF")
		print("|cFF50C0FF/ps multikillsound - |cFFFFFFA0"..Opt_HelpMultiKillSound.."|cFFFFFFFF")
		print("|cFF50C0FF/ps paysound - |cFFFFFFA0"..Opt_HelpPaybackSound.."|cFFFFFFFF")
		print("|cFF50C0FF/ps bgsound - |cFFFFFFA0"..Opt_HelpBattlegroundSound.."|cFFFFFFFF")
		print("|cFF50C0FF/ps soundeffect - |cFFFFFFA0"..Opt_HelpSoundEffect.."|cFFFFFFFF")
		print("|cFF50C0FF/ps killsoundengine - |cFFFFFFA0"..Opt_HelpKillSoundEngine.."|cFFFFFFFF")
		print("|cFF50C0FF/ps bgsoundengine - |cFFFFFFA0"..Opt_HelpBattlegroundSoundEngine.."|cFFFFFFFF")
		print("|cFF50C0FF/ps datashare - |cFFFFFFA0"..Opt_HelpDataShare.."|cFFFFFFFF")
		print("|cFF50C0FF/ps killsct - |cFFFFFFA0"..Opt_HelpKillSct.."|cFFFFFFFF")
		print("|cFF50C0FF/ps multikillsct - |cFFFFFFA0"..Opt_HelpMultiKillSct.."|cFFFFFFFF")
		print("|cFF50C0FF/ps paybacksct - |cFFFFFFA0"..Opt_HelpPaybackSct.."|cFFFFFFFF")
		print("|cFF50C0FF/ps sctengine - |cFFFFFFA0"..Opt_HelpSctEngine.."|cFFFFFFFF")
		print("|cFF50C0FF/ps frame'framename' - |cFFFFFFA0"..Opt_HelpFrame.."|cFFFFFFFF")
		print("|cFF50C0FF/ps hideservername - |cFFFFFFA0"..Opt_HelpHideServerName.."|cFFFFFFFF")
		print("|cFF50C0FF/ps channel'channelname' - |cFFFFFFA0"..Opt_HelpChannel.."|cFFFFFFFF")
		print("|cFF50C0FF/ps test - |cFFFFFFA0"..Opt_HelpTest.."|cFFFFFFFF")
		print("|cFF50C0FF/ps reset - |cFFFFFFA0"..Opt_HelpReset.."|cFFFFFFFF")
		print("|cFF50C0FF/ps help - |cFFFFFFA0"..Opt_HelpCmdList.."|cFFFFFFFF")
	end
end

function PVPSound_PrintSlashMenu()
	if Locale ~= "koKR" and Locale ~= "zhCN" and Locale ~= "zhTW" then
		print("|cFFFFA500PVPSound "..GetAddOnMetadata("PVPSound", "Version").." "..Opt_HelpInput.."|cFFFFFFFF")
		print("|cFF50C0FF"..Opt_Kills..": |cFFADFF2F"..KillCounter.."|cFFFFFFFF")
		if PS_PVPMode == true then
			print("|cFF50C0FF"..Opt_Mode..": |cFFADFF2F"..Opt_PVP.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_Mode..": |cFFFF4500"..Opt_PVE.."|cFFFFFFFF")
		end
		if PS_Emote == true then
			print("|cFF50C0FF"..Opt_Emotes..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_Emotes..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PS_EmoteMode == true then
			print("|cFF50C0FF"..Opt_EmoteMode..": |cFFADFF2F"..Opt_Emote.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_EmoteMode..": |cFFFF4500"..Opt_ChatMessage.."|cFFFFFFFF")
		end
		if PS_DeathMessage == true then
			print("|cFF50C0FF"..Opt_DeathMsg..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_DeathMsg..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PS_KillSound == true then
			print("|cFF50C0FF"..Opt_KillSound..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_KillSound..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PS_MultiKillSound == true then
			print("|cFF50C0FF"..Opt_MultiKillSound..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_MultiKillSound..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PS_PaybackSound == true then
			print("|cFF50C0FF"..Opt_PaySound..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_PaySound..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PS_BattlegroundSound == true then
			print("|cFF50C0FF"..Opt_BgSound..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_BgSound..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PS_SoundEffect == true then
			print("|cFF50C0FF"..Opt_SoundEffect..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_SoundEffect..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PS_KillSoundEngine == true then
			print("|cFF50C0FF"..Opt_KillSoundEngine..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_KillSoundEngine..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PS_BattlegroundSoundEngine == true then
			print("|cFF50C0FF"..Opt_BgSoundEngine..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_BgSoundEngine..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PS_DataShare == true then
			print("|cFF50C0FF"..Opt_DataShare..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_DataShare..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PS_KillSct == true then
			print("|cFF50C0FF"..Opt_KillSct..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_KillSct..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PS_MultiKillSct == true then
			print("|cFF50C0FF"..Opt_MultiKillSct..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_MultiKillSct..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PS_PaybackSct == true then
			print("|cFF50C0FF"..Opt_PaybackSct..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_PaybackSct..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PS_SctEngine == true then
			print("|cFF50C0FF"..Opt_SctEngine..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_SctEngine..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PSSctFrame ~= nil then
			print("|cFF50C0FF"..Opt_Frame..": |cFFADFF2F["..PSSctFrame.."]|cFFFFFFFF")
		end	
		if PS_HideServerName == true then
			print("|cFF50C0FF"..Opt_HideServerName..": |cFFADFF2F"..Opt_Enable.."|cFFFFFFFF")
		else
			print("|cFF50C0FF"..Opt_HideServerName..": |cFFFF4500"..Opt_Disable.."|cFFFFFFFF")
		end
		if PS_Channel == "Master" then
			print("|cFF50C0FF"..Opt_Channel..": |cFFADFF2F"..Opt_Master.."|cFFFFFFFF")
		elseif PS_Channel == "Sound" then
			print("|cFF50C0FF"..Opt_Channel..": |cFFFF4500"..Opt_Sound.."|cFFFFFFFF")
		elseif PS_Channel == "Music" then
			print("|cFF50C0FF"..Opt_Channel..": |cFFFF4500"..Opt_Music.."|cFFFFFFFF")
		elseif PS_Channel == "Ambience" then
			print("|cFF50C0FF"..Opt_Channel..": |cFFFF4500"..Opt_Ambience.."|cFFFFFFFF")
		end
	end
end