﻿BINDING_HEADER_OVERSIMPLIFIED = "!Over|cff5CB3FFSimplified|r";
BINDING_NAME_COMBATLOGON = "Enable CombatLog keybind";
BINDING_NAME_COMBATLOGOFF = "Disable CombatLog keybind";
BINDING_NAME_DUALSPEC = "Dual Spec keybind";
BINDING_NAME_DUNGEONTELE = "Dungeon Teleport keybind";
BINDING_NAME_DUNGEONRESET = "Dungeon Reset keybind";
BINDING_NAME_GMTICKET = "GM Ticket keybind";
BINDING_NAME_GROUPLEAD = "Group Lead keybind";
BINDING_NAME_GROUPKICK = "Group Kick keybind";
BINDING_NAME_LEAVEBATTLE = "Leave Battlefield keybind";
BINDING_NAME_LEAVEGROUP = "Leave Group keybind";
BINDING_NAME_NAMEPLATEOVER = "Nameplate Overlap keybind";
BINDING_NAME_READYCHECK	= "Ready Check keybind";
BINDING_NAME_RELOADUI = "ReloadUI keybind";
BINDING_NAME_SHOWCLOAK = "Show Cloak keybind";
BINDING_NAME_SHOWHELM = "Show Helm keybind";

local Addon = "OverSimplified"
local function Meta(vaL)
	local text = GetAddOnMetadata(Addon, vaL)
	return text
end

OStext = Meta("Title")..": "

local info = {};
info.help = function() 
	print(OStext.."Current List of commands:")
	DEFAULT_CHAT_FRAME:AddMessage("-- Combat Log - '/cl 'on' or 'off''.")
	DEFAULT_CHAT_FRAME:AddMessage("-- Dual Spec - '/ds'.")
	DEFAULT_CHAT_FRAME:AddMessage("-- Dungeon Teleport - '/dt' or '/dungeontele'.")
	DEFAULT_CHAT_FRAME:AddMessage("-- GM Ticket - '/gm'.")
	DEFAULT_CHAT_FRAME:AddMessage("-- Group Lead - '/gl' or '/grouplead'.")
	DEFAULT_CHAT_FRAME:AddMessage("-- Group Kick - '/gk','/groupkick','/vk', or '/votekick'.")
	DEFAULT_CHAT_FRAME:AddMessage("-- Leave Battlefield - '/lbg'.")
	DEFAULT_CHAT_FRAME:AddMessage("-- Leave Group - '/lg'.")
	DEFAULT_CHAT_FRAME:AddMessage("-- Nameplate Overlap - '/ol' or '/overlap'.")
	DEFAULT_CHAT_FRAME:AddMessage("-- Raid Info - 'ri' or '/raidinfo'.")
	DEFAULT_CHAT_FRAME:AddMessage("-- Ready Check - 'rc' or '/readycheck'.")
	DEFAULT_CHAT_FRAME:AddMessage("-- Reload UI - '/rl' or '/reload'.")
	DEFAULT_CHAT_FRAME:AddMessage("-- Show Cloak - '/sc' or '/showcloak'.")
	DEFAULT_CHAT_FRAME:AddMessage("-- Show Helm - '/sh' or '/showhelm'.")
end
info.about = function() 
	DEFAULT_CHAT_FRAME:AddMessage(Meta("Title").." v"..Meta("Version").." - Created by: "..Meta("Author")..". Email "..Meta("X-Email").." for suggestions, comments, or help.")
end

function osHelp(arg)
	if type(info[arg]) == 'function' then 
		info[arg]()
	else 
		print(OStext.."Available commands are /os 'help' or 'about'.")
	end
end

SLASH_OSHELP1 = "/os";
SlashCmdList["OSHELP"] = osHelp
