local OSDS1 = GetSpellInfo(63645)
local OSDS2 = GetSpellInfo(63644)

OSDS = CreateFrame("Frame");
OSDS:RegisterEvent("UNIT_SPELLCAST_START");
OSDS:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED");
OSDS:RegisterEvent("PLAYER_ENTERING_WORLD");
OSDS:RegisterEvent("PLAYER_LEAVING_WORLD");

OSDS.filter = function(self, event, msg, ...)
	if strfind(msg, string.gsub(ERR_LEARN_ABILITY_S:gsub('%.', '%.'), '%%s', '(.*)')) then
		return true
	elseif strfind(msg, string.gsub(ERR_LEARN_SPELL_S:gsub('%.', '%.'), '%%s', '(.*)')) then
		return true
	elseif strfind(msg, string.gsub(ERR_SPELL_UNLEARNED_S:gsub('%.', '%.'), '%%s', '(.*)')) then
		return true
	end
	return false, msg, ...
end

OSDS:SetScript("OnEvent", function( self, event, ...)
	local unit, spellName = ...
	local dispyet = false
	if(event == "UNIT_SPELLCAST_START") then
		if unit == "player" and (spellName == OSDS1 or spellName == OSDS2) then
			ChatFrame_AddMessageEventFilter("CHAT_MSG_SYSTEM", self.filter)
		end
	elseif(event == "UNIT_SPELLCAST_INTERRUPTED") then
		if unit == "player" and (spellName == OSDS1 or spellName == OSDS2) then
			ChatFrame_RemoveMessageEventFilter("CHAT_MSG_SYSTEM", self.filter)
		end
	elseif event == "PLAYER_ENTERING_WORLD" then
        self:RegisterEvent('ACTIVE_TALENT_GROUP_CHANGED')
    elseif event == "PLAYER_LEAVING_WORLD" then
        self:UnregisterEvent('ACTIVE_TALENT_GROUP_CHANGED')
    elseif event == "ACTIVE_TALENT_GROUP_CHANGED" then
		if dispyet == false then
			dispyet = true
		end
		ChatFrame_RemoveMessageEventFilter("CHAT_MSG_SYSTEM", self.filter)
	end
end);

function osDS()
	local active = GetActiveTalentGroup()
	if active == 2 then
		SetActiveTalentGroup(1);
	elseif active == 1 then
		SetActiveTalentGroup(2);
	else
	end
end

SLASH_DS1 = "/ds";
SLASH_DS2 = "/dualspec";
SlashCmdList["DS"] = osDS